/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.composite;

import com.facebook.battery.metrics.core.SystemMetrics;
import java.util.HashMap;
import java.util.Map;

public class CompositeMetrics
extends SystemMetrics<CompositeMetrics> {
    private static final long serialVersionUID = 0L;
    private final Map<Class<? extends SystemMetrics>, SystemMetrics> mMetricsMap = new HashMap<Class<? extends SystemMetrics>, SystemMetrics>();

    @Override
    public CompositeMetrics diff(CompositeMetrics b, CompositeMetrics result) {
        for (Class<? extends SystemMetrics> c : this.mMetricsMap.keySet()) {
            this.getMetric(c).diff(b.getMetric(c), result.getMetric(c));
        }
        return result;
    }

    @Override
    public CompositeMetrics sum(CompositeMetrics b, CompositeMetrics result) {
        for (Class<? extends SystemMetrics> c : this.mMetricsMap.keySet()) {
            this.getMetric(c).sum(b.getMetric(c), result.getMetric(c));
        }
        return result;
    }

    @Override
    public CompositeMetrics set(CompositeMetrics b) {
        for (Class<? extends SystemMetrics> c : this.mMetricsMap.keySet()) {
            this.getMetric(c).set(b.getMetric(c));
        }
        return this;
    }

    public <T extends SystemMetrics<T>> CompositeMetrics putMetric(Class<T> metricsClass, T metric) {
        this.mMetricsMap.put(metricsClass, metric);
        return this;
    }

    public <T extends SystemMetrics<T>> T getMetric(Class<T> metricsClass) {
        return (T)((SystemMetrics)metricsClass.cast(this.mMetricsMap.get(metricsClass)));
    }

    public Map<Class<? extends SystemMetrics>, SystemMetrics> getMetrics() {
        return this.mMetricsMap;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Composite Metrics:\n");
        for (Class<? extends SystemMetrics> c : this.mMetricsMap.keySet()) {
            SystemMetrics m = this.getMetric(c);
            b.append(m.toString());
            b.append("\n");
        }
        return b.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeMetrics that = (CompositeMetrics)o;
        return this.mMetricsMap.equals(that.mMetricsMap);
    }

    public int hashCode() {
        return this.mMetricsMap.hashCode();
    }
}

