/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.composite;

import android.support.v4.util.SimpleArrayMap;
import com.facebook.battery.metrics.composite.CompositeMetrics;
import com.facebook.battery.metrics.core.SystemMetrics;
import com.facebook.battery.metrics.core.SystemMetricsCollector;
import com.facebook.infer.annotation.ThreadSafe;

@ThreadSafe
public class CompositeMetricsCollector
extends SystemMetricsCollector<CompositeMetrics> {
    private final SimpleArrayMap<Class<? extends SystemMetrics>, SystemMetricsCollector<?>> mMetricsCollectorMap = new SimpleArrayMap();

    protected CompositeMetricsCollector(Builder builder) {
        this.mMetricsCollectorMap.putAll(builder.mMetricsCollectorMap);
    }

    public <S extends SystemMetrics<S>, T extends SystemMetricsCollector<S>> T getMetricsCollector(Class<S> metricsClass) {
        return (T)((SystemMetricsCollector)this.mMetricsCollectorMap.get(metricsClass));
    }

    @Override
    @ThreadSafe(enableChecks=false)
    public boolean getSnapshot(CompositeMetrics snapshot) {
        boolean result = true;
        for (int i = 0; i < this.mMetricsCollectorMap.size(); ++i) {
            Class metricsClass = (Class)this.mMetricsCollectorMap.keyAt(i);
            SystemMetricsCollector collector = (SystemMetricsCollector)this.mMetricsCollectorMap.get((Object)metricsClass);
            Object metric = snapshot.getMetric(metricsClass);
            result &= collector.getSnapshot(metric);
        }
        return result;
    }

    @Override
    public CompositeMetrics createMetrics() {
        CompositeMetrics metrics = new CompositeMetrics();
        int size = this.mMetricsCollectorMap.size();
        for (int i = 0; i < size; ++i) {
            Class metricsClass = (Class)this.mMetricsCollectorMap.keyAt(i);
            metrics.putMetric(metricsClass, ((SystemMetricsCollector)this.mMetricsCollectorMap.valueAt(i)).createMetrics());
        }
        return metrics;
    }

    public static class Builder {
        private final SimpleArrayMap<Class<? extends SystemMetrics>, SystemMetricsCollector<?>> mMetricsCollectorMap = new SimpleArrayMap();

        public <T extends SystemMetrics<T>> Builder addMetricsCollector(Class<T> metricsClass, SystemMetricsCollector<T> collector) {
            this.mMetricsCollectorMap.put(metricsClass, collector);
            return this;
        }

        public CompositeMetricsCollector build() {
            return new CompositeMetricsCollector(this);
        }
    }
}

