/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.core;

import android.support.annotation.Nullable;
import com.facebook.battery.metrics.core.SystemMetrics;
import com.facebook.battery.metrics.core.SystemMetricsCollector;

public class StatefulSystemMetricsCollector<R extends SystemMetrics<R>, S extends SystemMetricsCollector<R>> {
    private final S mCollector;
    private final R mDiff;
    private R mCurr;
    private R mPrev;
    private boolean mIsValid = true;

    public StatefulSystemMetricsCollector(S collector) {
        this(collector, ((SystemMetricsCollector)collector).createMetrics(), ((SystemMetricsCollector)collector).createMetrics(), ((SystemMetricsCollector)collector).createMetrics());
    }

    public StatefulSystemMetricsCollector(S collector, R curr, R prev, R diff) {
        this.mCollector = collector;
        this.mCurr = curr;
        this.mPrev = prev;
        this.mDiff = diff;
        this.mIsValid &= ((SystemMetricsCollector)this.mCollector).getSnapshot(this.mPrev);
    }

    public S getCollector() {
        return this.mCollector;
    }

    @Nullable
    public R getLatestDiffAndReset() {
        if (this.getLatestDiff() == null) {
            return null;
        }
        R temp = this.mPrev;
        this.mPrev = this.mCurr;
        this.mCurr = temp;
        return this.mDiff;
    }

    @Nullable
    public R getLatestDiff() {
        this.mIsValid &= ((SystemMetricsCollector)this.mCollector).getSnapshot(this.mCurr);
        if (!this.mIsValid) {
            return null;
        }
        ((SystemMetrics)this.mCurr).diff(this.mPrev, this.mDiff);
        return this.mDiff;
    }
}

