/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.cpu;

import android.support.annotation.VisibleForTesting;
import android.util.SparseIntArray;
import com.facebook.battery.metrics.core.SystemMetricsCollector;
import com.facebook.battery.metrics.cpu.CpuFrequencyMetrics;
import com.facebook.battery.metrics.cpu.CpuMetricsCollector;
import com.facebook.battery.metrics.cpu.ProcFileReader;
import com.facebook.battery.metrics.cpu.Sysconf;
import com.facebook.infer.annotation.ThreadSafe;
import java.io.File;
import java.io.FilenameFilter;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

@ThreadSafe
public class CpuFrequencyMetricsCollector
extends SystemMetricsCollector<CpuFrequencyMetrics> {
    private static final String CPU_DATA_PATH = "/sys/devices/system/cpu/";
    private static int sCoresForTest = -1;
    @Nullable
    @GuardedBy(value="this")
    private ProcFileReader[] mFiles;

    @Override
    @ThreadSafe(enableChecks=false)
    public boolean getSnapshot(CpuFrequencyMetrics snapshot) {
        boolean hasAnyValid = false;
        int cores = CpuFrequencyMetricsCollector.getTotalCores();
        for (int i = 0; i < cores; ++i) {
            hasAnyValid |= CpuFrequencyMetricsCollector.readCoreStats(snapshot.timeInStateS[i], this.getReader(i));
        }
        return hasAnyValid;
    }

    @VisibleForTesting
    protected String getPath(int core) {
        return "/sys/devices/system/cpu/cpu" + core + "/cpufreq/stats/time_in_state";
    }

    private synchronized ProcFileReader getReader(int core) {
        if (this.mFiles == null) {
            this.mFiles = new ProcFileReader[CpuFrequencyMetricsCollector.getTotalCores()];
        }
        if (this.mFiles[core] == null) {
            this.mFiles[core] = new ProcFileReader(this.getPath(core)).start();
        } else {
            this.mFiles[core].reset();
        }
        return this.mFiles[core];
    }

    private static synchronized boolean readCoreStats(SparseIntArray array, ProcFileReader reader) {
        array.clear();
        if (!reader.isValid()) {
            return false;
        }
        try {
            while (reader.hasNext()) {
                long frequency = reader.readNumber();
                reader.skipSpaces();
                long timeInState = reader.readNumber() / CpuMetricsCollector.getClockTicksPerSecond();
                reader.skipLines();
                array.put((int)frequency, (int)timeInState);
            }
        }
        catch (ProcFileReader.ParseException pe) {
            return false;
        }
        return true;
    }

    @Override
    public CpuFrequencyMetrics createMetrics() {
        return new CpuFrequencyMetrics();
    }

    public static int getTotalCores() {
        return Initializer.CORES;
    }

    @VisibleForTesting
    public static void overrideCores() {
        sCoresForTest = 4;
        if (CpuFrequencyMetricsCollector.getTotalCores() != sCoresForTest) {
            throw new RuntimeException("Unable to override cores! Has getTotalCores() already been called?");
        }
    }

    private static class Initializer {
        public static final int CORES;

        private Initializer() {
        }

        private static int getProcessorCountFromProc() {
            File cpuData = new File(CpuFrequencyMetricsCollector.CPU_DATA_PATH);
            if (!cpuData.exists() || !cpuData.isDirectory()) {
                return 0;
            }
            File[] cpuFiles = cpuData.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches("cpu\\d+");
                }
            });
            return cpuFiles.length;
        }

        static {
            int configuredProcessors;
            if (sCoresForTest > 0) {
                configuredProcessors = sCoresForTest;
            } else {
                configuredProcessors = (int)Sysconf.getScNProcessorsConf(-1L);
                if (configuredProcessors < 0) {
                    configuredProcessors = Initializer.getProcessorCountFromProc();
                }
            }
            CORES = configuredProcessors;
        }
    }
}

