/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.cpu;

import android.support.annotation.Nullable;
import com.facebook.battery.metrics.core.SystemMetrics;

public class CpuMetrics
extends SystemMetrics<CpuMetrics> {
    private static final long serialVersionUID = 0L;
    public double userTimeS;
    public double systemTimeS;
    public double childUserTimeS;
    public double childSystemTimeS;

    @Override
    public CpuMetrics set(CpuMetrics metrics) {
        this.userTimeS = metrics.userTimeS;
        this.systemTimeS = metrics.systemTimeS;
        this.childUserTimeS = metrics.childUserTimeS;
        this.childSystemTimeS = metrics.childSystemTimeS;
        return this;
    }

    @Override
    public CpuMetrics sum(@Nullable CpuMetrics b, @Nullable CpuMetrics output) {
        if (output == null) {
            output = new CpuMetrics();
        }
        if (b == null) {
            output.set(this);
        } else {
            output.systemTimeS = this.systemTimeS + b.systemTimeS;
            output.userTimeS = this.userTimeS + b.userTimeS;
            output.childSystemTimeS = this.childSystemTimeS + b.childSystemTimeS;
            output.childUserTimeS = this.childUserTimeS + b.childUserTimeS;
        }
        return output;
    }

    @Override
    public CpuMetrics diff(@Nullable CpuMetrics b, @Nullable CpuMetrics output) {
        if (output == null) {
            output = new CpuMetrics();
        }
        if (b == null) {
            output.set(this);
        } else {
            output.systemTimeS = this.systemTimeS - b.systemTimeS;
            output.userTimeS = this.userTimeS - b.userTimeS;
            output.childSystemTimeS = this.childSystemTimeS - b.childSystemTimeS;
            output.childUserTimeS = this.childUserTimeS - b.childUserTimeS;
        }
        return output;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CpuMetrics that = (CpuMetrics)other;
        return Double.compare(that.systemTimeS, this.systemTimeS) == 0 && Double.compare(that.userTimeS, this.userTimeS) == 0 && Double.compare(that.childSystemTimeS, this.childSystemTimeS) == 0 && Double.compare(that.childUserTimeS, this.childUserTimeS) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.systemTimeS);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.userTimeS);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.childSystemTimeS);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.childUserTimeS);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "CpuMetrics{userTimeS=" + this.userTimeS + ", systemTimeS=" + this.systemTimeS + ", childUserTimeS=" + this.childUserTimeS + ", childSystemTimeS=" + this.childSystemTimeS + '}';
    }
}

