/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.devicebattery;

import android.support.annotation.Nullable;
import com.facebook.battery.metrics.core.SystemMetrics;

public class DeviceBatteryMetrics
extends SystemMetrics<DeviceBatteryMetrics> {
    private static final long serialVersionUID = 0L;
    public float batteryLevelPct;
    public long batteryRealtimeMs;
    public long chargingRealtimeMs;

    @Override
    public DeviceBatteryMetrics set(DeviceBatteryMetrics metrics) {
        this.batteryLevelPct = metrics.batteryLevelPct;
        this.batteryRealtimeMs = metrics.batteryRealtimeMs;
        this.chargingRealtimeMs = metrics.chargingRealtimeMs;
        return this;
    }

    @Override
    public DeviceBatteryMetrics sum(@Nullable DeviceBatteryMetrics b, @Nullable DeviceBatteryMetrics output) {
        if (output == null) {
            output = new DeviceBatteryMetrics();
        }
        if (b == null) {
            output.set(this);
        } else {
            output.batteryLevelPct = this.batteryLevelPct + b.batteryLevelPct;
            output.batteryRealtimeMs = this.batteryRealtimeMs + b.batteryRealtimeMs;
            output.chargingRealtimeMs = this.chargingRealtimeMs + b.chargingRealtimeMs;
        }
        return output;
    }

    @Override
    public DeviceBatteryMetrics diff(@Nullable DeviceBatteryMetrics b, @Nullable DeviceBatteryMetrics output) {
        if (output == null) {
            output = new DeviceBatteryMetrics();
        }
        if (b == null) {
            output.set(this);
        } else {
            output.batteryLevelPct = this.batteryLevelPct - b.batteryLevelPct;
            output.batteryRealtimeMs = this.batteryRealtimeMs - b.batteryRealtimeMs;
            output.chargingRealtimeMs = this.chargingRealtimeMs - b.chargingRealtimeMs;
        }
        return output;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceBatteryMetrics that = (DeviceBatteryMetrics)o;
        if (this.batteryLevelPct != that.batteryLevelPct) {
            return false;
        }
        if (this.batteryRealtimeMs != that.batteryRealtimeMs) {
            return false;
        }
        return this.chargingRealtimeMs == that.chargingRealtimeMs;
    }

    public int hashCode() {
        int result = this.batteryLevelPct != 0.0f ? Float.floatToIntBits(this.batteryLevelPct) : 0;
        result = 31 * result + (int)(this.batteryRealtimeMs ^ this.batteryRealtimeMs >>> 32);
        result = 31 * result + (int)(this.chargingRealtimeMs ^ this.chargingRealtimeMs >>> 32);
        return result;
    }

    public String toString() {
        return "DeviceBatteryMetrics{batteryLevelPct=" + this.batteryLevelPct + ", batteryRealtimeMs=" + this.batteryRealtimeMs + ", chargingRealtimeMs=" + this.chargingRealtimeMs + '}';
    }
}

