/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.network;

import android.support.annotation.Nullable;
import com.facebook.battery.metrics.core.SystemMetrics;

public class NetworkMetrics
extends SystemMetrics<NetworkMetrics> {
    private static final long serialVersionUID = 0L;
    public long mobileBytesTx;
    public long mobileBytesRx;
    public long wifiBytesTx;
    public long wifiBytesRx;

    @Override
    public NetworkMetrics sum(@Nullable NetworkMetrics b, @Nullable NetworkMetrics output) {
        if (output == null) {
            output = new NetworkMetrics();
        }
        if (b == null) {
            output.set(this);
        } else {
            output.mobileBytesTx = this.mobileBytesTx + b.mobileBytesTx;
            output.mobileBytesRx = this.mobileBytesRx + b.mobileBytesRx;
            output.wifiBytesTx = this.wifiBytesTx + b.wifiBytesTx;
            output.wifiBytesRx = this.wifiBytesRx + b.wifiBytesRx;
        }
        return output;
    }

    @Override
    public NetworkMetrics diff(@Nullable NetworkMetrics b, @Nullable NetworkMetrics output) {
        if (output == null) {
            output = new NetworkMetrics();
        }
        if (b == null) {
            output.set(this);
        } else {
            output.mobileBytesTx = this.mobileBytesTx - b.mobileBytesTx;
            output.mobileBytesRx = this.mobileBytesRx - b.mobileBytesRx;
            output.wifiBytesTx = this.wifiBytesTx - b.wifiBytesTx;
            output.wifiBytesRx = this.wifiBytesRx - b.wifiBytesRx;
        }
        return output;
    }

    @Override
    public NetworkMetrics set(NetworkMetrics b) {
        this.mobileBytesRx = b.mobileBytesRx;
        this.mobileBytesTx = b.mobileBytesTx;
        this.wifiBytesRx = b.wifiBytesRx;
        this.wifiBytesTx = b.wifiBytesTx;
        return this;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        NetworkMetrics that = (NetworkMetrics)other;
        return this.mobileBytesTx == that.mobileBytesTx && this.mobileBytesRx == that.mobileBytesRx && this.wifiBytesTx == that.wifiBytesTx && this.wifiBytesRx == that.wifiBytesRx;
    }

    public int hashCode() {
        int result = (int)(this.mobileBytesTx ^ this.mobileBytesTx >>> 32);
        result = 31 * result + (int)(this.mobileBytesRx ^ this.mobileBytesRx >>> 32);
        result = 31 * result + (int)(this.wifiBytesTx ^ this.wifiBytesTx >>> 32);
        result = 31 * result + (int)(this.wifiBytesRx ^ this.wifiBytesRx >>> 32);
        return result;
    }

    public String toString() {
        return "NetworkMetrics{mobileBytesTx=" + this.mobileBytesTx + ", mobileBytesRx=" + this.mobileBytesRx + ", wifiBytesTx=" + this.wifiBytesTx + ", wifiBytesRx=" + this.wifiBytesRx + '}';
    }
}

