/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.network;

import android.content.Context;
import com.facebook.battery.metrics.core.SystemMetricsCollector;
import com.facebook.battery.metrics.network.NetworkBytesCollector;
import com.facebook.battery.metrics.network.NetworkMetrics;
import com.facebook.infer.annotation.ThreadSafe;

@ThreadSafe
public class NetworkMetricsCollector
extends SystemMetricsCollector<NetworkMetrics> {
    static final int RX = 0;
    static final int TX = 1;
    static final int MOBILE = 2;
    static final int WIFI = 0;
    private final NetworkBytesCollector mNetworkBytesCollector;
    private final long[] mBytes = new long[4];

    public NetworkMetricsCollector(Context context) {
        this.mNetworkBytesCollector = NetworkBytesCollector.create(context);
    }

    @Override
    @ThreadSafe(enableChecks=false)
    public synchronized boolean getSnapshot(NetworkMetrics snapshot) {
        if (!this.mNetworkBytesCollector.getTotalBytes(this.mBytes)) {
            return false;
        }
        snapshot.mobileBytesTx = this.mBytes[3];
        snapshot.mobileBytesRx = this.mBytes[2];
        snapshot.wifiBytesTx = this.mBytes[1];
        snapshot.wifiBytesRx = this.mBytes[0];
        return true;
    }

    @Override
    public NetworkMetrics createMetrics() {
        return new NetworkMetrics();
    }
}

