/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.time;

import android.support.annotation.Nullable;
import com.facebook.battery.metrics.core.SystemMetrics;

public class TimeMetrics
extends SystemMetrics<TimeMetrics> {
    private static final long serialVersionUID = 0L;
    public long uptimeMs;
    public long realtimeMs;

    @Override
    public TimeMetrics set(TimeMetrics metrics) {
        this.uptimeMs = metrics.uptimeMs;
        this.realtimeMs = metrics.realtimeMs;
        return this;
    }

    @Override
    public TimeMetrics sum(@Nullable TimeMetrics b, @Nullable TimeMetrics output) {
        if (output == null) {
            output = new TimeMetrics();
        }
        if (b == null) {
            output.set(this);
        } else {
            output.uptimeMs = this.uptimeMs + b.uptimeMs;
            output.realtimeMs = this.realtimeMs + b.realtimeMs;
        }
        return output;
    }

    @Override
    public TimeMetrics diff(@Nullable TimeMetrics b, @Nullable TimeMetrics output) {
        if (output == null) {
            output = new TimeMetrics();
        }
        if (b == null) {
            output.set(this);
        } else {
            output.uptimeMs = this.uptimeMs - b.uptimeMs;
            output.realtimeMs = this.realtimeMs - b.realtimeMs;
        }
        return output;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeMetrics that = (TimeMetrics)o;
        return this.uptimeMs == that.uptimeMs && this.realtimeMs == that.realtimeMs;
    }

    public int hashCode() {
        int result = (int)(this.uptimeMs ^ this.uptimeMs >>> 32);
        result = 31 * result + (int)(this.realtimeMs ^ this.realtimeMs >>> 32);
        return result;
    }

    public String toString() {
        return "TimeMetrics{uptimeMs=" + this.uptimeMs + ", realtimeMs=" + this.realtimeMs + '}';
    }
}

