/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.bluetooth;

import android.app.PendingIntent;
import android.bluetooth.le.ScanCallback;
import android.os.SystemClock;
import android.support.annotation.GuardedBy;
import android.util.SparseArray;
import com.facebook.battery.metrics.bluetooth.BluetoothMetrics;
import com.facebook.battery.metrics.core.SystemMetricsCollector;
import com.facebook.battery.metrics.core.Utilities;
import com.facebook.infer.annotation.ThreadSafe;

@ThreadSafe
public class BluetoothMetricsCollector
extends SystemMetricsCollector<BluetoothMetrics> {
    @GuardedBy(value="this")
    private final SparseArray<Boolean> mIsOpportunistic = new SparseArray();
    @GuardedBy(value="this")
    private final ScanMetrics mNonOpportunisticScan = new ScanMetrics();
    @GuardedBy(value="this")
    private final ScanMetrics mOpportunisticScan = new ScanMetrics();

    @Override
    public synchronized boolean getSnapshot(BluetoothMetrics snapshot) {
        Utilities.checkNotNull(snapshot, "Null value passed to getSnapshot!");
        snapshot.bleScanCount = this.mNonOpportunisticScan.count;
        snapshot.bleOpportunisticScanCount = this.mOpportunisticScan.count;
        snapshot.bleScanDurationMs = this.mNonOpportunisticScan.getTotalDuration();
        snapshot.bleOpportunisticScanDurationMs = this.mOpportunisticScan.getTotalDuration();
        return true;
    }

    @Override
    public BluetoothMetrics createMetrics() {
        return new BluetoothMetrics();
    }

    public void startScan(ScanCallback callback, boolean isOpportunistic) {
        this.startScanImpl(callback.hashCode(), isOpportunistic);
    }

    public void startScan(PendingIntent callback, boolean isOpportunistic) {
        this.startScanImpl(callback.hashCode(), isOpportunistic);
    }

    public void stopScan(ScanCallback callback) {
        this.stopScanImpl(callback.hashCode());
    }

    public void stopScan(PendingIntent callback) {
        this.stopScanImpl(callback.hashCode());
    }

    private ScanMetrics getScanMetrics(boolean isOpportunistic) {
        return isOpportunistic ? this.mOpportunisticScan : this.mNonOpportunisticScan;
    }

    private synchronized void startScanImpl(int scannerId, boolean isOpportunistic) {
        if (this.mIsOpportunistic.get(scannerId) != null) {
            return;
        }
        this.mIsOpportunistic.put(scannerId, (Object)isOpportunistic);
        ScanMetrics scanMetrics = this.getScanMetrics(isOpportunistic);
        if (scanMetrics.numActive == 0) {
            scanMetrics.startTime = SystemClock.uptimeMillis();
        }
        ++scanMetrics.count;
        ++scanMetrics.numActive;
    }

    private synchronized void stopScanImpl(int scannerId) {
        Boolean isOpportunistic = (Boolean)this.mIsOpportunistic.get(scannerId);
        if (isOpportunistic == null) {
            return;
        }
        this.mIsOpportunistic.remove(scannerId);
        ScanMetrics scanMetrics = this.getScanMetrics(isOpportunistic);
        --scanMetrics.numActive;
        if (scanMetrics.numActive == 0) {
            scanMetrics.duration += SystemClock.uptimeMillis() - scanMetrics.startTime;
        }
    }

    private static class ScanMetrics {
        public long startTime;
        public long duration;
        public int count;
        public int numActive;

        private ScanMetrics() {
        }

        public long getTotalDuration() {
            return this.duration + (this.numActive > 0 ? SystemClock.uptimeMillis() - this.startTime : 0L);
        }
    }
}

