/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.camera;

import android.hardware.Camera;
import android.hardware.camera2.CameraDevice;
import android.os.Build;
import android.os.SystemClock;
import android.support.annotation.GuardedBy;
import android.util.SparseArray;
import com.facebook.battery.metrics.camera.CameraMetrics;
import com.facebook.battery.metrics.core.SystemMetricsCollector;
import com.facebook.battery.metrics.core.SystemMetricsLogger;
import com.facebook.battery.metrics.core.Utilities;
import com.facebook.infer.annotation.ThreadSafe;

@ThreadSafe
public class CameraMetricsCollector
extends SystemMetricsCollector<CameraMetrics> {
    private static final String TAG = "CameraMetricsCollector";
    @GuardedBy(value="this")
    private final SparseArray<Long> mCameraOpenTimes = new SparseArray();
    @GuardedBy(value="this")
    private final SparseArray<Long> mCameraPreviewTimes = new SparseArray();
    @GuardedBy(value="this")
    private long mTotalCameraOpenTimeMs;
    @GuardedBy(value="this")
    private long mTotalCameraPreviewTimeMs;
    @GuardedBy(value="this")
    private boolean mIsEnabled = true;

    @Override
    public synchronized boolean getSnapshot(CameraMetrics snapshot) {
        Utilities.checkNotNull(snapshot, "Null value passed to getSnapshot!");
        if (!this.mIsEnabled) {
            return false;
        }
        long timestampMs = SystemClock.uptimeMillis();
        snapshot.cameraOpenTimeMs = this.mTotalCameraOpenTimeMs + CameraMetricsCollector.sumElapsedTime(timestampMs, this.mCameraOpenTimes);
        snapshot.cameraPreviewTimeMs = this.mTotalCameraPreviewTimeMs + CameraMetricsCollector.sumElapsedTime(timestampMs, this.mCameraPreviewTimes);
        return true;
    }

    @Override
    public CameraMetrics createMetrics() {
        return new CameraMetrics();
    }

    public synchronized void disable() {
        this.mIsEnabled = false;
        this.mCameraOpenTimes.clear();
        this.mCameraPreviewTimes.clear();
    }

    public synchronized void recordCameraOpen(Object camera) {
        if (!this.mIsEnabled) {
            return;
        }
        CameraMetricsCollector.validateArgument(camera);
        CameraMetricsCollector.startRecord(System.identityHashCode(camera), this.mCameraOpenTimes);
    }

    public synchronized void recordCameraClose(Object camera) {
        if (!this.mIsEnabled) {
            return;
        }
        CameraMetricsCollector.validateArgument(camera);
        this.mTotalCameraOpenTimeMs += CameraMetricsCollector.stopRecord(System.identityHashCode(camera), this.mCameraOpenTimes);
    }

    public synchronized void recordPreviewStart(Object camera) {
        if (!this.mIsEnabled) {
            return;
        }
        CameraMetricsCollector.validateArgument(camera);
        CameraMetricsCollector.startRecord(System.identityHashCode(camera), this.mCameraPreviewTimes);
    }

    public synchronized void recordPreviewStop(Object camera) {
        if (!this.mIsEnabled) {
            return;
        }
        CameraMetricsCollector.validateArgument(camera);
        this.mTotalCameraPreviewTimeMs += CameraMetricsCollector.stopRecord(System.identityHashCode(camera), this.mCameraPreviewTimes);
    }

    public synchronized void recordCameraError(Object camera) {
        if (!this.mIsEnabled) {
            return;
        }
        CameraMetricsCollector.validateArgument(camera);
        int cameraHash = System.identityHashCode(camera);
        this.mCameraOpenTimes.delete(cameraHash);
        this.mCameraPreviewTimes.delete(cameraHash);
    }

    private static synchronized void startRecord(int hash, SparseArray<Long> container) {
        long startTimeMs = SystemClock.uptimeMillis();
        if (container.get(hash) == null) {
            container.append(hash, (Object)startTimeMs);
        }
    }

    private static synchronized long stopRecord(int hash, SparseArray<Long> container) {
        long stopTimeMs = SystemClock.uptimeMillis();
        long totalTimeMs = 0L;
        Long startTimeMs = (Long)container.get(hash);
        if (startTimeMs != null) {
            totalTimeMs = stopTimeMs - startTimeMs;
            container.remove(hash);
        } else {
            SystemMetricsLogger.wtf(TAG, "Stopped recording details for a camera that hasn't been added yet");
        }
        return totalTimeMs;
    }

    private static void validateArgument(Object camera) {
        if (!(camera instanceof Camera || Build.VERSION.SDK_INT >= 21 && camera instanceof CameraDevice)) {
            throw new IllegalArgumentException("Must pass in a Camera or a CameraDevice");
        }
    }

    private static long sumElapsedTime(long timestamp, SparseArray<Long> container) {
        int size = container.size();
        long sum = 0L;
        for (int index = 0; index < size; ++index) {
            sum += timestamp - (Long)container.valueAt(index);
        }
        return sum;
    }
}

