/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.core;

import android.support.annotation.Nullable;
import android.util.Log;
import com.facebook.infer.annotation.ThreadSafe;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafe
public final class SystemMetricsLogger {
    private static final AtomicReference<Delegate> DELEGATE = new AtomicReference();

    public static void setDelegate(Delegate delegate) {
        DELEGATE.set(delegate);
    }

    public static void wtf(String tag, String message) {
        SystemMetricsLogger.wtf(tag, message, null);
    }

    public static void wtf(String tag, String message, @Nullable Throwable cause) {
        Delegate delegate = DELEGATE.get();
        if (delegate != null) {
            delegate.wtf(tag, message, cause);
        } else {
            Log.e((String)tag, (String)message, (Throwable)cause);
        }
    }

    @ThreadSafe
    public static interface Delegate {
        public void wtf(String var1, String var2, @Nullable Throwable var3);
    }
}

