/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.core;

import android.support.annotation.Nullable;
import android.support.v4.util.SimpleArrayMap;
import android.util.SparseArray;

public abstract class Utilities {
    public static <K, V> boolean simpleArrayMapEquals(SimpleArrayMap<K, V> a, SimpleArrayMap<K, V> b) {
        int bSize;
        if (a == b) {
            return true;
        }
        int aSize = a.size();
        if (aSize != (bSize = b.size())) {
            return false;
        }
        for (int i = 0; i < aSize; ++i) {
            Object aKey = a.keyAt(i);
            Object aValue = a.valueAt(i);
            Object bValue = b.get(aKey);
            if (!(aValue == null ? bValue != null || !b.containsKey(aKey) : !aValue.equals(bValue))) continue;
            return false;
        }
        return true;
    }

    public static void checkNotNull(Object o, String message) {
        if (o == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <V> boolean sparseArrayEquals(@Nullable SparseArray<V> a, @Nullable SparseArray<V> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            int key = a.keyAt(i);
            if (a.get(key).equals(b.get(key))) continue;
            return false;
        }
        return true;
    }
}

