/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.cpu;

import android.support.annotation.Nullable;
import android.util.SparseIntArray;
import com.facebook.battery.metrics.core.SystemMetrics;
import com.facebook.battery.metrics.core.SystemMetricsLogger;
import com.facebook.battery.metrics.cpu.CpuFrequencyMetricsCollector;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public class CpuFrequencyMetrics
extends SystemMetrics<CpuFrequencyMetrics> {
    public final SparseIntArray[] timeInStateS;

    public CpuFrequencyMetrics() {
        int cores = CpuFrequencyMetricsCollector.getTotalCores();
        this.timeInStateS = new SparseIntArray[cores];
        for (int core = 0; core < cores; ++core) {
            this.timeInStateS[core] = new SparseIntArray(0);
        }
    }

    @Override
    public CpuFrequencyMetrics sum(@Nullable CpuFrequencyMetrics b, @Nullable CpuFrequencyMetrics output) {
        if (output == null) {
            output = new CpuFrequencyMetrics();
        }
        if (b == null) {
            output.set(this);
        } else {
            for (int i = 0; i < this.timeInStateS.length; ++i) {
                int frequency;
                int j;
                SparseIntArray aCore = this.timeInStateS[i];
                SparseIntArray bCore = b.timeInStateS[i];
                SparseIntArray outputCore = output.timeInStateS[i];
                for (j = 0; j < aCore.size(); ++j) {
                    frequency = aCore.keyAt(j);
                    outputCore.put(frequency, aCore.valueAt(j) + bCore.get(frequency, 0));
                }
                for (j = 0; j < bCore.size(); ++j) {
                    frequency = bCore.keyAt(j);
                    if (aCore.indexOfKey(frequency) >= 0) continue;
                    outputCore.put(frequency, bCore.valueAt(j));
                }
            }
        }
        return output;
    }

    @Override
    public CpuFrequencyMetrics diff(@Nullable CpuFrequencyMetrics b, @Nullable CpuFrequencyMetrics output) {
        if (output == null) {
            output = new CpuFrequencyMetrics();
        }
        if (b == null) {
            output.set(this);
        } else {
            for (int i = 0; i < this.timeInStateS.length; ++i) {
                SparseIntArray aCore = this.timeInStateS[i];
                SparseIntArray bCore = b.timeInStateS[i];
                SparseIntArray outputCore = output.timeInStateS[i];
                boolean hasCoreReset = false;
                int size = aCore.size();
                for (int j = 0; j < size && !hasCoreReset; ++j) {
                    int frequency = aCore.keyAt(j);
                    int difference = aCore.valueAt(j) - bCore.get(frequency, 0);
                    if (difference < 0) {
                        hasCoreReset = true;
                        break;
                    }
                    outputCore.put(frequency, difference);
                }
                if (!hasCoreReset) continue;
                CpuFrequencyMetrics.copyArrayInto(aCore, outputCore);
            }
        }
        return output;
    }

    @Override
    public CpuFrequencyMetrics set(CpuFrequencyMetrics b) {
        for (int i = 0; i < this.timeInStateS.length; ++i) {
            CpuFrequencyMetrics.copyArrayInto(b.timeInStateS[i], this.timeInStateS[i]);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CpuFrequencyMetrics that = (CpuFrequencyMetrics)o;
        if (this.timeInStateS.length != that.timeInStateS.length) {
            return false;
        }
        int size = this.timeInStateS.length;
        for (int i = 0; i < size; ++i) {
            if (CpuFrequencyMetrics.sparseIntArrayEquals(this.timeInStateS[i], that.timeInStateS[i])) continue;
            return false;
        }
        return true;
    }

    private static void copyArrayInto(SparseIntArray source, SparseIntArray destination) {
        destination.clear();
        for (int i = 0; i < source.size(); ++i) {
            destination.append(source.keyAt(i), source.valueAt(i));
        }
    }

    public static boolean sparseIntArrayEquals(SparseIntArray a, SparseIntArray b) {
        if (a == b) {
            return true;
        }
        int aSize = a.size();
        if (aSize != b.size()) {
            return false;
        }
        for (int i = 0; i < aSize; ++i) {
            if (a.keyAt(i) == b.keyAt(i) && a.valueAt(i) == b.valueAt(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.timeInStateS.length; ++i) {
            SparseIntArray array = this.timeInStateS[i];
            int size = this.timeInStateS[i].size();
            for (int j = 0; j < size; ++j) {
                hash += array.keyAt(j) ^ array.valueAt(j);
            }
        }
        return hash;
    }

    public String toString() {
        return "CpuFrequencyMetrics{timeInStateS=" + Arrays.toString(this.timeInStateS) + '}';
    }

    @Nullable
    public JSONObject toJSONObject() {
        if (this.timeInStateS.length == 0) {
            return null;
        }
        boolean[] isHandled = new boolean[this.timeInStateS.length];
        JSONObject output = new JSONObject();
        int cores = this.timeInStateS.length;
        for (int i = 0; i < cores; ++i) {
            SparseIntArray current = this.timeInStateS[i];
            if (current.size() == 0 || isHandled[i]) continue;
            int cpumask = 1 << i;
            for (int j = i + 1; j < cores; ++j) {
                if (!CpuFrequencyMetrics.sparseIntArrayEquals(current, this.timeInStateS[j])) continue;
                cpumask |= 1 << j;
                isHandled[j] = true;
            }
            try {
                output.put(Integer.toHexString(cpumask), (Object)CpuFrequencyMetrics.convert(current));
                continue;
            }
            catch (JSONException je) {
                SystemMetricsLogger.wtf("CpuFrequencyMetricsReporter", "Unable to store event", je);
            }
        }
        return output;
    }

    private static JSONObject convert(SparseIntArray array) throws JSONException {
        JSONObject result = new JSONObject();
        int frequencies = array.size();
        for (int j = 0; j < frequencies; ++j) {
            result.put(Integer.toString(array.keyAt(j)), array.valueAt(j));
        }
        return result;
    }
}

