/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.cpu;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

class ProcFileReader {
    private final String mPath;
    private final byte[] mBuffer;
    @Nullable
    private RandomAccessFile mFile;
    private int mPosition = -1;
    private int mBufferSize;
    private char mChar;
    private char mPrev;
    private boolean mIsValid = true;
    private boolean mRewound = false;

    public ProcFileReader(String path) {
        this(path, 512);
    }

    public ProcFileReader(String path, int bufferSize) {
        this.mPath = path;
        this.mBuffer = new byte[bufferSize];
    }

    public ProcFileReader start() {
        return this.reset();
    }

    public ProcFileReader reset() {
        this.mIsValid = true;
        if (this.mFile != null) {
            try {
                this.mFile.seek(0L);
            }
            catch (IOException ioe) {
                this.close();
            }
        }
        if (this.mFile == null) {
            try {
                this.mFile = new RandomAccessFile(this.mPath, "r");
            }
            catch (IOException ioe) {
                this.mIsValid = false;
                this.close();
            }
        }
        if (this.mIsValid) {
            this.mPosition = -1;
            this.mBufferSize = 0;
            this.mChar = '\u0000';
            this.mPrev = '\u0000';
            this.mRewound = false;
        }
        return this;
    }

    public boolean isValid() {
        return this.mIsValid;
    }

    public boolean hasNext() {
        if (!this.mIsValid || this.mFile == null || this.mPosition > this.mBufferSize - 1) {
            return false;
        }
        if (this.mPosition < this.mBufferSize - 1) {
            return true;
        }
        try {
            this.mBufferSize = this.mFile.read(this.mBuffer);
            this.mPosition = -1;
        }
        catch (IOException ioe) {
            this.mIsValid = false;
            this.close();
        }
        return this.hasNext();
    }

    public boolean hasReachedEOF() {
        return this.mBufferSize == -1;
    }

    private void next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.mPosition;
        this.mPrev = this.mChar;
        this.mChar = (char)this.mBuffer[this.mPosition];
        this.mRewound = false;
    }

    private void rewind() {
        if (this.mRewound) {
            throw new ParseException("Can only rewind one step!");
        }
        --this.mPosition;
        this.mChar = this.mPrev;
        this.mRewound = true;
    }

    public long readNumber() {
        long result = 0L;
        boolean isFirstRun = true;
        while (this.hasNext()) {
            this.next();
            if (!Character.isDigit(this.mChar)) {
                if (isFirstRun) {
                    throw new ParseException("Couldn't read number!");
                }
                this.rewind();
                break;
            }
            result = result * 10L + (long)(this.mChar - 48);
            isFirstRun = false;
        }
        return result;
    }

    public void skipSpaces() {
        this.skipPast(' ');
    }

    public void skipLines() {
        this.skipPast('\n');
    }

    public void skipPast(char skipPast) {
        boolean found = false;
        while (this.hasNext()) {
            this.next();
            if (this.mChar == skipPast) {
                found = true;
                continue;
            }
            if (!found) continue;
            this.rewind();
            break;
        }
    }

    public void close() {
        if (this.mFile != null) {
            try {
                this.mFile.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.mFile = null;
            }
        }
    }

    public static class ParseException
    extends RuntimeException {
        public ParseException(String message) {
            super(message);
        }
    }
}

