/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.healthstats;

import android.os.health.HealthStats;
import android.os.health.PackageHealthStats;
import android.os.health.PidHealthStats;
import android.os.health.ProcessHealthStats;
import android.os.health.ServiceHealthStats;
import android.os.health.TimerStat;
import android.os.health.UidHealthStats;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.VisibleForTesting;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import com.facebook.battery.metrics.core.SystemMetrics;
import com.facebook.battery.metrics.core.SystemMetricsLogger;
import com.facebook.battery.metrics.core.Utilities;
import java.lang.reflect.Field;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@RequiresApi(api=24)
public class HealthStatsMetrics
extends SystemMetrics<HealthStatsMetrics> {
    @VisibleForTesting
    static final int OP_SUM = 1;
    @VisibleForTesting
    static final int OP_DIFF = -1;
    private static final String TAG = "HealthStatsMetrics";
    private static final SparseArray<String> sKeyNames = new SparseArray();
    public String dataType;
    public final SparseArray<Long> measurement = new SparseArray();
    public final SparseArray<TimerMetrics> timer = new SparseArray();
    public final SparseArray<ArrayMap<String, Long>> measurements = new SparseArray();
    public final SparseArray<ArrayMap<String, TimerMetrics>> timers = new SparseArray();
    public final SparseArray<ArrayMap<String, HealthStatsMetrics>> stats = new SparseArray();

    public HealthStatsMetrics() {
    }

    public HealthStatsMetrics(HealthStats healthStats) {
        this.set(healthStats);
    }

    public HealthStatsMetrics(HealthStatsMetrics metrics) {
        this.set(metrics);
    }

    @Override
    public HealthStatsMetrics sum(@Nullable HealthStatsMetrics b, @Nullable HealthStatsMetrics output) {
        if (output == null) {
            output = new HealthStatsMetrics();
        }
        output.dataType = this.dataType;
        if (b == null) {
            output.set(this);
        } else {
            if (!HealthStatsMetrics.strEquals(b.dataType, this.dataType)) {
                throw new IllegalArgumentException("Attempting to add different types of HealthStatMetrics: " + this.dataType + " and " + b.dataType);
            }
            HealthStatsMetrics.op(1, this.measurement, b.measurement, output.measurement);
            HealthStatsMetrics.op(1, this.measurements, b.measurements, output.measurements);
            HealthStatsMetrics.op(1, this.timer, b.timer, output.timer);
            HealthStatsMetrics.op(1, this.timers, b.timers, output.timers);
            HealthStatsMetrics.op(1, this.stats, b.stats, output.stats);
        }
        return output;
    }

    @Override
    public HealthStatsMetrics diff(@Nullable HealthStatsMetrics b, @Nullable HealthStatsMetrics output) {
        if (output == null) {
            output = new HealthStatsMetrics();
        }
        output.dataType = this.dataType;
        if (b == null || HealthStatsMetrics.compareSnapshotAge(this, b) < 0L) {
            output.set(this);
        } else {
            if (!HealthStatsMetrics.strEquals(b.dataType, this.dataType)) {
                throw new IllegalArgumentException("Attempting to subtract different types of HealthStatMetrics: " + this.dataType + " and " + b.dataType);
            }
            HealthStatsMetrics.op(-1, this.measurement, b.measurement, output.measurement);
            HealthStatsMetrics.op(-1, this.measurements, b.measurements, output.measurements);
            HealthStatsMetrics.op(-1, this.timer, b.timer, output.timer);
            HealthStatsMetrics.op(-1, this.timers, b.timers, output.timers);
            HealthStatsMetrics.op(-1, this.stats, b.stats, output.stats);
        }
        return output;
    }

    private static long compareSnapshotAge(HealthStatsMetrics a, HealthStatsMetrics b) {
        long aRealtimeBatteryMs = (Long)a.measurement.get(10001, (Object)0L);
        long bRealtimeBatteryMs = (Long)b.measurement.get(10001, (Object)0L);
        return aRealtimeBatteryMs - bRealtimeBatteryMs;
    }

    @VisibleForTesting
    static <K> SparseArray<K> op(int op, SparseArray<K> a, SparseArray<K> b, SparseArray<K> output) {
        int i;
        output.clear();
        for (i = 0; i < a.size(); ++i) {
            int aKey = a.keyAt(i);
            output.put(aKey, HealthStatsMetrics.opValues(op, a.valueAt(i), b.get(aKey)));
        }
        if (op == 1) {
            for (i = 0; i < b.size(); ++i) {
                int bKey = b.keyAt(i);
                if (a.get(bKey) != null) continue;
                output.put(bKey, b.valueAt(i));
            }
        }
        return output;
    }

    @VisibleForTesting
    static <K, V> ArrayMap<K, V> opArrayMaps(int op, ArrayMap<K, V> a, @Nullable ArrayMap<K, V> b) {
        int aSize = a.size();
        ArrayMap output = new ArrayMap();
        for (int i = 0; i < aSize; ++i) {
            Object key = a.keyAt(i);
            Object bValue = b == null ? null : b.get(key);
            output.put(key, bValue == null ? a.valueAt(i) : HealthStatsMetrics.opValues(op, a.valueAt(i), bValue));
        }
        if (op == 1) {
            int bSize = b == null ? 0 : b.size();
            for (int i = 0; i < bSize; ++i) {
                Object key = b.keyAt(i);
                if (a.get(key) != null) continue;
                output.put(key, b.valueAt(i));
            }
        }
        return output;
    }

    private static <V> Object opValues(int op, V a, @Nullable V b) {
        if (a instanceof Long) {
            return (Long)a + (b == null ? 0L : (long)op * (Long)b);
        }
        if (a instanceof TimerMetrics) {
            TimerMetrics timerMetricsA = (TimerMetrics)a;
            TimerMetrics timerMetricsB = (TimerMetrics)b;
            if (b == null) {
                return new TimerMetrics(timerMetricsA);
            }
            TimerMetrics timerMetrics = new TimerMetrics();
            timerMetrics.count = timerMetricsA.count + op * timerMetricsB.count;
            timerMetrics.timeMs = timerMetricsA.timeMs + (long)op * timerMetricsB.timeMs;
            return timerMetrics;
        }
        if (a instanceof HealthStatsMetrics) {
            if (op == 1) {
                return ((HealthStatsMetrics)a).sum((HealthStatsMetrics)b, (HealthStatsMetrics)null);
            }
            return ((HealthStatsMetrics)a).diff((HealthStatsMetrics)b, (HealthStatsMetrics)null);
        }
        if (a instanceof ArrayMap) {
            return HealthStatsMetrics.opArrayMaps(op, (ArrayMap)a, (ArrayMap)b);
        }
        throw new IllegalArgumentException("Handling unsupported values");
    }

    @Override
    public HealthStatsMetrics set(HealthStatsMetrics b) {
        int j;
        ArrayMap value;
        ArrayMap bValue;
        int i;
        this.dataType = b.dataType;
        this.measurement.clear();
        for (i = 0; i < b.measurement.size(); ++i) {
            this.measurement.append(b.measurement.keyAt(i), b.measurement.valueAt(i));
        }
        this.timer.clear();
        for (i = 0; i < b.timer.size(); ++i) {
            this.timer.append(b.timer.keyAt(i), (Object)new TimerMetrics((TimerMetrics)b.timer.valueAt(i)));
        }
        this.measurements.clear();
        for (i = 0; i < b.measurements.size(); ++i) {
            ArrayMap value2 = new ArrayMap();
            value2.putAll((Map)b.measurements.valueAt(i));
            this.measurements.append(b.measurements.keyAt(i), (Object)value2);
        }
        this.timers.clear();
        for (i = 0; i < b.timers.size(); ++i) {
            bValue = (ArrayMap)b.timers.valueAt(i);
            value = new ArrayMap();
            for (j = 0; j < bValue.size(); ++j) {
                value.put(bValue.keyAt(j), (Object)new TimerMetrics((TimerMetrics)bValue.valueAt(j)));
            }
            this.timers.append(b.timers.keyAt(i), (Object)value);
        }
        this.stats.clear();
        for (i = 0; i < b.stats.size(); ++i) {
            bValue = (ArrayMap)b.stats.valueAt(i);
            value = new ArrayMap();
            for (j = 0; j < bValue.size(); ++j) {
                value.put(bValue.keyAt(j), (Object)new HealthStatsMetrics((HealthStatsMetrics)bValue.valueAt(j)));
            }
            this.stats.append(b.stats.keyAt(i), (Object)value);
        }
        return this;
    }

    @Override
    public HealthStatsMetrics set(HealthStats healthStats) {
        Object value;
        int key;
        int i;
        this.dataType = healthStats.getDataType();
        this.measurement.clear();
        for (i = 0; i < healthStats.getMeasurementKeyCount(); ++i) {
            key = healthStats.getMeasurementKeyAt(i);
            this.measurement.put(key, (Object)healthStats.getMeasurement(key));
        }
        this.measurements.clear();
        for (i = 0; i < healthStats.getMeasurementsKeyCount(); ++i) {
            key = healthStats.getMeasurementsKeyAt(i);
            value = new ArrayMap();
            for (Map.Entry entry : healthStats.getMeasurements(key).entrySet()) {
                value.put(entry.getKey(), entry.getValue());
            }
            this.measurements.put(key, value);
        }
        this.timer.clear();
        for (i = 0; i < healthStats.getTimerKeyCount(); ++i) {
            key = healthStats.getTimerKeyAt(i);
            value = new TimerMetrics(healthStats.getTimerCount(key), healthStats.getTimerTime(key));
            this.timer.put(key, value);
        }
        this.timers.clear();
        for (i = 0; i < healthStats.getTimersKeyCount(); ++i) {
            key = healthStats.getTimersKeyAt(i);
            value = new ArrayMap();
            for (Map.Entry entry : healthStats.getTimers(key).entrySet()) {
                value.put(entry.getKey(), (Object)new TimerMetrics((TimerStat)entry.getValue()));
            }
            this.timers.put(key, value);
        }
        this.stats.clear();
        for (i = 0; i < healthStats.getStatsKeyCount(); ++i) {
            key = healthStats.getStatsKeyAt(i);
            value = new ArrayMap();
            for (Map.Entry entry : healthStats.getStats(key).entrySet()) {
                value.put(entry.getKey(), (Object)new HealthStatsMetrics((HealthStats)entry.getValue()));
            }
            this.stats.put(key, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder stringValue = new StringBuilder("HealthStatsMetrics {\n");
        try {
            stringValue.append(this.toJSONObject().toString(2));
        }
        catch (JSONException je) {
            stringValue.append("<error>");
            Log.e((String)TAG, (String)"Unable to convert to string", (Throwable)je);
        }
        stringValue.append("\n}");
        return stringValue.toString();
    }

    public static String getKeyName(int key) {
        if (sKeyNames.size() == 0) {
            HealthStatsMetrics.readKeyNames();
        }
        return (String)sKeyNames.get(key, (Object)"Unknown");
    }

    private static void readKeyNames() {
        try {
            Class[] healthStatsClasses = new Class[]{UidHealthStats.class, PidHealthStats.class, ProcessHealthStats.class, PackageHealthStats.class, ServiceHealthStats.class};
            Class<?> annotationClass = Class.forName("android.os.health.HealthKeys$Constant");
            for (Class clazz : healthStatsClasses) {
                Field[] fields;
                for (Field field : fields = clazz.getFields()) {
                    if (!field.isAnnotationPresent(annotationClass)) continue;
                    sKeyNames.put(field.getInt(null), (Object)field.getName());
                }
            }
            return;
        }
        catch (IllegalAccessException iae) {
            SystemMetricsLogger.wtf(TAG, "Unable to read constant names", iae);
        }
        catch (ClassNotFoundException cnfe) {
            SystemMetricsLogger.wtf(TAG, "Unable to find constant annotation", cnfe);
        }
        sKeyNames.put(-1, (Object)"Unable to read");
    }

    public JSONObject toJSONObject() throws JSONException {
        int statsCount;
        int timersCount;
        int measurementsCount;
        int timerCount;
        JSONObject output = new JSONObject();
        output.put("type", (Object)this.dataType);
        int measurementCount = this.measurement.size();
        if (measurementCount > 0) {
            JSONObject measurementObj = new JSONObject();
            for (int i = 0; i < measurementCount; ++i) {
                measurementObj.put(HealthStatsMetrics.getKeyName(this.measurement.keyAt(i)), this.measurement.valueAt(i));
            }
            output.put("measurement", (Object)measurementObj);
        }
        if ((timerCount = this.timer.size()) > 0) {
            JSONObject timerObj = new JSONObject();
            for (int i = 0; i < timerCount; ++i) {
                timerObj.put(HealthStatsMetrics.getKeyName(this.timer.keyAt(i)), (Object)new JSONObject().put("count", ((TimerMetrics)this.timer.valueAt((int)i)).count).put("time_ms", ((TimerMetrics)this.timer.valueAt((int)i)).timeMs));
            }
            output.put("timer", (Object)timerObj);
        }
        if ((measurementsCount = this.measurements.size()) > 0) {
            JSONObject measurementsObj = new JSONObject();
            for (int i = 0; i < measurementsCount; ++i) {
                measurementsObj.put(HealthStatsMetrics.getKeyName(this.measurements.keyAt(i)), (Object)HealthStatsMetrics.toJSONObject((ArrayMap)this.measurements.valueAt(i)));
            }
            output.put("measurements", (Object)measurementsObj);
        }
        if ((timersCount = this.timers.size()) > 0) {
            JSONObject timersObj = new JSONObject();
            for (int i = 0; i < timersCount; ++i) {
                timersObj.put(HealthStatsMetrics.getKeyName(this.timers.keyAt(i)), (Object)HealthStatsMetrics.toJSONObject((ArrayMap)this.timers.valueAt(i)));
            }
            output.put("timers", (Object)timersObj);
        }
        if ((statsCount = this.stats.size()) > 0) {
            JSONObject statsObj = new JSONObject();
            for (int i = 0; i < statsCount; ++i) {
                statsObj.put(HealthStatsMetrics.getKeyName(this.stats.keyAt(i)), (Object)HealthStatsMetrics.toJSONObject((ArrayMap)this.stats.valueAt(i)));
            }
            output.put("stats", (Object)statsObj);
        }
        return output;
    }

    private static <V> JSONObject toJSONObject(@Nullable ArrayMap<String, V> map) throws JSONException {
        int len;
        JSONObject mapObj = new JSONObject();
        int n = len = map == null ? 0 : map.size();
        for (int i = 0; i < len; ++i) {
            Object value = map.valueAt(i);
            if (value instanceof TimerMetrics) {
                mapObj.put((String)map.keyAt(i), (Object)new JSONObject().put("count", ((TimerMetrics)value).count).put("time_ms", ((TimerMetrics)value).timeMs));
                continue;
            }
            if (value instanceof HealthStatsMetrics) {
                mapObj.put((String)map.keyAt(i), (Object)((HealthStatsMetrics)value).toJSONObject());
                continue;
            }
            mapObj.put((String)map.keyAt(i), map.valueAt(i));
        }
        return mapObj;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HealthStatsMetrics that = (HealthStatsMetrics)o;
        if (this.dataType != null ? !this.dataType.equals(that.dataType) : that.dataType != null) {
            return false;
        }
        return Utilities.sparseArrayEquals(this.measurement, that.measurement) && Utilities.sparseArrayEquals(this.measurements, that.measurements) && Utilities.sparseArrayEquals(this.timer, that.timer) && Utilities.sparseArrayEquals(this.timers, that.timers) && Utilities.sparseArrayEquals(this.stats, that.stats);
    }

    public int hashCode() {
        int result = this.dataType != null ? this.dataType.hashCode() : 0;
        result = 31 * result + this.measurement.hashCode();
        result = 31 * result + this.timer.hashCode();
        result = 31 * result + this.measurements.hashCode();
        result = 31 * result + this.timers.hashCode();
        result = 31 * result + this.stats.hashCode();
        return result;
    }

    private static boolean strEquals(@Nullable String a, @Nullable String b) {
        return a == null ? b == null : a.equals(b);
    }

    public static class TimerMetrics {
        public int count;
        public long timeMs;

        public TimerMetrics() {
        }

        public TimerMetrics(TimerMetrics b) {
            this.count = b.count;
            this.timeMs = b.timeMs;
        }

        public TimerMetrics(TimerStat value) {
            this.count = value.getCount();
            this.timeMs = value.getTime();
        }

        public TimerMetrics(int count, long timeMs) {
            this.count = count;
            this.timeMs = timeMs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimerMetrics that = (TimerMetrics)o;
            if (this.count != that.count) {
                return false;
            }
            return this.timeMs == that.timeMs;
        }

        public int hashCode() {
            int result = this.count;
            result = 31 * result + (int)(this.timeMs ^ this.timeMs >>> 32);
            return result;
        }
    }
}

