/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.network;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.support.annotation.Size;
import com.facebook.battery.metrics.network.NetworkStatsManagerBytesCollector;
import com.facebook.battery.metrics.network.QTagUidNetworkBytesCollector;
import com.facebook.battery.metrics.network.TrafficStatsNetworkBytesCollector;

abstract class NetworkBytesCollector {
    static final int RX = 0;
    static final int TX = 1;
    static final int MOBILE = 2;
    static final int WIFI = 0;
    static final int FG = 0;
    static final int BG = 4;

    NetworkBytesCollector() {
    }

    @Size(value=8L)
    public static long[] createByteArray() {
        return new long[8];
    }

    public abstract boolean supportsBgDistinction();

    public abstract boolean getTotalBytes(@Size(value=8L) long[] var1);

    @SuppressLint(value={"ObsoleteSdkInt"})
    public static NetworkBytesCollector create(Context context) {
        long[] bytes;
        QTagUidNetworkBytesCollector collector;
        if (Build.VERSION.SDK_INT >= 28) {
            return new NetworkStatsManagerBytesCollector(context);
        }
        if (Build.VERSION.SDK_INT >= 14 && (collector = new QTagUidNetworkBytesCollector()).getTotalBytes(bytes = new long[8])) {
            return collector;
        }
        return new TrafficStatsNetworkBytesCollector(context);
    }
}

