/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.network;

import android.content.Context;
import com.facebook.battery.metrics.core.SystemMetricsCollector;
import com.facebook.battery.metrics.core.SystemMetricsLogger;
import com.facebook.battery.metrics.network.NetworkBytesCollector;
import com.facebook.battery.metrics.network.NetworkMetrics;
import com.facebook.infer.annotation.ThreadSafe;
import java.util.Arrays;

@ThreadSafe
public class NetworkMetricsCollector
extends SystemMetricsCollector<NetworkMetrics> {
    private static final String TAG = "NetworkMetricsCollector";
    private boolean mIsValid = true;
    private final NetworkBytesCollector mCollector;
    private final long[] mBytes;
    private final long[] mPrevBytes;

    public NetworkMetricsCollector(Context context) {
        this.mCollector = NetworkBytesCollector.create(context);
        this.mBytes = NetworkBytesCollector.createByteArray();
        this.mPrevBytes = NetworkBytesCollector.createByteArray();
    }

    @Override
    @ThreadSafe(enableChecks=false)
    public synchronized boolean getSnapshot(NetworkMetrics snapshot) {
        if (!this.mIsValid || !this.mCollector.getTotalBytes(this.mBytes)) {
            return false;
        }
        this.mIsValid = NetworkMetricsCollector.ensureBytesIncreased(this.mBytes, this.mPrevBytes);
        if (!this.mIsValid) {
            return false;
        }
        boolean supportsBgDetection = this.mCollector.supportsBgDistinction();
        NetworkMetricsCollector.resetMetrics(snapshot);
        NetworkMetricsCollector.addMetricsFromBytes(snapshot, this.mBytes, 0);
        if (supportsBgDetection) {
            NetworkMetricsCollector.addMetricsFromBytes(snapshot, this.mBytes, 4);
        }
        return true;
    }

    static boolean ensureBytesIncreased(long[] currentBytes, long[] previousBytes) {
        for (int i = 0; i < currentBytes.length; ++i) {
            if (currentBytes[i] >= previousBytes[i]) continue;
            SystemMetricsLogger.wtf(TAG, "Network Bytes decreased from " + Arrays.toString(previousBytes) + " to " + Arrays.toString(currentBytes));
            return false;
        }
        System.arraycopy(currentBytes, 0, previousBytes, 0, currentBytes.length);
        return true;
    }

    static void addMetricsFromBytes(NetworkMetrics metrics, long[] bytes, int fgBgBit) {
        metrics.mobileBytesTx += bytes[3 | fgBgBit];
        metrics.mobileBytesRx += bytes[2 | fgBgBit];
        metrics.wifiBytesTx += bytes[1 | fgBgBit];
        metrics.wifiBytesRx += bytes[0 | fgBgBit];
    }

    static void resetMetrics(NetworkMetrics metrics) {
        metrics.mobileBytesTx = 0L;
        metrics.mobileBytesRx = 0L;
        metrics.wifiBytesTx = 0L;
        metrics.wifiBytesRx = 0L;
    }

    @Override
    public NetworkMetrics createMetrics() {
        return new NetworkMetrics();
    }
}

