/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.network;

import android.annotation.SuppressLint;
import android.os.Process;
import android.support.annotation.VisibleForTesting;
import com.facebook.battery.metrics.core.SystemMetricsLogger;
import com.facebook.battery.metrics.network.NetworkBytesCollector;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;

class QTagUidNetworkBytesCollector
extends NetworkBytesCollector {
    private static final String TAG = "QTagUidNetworkBytesCollector";
    private static final String STATS_PATH = "/proc/net/xt_qtaguid/stats";
    private static final long UID = Process.myUid();
    private static final long WLAN0_HASH = "wlan0".hashCode();
    private static final long[] LOCAL_IFACE_HASHES = new long[]{"dummy0".hashCode(), "lo".hashCode()};
    private RandomAccessFile mQTagUidStatsFile;
    private boolean mIsValid = true;
    private boolean mReachedEof = false;
    private boolean mHasPeeked = false;
    private int mChar;

    QTagUidNetworkBytesCollector() {
    }

    protected void finalize() throws Throwable {
        this.closeFile();
    }

    @Override
    public boolean supportsBgDistinction() {
        return true;
    }

    @Override
    public boolean getTotalBytes(long[] bytes) {
        if (!this.mIsValid) {
            return false;
        }
        Arrays.fill(bytes, 0L);
        try {
            if (this.mQTagUidStatsFile == null) {
                this.mQTagUidStatsFile = this.openFile();
            }
            this.mReachedEof = false;
            this.mQTagUidStatsFile.seek(0L);
            this.skipPast('\n');
            while (!this.mReachedEof && this.mIsValid && this.peek()) {
                boolean isMobile;
                this.skipPast(' ');
                int ifaceHash = this.readHash();
                this.skipPast(' ');
                long uid = this.readNumber();
                boolean isWifi = (long)ifaceHash == WLAN0_HASH;
                boolean bl = isMobile = !isWifi && !QTagUidNetworkBytesCollector.isLocalInterface(ifaceHash);
                if (uid != UID || !isWifi && !isMobile) {
                    this.skipPast('\n');
                    continue;
                }
                long cntSet = this.readNumber();
                int field = 0;
                field |= isWifi ? 0 : 2;
                int n = (field |= cntSet == 0L ? 4 : 0) | 0;
                bytes[n] = bytes[n] + this.readNumber();
                this.skipPast(' ');
                int n2 = field | 1;
                bytes[n2] = bytes[n2] + this.readNumber();
                this.skipPast('\n');
            }
        }
        catch (IOException ioe) {
            SystemMetricsLogger.wtf(TAG, "Unable to parse file", ioe);
            this.closeFile();
        }
        return this.mIsValid;
    }

    @VisibleForTesting
    @SuppressLint(value={"InstanceMethodCanBeStatic"})
    protected RandomAccessFile openFile() throws FileNotFoundException {
        return new RandomAccessFile(STATS_PATH, "r");
    }

    private long readNumber() throws IOException {
        boolean complete = false;
        boolean triggered = false;
        long result = 0L;
        while (!complete && this.read()) {
            if (Character.isDigit(this.mChar)) {
                result = result * 10L + (long)(this.mChar - 48);
                triggered = true;
                continue;
            }
            complete = true;
        }
        this.softAssert(triggered);
        return result;
    }

    private int readHash() throws IOException {
        boolean complete = false;
        boolean triggered = false;
        int hash = 0;
        while (!complete && this.read()) {
            if (this.mChar != 32) {
                hash = 31 * hash + this.mChar;
                triggered = true;
                continue;
            }
            complete = true;
        }
        this.softAssert(triggered);
        return hash;
    }

    private void skipPast(char ch) throws IOException {
        boolean complete = false;
        while (!complete && this.read()) {
            if (this.mChar != ch) continue;
            complete = true;
        }
        this.softAssert(complete);
    }

    private void closeFile() {
        this.mIsValid = false;
        if (this.mQTagUidStatsFile != null) {
            try {
                this.mQTagUidStatsFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean peek() throws IOException {
        this.read();
        this.mHasPeeked = true;
        return !this.mReachedEof;
    }

    private boolean read() throws IOException {
        if (this.mHasPeeked) {
            this.mHasPeeked = false;
            return !this.mReachedEof;
        }
        this.mChar = this.mQTagUidStatsFile.read();
        this.mReachedEof = this.mChar == -1;
        return !this.mReachedEof;
    }

    private boolean softAssert(boolean test) {
        this.mIsValid &= test;
        return this.mIsValid;
    }

    private static boolean isLocalInterface(int ifaceHash) {
        for (int i = 0; i < LOCAL_IFACE_HASHES.length; ++i) {
            if ((long)ifaceHash != LOCAL_IFACE_HASHES[i]) continue;
            return true;
        }
        return false;
    }
}

