/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.network;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.TrafficStats;
import android.os.Process;
import android.support.annotation.VisibleForTesting;
import com.facebook.battery.metrics.network.NetworkBytesCollector;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class TrafficStatsNetworkBytesCollector
extends NetworkBytesCollector {
    private static final int UID = Process.myUid();
    private static final int TYPE_NONE = -1;
    final ConnectivityManager mConnectivityManager;
    private final long[] mTotalBytes = new long[8];
    int mCurrentNetworkType;
    private boolean mIsValid = true;
    @VisibleForTesting
    BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            int type;
            NetworkInfo info = TrafficStatsNetworkBytesCollector.this.mConnectivityManager.getActiveNetworkInfo();
            if (info == null || (type = info.getType()) == TrafficStatsNetworkBytesCollector.this.mCurrentNetworkType) {
                return;
            }
            TrafficStatsNetworkBytesCollector.this.updateTotalBytes();
            TrafficStatsNetworkBytesCollector.this.mCurrentNetworkType = type;
        }
    };

    public TrafficStatsNetworkBytesCollector(Context context) {
        Context applicationContext = context.getApplicationContext();
        context = applicationContext != null ? applicationContext : context;
        this.mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetwork = this.mConnectivityManager.getActiveNetworkInfo();
        this.mCurrentNetworkType = activeNetwork == null ? -1 : activeNetwork.getType();
        context.registerReceiver(this.mReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        this.updateTotalBytes();
    }

    @Override
    public boolean supportsBgDistinction() {
        return false;
    }

    @Override
    public synchronized boolean getTotalBytes(long[] bytes) {
        if (!this.mIsValid) {
            return false;
        }
        this.updateTotalBytes();
        System.arraycopy(this.mTotalBytes, 0, bytes, 0, bytes.length);
        return true;
    }

    synchronized void updateTotalBytes() {
        long currentTotalTxBytes = TrafficStats.getUidTxBytes((int)UID);
        long currentTotalRxBytes = TrafficStats.getUidRxBytes((int)UID);
        if (currentTotalRxBytes == -1L || currentTotalTxBytes == -1L) {
            this.mIsValid = false;
            return;
        }
        int prefix = this.mCurrentNetworkType == 1 ? 0 : 2;
        long lastTotalTxBytes = this.mTotalBytes[3] + this.mTotalBytes[1];
        long lastTotalRxBytes = this.mTotalBytes[2] + this.mTotalBytes[0];
        int n = 1 | prefix;
        this.mTotalBytes[n] = this.mTotalBytes[n] + (currentTotalTxBytes - lastTotalTxBytes);
        int n2 = 0 | prefix;
        this.mTotalBytes[n2] = this.mTotalBytes[n2] + (currentTotalRxBytes - lastTotalRxBytes);
    }
}

