/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.wakelock;

import android.os.PowerManager;
import android.os.SystemClock;
import com.facebook.battery.metrics.core.SystemMetricsLogger;
import java.lang.ref.WeakReference;

class WakeLockDetails {
    public final String tag;
    public final int levelAndFlags;
    public final WeakReference<PowerManager.WakeLock> wakeLockReference;
    private boolean mIsReferenceCounted = true;
    private boolean mIsHeld = false;
    private int mReferences = 0;
    private long mAcquireTimeMs;
    private long mTimeoutTimeMs = Long.MAX_VALUE;
    private long mHeldTimeMs;
    private long mLastReleasedMs = -1L;

    public WakeLockDetails(PowerManager.WakeLock wakeLockReference, String tag, int levelAndFlags) {
        this.tag = tag;
        this.levelAndFlags = levelAndFlags;
        this.wakeLockReference = new WeakReference<PowerManager.WakeLock>(wakeLockReference);
    }

    public boolean acquire(long timeoutMs) {
        long currentTimeMs = SystemClock.uptimeMillis();
        if (timeoutMs >= 0L) {
            this.mTimeoutTimeMs = currentTimeMs + timeoutMs;
        }
        if (this.mIsReferenceCounted && this.mReferences++ != 0) {
            return false;
        }
        if (this.mIsHeld) {
            return false;
        }
        this.mAcquireTimeMs = currentTimeMs;
        this.mIsHeld = true;
        return true;
    }

    public boolean release() {
        return this.releaseAtTime(SystemClock.uptimeMillis());
    }

    private boolean releaseAtTime(long releaseTimeMs) {
        if (!this.mIsHeld) {
            return false;
        }
        if (this.mIsReferenceCounted && --this.mReferences != 0) {
            return false;
        }
        this.mLastReleasedMs = releaseTimeMs;
        this.mHeldTimeMs += releaseTimeMs - this.mAcquireTimeMs;
        this.mTimeoutTimeMs = Long.MAX_VALUE;
        this.mIsHeld = false;
        return true;
    }

    public boolean applyAutomaticReleases() {
        boolean timeoutReleaseTimeMs = this.applyTimeouts();
        boolean finalizeReleaseTimeMs = this.applyFinalize();
        return timeoutReleaseTimeMs || finalizeReleaseTimeMs;
    }

    private boolean applyTimeouts() {
        long currentTimeMs = SystemClock.uptimeMillis();
        if (currentTimeMs >= this.mTimeoutTimeMs) {
            return this.releaseAtTime(this.mTimeoutTimeMs);
        }
        return false;
    }

    private boolean applyFinalize() {
        if (this.mIsHeld && this.wakeLockReference.get() == null) {
            SystemMetricsLogger.wtf("WakeLockMetricsCollector", "The wakelock " + this.tag + " was garbage collected before being released.");
            return this.releaseAtTime(SystemClock.uptimeMillis());
        }
        return false;
    }

    public long getHeldTimeMs() {
        return this.mHeldTimeMs + (this.mIsHeld ? SystemClock.uptimeMillis() - this.mAcquireTimeMs : 0L);
    }

    public long getLastReleaseTimeMs() {
        return this.mLastReleasedMs;
    }

    public boolean isHeld() {
        return this.mIsHeld;
    }

    public WakeLockDetails setIsReferenceCounted(boolean isReferenceCounted) {
        this.mIsReferenceCounted = isReferenceCounted;
        return this;
    }
}

