/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.battery.metrics.wakelock;

import android.os.PowerManager;
import android.os.SystemClock;
import android.support.annotation.GuardedBy;
import android.support.v4.util.SimpleArrayMap;
import com.facebook.battery.metrics.core.SystemMetricsCollector;
import com.facebook.battery.metrics.core.SystemMetricsLogger;
import com.facebook.battery.metrics.core.Utilities;
import com.facebook.battery.metrics.wakelock.WakeLockDetails;
import com.facebook.battery.metrics.wakelock.WakeLockMetrics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.WeakHashMap;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class WakeLockMetricsCollector
extends SystemMetricsCollector<WakeLockMetrics> {
    private static final String TAG = "WakeLockMetricsCollector";
    private final WeakHashMap<PowerManager.WakeLock, WakeLockDetails> mWakeLocks = new WeakHashMap();
    private final SimpleArrayMap<String, Long> mPrevWakeLockMs = new SimpleArrayMap();
    private final ArrayList<WakeLockDetails> mActiveWakeLockDetails = new ArrayList();
    @GuardedBy(value="this")
    private long mWakeLockAcquireTimeMs;
    @GuardedBy(value="this")
    private long mWakeLocksHeldTimeMs;
    @GuardedBy(value="this")
    private long mTotalWakeLocksAcquired;
    @GuardedBy(value="this")
    private int mActiveWakeLocks;
    @GuardedBy(value="this")
    private boolean mIsEnabled = true;

    public synchronized void newWakeLock(PowerManager.WakeLock wakelock, int levelAndFlags, String tag) {
        if (!this.mIsEnabled) {
            return;
        }
        WakeLockDetails details = new WakeLockDetails(wakelock, tag, levelAndFlags);
        this.mWakeLocks.put(wakelock, details);
        this.mActiveWakeLockDetails.add(details);
    }

    public synchronized void acquire(PowerManager.WakeLock wakelock, long timeout) {
        if (!this.mIsEnabled) {
            return;
        }
        this.updateWakeLockCounts();
        WakeLockDetails details = this.mWakeLocks.get(wakelock);
        if (details == null) {
            SystemMetricsLogger.wtf(TAG, "Unknown wakelock modified");
            return;
        }
        if (details.acquire(timeout)) {
            if (this.mActiveWakeLocks == 0) {
                this.mWakeLockAcquireTimeMs = SystemClock.uptimeMillis();
            }
            ++this.mTotalWakeLocksAcquired;
            ++this.mActiveWakeLocks;
        }
    }

    public synchronized void release(PowerManager.WakeLock wakelock, int flags) {
        if (!this.mIsEnabled) {
            return;
        }
        this.updateWakeLockCounts();
        WakeLockDetails details = this.mWakeLocks.get(wakelock);
        if (details == null) {
            SystemMetricsLogger.wtf(TAG, "Unknown wakelock modified");
            return;
        }
        if (details.release()) {
            --this.mActiveWakeLocks;
            if (this.mActiveWakeLocks == 0) {
                this.mWakeLocksHeldTimeMs += details.getLastReleaseTimeMs() - this.mWakeLockAcquireTimeMs;
            }
        }
    }

    public synchronized void setReferenceCounted(PowerManager.WakeLock wakelock, boolean value) {
        if (!this.mIsEnabled) {
            return;
        }
        WakeLockDetails details = this.mWakeLocks.get(wakelock);
        if (details == null) {
            SystemMetricsLogger.wtf(TAG, "Unknown wakelock modified");
            return;
        }
        details.setIsReferenceCounted(value);
    }

    public synchronized void disable() {
        this.mIsEnabled = false;
        this.mPrevWakeLockMs.clear();
        this.mActiveWakeLockDetails.clear();
    }

    private synchronized void updateWakeLockCounts() {
        int activeWakeLocks = 0;
        long maxReleaseTimeMs = -1L;
        Iterator<WakeLockDetails> iter = this.mActiveWakeLockDetails.iterator();
        while (iter.hasNext()) {
            WakeLockDetails details = iter.next();
            boolean released = details.applyAutomaticReleases();
            if (details.isHeld()) {
                ++activeWakeLocks;
            } else if (released && details.getLastReleaseTimeMs() > maxReleaseTimeMs) {
                maxReleaseTimeMs = details.getLastReleaseTimeMs();
            }
            if (details.wakeLockReference.get() != null) continue;
            Long existingValue = (Long)this.mPrevWakeLockMs.get((Object)details.tag);
            this.mPrevWakeLockMs.put((Object)details.tag, (Object)((existingValue == null ? 0L : existingValue) + details.getHeldTimeMs()));
            iter.remove();
        }
        if (this.mActiveWakeLocks != 0 && activeWakeLocks == 0) {
            this.mWakeLocksHeldTimeMs += maxReleaseTimeMs - this.mWakeLockAcquireTimeMs;
        }
        this.mActiveWakeLocks = activeWakeLocks;
    }

    @Override
    public synchronized boolean getSnapshot(WakeLockMetrics snapshot) {
        Utilities.checkNotNull(snapshot, "Null value passed to getSnapshot!");
        if (!this.mIsEnabled) {
            return false;
        }
        this.updateWakeLockCounts();
        snapshot.acquiredCount = this.mTotalWakeLocksAcquired;
        snapshot.heldTimeMs = this.mWakeLocksHeldTimeMs + (this.mActiveWakeLocks > 0 ? SystemClock.uptimeMillis() - this.mWakeLockAcquireTimeMs : 0L);
        if (snapshot.isAttributionEnabled) {
            int i;
            snapshot.tagTimeMs.clear();
            int size = this.mActiveWakeLockDetails.size();
            for (i = 0; i < size; ++i) {
                WakeLockDetails details = this.mActiveWakeLockDetails.get(i);
                long heldTimeMs = details.getHeldTimeMs();
                String tag = details.tag;
                Long existingValue = (Long)snapshot.tagTimeMs.get((Object)tag);
                snapshot.tagTimeMs.put((Object)tag, (Object)((existingValue == null ? 0L : existingValue) + heldTimeMs));
            }
            size = this.mPrevWakeLockMs.size();
            for (i = 0; i < size; ++i) {
                String tag = (String)this.mPrevWakeLockMs.keyAt(i);
                Long existingValue = (Long)snapshot.tagTimeMs.get((Object)tag);
                snapshot.tagTimeMs.put((Object)tag, (Object)((existingValue == null ? 0L : existingValue) + (Long)this.mPrevWakeLockMs.valueAt(i)));
            }
        }
        return true;
    }

    @Override
    public WakeLockMetrics createMetrics() {
        return new WakeLockMetrics();
    }
}

