/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdCreativeLinkDataCallToAction;
import com.facebook.ads.sdk.AdCreativePlaceData;
import com.facebook.ads.sdk.AdsImageCrops;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

public class AdCreativeLinkDataChildAttachment
extends APINode {
    @SerializedName(value="call_to_action")
    private AdCreativeLinkDataCallToAction mCallToAction = null;
    @SerializedName(value="caption")
    private String mCaption = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="image_crops")
    private AdsImageCrops mImageCrops = null;
    @SerializedName(value="image_hash")
    private String mImageHash = null;
    @SerializedName(value="link")
    private String mLink = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="picture")
    private String mPicture = null;
    @SerializedName(value="place_data")
    private AdCreativePlaceData mPlaceData = null;
    @SerializedName(value="static_card")
    private Boolean mStaticCard = null;
    @SerializedName(value="video_id")
    private String mVideoId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdCreativeLinkDataChildAttachment loadJSON(String json, APIContext context, String header) {
        AdCreativeLinkDataChildAttachment adCreativeLinkDataChildAttachment = (AdCreativeLinkDataChildAttachment)AdCreativeLinkDataChildAttachment.getGson().fromJson(json, AdCreativeLinkDataChildAttachment.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCreativeLinkDataChildAttachment.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCreativeLinkDataChildAttachment.context = context;
        adCreativeLinkDataChildAttachment.rawValue = json;
        adCreativeLinkDataChildAttachment.header = header;
        return adCreativeLinkDataChildAttachment;
    }

    public static APINodeList<AdCreativeLinkDataChildAttachment> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCreativeLinkDataChildAttachment> adCreativeLinkDataChildAttachments = new APINodeList<AdCreativeLinkDataChildAttachment>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCreativeLinkDataChildAttachments.add(AdCreativeLinkDataChildAttachment.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adCreativeLinkDataChildAttachments;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCreativeLinkDataChildAttachments.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCreativeLinkDataChildAttachments.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCreativeLinkDataChildAttachments.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCreativeLinkDataChildAttachments.add(AdCreativeLinkDataChildAttachment.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCreativeLinkDataChildAttachments.add(AdCreativeLinkDataChildAttachment.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCreativeLinkDataChildAttachments.add(AdCreativeLinkDataChildAttachment.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adCreativeLinkDataChildAttachments;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCreativeLinkDataChildAttachments.add(AdCreativeLinkDataChildAttachment.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adCreativeLinkDataChildAttachments;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCreativeLinkDataChildAttachments.add(AdCreativeLinkDataChildAttachment.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCreativeLinkDataChildAttachments;
                }
                adCreativeLinkDataChildAttachments.clear();
                adCreativeLinkDataChildAttachments.add(AdCreativeLinkDataChildAttachment.loadJSON(json, context, header));
                return adCreativeLinkDataChildAttachments;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCreativeLinkDataChildAttachment.getGson().toJson((Object)this);
    }

    public AdCreativeLinkDataCallToAction getFieldCallToAction() {
        return this.mCallToAction;
    }

    public AdCreativeLinkDataChildAttachment setFieldCallToAction(AdCreativeLinkDataCallToAction value) {
        this.mCallToAction = value;
        return this;
    }

    public AdCreativeLinkDataChildAttachment setFieldCallToAction(String value) {
        Type type = new TypeToken<AdCreativeLinkDataCallToAction>(){}.getType();
        this.mCallToAction = (AdCreativeLinkDataCallToAction)AdCreativeLinkDataCallToAction.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldCaption() {
        return this.mCaption;
    }

    public AdCreativeLinkDataChildAttachment setFieldCaption(String value) {
        this.mCaption = value;
        return this;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public AdCreativeLinkDataChildAttachment setFieldDescription(String value) {
        this.mDescription = value;
        return this;
    }

    public AdsImageCrops getFieldImageCrops() {
        return this.mImageCrops;
    }

    public AdCreativeLinkDataChildAttachment setFieldImageCrops(AdsImageCrops value) {
        this.mImageCrops = value;
        return this;
    }

    public AdCreativeLinkDataChildAttachment setFieldImageCrops(String value) {
        Type type = new TypeToken<AdsImageCrops>(){}.getType();
        this.mImageCrops = (AdsImageCrops)AdsImageCrops.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldImageHash() {
        return this.mImageHash;
    }

    public AdCreativeLinkDataChildAttachment setFieldImageHash(String value) {
        this.mImageHash = value;
        return this;
    }

    public String getFieldLink() {
        return this.mLink;
    }

    public AdCreativeLinkDataChildAttachment setFieldLink(String value) {
        this.mLink = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public AdCreativeLinkDataChildAttachment setFieldName(String value) {
        this.mName = value;
        return this;
    }

    public String getFieldPicture() {
        return this.mPicture;
    }

    public AdCreativeLinkDataChildAttachment setFieldPicture(String value) {
        this.mPicture = value;
        return this;
    }

    public AdCreativePlaceData getFieldPlaceData() {
        return this.mPlaceData;
    }

    public AdCreativeLinkDataChildAttachment setFieldPlaceData(AdCreativePlaceData value) {
        this.mPlaceData = value;
        return this;
    }

    public AdCreativeLinkDataChildAttachment setFieldPlaceData(String value) {
        Type type = new TypeToken<AdCreativePlaceData>(){}.getType();
        this.mPlaceData = (AdCreativePlaceData)AdCreativePlaceData.getGson().fromJson(value, type);
        return this;
    }

    public Boolean getFieldStaticCard() {
        return this.mStaticCard;
    }

    public AdCreativeLinkDataChildAttachment setFieldStaticCard(Boolean value) {
        this.mStaticCard = value;
        return this;
    }

    public String getFieldVideoId() {
        return this.mVideoId;
    }

    public AdCreativeLinkDataChildAttachment setFieldVideoId(String value) {
        this.mVideoId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCreativeLinkDataChildAttachment copyFrom(AdCreativeLinkDataChildAttachment instance) {
        this.mCallToAction = instance.mCallToAction;
        this.mCaption = instance.mCaption;
        this.mDescription = instance.mDescription;
        this.mImageCrops = instance.mImageCrops;
        this.mImageHash = instance.mImageHash;
        this.mLink = instance.mLink;
        this.mName = instance.mName;
        this.mPicture = instance.mPicture;
        this.mPlaceData = instance.mPlaceData;
        this.mStaticCard = instance.mStaticCard;
        this.mVideoId = instance.mVideoId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCreativeLinkDataChildAttachment> getParser() {
        return new APIRequest.ResponseParser<AdCreativeLinkDataChildAttachment>(){

            @Override
            public APINodeList<AdCreativeLinkDataChildAttachment> parseResponse(String response, APIContext context, APIRequest<AdCreativeLinkDataChildAttachment> request, String header) throws APIException.MalformedResponseException {
                return AdCreativeLinkDataChildAttachment.parseResponse(response, context, request, header);
            }
        };
    }
}

