/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.CommerceOrder;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommerceOrderTransactionDetail
extends APINode {
    @SerializedName(value="net_payment_amount")
    private Object mNetPaymentAmount = null;
    @SerializedName(value="order_details")
    private CommerceOrder mOrderDetails = null;
    @SerializedName(value="payout_reference_id")
    private String mPayoutReferenceId = null;
    @SerializedName(value="processing_fee")
    private Object mProcessingFee = null;
    @SerializedName(value="tax_rate")
    private String mTaxRate = null;
    @SerializedName(value="transaction_date")
    private String mTransactionDate = null;
    @SerializedName(value="transaction_type")
    private String mTransactionType = null;
    @SerializedName(value="transfer_id")
    private String mTransferId = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CommerceOrderTransactionDetail loadJSON(String json, APIContext context, String header) {
        CommerceOrderTransactionDetail commerceOrderTransactionDetail = (CommerceOrderTransactionDetail)CommerceOrderTransactionDetail.getGson().fromJson(json, CommerceOrderTransactionDetail.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(commerceOrderTransactionDetail.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        commerceOrderTransactionDetail.context = context;
        commerceOrderTransactionDetail.rawValue = json;
        commerceOrderTransactionDetail.header = header;
        return commerceOrderTransactionDetail;
    }

    public static APINodeList<CommerceOrderTransactionDetail> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CommerceOrderTransactionDetail> commerceOrderTransactionDetails = new APINodeList<CommerceOrderTransactionDetail>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        commerceOrderTransactionDetails.add(CommerceOrderTransactionDetail.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return commerceOrderTransactionDetails;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            commerceOrderTransactionDetails.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        commerceOrderTransactionDetails.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            commerceOrderTransactionDetails.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            commerceOrderTransactionDetails.add(CommerceOrderTransactionDetail.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                commerceOrderTransactionDetails.add(CommerceOrderTransactionDetail.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            commerceOrderTransactionDetails.add(CommerceOrderTransactionDetail.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return commerceOrderTransactionDetails;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        commerceOrderTransactionDetails.add(CommerceOrderTransactionDetail.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return commerceOrderTransactionDetails;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        commerceOrderTransactionDetails.add(CommerceOrderTransactionDetail.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return commerceOrderTransactionDetails;
                }
                commerceOrderTransactionDetails.clear();
                commerceOrderTransactionDetails.add(CommerceOrderTransactionDetail.loadJSON(json, context, header));
                return commerceOrderTransactionDetails;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CommerceOrderTransactionDetail.getGson().toJson((Object)this);
    }

    public APIRequestGetItems getItems() {
        return new APIRequestGetItems(this.getId(), this.context);
    }

    public APIRequestGetTaxDetails getTaxDetails() {
        return new APIRequestGetTaxDetails(this.getId(), this.context);
    }

    public Object getFieldNetPaymentAmount() {
        return this.mNetPaymentAmount;
    }

    public CommerceOrderTransactionDetail setFieldNetPaymentAmount(Object value) {
        this.mNetPaymentAmount = value;
        return this;
    }

    public CommerceOrder getFieldOrderDetails() {
        if (this.mOrderDetails != null) {
            this.mOrderDetails.context = this.getContext();
        }
        return this.mOrderDetails;
    }

    public CommerceOrderTransactionDetail setFieldOrderDetails(CommerceOrder value) {
        this.mOrderDetails = value;
        return this;
    }

    public CommerceOrderTransactionDetail setFieldOrderDetails(String value) {
        Type type = new TypeToken<CommerceOrder>(){}.getType();
        this.mOrderDetails = (CommerceOrder)CommerceOrder.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldPayoutReferenceId() {
        return this.mPayoutReferenceId;
    }

    public CommerceOrderTransactionDetail setFieldPayoutReferenceId(String value) {
        this.mPayoutReferenceId = value;
        return this;
    }

    public Object getFieldProcessingFee() {
        return this.mProcessingFee;
    }

    public CommerceOrderTransactionDetail setFieldProcessingFee(Object value) {
        this.mProcessingFee = value;
        return this;
    }

    public String getFieldTaxRate() {
        return this.mTaxRate;
    }

    public CommerceOrderTransactionDetail setFieldTaxRate(String value) {
        this.mTaxRate = value;
        return this;
    }

    public String getFieldTransactionDate() {
        return this.mTransactionDate;
    }

    public CommerceOrderTransactionDetail setFieldTransactionDate(String value) {
        this.mTransactionDate = value;
        return this;
    }

    public String getFieldTransactionType() {
        return this.mTransactionType;
    }

    public CommerceOrderTransactionDetail setFieldTransactionType(String value) {
        this.mTransactionType = value;
        return this;
    }

    public String getFieldTransferId() {
        return this.mTransferId;
    }

    public CommerceOrderTransactionDetail setFieldTransferId(String value) {
        this.mTransferId = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public CommerceOrderTransactionDetail setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CommerceOrderTransactionDetail copyFrom(CommerceOrderTransactionDetail instance) {
        this.mNetPaymentAmount = instance.mNetPaymentAmount;
        this.mOrderDetails = instance.mOrderDetails;
        this.mPayoutReferenceId = instance.mPayoutReferenceId;
        this.mProcessingFee = instance.mProcessingFee;
        this.mTaxRate = instance.mTaxRate;
        this.mTransactionDate = instance.mTransactionDate;
        this.mTransactionType = instance.mTransactionType;
        this.mTransferId = instance.mTransferId;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CommerceOrderTransactionDetail> getParser() {
        return new APIRequest.ResponseParser<CommerceOrderTransactionDetail>(){

            @Override
            public APINodeList<CommerceOrderTransactionDetail> parseResponse(String response, APIContext context, APIRequest<CommerceOrderTransactionDetail> request, String header) throws APIException.MalformedResponseException {
                return CommerceOrderTransactionDetail.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGetTaxDetails
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetTaxDetails(String nodeId, APIContext context) {
            super(context, nodeId, "/tax_details", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetTaxDetails setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetTaxDetails setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetTaxDetails requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetTaxDetails requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTaxDetails requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetTaxDetails requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTaxDetails requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetTaxDetails requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetItems
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetItems(String nodeId, APIContext context) {
            super(context, nodeId, "/items", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetItems setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetItems setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetItems requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetItems requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetItems requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetItems requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetItems requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetItems requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

