/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.User;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class Experience
extends APINode {
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="from")
    private User mFrom = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="with")
    private List<User> mWith = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static Experience loadJSON(String json, APIContext context, String header) {
        Experience experience = (Experience)Experience.getGson().fromJson(json, Experience.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(experience.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        experience.context = context;
        experience.rawValue = json;
        experience.header = header;
        return experience;
    }

    public static APINodeList<Experience> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<Experience> experiences = new APINodeList<Experience>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        experiences.add(Experience.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return experiences;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            experiences.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        experiences.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            experiences.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            experiences.add(Experience.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                experiences.add(Experience.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            experiences.add(Experience.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return experiences;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        experiences.add(Experience.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return experiences;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        experiences.add(Experience.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return experiences;
                }
                experiences.clear();
                experiences.add(Experience.loadJSON(json, context, header));
                return experiences;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Experience.getGson().toJson((Object)this);
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public Experience setFieldDescription(String value) {
        this.mDescription = value;
        return this;
    }

    public User getFieldFrom() {
        if (this.mFrom != null) {
            this.mFrom.context = this.getContext();
        }
        return this.mFrom;
    }

    public Experience setFieldFrom(User value) {
        this.mFrom = value;
        return this;
    }

    public Experience setFieldFrom(String value) {
        Type type = new TypeToken<User>(){}.getType();
        this.mFrom = (User)User.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Experience setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Experience setFieldName(String value) {
        this.mName = value;
        return this;
    }

    public List<User> getFieldWith() {
        return this.mWith;
    }

    public Experience setFieldWith(List<User> value) {
        this.mWith = value;
        return this;
    }

    public Experience setFieldWith(String value) {
        Type type = new TypeToken<List<User>>(){}.getType();
        this.mWith = (List)User.getGson().fromJson(value, type);
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Experience copyFrom(Experience instance) {
        this.mDescription = instance.mDescription;
        this.mFrom = instance.mFrom;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.mWith = instance.mWith;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Experience> getParser() {
        return new APIRequest.ResponseParser<Experience>(){

            @Override
            public APINodeList<Experience> parseResponse(String response, APIContext context, APIRequest<Experience> request, String header) throws APIException.MalformedResponseException {
                return Experience.parseResponse(response, context, request, header);
            }
        };
    }
}

