/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AtlasCampaign;
import com.facebook.ads.sdk.BilledAmountDetails;
import com.facebook.ads.sdk.CurrencyAmount;
import com.facebook.ads.sdk.InvoiceCampaign;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OmegaCustomerTrx
extends APINode {
    @SerializedName(value="ad_account_ids")
    private List<String> mAdAccountIds = null;
    @SerializedName(value="advertiser_name")
    private String mAdvertiserName = null;
    @SerializedName(value="amount")
    private String mAmount = null;
    @SerializedName(value="amount_due")
    private CurrencyAmount mAmountDue = null;
    @SerializedName(value="billed_amount_details")
    private BilledAmountDetails mBilledAmountDetails = null;
    @SerializedName(value="billing_period")
    private String mBillingPeriod = null;
    @SerializedName(value="campaign")
    private AtlasCampaign mCampaign = null;
    @SerializedName(value="cdn_download_uri")
    private String mCdnDownloadUri = null;
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="download_uri")
    private String mDownloadUri = null;
    @SerializedName(value="due_date")
    private String mDueDate = null;
    @SerializedName(value="entity")
    private String mEntity = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="invoice_date")
    private String mInvoiceDate = null;
    @SerializedName(value="invoice_id")
    private String mInvoiceId = null;
    @SerializedName(value="invoice_type")
    private String mInvoiceType = null;
    @SerializedName(value="liability_type")
    private String mLiabilityType = null;
    @SerializedName(value="payment_status")
    private String mPaymentStatus = null;
    @SerializedName(value="payment_term")
    private String mPaymentTerm = null;
    @SerializedName(value="type")
    private String mType = null;
    protected static Gson gson = null;

    OmegaCustomerTrx() {
    }

    public OmegaCustomerTrx(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public OmegaCustomerTrx(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public OmegaCustomerTrx fetch() throws APIException {
        OmegaCustomerTrx newInstance = OmegaCustomerTrx.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static OmegaCustomerTrx fetchById(Long id, APIContext context) throws APIException {
        return OmegaCustomerTrx.fetchById(id.toString(), context);
    }

    public static ListenableFuture<OmegaCustomerTrx> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return OmegaCustomerTrx.fetchByIdAsync(id.toString(), context);
    }

    public static OmegaCustomerTrx fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<OmegaCustomerTrx> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<OmegaCustomerTrx> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<OmegaCustomerTrx>(context, "", "/", "GET", OmegaCustomerTrx.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<OmegaCustomerTrx>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<OmegaCustomerTrx>(context, "", "/", "GET", OmegaCustomerTrx.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static OmegaCustomerTrx loadJSON(String json, APIContext context, String header) {
        OmegaCustomerTrx omegaCustomerTrx = (OmegaCustomerTrx)OmegaCustomerTrx.getGson().fromJson(json, OmegaCustomerTrx.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(omegaCustomerTrx.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        omegaCustomerTrx.context = context;
        omegaCustomerTrx.rawValue = json;
        omegaCustomerTrx.header = header;
        return omegaCustomerTrx;
    }

    public static APINodeList<OmegaCustomerTrx> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<OmegaCustomerTrx> omegaCustomerTrxs = new APINodeList<OmegaCustomerTrx>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        omegaCustomerTrxs.add(OmegaCustomerTrx.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return omegaCustomerTrxs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            omegaCustomerTrxs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        omegaCustomerTrxs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            omegaCustomerTrxs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            omegaCustomerTrxs.add(OmegaCustomerTrx.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                omegaCustomerTrxs.add(OmegaCustomerTrx.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            omegaCustomerTrxs.add(OmegaCustomerTrx.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return omegaCustomerTrxs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        omegaCustomerTrxs.add(OmegaCustomerTrx.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return omegaCustomerTrxs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        omegaCustomerTrxs.add(OmegaCustomerTrx.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return omegaCustomerTrxs;
                }
                omegaCustomerTrxs.clear();
                omegaCustomerTrxs.add(OmegaCustomerTrx.loadJSON(json, context, header));
                return omegaCustomerTrxs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return OmegaCustomerTrx.getGson().toJson((Object)this);
    }

    public APIRequestGetCampaigns getCampaigns() {
        return new APIRequestGetCampaigns(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<String> getFieldAdAccountIds() {
        return this.mAdAccountIds;
    }

    public String getFieldAdvertiserName() {
        return this.mAdvertiserName;
    }

    public String getFieldAmount() {
        return this.mAmount;
    }

    public CurrencyAmount getFieldAmountDue() {
        return this.mAmountDue;
    }

    public BilledAmountDetails getFieldBilledAmountDetails() {
        return this.mBilledAmountDetails;
    }

    public String getFieldBillingPeriod() {
        return this.mBillingPeriod;
    }

    public AtlasCampaign getFieldCampaign() {
        if (this.mCampaign != null) {
            this.mCampaign.context = this.getContext();
        }
        return this.mCampaign;
    }

    public String getFieldCdnDownloadUri() {
        return this.mCdnDownloadUri;
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public String getFieldDownloadUri() {
        return this.mDownloadUri;
    }

    public String getFieldDueDate() {
        return this.mDueDate;
    }

    public String getFieldEntity() {
        return this.mEntity;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldInvoiceDate() {
        return this.mInvoiceDate;
    }

    public String getFieldInvoiceId() {
        return this.mInvoiceId;
    }

    public String getFieldInvoiceType() {
        return this.mInvoiceType;
    }

    public String getFieldLiabilityType() {
        return this.mLiabilityType;
    }

    public String getFieldPaymentStatus() {
        return this.mPaymentStatus;
    }

    public String getFieldPaymentTerm() {
        return this.mPaymentTerm;
    }

    public String getFieldType() {
        return this.mType;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public OmegaCustomerTrx copyFrom(OmegaCustomerTrx instance) {
        this.mAdAccountIds = instance.mAdAccountIds;
        this.mAdvertiserName = instance.mAdvertiserName;
        this.mAmount = instance.mAmount;
        this.mAmountDue = instance.mAmountDue;
        this.mBilledAmountDetails = instance.mBilledAmountDetails;
        this.mBillingPeriod = instance.mBillingPeriod;
        this.mCampaign = instance.mCampaign;
        this.mCdnDownloadUri = instance.mCdnDownloadUri;
        this.mCurrency = instance.mCurrency;
        this.mDownloadUri = instance.mDownloadUri;
        this.mDueDate = instance.mDueDate;
        this.mEntity = instance.mEntity;
        this.mId = instance.mId;
        this.mInvoiceDate = instance.mInvoiceDate;
        this.mInvoiceId = instance.mInvoiceId;
        this.mInvoiceType = instance.mInvoiceType;
        this.mLiabilityType = instance.mLiabilityType;
        this.mPaymentStatus = instance.mPaymentStatus;
        this.mPaymentTerm = instance.mPaymentTerm;
        this.mType = instance.mType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<OmegaCustomerTrx> getParser() {
        return new APIRequest.ResponseParser<OmegaCustomerTrx>(){

            @Override
            public APINodeList<OmegaCustomerTrx> parseResponse(String response, APIContext context, APIRequest<OmegaCustomerTrx> request, String header) throws APIException.MalformedResponseException {
                return OmegaCustomerTrx.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumType {
        VALUE_CM("CM"),
        VALUE_DM("DM"),
        VALUE_INV("INV"),
        VALUE_PRO_FORMA("PRO_FORMA");

        private String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestGet
    extends APIRequest<OmegaCustomerTrx> {
        OmegaCustomerTrx lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ad_account_ids", "advertiser_name", "amount", "amount_due", "billed_amount_details", "billing_period", "campaign", "cdn_download_uri", "currency", "download_uri", "due_date", "entity", "id", "invoice_date", "invoice_id", "invoice_type", "liability_type", "payment_status", "payment_term", "type"};

        @Override
        public OmegaCustomerTrx getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public OmegaCustomerTrx parseResponse(String response, String header) throws APIException {
            return OmegaCustomerTrx.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public OmegaCustomerTrx execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public OmegaCustomerTrx execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<OmegaCustomerTrx> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<OmegaCustomerTrx> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, OmegaCustomerTrx>(){

                public OmegaCustomerTrx apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdAccountIdsField() {
            return this.requestAdAccountIdsField(true);
        }

        public APIRequestGet requestAdAccountIdsField(boolean value) {
            this.requestField("ad_account_ids", value);
            return this;
        }

        public APIRequestGet requestAdvertiserNameField() {
            return this.requestAdvertiserNameField(true);
        }

        public APIRequestGet requestAdvertiserNameField(boolean value) {
            this.requestField("advertiser_name", value);
            return this;
        }

        public APIRequestGet requestAmountField() {
            return this.requestAmountField(true);
        }

        public APIRequestGet requestAmountField(boolean value) {
            this.requestField("amount", value);
            return this;
        }

        public APIRequestGet requestAmountDueField() {
            return this.requestAmountDueField(true);
        }

        public APIRequestGet requestAmountDueField(boolean value) {
            this.requestField("amount_due", value);
            return this;
        }

        public APIRequestGet requestBilledAmountDetailsField() {
            return this.requestBilledAmountDetailsField(true);
        }

        public APIRequestGet requestBilledAmountDetailsField(boolean value) {
            this.requestField("billed_amount_details", value);
            return this;
        }

        public APIRequestGet requestBillingPeriodField() {
            return this.requestBillingPeriodField(true);
        }

        public APIRequestGet requestBillingPeriodField(boolean value) {
            this.requestField("billing_period", value);
            return this;
        }

        public APIRequestGet requestCampaignField() {
            return this.requestCampaignField(true);
        }

        public APIRequestGet requestCampaignField(boolean value) {
            this.requestField("campaign", value);
            return this;
        }

        public APIRequestGet requestCdnDownloadUriField() {
            return this.requestCdnDownloadUriField(true);
        }

        public APIRequestGet requestCdnDownloadUriField(boolean value) {
            this.requestField("cdn_download_uri", value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestDownloadUriField() {
            return this.requestDownloadUriField(true);
        }

        public APIRequestGet requestDownloadUriField(boolean value) {
            this.requestField("download_uri", value);
            return this;
        }

        public APIRequestGet requestDueDateField() {
            return this.requestDueDateField(true);
        }

        public APIRequestGet requestDueDateField(boolean value) {
            this.requestField("due_date", value);
            return this;
        }

        public APIRequestGet requestEntityField() {
            return this.requestEntityField(true);
        }

        public APIRequestGet requestEntityField(boolean value) {
            this.requestField("entity", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestInvoiceDateField() {
            return this.requestInvoiceDateField(true);
        }

        public APIRequestGet requestInvoiceDateField(boolean value) {
            this.requestField("invoice_date", value);
            return this;
        }

        public APIRequestGet requestInvoiceIdField() {
            return this.requestInvoiceIdField(true);
        }

        public APIRequestGet requestInvoiceIdField(boolean value) {
            this.requestField("invoice_id", value);
            return this;
        }

        public APIRequestGet requestInvoiceTypeField() {
            return this.requestInvoiceTypeField(true);
        }

        public APIRequestGet requestInvoiceTypeField(boolean value) {
            this.requestField("invoice_type", value);
            return this;
        }

        public APIRequestGet requestLiabilityTypeField() {
            return this.requestLiabilityTypeField(true);
        }

        public APIRequestGet requestLiabilityTypeField(boolean value) {
            this.requestField("liability_type", value);
            return this;
        }

        public APIRequestGet requestPaymentStatusField() {
            return this.requestPaymentStatusField(true);
        }

        public APIRequestGet requestPaymentStatusField(boolean value) {
            this.requestField("payment_status", value);
            return this;
        }

        public APIRequestGet requestPaymentTermField() {
            return this.requestPaymentTermField(true);
        }

        public APIRequestGet requestPaymentTermField(boolean value) {
            this.requestField("payment_term", value);
            return this;
        }

        public APIRequestGet requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGet requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }
    }

    public static class APIRequestGetCampaigns
    extends APIRequest<InvoiceCampaign> {
        APINodeList<InvoiceCampaign> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ad_account_id", "billed_amount_details", "campaign_id", "campaign_name", "clicks", "conversions", "description", "impressions", "tags"};

        @Override
        public APINodeList<InvoiceCampaign> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<InvoiceCampaign> parseResponse(String response, String header) throws APIException {
            return InvoiceCampaign.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<InvoiceCampaign> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<InvoiceCampaign> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<InvoiceCampaign>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<InvoiceCampaign>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<InvoiceCampaign>>(){

                public APINodeList<InvoiceCampaign> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetCampaigns(String nodeId, APIContext context) {
            super(context, nodeId, "/campaigns", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetCampaigns setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetCampaigns setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetCampaigns requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetCampaigns requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCampaigns requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetCampaigns requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCampaigns requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetCampaigns requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetCampaigns requestAdAccountIdField() {
            return this.requestAdAccountIdField(true);
        }

        public APIRequestGetCampaigns requestAdAccountIdField(boolean value) {
            this.requestField("ad_account_id", value);
            return this;
        }

        public APIRequestGetCampaigns requestBilledAmountDetailsField() {
            return this.requestBilledAmountDetailsField(true);
        }

        public APIRequestGetCampaigns requestBilledAmountDetailsField(boolean value) {
            this.requestField("billed_amount_details", value);
            return this;
        }

        public APIRequestGetCampaigns requestCampaignIdField() {
            return this.requestCampaignIdField(true);
        }

        public APIRequestGetCampaigns requestCampaignIdField(boolean value) {
            this.requestField("campaign_id", value);
            return this;
        }

        public APIRequestGetCampaigns requestCampaignNameField() {
            return this.requestCampaignNameField(true);
        }

        public APIRequestGetCampaigns requestCampaignNameField(boolean value) {
            this.requestField("campaign_name", value);
            return this;
        }

        public APIRequestGetCampaigns requestClicksField() {
            return this.requestClicksField(true);
        }

        public APIRequestGetCampaigns requestClicksField(boolean value) {
            this.requestField("clicks", value);
            return this;
        }

        public APIRequestGetCampaigns requestConversionsField() {
            return this.requestConversionsField(true);
        }

        public APIRequestGetCampaigns requestConversionsField(boolean value) {
            this.requestField("conversions", value);
            return this;
        }

        public APIRequestGetCampaigns requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetCampaigns requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetCampaigns requestImpressionsField() {
            return this.requestImpressionsField(true);
        }

        public APIRequestGetCampaigns requestImpressionsField(boolean value) {
            this.requestField("impressions", value);
            return this;
        }

        public APIRequestGetCampaigns requestTagsField() {
            return this.requestTagsField(true);
        }

        public APIRequestGetCampaigns requestTagsField(boolean value) {
            this.requestField("tags", value);
            return this;
        }
    }
}

