/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 */

package com.facebook.ads.sdk;

import java.io.File;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.gson.JsonObject;
import com.google.gson.JsonArray;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;

import com.facebook.ads.sdk.APIException.MalformedResponseException;

/**
 * This class is auto-generated.
 *
 * For any issues or feature requests related to this class, please let us know
 * on github and we'll fix in our codegen framework. We'll not be able to accept
 * pull request for this class.
 *
 */
public class PaymentRequestDetails extends APINode {
  @SerializedName("amount")
  private Object mAmount = null;
  @SerializedName("creation_time")
  private Long mCreationTime = null;
  @SerializedName("note")
  private String mNote = null;
  @SerializedName("payment_request_id")
  private String mPaymentRequestId = null;
  @SerializedName("receiver_id")
  private String mReceiverId = null;
  @SerializedName("reference_number")
  private String mReferenceNumber = null;
  @SerializedName("sender_id")
  private String mSenderId = null;
  @SerializedName("status")
  private String mStatus = null;
  @SerializedName("transaction_time")
  private Long mTransactionTime = null;
  protected static Gson gson = null;

  public PaymentRequestDetails() {
  }

  public String getId() {
    return null;
  }
  public static PaymentRequestDetails loadJSON(String json, APIContext context, String header) {
    PaymentRequestDetails paymentRequestDetails = getGson().fromJson(json, PaymentRequestDetails.class);
    if (context.isDebug()) {
      JsonParser parser = new JsonParser();
      JsonElement o1 = parser.parse(json);
      JsonElement o2 = parser.parse(paymentRequestDetails.toString());
      if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
        o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
      }
      if (!o1.equals(o2)) {
        context.log("[Warning] When parsing response, object is not consistent with JSON:");
        context.log("[JSON]" + o1);
        context.log("[Object]" + o2);
      }
    }
    paymentRequestDetails.context = context;
    paymentRequestDetails.rawValue = json;
    paymentRequestDetails.header = header;
    return paymentRequestDetails;
  }

  public static APINodeList<PaymentRequestDetails> parseResponse(String json, APIContext context, APIRequest request, String header) throws MalformedResponseException {
    APINodeList<PaymentRequestDetails> paymentRequestDetailss = new APINodeList<PaymentRequestDetails>(request, json, header);
    JsonArray arr;
    JsonObject obj;
    JsonParser parser = new JsonParser();
    Exception exception = null;
    try{
      JsonElement result = parser.parse(json);
      if (result.isJsonArray()) {
        // First, check if it's a pure JSON Array
        arr = result.getAsJsonArray();
        for (int i = 0; i < arr.size(); i++) {
          paymentRequestDetailss.add(loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
        };
        return paymentRequestDetailss;
      } else if (result.isJsonObject()) {
        obj = result.getAsJsonObject();
        if (obj.has("data")) {
          if (obj.has("paging")) {
            JsonObject paging = obj.get("paging").getAsJsonObject();
            if (paging.has("cursors")) {
                JsonObject cursors = paging.get("cursors").getAsJsonObject();
                String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                paymentRequestDetailss.setCursors(before, after);
            }
            String previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
            String next = paging.has("next") ? paging.get("next").getAsString() : null;
            paymentRequestDetailss.setPaging(previous, next);
            if (context.hasAppSecret()) {
              paymentRequestDetailss.setAppSecret(context.getAppSecretProof());
            }
          }
          if (obj.get("data").isJsonArray()) {
            // Second, check if it's a JSON array with "data"
            arr = obj.get("data").getAsJsonArray();
            for (int i = 0; i < arr.size(); i++) {
              paymentRequestDetailss.add(loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
            };
          } else if (obj.get("data").isJsonObject()) {
            // Third, check if it's a JSON object with "data"
            obj = obj.get("data").getAsJsonObject();
            boolean isRedownload = false;
            for (String s : new String[]{"campaigns", "adsets", "ads"}) {
              if (obj.has(s)) {
                isRedownload = true;
                obj = obj.getAsJsonObject(s);
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                  paymentRequestDetailss.add(loadJSON(entry.getValue().toString(), context, header));
                }
                break;
              }
            }
            if (!isRedownload) {
              paymentRequestDetailss.add(loadJSON(obj.toString(), context, header));
            }
          }
          return paymentRequestDetailss;
        } else if (obj.has("images")) {
          // Fourth, check if it's a map of image objects
          obj = obj.get("images").getAsJsonObject();
          for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
              paymentRequestDetailss.add(loadJSON(entry.getValue().toString(), context, header));
          }
          return paymentRequestDetailss;
        } else {
          // Fifth, check if it's an array of objects indexed by id
          boolean isIdIndexedArray = true;
          for (Map.Entry entry : obj.entrySet()) {
            String key = (String) entry.getKey();
            if (key.equals("__fb_trace_id__")) {
              continue;
            }
            JsonElement value = (JsonElement) entry.getValue();
            if (
              value != null &&
              value.isJsonObject() &&
              value.getAsJsonObject().has("id") &&
              value.getAsJsonObject().get("id") != null &&
              value.getAsJsonObject().get("id").getAsString().equals(key)
            ) {
              paymentRequestDetailss.add(loadJSON(value.toString(), context, header));
            } else {
              isIdIndexedArray = false;
              break;
            }
          }
          if (isIdIndexedArray) {
            return paymentRequestDetailss;
          }

          // Sixth, check if it's pure JsonObject
          paymentRequestDetailss.clear();
          paymentRequestDetailss.add(loadJSON(json, context, header));
          return paymentRequestDetailss;
        }
      }
    } catch (Exception e) {
      exception = e;
    }
    throw new MalformedResponseException(
      "Invalid response string: " + json,
      exception
    );
  }

  @Override
  public APIContext getContext() {
    return context;
  }

  @Override
  public void setContext(APIContext context) {
    this.context = context;
  }

  @Override
  public String toString() {
    return getGson().toJson(this);
  }


  public Object getFieldAmount() {
    return mAmount;
  }

  public PaymentRequestDetails setFieldAmount(Object value) {
    this.mAmount = value;
    return this;
  }

  public Long getFieldCreationTime() {
    return mCreationTime;
  }

  public PaymentRequestDetails setFieldCreationTime(Long value) {
    this.mCreationTime = value;
    return this;
  }

  public String getFieldNote() {
    return mNote;
  }

  public PaymentRequestDetails setFieldNote(String value) {
    this.mNote = value;
    return this;
  }

  public String getFieldPaymentRequestId() {
    return mPaymentRequestId;
  }

  public PaymentRequestDetails setFieldPaymentRequestId(String value) {
    this.mPaymentRequestId = value;
    return this;
  }

  public String getFieldReceiverId() {
    return mReceiverId;
  }

  public PaymentRequestDetails setFieldReceiverId(String value) {
    this.mReceiverId = value;
    return this;
  }

  public String getFieldReferenceNumber() {
    return mReferenceNumber;
  }

  public PaymentRequestDetails setFieldReferenceNumber(String value) {
    this.mReferenceNumber = value;
    return this;
  }

  public String getFieldSenderId() {
    return mSenderId;
  }

  public PaymentRequestDetails setFieldSenderId(String value) {
    this.mSenderId = value;
    return this;
  }

  public String getFieldStatus() {
    return mStatus;
  }

  public PaymentRequestDetails setFieldStatus(String value) {
    this.mStatus = value;
    return this;
  }

  public Long getFieldTransactionTime() {
    return mTransactionTime;
  }

  public PaymentRequestDetails setFieldTransactionTime(Long value) {
    this.mTransactionTime = value;
    return this;
  }




  synchronized /*package*/ static Gson getGson() {
    if (gson != null) {
      return gson;
    } else {
      gson = new GsonBuilder()
        .excludeFieldsWithModifiers(Modifier.STATIC)
        .excludeFieldsWithModifiers(Modifier.PROTECTED)
        .disableHtmlEscaping()
        .create();
    }
    return gson;
  }

  public PaymentRequestDetails copyFrom(PaymentRequestDetails instance) {
    this.mAmount = instance.mAmount;
    this.mCreationTime = instance.mCreationTime;
    this.mNote = instance.mNote;
    this.mPaymentRequestId = instance.mPaymentRequestId;
    this.mReceiverId = instance.mReceiverId;
    this.mReferenceNumber = instance.mReferenceNumber;
    this.mSenderId = instance.mSenderId;
    this.mStatus = instance.mStatus;
    this.mTransactionTime = instance.mTransactionTime;
    this.context = instance.context;
    this.rawValue = instance.rawValue;
    return this;
  }

  public static APIRequest.ResponseParser<PaymentRequestDetails> getParser() {
    return new APIRequest.ResponseParser<PaymentRequestDetails>() {
      public APINodeList<PaymentRequestDetails> parseResponse(String response, APIContext context, APIRequest<PaymentRequestDetails> request, String header) throws MalformedResponseException {
        return PaymentRequestDetails.parseResponse(response, context, request, header);
      }
    };
  }
}
