/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Page;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class MailingAddress
extends APINode {
    @SerializedName(value="city")
    private String mCity = null;
    @SerializedName(value="city_page")
    private Page mCityPage = null;
    @SerializedName(value="country")
    private String mCountry = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="postal_code")
    private String mPostalCode = null;
    @SerializedName(value="region")
    private String mRegion = null;
    @SerializedName(value="street1")
    private String mStreet1 = null;
    @SerializedName(value="street2")
    private String mStreet2 = null;
    protected static Gson gson = null;

    MailingAddress() {
    }

    public MailingAddress(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public MailingAddress(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public MailingAddress fetch() throws APIException {
        MailingAddress newInstance = MailingAddress.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static MailingAddress fetchById(Long id, APIContext context) throws APIException {
        return MailingAddress.fetchById(id.toString(), context);
    }

    public static ListenableFuture<MailingAddress> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return MailingAddress.fetchByIdAsync(id.toString(), context);
    }

    public static MailingAddress fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<MailingAddress> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<MailingAddress> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<MailingAddress>(context, "", "/", "GET", MailingAddress.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<MailingAddress>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<MailingAddress>(context, "", "/", "GET", MailingAddress.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static MailingAddress loadJSON(String json, APIContext context, String header) {
        MailingAddress mailingAddress = (MailingAddress)MailingAddress.getGson().fromJson(json, MailingAddress.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(mailingAddress.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        mailingAddress.context = context;
        mailingAddress.rawValue = json;
        mailingAddress.header = header;
        return mailingAddress;
    }

    public static APINodeList<MailingAddress> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<MailingAddress> mailingAddresss = new APINodeList<MailingAddress>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        mailingAddresss.add(MailingAddress.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return mailingAddresss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            mailingAddresss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        mailingAddresss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            mailingAddresss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            mailingAddresss.add(MailingAddress.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                mailingAddresss.add(MailingAddress.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            mailingAddresss.add(MailingAddress.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return mailingAddresss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        mailingAddresss.add(MailingAddress.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return mailingAddresss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        mailingAddresss.add(MailingAddress.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return mailingAddresss;
                }
                mailingAddresss.clear();
                mailingAddresss.add(MailingAddress.loadJSON(json, context, header));
                return mailingAddresss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return MailingAddress.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCity() {
        return this.mCity;
    }

    public Page getFieldCityPage() {
        if (this.mCityPage != null) {
            this.mCityPage.context = this.getContext();
        }
        return this.mCityPage;
    }

    public String getFieldCountry() {
        return this.mCountry;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldPostalCode() {
        return this.mPostalCode;
    }

    public String getFieldRegion() {
        return this.mRegion;
    }

    public String getFieldStreet1() {
        return this.mStreet1;
    }

    public String getFieldStreet2() {
        return this.mStreet2;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public MailingAddress copyFrom(MailingAddress instance) {
        this.mCity = instance.mCity;
        this.mCityPage = instance.mCityPage;
        this.mCountry = instance.mCountry;
        this.mId = instance.mId;
        this.mPostalCode = instance.mPostalCode;
        this.mRegion = instance.mRegion;
        this.mStreet1 = instance.mStreet1;
        this.mStreet2 = instance.mStreet2;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<MailingAddress> getParser() {
        return new APIRequest.ResponseParser<MailingAddress>(){

            @Override
            public APINodeList<MailingAddress> parseResponse(String response, APIContext context, APIRequest<MailingAddress> request, String header) throws APIException.MalformedResponseException {
                return MailingAddress.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<MailingAddress> {
        MailingAddress lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"city", "city_page", "country", "id", "postal_code", "region", "street1", "street2"};

        @Override
        public MailingAddress getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public MailingAddress parseResponse(String response, String header) throws APIException {
            return MailingAddress.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public MailingAddress execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public MailingAddress execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<MailingAddress> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<MailingAddress> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, MailingAddress>(){

                public MailingAddress apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCityField() {
            return this.requestCityField(true);
        }

        public APIRequestGet requestCityField(boolean value) {
            this.requestField("city", value);
            return this;
        }

        public APIRequestGet requestCityPageField() {
            return this.requestCityPageField(true);
        }

        public APIRequestGet requestCityPageField(boolean value) {
            this.requestField("city_page", value);
            return this;
        }

        public APIRequestGet requestCountryField() {
            return this.requestCountryField(true);
        }

        public APIRequestGet requestCountryField(boolean value) {
            this.requestField("country", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestPostalCodeField() {
            return this.requestPostalCodeField(true);
        }

        public APIRequestGet requestPostalCodeField(boolean value) {
            this.requestField("postal_code", value);
            return this;
        }

        public APIRequestGet requestRegionField() {
            return this.requestRegionField(true);
        }

        public APIRequestGet requestRegionField(boolean value) {
            this.requestField("region", value);
            return this;
        }

        public APIRequestGet requestStreet1Field() {
            return this.requestStreet1Field(true);
        }

        public APIRequestGet requestStreet1Field(boolean value) {
            this.requestField("street1", value);
            return this;
        }

        public APIRequestGet requestStreet2Field() {
            return this.requestStreet2Field(true);
        }

        public APIRequestGet requestStreet2Field(boolean value) {
            this.requestField("street2", value);
            return this;
        }
    }
}

