/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.VideoCopyrightRule;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class MusicWorkCopyright
extends APINode {
    @SerializedName(value="available_ui_actions")
    private List<String> mAvailableUiActions = null;
    @SerializedName(value="claim_status")
    private String mClaimStatus = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="displayed_fb_matches_count")
    private Long mDisplayedFbMatchesCount = null;
    @SerializedName(value="displayed_ig_matches_count")
    private Long mDisplayedIgMatchesCount = null;
    @SerializedName(value="displayed_matches_count")
    private Long mDisplayedMatchesCount = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="match_rule")
    private VideoCopyrightRule mMatchRule = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="tags")
    private List<String> mTags = null;
    @SerializedName(value="update_time")
    private String mUpdateTime = null;
    protected static Gson gson = null;

    MusicWorkCopyright() {
    }

    public MusicWorkCopyright(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public MusicWorkCopyright(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public MusicWorkCopyright fetch() throws APIException {
        MusicWorkCopyright newInstance = MusicWorkCopyright.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static MusicWorkCopyright fetchById(Long id, APIContext context) throws APIException {
        return MusicWorkCopyright.fetchById(id.toString(), context);
    }

    public static ListenableFuture<MusicWorkCopyright> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return MusicWorkCopyright.fetchByIdAsync(id.toString(), context);
    }

    public static MusicWorkCopyright fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<MusicWorkCopyright> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<MusicWorkCopyright> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<MusicWorkCopyright>(context, "", "/", "GET", MusicWorkCopyright.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<MusicWorkCopyright>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<MusicWorkCopyright>(context, "", "/", "GET", MusicWorkCopyright.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static MusicWorkCopyright loadJSON(String json, APIContext context, String header) {
        MusicWorkCopyright musicWorkCopyright = (MusicWorkCopyright)MusicWorkCopyright.getGson().fromJson(json, MusicWorkCopyright.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(musicWorkCopyright.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        musicWorkCopyright.context = context;
        musicWorkCopyright.rawValue = json;
        musicWorkCopyright.header = header;
        return musicWorkCopyright;
    }

    public static APINodeList<MusicWorkCopyright> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<MusicWorkCopyright> musicWorkCopyrights = new APINodeList<MusicWorkCopyright>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        musicWorkCopyrights.add(MusicWorkCopyright.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return musicWorkCopyrights;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            musicWorkCopyrights.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        musicWorkCopyrights.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            musicWorkCopyrights.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            musicWorkCopyrights.add(MusicWorkCopyright.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                musicWorkCopyrights.add(MusicWorkCopyright.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            musicWorkCopyrights.add(MusicWorkCopyright.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return musicWorkCopyrights;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        musicWorkCopyrights.add(MusicWorkCopyright.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return musicWorkCopyrights;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        musicWorkCopyrights.add(MusicWorkCopyright.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return musicWorkCopyrights;
                }
                musicWorkCopyrights.clear();
                musicWorkCopyrights.add(MusicWorkCopyright.loadJSON(json, context, header));
                return musicWorkCopyrights;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return MusicWorkCopyright.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<String> getFieldAvailableUiActions() {
        return this.mAvailableUiActions;
    }

    public String getFieldClaimStatus() {
        return this.mClaimStatus;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public Long getFieldDisplayedFbMatchesCount() {
        return this.mDisplayedFbMatchesCount;
    }

    public Long getFieldDisplayedIgMatchesCount() {
        return this.mDisplayedIgMatchesCount;
    }

    public Long getFieldDisplayedMatchesCount() {
        return this.mDisplayedMatchesCount;
    }

    public String getFieldId() {
        return this.mId;
    }

    public VideoCopyrightRule getFieldMatchRule() {
        if (this.mMatchRule != null) {
            this.mMatchRule.context = this.getContext();
        }
        return this.mMatchRule;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public List<String> getFieldTags() {
        return this.mTags;
    }

    public String getFieldUpdateTime() {
        return this.mUpdateTime;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public MusicWorkCopyright copyFrom(MusicWorkCopyright instance) {
        this.mAvailableUiActions = instance.mAvailableUiActions;
        this.mClaimStatus = instance.mClaimStatus;
        this.mCreationTime = instance.mCreationTime;
        this.mDisplayedFbMatchesCount = instance.mDisplayedFbMatchesCount;
        this.mDisplayedIgMatchesCount = instance.mDisplayedIgMatchesCount;
        this.mDisplayedMatchesCount = instance.mDisplayedMatchesCount;
        this.mId = instance.mId;
        this.mMatchRule = instance.mMatchRule;
        this.mStatus = instance.mStatus;
        this.mTags = instance.mTags;
        this.mUpdateTime = instance.mUpdateTime;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<MusicWorkCopyright> getParser() {
        return new APIRequest.ResponseParser<MusicWorkCopyright>(){

            @Override
            public APINodeList<MusicWorkCopyright> parseResponse(String response, APIContext context, APIRequest<MusicWorkCopyright> request, String header) throws APIException.MalformedResponseException {
                return MusicWorkCopyright.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<MusicWorkCopyright> {
        MusicWorkCopyright lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"available_ui_actions", "claim_status", "creation_time", "displayed_fb_matches_count", "displayed_ig_matches_count", "displayed_matches_count", "id", "match_rule", "status", "tags", "update_time"};

        @Override
        public MusicWorkCopyright getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public MusicWorkCopyright parseResponse(String response, String header) throws APIException {
            return MusicWorkCopyright.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public MusicWorkCopyright execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public MusicWorkCopyright execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<MusicWorkCopyright> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<MusicWorkCopyright> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, MusicWorkCopyright>(){

                public MusicWorkCopyright apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAvailableUiActionsField() {
            return this.requestAvailableUiActionsField(true);
        }

        public APIRequestGet requestAvailableUiActionsField(boolean value) {
            this.requestField("available_ui_actions", value);
            return this;
        }

        public APIRequestGet requestClaimStatusField() {
            return this.requestClaimStatusField(true);
        }

        public APIRequestGet requestClaimStatusField(boolean value) {
            this.requestField("claim_status", value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestDisplayedFbMatchesCountField() {
            return this.requestDisplayedFbMatchesCountField(true);
        }

        public APIRequestGet requestDisplayedFbMatchesCountField(boolean value) {
            this.requestField("displayed_fb_matches_count", value);
            return this;
        }

        public APIRequestGet requestDisplayedIgMatchesCountField() {
            return this.requestDisplayedIgMatchesCountField(true);
        }

        public APIRequestGet requestDisplayedIgMatchesCountField(boolean value) {
            this.requestField("displayed_ig_matches_count", value);
            return this;
        }

        public APIRequestGet requestDisplayedMatchesCountField() {
            return this.requestDisplayedMatchesCountField(true);
        }

        public APIRequestGet requestDisplayedMatchesCountField(boolean value) {
            this.requestField("displayed_matches_count", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestMatchRuleField() {
            return this.requestMatchRuleField(true);
        }

        public APIRequestGet requestMatchRuleField(boolean value) {
            this.requestField("match_rule", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestTagsField() {
            return this.requestTagsField(true);
        }

        public APIRequestGet requestTagsField(boolean value) {
            this.requestField("tags", value);
            return this;
        }

        public APIRequestGet requestUpdateTimeField() {
            return this.requestUpdateTimeField(true);
        }

        public APIRequestGet requestUpdateTimeField(boolean value) {
            this.requestField("update_time", value);
            return this;
        }
    }
}

