/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class OfflineConversionDataSetUpload
extends APINode {
    @SerializedName(value="api_calls")
    private Long mApiCalls = null;
    @SerializedName(value="creation_time")
    private Long mCreationTime = null;
    @SerializedName(value="duplicate_entries")
    private Long mDuplicateEntries = null;
    @SerializedName(value="event_stats")
    private String mEventStats = null;
    @SerializedName(value="event_time_max")
    private Long mEventTimeMax = null;
    @SerializedName(value="event_time_min")
    private Long mEventTimeMin = null;
    @SerializedName(value="first_upload_time")
    private Long mFirstUploadTime = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_excluded_for_lift")
    private Boolean mIsExcludedForLift = null;
    @SerializedName(value="last_upload_time")
    private Long mLastUploadTime = null;
    @SerializedName(value="match_rate_approx")
    private Long mMatchRateApprox = null;
    @SerializedName(value="matched_entries")
    private Long mMatchedEntries = null;
    @SerializedName(value="upload_tag")
    private String mUploadTag = null;
    @SerializedName(value="valid_entries")
    private Long mValidEntries = null;
    protected static Gson gson = null;

    OfflineConversionDataSetUpload() {
    }

    public OfflineConversionDataSetUpload(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public OfflineConversionDataSetUpload(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public OfflineConversionDataSetUpload fetch() throws APIException {
        OfflineConversionDataSetUpload newInstance = OfflineConversionDataSetUpload.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static OfflineConversionDataSetUpload fetchById(Long id, APIContext context) throws APIException {
        return OfflineConversionDataSetUpload.fetchById(id.toString(), context);
    }

    public static ListenableFuture<OfflineConversionDataSetUpload> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return OfflineConversionDataSetUpload.fetchByIdAsync(id.toString(), context);
    }

    public static OfflineConversionDataSetUpload fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<OfflineConversionDataSetUpload> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<OfflineConversionDataSetUpload> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<OfflineConversionDataSetUpload>(context, "", "/", "GET", OfflineConversionDataSetUpload.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<OfflineConversionDataSetUpload>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<OfflineConversionDataSetUpload>(context, "", "/", "GET", OfflineConversionDataSetUpload.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static OfflineConversionDataSetUpload loadJSON(String json, APIContext context, String header) {
        OfflineConversionDataSetUpload offlineConversionDataSetUpload = (OfflineConversionDataSetUpload)OfflineConversionDataSetUpload.getGson().fromJson(json, OfflineConversionDataSetUpload.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(offlineConversionDataSetUpload.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        offlineConversionDataSetUpload.context = context;
        offlineConversionDataSetUpload.rawValue = json;
        offlineConversionDataSetUpload.header = header;
        return offlineConversionDataSetUpload;
    }

    public static APINodeList<OfflineConversionDataSetUpload> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<OfflineConversionDataSetUpload> offlineConversionDataSetUploads = new APINodeList<OfflineConversionDataSetUpload>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        offlineConversionDataSetUploads.add(OfflineConversionDataSetUpload.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return offlineConversionDataSetUploads;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            offlineConversionDataSetUploads.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        offlineConversionDataSetUploads.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            offlineConversionDataSetUploads.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            offlineConversionDataSetUploads.add(OfflineConversionDataSetUpload.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                offlineConversionDataSetUploads.add(OfflineConversionDataSetUpload.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            offlineConversionDataSetUploads.add(OfflineConversionDataSetUpload.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return offlineConversionDataSetUploads;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        offlineConversionDataSetUploads.add(OfflineConversionDataSetUpload.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return offlineConversionDataSetUploads;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        offlineConversionDataSetUploads.add(OfflineConversionDataSetUpload.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return offlineConversionDataSetUploads;
                }
                offlineConversionDataSetUploads.clear();
                offlineConversionDataSetUploads.add(OfflineConversionDataSetUpload.loadJSON(json, context, header));
                return offlineConversionDataSetUploads;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return OfflineConversionDataSetUpload.getGson().toJson((Object)this);
    }

    public APIRequestGetProgress getProgress() {
        return new APIRequestGetProgress(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPullSessions getPullSessions() {
        return new APIRequestGetPullSessions(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldApiCalls() {
        return this.mApiCalls;
    }

    public Long getFieldCreationTime() {
        return this.mCreationTime;
    }

    public Long getFieldDuplicateEntries() {
        return this.mDuplicateEntries;
    }

    public String getFieldEventStats() {
        return this.mEventStats;
    }

    public Long getFieldEventTimeMax() {
        return this.mEventTimeMax;
    }

    public Long getFieldEventTimeMin() {
        return this.mEventTimeMin;
    }

    public Long getFieldFirstUploadTime() {
        return this.mFirstUploadTime;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsExcludedForLift() {
        return this.mIsExcludedForLift;
    }

    public Long getFieldLastUploadTime() {
        return this.mLastUploadTime;
    }

    public Long getFieldMatchRateApprox() {
        return this.mMatchRateApprox;
    }

    public Long getFieldMatchedEntries() {
        return this.mMatchedEntries;
    }

    public String getFieldUploadTag() {
        return this.mUploadTag;
    }

    public Long getFieldValidEntries() {
        return this.mValidEntries;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public OfflineConversionDataSetUpload copyFrom(OfflineConversionDataSetUpload instance) {
        this.mApiCalls = instance.mApiCalls;
        this.mCreationTime = instance.mCreationTime;
        this.mDuplicateEntries = instance.mDuplicateEntries;
        this.mEventStats = instance.mEventStats;
        this.mEventTimeMax = instance.mEventTimeMax;
        this.mEventTimeMin = instance.mEventTimeMin;
        this.mFirstUploadTime = instance.mFirstUploadTime;
        this.mId = instance.mId;
        this.mIsExcludedForLift = instance.mIsExcludedForLift;
        this.mLastUploadTime = instance.mLastUploadTime;
        this.mMatchRateApprox = instance.mMatchRateApprox;
        this.mMatchedEntries = instance.mMatchedEntries;
        this.mUploadTag = instance.mUploadTag;
        this.mValidEntries = instance.mValidEntries;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<OfflineConversionDataSetUpload> getParser() {
        return new APIRequest.ResponseParser<OfflineConversionDataSetUpload>(){

            @Override
            public APINodeList<OfflineConversionDataSetUpload> parseResponse(String response, APIContext context, APIRequest<OfflineConversionDataSetUpload> request, String header) throws APIException.MalformedResponseException {
                return OfflineConversionDataSetUpload.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumSortBy {
        VALUE_API_CALLS("API_CALLS"),
        VALUE_CREATION_TIME("CREATION_TIME"),
        VALUE_EVENT_TIME_MAX("EVENT_TIME_MAX"),
        VALUE_EVENT_TIME_MIN("EVENT_TIME_MIN"),
        VALUE_FIRST_UPLOAD_TIME("FIRST_UPLOAD_TIME"),
        VALUE_IS_EXCLUDED_FOR_LIFT("IS_EXCLUDED_FOR_LIFT"),
        VALUE_LAST_UPLOAD_TIME("LAST_UPLOAD_TIME");

        private String value;

        private EnumSortBy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumOrder {
        VALUE_ASCENDING("ASCENDING"),
        VALUE_DESCENDING("DESCENDING");

        private String value;

        private EnumOrder(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestGet
    extends APIRequest<OfflineConversionDataSetUpload> {
        OfflineConversionDataSetUpload lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"api_calls", "creation_time", "duplicate_entries", "event_stats", "event_time_max", "event_time_min", "first_upload_time", "id", "is_excluded_for_lift", "last_upload_time", "match_rate_approx", "matched_entries", "upload_tag", "valid_entries"};

        @Override
        public OfflineConversionDataSetUpload getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public OfflineConversionDataSetUpload parseResponse(String response, String header) throws APIException {
            return OfflineConversionDataSetUpload.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public OfflineConversionDataSetUpload execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public OfflineConversionDataSetUpload execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<OfflineConversionDataSetUpload> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<OfflineConversionDataSetUpload> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, OfflineConversionDataSetUpload>(){

                public OfflineConversionDataSetUpload apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestApiCallsField() {
            return this.requestApiCallsField(true);
        }

        public APIRequestGet requestApiCallsField(boolean value) {
            this.requestField("api_calls", value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestDuplicateEntriesField() {
            return this.requestDuplicateEntriesField(true);
        }

        public APIRequestGet requestDuplicateEntriesField(boolean value) {
            this.requestField("duplicate_entries", value);
            return this;
        }

        public APIRequestGet requestEventStatsField() {
            return this.requestEventStatsField(true);
        }

        public APIRequestGet requestEventStatsField(boolean value) {
            this.requestField("event_stats", value);
            return this;
        }

        public APIRequestGet requestEventTimeMaxField() {
            return this.requestEventTimeMaxField(true);
        }

        public APIRequestGet requestEventTimeMaxField(boolean value) {
            this.requestField("event_time_max", value);
            return this;
        }

        public APIRequestGet requestEventTimeMinField() {
            return this.requestEventTimeMinField(true);
        }

        public APIRequestGet requestEventTimeMinField(boolean value) {
            this.requestField("event_time_min", value);
            return this;
        }

        public APIRequestGet requestFirstUploadTimeField() {
            return this.requestFirstUploadTimeField(true);
        }

        public APIRequestGet requestFirstUploadTimeField(boolean value) {
            this.requestField("first_upload_time", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsExcludedForLiftField() {
            return this.requestIsExcludedForLiftField(true);
        }

        public APIRequestGet requestIsExcludedForLiftField(boolean value) {
            this.requestField("is_excluded_for_lift", value);
            return this;
        }

        public APIRequestGet requestLastUploadTimeField() {
            return this.requestLastUploadTimeField(true);
        }

        public APIRequestGet requestLastUploadTimeField(boolean value) {
            this.requestField("last_upload_time", value);
            return this;
        }

        public APIRequestGet requestMatchRateApproxField() {
            return this.requestMatchRateApproxField(true);
        }

        public APIRequestGet requestMatchRateApproxField(boolean value) {
            this.requestField("match_rate_approx", value);
            return this;
        }

        public APIRequestGet requestMatchedEntriesField() {
            return this.requestMatchedEntriesField(true);
        }

        public APIRequestGet requestMatchedEntriesField(boolean value) {
            this.requestField("matched_entries", value);
            return this;
        }

        public APIRequestGet requestUploadTagField() {
            return this.requestUploadTagField(true);
        }

        public APIRequestGet requestUploadTagField(boolean value) {
            this.requestField("upload_tag", value);
            return this;
        }

        public APIRequestGet requestValidEntriesField() {
            return this.requestValidEntriesField(true);
        }

        public APIRequestGet requestValidEntriesField(boolean value) {
            this.requestField("valid_entries", value);
            return this;
        }
    }

    public static class APIRequestGetPullSessions
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetPullSessions(String nodeId, APIContext context) {
            super(context, nodeId, "/pull_sessions", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPullSessions setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPullSessions setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPullSessions requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPullSessions requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPullSessions requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPullSessions requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPullSessions requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPullSessions requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetProgress
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetProgress(String nodeId, APIContext context) {
            super(context, nodeId, "/progress", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetProgress setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetProgress setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetProgress requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetProgress requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetProgress requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetProgress requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetProgress requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetProgress requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

