/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.User;
import com.facebook.ads.sdk.VideoCopyrightConditionGroup;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class VideoCopyrightRule
extends APINode {
    @SerializedName(value="condition_groups")
    private List<VideoCopyrightConditionGroup> mConditionGroups = null;
    @SerializedName(value="copyrights")
    private List<String> mCopyrights = null;
    @SerializedName(value="created_date")
    private String mCreatedDate = null;
    @SerializedName(value="creator")
    private User mCreator = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_in_migration")
    private Boolean mIsInMigration = null;
    @SerializedName(value="name")
    private String mName = null;
    protected static Gson gson = null;

    VideoCopyrightRule() {
    }

    public VideoCopyrightRule(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public VideoCopyrightRule(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public VideoCopyrightRule fetch() throws APIException {
        VideoCopyrightRule newInstance = VideoCopyrightRule.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static VideoCopyrightRule fetchById(Long id, APIContext context) throws APIException {
        return VideoCopyrightRule.fetchById(id.toString(), context);
    }

    public static ListenableFuture<VideoCopyrightRule> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return VideoCopyrightRule.fetchByIdAsync(id.toString(), context);
    }

    public static VideoCopyrightRule fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<VideoCopyrightRule> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<VideoCopyrightRule> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<VideoCopyrightRule>(context, "", "/", "GET", VideoCopyrightRule.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<VideoCopyrightRule>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<VideoCopyrightRule>(context, "", "/", "GET", VideoCopyrightRule.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static VideoCopyrightRule loadJSON(String json, APIContext context, String header) {
        VideoCopyrightRule videoCopyrightRule = (VideoCopyrightRule)VideoCopyrightRule.getGson().fromJson(json, VideoCopyrightRule.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(videoCopyrightRule.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        videoCopyrightRule.context = context;
        videoCopyrightRule.rawValue = json;
        videoCopyrightRule.header = header;
        return videoCopyrightRule;
    }

    public static APINodeList<VideoCopyrightRule> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<VideoCopyrightRule> videoCopyrightRules = new APINodeList<VideoCopyrightRule>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        videoCopyrightRules.add(VideoCopyrightRule.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return videoCopyrightRules;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            videoCopyrightRules.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        videoCopyrightRules.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            videoCopyrightRules.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            videoCopyrightRules.add(VideoCopyrightRule.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                videoCopyrightRules.add(VideoCopyrightRule.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            videoCopyrightRules.add(VideoCopyrightRule.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return videoCopyrightRules;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        videoCopyrightRules.add(VideoCopyrightRule.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return videoCopyrightRules;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        videoCopyrightRules.add(VideoCopyrightRule.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return videoCopyrightRules;
                }
                videoCopyrightRules.clear();
                videoCopyrightRules.add(VideoCopyrightRule.loadJSON(json, context, header));
                return videoCopyrightRules;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return VideoCopyrightRule.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<VideoCopyrightConditionGroup> getFieldConditionGroups() {
        return this.mConditionGroups;
    }

    public List<String> getFieldCopyrights() {
        return this.mCopyrights;
    }

    public String getFieldCreatedDate() {
        return this.mCreatedDate;
    }

    public User getFieldCreator() {
        if (this.mCreator != null) {
            this.mCreator.context = this.getContext();
        }
        return this.mCreator;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsInMigration() {
        return this.mIsInMigration;
    }

    public String getFieldName() {
        return this.mName;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public VideoCopyrightRule copyFrom(VideoCopyrightRule instance) {
        this.mConditionGroups = instance.mConditionGroups;
        this.mCopyrights = instance.mCopyrights;
        this.mCreatedDate = instance.mCreatedDate;
        this.mCreator = instance.mCreator;
        this.mId = instance.mId;
        this.mIsInMigration = instance.mIsInMigration;
        this.mName = instance.mName;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<VideoCopyrightRule> getParser() {
        return new APIRequest.ResponseParser<VideoCopyrightRule>(){

            @Override
            public APINodeList<VideoCopyrightRule> parseResponse(String response, APIContext context, APIRequest<VideoCopyrightRule> request, String header) throws APIException.MalformedResponseException {
                return VideoCopyrightRule.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumSource {
        VALUE_MATCH_SETTINGS_DIALOG("MATCH_SETTINGS_DIALOG"),
        VALUE_RULES_SELECTOR("RULES_SELECTOR"),
        VALUE_RULES_TAB("RULES_TAB");

        private String value;

        private EnumSource(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestGet
    extends APIRequest<VideoCopyrightRule> {
        VideoCopyrightRule lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"condition_groups", "copyrights", "created_date", "creator", "id", "is_in_migration", "name"};

        @Override
        public VideoCopyrightRule getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public VideoCopyrightRule parseResponse(String response, String header) throws APIException {
            return VideoCopyrightRule.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public VideoCopyrightRule execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public VideoCopyrightRule execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<VideoCopyrightRule> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<VideoCopyrightRule> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, VideoCopyrightRule>(){

                public VideoCopyrightRule apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestConditionGroupsField() {
            return this.requestConditionGroupsField(true);
        }

        public APIRequestGet requestConditionGroupsField(boolean value) {
            this.requestField("condition_groups", value);
            return this;
        }

        public APIRequestGet requestCopyrightsField() {
            return this.requestCopyrightsField(true);
        }

        public APIRequestGet requestCopyrightsField(boolean value) {
            this.requestField("copyrights", value);
            return this;
        }

        public APIRequestGet requestCreatedDateField() {
            return this.requestCreatedDateField(true);
        }

        public APIRequestGet requestCreatedDateField(boolean value) {
            this.requestField("created_date", value);
            return this;
        }

        public APIRequestGet requestCreatorField() {
            return this.requestCreatorField(true);
        }

        public APIRequestGet requestCreatorField(boolean value) {
            this.requestField("creator", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsInMigrationField() {
            return this.requestIsInMigrationField(true);
        }

        public APIRequestGet requestIsInMigrationField(boolean value) {
            this.requestField("is_in_migration", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }
    }
}

