/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class VideoMetricsReport
extends APINode {
    @SerializedName(value="checksum")
    private String mChecksum = null;
    @SerializedName(value="chunks")
    private Long mChunks = null;
    @SerializedName(value="end_date")
    private String mEndDate = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="index")
    private Long mIndex = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="platform")
    private String mPlatform = null;
    @SerializedName(value="start_date")
    private String mStartDate = null;
    @SerializedName(value="type")
    private String mType = null;
    @SerializedName(value="upload_date")
    private String mUploadDate = null;
    @SerializedName(value="url")
    private String mUrl = null;
    protected static Gson gson = null;

    VideoMetricsReport() {
    }

    public VideoMetricsReport(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public VideoMetricsReport(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public VideoMetricsReport fetch() throws APIException {
        VideoMetricsReport newInstance = VideoMetricsReport.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static VideoMetricsReport fetchById(Long id, APIContext context) throws APIException {
        return VideoMetricsReport.fetchById(id.toString(), context);
    }

    public static ListenableFuture<VideoMetricsReport> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return VideoMetricsReport.fetchByIdAsync(id.toString(), context);
    }

    public static VideoMetricsReport fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<VideoMetricsReport> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<VideoMetricsReport> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<VideoMetricsReport>(context, "", "/", "GET", VideoMetricsReport.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<VideoMetricsReport>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<VideoMetricsReport>(context, "", "/", "GET", VideoMetricsReport.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static VideoMetricsReport loadJSON(String json, APIContext context, String header) {
        VideoMetricsReport videoMetricsReport = (VideoMetricsReport)VideoMetricsReport.getGson().fromJson(json, VideoMetricsReport.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(videoMetricsReport.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        videoMetricsReport.context = context;
        videoMetricsReport.rawValue = json;
        videoMetricsReport.header = header;
        return videoMetricsReport;
    }

    public static APINodeList<VideoMetricsReport> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<VideoMetricsReport> videoMetricsReports = new APINodeList<VideoMetricsReport>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        videoMetricsReports.add(VideoMetricsReport.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return videoMetricsReports;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            videoMetricsReports.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        videoMetricsReports.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            videoMetricsReports.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            videoMetricsReports.add(VideoMetricsReport.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                videoMetricsReports.add(VideoMetricsReport.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            videoMetricsReports.add(VideoMetricsReport.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return videoMetricsReports;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        videoMetricsReports.add(VideoMetricsReport.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return videoMetricsReports;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        videoMetricsReports.add(VideoMetricsReport.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return videoMetricsReports;
                }
                videoMetricsReports.clear();
                videoMetricsReports.add(VideoMetricsReport.loadJSON(json, context, header));
                return videoMetricsReports;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return VideoMetricsReport.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldChecksum() {
        return this.mChecksum;
    }

    public Long getFieldChunks() {
        return this.mChunks;
    }

    public String getFieldEndDate() {
        return this.mEndDate;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Long getFieldIndex() {
        return this.mIndex;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldPlatform() {
        return this.mPlatform;
    }

    public String getFieldStartDate() {
        return this.mStartDate;
    }

    public String getFieldType() {
        return this.mType;
    }

    public String getFieldUploadDate() {
        return this.mUploadDate;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public VideoMetricsReport copyFrom(VideoMetricsReport instance) {
        this.mChecksum = instance.mChecksum;
        this.mChunks = instance.mChunks;
        this.mEndDate = instance.mEndDate;
        this.mId = instance.mId;
        this.mIndex = instance.mIndex;
        this.mName = instance.mName;
        this.mPlatform = instance.mPlatform;
        this.mStartDate = instance.mStartDate;
        this.mType = instance.mType;
        this.mUploadDate = instance.mUploadDate;
        this.mUrl = instance.mUrl;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<VideoMetricsReport> getParser() {
        return new APIRequest.ResponseParser<VideoMetricsReport>(){

            @Override
            public APINodeList<VideoMetricsReport> parseResponse(String response, APIContext context, APIRequest<VideoMetricsReport> request, String header) throws APIException.MalformedResponseException {
                return VideoMetricsReport.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<VideoMetricsReport> {
        VideoMetricsReport lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"checksum", "chunks", "end_date", "id", "index", "name", "platform", "start_date", "type", "upload_date", "url"};

        @Override
        public VideoMetricsReport getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public VideoMetricsReport parseResponse(String response, String header) throws APIException {
            return VideoMetricsReport.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public VideoMetricsReport execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public VideoMetricsReport execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<VideoMetricsReport> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<VideoMetricsReport> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, VideoMetricsReport>(){

                public VideoMetricsReport apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestChecksumField() {
            return this.requestChecksumField(true);
        }

        public APIRequestGet requestChecksumField(boolean value) {
            this.requestField("checksum", value);
            return this;
        }

        public APIRequestGet requestChunksField() {
            return this.requestChunksField(true);
        }

        public APIRequestGet requestChunksField(boolean value) {
            this.requestField("chunks", value);
            return this;
        }

        public APIRequestGet requestEndDateField() {
            return this.requestEndDateField(true);
        }

        public APIRequestGet requestEndDateField(boolean value) {
            this.requestField("end_date", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIndexField() {
            return this.requestIndexField(true);
        }

        public APIRequestGet requestIndexField(boolean value) {
            this.requestField("index", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPlatformField() {
            return this.requestPlatformField(true);
        }

        public APIRequestGet requestPlatformField(boolean value) {
            this.requestField("platform", value);
            return this;
        }

        public APIRequestGet requestStartDateField() {
            return this.requestStartDateField(true);
        }

        public APIRequestGet requestStartDateField(boolean value) {
            this.requestField("start_date", value);
            return this;
        }

        public APIRequestGet requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGet requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGet requestUploadDateField() {
            return this.requestUploadDateField(true);
        }

        public APIRequestGet requestUploadDateField(boolean value) {
            this.requestField("upload_date", value);
            return this;
        }

        public APIRequestGet requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGet requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }
    }
}

