/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class WoodhengeSupporter
extends APINode {
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_gifted_subscription")
    private Boolean mIsGiftedSubscription = null;
    @SerializedName(value="most_recent_subscription_time")
    private String mMostRecentSubscriptionTime = null;
    @SerializedName(value="number_of_months_subscribed")
    private Long mNumberOfMonthsSubscribed = null;
    @SerializedName(value="user")
    private User mUser = null;
    protected static Gson gson = null;

    WoodhengeSupporter() {
    }

    public WoodhengeSupporter(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public WoodhengeSupporter(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public WoodhengeSupporter fetch() throws APIException {
        WoodhengeSupporter newInstance = WoodhengeSupporter.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static WoodhengeSupporter fetchById(Long id, APIContext context) throws APIException {
        return WoodhengeSupporter.fetchById(id.toString(), context);
    }

    public static ListenableFuture<WoodhengeSupporter> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return WoodhengeSupporter.fetchByIdAsync(id.toString(), context);
    }

    public static WoodhengeSupporter fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<WoodhengeSupporter> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<WoodhengeSupporter> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<WoodhengeSupporter>(context, "", "/", "GET", WoodhengeSupporter.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<WoodhengeSupporter>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<WoodhengeSupporter>(context, "", "/", "GET", WoodhengeSupporter.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static WoodhengeSupporter loadJSON(String json, APIContext context, String header) {
        WoodhengeSupporter woodhengeSupporter = (WoodhengeSupporter)WoodhengeSupporter.getGson().fromJson(json, WoodhengeSupporter.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(woodhengeSupporter.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        woodhengeSupporter.context = context;
        woodhengeSupporter.rawValue = json;
        woodhengeSupporter.header = header;
        return woodhengeSupporter;
    }

    public static APINodeList<WoodhengeSupporter> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<WoodhengeSupporter> woodhengeSupporters = new APINodeList<WoodhengeSupporter>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        woodhengeSupporters.add(WoodhengeSupporter.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return woodhengeSupporters;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            woodhengeSupporters.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        woodhengeSupporters.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            woodhengeSupporters.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            woodhengeSupporters.add(WoodhengeSupporter.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                woodhengeSupporters.add(WoodhengeSupporter.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            woodhengeSupporters.add(WoodhengeSupporter.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return woodhengeSupporters;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        woodhengeSupporters.add(WoodhengeSupporter.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return woodhengeSupporters;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        woodhengeSupporters.add(WoodhengeSupporter.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return woodhengeSupporters;
                }
                woodhengeSupporters.clear();
                woodhengeSupporters.add(WoodhengeSupporter.loadJSON(json, context, header));
                return woodhengeSupporters;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return WoodhengeSupporter.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsGiftedSubscription() {
        return this.mIsGiftedSubscription;
    }

    public String getFieldMostRecentSubscriptionTime() {
        return this.mMostRecentSubscriptionTime;
    }

    public Long getFieldNumberOfMonthsSubscribed() {
        return this.mNumberOfMonthsSubscribed;
    }

    public User getFieldUser() {
        if (this.mUser != null) {
            this.mUser.context = this.getContext();
        }
        return this.mUser;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public WoodhengeSupporter copyFrom(WoodhengeSupporter instance) {
        this.mCreationTime = instance.mCreationTime;
        this.mId = instance.mId;
        this.mIsGiftedSubscription = instance.mIsGiftedSubscription;
        this.mMostRecentSubscriptionTime = instance.mMostRecentSubscriptionTime;
        this.mNumberOfMonthsSubscribed = instance.mNumberOfMonthsSubscribed;
        this.mUser = instance.mUser;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<WoodhengeSupporter> getParser() {
        return new APIRequest.ResponseParser<WoodhengeSupporter>(){

            @Override
            public APINodeList<WoodhengeSupporter> parseResponse(String response, APIContext context, APIRequest<WoodhengeSupporter> request, String header) throws APIException.MalformedResponseException {
                return WoodhengeSupporter.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<WoodhengeSupporter> {
        WoodhengeSupporter lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"creation_time", "id", "is_gifted_subscription", "most_recent_subscription_time", "number_of_months_subscribed", "user"};

        @Override
        public WoodhengeSupporter getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public WoodhengeSupporter parseResponse(String response, String header) throws APIException {
            return WoodhengeSupporter.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public WoodhengeSupporter execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public WoodhengeSupporter execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<WoodhengeSupporter> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<WoodhengeSupporter> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, WoodhengeSupporter>(){

                public WoodhengeSupporter apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsGiftedSubscriptionField() {
            return this.requestIsGiftedSubscriptionField(true);
        }

        public APIRequestGet requestIsGiftedSubscriptionField(boolean value) {
            this.requestField("is_gifted_subscription", value);
            return this;
        }

        public APIRequestGet requestMostRecentSubscriptionTimeField() {
            return this.requestMostRecentSubscriptionTimeField(true);
        }

        public APIRequestGet requestMostRecentSubscriptionTimeField(boolean value) {
            this.requestField("most_recent_subscription_time", value);
            return this;
        }

        public APIRequestGet requestNumberOfMonthsSubscribedField() {
            return this.requestNumberOfMonthsSubscribedField(true);
        }

        public APIRequestGet requestNumberOfMonthsSubscribedField(boolean value) {
            this.requestField("number_of_months_subscribed", value);
            return this;
        }

        public APIRequestGet requestUserField() {
            return this.requestUserField(true);
        }

        public APIRequestGet requestUserField(boolean value) {
            this.requestField("user", value);
            return this;
        }
    }
}

