/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 */

package com.facebook.ads.sdk;

import java.io.File;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.gson.JsonObject;
import com.google.gson.JsonArray;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;

import com.facebook.ads.sdk.APIException.MalformedResponseException;

/**
 * This class is auto-generated.
 *
 * For any issues or feature requests related to this class, please let us know
 * on github and we'll fix in our codegen framework. We'll not be able to accept
 * pull request for this class.
 *
 */
public class Page extends APINode {
  @SerializedName("about")
  private String mAbout = null;
  @SerializedName("access_token")
  private String mAccessToken = null;
  @SerializedName("ad_campaign")
  private AdSet mAdCampaign = null;
  @SerializedName("affiliation")
  private String mAffiliation = null;
  @SerializedName("app_id")
  private String mAppId = null;
  @SerializedName("artists_we_like")
  private String mArtistsWeLike = null;
  @SerializedName("attire")
  private String mAttire = null;
  @SerializedName("available_promo_offer_ids")
  private List<Map<String, List<Map<String, String>>>> mAvailablePromoOfferIds = null;
  @SerializedName("awards")
  private String mAwards = null;
  @SerializedName("band_interests")
  private String mBandInterests = null;
  @SerializedName("band_members")
  private String mBandMembers = null;
  @SerializedName("best_page")
  private Page mBestPage = null;
  @SerializedName("bio")
  private String mBio = null;
  @SerializedName("birthday")
  private String mBirthday = null;
  @SerializedName("booking_agent")
  private String mBookingAgent = null;
  @SerializedName("breaking_news_usage")
  private Object mBreakingNewsUsage = null;
  @SerializedName("built")
  private String mBuilt = null;
  @SerializedName("business")
  private Object mBusiness = null;
  @SerializedName("can_checkin")
  private Boolean mCanCheckin = null;
  @SerializedName("can_post")
  private Boolean mCanPost = null;
  @SerializedName("category")
  private String mCategory = null;
  @SerializedName("category_list")
  private List<PageCategory> mCategoryList = null;
  @SerializedName("checkins")
  private Long mCheckins = null;
  @SerializedName("company_overview")
  private String mCompanyOverview = null;
  @SerializedName("connected_instagram_account")
  private IGUser mConnectedInstagramAccount = null;
  @SerializedName("connected_page_backed_instagram_account")
  private IGUser mConnectedPageBackedInstagramAccount = null;
  @SerializedName("contact_address")
  private MailingAddress mContactAddress = null;
  @SerializedName("copyright_attribution_insights")
  private CopyrightAttributionInsights mCopyrightAttributionInsights = null;
  @SerializedName("copyright_whitelisted_ig_partners")
  private List<String> mCopyrightWhitelistedIgPartners = null;
  @SerializedName("country_page_likes")
  private Long mCountryPageLikes = null;
  @SerializedName("cover")
  private CoverPhoto mCover = null;
  @SerializedName("culinary_team")
  private String mCulinaryTeam = null;
  @SerializedName("current_location")
  private String mCurrentLocation = null;
  @SerializedName("delivery_and_pickup_option_info")
  private List<String> mDeliveryAndPickupOptionInfo = null;
  @SerializedName("description")
  private String mDescription = null;
  @SerializedName("description_html")
  private String mDescriptionHtml = null;
  @SerializedName("differently_open_offerings")
  private List<Map<String, Boolean>> mDifferentlyOpenOfferings = null;
  @SerializedName("directed_by")
  private String mDirectedBy = null;
  @SerializedName("display_subtext")
  private String mDisplaySubtext = null;
  @SerializedName("displayed_message_response_time")
  private String mDisplayedMessageResponseTime = null;
  @SerializedName("does_viewer_have_page_permission_link_ig")
  private Boolean mDoesViewerHavePagePermissionLinkIg = null;
  @SerializedName("emails")
  private List<String> mEmails = null;
  @SerializedName("engagement")
  private Engagement mEngagement = null;
  @SerializedName("fan_count")
  private Long mFanCount = null;
  @SerializedName("featured_video")
  private AdVideo mFeaturedVideo = null;
  @SerializedName("features")
  private String mFeatures = null;
  @SerializedName("followers_count")
  private Long mFollowersCount = null;
  @SerializedName("food_styles")
  private List<String> mFoodStyles = null;
  @SerializedName("founded")
  private String mFounded = null;
  @SerializedName("general_info")
  private String mGeneralInfo = null;
  @SerializedName("general_manager")
  private String mGeneralManager = null;
  @SerializedName("genre")
  private String mGenre = null;
  @SerializedName("global_brand_page_name")
  private String mGlobalBrandPageName = null;
  @SerializedName("global_brand_root_id")
  private String mGlobalBrandRootId = null;
  @SerializedName("has_added_app")
  private Boolean mHasAddedApp = null;
  @SerializedName("has_lead_access")
  private HasLeadAccess mHasLeadAccess = null;
  @SerializedName("has_transitioned_to_new_page_experience")
  private Boolean mHasTransitionedToNewPageExperience = null;
  @SerializedName("has_whatsapp_business_number")
  private Boolean mHasWhatsappBusinessNumber = null;
  @SerializedName("has_whatsapp_number")
  private Boolean mHasWhatsappNumber = null;
  @SerializedName("hometown")
  private String mHometown = null;
  @SerializedName("hours")
  private Map<String, String> mHours = null;
  @SerializedName("id")
  private String mId = null;
  @SerializedName("impressum")
  private String mImpressum = null;
  @SerializedName("influences")
  private String mInfluences = null;
  @SerializedName("instagram_business_account")
  private IGUser mInstagramBusinessAccount = null;
  @SerializedName("is_always_open")
  private Boolean mIsAlwaysOpen = null;
  @SerializedName("is_calling_eligible")
  private Boolean mIsCallingEligible = null;
  @SerializedName("is_chain")
  private Boolean mIsChain = null;
  @SerializedName("is_community_page")
  private Boolean mIsCommunityPage = null;
  @SerializedName("is_eligible_for_branded_content")
  private Boolean mIsEligibleForBrandedContent = null;
  @SerializedName("is_eligible_for_disable_connect_ig_btn_for_non_page_admin_am_web")
  private Boolean mIsEligibleForDisableConnectIgBtnForNonPageAdminAmWeb = null;
  @SerializedName("is_messenger_bot_get_started_enabled")
  private Boolean mIsMessengerBotGetStartedEnabled = null;
  @SerializedName("is_messenger_platform_bot")
  private Boolean mIsMessengerPlatformBot = null;
  @SerializedName("is_owned")
  private Boolean mIsOwned = null;
  @SerializedName("is_permanently_closed")
  private Boolean mIsPermanentlyClosed = null;
  @SerializedName("is_published")
  private Boolean mIsPublished = null;
  @SerializedName("is_unclaimed")
  private Boolean mIsUnclaimed = null;
  @SerializedName("is_verified")
  private Boolean mIsVerified = null;
  @SerializedName("is_webhooks_subscribed")
  private Boolean mIsWebhooksSubscribed = null;
  @SerializedName("keywords")
  private Object mKeywords = null;
  @SerializedName("leadgen_tos_acceptance_time")
  private String mLeadgenTosAcceptanceTime = null;
  @SerializedName("leadgen_tos_accepted")
  private Boolean mLeadgenTosAccepted = null;
  @SerializedName("leadgen_tos_accepting_user")
  private User mLeadgenTosAcceptingUser = null;
  @SerializedName("link")
  private String mLink = null;
  @SerializedName("location")
  private Location mLocation = null;
  @SerializedName("members")
  private String mMembers = null;
  @SerializedName("merchant_id")
  private String mMerchantId = null;
  @SerializedName("merchant_review_status")
  private String mMerchantReviewStatus = null;
  @SerializedName("messaging_feature_status")
  private MessagingFeatureStatus mMessagingFeatureStatus = null;
  @SerializedName("messenger_ads_default_icebreakers")
  private List<String> mMessengerAdsDefaultIcebreakers = null;
  @SerializedName("messenger_ads_default_quick_replies")
  private List<String> mMessengerAdsDefaultQuickReplies = null;
  @SerializedName("messenger_ads_quick_replies_type")
  private String mMessengerAdsQuickRepliesType = null;
  @SerializedName("mini_shop_storefront")
  private Shop mMiniShopStorefront = null;
  @SerializedName("mission")
  private String mMission = null;
  @SerializedName("mpg")
  private String mMpg = null;
  @SerializedName("name")
  private String mName = null;
  @SerializedName("name_with_location_descriptor")
  private String mNameWithLocationDescriptor = null;
  @SerializedName("network")
  private String mNetwork = null;
  @SerializedName("new_like_count")
  private Long mNewLikeCount = null;
  @SerializedName("offer_eligible")
  private Boolean mOfferEligible = null;
  @SerializedName("overall_star_rating")
  private Double mOverallStarRating = null;
  @SerializedName("owner_business")
  private Business mOwnerBusiness = null;
  @SerializedName("page_token")
  private String mPageToken = null;
  @SerializedName("parent_page")
  private Page mParentPage = null;
  @SerializedName("parking")
  private PageParking mParking = null;
  @SerializedName("payment_options")
  private PagePaymentOptions mPaymentOptions = null;
  @SerializedName("personal_info")
  private String mPersonalInfo = null;
  @SerializedName("personal_interests")
  private String mPersonalInterests = null;
  @SerializedName("pharma_safety_info")
  private String mPharmaSafetyInfo = null;
  @SerializedName("phone")
  private String mPhone = null;
  @SerializedName("pickup_options")
  private List<String> mPickupOptions = null;
  @SerializedName("place_type")
  private String mPlaceType = null;
  @SerializedName("plot_outline")
  private String mPlotOutline = null;
  @SerializedName("preferred_audience")
  private Targeting mPreferredAudience = null;
  @SerializedName("press_contact")
  private String mPressContact = null;
  @SerializedName("price_range")
  private String mPriceRange = null;
  @SerializedName("privacy_info_url")
  private String mPrivacyInfoUrl = null;
  @SerializedName("produced_by")
  private String mProducedBy = null;
  @SerializedName("products")
  private String mProducts = null;
  @SerializedName("promotion_eligible")
  private Boolean mPromotionEligible = null;
  @SerializedName("promotion_ineligible_reason")
  private String mPromotionIneligibleReason = null;
  @SerializedName("public_transit")
  private String mPublicTransit = null;
  @SerializedName("rating_count")
  private Long mRatingCount = null;
  @SerializedName("recipient")
  private String mRecipient = null;
  @SerializedName("record_label")
  private String mRecordLabel = null;
  @SerializedName("release_date")
  private String mReleaseDate = null;
  @SerializedName("restaurant_services")
  private PageRestaurantServices mRestaurantServices = null;
  @SerializedName("restaurant_specialties")
  private PageRestaurantSpecialties mRestaurantSpecialties = null;
  @SerializedName("schedule")
  private String mSchedule = null;
  @SerializedName("screenplay_by")
  private String mScreenplayBy = null;
  @SerializedName("season")
  private String mSeason = null;
  @SerializedName("single_line_address")
  private String mSingleLineAddress = null;
  @SerializedName("starring")
  private String mStarring = null;
  @SerializedName("start_info")
  private PageStartInfo mStartInfo = null;
  @SerializedName("store_code")
  private String mStoreCode = null;
  @SerializedName("store_location_descriptor")
  private String mStoreLocationDescriptor = null;
  @SerializedName("store_number")
  private Long mStoreNumber = null;
  @SerializedName("studio")
  private String mStudio = null;
  @SerializedName("supports_donate_button_in_live_video")
  private Boolean mSupportsDonateButtonInLiveVideo = null;
  @SerializedName("talking_about_count")
  private Long mTalkingAboutCount = null;
  @SerializedName("temporary_status")
  private String mTemporaryStatus = null;
  @SerializedName("unread_message_count")
  private Long mUnreadMessageCount = null;
  @SerializedName("unread_notif_count")
  private Long mUnreadNotifCount = null;
  @SerializedName("unseen_message_count")
  private Long mUnseenMessageCount = null;
  @SerializedName("user_access_expire_time")
  private String mUserAccessExpireTime = null;
  @SerializedName("username")
  private String mUsername = null;
  @SerializedName("verification_status")
  private String mVerificationStatus = null;
  @SerializedName("voip_info")
  private VoipInfo mVoipInfo = null;
  @SerializedName("website")
  private String mWebsite = null;
  @SerializedName("were_here_count")
  private Long mWereHereCount = null;
  @SerializedName("whatsapp_number")
  private String mWhatsappNumber = null;
  @SerializedName("written_by")
  private String mWrittenBy = null;
  protected static Gson gson = null;

  Page() {
  }

  public Page(Long id, APIContext context) {
    this(id.toString(), context);
  }

  public Page(String id, APIContext context) {
    this.mId = id;

    this.context = context;
  }

  public Page fetch() throws APIException{
    Page newInstance = fetchById(this.getPrefixedId().toString(), this.context);
    this.copyFrom(newInstance);
    return this;
  }

  public static Page fetchById(Long id, APIContext context) throws APIException {
    return fetchById(id.toString(), context);
  }

  public static ListenableFuture<Page> fetchByIdAsync(Long id, APIContext context) throws APIException {
    return fetchByIdAsync(id.toString(), context);
  }

  public static Page fetchById(String id, APIContext context) throws APIException {
    return
      new APIRequestGet(id, context)
      .requestAllFields()
      .execute();
  }

  public static ListenableFuture<Page> fetchByIdAsync(String id, APIContext context) throws APIException {
    return
      new APIRequestGet(id, context)
      .requestAllFields()
      .executeAsync();
  }

  public static APINodeList<Page> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
    return (APINodeList<Page>)(
      new APIRequest<Page>(context, "", "/", "GET", Page.getParser())
        .setParam("ids", APIRequest.joinStringList(ids))
        .requestFields(fields)
        .execute()
    );
  }

  public static ListenableFuture<APINodeList<Page>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
    return
      new APIRequest(context, "", "/", "GET", Page.getParser())
        .setParam("ids", APIRequest.joinStringList(ids))
        .requestFields(fields)
        .executeAsyncBase();
  }

  private String getPrefixedId() {
    return getId();
  }

  public String getId() {
    return getFieldId().toString();
  }
  public static Page loadJSON(String json, APIContext context, String header) {
    Page page = getGson().fromJson(json, Page.class);
    if (context.isDebug()) {
      JsonParser parser = new JsonParser();
      JsonElement o1 = parser.parse(json);
      JsonElement o2 = parser.parse(page.toString());
      if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
        o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
      }
      if (!o1.equals(o2)) {
        context.log("[Warning] When parsing response, object is not consistent with JSON:");
        context.log("[JSON]" + o1);
        context.log("[Object]" + o2);
      }
    }
    page.context = context;
    page.rawValue = json;
    page.header = header;
    return page;
  }

  public static APINodeList<Page> parseResponse(String json, APIContext context, APIRequest request, String header) throws MalformedResponseException {
    APINodeList<Page> pages = new APINodeList<Page>(request, json, header);
    JsonArray arr;
    JsonObject obj;
    JsonParser parser = new JsonParser();
    Exception exception = null;
    try{
      JsonElement result = parser.parse(json);
      if (result.isJsonArray()) {
        // First, check if it's a pure JSON Array
        arr = result.getAsJsonArray();
        for (int i = 0; i < arr.size(); i++) {
          pages.add(loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
        };
        return pages;
      } else if (result.isJsonObject()) {
        obj = result.getAsJsonObject();
        if (obj.has("data")) {
          if (obj.has("paging")) {
            JsonObject paging = obj.get("paging").getAsJsonObject();
            if (paging.has("cursors")) {
                JsonObject cursors = paging.get("cursors").getAsJsonObject();
                String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                pages.setCursors(before, after);
            }
            String previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
            String next = paging.has("next") ? paging.get("next").getAsString() : null;
            pages.setPaging(previous, next);
            if (context.hasAppSecret()) {
              pages.setAppSecret(context.getAppSecretProof());
            }
          }
          if (obj.get("data").isJsonArray()) {
            // Second, check if it's a JSON array with "data"
            arr = obj.get("data").getAsJsonArray();
            for (int i = 0; i < arr.size(); i++) {
              pages.add(loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
            };
          } else if (obj.get("data").isJsonObject()) {
            // Third, check if it's a JSON object with "data"
            obj = obj.get("data").getAsJsonObject();
            boolean isRedownload = false;
            for (String s : new String[]{"campaigns", "adsets", "ads"}) {
              if (obj.has(s)) {
                isRedownload = true;
                obj = obj.getAsJsonObject(s);
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                  pages.add(loadJSON(entry.getValue().toString(), context, header));
                }
                break;
              }
            }
            if (!isRedownload) {
              pages.add(loadJSON(obj.toString(), context, header));
            }
          }
          return pages;
        } else if (obj.has("images")) {
          // Fourth, check if it's a map of image objects
          obj = obj.get("images").getAsJsonObject();
          for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
              pages.add(loadJSON(entry.getValue().toString(), context, header));
          }
          return pages;
        } else {
          // Fifth, check if it's an array of objects indexed by id
          boolean isIdIndexedArray = true;
          for (Map.Entry entry : obj.entrySet()) {
            String key = (String) entry.getKey();
            if (key.equals("__fb_trace_id__")) {
              continue;
            }
            JsonElement value = (JsonElement) entry.getValue();
            if (
              value != null &&
              value.isJsonObject() &&
              value.getAsJsonObject().has("id") &&
              value.getAsJsonObject().get("id") != null &&
              value.getAsJsonObject().get("id").getAsString().equals(key)
            ) {
              pages.add(loadJSON(value.toString(), context, header));
            } else {
              isIdIndexedArray = false;
              break;
            }
          }
          if (isIdIndexedArray) {
            return pages;
          }

          // Sixth, check if it's pure JsonObject
          pages.clear();
          pages.add(loadJSON(json, context, header));
          return pages;
        }
      }
    } catch (Exception e) {
      exception = e;
    }
    throw new MalformedResponseException(
      "Invalid response string: " + json,
      exception
    );
  }

  @Override
  public APIContext getContext() {
    return context;
  }

  @Override
  public void setContext(APIContext context) {
    this.context = context;
  }

  @Override
  public String toString() {
    return getGson().toJson(this);
  }

  public APIRequestGetAbTests getAbTests() {
    return new APIRequestGetAbTests(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateAbTest createAbTest() {
    return new APIRequestCreateAbTest(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateAcknowledgeOrder createAcknowledgeOrder() {
    return new APIRequestCreateAcknowledgeOrder(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetAdsEligibility getAdsEligibility() {
    return new APIRequestGetAdsEligibility(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetAdsPosts getAdsPosts() {
    return new APIRequestGetAdsPosts(this.getPrefixedId().toString(), context);
  }

  public APIRequestDeleteAgencies deleteAgencies() {
    return new APIRequestDeleteAgencies(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetAgencies getAgencies() {
    return new APIRequestGetAgencies(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateAgency createAgency() {
    return new APIRequestCreateAgency(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetAlbums getAlbums() {
    return new APIRequestGetAlbums(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetArExperience getArExperience() {
    return new APIRequestGetArExperience(this.getPrefixedId().toString(), context);
  }

  public APIRequestDeleteAssignedUsers deleteAssignedUsers() {
    return new APIRequestDeleteAssignedUsers(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetAssignedUsers getAssignedUsers() {
    return new APIRequestGetAssignedUsers(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateAssignedUser createAssignedUser() {
    return new APIRequestCreateAssignedUser(this.getPrefixedId().toString(), context);
  }

  public APIRequestDeleteBlocked deleteBlocked() {
    return new APIRequestDeleteBlocked(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetBlocked getBlocked() {
    return new APIRequestGetBlocked(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateBlocked createBlocked() {
    return new APIRequestCreateBlocked(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateBusinessDatum createBusinessDatum() {
    return new APIRequestCreateBusinessDatum(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateBusinessMessagingFeatureStatus createBusinessMessagingFeatureStatus() {
    return new APIRequestCreateBusinessMessagingFeatureStatus(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetBusinessProjects getBusinessProjects() {
    return new APIRequestGetBusinessProjects(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetCallToActions getCallToActions() {
    return new APIRequestGetCallToActions(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateCall createCall() {
    return new APIRequestCreateCall(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetCanvasElements getCanvasElements() {
    return new APIRequestGetCanvasElements(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateCanvasElement createCanvasElement() {
    return new APIRequestCreateCanvasElement(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetCanvases getCanvases() {
    return new APIRequestGetCanvases(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateCanvase createCanvase() {
    return new APIRequestCreateCanvase(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetChatPlugin getChatPlugin() {
    return new APIRequestGetChatPlugin(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetCommerceMerchantSettings getCommerceMerchantSettings() {
    return new APIRequestGetCommerceMerchantSettings(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetCommerceOrders getCommerceOrders() {
    return new APIRequestGetCommerceOrders(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetCommercePayouts getCommercePayouts() {
    return new APIRequestGetCommercePayouts(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetCommerceTransactions getCommerceTransactions() {
    return new APIRequestGetCommerceTransactions(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetConversations getConversations() {
    return new APIRequestGetConversations(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateCopyrightManualClaim createCopyrightManualClaim() {
    return new APIRequestCreateCopyrightManualClaim(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetCrosspostWhitelistedPages getCrosspostWhitelistedPages() {
    return new APIRequestGetCrosspostWhitelistedPages(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetCtxOptimizationEligibility getCtxOptimizationEligibility() {
    return new APIRequestGetCtxOptimizationEligibility(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetCustomLabels getCustomLabels() {
    return new APIRequestGetCustomLabels(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateCustomLabel createCustomLabel() {
    return new APIRequestCreateCustomLabel(this.getPrefixedId().toString(), context);
  }

  public APIRequestDeleteCustomUserSettings deleteCustomUserSettings() {
    return new APIRequestDeleteCustomUserSettings(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetCustomUserSettings getCustomUserSettings() {
    return new APIRequestGetCustomUserSettings(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateCustomUserSetting createCustomUserSetting() {
    return new APIRequestCreateCustomUserSetting(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetDataset getDataset() {
    return new APIRequestGetDataset(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateDataset createDataset() {
    return new APIRequestCreateDataset(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetEvents getEvents() {
    return new APIRequestGetEvents(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateExtendThreadControl createExtendThreadControl() {
    return new APIRequestCreateExtendThreadControl(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetFantasyGames getFantasyGames() {
    return new APIRequestGetFantasyGames(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetFeed getFeed() {
    return new APIRequestGetFeed(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateFeed createFeed() {
    return new APIRequestCreateFeed(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetGlobalBrandChildren getGlobalBrandChildren() {
    return new APIRequestGetGlobalBrandChildren(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetImageCopyrights getImageCopyrights() {
    return new APIRequestGetImageCopyrights(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateImageCopyright createImageCopyright() {
    return new APIRequestCreateImageCopyright(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetIndexedVideos getIndexedVideos() {
    return new APIRequestGetIndexedVideos(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetInsights getInsights() {
    return new APIRequestGetInsights(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetInstagramAccounts getInstagramAccounts() {
    return new APIRequestGetInstagramAccounts(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetLeadGenForms getLeadGenForms() {
    return new APIRequestGetLeadGenForms(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateLeadGenForm createLeadGenForm() {
    return new APIRequestCreateLeadGenForm(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetLikes getLikes() {
    return new APIRequestGetLikes(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetLiveVideos getLiveVideos() {
    return new APIRequestGetLiveVideos(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateLiveVideo createLiveVideo() {
    return new APIRequestCreateLiveVideo(this.getPrefixedId().toString(), context);
  }

  public APIRequestDeleteLocations deleteLocations() {
    return new APIRequestDeleteLocations(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetLocations getLocations() {
    return new APIRequestGetLocations(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateLocation createLocation() {
    return new APIRequestCreateLocation(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetMediaFingerprints getMediaFingerprints() {
    return new APIRequestGetMediaFingerprints(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateMediaFingerprint createMediaFingerprint() {
    return new APIRequestCreateMediaFingerprint(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateMessageAttachment createMessageAttachment() {
    return new APIRequestCreateMessageAttachment(this.getPrefixedId().toString(), context);
  }

  public APIRequestDeleteMessageTemplates deleteMessageTemplates() {
    return new APIRequestDeleteMessageTemplates(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetMessageTemplates getMessageTemplates() {
    return new APIRequestGetMessageTemplates(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateMessageTemplate createMessageTemplate() {
    return new APIRequestCreateMessageTemplate(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateMessage createMessage() {
    return new APIRequestCreateMessage(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetMessagingFeatureReview getMessagingFeatureReview() {
    return new APIRequestGetMessagingFeatureReview(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetMessengerCallSettings getMessengerCallSettings() {
    return new APIRequestGetMessengerCallSettings(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateMessengerCallSetting createMessengerCallSetting() {
    return new APIRequestCreateMessengerCallSetting(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetMessengerLeadForms getMessengerLeadForms() {
    return new APIRequestGetMessengerLeadForms(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateMessengerLeadForm createMessengerLeadForm() {
    return new APIRequestCreateMessengerLeadForm(this.getPrefixedId().toString(), context);
  }

  public APIRequestDeleteMessengerProfile deleteMessengerProfile() {
    return new APIRequestDeleteMessengerProfile(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetMessengerProfile getMessengerProfile() {
    return new APIRequestGetMessengerProfile(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateMessengerProfile createMessengerProfile() {
    return new APIRequestCreateMessengerProfile(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateModerateConversation createModerateConversation() {
    return new APIRequestCreateModerateConversation(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateNlpConfig createNlpConfig() {
    return new APIRequestCreateNlpConfig(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetNotificationMessageTokens getNotificationMessageTokens() {
    return new APIRequestGetNotificationMessageTokens(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateNotificationMessagesDevSupport createNotificationMessagesDevSupport() {
    return new APIRequestCreateNotificationMessagesDevSupport(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetPageBackedInstagramAccounts getPageBackedInstagramAccounts() {
    return new APIRequestGetPageBackedInstagramAccounts(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreatePageBackedInstagramAccount createPageBackedInstagramAccount() {
    return new APIRequestCreatePageBackedInstagramAccount(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreatePageWhatsAppNumberVerification createPageWhatsAppNumberVerification() {
    return new APIRequestCreatePageWhatsAppNumberVerification(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreatePassThreadControl createPassThreadControl() {
    return new APIRequestCreatePassThreadControl(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetPersonas getPersonas() {
    return new APIRequestGetPersonas(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreatePersona createPersona() {
    return new APIRequestCreatePersona(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreatePhotoStory createPhotoStory() {
    return new APIRequestCreatePhotoStory(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetPhotos getPhotos() {
    return new APIRequestGetPhotos(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreatePhoto createPhoto() {
    return new APIRequestCreatePhoto(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetPicture getPicture() {
    return new APIRequestGetPicture(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreatePicture createPicture() {
    return new APIRequestCreatePicture(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetPosts getPosts() {
    return new APIRequestGetPosts(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetProductCatalogs getProductCatalogs() {
    return new APIRequestGetProductCatalogs(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetPublishedPosts getPublishedPosts() {
    return new APIRequestGetPublishedPosts(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetRatings getRatings() {
    return new APIRequestGetRatings(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateReleaseThreadControl createReleaseThreadControl() {
    return new APIRequestCreateReleaseThreadControl(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateRequestThreadControl createRequestThreadControl() {
    return new APIRequestCreateRequestThreadControl(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetRoles getRoles() {
    return new APIRequestGetRoles(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetRtbDynamicPosts getRtbDynamicPosts() {
    return new APIRequestGetRtbDynamicPosts(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetScheduledPosts getScheduledPosts() {
    return new APIRequestGetScheduledPosts(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetSecondaryReceivers getSecondaryReceivers() {
    return new APIRequestGetSecondaryReceivers(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetSettings getSettings() {
    return new APIRequestGetSettings(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateSetting createSetting() {
    return new APIRequestCreateSetting(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetShopSetupStatus getShopSetupStatus() {
    return new APIRequestGetShopSetupStatus(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetStoreLocations getStoreLocations() {
    return new APIRequestGetStoreLocations(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetStories getStories() {
    return new APIRequestGetStories(this.getPrefixedId().toString(), context);
  }

  public APIRequestDeleteSubscribedApps deleteSubscribedApps() {
    return new APIRequestDeleteSubscribedApps(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetSubscribedApps getSubscribedApps() {
    return new APIRequestGetSubscribedApps(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateSubscribedApp createSubscribedApp() {
    return new APIRequestCreateSubscribedApp(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetTabs getTabs() {
    return new APIRequestGetTabs(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetTagged getTagged() {
    return new APIRequestGetTagged(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateTakeThreadControl createTakeThreadControl() {
    return new APIRequestCreateTakeThreadControl(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetThreadOwner getThreadOwner() {
    return new APIRequestGetThreadOwner(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetThreads getThreads() {
    return new APIRequestGetThreads(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateUnlinkAccount createUnlinkAccount() {
    return new APIRequestCreateUnlinkAccount(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetVideoCopyrightRules getVideoCopyrightRules() {
    return new APIRequestGetVideoCopyrightRules(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateVideoCopyrightRule createVideoCopyrightRule() {
    return new APIRequestCreateVideoCopyrightRule(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateVideoCopyright createVideoCopyright() {
    return new APIRequestCreateVideoCopyright(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetVideoLists getVideoLists() {
    return new APIRequestGetVideoLists(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetVideoReels getVideoReels() {
    return new APIRequestGetVideoReels(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateVideoReel createVideoReel() {
    return new APIRequestCreateVideoReel(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateVideoStory createVideoStory() {
    return new APIRequestCreateVideoStory(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetVideos getVideos() {
    return new APIRequestGetVideos(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateVideo createVideo() {
    return new APIRequestCreateVideo(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetVisitorPosts getVisitorPosts() {
    return new APIRequestGetVisitorPosts(this.getPrefixedId().toString(), context);
  }

  public APIRequestDeleteWelcomeMessageFlows deleteWelcomeMessageFlows() {
    return new APIRequestDeleteWelcomeMessageFlows(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetWelcomeMessageFlows getWelcomeMessageFlows() {
    return new APIRequestGetWelcomeMessageFlows(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateWelcomeMessageFlow createWelcomeMessageFlow() {
    return new APIRequestCreateWelcomeMessageFlow(this.getPrefixedId().toString(), context);
  }

  public APIRequestGet get() {
    return new APIRequestGet(this.getPrefixedId().toString(), context);
  }

  public APIRequestUpdate update() {
    return new APIRequestUpdate(this.getPrefixedId().toString(), context);
  }


  public String getFieldAbout() {
    return mAbout;
  }

  public String getFieldAccessToken() {
    return mAccessToken;
  }

  public AdSet getFieldAdCampaign() {
    if (mAdCampaign != null) {
      mAdCampaign.context = getContext();
    }
    return mAdCampaign;
  }

  public String getFieldAffiliation() {
    return mAffiliation;
  }

  public String getFieldAppId() {
    return mAppId;
  }

  public String getFieldArtistsWeLike() {
    return mArtistsWeLike;
  }

  public String getFieldAttire() {
    return mAttire;
  }

  public List<Map<String, List<Map<String, String>>>> getFieldAvailablePromoOfferIds() {
    return mAvailablePromoOfferIds;
  }

  public String getFieldAwards() {
    return mAwards;
  }

  public String getFieldBandInterests() {
    return mBandInterests;
  }

  public String getFieldBandMembers() {
    return mBandMembers;
  }

  public Page getFieldBestPage() {
    if (mBestPage != null) {
      mBestPage.context = getContext();
    }
    return mBestPage;
  }

  public String getFieldBio() {
    return mBio;
  }

  public String getFieldBirthday() {
    return mBirthday;
  }

  public String getFieldBookingAgent() {
    return mBookingAgent;
  }

  public Object getFieldBreakingNewsUsage() {
    return mBreakingNewsUsage;
  }

  public String getFieldBuilt() {
    return mBuilt;
  }

  public Object getFieldBusiness() {
    return mBusiness;
  }

  public Boolean getFieldCanCheckin() {
    return mCanCheckin;
  }

  public Boolean getFieldCanPost() {
    return mCanPost;
  }

  public String getFieldCategory() {
    return mCategory;
  }

  public List<PageCategory> getFieldCategoryList() {
    return mCategoryList;
  }

  public Long getFieldCheckins() {
    return mCheckins;
  }

  public String getFieldCompanyOverview() {
    return mCompanyOverview;
  }

  public IGUser getFieldConnectedInstagramAccount() {
    if (mConnectedInstagramAccount != null) {
      mConnectedInstagramAccount.context = getContext();
    }
    return mConnectedInstagramAccount;
  }

  public IGUser getFieldConnectedPageBackedInstagramAccount() {
    if (mConnectedPageBackedInstagramAccount != null) {
      mConnectedPageBackedInstagramAccount.context = getContext();
    }
    return mConnectedPageBackedInstagramAccount;
  }

  public MailingAddress getFieldContactAddress() {
    if (mContactAddress != null) {
      mContactAddress.context = getContext();
    }
    return mContactAddress;
  }

  public CopyrightAttributionInsights getFieldCopyrightAttributionInsights() {
    return mCopyrightAttributionInsights;
  }

  public List<String> getFieldCopyrightWhitelistedIgPartners() {
    return mCopyrightWhitelistedIgPartners;
  }

  public Long getFieldCountryPageLikes() {
    return mCountryPageLikes;
  }

  public CoverPhoto getFieldCover() {
    return mCover;
  }

  public String getFieldCulinaryTeam() {
    return mCulinaryTeam;
  }

  public String getFieldCurrentLocation() {
    return mCurrentLocation;
  }

  public List<String> getFieldDeliveryAndPickupOptionInfo() {
    return mDeliveryAndPickupOptionInfo;
  }

  public String getFieldDescription() {
    return mDescription;
  }

  public String getFieldDescriptionHtml() {
    return mDescriptionHtml;
  }

  public List<Map<String, Boolean>> getFieldDifferentlyOpenOfferings() {
    return mDifferentlyOpenOfferings;
  }

  public String getFieldDirectedBy() {
    return mDirectedBy;
  }

  public String getFieldDisplaySubtext() {
    return mDisplaySubtext;
  }

  public String getFieldDisplayedMessageResponseTime() {
    return mDisplayedMessageResponseTime;
  }

  public Boolean getFieldDoesViewerHavePagePermissionLinkIg() {
    return mDoesViewerHavePagePermissionLinkIg;
  }

  public List<String> getFieldEmails() {
    return mEmails;
  }

  public Engagement getFieldEngagement() {
    return mEngagement;
  }

  public Long getFieldFanCount() {
    return mFanCount;
  }

  public AdVideo getFieldFeaturedVideo() {
    if (mFeaturedVideo != null) {
      mFeaturedVideo.context = getContext();
    }
    return mFeaturedVideo;
  }

  public String getFieldFeatures() {
    return mFeatures;
  }

  public Long getFieldFollowersCount() {
    return mFollowersCount;
  }

  public List<String> getFieldFoodStyles() {
    return mFoodStyles;
  }

  public String getFieldFounded() {
    return mFounded;
  }

  public String getFieldGeneralInfo() {
    return mGeneralInfo;
  }

  public String getFieldGeneralManager() {
    return mGeneralManager;
  }

  public String getFieldGenre() {
    return mGenre;
  }

  public String getFieldGlobalBrandPageName() {
    return mGlobalBrandPageName;
  }

  public String getFieldGlobalBrandRootId() {
    return mGlobalBrandRootId;
  }

  public Boolean getFieldHasAddedApp() {
    return mHasAddedApp;
  }

  public HasLeadAccess getFieldHasLeadAccess() {
    return mHasLeadAccess;
  }

  public Boolean getFieldHasTransitionedToNewPageExperience() {
    return mHasTransitionedToNewPageExperience;
  }

  public Boolean getFieldHasWhatsappBusinessNumber() {
    return mHasWhatsappBusinessNumber;
  }

  public Boolean getFieldHasWhatsappNumber() {
    return mHasWhatsappNumber;
  }

  public String getFieldHometown() {
    return mHometown;
  }

  public Map<String, String> getFieldHours() {
    return mHours;
  }

  public String getFieldId() {
    return mId;
  }

  public String getFieldImpressum() {
    return mImpressum;
  }

  public String getFieldInfluences() {
    return mInfluences;
  }

  public IGUser getFieldInstagramBusinessAccount() {
    if (mInstagramBusinessAccount != null) {
      mInstagramBusinessAccount.context = getContext();
    }
    return mInstagramBusinessAccount;
  }

  public Boolean getFieldIsAlwaysOpen() {
    return mIsAlwaysOpen;
  }

  public Boolean getFieldIsCallingEligible() {
    return mIsCallingEligible;
  }

  public Boolean getFieldIsChain() {
    return mIsChain;
  }

  public Boolean getFieldIsCommunityPage() {
    return mIsCommunityPage;
  }

  public Boolean getFieldIsEligibleForBrandedContent() {
    return mIsEligibleForBrandedContent;
  }

  public Boolean getFieldIsEligibleForDisableConnectIgBtnForNonPageAdminAmWeb() {
    return mIsEligibleForDisableConnectIgBtnForNonPageAdminAmWeb;
  }

  public Boolean getFieldIsMessengerBotGetStartedEnabled() {
    return mIsMessengerBotGetStartedEnabled;
  }

  public Boolean getFieldIsMessengerPlatformBot() {
    return mIsMessengerPlatformBot;
  }

  public Boolean getFieldIsOwned() {
    return mIsOwned;
  }

  public Boolean getFieldIsPermanentlyClosed() {
    return mIsPermanentlyClosed;
  }

  public Boolean getFieldIsPublished() {
    return mIsPublished;
  }

  public Boolean getFieldIsUnclaimed() {
    return mIsUnclaimed;
  }

  public Boolean getFieldIsVerified() {
    return mIsVerified;
  }

  public Boolean getFieldIsWebhooksSubscribed() {
    return mIsWebhooksSubscribed;
  }

  public Object getFieldKeywords() {
    return mKeywords;
  }

  public String getFieldLeadgenTosAcceptanceTime() {
    return mLeadgenTosAcceptanceTime;
  }

  public Boolean getFieldLeadgenTosAccepted() {
    return mLeadgenTosAccepted;
  }

  public User getFieldLeadgenTosAcceptingUser() {
    if (mLeadgenTosAcceptingUser != null) {
      mLeadgenTosAcceptingUser.context = getContext();
    }
    return mLeadgenTosAcceptingUser;
  }

  public String getFieldLink() {
    return mLink;
  }

  public Location getFieldLocation() {
    return mLocation;
  }

  public String getFieldMembers() {
    return mMembers;
  }

  public String getFieldMerchantId() {
    return mMerchantId;
  }

  public String getFieldMerchantReviewStatus() {
    return mMerchantReviewStatus;
  }

  public MessagingFeatureStatus getFieldMessagingFeatureStatus() {
    return mMessagingFeatureStatus;
  }

  public List<String> getFieldMessengerAdsDefaultIcebreakers() {
    return mMessengerAdsDefaultIcebreakers;
  }

  public List<String> getFieldMessengerAdsDefaultQuickReplies() {
    return mMessengerAdsDefaultQuickReplies;
  }

  public String getFieldMessengerAdsQuickRepliesType() {
    return mMessengerAdsQuickRepliesType;
  }

  public Shop getFieldMiniShopStorefront() {
    if (mMiniShopStorefront != null) {
      mMiniShopStorefront.context = getContext();
    }
    return mMiniShopStorefront;
  }

  public String getFieldMission() {
    return mMission;
  }

  public String getFieldMpg() {
    return mMpg;
  }

  public String getFieldName() {
    return mName;
  }

  public String getFieldNameWithLocationDescriptor() {
    return mNameWithLocationDescriptor;
  }

  public String getFieldNetwork() {
    return mNetwork;
  }

  public Long getFieldNewLikeCount() {
    return mNewLikeCount;
  }

  public Boolean getFieldOfferEligible() {
    return mOfferEligible;
  }

  public Double getFieldOverallStarRating() {
    return mOverallStarRating;
  }

  public Business getFieldOwnerBusiness() {
    if (mOwnerBusiness != null) {
      mOwnerBusiness.context = getContext();
    }
    return mOwnerBusiness;
  }

  public String getFieldPageToken() {
    return mPageToken;
  }

  public Page getFieldParentPage() {
    if (mParentPage != null) {
      mParentPage.context = getContext();
    }
    return mParentPage;
  }

  public PageParking getFieldParking() {
    return mParking;
  }

  public PagePaymentOptions getFieldPaymentOptions() {
    return mPaymentOptions;
  }

  public String getFieldPersonalInfo() {
    return mPersonalInfo;
  }

  public String getFieldPersonalInterests() {
    return mPersonalInterests;
  }

  public String getFieldPharmaSafetyInfo() {
    return mPharmaSafetyInfo;
  }

  public String getFieldPhone() {
    return mPhone;
  }

  public List<String> getFieldPickupOptions() {
    return mPickupOptions;
  }

  public String getFieldPlaceType() {
    return mPlaceType;
  }

  public String getFieldPlotOutline() {
    return mPlotOutline;
  }

  public Targeting getFieldPreferredAudience() {
    return mPreferredAudience;
  }

  public String getFieldPressContact() {
    return mPressContact;
  }

  public String getFieldPriceRange() {
    return mPriceRange;
  }

  public String getFieldPrivacyInfoUrl() {
    return mPrivacyInfoUrl;
  }

  public String getFieldProducedBy() {
    return mProducedBy;
  }

  public String getFieldProducts() {
    return mProducts;
  }

  public Boolean getFieldPromotionEligible() {
    return mPromotionEligible;
  }

  public String getFieldPromotionIneligibleReason() {
    return mPromotionIneligibleReason;
  }

  public String getFieldPublicTransit() {
    return mPublicTransit;
  }

  public Long getFieldRatingCount() {
    return mRatingCount;
  }

  public String getFieldRecipient() {
    return mRecipient;
  }

  public String getFieldRecordLabel() {
    return mRecordLabel;
  }

  public String getFieldReleaseDate() {
    return mReleaseDate;
  }

  public PageRestaurantServices getFieldRestaurantServices() {
    return mRestaurantServices;
  }

  public PageRestaurantSpecialties getFieldRestaurantSpecialties() {
    return mRestaurantSpecialties;
  }

  public String getFieldSchedule() {
    return mSchedule;
  }

  public String getFieldScreenplayBy() {
    return mScreenplayBy;
  }

  public String getFieldSeason() {
    return mSeason;
  }

  public String getFieldSingleLineAddress() {
    return mSingleLineAddress;
  }

  public String getFieldStarring() {
    return mStarring;
  }

  public PageStartInfo getFieldStartInfo() {
    return mStartInfo;
  }

  public String getFieldStoreCode() {
    return mStoreCode;
  }

  public String getFieldStoreLocationDescriptor() {
    return mStoreLocationDescriptor;
  }

  public Long getFieldStoreNumber() {
    return mStoreNumber;
  }

  public String getFieldStudio() {
    return mStudio;
  }

  public Boolean getFieldSupportsDonateButtonInLiveVideo() {
    return mSupportsDonateButtonInLiveVideo;
  }

  public Long getFieldTalkingAboutCount() {
    return mTalkingAboutCount;
  }

  public String getFieldTemporaryStatus() {
    return mTemporaryStatus;
  }

  public Long getFieldUnreadMessageCount() {
    return mUnreadMessageCount;
  }

  public Long getFieldUnreadNotifCount() {
    return mUnreadNotifCount;
  }

  public Long getFieldUnseenMessageCount() {
    return mUnseenMessageCount;
  }

  public String getFieldUserAccessExpireTime() {
    return mUserAccessExpireTime;
  }

  public String getFieldUsername() {
    return mUsername;
  }

  public String getFieldVerificationStatus() {
    return mVerificationStatus;
  }

  public VoipInfo getFieldVoipInfo() {
    return mVoipInfo;
  }

  public String getFieldWebsite() {
    return mWebsite;
  }

  public Long getFieldWereHereCount() {
    return mWereHereCount;
  }

  public String getFieldWhatsappNumber() {
    return mWhatsappNumber;
  }

  public String getFieldWrittenBy() {
    return mWrittenBy;
  }



  public static class APIRequestGetAbTests extends APIRequest<PagePostExperiment> {

    APINodeList<PagePostExperiment> lastResponse = null;
    @Override
    public APINodeList<PagePostExperiment> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "auto_resolve_settings",
      "control_video_id",
      "creation_time",
      "creator",
      "declared_winning_time",
      "declared_winning_video_id",
      "description",
      "experiment_video_ids",
      "id",
      "insight_snapshots",
      "name",
      "optimization_goal",
      "publish_status",
      "publish_time",
      "scheduled_experiment_timestamp",
      "updated_time",
    };

    @Override
    public APINodeList<PagePostExperiment> parseResponse(String response, String header) throws APIException {
      return PagePostExperiment.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<PagePostExperiment> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<PagePostExperiment> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<PagePostExperiment>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<PagePostExperiment>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<PagePostExperiment>>() {
           public APINodeList<PagePostExperiment> apply(ResponseWrapper result) {
             try {
               return APIRequestGetAbTests.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetAbTests(String nodeId, APIContext context) {
      super(context, nodeId, "/ab_tests", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetAbTests setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetAbTests setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetAbTests requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetAbTests requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetAbTests requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetAbTests requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetAbTests requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetAbTests requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetAbTests requestAutoResolveSettingsField () {
      return this.requestAutoResolveSettingsField(true);
    }
    public APIRequestGetAbTests requestAutoResolveSettingsField (boolean value) {
      this.requestField("auto_resolve_settings", value);
      return this;
    }
    public APIRequestGetAbTests requestControlVideoIdField () {
      return this.requestControlVideoIdField(true);
    }
    public APIRequestGetAbTests requestControlVideoIdField (boolean value) {
      this.requestField("control_video_id", value);
      return this;
    }
    public APIRequestGetAbTests requestCreationTimeField () {
      return this.requestCreationTimeField(true);
    }
    public APIRequestGetAbTests requestCreationTimeField (boolean value) {
      this.requestField("creation_time", value);
      return this;
    }
    public APIRequestGetAbTests requestCreatorField () {
      return this.requestCreatorField(true);
    }
    public APIRequestGetAbTests requestCreatorField (boolean value) {
      this.requestField("creator", value);
      return this;
    }
    public APIRequestGetAbTests requestDeclaredWinningTimeField () {
      return this.requestDeclaredWinningTimeField(true);
    }
    public APIRequestGetAbTests requestDeclaredWinningTimeField (boolean value) {
      this.requestField("declared_winning_time", value);
      return this;
    }
    public APIRequestGetAbTests requestDeclaredWinningVideoIdField () {
      return this.requestDeclaredWinningVideoIdField(true);
    }
    public APIRequestGetAbTests requestDeclaredWinningVideoIdField (boolean value) {
      this.requestField("declared_winning_video_id", value);
      return this;
    }
    public APIRequestGetAbTests requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetAbTests requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetAbTests requestExperimentVideoIdsField () {
      return this.requestExperimentVideoIdsField(true);
    }
    public APIRequestGetAbTests requestExperimentVideoIdsField (boolean value) {
      this.requestField("experiment_video_ids", value);
      return this;
    }
    public APIRequestGetAbTests requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetAbTests requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetAbTests requestInsightSnapshotsField () {
      return this.requestInsightSnapshotsField(true);
    }
    public APIRequestGetAbTests requestInsightSnapshotsField (boolean value) {
      this.requestField("insight_snapshots", value);
      return this;
    }
    public APIRequestGetAbTests requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetAbTests requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetAbTests requestOptimizationGoalField () {
      return this.requestOptimizationGoalField(true);
    }
    public APIRequestGetAbTests requestOptimizationGoalField (boolean value) {
      this.requestField("optimization_goal", value);
      return this;
    }
    public APIRequestGetAbTests requestPublishStatusField () {
      return this.requestPublishStatusField(true);
    }
    public APIRequestGetAbTests requestPublishStatusField (boolean value) {
      this.requestField("publish_status", value);
      return this;
    }
    public APIRequestGetAbTests requestPublishTimeField () {
      return this.requestPublishTimeField(true);
    }
    public APIRequestGetAbTests requestPublishTimeField (boolean value) {
      this.requestField("publish_time", value);
      return this;
    }
    public APIRequestGetAbTests requestScheduledExperimentTimestampField () {
      return this.requestScheduledExperimentTimestampField(true);
    }
    public APIRequestGetAbTests requestScheduledExperimentTimestampField (boolean value) {
      this.requestField("scheduled_experiment_timestamp", value);
      return this;
    }
    public APIRequestGetAbTests requestUpdatedTimeField () {
      return this.requestUpdatedTimeField(true);
    }
    public APIRequestGetAbTests requestUpdatedTimeField (boolean value) {
      this.requestField("updated_time", value);
      return this;
    }
  }

  public static class APIRequestCreateAbTest extends APIRequest<PagePostExperiment> {

    PagePostExperiment lastResponse = null;
    @Override
    public PagePostExperiment getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "control_video_id",
      "description",
      "duration",
      "experiment_video_ids",
      "name",
      "optimization_goal",
      "scheduled_experiment_timestamp",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public PagePostExperiment parseResponse(String response, String header) throws APIException {
      return PagePostExperiment.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public PagePostExperiment execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public PagePostExperiment execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<PagePostExperiment> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<PagePostExperiment> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, PagePostExperiment>() {
           public PagePostExperiment apply(ResponseWrapper result) {
             try {
               return APIRequestCreateAbTest.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateAbTest(String nodeId, APIContext context) {
      super(context, nodeId, "/ab_tests", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateAbTest setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateAbTest setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateAbTest setControlVideoId (String controlVideoId) {
      this.setParam("control_video_id", controlVideoId);
      return this;
    }

    public APIRequestCreateAbTest setDescription (String description) {
      this.setParam("description", description);
      return this;
    }

    public APIRequestCreateAbTest setDuration (Long duration) {
      this.setParam("duration", duration);
      return this;
    }
    public APIRequestCreateAbTest setDuration (String duration) {
      this.setParam("duration", duration);
      return this;
    }

    public APIRequestCreateAbTest setExperimentVideoIds (List<String> experimentVideoIds) {
      this.setParam("experiment_video_ids", experimentVideoIds);
      return this;
    }
    public APIRequestCreateAbTest setExperimentVideoIds (String experimentVideoIds) {
      this.setParam("experiment_video_ids", experimentVideoIds);
      return this;
    }

    public APIRequestCreateAbTest setName (String name) {
      this.setParam("name", name);
      return this;
    }

    public APIRequestCreateAbTest setOptimizationGoal (PagePostExperiment.EnumOptimizationGoal optimizationGoal) {
      this.setParam("optimization_goal", optimizationGoal);
      return this;
    }
    public APIRequestCreateAbTest setOptimizationGoal (String optimizationGoal) {
      this.setParam("optimization_goal", optimizationGoal);
      return this;
    }

    public APIRequestCreateAbTest setScheduledExperimentTimestamp (Long scheduledExperimentTimestamp) {
      this.setParam("scheduled_experiment_timestamp", scheduledExperimentTimestamp);
      return this;
    }
    public APIRequestCreateAbTest setScheduledExperimentTimestamp (String scheduledExperimentTimestamp) {
      this.setParam("scheduled_experiment_timestamp", scheduledExperimentTimestamp);
      return this;
    }

    public APIRequestCreateAbTest requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateAbTest requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateAbTest requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateAbTest requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateAbTest requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateAbTest requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestCreateAcknowledgeOrder extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "idempotency_key",
      "orders",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response, String header) throws APIException {
      return Page.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, Page>() {
           public Page apply(ResponseWrapper result) {
             try {
               return APIRequestCreateAcknowledgeOrder.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateAcknowledgeOrder(String nodeId, APIContext context) {
      super(context, nodeId, "/acknowledge_orders", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateAcknowledgeOrder setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateAcknowledgeOrder setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateAcknowledgeOrder setIdempotencyKey (String idempotencyKey) {
      this.setParam("idempotency_key", idempotencyKey);
      return this;
    }

    public APIRequestCreateAcknowledgeOrder setOrders (List<Map<String, String>> orders) {
      this.setParam("orders", orders);
      return this;
    }
    public APIRequestCreateAcknowledgeOrder setOrders (String orders) {
      this.setParam("orders", orders);
      return this;
    }

    public APIRequestCreateAcknowledgeOrder requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateAcknowledgeOrder requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateAcknowledgeOrder requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateAcknowledgeOrder requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateAcknowledgeOrder requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateAcknowledgeOrder requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetAdsEligibility extends APIRequest<AdsEligibility> {

    APINodeList<AdsEligibility> lastResponse = null;
    @Override
    public APINodeList<AdsEligibility> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "ads_account_id",
    };

    public static final String[] FIELDS = {
      "live_shopping",
    };

    @Override
    public APINodeList<AdsEligibility> parseResponse(String response, String header) throws APIException {
      return AdsEligibility.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<AdsEligibility> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<AdsEligibility> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<AdsEligibility>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<AdsEligibility>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<AdsEligibility>>() {
           public APINodeList<AdsEligibility> apply(ResponseWrapper result) {
             try {
               return APIRequestGetAdsEligibility.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetAdsEligibility(String nodeId, APIContext context) {
      super(context, nodeId, "/ads_eligibility", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetAdsEligibility setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetAdsEligibility setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetAdsEligibility setAdsAccountId (String adsAccountId) {
      this.setParam("ads_account_id", adsAccountId);
      return this;
    }

    public APIRequestGetAdsEligibility requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetAdsEligibility requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetAdsEligibility requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetAdsEligibility requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetAdsEligibility requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetAdsEligibility requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetAdsEligibility requestLiveShoppingField () {
      return this.requestLiveShoppingField(true);
    }
    public APIRequestGetAdsEligibility requestLiveShoppingField (boolean value) {
      this.requestField("live_shopping", value);
      return this;
    }
  }

  public static class APIRequestGetAdsPosts extends APIRequest<PagePost> {

    APINodeList<PagePost> lastResponse = null;
    @Override
    public APINodeList<PagePost> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "exclude_dynamic_ads",
      "include_inline_create",
      "since",
      "until",
    };

    public static final String[] FIELDS = {
      "actions",
      "admin_creator",
      "allowed_advertising_objectives",
      "application",
      "backdated_time",
      "call_to_action",
      "can_reply_privately",
      "child_attachments",
      "comments_mirroring_domain",
      "coordinates",
      "created_time",
      "event",
      "expanded_height",
      "expanded_width",
      "feed_targeting",
      "from",
      "full_picture",
      "height",
      "icon",
      "id",
      "instagram_eligibility",
      "is_app_share",
      "is_eligible_for_promotion",
      "is_expired",
      "is_hidden",
      "is_inline_created",
      "is_instagram_eligible",
      "is_popular",
      "is_published",
      "is_spherical",
      "message",
      "message_tags",
      "multi_share_end_card",
      "multi_share_optimized",
      "parent_id",
      "permalink_url",
      "picture",
      "place",
      "privacy",
      "promotable_id",
      "promotion_status",
      "properties",
      "scheduled_publish_time",
      "shares",
      "status_type",
      "story",
      "story_tags",
      "subscribed",
      "target",
      "targeting",
      "timeline_visibility",
      "updated_time",
      "via",
      "video_buying_eligibility",
      "width",
    };

    @Override
    public APINodeList<PagePost> parseResponse(String response, String header) throws APIException {
      return PagePost.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<PagePost> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<PagePost> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<PagePost>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<PagePost>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<PagePost>>() {
           public APINodeList<PagePost> apply(ResponseWrapper result) {
             try {
               return APIRequestGetAdsPosts.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetAdsPosts(String nodeId, APIContext context) {
      super(context, nodeId, "/ads_posts", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetAdsPosts setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetAdsPosts setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetAdsPosts setExcludeDynamicAds (Boolean excludeDynamicAds) {
      this.setParam("exclude_dynamic_ads", excludeDynamicAds);
      return this;
    }
    public APIRequestGetAdsPosts setExcludeDynamicAds (String excludeDynamicAds) {
      this.setParam("exclude_dynamic_ads", excludeDynamicAds);
      return this;
    }

    public APIRequestGetAdsPosts setIncludeInlineCreate (Boolean includeInlineCreate) {
      this.setParam("include_inline_create", includeInlineCreate);
      return this;
    }
    public APIRequestGetAdsPosts setIncludeInlineCreate (String includeInlineCreate) {
      this.setParam("include_inline_create", includeInlineCreate);
      return this;
    }

    public APIRequestGetAdsPosts setSince (String since) {
      this.setParam("since", since);
      return this;
    }

    public APIRequestGetAdsPosts setUntil (String until) {
      this.setParam("until", until);
      return this;
    }

    public APIRequestGetAdsPosts requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetAdsPosts requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetAdsPosts requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetAdsPosts requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetAdsPosts requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetAdsPosts requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetAdsPosts requestActionsField () {
      return this.requestActionsField(true);
    }
    public APIRequestGetAdsPosts requestActionsField (boolean value) {
      this.requestField("actions", value);
      return this;
    }
    public APIRequestGetAdsPosts requestAdminCreatorField () {
      return this.requestAdminCreatorField(true);
    }
    public APIRequestGetAdsPosts requestAdminCreatorField (boolean value) {
      this.requestField("admin_creator", value);
      return this;
    }
    public APIRequestGetAdsPosts requestAllowedAdvertisingObjectivesField () {
      return this.requestAllowedAdvertisingObjectivesField(true);
    }
    public APIRequestGetAdsPosts requestAllowedAdvertisingObjectivesField (boolean value) {
      this.requestField("allowed_advertising_objectives", value);
      return this;
    }
    public APIRequestGetAdsPosts requestApplicationField () {
      return this.requestApplicationField(true);
    }
    public APIRequestGetAdsPosts requestApplicationField (boolean value) {
      this.requestField("application", value);
      return this;
    }
    public APIRequestGetAdsPosts requestBackdatedTimeField () {
      return this.requestBackdatedTimeField(true);
    }
    public APIRequestGetAdsPosts requestBackdatedTimeField (boolean value) {
      this.requestField("backdated_time", value);
      return this;
    }
    public APIRequestGetAdsPosts requestCallToActionField () {
      return this.requestCallToActionField(true);
    }
    public APIRequestGetAdsPosts requestCallToActionField (boolean value) {
      this.requestField("call_to_action", value);
      return this;
    }
    public APIRequestGetAdsPosts requestCanReplyPrivatelyField () {
      return this.requestCanReplyPrivatelyField(true);
    }
    public APIRequestGetAdsPosts requestCanReplyPrivatelyField (boolean value) {
      this.requestField("can_reply_privately", value);
      return this;
    }
    public APIRequestGetAdsPosts requestChildAttachmentsField () {
      return this.requestChildAttachmentsField(true);
    }
    public APIRequestGetAdsPosts requestChildAttachmentsField (boolean value) {
      this.requestField("child_attachments", value);
      return this;
    }
    public APIRequestGetAdsPosts requestCommentsMirroringDomainField () {
      return this.requestCommentsMirroringDomainField(true);
    }
    public APIRequestGetAdsPosts requestCommentsMirroringDomainField (boolean value) {
      this.requestField("comments_mirroring_domain", value);
      return this;
    }
    public APIRequestGetAdsPosts requestCoordinatesField () {
      return this.requestCoordinatesField(true);
    }
    public APIRequestGetAdsPosts requestCoordinatesField (boolean value) {
      this.requestField("coordinates", value);
      return this;
    }
    public APIRequestGetAdsPosts requestCreatedTimeField () {
      return this.requestCreatedTimeField(true);
    }
    public APIRequestGetAdsPosts requestCreatedTimeField (boolean value) {
      this.requestField("created_time", value);
      return this;
    }
    public APIRequestGetAdsPosts requestEventField () {
      return this.requestEventField(true);
    }
    public APIRequestGetAdsPosts requestEventField (boolean value) {
      this.requestField("event", value);
      return this;
    }
    public APIRequestGetAdsPosts requestExpandedHeightField () {
      return this.requestExpandedHeightField(true);
    }
    public APIRequestGetAdsPosts requestExpandedHeightField (boolean value) {
      this.requestField("expanded_height", value);
      return this;
    }
    public APIRequestGetAdsPosts requestExpandedWidthField () {
      return this.requestExpandedWidthField(true);
    }
    public APIRequestGetAdsPosts requestExpandedWidthField (boolean value) {
      this.requestField("expanded_width", value);
      return this;
    }
    public APIRequestGetAdsPosts requestFeedTargetingField () {
      return this.requestFeedTargetingField(true);
    }
    public APIRequestGetAdsPosts requestFeedTargetingField (boolean value) {
      this.requestField("feed_targeting", value);
      return this;
    }
    public APIRequestGetAdsPosts requestFromField () {
      return this.requestFromField(true);
    }
    public APIRequestGetAdsPosts requestFromField (boolean value) {
      this.requestField("from", value);
      return this;
    }
    public APIRequestGetAdsPosts requestFullPictureField () {
      return this.requestFullPictureField(true);
    }
    public APIRequestGetAdsPosts requestFullPictureField (boolean value) {
      this.requestField("full_picture", value);
      return this;
    }
    public APIRequestGetAdsPosts requestHeightField () {
      return this.requestHeightField(true);
    }
    public APIRequestGetAdsPosts requestHeightField (boolean value) {
      this.requestField("height", value);
      return this;
    }
    public APIRequestGetAdsPosts requestIconField () {
      return this.requestIconField(true);
    }
    public APIRequestGetAdsPosts requestIconField (boolean value) {
      this.requestField("icon", value);
      return this;
    }
    public APIRequestGetAdsPosts requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetAdsPosts requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetAdsPosts requestInstagramEligibilityField () {
      return this.requestInstagramEligibilityField(true);
    }
    public APIRequestGetAdsPosts requestInstagramEligibilityField (boolean value) {
      this.requestField("instagram_eligibility", value);
      return this;
    }
    public APIRequestGetAdsPosts requestIsAppShareField () {
      return this.requestIsAppShareField(true);
    }
    public APIRequestGetAdsPosts requestIsAppShareField (boolean value) {
      this.requestField("is_app_share", value);
      return this;
    }
    public APIRequestGetAdsPosts requestIsEligibleForPromotionField () {
      return this.requestIsEligibleForPromotionField(true);
    }
    public APIRequestGetAdsPosts requestIsEligibleForPromotionField (boolean value) {
      this.requestField("is_eligible_for_promotion", value);
      return this;
    }
    public APIRequestGetAdsPosts requestIsExpiredField () {
      return this.requestIsExpiredField(true);
    }
    public APIRequestGetAdsPosts requestIsExpiredField (boolean value) {
      this.requestField("is_expired", value);
      return this;
    }
    public APIRequestGetAdsPosts requestIsHiddenField () {
      return this.requestIsHiddenField(true);
    }
    public APIRequestGetAdsPosts requestIsHiddenField (boolean value) {
      this.requestField("is_hidden", value);
      return this;
    }
    public APIRequestGetAdsPosts requestIsInlineCreatedField () {
      return this.requestIsInlineCreatedField(true);
    }
    public APIRequestGetAdsPosts requestIsInlineCreatedField (boolean value) {
      this.requestField("is_inline_created", value);
      return this;
    }
    public APIRequestGetAdsPosts requestIsInstagramEligibleField () {
      return this.requestIsInstagramEligibleField(true);
    }
    public APIRequestGetAdsPosts requestIsInstagramEligibleField (boolean value) {
      this.requestField("is_instagram_eligible", value);
      return this;
    }
    public APIRequestGetAdsPosts requestIsPopularField () {
      return this.requestIsPopularField(true);
    }
    public APIRequestGetAdsPosts requestIsPopularField (boolean value) {
      this.requestField("is_popular", value);
      return this;
    }
    public APIRequestGetAdsPosts requestIsPublishedField () {
      return this.requestIsPublishedField(true);
    }
    public APIRequestGetAdsPosts requestIsPublishedField (boolean value) {
      this.requestField("is_published", value);
      return this;
    }
    public APIRequestGetAdsPosts requestIsSphericalField () {
      return this.requestIsSphericalField(true);
    }
    public APIRequestGetAdsPosts requestIsSphericalField (boolean value) {
      this.requestField("is_spherical", value);
      return this;
    }
    public APIRequestGetAdsPosts requestMessageField () {
      return this.requestMessageField(true);
    }
    public APIRequestGetAdsPosts requestMessageField (boolean value) {
      this.requestField("message", value);
      return this;
    }
    public APIRequestGetAdsPosts requestMessageTagsField () {
      return this.requestMessageTagsField(true);
    }
    public APIRequestGetAdsPosts requestMessageTagsField (boolean value) {
      this.requestField("message_tags", value);
      return this;
    }
    public APIRequestGetAdsPosts requestMultiShareEndCardField () {
      return this.requestMultiShareEndCardField(true);
    }
    public APIRequestGetAdsPosts requestMultiShareEndCardField (boolean value) {
      this.requestField("multi_share_end_card", value);
      return this;
    }
    public APIRequestGetAdsPosts requestMultiShareOptimizedField () {
      return this.requestMultiShareOptimizedField(true);
    }
    public APIRequestGetAdsPosts requestMultiShareOptimizedField (boolean value) {
      this.requestField("multi_share_optimized", value);
      return this;
    }
    public APIRequestGetAdsPosts requestParentIdField () {
      return this.requestParentIdField(true);
    }
    public APIRequestGetAdsPosts requestParentIdField (boolean value) {
      this.requestField("parent_id", value);
      return this;
    }
    public APIRequestGetAdsPosts requestPermalinkUrlField () {
      return this.requestPermalinkUrlField(true);
    }
    public APIRequestGetAdsPosts requestPermalinkUrlField (boolean value) {
      this.requestField("permalink_url", value);
      return this;
    }
    public APIRequestGetAdsPosts requestPictureField () {
      return this.requestPictureField(true);
    }
    public APIRequestGetAdsPosts requestPictureField (boolean value) {
      this.requestField("picture", value);
      return this;
    }
    public APIRequestGetAdsPosts requestPlaceField () {
      return this.requestPlaceField(true);
    }
    public APIRequestGetAdsPosts requestPlaceField (boolean value) {
      this.requestField("place", value);
      return this;
    }
    public APIRequestGetAdsPosts requestPrivacyField () {
      return this.requestPrivacyField(true);
    }
    public APIRequestGetAdsPosts requestPrivacyField (boolean value) {
      this.requestField("privacy", value);
      return this;
    }
    public APIRequestGetAdsPosts requestPromotableIdField () {
      return this.requestPromotableIdField(true);
    }
    public APIRequestGetAdsPosts requestPromotableIdField (boolean value) {
      this.requestField("promotable_id", value);
      return this;
    }
    public APIRequestGetAdsPosts requestPromotionStatusField () {
      return this.requestPromotionStatusField(true);
    }
    public APIRequestGetAdsPosts requestPromotionStatusField (boolean value) {
      this.requestField("promotion_status", value);
      return this;
    }
    public APIRequestGetAdsPosts requestPropertiesField () {
      return this.requestPropertiesField(true);
    }
    public APIRequestGetAdsPosts requestPropertiesField (boolean value) {
      this.requestField("properties", value);
      return this;
    }
    public APIRequestGetAdsPosts requestScheduledPublishTimeField () {
      return this.requestScheduledPublishTimeField(true);
    }
    public APIRequestGetAdsPosts requestScheduledPublishTimeField (boolean value) {
      this.requestField("scheduled_publish_time", value);
      return this;
    }
    public APIRequestGetAdsPosts requestSharesField () {
      return this.requestSharesField(true);
    }
    public APIRequestGetAdsPosts requestSharesField (boolean value) {
      this.requestField("shares", value);
      return this;
    }
    public APIRequestGetAdsPosts requestStatusTypeField () {
      return this.requestStatusTypeField(true);
    }
    public APIRequestGetAdsPosts requestStatusTypeField (boolean value) {
      this.requestField("status_type", value);
      return this;
    }
    public APIRequestGetAdsPosts requestStoryField () {
      return this.requestStoryField(true);
    }
    public APIRequestGetAdsPosts requestStoryField (boolean value) {
      this.requestField("story", value);
      return this;
    }
    public APIRequestGetAdsPosts requestStoryTagsField () {
      return this.requestStoryTagsField(true);
    }
    public APIRequestGetAdsPosts requestStoryTagsField (boolean value) {
      this.requestField("story_tags", value);
      return this;
    }
    public APIRequestGetAdsPosts requestSubscribedField () {
      return this.requestSubscribedField(true);
    }
    public APIRequestGetAdsPosts requestSubscribedField (boolean value) {
      this.requestField("subscribed", value);
      return this;
    }
    public APIRequestGetAdsPosts requestTargetField () {
      return this.requestTargetField(true);
    }
    public APIRequestGetAdsPosts requestTargetField (boolean value) {
      this.requestField("target", value);
      return this;
    }
    public APIRequestGetAdsPosts requestTargetingField () {
      return this.requestTargetingField(true);
    }
    public APIRequestGetAdsPosts requestTargetingField (boolean value) {
      this.requestField("targeting", value);
      return this;
    }
    public APIRequestGetAdsPosts requestTimelineVisibilityField () {
      return this.requestTimelineVisibilityField(true);
    }
    public APIRequestGetAdsPosts requestTimelineVisibilityField (boolean value) {
      this.requestField("timeline_visibility", value);
      return this;
    }
    public APIRequestGetAdsPosts requestUpdatedTimeField () {
      return this.requestUpdatedTimeField(true);
    }
    public APIRequestGetAdsPosts requestUpdatedTimeField (boolean value) {
      this.requestField("updated_time", value);
      return this;
    }
    public APIRequestGetAdsPosts requestViaField () {
      return this.requestViaField(true);
    }
    public APIRequestGetAdsPosts requestViaField (boolean value) {
      this.requestField("via", value);
      return this;
    }
    public APIRequestGetAdsPosts requestVideoBuyingEligibilityField () {
      return this.requestVideoBuyingEligibilityField(true);
    }
    public APIRequestGetAdsPosts requestVideoBuyingEligibilityField (boolean value) {
      this.requestField("video_buying_eligibility", value);
      return this;
    }
    public APIRequestGetAdsPosts requestWidthField () {
      return this.requestWidthField(true);
    }
    public APIRequestGetAdsPosts requestWidthField (boolean value) {
      this.requestField("width", value);
      return this;
    }
  }

  public static class APIRequestDeleteAgencies extends APIRequest<APINode> {

    APINodeList<APINode> lastResponse = null;
    @Override
    public APINodeList<APINode> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "business",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
      return APINode.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<APINode> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<APINode>>() {
           public APINodeList<APINode> apply(ResponseWrapper result) {
             try {
               return APIRequestDeleteAgencies.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestDeleteAgencies(String nodeId, APIContext context) {
      super(context, nodeId, "/agencies", "DELETE", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestDeleteAgencies setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestDeleteAgencies setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestDeleteAgencies setBusiness (String business) {
      this.setParam("business", business);
      return this;
    }

    public APIRequestDeleteAgencies requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestDeleteAgencies requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteAgencies requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestDeleteAgencies requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteAgencies requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestDeleteAgencies requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetAgencies extends APIRequest<Business> {

    APINodeList<Business> lastResponse = null;
    @Override
    public APINodeList<Business> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "block_offline_analytics",
      "collaborative_ads_managed_partner_business_info",
      "collaborative_ads_managed_partner_eligibility",
      "collaborative_ads_partner_premium_options",
      "created_by",
      "created_time",
      "extended_updated_time",
      "id",
      "is_hidden",
      "link",
      "marketing_messages_onboarding_status",
      "name",
      "primary_page",
      "profile_picture_uri",
      "timezone_id",
      "two_factor_type",
      "updated_by",
      "updated_time",
      "user_access_expire_time",
      "verification_status",
      "vertical",
      "vertical_id",
    };

    @Override
    public APINodeList<Business> parseResponse(String response, String header) throws APIException {
      return Business.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<Business> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Business> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Business>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Business>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<Business>>() {
           public APINodeList<Business> apply(ResponseWrapper result) {
             try {
               return APIRequestGetAgencies.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetAgencies(String nodeId, APIContext context) {
      super(context, nodeId, "/agencies", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetAgencies setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetAgencies setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetAgencies requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetAgencies requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetAgencies requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetAgencies requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetAgencies requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetAgencies requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetAgencies requestBlockOfflineAnalyticsField () {
      return this.requestBlockOfflineAnalyticsField(true);
    }
    public APIRequestGetAgencies requestBlockOfflineAnalyticsField (boolean value) {
      this.requestField("block_offline_analytics", value);
      return this;
    }
    public APIRequestGetAgencies requestCollaborativeAdsManagedPartnerBusinessInfoField () {
      return this.requestCollaborativeAdsManagedPartnerBusinessInfoField(true);
    }
    public APIRequestGetAgencies requestCollaborativeAdsManagedPartnerBusinessInfoField (boolean value) {
      this.requestField("collaborative_ads_managed_partner_business_info", value);
      return this;
    }
    public APIRequestGetAgencies requestCollaborativeAdsManagedPartnerEligibilityField () {
      return this.requestCollaborativeAdsManagedPartnerEligibilityField(true);
    }
    public APIRequestGetAgencies requestCollaborativeAdsManagedPartnerEligibilityField (boolean value) {
      this.requestField("collaborative_ads_managed_partner_eligibility", value);
      return this;
    }
    public APIRequestGetAgencies requestCollaborativeAdsPartnerPremiumOptionsField () {
      return this.requestCollaborativeAdsPartnerPremiumOptionsField(true);
    }
    public APIRequestGetAgencies requestCollaborativeAdsPartnerPremiumOptionsField (boolean value) {
      this.requestField("collaborative_ads_partner_premium_options", value);
      return this;
    }
    public APIRequestGetAgencies requestCreatedByField () {
      return this.requestCreatedByField(true);
    }
    public APIRequestGetAgencies requestCreatedByField (boolean value) {
      this.requestField("created_by", value);
      return this;
    }
    public APIRequestGetAgencies requestCreatedTimeField () {
      return this.requestCreatedTimeField(true);
    }
    public APIRequestGetAgencies requestCreatedTimeField (boolean value) {
      this.requestField("created_time", value);
      return this;
    }
    public APIRequestGetAgencies requestExtendedUpdatedTimeField () {
      return this.requestExtendedUpdatedTimeField(true);
    }
    public APIRequestGetAgencies requestExtendedUpdatedTimeField (boolean value) {
      this.requestField("extended_updated_time", value);
      return this;
    }
    public APIRequestGetAgencies requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetAgencies requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetAgencies requestIsHiddenField () {
      return this.requestIsHiddenField(true);
    }
    public APIRequestGetAgencies requestIsHiddenField (boolean value) {
      this.requestField("is_hidden", value);
      return this;
    }
    public APIRequestGetAgencies requestLinkField () {
      return this.requestLinkField(true);
    }
    public APIRequestGetAgencies requestLinkField (boolean value) {
      this.requestField("link", value);
      return this;
    }
    public APIRequestGetAgencies requestMarketingMessagesOnboardingStatusField () {
      return this.requestMarketingMessagesOnboardingStatusField(true);
    }
    public APIRequestGetAgencies requestMarketingMessagesOnboardingStatusField (boolean value) {
      this.requestField("marketing_messages_onboarding_status", value);
      return this;
    }
    public APIRequestGetAgencies requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetAgencies requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetAgencies requestPrimaryPageField () {
      return this.requestPrimaryPageField(true);
    }
    public APIRequestGetAgencies requestPrimaryPageField (boolean value) {
      this.requestField("primary_page", value);
      return this;
    }
    public APIRequestGetAgencies requestProfilePictureUriField () {
      return this.requestProfilePictureUriField(true);
    }
    public APIRequestGetAgencies requestProfilePictureUriField (boolean value) {
      this.requestField("profile_picture_uri", value);
      return this;
    }
    public APIRequestGetAgencies requestTimezoneIdField () {
      return this.requestTimezoneIdField(true);
    }
    public APIRequestGetAgencies requestTimezoneIdField (boolean value) {
      this.requestField("timezone_id", value);
      return this;
    }
    public APIRequestGetAgencies requestTwoFactorTypeField () {
      return this.requestTwoFactorTypeField(true);
    }
    public APIRequestGetAgencies requestTwoFactorTypeField (boolean value) {
      this.requestField("two_factor_type", value);
      return this;
    }
    public APIRequestGetAgencies requestUpdatedByField () {
      return this.requestUpdatedByField(true);
    }
    public APIRequestGetAgencies requestUpdatedByField (boolean value) {
      this.requestField("updated_by", value);
      return this;
    }
    public APIRequestGetAgencies requestUpdatedTimeField () {
      return this.requestUpdatedTimeField(true);
    }
    public APIRequestGetAgencies requestUpdatedTimeField (boolean value) {
      this.requestField("updated_time", value);
      return this;
    }
    public APIRequestGetAgencies requestUserAccessExpireTimeField () {
      return this.requestUserAccessExpireTimeField(true);
    }
    public APIRequestGetAgencies requestUserAccessExpireTimeField (boolean value) {
      this.requestField("user_access_expire_time", value);
      return this;
    }
    public APIRequestGetAgencies requestVerificationStatusField () {
      return this.requestVerificationStatusField(true);
    }
    public APIRequestGetAgencies requestVerificationStatusField (boolean value) {
      this.requestField("verification_status", value);
      return this;
    }
    public APIRequestGetAgencies requestVerticalField () {
      return this.requestVerticalField(true);
    }
    public APIRequestGetAgencies requestVerticalField (boolean value) {
      this.requestField("vertical", value);
      return this;
    }
    public APIRequestGetAgencies requestVerticalIdField () {
      return this.requestVerticalIdField(true);
    }
    public APIRequestGetAgencies requestVerticalIdField (boolean value) {
      this.requestField("vertical_id", value);
      return this;
    }
  }

  public static class APIRequestCreateAgency extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "business",
      "permitted_tasks",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response, String header) throws APIException {
      return Page.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, Page>() {
           public Page apply(ResponseWrapper result) {
             try {
               return APIRequestCreateAgency.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateAgency(String nodeId, APIContext context) {
      super(context, nodeId, "/agencies", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateAgency setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateAgency setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateAgency setBusiness (String business) {
      this.setParam("business", business);
      return this;
    }

    public APIRequestCreateAgency setPermittedTasks (List<Page.EnumPermittedTasks> permittedTasks) {
      this.setParam("permitted_tasks", permittedTasks);
      return this;
    }
    public APIRequestCreateAgency setPermittedTasks (String permittedTasks) {
      this.setParam("permitted_tasks", permittedTasks);
      return this;
    }

    public APIRequestCreateAgency requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateAgency requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateAgency requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateAgency requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateAgency requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateAgency requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetAlbums extends APIRequest<Album> {

    APINodeList<Album> lastResponse = null;
    @Override
    public APINodeList<Album> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "backdated_time",
      "backdated_time_granularity",
      "can_backdate",
      "can_upload",
      "count",
      "cover_photo",
      "created_time",
      "description",
      "edit_link",
      "event",
      "from",
      "id",
      "is_user_facing",
      "link",
      "location",
      "modified_major",
      "name",
      "photo_count",
      "place",
      "privacy",
      "type",
      "updated_time",
      "video_count",
    };

    @Override
    public APINodeList<Album> parseResponse(String response, String header) throws APIException {
      return Album.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<Album> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Album> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Album>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Album>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<Album>>() {
           public APINodeList<Album> apply(ResponseWrapper result) {
             try {
               return APIRequestGetAlbums.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetAlbums(String nodeId, APIContext context) {
      super(context, nodeId, "/albums", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetAlbums setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetAlbums setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetAlbums requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetAlbums requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetAlbums requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetAlbums requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetAlbums requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetAlbums requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetAlbums requestBackdatedTimeField () {
      return this.requestBackdatedTimeField(true);
    }
    public APIRequestGetAlbums requestBackdatedTimeField (boolean value) {
      this.requestField("backdated_time", value);
      return this;
    }
    public APIRequestGetAlbums requestBackdatedTimeGranularityField () {
      return this.requestBackdatedTimeGranularityField(true);
    }
    public APIRequestGetAlbums requestBackdatedTimeGranularityField (boolean value) {
      this.requestField("backdated_time_granularity", value);
      return this;
    }
    public APIRequestGetAlbums requestCanBackdateField () {
      return this.requestCanBackdateField(true);
    }
    public APIRequestGetAlbums requestCanBackdateField (boolean value) {
      this.requestField("can_backdate", value);
      return this;
    }
    public APIRequestGetAlbums requestCanUploadField () {
      return this.requestCanUploadField(true);
    }
    public APIRequestGetAlbums requestCanUploadField (boolean value) {
      this.requestField("can_upload", value);
      return this;
    }
    public APIRequestGetAlbums requestCountField () {
      return this.requestCountField(true);
    }
    public APIRequestGetAlbums requestCountField (boolean value) {
      this.requestField("count", value);
      return this;
    }
    public APIRequestGetAlbums requestCoverPhotoField () {
      return this.requestCoverPhotoField(true);
    }
    public APIRequestGetAlbums requestCoverPhotoField (boolean value) {
      this.requestField("cover_photo", value);
      return this;
    }
    public APIRequestGetAlbums requestCreatedTimeField () {
      return this.requestCreatedTimeField(true);
    }
    public APIRequestGetAlbums requestCreatedTimeField (boolean value) {
      this.requestField("created_time", value);
      return this;
    }
    public APIRequestGetAlbums requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetAlbums requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetAlbums requestEditLinkField () {
      return this.requestEditLinkField(true);
    }
    public APIRequestGetAlbums requestEditLinkField (boolean value) {
      this.requestField("edit_link", value);
      return this;
    }
    public APIRequestGetAlbums requestEventField () {
      return this.requestEventField(true);
    }
    public APIRequestGetAlbums requestEventField (boolean value) {
      this.requestField("event", value);
      return this;
    }
    public APIRequestGetAlbums requestFromField () {
      return this.requestFromField(true);
    }
    public APIRequestGetAlbums requestFromField (boolean value) {
      this.requestField("from", value);
      return this;
    }
    public APIRequestGetAlbums requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetAlbums requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetAlbums requestIsUserFacingField () {
      return this.requestIsUserFacingField(true);
    }
    public APIRequestGetAlbums requestIsUserFacingField (boolean value) {
      this.requestField("is_user_facing", value);
      return this;
    }
    public APIRequestGetAlbums requestLinkField () {
      return this.requestLinkField(true);
    }
    public APIRequestGetAlbums requestLinkField (boolean value) {
      this.requestField("link", value);
      return this;
    }
    public APIRequestGetAlbums requestLocationField () {
      return this.requestLocationField(true);
    }
    public APIRequestGetAlbums requestLocationField (boolean value) {
      this.requestField("location", value);
      return this;
    }
    public APIRequestGetAlbums requestModifiedMajorField () {
      return this.requestModifiedMajorField(true);
    }
    public APIRequestGetAlbums requestModifiedMajorField (boolean value) {
      this.requestField("modified_major", value);
      return this;
    }
    public APIRequestGetAlbums requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetAlbums requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetAlbums requestPhotoCountField () {
      return this.requestPhotoCountField(true);
    }
    public APIRequestGetAlbums requestPhotoCountField (boolean value) {
      this.requestField("photo_count", value);
      return this;
    }
    public APIRequestGetAlbums requestPlaceField () {
      return this.requestPlaceField(true);
    }
    public APIRequestGetAlbums requestPlaceField (boolean value) {
      this.requestField("place", value);
      return this;
    }
    public APIRequestGetAlbums requestPrivacyField () {
      return this.requestPrivacyField(true);
    }
    public APIRequestGetAlbums requestPrivacyField (boolean value) {
      this.requestField("privacy", value);
      return this;
    }
    public APIRequestGetAlbums requestTypeField () {
      return this.requestTypeField(true);
    }
    public APIRequestGetAlbums requestTypeField (boolean value) {
      this.requestField("type", value);
      return this;
    }
    public APIRequestGetAlbums requestUpdatedTimeField () {
      return this.requestUpdatedTimeField(true);
    }
    public APIRequestGetAlbums requestUpdatedTimeField (boolean value) {
      this.requestField("updated_time", value);
      return this;
    }
    public APIRequestGetAlbums requestVideoCountField () {
      return this.requestVideoCountField(true);
    }
    public APIRequestGetAlbums requestVideoCountField (boolean value) {
      this.requestField("video_count", value);
      return this;
    }
  }

  public static class APIRequestGetArExperience extends APIRequest<ArAdsDataContainer> {

    APINodeList<ArAdsDataContainer> lastResponse = null;
    @Override
    public APINodeList<ArAdsDataContainer> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "camera_facing_override",
      "creation_time",
      "effect",
      "id",
      "is_published",
      "last_modified_time",
      "name",
    };

    @Override
    public APINodeList<ArAdsDataContainer> parseResponse(String response, String header) throws APIException {
      return ArAdsDataContainer.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<ArAdsDataContainer> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<ArAdsDataContainer> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<ArAdsDataContainer>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<ArAdsDataContainer>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<ArAdsDataContainer>>() {
           public APINodeList<ArAdsDataContainer> apply(ResponseWrapper result) {
             try {
               return APIRequestGetArExperience.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetArExperience(String nodeId, APIContext context) {
      super(context, nodeId, "/ar_experience", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetArExperience setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetArExperience setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetArExperience requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetArExperience requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetArExperience requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetArExperience requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetArExperience requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetArExperience requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetArExperience requestCameraFacingOverrideField () {
      return this.requestCameraFacingOverrideField(true);
    }
    public APIRequestGetArExperience requestCameraFacingOverrideField (boolean value) {
      this.requestField("camera_facing_override", value);
      return this;
    }
    public APIRequestGetArExperience requestCreationTimeField () {
      return this.requestCreationTimeField(true);
    }
    public APIRequestGetArExperience requestCreationTimeField (boolean value) {
      this.requestField("creation_time", value);
      return this;
    }
    public APIRequestGetArExperience requestEffectField () {
      return this.requestEffectField(true);
    }
    public APIRequestGetArExperience requestEffectField (boolean value) {
      this.requestField("effect", value);
      return this;
    }
    public APIRequestGetArExperience requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetArExperience requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetArExperience requestIsPublishedField () {
      return this.requestIsPublishedField(true);
    }
    public APIRequestGetArExperience requestIsPublishedField (boolean value) {
      this.requestField("is_published", value);
      return this;
    }
    public APIRequestGetArExperience requestLastModifiedTimeField () {
      return this.requestLastModifiedTimeField(true);
    }
    public APIRequestGetArExperience requestLastModifiedTimeField (boolean value) {
      this.requestField("last_modified_time", value);
      return this;
    }
    public APIRequestGetArExperience requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetArExperience requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
  }

  public static class APIRequestDeleteAssignedUsers extends APIRequest<APINode> {

    APINodeList<APINode> lastResponse = null;
    @Override
    public APINodeList<APINode> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "user",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
      return APINode.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<APINode> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<APINode>>() {
           public APINodeList<APINode> apply(ResponseWrapper result) {
             try {
               return APIRequestDeleteAssignedUsers.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestDeleteAssignedUsers(String nodeId, APIContext context) {
      super(context, nodeId, "/assigned_users", "DELETE", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestDeleteAssignedUsers setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestDeleteAssignedUsers setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestDeleteAssignedUsers setUser (Long user) {
      this.setParam("user", user);
      return this;
    }
    public APIRequestDeleteAssignedUsers setUser (String user) {
      this.setParam("user", user);
      return this;
    }

    public APIRequestDeleteAssignedUsers requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestDeleteAssignedUsers requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteAssignedUsers requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestDeleteAssignedUsers requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteAssignedUsers requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestDeleteAssignedUsers requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetAssignedUsers extends APIRequest<AssignedUser> {

    APINodeList<AssignedUser> lastResponse = null;
    @Override
    public APINodeList<AssignedUser> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "business",
    };

    public static final String[] FIELDS = {
      "business",
      "id",
      "name",
      "user_type",
    };

    @Override
    public APINodeList<AssignedUser> parseResponse(String response, String header) throws APIException {
      return AssignedUser.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<AssignedUser> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<AssignedUser> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<AssignedUser>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<AssignedUser>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<AssignedUser>>() {
           public APINodeList<AssignedUser> apply(ResponseWrapper result) {
             try {
               return APIRequestGetAssignedUsers.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetAssignedUsers(String nodeId, APIContext context) {
      super(context, nodeId, "/assigned_users", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetAssignedUsers setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetAssignedUsers setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetAssignedUsers setBusiness (String business) {
      this.setParam("business", business);
      return this;
    }

    public APIRequestGetAssignedUsers requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetAssignedUsers requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetAssignedUsers requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetAssignedUsers requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetAssignedUsers requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetAssignedUsers requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetAssignedUsers requestBusinessField () {
      return this.requestBusinessField(true);
    }
    public APIRequestGetAssignedUsers requestBusinessField (boolean value) {
      this.requestField("business", value);
      return this;
    }
    public APIRequestGetAssignedUsers requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetAssignedUsers requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetAssignedUsers requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetAssignedUsers requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetAssignedUsers requestUserTypeField () {
      return this.requestUserTypeField(true);
    }
    public APIRequestGetAssignedUsers requestUserTypeField (boolean value) {
      this.requestField("user_type", value);
      return this;
    }
  }

  public static class APIRequestCreateAssignedUser extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "tasks",
      "user",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response, String header) throws APIException {
      return Page.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, Page>() {
           public Page apply(ResponseWrapper result) {
             try {
               return APIRequestCreateAssignedUser.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateAssignedUser(String nodeId, APIContext context) {
      super(context, nodeId, "/assigned_users", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateAssignedUser setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateAssignedUser setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateAssignedUser setTasks (List<Page.EnumTasks> tasks) {
      this.setParam("tasks", tasks);
      return this;
    }
    public APIRequestCreateAssignedUser setTasks (String tasks) {
      this.setParam("tasks", tasks);
      return this;
    }

    public APIRequestCreateAssignedUser setUser (Long user) {
      this.setParam("user", user);
      return this;
    }
    public APIRequestCreateAssignedUser setUser (String user) {
      this.setParam("user", user);
      return this;
    }

    public APIRequestCreateAssignedUser requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateAssignedUser requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateAssignedUser requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateAssignedUser requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateAssignedUser requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateAssignedUser requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestDeleteBlocked extends APIRequest<APINode> {

    APINodeList<APINode> lastResponse = null;
    @Override
    public APINodeList<APINode> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "asid",
      "psid",
      "uid",
      "user",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
      return APINode.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<APINode> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<APINode>>() {
           public APINodeList<APINode> apply(ResponseWrapper result) {
             try {
               return APIRequestDeleteBlocked.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestDeleteBlocked(String nodeId, APIContext context) {
      super(context, nodeId, "/blocked", "DELETE", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestDeleteBlocked setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestDeleteBlocked setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestDeleteBlocked setAsid (String asid) {
      this.setParam("asid", asid);
      return this;
    }

    public APIRequestDeleteBlocked setPsid (Long psid) {
      this.setParam("psid", psid);
      return this;
    }
    public APIRequestDeleteBlocked setPsid (String psid) {
      this.setParam("psid", psid);
      return this;
    }

    public APIRequestDeleteBlocked setUid (Long uid) {
      this.setParam("uid", uid);
      return this;
    }
    public APIRequestDeleteBlocked setUid (String uid) {
      this.setParam("uid", uid);
      return this;
    }

    public APIRequestDeleteBlocked setUser (Long user) {
      this.setParam("user", user);
      return this;
    }
    public APIRequestDeleteBlocked setUser (String user) {
      this.setParam("user", user);
      return this;
    }

    public APIRequestDeleteBlocked requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestDeleteBlocked requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteBlocked requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestDeleteBlocked requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteBlocked requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestDeleteBlocked requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetBlocked extends APIRequest<Profile> {

    APINodeList<Profile> lastResponse = null;
    @Override
    public APINodeList<Profile> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "uid",
      "user",
    };

    public static final String[] FIELDS = {
      "can_post",
      "id",
      "link",
      "name",
      "pic",
      "pic_crop",
      "pic_large",
      "pic_small",
      "pic_square",
      "profile_type",
      "username",
    };

    @Override
    public APINodeList<Profile> parseResponse(String response, String header) throws APIException {
      return Profile.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<Profile> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Profile> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Profile>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Profile>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<Profile>>() {
           public APINodeList<Profile> apply(ResponseWrapper result) {
             try {
               return APIRequestGetBlocked.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetBlocked(String nodeId, APIContext context) {
      super(context, nodeId, "/blocked", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetBlocked setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetBlocked setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetBlocked setUid (Long uid) {
      this.setParam("uid", uid);
      return this;
    }
    public APIRequestGetBlocked setUid (String uid) {
      this.setParam("uid", uid);
      return this;
    }

    public APIRequestGetBlocked setUser (Long user) {
      this.setParam("user", user);
      return this;
    }
    public APIRequestGetBlocked setUser (String user) {
      this.setParam("user", user);
      return this;
    }

    public APIRequestGetBlocked requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetBlocked requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetBlocked requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetBlocked requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetBlocked requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetBlocked requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetBlocked requestCanPostField () {
      return this.requestCanPostField(true);
    }
    public APIRequestGetBlocked requestCanPostField (boolean value) {
      this.requestField("can_post", value);
      return this;
    }
    public APIRequestGetBlocked requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetBlocked requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetBlocked requestLinkField () {
      return this.requestLinkField(true);
    }
    public APIRequestGetBlocked requestLinkField (boolean value) {
      this.requestField("link", value);
      return this;
    }
    public APIRequestGetBlocked requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetBlocked requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetBlocked requestPicField () {
      return this.requestPicField(true);
    }
    public APIRequestGetBlocked requestPicField (boolean value) {
      this.requestField("pic", value);
      return this;
    }
    public APIRequestGetBlocked requestPicCropField () {
      return this.requestPicCropField(true);
    }
    public APIRequestGetBlocked requestPicCropField (boolean value) {
      this.requestField("pic_crop", value);
      return this;
    }
    public APIRequestGetBlocked requestPicLargeField () {
      return this.requestPicLargeField(true);
    }
    public APIRequestGetBlocked requestPicLargeField (boolean value) {
      this.requestField("pic_large", value);
      return this;
    }
    public APIRequestGetBlocked requestPicSmallField () {
      return this.requestPicSmallField(true);
    }
    public APIRequestGetBlocked requestPicSmallField (boolean value) {
      this.requestField("pic_small", value);
      return this;
    }
    public APIRequestGetBlocked requestPicSquareField () {
      return this.requestPicSquareField(true);
    }
    public APIRequestGetBlocked requestPicSquareField (boolean value) {
      this.requestField("pic_square", value);
      return this;
    }
    public APIRequestGetBlocked requestProfileTypeField () {
      return this.requestProfileTypeField(true);
    }
    public APIRequestGetBlocked requestProfileTypeField (boolean value) {
      this.requestField("profile_type", value);
      return this;
    }
    public APIRequestGetBlocked requestUsernameField () {
      return this.requestUsernameField(true);
    }
    public APIRequestGetBlocked requestUsernameField (boolean value) {
      this.requestField("username", value);
      return this;
    }
  }

  public static class APIRequestCreateBlocked extends APIRequest<APINode> {

    APINode lastResponse = null;
    @Override
    public APINode getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "asid",
      "psid",
      "uid",
      "user",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINode parseResponse(String response, String header) throws APIException {
      return APINode.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public APINode execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINode execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINode> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINode>() {
           public APINode apply(ResponseWrapper result) {
             try {
               return APIRequestCreateBlocked.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateBlocked(String nodeId, APIContext context) {
      super(context, nodeId, "/blocked", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateBlocked setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateBlocked setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateBlocked setAsid (List<String> asid) {
      this.setParam("asid", asid);
      return this;
    }
    public APIRequestCreateBlocked setAsid (String asid) {
      this.setParam("asid", asid);
      return this;
    }

    public APIRequestCreateBlocked setPsid (List<Long> psid) {
      this.setParam("psid", psid);
      return this;
    }
    public APIRequestCreateBlocked setPsid (String psid) {
      this.setParam("psid", psid);
      return this;
    }

    public APIRequestCreateBlocked setUid (List<String> uid) {
      this.setParam("uid", uid);
      return this;
    }
    public APIRequestCreateBlocked setUid (String uid) {
      this.setParam("uid", uid);
      return this;
    }

    public APIRequestCreateBlocked setUser (List<String> user) {
      this.setParam("user", user);
      return this;
    }
    public APIRequestCreateBlocked setUser (String user) {
      this.setParam("user", user);
      return this;
    }

    public APIRequestCreateBlocked requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateBlocked requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateBlocked requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateBlocked requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateBlocked requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateBlocked requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestCreateBusinessDatum extends APIRequest<APINode> {

    APINode lastResponse = null;
    @Override
    public APINode getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "data",
      "partner_agent",
      "processing_type",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINode parseResponse(String response, String header) throws APIException {
      return APINode.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public APINode execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINode execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINode> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINode>() {
           public APINode apply(ResponseWrapper result) {
             try {
               return APIRequestCreateBusinessDatum.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateBusinessDatum(String nodeId, APIContext context) {
      super(context, nodeId, "/business_data", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateBusinessDatum setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateBusinessDatum setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateBusinessDatum setData (List<String> data) {
      this.setParam("data", data);
      return this;
    }
    public APIRequestCreateBusinessDatum setData (String data) {
      this.setParam("data", data);
      return this;
    }

    public APIRequestCreateBusinessDatum setPartnerAgent (String partnerAgent) {
      this.setParam("partner_agent", partnerAgent);
      return this;
    }

    public APIRequestCreateBusinessDatum setProcessingType (String processingType) {
      this.setParam("processing_type", processingType);
      return this;
    }

    public APIRequestCreateBusinessDatum requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateBusinessDatum requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateBusinessDatum requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateBusinessDatum requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateBusinessDatum requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateBusinessDatum requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestCreateBusinessMessagingFeatureStatus extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "features",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response, String header) throws APIException {
      return Page.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, Page>() {
           public Page apply(ResponseWrapper result) {
             try {
               return APIRequestCreateBusinessMessagingFeatureStatus.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateBusinessMessagingFeatureStatus(String nodeId, APIContext context) {
      super(context, nodeId, "/business_messaging_feature_status", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateBusinessMessagingFeatureStatus setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateBusinessMessagingFeatureStatus setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateBusinessMessagingFeatureStatus setFeatures (List<Map<String, String>> features) {
      this.setParam("features", features);
      return this;
    }
    public APIRequestCreateBusinessMessagingFeatureStatus setFeatures (String features) {
      this.setParam("features", features);
      return this;
    }

    public APIRequestCreateBusinessMessagingFeatureStatus requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateBusinessMessagingFeatureStatus requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateBusinessMessagingFeatureStatus requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateBusinessMessagingFeatureStatus requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateBusinessMessagingFeatureStatus requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateBusinessMessagingFeatureStatus requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetBusinessProjects extends APIRequest<BusinessProject> {

    APINodeList<BusinessProject> lastResponse = null;
    @Override
    public APINodeList<BusinessProject> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "business",
    };

    public static final String[] FIELDS = {
      "business",
      "created_time",
      "creator",
      "id",
      "name",
    };

    @Override
    public APINodeList<BusinessProject> parseResponse(String response, String header) throws APIException {
      return BusinessProject.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<BusinessProject> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<BusinessProject> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<BusinessProject>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<BusinessProject>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<BusinessProject>>() {
           public APINodeList<BusinessProject> apply(ResponseWrapper result) {
             try {
               return APIRequestGetBusinessProjects.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetBusinessProjects(String nodeId, APIContext context) {
      super(context, nodeId, "/businessprojects", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetBusinessProjects setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetBusinessProjects setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetBusinessProjects setBusiness (String business) {
      this.setParam("business", business);
      return this;
    }

    public APIRequestGetBusinessProjects requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetBusinessProjects requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetBusinessProjects requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetBusinessProjects requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetBusinessProjects requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetBusinessProjects requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetBusinessProjects requestBusinessField () {
      return this.requestBusinessField(true);
    }
    public APIRequestGetBusinessProjects requestBusinessField (boolean value) {
      this.requestField("business", value);
      return this;
    }
    public APIRequestGetBusinessProjects requestCreatedTimeField () {
      return this.requestCreatedTimeField(true);
    }
    public APIRequestGetBusinessProjects requestCreatedTimeField (boolean value) {
      this.requestField("created_time", value);
      return this;
    }
    public APIRequestGetBusinessProjects requestCreatorField () {
      return this.requestCreatorField(true);
    }
    public APIRequestGetBusinessProjects requestCreatorField (boolean value) {
      this.requestField("creator", value);
      return this;
    }
    public APIRequestGetBusinessProjects requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetBusinessProjects requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetBusinessProjects requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetBusinessProjects requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
  }

  public static class APIRequestGetCallToActions extends APIRequest<PageCallToAction> {

    APINodeList<PageCallToAction> lastResponse = null;
    @Override
    public APINodeList<PageCallToAction> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "android_app",
      "android_deeplink",
      "android_destination_type",
      "android_package_name",
      "android_url",
      "created_time",
      "email_address",
      "from",
      "id",
      "intl_number_with_plus",
      "iphone_app",
      "iphone_deeplink",
      "iphone_destination_type",
      "iphone_url",
      "status",
      "type",
      "updated_time",
      "web_destination_type",
      "web_url",
    };

    @Override
    public APINodeList<PageCallToAction> parseResponse(String response, String header) throws APIException {
      return PageCallToAction.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<PageCallToAction> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<PageCallToAction> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<PageCallToAction>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<PageCallToAction>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<PageCallToAction>>() {
           public APINodeList<PageCallToAction> apply(ResponseWrapper result) {
             try {
               return APIRequestGetCallToActions.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetCallToActions(String nodeId, APIContext context) {
      super(context, nodeId, "/call_to_actions", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetCallToActions setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetCallToActions setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetCallToActions requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetCallToActions requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCallToActions requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetCallToActions requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCallToActions requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetCallToActions requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetCallToActions requestAndroidAppField () {
      return this.requestAndroidAppField(true);
    }
    public APIRequestGetCallToActions requestAndroidAppField (boolean value) {
      this.requestField("android_app", value);
      return this;
    }
    public APIRequestGetCallToActions requestAndroidDeeplinkField () {
      return this.requestAndroidDeeplinkField(true);
    }
    public APIRequestGetCallToActions requestAndroidDeeplinkField (boolean value) {
      this.requestField("android_deeplink", value);
      return this;
    }
    public APIRequestGetCallToActions requestAndroidDestinationTypeField () {
      return this.requestAndroidDestinationTypeField(true);
    }
    public APIRequestGetCallToActions requestAndroidDestinationTypeField (boolean value) {
      this.requestField("android_destination_type", value);
      return this;
    }
    public APIRequestGetCallToActions requestAndroidPackageNameField () {
      return this.requestAndroidPackageNameField(true);
    }
    public APIRequestGetCallToActions requestAndroidPackageNameField (boolean value) {
      this.requestField("android_package_name", value);
      return this;
    }
    public APIRequestGetCallToActions requestAndroidUrlField () {
      return this.requestAndroidUrlField(true);
    }
    public APIRequestGetCallToActions requestAndroidUrlField (boolean value) {
      this.requestField("android_url", value);
      return this;
    }
    public APIRequestGetCallToActions requestCreatedTimeField () {
      return this.requestCreatedTimeField(true);
    }
    public APIRequestGetCallToActions requestCreatedTimeField (boolean value) {
      this.requestField("created_time", value);
      return this;
    }
    public APIRequestGetCallToActions requestEmailAddressField () {
      return this.requestEmailAddressField(true);
    }
    public APIRequestGetCallToActions requestEmailAddressField (boolean value) {
      this.requestField("email_address", value);
      return this;
    }
    public APIRequestGetCallToActions requestFromField () {
      return this.requestFromField(true);
    }
    public APIRequestGetCallToActions requestFromField (boolean value) {
      this.requestField("from", value);
      return this;
    }
    public APIRequestGetCallToActions requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetCallToActions requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetCallToActions requestIntlNumberWithPlusField () {
      return this.requestIntlNumberWithPlusField(true);
    }
    public APIRequestGetCallToActions requestIntlNumberWithPlusField (boolean value) {
      this.requestField("intl_number_with_plus", value);
      return this;
    }
    public APIRequestGetCallToActions requestIphoneAppField () {
      return this.requestIphoneAppField(true);
    }
    public APIRequestGetCallToActions requestIphoneAppField (boolean value) {
      this.requestField("iphone_app", value);
      return this;
    }
    public APIRequestGetCallToActions requestIphoneDeeplinkField () {
      return this.requestIphoneDeeplinkField(true);
    }
    public APIRequestGetCallToActions requestIphoneDeeplinkField (boolean value) {
      this.requestField("iphone_deeplink", value);
      return this;
    }
    public APIRequestGetCallToActions requestIphoneDestinationTypeField () {
      return this.requestIphoneDestinationTypeField(true);
    }
    public APIRequestGetCallToActions requestIphoneDestinationTypeField (boolean value) {
      this.requestField("iphone_destination_type", value);
      return this;
    }
    public APIRequestGetCallToActions requestIphoneUrlField () {
      return this.requestIphoneUrlField(true);
    }
    public APIRequestGetCallToActions requestIphoneUrlField (boolean value) {
      this.requestField("iphone_url", value);
      return this;
    }
    public APIRequestGetCallToActions requestStatusField () {
      return this.requestStatusField(true);
    }
    public APIRequestGetCallToActions requestStatusField (boolean value) {
      this.requestField("status", value);
      return this;
    }
    public APIRequestGetCallToActions requestTypeField () {
      return this.requestTypeField(true);
    }
    public APIRequestGetCallToActions requestTypeField (boolean value) {
      this.requestField("type", value);
      return this;
    }
    public APIRequestGetCallToActions requestUpdatedTimeField () {
      return this.requestUpdatedTimeField(true);
    }
    public APIRequestGetCallToActions requestUpdatedTimeField (boolean value) {
      this.requestField("updated_time", value);
      return this;
    }
    public APIRequestGetCallToActions requestWebDestinationTypeField () {
      return this.requestWebDestinationTypeField(true);
    }
    public APIRequestGetCallToActions requestWebDestinationTypeField (boolean value) {
      this.requestField("web_destination_type", value);
      return this;
    }
    public APIRequestGetCallToActions requestWebUrlField () {
      return this.requestWebUrlField(true);
    }
    public APIRequestGetCallToActions requestWebUrlField (boolean value) {
      this.requestField("web_url", value);
      return this;
    }
  }

  public static class APIRequestCreateCall extends APIRequest<APINode> {

    APINode lastResponse = null;
    @Override
    public APINode getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "action",
      "call_id",
      "from_version",
      "platform",
      "session",
      "to",
      "to_version",
      "tracks",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINode parseResponse(String response, String header) throws APIException {
      return APINode.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public APINode execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINode execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINode> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINode>() {
           public APINode apply(ResponseWrapper result) {
             try {
               return APIRequestCreateCall.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateCall(String nodeId, APIContext context) {
      super(context, nodeId, "/calls", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateCall setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateCall setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateCall setAction (EnumAction action) {
      this.setParam("action", action);
      return this;
    }
    public APIRequestCreateCall setAction (String action) {
      this.setParam("action", action);
      return this;
    }

    public APIRequestCreateCall setCallId (String callId) {
      this.setParam("call_id", callId);
      return this;
    }

    public APIRequestCreateCall setFromVersion (Long fromVersion) {
      this.setParam("from_version", fromVersion);
      return this;
    }
    public APIRequestCreateCall setFromVersion (String fromVersion) {
      this.setParam("from_version", fromVersion);
      return this;
    }

    public APIRequestCreateCall setPlatform (EnumPlatform platform) {
      this.setParam("platform", platform);
      return this;
    }
    public APIRequestCreateCall setPlatform (String platform) {
      this.setParam("platform", platform);
      return this;
    }

    public APIRequestCreateCall setSession (Map<String, String> session) {
      this.setParam("session", session);
      return this;
    }
    public APIRequestCreateCall setSession (String session) {
      this.setParam("session", session);
      return this;
    }

    public APIRequestCreateCall setTo (String to) {
      this.setParam("to", to);
      return this;
    }

    public APIRequestCreateCall setToVersion (Long toVersion) {
      this.setParam("to_version", toVersion);
      return this;
    }
    public APIRequestCreateCall setToVersion (String toVersion) {
      this.setParam("to_version", toVersion);
      return this;
    }

    public APIRequestCreateCall setTracks (List<Map<String, String>> tracks) {
      this.setParam("tracks", tracks);
      return this;
    }
    public APIRequestCreateCall setTracks (String tracks) {
      this.setParam("tracks", tracks);
      return this;
    }

    public APIRequestCreateCall requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateCall requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateCall requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateCall requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateCall requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateCall requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetCanvasElements extends APIRequest<CanvasBodyElement> {

    APINodeList<CanvasBodyElement> lastResponse = null;
    @Override
    public APINodeList<CanvasBodyElement> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "element",
    };

    @Override
    public APINodeList<CanvasBodyElement> parseResponse(String response, String header) throws APIException {
      return CanvasBodyElement.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<CanvasBodyElement> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<CanvasBodyElement> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<CanvasBodyElement>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<CanvasBodyElement>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<CanvasBodyElement>>() {
           public APINodeList<CanvasBodyElement> apply(ResponseWrapper result) {
             try {
               return APIRequestGetCanvasElements.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetCanvasElements(String nodeId, APIContext context) {
      super(context, nodeId, "/canvas_elements", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetCanvasElements setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetCanvasElements setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetCanvasElements requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetCanvasElements requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCanvasElements requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetCanvasElements requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCanvasElements requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetCanvasElements requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetCanvasElements requestElementField () {
      return this.requestElementField(true);
    }
    public APIRequestGetCanvasElements requestElementField (boolean value) {
      this.requestField("element", value);
      return this;
    }
  }

  public static class APIRequestCreateCanvasElement extends APIRequest<CanvasBodyElement> {

    CanvasBodyElement lastResponse = null;
    @Override
    public CanvasBodyElement getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "canvas_button",
      "canvas_carousel",
      "canvas_existing_post",
      "canvas_footer",
      "canvas_header",
      "canvas_lead_form",
      "canvas_photo",
      "canvas_product_list",
      "canvas_product_set",
      "canvas_store_locator",
      "canvas_template_video",
      "canvas_text",
      "canvas_video",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public CanvasBodyElement parseResponse(String response, String header) throws APIException {
      return CanvasBodyElement.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public CanvasBodyElement execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public CanvasBodyElement execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<CanvasBodyElement> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<CanvasBodyElement> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, CanvasBodyElement>() {
           public CanvasBodyElement apply(ResponseWrapper result) {
             try {
               return APIRequestCreateCanvasElement.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateCanvasElement(String nodeId, APIContext context) {
      super(context, nodeId, "/canvas_elements", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateCanvasElement setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateCanvasElement setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateCanvasElement setCanvasButton (Object canvasButton) {
      this.setParam("canvas_button", canvasButton);
      return this;
    }
    public APIRequestCreateCanvasElement setCanvasButton (String canvasButton) {
      this.setParam("canvas_button", canvasButton);
      return this;
    }

    public APIRequestCreateCanvasElement setCanvasCarousel (Object canvasCarousel) {
      this.setParam("canvas_carousel", canvasCarousel);
      return this;
    }
    public APIRequestCreateCanvasElement setCanvasCarousel (String canvasCarousel) {
      this.setParam("canvas_carousel", canvasCarousel);
      return this;
    }

    public APIRequestCreateCanvasElement setCanvasExistingPost (Object canvasExistingPost) {
      this.setParam("canvas_existing_post", canvasExistingPost);
      return this;
    }
    public APIRequestCreateCanvasElement setCanvasExistingPost (String canvasExistingPost) {
      this.setParam("canvas_existing_post", canvasExistingPost);
      return this;
    }

    public APIRequestCreateCanvasElement setCanvasFooter (Object canvasFooter) {
      this.setParam("canvas_footer", canvasFooter);
      return this;
    }
    public APIRequestCreateCanvasElement setCanvasFooter (String canvasFooter) {
      this.setParam("canvas_footer", canvasFooter);
      return this;
    }

    public APIRequestCreateCanvasElement setCanvasHeader (Object canvasHeader) {
      this.setParam("canvas_header", canvasHeader);
      return this;
    }
    public APIRequestCreateCanvasElement setCanvasHeader (String canvasHeader) {
      this.setParam("canvas_header", canvasHeader);
      return this;
    }

    public APIRequestCreateCanvasElement setCanvasLeadForm (Object canvasLeadForm) {
      this.setParam("canvas_lead_form", canvasLeadForm);
      return this;
    }
    public APIRequestCreateCanvasElement setCanvasLeadForm (String canvasLeadForm) {
      this.setParam("canvas_lead_form", canvasLeadForm);
      return this;
    }

    public APIRequestCreateCanvasElement setCanvasPhoto (Object canvasPhoto) {
      this.setParam("canvas_photo", canvasPhoto);
      return this;
    }
    public APIRequestCreateCanvasElement setCanvasPhoto (String canvasPhoto) {
      this.setParam("canvas_photo", canvasPhoto);
      return this;
    }

    public APIRequestCreateCanvasElement setCanvasProductList (Object canvasProductList) {
      this.setParam("canvas_product_list", canvasProductList);
      return this;
    }
    public APIRequestCreateCanvasElement setCanvasProductList (String canvasProductList) {
      this.setParam("canvas_product_list", canvasProductList);
      return this;
    }

    public APIRequestCreateCanvasElement setCanvasProductSet (Object canvasProductSet) {
      this.setParam("canvas_product_set", canvasProductSet);
      return this;
    }
    public APIRequestCreateCanvasElement setCanvasProductSet (String canvasProductSet) {
      this.setParam("canvas_product_set", canvasProductSet);
      return this;
    }

    public APIRequestCreateCanvasElement setCanvasStoreLocator (Object canvasStoreLocator) {
      this.setParam("canvas_store_locator", canvasStoreLocator);
      return this;
    }
    public APIRequestCreateCanvasElement setCanvasStoreLocator (String canvasStoreLocator) {
      this.setParam("canvas_store_locator", canvasStoreLocator);
      return this;
    }

    public APIRequestCreateCanvasElement setCanvasTemplateVideo (Object canvasTemplateVideo) {
      this.setParam("canvas_template_video", canvasTemplateVideo);
      return this;
    }
    public APIRequestCreateCanvasElement setCanvasTemplateVideo (String canvasTemplateVideo) {
      this.setParam("canvas_template_video", canvasTemplateVideo);
      return this;
    }

    public APIRequestCreateCanvasElement setCanvasText (Object canvasText) {
      this.setParam("canvas_text", canvasText);
      return this;
    }
    public APIRequestCreateCanvasElement setCanvasText (String canvasText) {
      this.setParam("canvas_text", canvasText);
      return this;
    }

    public APIRequestCreateCanvasElement setCanvasVideo (Object canvasVideo) {
      this.setParam("canvas_video", canvasVideo);
      return this;
    }
    public APIRequestCreateCanvasElement setCanvasVideo (String canvasVideo) {
      this.setParam("canvas_video", canvasVideo);
      return this;
    }

    public APIRequestCreateCanvasElement requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateCanvasElement requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateCanvasElement requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateCanvasElement requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateCanvasElement requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateCanvasElement requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetCanvases extends APIRequest<Canvas> {

    APINodeList<Canvas> lastResponse = null;
    @Override
    public APINodeList<Canvas> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "is_hidden",
      "is_published",
    };

    public static final String[] FIELDS = {
      "background_color",
      "body_elements",
      "business_id",
      "canvas_link",
      "collection_hero_image",
      "collection_hero_video",
      "collection_thumbnails",
      "dynamic_setting",
      "element_payload",
      "elements",
      "fb_body_elements",
      "hero_asset_facebook_post_id",
      "hero_asset_instagram_media_id",
      "id",
      "is_hidden",
      "is_published",
      "last_editor",
      "linked_documents",
      "name",
      "owner",
      "property_list",
      "source_template",
      "store_url",
      "style_list",
      "tags",
      "ui_property_list",
      "unused_body_elements",
      "update_time",
      "use_retailer_item_ids",
    };

    @Override
    public APINodeList<Canvas> parseResponse(String response, String header) throws APIException {
      return Canvas.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<Canvas> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Canvas> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Canvas>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Canvas>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<Canvas>>() {
           public APINodeList<Canvas> apply(ResponseWrapper result) {
             try {
               return APIRequestGetCanvases.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetCanvases(String nodeId, APIContext context) {
      super(context, nodeId, "/canvases", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetCanvases setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetCanvases setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetCanvases setIsHidden (Boolean isHidden) {
      this.setParam("is_hidden", isHidden);
      return this;
    }
    public APIRequestGetCanvases setIsHidden (String isHidden) {
      this.setParam("is_hidden", isHidden);
      return this;
    }

    public APIRequestGetCanvases setIsPublished (Boolean isPublished) {
      this.setParam("is_published", isPublished);
      return this;
    }
    public APIRequestGetCanvases setIsPublished (String isPublished) {
      this.setParam("is_published", isPublished);
      return this;
    }

    public APIRequestGetCanvases requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetCanvases requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCanvases requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetCanvases requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCanvases requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetCanvases requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetCanvases requestBackgroundColorField () {
      return this.requestBackgroundColorField(true);
    }
    public APIRequestGetCanvases requestBackgroundColorField (boolean value) {
      this.requestField("background_color", value);
      return this;
    }
    public APIRequestGetCanvases requestBodyElementsField () {
      return this.requestBodyElementsField(true);
    }
    public APIRequestGetCanvases requestBodyElementsField (boolean value) {
      this.requestField("body_elements", value);
      return this;
    }
    public APIRequestGetCanvases requestBusinessIdField () {
      return this.requestBusinessIdField(true);
    }
    public APIRequestGetCanvases requestBusinessIdField (boolean value) {
      this.requestField("business_id", value);
      return this;
    }
    public APIRequestGetCanvases requestCanvasLinkField () {
      return this.requestCanvasLinkField(true);
    }
    public APIRequestGetCanvases requestCanvasLinkField (boolean value) {
      this.requestField("canvas_link", value);
      return this;
    }
    public APIRequestGetCanvases requestCollectionHeroImageField () {
      return this.requestCollectionHeroImageField(true);
    }
    public APIRequestGetCanvases requestCollectionHeroImageField (boolean value) {
      this.requestField("collection_hero_image", value);
      return this;
    }
    public APIRequestGetCanvases requestCollectionHeroVideoField () {
      return this.requestCollectionHeroVideoField(true);
    }
    public APIRequestGetCanvases requestCollectionHeroVideoField (boolean value) {
      this.requestField("collection_hero_video", value);
      return this;
    }
    public APIRequestGetCanvases requestCollectionThumbnailsField () {
      return this.requestCollectionThumbnailsField(true);
    }
    public APIRequestGetCanvases requestCollectionThumbnailsField (boolean value) {
      this.requestField("collection_thumbnails", value);
      return this;
    }
    public APIRequestGetCanvases requestDynamicSettingField () {
      return this.requestDynamicSettingField(true);
    }
    public APIRequestGetCanvases requestDynamicSettingField (boolean value) {
      this.requestField("dynamic_setting", value);
      return this;
    }
    public APIRequestGetCanvases requestElementPayloadField () {
      return this.requestElementPayloadField(true);
    }
    public APIRequestGetCanvases requestElementPayloadField (boolean value) {
      this.requestField("element_payload", value);
      return this;
    }
    public APIRequestGetCanvases requestElementsField () {
      return this.requestElementsField(true);
    }
    public APIRequestGetCanvases requestElementsField (boolean value) {
      this.requestField("elements", value);
      return this;
    }
    public APIRequestGetCanvases requestFbBodyElementsField () {
      return this.requestFbBodyElementsField(true);
    }
    public APIRequestGetCanvases requestFbBodyElementsField (boolean value) {
      this.requestField("fb_body_elements", value);
      return this;
    }
    public APIRequestGetCanvases requestHeroAssetFacebookPostIdField () {
      return this.requestHeroAssetFacebookPostIdField(true);
    }
    public APIRequestGetCanvases requestHeroAssetFacebookPostIdField (boolean value) {
      this.requestField("hero_asset_facebook_post_id", value);
      return this;
    }
    public APIRequestGetCanvases requestHeroAssetInstagramMediaIdField () {
      return this.requestHeroAssetInstagramMediaIdField(true);
    }
    public APIRequestGetCanvases requestHeroAssetInstagramMediaIdField (boolean value) {
      this.requestField("hero_asset_instagram_media_id", value);
      return this;
    }
    public APIRequestGetCanvases requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetCanvases requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetCanvases requestIsHiddenField () {
      return this.requestIsHiddenField(true);
    }
    public APIRequestGetCanvases requestIsHiddenField (boolean value) {
      this.requestField("is_hidden", value);
      return this;
    }
    public APIRequestGetCanvases requestIsPublishedField () {
      return this.requestIsPublishedField(true);
    }
    public APIRequestGetCanvases requestIsPublishedField (boolean value) {
      this.requestField("is_published", value);
      return this;
    }
    public APIRequestGetCanvases requestLastEditorField () {
      return this.requestLastEditorField(true);
    }
    public APIRequestGetCanvases requestLastEditorField (boolean value) {
      this.requestField("last_editor", value);
      return this;
    }
    public APIRequestGetCanvases requestLinkedDocumentsField () {
      return this.requestLinkedDocumentsField(true);
    }
    public APIRequestGetCanvases requestLinkedDocumentsField (boolean value) {
      this.requestField("linked_documents", value);
      return this;
    }
    public APIRequestGetCanvases requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetCanvases requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetCanvases requestOwnerField () {
      return this.requestOwnerField(true);
    }
    public APIRequestGetCanvases requestOwnerField (boolean value) {
      this.requestField("owner", value);
      return this;
    }
    public APIRequestGetCanvases requestPropertyListField () {
      return this.requestPropertyListField(true);
    }
    public APIRequestGetCanvases requestPropertyListField (boolean value) {
      this.requestField("property_list", value);
      return this;
    }
    public APIRequestGetCanvases requestSourceTemplateField () {
      return this.requestSourceTemplateField(true);
    }
    public APIRequestGetCanvases requestSourceTemplateField (boolean value) {
      this.requestField("source_template", value);
      return this;
    }
    public APIRequestGetCanvases requestStoreUrlField () {
      return this.requestStoreUrlField(true);
    }
    public APIRequestGetCanvases requestStoreUrlField (boolean value) {
      this.requestField("store_url", value);
      return this;
    }
    public APIRequestGetCanvases requestStyleListField () {
      return this.requestStyleListField(true);
    }
    public APIRequestGetCanvases requestStyleListField (boolean value) {
      this.requestField("style_list", value);
      return this;
    }
    public APIRequestGetCanvases requestTagsField () {
      return this.requestTagsField(true);
    }
    public APIRequestGetCanvases requestTagsField (boolean value) {
      this.requestField("tags", value);
      return this;
    }
    public APIRequestGetCanvases requestUiPropertyListField () {
      return this.requestUiPropertyListField(true);
    }
    public APIRequestGetCanvases requestUiPropertyListField (boolean value) {
      this.requestField("ui_property_list", value);
      return this;
    }
    public APIRequestGetCanvases requestUnusedBodyElementsField () {
      return this.requestUnusedBodyElementsField(true);
    }
    public APIRequestGetCanvases requestUnusedBodyElementsField (boolean value) {
      this.requestField("unused_body_elements", value);
      return this;
    }
    public APIRequestGetCanvases requestUpdateTimeField () {
      return this.requestUpdateTimeField(true);
    }
    public APIRequestGetCanvases requestUpdateTimeField (boolean value) {
      this.requestField("update_time", value);
      return this;
    }
    public APIRequestGetCanvases requestUseRetailerItemIdsField () {
      return this.requestUseRetailerItemIdsField(true);
    }
    public APIRequestGetCanvases requestUseRetailerItemIdsField (boolean value) {
      this.requestField("use_retailer_item_ids", value);
      return this;
    }
  }

  public static class APIRequestCreateCanvase extends APIRequest<Canvas> {

    Canvas lastResponse = null;
    @Override
    public Canvas getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "background_color",
      "body_element_ids",
      "enable_swipe_to_open",
      "hero_asset_facebook_post_id",
      "hero_asset_instagram_media_id",
      "is_hidden",
      "is_published",
      "name",
      "source_template_id",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Canvas parseResponse(String response, String header) throws APIException {
      return Canvas.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public Canvas execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Canvas execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<Canvas> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Canvas> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, Canvas>() {
           public Canvas apply(ResponseWrapper result) {
             try {
               return APIRequestCreateCanvase.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateCanvase(String nodeId, APIContext context) {
      super(context, nodeId, "/canvases", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateCanvase setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateCanvase setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateCanvase setBackgroundColor (String backgroundColor) {
      this.setParam("background_color", backgroundColor);
      return this;
    }

    public APIRequestCreateCanvase setBodyElementIds (List<String> bodyElementIds) {
      this.setParam("body_element_ids", bodyElementIds);
      return this;
    }
    public APIRequestCreateCanvase setBodyElementIds (String bodyElementIds) {
      this.setParam("body_element_ids", bodyElementIds);
      return this;
    }

    public APIRequestCreateCanvase setEnableSwipeToOpen (Boolean enableSwipeToOpen) {
      this.setParam("enable_swipe_to_open", enableSwipeToOpen);
      return this;
    }
    public APIRequestCreateCanvase setEnableSwipeToOpen (String enableSwipeToOpen) {
      this.setParam("enable_swipe_to_open", enableSwipeToOpen);
      return this;
    }

    public APIRequestCreateCanvase setHeroAssetFacebookPostId (String heroAssetFacebookPostId) {
      this.setParam("hero_asset_facebook_post_id", heroAssetFacebookPostId);
      return this;
    }

    public APIRequestCreateCanvase setHeroAssetInstagramMediaId (String heroAssetInstagramMediaId) {
      this.setParam("hero_asset_instagram_media_id", heroAssetInstagramMediaId);
      return this;
    }

    public APIRequestCreateCanvase setIsHidden (Boolean isHidden) {
      this.setParam("is_hidden", isHidden);
      return this;
    }
    public APIRequestCreateCanvase setIsHidden (String isHidden) {
      this.setParam("is_hidden", isHidden);
      return this;
    }

    public APIRequestCreateCanvase setIsPublished (Boolean isPublished) {
      this.setParam("is_published", isPublished);
      return this;
    }
    public APIRequestCreateCanvase setIsPublished (String isPublished) {
      this.setParam("is_published", isPublished);
      return this;
    }

    public APIRequestCreateCanvase setName (String name) {
      this.setParam("name", name);
      return this;
    }

    public APIRequestCreateCanvase setSourceTemplateId (String sourceTemplateId) {
      this.setParam("source_template_id", sourceTemplateId);
      return this;
    }

    public APIRequestCreateCanvase requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateCanvase requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateCanvase requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateCanvase requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateCanvase requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateCanvase requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetChatPlugin extends APIRequest<ChatPlugin> {

    APINodeList<ChatPlugin> lastResponse = null;
    @Override
    public APINodeList<ChatPlugin> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "alignment",
      "desktop_bottom_spacing",
      "desktop_side_spacing",
      "entry_point_icon",
      "entry_point_label",
      "greeting_dialog_display",
      "guest_chat_mode",
      "mobile_bottom_spacing",
      "mobile_chat_display",
      "mobile_side_spacing",
      "theme_color",
      "welcome_screen_greeting",
    };

    @Override
    public APINodeList<ChatPlugin> parseResponse(String response, String header) throws APIException {
      return ChatPlugin.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<ChatPlugin> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<ChatPlugin> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<ChatPlugin>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<ChatPlugin>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<ChatPlugin>>() {
           public APINodeList<ChatPlugin> apply(ResponseWrapper result) {
             try {
               return APIRequestGetChatPlugin.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetChatPlugin(String nodeId, APIContext context) {
      super(context, nodeId, "/chat_plugin", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetChatPlugin setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetChatPlugin setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetChatPlugin requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetChatPlugin requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetChatPlugin requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetChatPlugin requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetChatPlugin requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetChatPlugin requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetChatPlugin requestAlignmentField () {
      return this.requestAlignmentField(true);
    }
    public APIRequestGetChatPlugin requestAlignmentField (boolean value) {
      this.requestField("alignment", value);
      return this;
    }
    public APIRequestGetChatPlugin requestDesktopBottomSpacingField () {
      return this.requestDesktopBottomSpacingField(true);
    }
    public APIRequestGetChatPlugin requestDesktopBottomSpacingField (boolean value) {
      this.requestField("desktop_bottom_spacing", value);
      return this;
    }
    public APIRequestGetChatPlugin requestDesktopSideSpacingField () {
      return this.requestDesktopSideSpacingField(true);
    }
    public APIRequestGetChatPlugin requestDesktopSideSpacingField (boolean value) {
      this.requestField("desktop_side_spacing", value);
      return this;
    }
    public APIRequestGetChatPlugin requestEntryPointIconField () {
      return this.requestEntryPointIconField(true);
    }
    public APIRequestGetChatPlugin requestEntryPointIconField (boolean value) {
      this.requestField("entry_point_icon", value);
      return this;
    }
    public APIRequestGetChatPlugin requestEntryPointLabelField () {
      return this.requestEntryPointLabelField(true);
    }
    public APIRequestGetChatPlugin requestEntryPointLabelField (boolean value) {
      this.requestField("entry_point_label", value);
      return this;
    }
    public APIRequestGetChatPlugin requestGreetingDialogDisplayField () {
      return this.requestGreetingDialogDisplayField(true);
    }
    public APIRequestGetChatPlugin requestGreetingDialogDisplayField (boolean value) {
      this.requestField("greeting_dialog_display", value);
      return this;
    }
    public APIRequestGetChatPlugin requestGuestChatModeField () {
      return this.requestGuestChatModeField(true);
    }
    public APIRequestGetChatPlugin requestGuestChatModeField (boolean value) {
      this.requestField("guest_chat_mode", value);
      return this;
    }
    public APIRequestGetChatPlugin requestMobileBottomSpacingField () {
      return this.requestMobileBottomSpacingField(true);
    }
    public APIRequestGetChatPlugin requestMobileBottomSpacingField (boolean value) {
      this.requestField("mobile_bottom_spacing", value);
      return this;
    }
    public APIRequestGetChatPlugin requestMobileChatDisplayField () {
      return this.requestMobileChatDisplayField(true);
    }
    public APIRequestGetChatPlugin requestMobileChatDisplayField (boolean value) {
      this.requestField("mobile_chat_display", value);
      return this;
    }
    public APIRequestGetChatPlugin requestMobileSideSpacingField () {
      return this.requestMobileSideSpacingField(true);
    }
    public APIRequestGetChatPlugin requestMobileSideSpacingField (boolean value) {
      this.requestField("mobile_side_spacing", value);
      return this;
    }
    public APIRequestGetChatPlugin requestThemeColorField () {
      return this.requestThemeColorField(true);
    }
    public APIRequestGetChatPlugin requestThemeColorField (boolean value) {
      this.requestField("theme_color", value);
      return this;
    }
    public APIRequestGetChatPlugin requestWelcomeScreenGreetingField () {
      return this.requestWelcomeScreenGreetingField(true);
    }
    public APIRequestGetChatPlugin requestWelcomeScreenGreetingField (boolean value) {
      this.requestField("welcome_screen_greeting", value);
      return this;
    }
  }

  public static class APIRequestGetCommerceMerchantSettings extends APIRequest<CommerceMerchantSettings> {

    APINodeList<CommerceMerchantSettings> lastResponse = null;
    @Override
    public APINodeList<CommerceMerchantSettings> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "checkout_config",
      "checkout_message",
      "contact_email",
      "cta",
      "display_name",
      "facebook_channel",
      "id",
      "instagram_channel",
      "korea_ftc_listing",
      "merchant_page",
      "merchant_status",
      "offsite_iab_checkout_enabled_countries",
      "onsite_commerce_merchant",
      "payment_provider",
      "privacy_policy_localized",
      "return_policy_localized",
      "shops_ads_setup",
      "terms",
    };

    @Override
    public APINodeList<CommerceMerchantSettings> parseResponse(String response, String header) throws APIException {
      return CommerceMerchantSettings.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<CommerceMerchantSettings> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<CommerceMerchantSettings> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<CommerceMerchantSettings>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<CommerceMerchantSettings>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<CommerceMerchantSettings>>() {
           public APINodeList<CommerceMerchantSettings> apply(ResponseWrapper result) {
             try {
               return APIRequestGetCommerceMerchantSettings.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetCommerceMerchantSettings(String nodeId, APIContext context) {
      super(context, nodeId, "/commerce_merchant_settings", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetCommerceMerchantSettings setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetCommerceMerchantSettings setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetCommerceMerchantSettings requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetCommerceMerchantSettings requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCommerceMerchantSettings requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetCommerceMerchantSettings requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCommerceMerchantSettings requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetCommerceMerchantSettings requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetCommerceMerchantSettings requestCheckoutConfigField () {
      return this.requestCheckoutConfigField(true);
    }
    public APIRequestGetCommerceMerchantSettings requestCheckoutConfigField (boolean value) {
      this.requestField("checkout_config", value);
      return this;
    }
    public APIRequestGetCommerceMerchantSettings requestCheckoutMessageField () {
      return this.requestCheckoutMessageField(true);
    }
    public APIRequestGetCommerceMerchantSettings requestCheckoutMessageField (boolean value) {
      this.requestField("checkout_message", value);
      return this;
    }
    public APIRequestGetCommerceMerchantSettings requestContactEmailField () {
      return this.requestContactEmailField(true);
    }
    public APIRequestGetCommerceMerchantSettings requestContactEmailField (boolean value) {
      this.requestField("contact_email", value);
      return this;
    }
    public APIRequestGetCommerceMerchantSettings requestCtaField () {
      return this.requestCtaField(true);
    }
    public APIRequestGetCommerceMerchantSettings requestCtaField (boolean value) {
      this.requestField("cta", value);
      return this;
    }
    public APIRequestGetCommerceMerchantSettings requestDisplayNameField () {
      return this.requestDisplayNameField(true);
    }
    public APIRequestGetCommerceMerchantSettings requestDisplayNameField (boolean value) {
      this.requestField("display_name", value);
      return this;
    }
    public APIRequestGetCommerceMerchantSettings requestFacebookChannelField () {
      return this.requestFacebookChannelField(true);
    }
    public APIRequestGetCommerceMerchantSettings requestFacebookChannelField (boolean value) {
      this.requestField("facebook_channel", value);
      return this;
    }
    public APIRequestGetCommerceMerchantSettings requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetCommerceMerchantSettings requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetCommerceMerchantSettings requestInstagramChannelField () {
      return this.requestInstagramChannelField(true);
    }
    public APIRequestGetCommerceMerchantSettings requestInstagramChannelField (boolean value) {
      this.requestField("instagram_channel", value);
      return this;
    }
    public APIRequestGetCommerceMerchantSettings requestKoreaFtcListingField () {
      return this.requestKoreaFtcListingField(true);
    }
    public APIRequestGetCommerceMerchantSettings requestKoreaFtcListingField (boolean value) {
      this.requestField("korea_ftc_listing", value);
      return this;
    }
    public APIRequestGetCommerceMerchantSettings requestMerchantPageField () {
      return this.requestMerchantPageField(true);
    }
    public APIRequestGetCommerceMerchantSettings requestMerchantPageField (boolean value) {
      this.requestField("merchant_page", value);
      return this;
    }
    public APIRequestGetCommerceMerchantSettings requestMerchantStatusField () {
      return this.requestMerchantStatusField(true);
    }
    public APIRequestGetCommerceMerchantSettings requestMerchantStatusField (boolean value) {
      this.requestField("merchant_status", value);
      return this;
    }
    public APIRequestGetCommerceMerchantSettings requestOffsiteIabCheckoutEnabledCountriesField () {
      return this.requestOffsiteIabCheckoutEnabledCountriesField(true);
    }
    public APIRequestGetCommerceMerchantSettings requestOffsiteIabCheckoutEnabledCountriesField (boolean value) {
      this.requestField("offsite_iab_checkout_enabled_countries", value);
      return this;
    }
    public APIRequestGetCommerceMerchantSettings requestOnsiteCommerceMerchantField () {
      return this.requestOnsiteCommerceMerchantField(true);
    }
    public APIRequestGetCommerceMerchantSettings requestOnsiteCommerceMerchantField (boolean value) {
      this.requestField("onsite_commerce_merchant", value);
      return this;
    }
    public APIRequestGetCommerceMerchantSettings requestPaymentProviderField () {
      return this.requestPaymentProviderField(true);
    }
    public APIRequestGetCommerceMerchantSettings requestPaymentProviderField (boolean value) {
      this.requestField("payment_provider", value);
      return this;
    }
    public APIRequestGetCommerceMerchantSettings requestPrivacyPolicyLocalizedField () {
      return this.requestPrivacyPolicyLocalizedField(true);
    }
    public APIRequestGetCommerceMerchantSettings requestPrivacyPolicyLocalizedField (boolean value) {
      this.requestField("privacy_policy_localized", value);
      return this;
    }
    public APIRequestGetCommerceMerchantSettings requestReturnPolicyLocalizedField () {
      return this.requestReturnPolicyLocalizedField(true);
    }
    public APIRequestGetCommerceMerchantSettings requestReturnPolicyLocalizedField (boolean value) {
      this.requestField("return_policy_localized", value);
      return this;
    }
    public APIRequestGetCommerceMerchantSettings requestShopsAdsSetupField () {
      return this.requestShopsAdsSetupField(true);
    }
    public APIRequestGetCommerceMerchantSettings requestShopsAdsSetupField (boolean value) {
      this.requestField("shops_ads_setup", value);
      return this;
    }
    public APIRequestGetCommerceMerchantSettings requestTermsField () {
      return this.requestTermsField(true);
    }
    public APIRequestGetCommerceMerchantSettings requestTermsField (boolean value) {
      this.requestField("terms", value);
      return this;
    }
  }

  public static class APIRequestGetCommerceOrders extends APIRequest<CommerceOrder> {

    APINodeList<CommerceOrder> lastResponse = null;
    @Override
    public APINodeList<CommerceOrder> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "filters",
      "state",
      "updated_after",
      "updated_before",
    };

    public static final String[] FIELDS = {
      "buyer_details",
      "channel",
      "contains_bopis_items",
      "created",
      "estimated_payment_details",
      "id",
      "is_group_buy",
      "is_test_order",
      "last_updated",
      "merchant_order_id",
      "order_status",
      "pre_order_details",
      "selected_shipping_option",
      "ship_by_date",
      "shipping_address",
    };

    @Override
    public APINodeList<CommerceOrder> parseResponse(String response, String header) throws APIException {
      return CommerceOrder.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<CommerceOrder> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<CommerceOrder> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<CommerceOrder>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<CommerceOrder>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<CommerceOrder>>() {
           public APINodeList<CommerceOrder> apply(ResponseWrapper result) {
             try {
               return APIRequestGetCommerceOrders.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetCommerceOrders(String nodeId, APIContext context) {
      super(context, nodeId, "/commerce_orders", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetCommerceOrders setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetCommerceOrders setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetCommerceOrders setFilters (List<CommerceOrder.EnumFilters> filters) {
      this.setParam("filters", filters);
      return this;
    }
    public APIRequestGetCommerceOrders setFilters (String filters) {
      this.setParam("filters", filters);
      return this;
    }

    public APIRequestGetCommerceOrders setState (List<CommerceOrder.EnumState> state) {
      this.setParam("state", state);
      return this;
    }
    public APIRequestGetCommerceOrders setState (String state) {
      this.setParam("state", state);
      return this;
    }

    public APIRequestGetCommerceOrders setUpdatedAfter (String updatedAfter) {
      this.setParam("updated_after", updatedAfter);
      return this;
    }

    public APIRequestGetCommerceOrders setUpdatedBefore (String updatedBefore) {
      this.setParam("updated_before", updatedBefore);
      return this;
    }

    public APIRequestGetCommerceOrders requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetCommerceOrders requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCommerceOrders requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetCommerceOrders requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCommerceOrders requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetCommerceOrders requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetCommerceOrders requestBuyerDetailsField () {
      return this.requestBuyerDetailsField(true);
    }
    public APIRequestGetCommerceOrders requestBuyerDetailsField (boolean value) {
      this.requestField("buyer_details", value);
      return this;
    }
    public APIRequestGetCommerceOrders requestChannelField () {
      return this.requestChannelField(true);
    }
    public APIRequestGetCommerceOrders requestChannelField (boolean value) {
      this.requestField("channel", value);
      return this;
    }
    public APIRequestGetCommerceOrders requestContainsBopisItemsField () {
      return this.requestContainsBopisItemsField(true);
    }
    public APIRequestGetCommerceOrders requestContainsBopisItemsField (boolean value) {
      this.requestField("contains_bopis_items", value);
      return this;
    }
    public APIRequestGetCommerceOrders requestCreatedField () {
      return this.requestCreatedField(true);
    }
    public APIRequestGetCommerceOrders requestCreatedField (boolean value) {
      this.requestField("created", value);
      return this;
    }
    public APIRequestGetCommerceOrders requestEstimatedPaymentDetailsField () {
      return this.requestEstimatedPaymentDetailsField(true);
    }
    public APIRequestGetCommerceOrders requestEstimatedPaymentDetailsField (boolean value) {
      this.requestField("estimated_payment_details", value);
      return this;
    }
    public APIRequestGetCommerceOrders requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetCommerceOrders requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetCommerceOrders requestIsGroupBuyField () {
      return this.requestIsGroupBuyField(true);
    }
    public APIRequestGetCommerceOrders requestIsGroupBuyField (boolean value) {
      this.requestField("is_group_buy", value);
      return this;
    }
    public APIRequestGetCommerceOrders requestIsTestOrderField () {
      return this.requestIsTestOrderField(true);
    }
    public APIRequestGetCommerceOrders requestIsTestOrderField (boolean value) {
      this.requestField("is_test_order", value);
      return this;
    }
    public APIRequestGetCommerceOrders requestLastUpdatedField () {
      return this.requestLastUpdatedField(true);
    }
    public APIRequestGetCommerceOrders requestLastUpdatedField (boolean value) {
      this.requestField("last_updated", value);
      return this;
    }
    public APIRequestGetCommerceOrders requestMerchantOrderIdField () {
      return this.requestMerchantOrderIdField(true);
    }
    public APIRequestGetCommerceOrders requestMerchantOrderIdField (boolean value) {
      this.requestField("merchant_order_id", value);
      return this;
    }
    public APIRequestGetCommerceOrders requestOrderStatusField () {
      return this.requestOrderStatusField(true);
    }
    public APIRequestGetCommerceOrders requestOrderStatusField (boolean value) {
      this.requestField("order_status", value);
      return this;
    }
    public APIRequestGetCommerceOrders requestPreOrderDetailsField () {
      return this.requestPreOrderDetailsField(true);
    }
    public APIRequestGetCommerceOrders requestPreOrderDetailsField (boolean value) {
      this.requestField("pre_order_details", value);
      return this;
    }
    public APIRequestGetCommerceOrders requestSelectedShippingOptionField () {
      return this.requestSelectedShippingOptionField(true);
    }
    public APIRequestGetCommerceOrders requestSelectedShippingOptionField (boolean value) {
      this.requestField("selected_shipping_option", value);
      return this;
    }
    public APIRequestGetCommerceOrders requestShipByDateField () {
      return this.requestShipByDateField(true);
    }
    public APIRequestGetCommerceOrders requestShipByDateField (boolean value) {
      this.requestField("ship_by_date", value);
      return this;
    }
    public APIRequestGetCommerceOrders requestShippingAddressField () {
      return this.requestShippingAddressField(true);
    }
    public APIRequestGetCommerceOrders requestShippingAddressField (boolean value) {
      this.requestField("shipping_address", value);
      return this;
    }
  }

  public static class APIRequestGetCommercePayouts extends APIRequest<CommercePayout> {

    APINodeList<CommercePayout> lastResponse = null;
    @Override
    public APINodeList<CommercePayout> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "end_time",
      "start_time",
    };

    public static final String[] FIELDS = {
      "amount",
      "payout_date",
      "payout_reference_id",
      "status",
      "transfer_id",
    };

    @Override
    public APINodeList<CommercePayout> parseResponse(String response, String header) throws APIException {
      return CommercePayout.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<CommercePayout> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<CommercePayout> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<CommercePayout>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<CommercePayout>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<CommercePayout>>() {
           public APINodeList<CommercePayout> apply(ResponseWrapper result) {
             try {
               return APIRequestGetCommercePayouts.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetCommercePayouts(String nodeId, APIContext context) {
      super(context, nodeId, "/commerce_payouts", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetCommercePayouts setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetCommercePayouts setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetCommercePayouts setEndTime (String endTime) {
      this.setParam("end_time", endTime);
      return this;
    }

    public APIRequestGetCommercePayouts setStartTime (String startTime) {
      this.setParam("start_time", startTime);
      return this;
    }

    public APIRequestGetCommercePayouts requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetCommercePayouts requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCommercePayouts requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetCommercePayouts requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCommercePayouts requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetCommercePayouts requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetCommercePayouts requestAmountField () {
      return this.requestAmountField(true);
    }
    public APIRequestGetCommercePayouts requestAmountField (boolean value) {
      this.requestField("amount", value);
      return this;
    }
    public APIRequestGetCommercePayouts requestPayoutDateField () {
      return this.requestPayoutDateField(true);
    }
    public APIRequestGetCommercePayouts requestPayoutDateField (boolean value) {
      this.requestField("payout_date", value);
      return this;
    }
    public APIRequestGetCommercePayouts requestPayoutReferenceIdField () {
      return this.requestPayoutReferenceIdField(true);
    }
    public APIRequestGetCommercePayouts requestPayoutReferenceIdField (boolean value) {
      this.requestField("payout_reference_id", value);
      return this;
    }
    public APIRequestGetCommercePayouts requestStatusField () {
      return this.requestStatusField(true);
    }
    public APIRequestGetCommercePayouts requestStatusField (boolean value) {
      this.requestField("status", value);
      return this;
    }
    public APIRequestGetCommercePayouts requestTransferIdField () {
      return this.requestTransferIdField(true);
    }
    public APIRequestGetCommercePayouts requestTransferIdField (boolean value) {
      this.requestField("transfer_id", value);
      return this;
    }
  }

  public static class APIRequestGetCommerceTransactions extends APIRequest<CommerceOrderTransactionDetail> {

    APINodeList<CommerceOrderTransactionDetail> lastResponse = null;
    @Override
    public APINodeList<CommerceOrderTransactionDetail> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "end_time",
      "payout_reference_id",
      "start_time",
    };

    public static final String[] FIELDS = {
      "merchant_order_id",
      "net_payment_amount",
      "order_created",
      "order_details",
      "order_id",
      "payout_reference_id",
      "postal_code",
      "processing_fee",
      "state",
      "tax_rate",
      "transaction_date",
      "transaction_type",
      "transfer_id",
      "id",
    };

    @Override
    public APINodeList<CommerceOrderTransactionDetail> parseResponse(String response, String header) throws APIException {
      return CommerceOrderTransactionDetail.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<CommerceOrderTransactionDetail> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<CommerceOrderTransactionDetail> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<CommerceOrderTransactionDetail>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<CommerceOrderTransactionDetail>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<CommerceOrderTransactionDetail>>() {
           public APINodeList<CommerceOrderTransactionDetail> apply(ResponseWrapper result) {
             try {
               return APIRequestGetCommerceTransactions.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetCommerceTransactions(String nodeId, APIContext context) {
      super(context, nodeId, "/commerce_transactions", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetCommerceTransactions setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetCommerceTransactions setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetCommerceTransactions setEndTime (String endTime) {
      this.setParam("end_time", endTime);
      return this;
    }

    public APIRequestGetCommerceTransactions setPayoutReferenceId (String payoutReferenceId) {
      this.setParam("payout_reference_id", payoutReferenceId);
      return this;
    }

    public APIRequestGetCommerceTransactions setStartTime (String startTime) {
      this.setParam("start_time", startTime);
      return this;
    }

    public APIRequestGetCommerceTransactions requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetCommerceTransactions requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCommerceTransactions requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetCommerceTransactions requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCommerceTransactions requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetCommerceTransactions requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetCommerceTransactions requestMerchantOrderIdField () {
      return this.requestMerchantOrderIdField(true);
    }
    public APIRequestGetCommerceTransactions requestMerchantOrderIdField (boolean value) {
      this.requestField("merchant_order_id", value);
      return this;
    }
    public APIRequestGetCommerceTransactions requestNetPaymentAmountField () {
      return this.requestNetPaymentAmountField(true);
    }
    public APIRequestGetCommerceTransactions requestNetPaymentAmountField (boolean value) {
      this.requestField("net_payment_amount", value);
      return this;
    }
    public APIRequestGetCommerceTransactions requestOrderCreatedField () {
      return this.requestOrderCreatedField(true);
    }
    public APIRequestGetCommerceTransactions requestOrderCreatedField (boolean value) {
      this.requestField("order_created", value);
      return this;
    }
    public APIRequestGetCommerceTransactions requestOrderDetailsField () {
      return this.requestOrderDetailsField(true);
    }
    public APIRequestGetCommerceTransactions requestOrderDetailsField (boolean value) {
      this.requestField("order_details", value);
      return this;
    }
    public APIRequestGetCommerceTransactions requestOrderIdField () {
      return this.requestOrderIdField(true);
    }
    public APIRequestGetCommerceTransactions requestOrderIdField (boolean value) {
      this.requestField("order_id", value);
      return this;
    }
    public APIRequestGetCommerceTransactions requestPayoutReferenceIdField () {
      return this.requestPayoutReferenceIdField(true);
    }
    public APIRequestGetCommerceTransactions requestPayoutReferenceIdField (boolean value) {
      this.requestField("payout_reference_id", value);
      return this;
    }
    public APIRequestGetCommerceTransactions requestPostalCodeField () {
      return this.requestPostalCodeField(true);
    }
    public APIRequestGetCommerceTransactions requestPostalCodeField (boolean value) {
      this.requestField("postal_code", value);
      return this;
    }
    public APIRequestGetCommerceTransactions requestProcessingFeeField () {
      return this.requestProcessingFeeField(true);
    }
    public APIRequestGetCommerceTransactions requestProcessingFeeField (boolean value) {
      this.requestField("processing_fee", value);
      return this;
    }
    public APIRequestGetCommerceTransactions requestStateField () {
      return this.requestStateField(true);
    }
    public APIRequestGetCommerceTransactions requestStateField (boolean value) {
      this.requestField("state", value);
      return this;
    }
    public APIRequestGetCommerceTransactions requestTaxRateField () {
      return this.requestTaxRateField(true);
    }
    public APIRequestGetCommerceTransactions requestTaxRateField (boolean value) {
      this.requestField("tax_rate", value);
      return this;
    }
    public APIRequestGetCommerceTransactions requestTransactionDateField () {
      return this.requestTransactionDateField(true);
    }
    public APIRequestGetCommerceTransactions requestTransactionDateField (boolean value) {
      this.requestField("transaction_date", value);
      return this;
    }
    public APIRequestGetCommerceTransactions requestTransactionTypeField () {
      return this.requestTransactionTypeField(true);
    }
    public APIRequestGetCommerceTransactions requestTransactionTypeField (boolean value) {
      this.requestField("transaction_type", value);
      return this;
    }
    public APIRequestGetCommerceTransactions requestTransferIdField () {
      return this.requestTransferIdField(true);
    }
    public APIRequestGetCommerceTransactions requestTransferIdField (boolean value) {
      this.requestField("transfer_id", value);
      return this;
    }
    public APIRequestGetCommerceTransactions requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetCommerceTransactions requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
  }

  public static class APIRequestGetConversations extends APIRequest<UnifiedThread> {

    APINodeList<UnifiedThread> lastResponse = null;
    @Override
    public APINodeList<UnifiedThread> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "folder",
      "is_owner",
      "platform",
      "tags",
      "user_id",
    };

    public static final String[] FIELDS = {
      "can_reply",
      "folder",
      "former_participants",
      "id",
      "is_owner",
      "is_subscribed",
      "link",
      "linked_group",
      "message_count",
      "name",
      "participants",
      "scoped_thread_key",
      "senders",
      "snippet",
      "unread_count",
      "updated_time",
      "wallpaper",
    };

    @Override
    public APINodeList<UnifiedThread> parseResponse(String response, String header) throws APIException {
      return UnifiedThread.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<UnifiedThread> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<UnifiedThread> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<UnifiedThread>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<UnifiedThread>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<UnifiedThread>>() {
           public APINodeList<UnifiedThread> apply(ResponseWrapper result) {
             try {
               return APIRequestGetConversations.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetConversations(String nodeId, APIContext context) {
      super(context, nodeId, "/conversations", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetConversations setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetConversations setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetConversations setFolder (String folder) {
      this.setParam("folder", folder);
      return this;
    }

    public APIRequestGetConversations setIsOwner (Boolean isOwner) {
      this.setParam("is_owner", isOwner);
      return this;
    }
    public APIRequestGetConversations setIsOwner (String isOwner) {
      this.setParam("is_owner", isOwner);
      return this;
    }

    public APIRequestGetConversations setPlatform (UnifiedThread.EnumPlatform platform) {
      this.setParam("platform", platform);
      return this;
    }
    public APIRequestGetConversations setPlatform (String platform) {
      this.setParam("platform", platform);
      return this;
    }

    public APIRequestGetConversations setTags (List<String> tags) {
      this.setParam("tags", tags);
      return this;
    }
    public APIRequestGetConversations setTags (String tags) {
      this.setParam("tags", tags);
      return this;
    }

    public APIRequestGetConversations setUserId (String userId) {
      this.setParam("user_id", userId);
      return this;
    }

    public APIRequestGetConversations requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetConversations requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetConversations requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetConversations requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetConversations requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetConversations requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetConversations requestCanReplyField () {
      return this.requestCanReplyField(true);
    }
    public APIRequestGetConversations requestCanReplyField (boolean value) {
      this.requestField("can_reply", value);
      return this;
    }
    public APIRequestGetConversations requestFolderField () {
      return this.requestFolderField(true);
    }
    public APIRequestGetConversations requestFolderField (boolean value) {
      this.requestField("folder", value);
      return this;
    }
    public APIRequestGetConversations requestFormerParticipantsField () {
      return this.requestFormerParticipantsField(true);
    }
    public APIRequestGetConversations requestFormerParticipantsField (boolean value) {
      this.requestField("former_participants", value);
      return this;
    }
    public APIRequestGetConversations requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetConversations requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetConversations requestIsOwnerField () {
      return this.requestIsOwnerField(true);
    }
    public APIRequestGetConversations requestIsOwnerField (boolean value) {
      this.requestField("is_owner", value);
      return this;
    }
    public APIRequestGetConversations requestIsSubscribedField () {
      return this.requestIsSubscribedField(true);
    }
    public APIRequestGetConversations requestIsSubscribedField (boolean value) {
      this.requestField("is_subscribed", value);
      return this;
    }
    public APIRequestGetConversations requestLinkField () {
      return this.requestLinkField(true);
    }
    public APIRequestGetConversations requestLinkField (boolean value) {
      this.requestField("link", value);
      return this;
    }
    public APIRequestGetConversations requestLinkedGroupField () {
      return this.requestLinkedGroupField(true);
    }
    public APIRequestGetConversations requestLinkedGroupField (boolean value) {
      this.requestField("linked_group", value);
      return this;
    }
    public APIRequestGetConversations requestMessageCountField () {
      return this.requestMessageCountField(true);
    }
    public APIRequestGetConversations requestMessageCountField (boolean value) {
      this.requestField("message_count", value);
      return this;
    }
    public APIRequestGetConversations requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetConversations requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetConversations requestParticipantsField () {
      return this.requestParticipantsField(true);
    }
    public APIRequestGetConversations requestParticipantsField (boolean value) {
      this.requestField("participants", value);
      return this;
    }
    public APIRequestGetConversations requestScopedThreadKeyField () {
      return this.requestScopedThreadKeyField(true);
    }
    public APIRequestGetConversations requestScopedThreadKeyField (boolean value) {
      this.requestField("scoped_thread_key", value);
      return this;
    }
    public APIRequestGetConversations requestSendersField () {
      return this.requestSendersField(true);
    }
    public APIRequestGetConversations requestSendersField (boolean value) {
      this.requestField("senders", value);
      return this;
    }
    public APIRequestGetConversations requestSnippetField () {
      return this.requestSnippetField(true);
    }
    public APIRequestGetConversations requestSnippetField (boolean value) {
      this.requestField("snippet", value);
      return this;
    }
    public APIRequestGetConversations requestUnreadCountField () {
      return this.requestUnreadCountField(true);
    }
    public APIRequestGetConversations requestUnreadCountField (boolean value) {
      this.requestField("unread_count", value);
      return this;
    }
    public APIRequestGetConversations requestUpdatedTimeField () {
      return this.requestUpdatedTimeField(true);
    }
    public APIRequestGetConversations requestUpdatedTimeField (boolean value) {
      this.requestField("updated_time", value);
      return this;
    }
    public APIRequestGetConversations requestWallpaperField () {
      return this.requestWallpaperField(true);
    }
    public APIRequestGetConversations requestWallpaperField (boolean value) {
      this.requestField("wallpaper", value);
      return this;
    }
  }

  public static class APIRequestCreateCopyrightManualClaim extends APIRequest<VideoCopyrightMatch> {

    VideoCopyrightMatch lastResponse = null;
    @Override
    public VideoCopyrightMatch getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "action",
      "action_reason",
      "countries",
      "match_content_type",
      "matched_asset_id",
      "reference_asset_id",
      "selected_segments",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public VideoCopyrightMatch parseResponse(String response, String header) throws APIException {
      return VideoCopyrightMatch.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public VideoCopyrightMatch execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public VideoCopyrightMatch execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<VideoCopyrightMatch> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<VideoCopyrightMatch> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, VideoCopyrightMatch>() {
           public VideoCopyrightMatch apply(ResponseWrapper result) {
             try {
               return APIRequestCreateCopyrightManualClaim.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateCopyrightManualClaim(String nodeId, APIContext context) {
      super(context, nodeId, "/copyright_manual_claims", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateCopyrightManualClaim setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateCopyrightManualClaim setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateCopyrightManualClaim setAction (VideoCopyrightMatch.EnumAction action) {
      this.setParam("action", action);
      return this;
    }
    public APIRequestCreateCopyrightManualClaim setAction (String action) {
      this.setParam("action", action);
      return this;
    }

    public APIRequestCreateCopyrightManualClaim setActionReason (VideoCopyrightMatch.EnumActionReason actionReason) {
      this.setParam("action_reason", actionReason);
      return this;
    }
    public APIRequestCreateCopyrightManualClaim setActionReason (String actionReason) {
      this.setParam("action_reason", actionReason);
      return this;
    }

    public APIRequestCreateCopyrightManualClaim setCountries (Object countries) {
      this.setParam("countries", countries);
      return this;
    }
    public APIRequestCreateCopyrightManualClaim setCountries (String countries) {
      this.setParam("countries", countries);
      return this;
    }

    public APIRequestCreateCopyrightManualClaim setMatchContentType (VideoCopyrightMatch.EnumMatchContentType matchContentType) {
      this.setParam("match_content_type", matchContentType);
      return this;
    }
    public APIRequestCreateCopyrightManualClaim setMatchContentType (String matchContentType) {
      this.setParam("match_content_type", matchContentType);
      return this;
    }

    public APIRequestCreateCopyrightManualClaim setMatchedAssetId (String matchedAssetId) {
      this.setParam("matched_asset_id", matchedAssetId);
      return this;
    }

    public APIRequestCreateCopyrightManualClaim setReferenceAssetId (String referenceAssetId) {
      this.setParam("reference_asset_id", referenceAssetId);
      return this;
    }

    public APIRequestCreateCopyrightManualClaim setSelectedSegments (List<Map<String, String>> selectedSegments) {
      this.setParam("selected_segments", selectedSegments);
      return this;
    }
    public APIRequestCreateCopyrightManualClaim setSelectedSegments (String selectedSegments) {
      this.setParam("selected_segments", selectedSegments);
      return this;
    }

    public APIRequestCreateCopyrightManualClaim requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateCopyrightManualClaim requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateCopyrightManualClaim requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateCopyrightManualClaim requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateCopyrightManualClaim requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateCopyrightManualClaim requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetCrosspostWhitelistedPages extends APIRequest<Page> {

    APINodeList<Page> lastResponse = null;
    @Override
    public APINodeList<Page> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "about",
      "access_token",
      "ad_campaign",
      "affiliation",
      "app_id",
      "artists_we_like",
      "attire",
      "available_promo_offer_ids",
      "awards",
      "band_interests",
      "band_members",
      "best_page",
      "bio",
      "birthday",
      "booking_agent",
      "breaking_news_usage",
      "built",
      "business",
      "can_checkin",
      "can_post",
      "category",
      "category_list",
      "checkins",
      "company_overview",
      "connected_instagram_account",
      "connected_page_backed_instagram_account",
      "contact_address",
      "copyright_attribution_insights",
      "copyright_whitelisted_ig_partners",
      "country_page_likes",
      "cover",
      "culinary_team",
      "current_location",
      "delivery_and_pickup_option_info",
      "description",
      "description_html",
      "differently_open_offerings",
      "directed_by",
      "display_subtext",
      "displayed_message_response_time",
      "does_viewer_have_page_permission_link_ig",
      "emails",
      "engagement",
      "fan_count",
      "featured_video",
      "features",
      "followers_count",
      "food_styles",
      "founded",
      "general_info",
      "general_manager",
      "genre",
      "global_brand_page_name",
      "global_brand_root_id",
      "has_added_app",
      "has_lead_access",
      "has_transitioned_to_new_page_experience",
      "has_whatsapp_business_number",
      "has_whatsapp_number",
      "hometown",
      "hours",
      "id",
      "impressum",
      "influences",
      "instagram_business_account",
      "is_always_open",
      "is_calling_eligible",
      "is_chain",
      "is_community_page",
      "is_eligible_for_branded_content",
      "is_eligible_for_disable_connect_ig_btn_for_non_page_admin_am_web",
      "is_messenger_bot_get_started_enabled",
      "is_messenger_platform_bot",
      "is_owned",
      "is_permanently_closed",
      "is_published",
      "is_unclaimed",
      "is_verified",
      "is_webhooks_subscribed",
      "keywords",
      "leadgen_tos_acceptance_time",
      "leadgen_tos_accepted",
      "leadgen_tos_accepting_user",
      "link",
      "location",
      "members",
      "merchant_id",
      "merchant_review_status",
      "messaging_feature_status",
      "messenger_ads_default_icebreakers",
      "messenger_ads_default_quick_replies",
      "messenger_ads_quick_replies_type",
      "mini_shop_storefront",
      "mission",
      "mpg",
      "name",
      "name_with_location_descriptor",
      "network",
      "new_like_count",
      "offer_eligible",
      "overall_star_rating",
      "owner_business",
      "page_token",
      "parent_page",
      "parking",
      "payment_options",
      "personal_info",
      "personal_interests",
      "pharma_safety_info",
      "phone",
      "pickup_options",
      "place_type",
      "plot_outline",
      "preferred_audience",
      "press_contact",
      "price_range",
      "privacy_info_url",
      "produced_by",
      "products",
      "promotion_eligible",
      "promotion_ineligible_reason",
      "public_transit",
      "rating_count",
      "recipient",
      "record_label",
      "release_date",
      "restaurant_services",
      "restaurant_specialties",
      "schedule",
      "screenplay_by",
      "season",
      "single_line_address",
      "starring",
      "start_info",
      "store_code",
      "store_location_descriptor",
      "store_number",
      "studio",
      "supports_donate_button_in_live_video",
      "talking_about_count",
      "temporary_status",
      "unread_message_count",
      "unread_notif_count",
      "unseen_message_count",
      "user_access_expire_time",
      "username",
      "verification_status",
      "voip_info",
      "website",
      "were_here_count",
      "whatsapp_number",
      "written_by",
    };

    @Override
    public APINodeList<Page> parseResponse(String response, String header) throws APIException {
      return Page.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<Page> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Page> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Page>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Page>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<Page>>() {
           public APINodeList<Page> apply(ResponseWrapper result) {
             try {
               return APIRequestGetCrosspostWhitelistedPages.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetCrosspostWhitelistedPages(String nodeId, APIContext context) {
      super(context, nodeId, "/crosspost_whitelisted_pages", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetCrosspostWhitelistedPages setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetCrosspostWhitelistedPages setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetCrosspostWhitelistedPages requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetCrosspostWhitelistedPages requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCrosspostWhitelistedPages requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetCrosspostWhitelistedPages requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCrosspostWhitelistedPages requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetCrosspostWhitelistedPages requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetCrosspostWhitelistedPages requestAboutField () {
      return this.requestAboutField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestAboutField (boolean value) {
      this.requestField("about", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestAccessTokenField () {
      return this.requestAccessTokenField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestAccessTokenField (boolean value) {
      this.requestField("access_token", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestAdCampaignField () {
      return this.requestAdCampaignField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestAdCampaignField (boolean value) {
      this.requestField("ad_campaign", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestAffiliationField () {
      return this.requestAffiliationField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestAffiliationField (boolean value) {
      this.requestField("affiliation", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestAppIdField () {
      return this.requestAppIdField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestAppIdField (boolean value) {
      this.requestField("app_id", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestArtistsWeLikeField () {
      return this.requestArtistsWeLikeField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestArtistsWeLikeField (boolean value) {
      this.requestField("artists_we_like", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestAttireField () {
      return this.requestAttireField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestAttireField (boolean value) {
      this.requestField("attire", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestAvailablePromoOfferIdsField () {
      return this.requestAvailablePromoOfferIdsField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestAvailablePromoOfferIdsField (boolean value) {
      this.requestField("available_promo_offer_ids", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestAwardsField () {
      return this.requestAwardsField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestAwardsField (boolean value) {
      this.requestField("awards", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestBandInterestsField () {
      return this.requestBandInterestsField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestBandInterestsField (boolean value) {
      this.requestField("band_interests", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestBandMembersField () {
      return this.requestBandMembersField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestBandMembersField (boolean value) {
      this.requestField("band_members", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestBestPageField () {
      return this.requestBestPageField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestBestPageField (boolean value) {
      this.requestField("best_page", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestBioField () {
      return this.requestBioField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestBioField (boolean value) {
      this.requestField("bio", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestBirthdayField () {
      return this.requestBirthdayField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestBirthdayField (boolean value) {
      this.requestField("birthday", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestBookingAgentField () {
      return this.requestBookingAgentField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestBookingAgentField (boolean value) {
      this.requestField("booking_agent", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestBreakingNewsUsageField () {
      return this.requestBreakingNewsUsageField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestBreakingNewsUsageField (boolean value) {
      this.requestField("breaking_news_usage", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestBuiltField () {
      return this.requestBuiltField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestBuiltField (boolean value) {
      this.requestField("built", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestBusinessField () {
      return this.requestBusinessField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestBusinessField (boolean value) {
      this.requestField("business", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestCanCheckinField () {
      return this.requestCanCheckinField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestCanCheckinField (boolean value) {
      this.requestField("can_checkin", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestCanPostField () {
      return this.requestCanPostField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestCanPostField (boolean value) {
      this.requestField("can_post", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestCategoryField () {
      return this.requestCategoryField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestCategoryField (boolean value) {
      this.requestField("category", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestCategoryListField () {
      return this.requestCategoryListField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestCategoryListField (boolean value) {
      this.requestField("category_list", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestCheckinsField () {
      return this.requestCheckinsField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestCheckinsField (boolean value) {
      this.requestField("checkins", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestCompanyOverviewField () {
      return this.requestCompanyOverviewField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestCompanyOverviewField (boolean value) {
      this.requestField("company_overview", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestConnectedInstagramAccountField () {
      return this.requestConnectedInstagramAccountField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestConnectedInstagramAccountField (boolean value) {
      this.requestField("connected_instagram_account", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestConnectedPageBackedInstagramAccountField () {
      return this.requestConnectedPageBackedInstagramAccountField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestConnectedPageBackedInstagramAccountField (boolean value) {
      this.requestField("connected_page_backed_instagram_account", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestContactAddressField () {
      return this.requestContactAddressField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestContactAddressField (boolean value) {
      this.requestField("contact_address", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestCopyrightAttributionInsightsField () {
      return this.requestCopyrightAttributionInsightsField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestCopyrightAttributionInsightsField (boolean value) {
      this.requestField("copyright_attribution_insights", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestCopyrightWhitelistedIgPartnersField () {
      return this.requestCopyrightWhitelistedIgPartnersField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestCopyrightWhitelistedIgPartnersField (boolean value) {
      this.requestField("copyright_whitelisted_ig_partners", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestCountryPageLikesField () {
      return this.requestCountryPageLikesField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestCountryPageLikesField (boolean value) {
      this.requestField("country_page_likes", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestCoverField () {
      return this.requestCoverField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestCoverField (boolean value) {
      this.requestField("cover", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestCulinaryTeamField () {
      return this.requestCulinaryTeamField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestCulinaryTeamField (boolean value) {
      this.requestField("culinary_team", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestCurrentLocationField () {
      return this.requestCurrentLocationField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestCurrentLocationField (boolean value) {
      this.requestField("current_location", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestDeliveryAndPickupOptionInfoField () {
      return this.requestDeliveryAndPickupOptionInfoField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestDeliveryAndPickupOptionInfoField (boolean value) {
      this.requestField("delivery_and_pickup_option_info", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestDescriptionHtmlField () {
      return this.requestDescriptionHtmlField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestDescriptionHtmlField (boolean value) {
      this.requestField("description_html", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestDifferentlyOpenOfferingsField () {
      return this.requestDifferentlyOpenOfferingsField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestDifferentlyOpenOfferingsField (boolean value) {
      this.requestField("differently_open_offerings", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestDirectedByField () {
      return this.requestDirectedByField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestDirectedByField (boolean value) {
      this.requestField("directed_by", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestDisplaySubtextField () {
      return this.requestDisplaySubtextField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestDisplaySubtextField (boolean value) {
      this.requestField("display_subtext", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestDisplayedMessageResponseTimeField () {
      return this.requestDisplayedMessageResponseTimeField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestDisplayedMessageResponseTimeField (boolean value) {
      this.requestField("displayed_message_response_time", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestDoesViewerHavePagePermissionLinkIgField () {
      return this.requestDoesViewerHavePagePermissionLinkIgField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestDoesViewerHavePagePermissionLinkIgField (boolean value) {
      this.requestField("does_viewer_have_page_permission_link_ig", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestEmailsField () {
      return this.requestEmailsField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestEmailsField (boolean value) {
      this.requestField("emails", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestEngagementField () {
      return this.requestEngagementField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestEngagementField (boolean value) {
      this.requestField("engagement", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestFanCountField () {
      return this.requestFanCountField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestFanCountField (boolean value) {
      this.requestField("fan_count", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestFeaturedVideoField () {
      return this.requestFeaturedVideoField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestFeaturedVideoField (boolean value) {
      this.requestField("featured_video", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestFeaturesField () {
      return this.requestFeaturesField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestFeaturesField (boolean value) {
      this.requestField("features", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestFollowersCountField () {
      return this.requestFollowersCountField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestFollowersCountField (boolean value) {
      this.requestField("followers_count", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestFoodStylesField () {
      return this.requestFoodStylesField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestFoodStylesField (boolean value) {
      this.requestField("food_styles", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestFoundedField () {
      return this.requestFoundedField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestFoundedField (boolean value) {
      this.requestField("founded", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestGeneralInfoField () {
      return this.requestGeneralInfoField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestGeneralInfoField (boolean value) {
      this.requestField("general_info", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestGeneralManagerField () {
      return this.requestGeneralManagerField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestGeneralManagerField (boolean value) {
      this.requestField("general_manager", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestGenreField () {
      return this.requestGenreField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestGenreField (boolean value) {
      this.requestField("genre", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestGlobalBrandPageNameField () {
      return this.requestGlobalBrandPageNameField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestGlobalBrandPageNameField (boolean value) {
      this.requestField("global_brand_page_name", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestGlobalBrandRootIdField () {
      return this.requestGlobalBrandRootIdField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestGlobalBrandRootIdField (boolean value) {
      this.requestField("global_brand_root_id", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestHasAddedAppField () {
      return this.requestHasAddedAppField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestHasAddedAppField (boolean value) {
      this.requestField("has_added_app", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestHasLeadAccessField () {
      return this.requestHasLeadAccessField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestHasLeadAccessField (boolean value) {
      this.requestField("has_lead_access", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestHasTransitionedToNewPageExperienceField () {
      return this.requestHasTransitionedToNewPageExperienceField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestHasTransitionedToNewPageExperienceField (boolean value) {
      this.requestField("has_transitioned_to_new_page_experience", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestHasWhatsappBusinessNumberField () {
      return this.requestHasWhatsappBusinessNumberField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestHasWhatsappBusinessNumberField (boolean value) {
      this.requestField("has_whatsapp_business_number", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestHasWhatsappNumberField () {
      return this.requestHasWhatsappNumberField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestHasWhatsappNumberField (boolean value) {
      this.requestField("has_whatsapp_number", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestHometownField () {
      return this.requestHometownField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestHometownField (boolean value) {
      this.requestField("hometown", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestHoursField () {
      return this.requestHoursField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestHoursField (boolean value) {
      this.requestField("hours", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestImpressumField () {
      return this.requestImpressumField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestImpressumField (boolean value) {
      this.requestField("impressum", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestInfluencesField () {
      return this.requestInfluencesField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestInfluencesField (boolean value) {
      this.requestField("influences", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestInstagramBusinessAccountField () {
      return this.requestInstagramBusinessAccountField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestInstagramBusinessAccountField (boolean value) {
      this.requestField("instagram_business_account", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsAlwaysOpenField () {
      return this.requestIsAlwaysOpenField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsAlwaysOpenField (boolean value) {
      this.requestField("is_always_open", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsCallingEligibleField () {
      return this.requestIsCallingEligibleField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsCallingEligibleField (boolean value) {
      this.requestField("is_calling_eligible", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsChainField () {
      return this.requestIsChainField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsChainField (boolean value) {
      this.requestField("is_chain", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsCommunityPageField () {
      return this.requestIsCommunityPageField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsCommunityPageField (boolean value) {
      this.requestField("is_community_page", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsEligibleForBrandedContentField () {
      return this.requestIsEligibleForBrandedContentField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsEligibleForBrandedContentField (boolean value) {
      this.requestField("is_eligible_for_branded_content", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsEligibleForDisableConnectIgBtnForNonPageAdminAmWebField () {
      return this.requestIsEligibleForDisableConnectIgBtnForNonPageAdminAmWebField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsEligibleForDisableConnectIgBtnForNonPageAdminAmWebField (boolean value) {
      this.requestField("is_eligible_for_disable_connect_ig_btn_for_non_page_admin_am_web", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsMessengerBotGetStartedEnabledField () {
      return this.requestIsMessengerBotGetStartedEnabledField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsMessengerBotGetStartedEnabledField (boolean value) {
      this.requestField("is_messenger_bot_get_started_enabled", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsMessengerPlatformBotField () {
      return this.requestIsMessengerPlatformBotField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsMessengerPlatformBotField (boolean value) {
      this.requestField("is_messenger_platform_bot", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsOwnedField () {
      return this.requestIsOwnedField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsOwnedField (boolean value) {
      this.requestField("is_owned", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsPermanentlyClosedField () {
      return this.requestIsPermanentlyClosedField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsPermanentlyClosedField (boolean value) {
      this.requestField("is_permanently_closed", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsPublishedField () {
      return this.requestIsPublishedField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsPublishedField (boolean value) {
      this.requestField("is_published", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsUnclaimedField () {
      return this.requestIsUnclaimedField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsUnclaimedField (boolean value) {
      this.requestField("is_unclaimed", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsVerifiedField () {
      return this.requestIsVerifiedField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsVerifiedField (boolean value) {
      this.requestField("is_verified", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsWebhooksSubscribedField () {
      return this.requestIsWebhooksSubscribedField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsWebhooksSubscribedField (boolean value) {
      this.requestField("is_webhooks_subscribed", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestKeywordsField () {
      return this.requestKeywordsField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestKeywordsField (boolean value) {
      this.requestField("keywords", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestLeadgenTosAcceptanceTimeField () {
      return this.requestLeadgenTosAcceptanceTimeField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestLeadgenTosAcceptanceTimeField (boolean value) {
      this.requestField("leadgen_tos_acceptance_time", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestLeadgenTosAcceptedField () {
      return this.requestLeadgenTosAcceptedField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestLeadgenTosAcceptedField (boolean value) {
      this.requestField("leadgen_tos_accepted", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestLeadgenTosAcceptingUserField () {
      return this.requestLeadgenTosAcceptingUserField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestLeadgenTosAcceptingUserField (boolean value) {
      this.requestField("leadgen_tos_accepting_user", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestLinkField () {
      return this.requestLinkField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestLinkField (boolean value) {
      this.requestField("link", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestLocationField () {
      return this.requestLocationField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestLocationField (boolean value) {
      this.requestField("location", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestMembersField () {
      return this.requestMembersField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestMembersField (boolean value) {
      this.requestField("members", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestMerchantIdField () {
      return this.requestMerchantIdField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestMerchantIdField (boolean value) {
      this.requestField("merchant_id", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestMerchantReviewStatusField () {
      return this.requestMerchantReviewStatusField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestMerchantReviewStatusField (boolean value) {
      this.requestField("merchant_review_status", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestMessagingFeatureStatusField () {
      return this.requestMessagingFeatureStatusField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestMessagingFeatureStatusField (boolean value) {
      this.requestField("messaging_feature_status", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestMessengerAdsDefaultIcebreakersField () {
      return this.requestMessengerAdsDefaultIcebreakersField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestMessengerAdsDefaultIcebreakersField (boolean value) {
      this.requestField("messenger_ads_default_icebreakers", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestMessengerAdsDefaultQuickRepliesField () {
      return this.requestMessengerAdsDefaultQuickRepliesField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestMessengerAdsDefaultQuickRepliesField (boolean value) {
      this.requestField("messenger_ads_default_quick_replies", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestMessengerAdsQuickRepliesTypeField () {
      return this.requestMessengerAdsQuickRepliesTypeField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestMessengerAdsQuickRepliesTypeField (boolean value) {
      this.requestField("messenger_ads_quick_replies_type", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestMiniShopStorefrontField () {
      return this.requestMiniShopStorefrontField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestMiniShopStorefrontField (boolean value) {
      this.requestField("mini_shop_storefront", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestMissionField () {
      return this.requestMissionField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestMissionField (boolean value) {
      this.requestField("mission", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestMpgField () {
      return this.requestMpgField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestMpgField (boolean value) {
      this.requestField("mpg", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestNameWithLocationDescriptorField () {
      return this.requestNameWithLocationDescriptorField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestNameWithLocationDescriptorField (boolean value) {
      this.requestField("name_with_location_descriptor", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestNetworkField () {
      return this.requestNetworkField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestNetworkField (boolean value) {
      this.requestField("network", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestNewLikeCountField () {
      return this.requestNewLikeCountField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestNewLikeCountField (boolean value) {
      this.requestField("new_like_count", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestOfferEligibleField () {
      return this.requestOfferEligibleField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestOfferEligibleField (boolean value) {
      this.requestField("offer_eligible", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestOverallStarRatingField () {
      return this.requestOverallStarRatingField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestOverallStarRatingField (boolean value) {
      this.requestField("overall_star_rating", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestOwnerBusinessField () {
      return this.requestOwnerBusinessField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestOwnerBusinessField (boolean value) {
      this.requestField("owner_business", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPageTokenField () {
      return this.requestPageTokenField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPageTokenField (boolean value) {
      this.requestField("page_token", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestParentPageField () {
      return this.requestParentPageField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestParentPageField (boolean value) {
      this.requestField("parent_page", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestParkingField () {
      return this.requestParkingField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestParkingField (boolean value) {
      this.requestField("parking", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPaymentOptionsField () {
      return this.requestPaymentOptionsField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPaymentOptionsField (boolean value) {
      this.requestField("payment_options", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPersonalInfoField () {
      return this.requestPersonalInfoField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPersonalInfoField (boolean value) {
      this.requestField("personal_info", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPersonalInterestsField () {
      return this.requestPersonalInterestsField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPersonalInterestsField (boolean value) {
      this.requestField("personal_interests", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPharmaSafetyInfoField () {
      return this.requestPharmaSafetyInfoField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPharmaSafetyInfoField (boolean value) {
      this.requestField("pharma_safety_info", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPhoneField () {
      return this.requestPhoneField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPhoneField (boolean value) {
      this.requestField("phone", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPickupOptionsField () {
      return this.requestPickupOptionsField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPickupOptionsField (boolean value) {
      this.requestField("pickup_options", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPlaceTypeField () {
      return this.requestPlaceTypeField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPlaceTypeField (boolean value) {
      this.requestField("place_type", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPlotOutlineField () {
      return this.requestPlotOutlineField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPlotOutlineField (boolean value) {
      this.requestField("plot_outline", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPreferredAudienceField () {
      return this.requestPreferredAudienceField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPreferredAudienceField (boolean value) {
      this.requestField("preferred_audience", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPressContactField () {
      return this.requestPressContactField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPressContactField (boolean value) {
      this.requestField("press_contact", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPriceRangeField () {
      return this.requestPriceRangeField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPriceRangeField (boolean value) {
      this.requestField("price_range", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPrivacyInfoUrlField () {
      return this.requestPrivacyInfoUrlField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPrivacyInfoUrlField (boolean value) {
      this.requestField("privacy_info_url", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestProducedByField () {
      return this.requestProducedByField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestProducedByField (boolean value) {
      this.requestField("produced_by", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestProductsField () {
      return this.requestProductsField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestProductsField (boolean value) {
      this.requestField("products", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPromotionEligibleField () {
      return this.requestPromotionEligibleField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPromotionEligibleField (boolean value) {
      this.requestField("promotion_eligible", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPromotionIneligibleReasonField () {
      return this.requestPromotionIneligibleReasonField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPromotionIneligibleReasonField (boolean value) {
      this.requestField("promotion_ineligible_reason", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPublicTransitField () {
      return this.requestPublicTransitField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPublicTransitField (boolean value) {
      this.requestField("public_transit", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestRatingCountField () {
      return this.requestRatingCountField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestRatingCountField (boolean value) {
      this.requestField("rating_count", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestRecipientField () {
      return this.requestRecipientField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestRecipientField (boolean value) {
      this.requestField("recipient", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestRecordLabelField () {
      return this.requestRecordLabelField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestRecordLabelField (boolean value) {
      this.requestField("record_label", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestReleaseDateField () {
      return this.requestReleaseDateField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestReleaseDateField (boolean value) {
      this.requestField("release_date", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestRestaurantServicesField () {
      return this.requestRestaurantServicesField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestRestaurantServicesField (boolean value) {
      this.requestField("restaurant_services", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestRestaurantSpecialtiesField () {
      return this.requestRestaurantSpecialtiesField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestRestaurantSpecialtiesField (boolean value) {
      this.requestField("restaurant_specialties", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestScheduleField () {
      return this.requestScheduleField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestScheduleField (boolean value) {
      this.requestField("schedule", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestScreenplayByField () {
      return this.requestScreenplayByField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestScreenplayByField (boolean value) {
      this.requestField("screenplay_by", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestSeasonField () {
      return this.requestSeasonField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestSeasonField (boolean value) {
      this.requestField("season", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestSingleLineAddressField () {
      return this.requestSingleLineAddressField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestSingleLineAddressField (boolean value) {
      this.requestField("single_line_address", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestStarringField () {
      return this.requestStarringField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestStarringField (boolean value) {
      this.requestField("starring", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestStartInfoField () {
      return this.requestStartInfoField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestStartInfoField (boolean value) {
      this.requestField("start_info", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestStoreCodeField () {
      return this.requestStoreCodeField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestStoreCodeField (boolean value) {
      this.requestField("store_code", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestStoreLocationDescriptorField () {
      return this.requestStoreLocationDescriptorField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestStoreLocationDescriptorField (boolean value) {
      this.requestField("store_location_descriptor", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestStoreNumberField () {
      return this.requestStoreNumberField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestStoreNumberField (boolean value) {
      this.requestField("store_number", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestStudioField () {
      return this.requestStudioField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestStudioField (boolean value) {
      this.requestField("studio", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestSupportsDonateButtonInLiveVideoField () {
      return this.requestSupportsDonateButtonInLiveVideoField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestSupportsDonateButtonInLiveVideoField (boolean value) {
      this.requestField("supports_donate_button_in_live_video", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestTalkingAboutCountField () {
      return this.requestTalkingAboutCountField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestTalkingAboutCountField (boolean value) {
      this.requestField("talking_about_count", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestTemporaryStatusField () {
      return this.requestTemporaryStatusField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestTemporaryStatusField (boolean value) {
      this.requestField("temporary_status", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestUnreadMessageCountField () {
      return this.requestUnreadMessageCountField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestUnreadMessageCountField (boolean value) {
      this.requestField("unread_message_count", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestUnreadNotifCountField () {
      return this.requestUnreadNotifCountField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestUnreadNotifCountField (boolean value) {
      this.requestField("unread_notif_count", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestUnseenMessageCountField () {
      return this.requestUnseenMessageCountField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestUnseenMessageCountField (boolean value) {
      this.requestField("unseen_message_count", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestUserAccessExpireTimeField () {
      return this.requestUserAccessExpireTimeField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestUserAccessExpireTimeField (boolean value) {
      this.requestField("user_access_expire_time", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestUsernameField () {
      return this.requestUsernameField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestUsernameField (boolean value) {
      this.requestField("username", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestVerificationStatusField () {
      return this.requestVerificationStatusField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestVerificationStatusField (boolean value) {
      this.requestField("verification_status", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestVoipInfoField () {
      return this.requestVoipInfoField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestVoipInfoField (boolean value) {
      this.requestField("voip_info", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestWebsiteField () {
      return this.requestWebsiteField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestWebsiteField (boolean value) {
      this.requestField("website", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestWereHereCountField () {
      return this.requestWereHereCountField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestWereHereCountField (boolean value) {
      this.requestField("were_here_count", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestWhatsappNumberField () {
      return this.requestWhatsappNumberField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestWhatsappNumberField (boolean value) {
      this.requestField("whatsapp_number", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestWrittenByField () {
      return this.requestWrittenByField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestWrittenByField (boolean value) {
      this.requestField("written_by", value);
      return this;
    }
  }

  public static class APIRequestGetCtxOptimizationEligibility extends APIRequest<CTXOptimizationEligibility> {

    APINodeList<CTXOptimizationEligibility> lastResponse = null;
    @Override
    public APINodeList<CTXOptimizationEligibility> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "ctm",
    };

    @Override
    public APINodeList<CTXOptimizationEligibility> parseResponse(String response, String header) throws APIException {
      return CTXOptimizationEligibility.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<CTXOptimizationEligibility> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<CTXOptimizationEligibility> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<CTXOptimizationEligibility>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<CTXOptimizationEligibility>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<CTXOptimizationEligibility>>() {
           public APINodeList<CTXOptimizationEligibility> apply(ResponseWrapper result) {
             try {
               return APIRequestGetCtxOptimizationEligibility.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetCtxOptimizationEligibility(String nodeId, APIContext context) {
      super(context, nodeId, "/ctx_optimization_eligibility", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetCtxOptimizationEligibility setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetCtxOptimizationEligibility setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetCtxOptimizationEligibility requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetCtxOptimizationEligibility requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCtxOptimizationEligibility requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetCtxOptimizationEligibility requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCtxOptimizationEligibility requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetCtxOptimizationEligibility requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetCtxOptimizationEligibility requestCtmField () {
      return this.requestCtmField(true);
    }
    public APIRequestGetCtxOptimizationEligibility requestCtmField (boolean value) {
      this.requestField("ctm", value);
      return this;
    }
  }

  public static class APIRequestGetCustomLabels extends APIRequest<PageUserMessageThreadLabel> {

    APINodeList<PageUserMessageThreadLabel> lastResponse = null;
    @Override
    public APINodeList<PageUserMessageThreadLabel> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "id",
      "page_label_name",
    };

    @Override
    public APINodeList<PageUserMessageThreadLabel> parseResponse(String response, String header) throws APIException {
      return PageUserMessageThreadLabel.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<PageUserMessageThreadLabel> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<PageUserMessageThreadLabel> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<PageUserMessageThreadLabel>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<PageUserMessageThreadLabel>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<PageUserMessageThreadLabel>>() {
           public APINodeList<PageUserMessageThreadLabel> apply(ResponseWrapper result) {
             try {
               return APIRequestGetCustomLabels.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetCustomLabels(String nodeId, APIContext context) {
      super(context, nodeId, "/custom_labels", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetCustomLabels setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetCustomLabels setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetCustomLabels requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetCustomLabels requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCustomLabels requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetCustomLabels requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCustomLabels requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetCustomLabels requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetCustomLabels requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetCustomLabels requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetCustomLabels requestPageLabelNameField () {
      return this.requestPageLabelNameField(true);
    }
    public APIRequestGetCustomLabels requestPageLabelNameField (boolean value) {
      this.requestField("page_label_name", value);
      return this;
    }
  }

  public static class APIRequestCreateCustomLabel extends APIRequest<PageUserMessageThreadLabel> {

    PageUserMessageThreadLabel lastResponse = null;
    @Override
    public PageUserMessageThreadLabel getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "name",
      "page_label_name",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public PageUserMessageThreadLabel parseResponse(String response, String header) throws APIException {
      return PageUserMessageThreadLabel.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public PageUserMessageThreadLabel execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public PageUserMessageThreadLabel execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<PageUserMessageThreadLabel> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<PageUserMessageThreadLabel> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, PageUserMessageThreadLabel>() {
           public PageUserMessageThreadLabel apply(ResponseWrapper result) {
             try {
               return APIRequestCreateCustomLabel.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateCustomLabel(String nodeId, APIContext context) {
      super(context, nodeId, "/custom_labels", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateCustomLabel setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateCustomLabel setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateCustomLabel setName (String name) {
      this.setParam("name", name);
      return this;
    }

    public APIRequestCreateCustomLabel setPageLabelName (String pageLabelName) {
      this.setParam("page_label_name", pageLabelName);
      return this;
    }

    public APIRequestCreateCustomLabel requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateCustomLabel requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateCustomLabel requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateCustomLabel requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateCustomLabel requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateCustomLabel requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestDeleteCustomUserSettings extends APIRequest<APINode> {

    APINodeList<APINode> lastResponse = null;
    @Override
    public APINodeList<APINode> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "params",
      "psid",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
      return APINode.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<APINode> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<APINode>>() {
           public APINodeList<APINode> apply(ResponseWrapper result) {
             try {
               return APIRequestDeleteCustomUserSettings.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestDeleteCustomUserSettings(String nodeId, APIContext context) {
      super(context, nodeId, "/custom_user_settings", "DELETE", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestDeleteCustomUserSettings setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestDeleteCustomUserSettings setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestDeleteCustomUserSettings setparamParams (List<EnumParams> params) {
      this.setParam("params", params);
      return this;
    }
    public APIRequestDeleteCustomUserSettings setParams (String params) {
      this.setParam("params", params);
      return this;
    }

    public APIRequestDeleteCustomUserSettings setPsid (String psid) {
      this.setParam("psid", psid);
      return this;
    }

    public APIRequestDeleteCustomUserSettings requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestDeleteCustomUserSettings requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteCustomUserSettings requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestDeleteCustomUserSettings requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteCustomUserSettings requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestDeleteCustomUserSettings requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetCustomUserSettings extends APIRequest<CustomUserSettings> {

    APINodeList<CustomUserSettings> lastResponse = null;
    @Override
    public APINodeList<CustomUserSettings> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "psid",
    };

    public static final String[] FIELDS = {
      "page_level_persistent_menu",
      "user_level_persistent_menu",
    };

    @Override
    public APINodeList<CustomUserSettings> parseResponse(String response, String header) throws APIException {
      return CustomUserSettings.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<CustomUserSettings> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<CustomUserSettings> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<CustomUserSettings>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<CustomUserSettings>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<CustomUserSettings>>() {
           public APINodeList<CustomUserSettings> apply(ResponseWrapper result) {
             try {
               return APIRequestGetCustomUserSettings.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetCustomUserSettings(String nodeId, APIContext context) {
      super(context, nodeId, "/custom_user_settings", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetCustomUserSettings setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetCustomUserSettings setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetCustomUserSettings setPsid (String psid) {
      this.setParam("psid", psid);
      return this;
    }

    public APIRequestGetCustomUserSettings requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetCustomUserSettings requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCustomUserSettings requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetCustomUserSettings requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCustomUserSettings requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetCustomUserSettings requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetCustomUserSettings requestPageLevelPersistentMenuField () {
      return this.requestPageLevelPersistentMenuField(true);
    }
    public APIRequestGetCustomUserSettings requestPageLevelPersistentMenuField (boolean value) {
      this.requestField("page_level_persistent_menu", value);
      return this;
    }
    public APIRequestGetCustomUserSettings requestUserLevelPersistentMenuField () {
      return this.requestUserLevelPersistentMenuField(true);
    }
    public APIRequestGetCustomUserSettings requestUserLevelPersistentMenuField (boolean value) {
      this.requestField("user_level_persistent_menu", value);
      return this;
    }
  }

  public static class APIRequestCreateCustomUserSetting extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "persistent_menu",
      "psid",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response, String header) throws APIException {
      return Page.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, Page>() {
           public Page apply(ResponseWrapper result) {
             try {
               return APIRequestCreateCustomUserSetting.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateCustomUserSetting(String nodeId, APIContext context) {
      super(context, nodeId, "/custom_user_settings", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateCustomUserSetting setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateCustomUserSetting setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateCustomUserSetting setPersistentMenu (List<Object> persistentMenu) {
      this.setParam("persistent_menu", persistentMenu);
      return this;
    }
    public APIRequestCreateCustomUserSetting setPersistentMenu (String persistentMenu) {
      this.setParam("persistent_menu", persistentMenu);
      return this;
    }

    public APIRequestCreateCustomUserSetting setPsid (String psid) {
      this.setParam("psid", psid);
      return this;
    }

    public APIRequestCreateCustomUserSetting requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateCustomUserSetting requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateCustomUserSetting requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateCustomUserSetting requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateCustomUserSetting requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateCustomUserSetting requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetDataset extends APIRequest<Dataset> {

    APINodeList<Dataset> lastResponse = null;
    @Override
    public APINodeList<Dataset> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "id",
      "name",
    };

    @Override
    public APINodeList<Dataset> parseResponse(String response, String header) throws APIException {
      return Dataset.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<Dataset> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Dataset> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Dataset>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Dataset>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<Dataset>>() {
           public APINodeList<Dataset> apply(ResponseWrapper result) {
             try {
               return APIRequestGetDataset.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetDataset(String nodeId, APIContext context) {
      super(context, nodeId, "/dataset", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetDataset setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetDataset setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetDataset requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetDataset requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetDataset requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetDataset requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetDataset requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetDataset requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetDataset requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetDataset requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetDataset requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetDataset requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
  }

  public static class APIRequestCreateDataset extends APIRequest<Dataset> {

    Dataset lastResponse = null;
    @Override
    public Dataset getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "dataset_name",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Dataset parseResponse(String response, String header) throws APIException {
      return Dataset.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public Dataset execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Dataset execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<Dataset> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Dataset> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, Dataset>() {
           public Dataset apply(ResponseWrapper result) {
             try {
               return APIRequestCreateDataset.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateDataset(String nodeId, APIContext context) {
      super(context, nodeId, "/dataset", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateDataset setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateDataset setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateDataset setDatasetName (String datasetName) {
      this.setParam("dataset_name", datasetName);
      return this;
    }

    public APIRequestCreateDataset requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateDataset requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateDataset requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateDataset requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateDataset requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateDataset requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetEvents extends APIRequest<Event> {

    APINodeList<Event> lastResponse = null;
    @Override
    public APINodeList<Event> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "event_state_filter",
      "include_canceled",
      "time_filter",
      "type",
    };

    public static final String[] FIELDS = {
      "attending_count",
      "can_guests_invite",
      "category",
      "cover",
      "created_time",
      "declined_count",
      "description",
      "discount_code_enabled",
      "end_time",
      "event_times",
      "guest_list_enabled",
      "id",
      "interested_count",
      "is_canceled",
      "is_draft",
      "is_online",
      "is_page_owned",
      "maybe_count",
      "name",
      "noreply_count",
      "online_event_format",
      "online_event_third_party_url",
      "owner",
      "parent_group",
      "place",
      "registration_setting",
      "scheduled_publish_time",
      "start_time",
      "ticket_setting",
      "ticket_uri",
      "ticket_uri_start_sales_time",
      "ticketing_privacy_uri",
      "ticketing_terms_uri",
      "timezone",
      "type",
      "updated_time",
    };

    @Override
    public APINodeList<Event> parseResponse(String response, String header) throws APIException {
      return Event.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<Event> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Event> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Event>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Event>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<Event>>() {
           public APINodeList<Event> apply(ResponseWrapper result) {
             try {
               return APIRequestGetEvents.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetEvents(String nodeId, APIContext context) {
      super(context, nodeId, "/events", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetEvents setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetEvents setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetEvents setEventStateFilter (List<Event.EnumEventStateFilter> eventStateFilter) {
      this.setParam("event_state_filter", eventStateFilter);
      return this;
    }
    public APIRequestGetEvents setEventStateFilter (String eventStateFilter) {
      this.setParam("event_state_filter", eventStateFilter);
      return this;
    }

    public APIRequestGetEvents setIncludeCanceled (Boolean includeCanceled) {
      this.setParam("include_canceled", includeCanceled);
      return this;
    }
    public APIRequestGetEvents setIncludeCanceled (String includeCanceled) {
      this.setParam("include_canceled", includeCanceled);
      return this;
    }

    public APIRequestGetEvents setTimeFilter (Event.EnumTimeFilter timeFilter) {
      this.setParam("time_filter", timeFilter);
      return this;
    }
    public APIRequestGetEvents setTimeFilter (String timeFilter) {
      this.setParam("time_filter", timeFilter);
      return this;
    }

    public APIRequestGetEvents setType (Event.EnumType type) {
      this.setParam("type", type);
      return this;
    }
    public APIRequestGetEvents setType (String type) {
      this.setParam("type", type);
      return this;
    }

    public APIRequestGetEvents requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetEvents requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetEvents requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetEvents requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetEvents requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetEvents requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetEvents requestAttendingCountField () {
      return this.requestAttendingCountField(true);
    }
    public APIRequestGetEvents requestAttendingCountField (boolean value) {
      this.requestField("attending_count", value);
      return this;
    }
    public APIRequestGetEvents requestCanGuestsInviteField () {
      return this.requestCanGuestsInviteField(true);
    }
    public APIRequestGetEvents requestCanGuestsInviteField (boolean value) {
      this.requestField("can_guests_invite", value);
      return this;
    }
    public APIRequestGetEvents requestCategoryField () {
      return this.requestCategoryField(true);
    }
    public APIRequestGetEvents requestCategoryField (boolean value) {
      this.requestField("category", value);
      return this;
    }
    public APIRequestGetEvents requestCoverField () {
      return this.requestCoverField(true);
    }
    public APIRequestGetEvents requestCoverField (boolean value) {
      this.requestField("cover", value);
      return this;
    }
    public APIRequestGetEvents requestCreatedTimeField () {
      return this.requestCreatedTimeField(true);
    }
    public APIRequestGetEvents requestCreatedTimeField (boolean value) {
      this.requestField("created_time", value);
      return this;
    }
    public APIRequestGetEvents requestDeclinedCountField () {
      return this.requestDeclinedCountField(true);
    }
    public APIRequestGetEvents requestDeclinedCountField (boolean value) {
      this.requestField("declined_count", value);
      return this;
    }
    public APIRequestGetEvents requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetEvents requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetEvents requestDiscountCodeEnabledField () {
      return this.requestDiscountCodeEnabledField(true);
    }
    public APIRequestGetEvents requestDiscountCodeEnabledField (boolean value) {
      this.requestField("discount_code_enabled", value);
      return this;
    }
    public APIRequestGetEvents requestEndTimeField () {
      return this.requestEndTimeField(true);
    }
    public APIRequestGetEvents requestEndTimeField (boolean value) {
      this.requestField("end_time", value);
      return this;
    }
    public APIRequestGetEvents requestEventTimesField () {
      return this.requestEventTimesField(true);
    }
    public APIRequestGetEvents requestEventTimesField (boolean value) {
      this.requestField("event_times", value);
      return this;
    }
    public APIRequestGetEvents requestGuestListEnabledField () {
      return this.requestGuestListEnabledField(true);
    }
    public APIRequestGetEvents requestGuestListEnabledField (boolean value) {
      this.requestField("guest_list_enabled", value);
      return this;
    }
    public APIRequestGetEvents requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetEvents requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetEvents requestInterestedCountField () {
      return this.requestInterestedCountField(true);
    }
    public APIRequestGetEvents requestInterestedCountField (boolean value) {
      this.requestField("interested_count", value);
      return this;
    }
    public APIRequestGetEvents requestIsCanceledField () {
      return this.requestIsCanceledField(true);
    }
    public APIRequestGetEvents requestIsCanceledField (boolean value) {
      this.requestField("is_canceled", value);
      return this;
    }
    public APIRequestGetEvents requestIsDraftField () {
      return this.requestIsDraftField(true);
    }
    public APIRequestGetEvents requestIsDraftField (boolean value) {
      this.requestField("is_draft", value);
      return this;
    }
    public APIRequestGetEvents requestIsOnlineField () {
      return this.requestIsOnlineField(true);
    }
    public APIRequestGetEvents requestIsOnlineField (boolean value) {
      this.requestField("is_online", value);
      return this;
    }
    public APIRequestGetEvents requestIsPageOwnedField () {
      return this.requestIsPageOwnedField(true);
    }
    public APIRequestGetEvents requestIsPageOwnedField (boolean value) {
      this.requestField("is_page_owned", value);
      return this;
    }
    public APIRequestGetEvents requestMaybeCountField () {
      return this.requestMaybeCountField(true);
    }
    public APIRequestGetEvents requestMaybeCountField (boolean value) {
      this.requestField("maybe_count", value);
      return this;
    }
    public APIRequestGetEvents requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetEvents requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetEvents requestNoreplyCountField () {
      return this.requestNoreplyCountField(true);
    }
    public APIRequestGetEvents requestNoreplyCountField (boolean value) {
      this.requestField("noreply_count", value);
      return this;
    }
    public APIRequestGetEvents requestOnlineEventFormatField () {
      return this.requestOnlineEventFormatField(true);
    }
    public APIRequestGetEvents requestOnlineEventFormatField (boolean value) {
      this.requestField("online_event_format", value);
      return this;
    }
    public APIRequestGetEvents requestOnlineEventThirdPartyUrlField () {
      return this.requestOnlineEventThirdPartyUrlField(true);
    }
    public APIRequestGetEvents requestOnlineEventThirdPartyUrlField (boolean value) {
      this.requestField("online_event_third_party_url", value);
      return this;
    }
    public APIRequestGetEvents requestOwnerField () {
      return this.requestOwnerField(true);
    }
    public APIRequestGetEvents requestOwnerField (boolean value) {
      this.requestField("owner", value);
      return this;
    }
    public APIRequestGetEvents requestParentGroupField () {
      return this.requestParentGroupField(true);
    }
    public APIRequestGetEvents requestParentGroupField (boolean value) {
      this.requestField("parent_group", value);
      return this;
    }
    public APIRequestGetEvents requestPlaceField () {
      return this.requestPlaceField(true);
    }
    public APIRequestGetEvents requestPlaceField (boolean value) {
      this.requestField("place", value);
      return this;
    }
    public APIRequestGetEvents requestRegistrationSettingField () {
      return this.requestRegistrationSettingField(true);
    }
    public APIRequestGetEvents requestRegistrationSettingField (boolean value) {
      this.requestField("registration_setting", value);
      return this;
    }
    public APIRequestGetEvents requestScheduledPublishTimeField () {
      return this.requestScheduledPublishTimeField(true);
    }
    public APIRequestGetEvents requestScheduledPublishTimeField (boolean value) {
      this.requestField("scheduled_publish_time", value);
      return this;
    }
    public APIRequestGetEvents requestStartTimeField () {
      return this.requestStartTimeField(true);
    }
    public APIRequestGetEvents requestStartTimeField (boolean value) {
      this.requestField("start_time", value);
      return this;
    }
    public APIRequestGetEvents requestTicketSettingField () {
      return this.requestTicketSettingField(true);
    }
    public APIRequestGetEvents requestTicketSettingField (boolean value) {
      this.requestField("ticket_setting", value);
      return this;
    }
    public APIRequestGetEvents requestTicketUriField () {
      return this.requestTicketUriField(true);
    }
    public APIRequestGetEvents requestTicketUriField (boolean value) {
      this.requestField("ticket_uri", value);
      return this;
    }
    public APIRequestGetEvents requestTicketUriStartSalesTimeField () {
      return this.requestTicketUriStartSalesTimeField(true);
    }
    public APIRequestGetEvents requestTicketUriStartSalesTimeField (boolean value) {
      this.requestField("ticket_uri_start_sales_time", value);
      return this;
    }
    public APIRequestGetEvents requestTicketingPrivacyUriField () {
      return this.requestTicketingPrivacyUriField(true);
    }
    public APIRequestGetEvents requestTicketingPrivacyUriField (boolean value) {
      this.requestField("ticketing_privacy_uri", value);
      return this;
    }
    public APIRequestGetEvents requestTicketingTermsUriField () {
      return this.requestTicketingTermsUriField(true);
    }
    public APIRequestGetEvents requestTicketingTermsUriField (boolean value) {
      this.requestField("ticketing_terms_uri", value);
      return this;
    }
    public APIRequestGetEvents requestTimezoneField () {
      return this.requestTimezoneField(true);
    }
    public APIRequestGetEvents requestTimezoneField (boolean value) {
      this.requestField("timezone", value);
      return this;
    }
    public APIRequestGetEvents requestTypeField () {
      return this.requestTypeField(true);
    }
    public APIRequestGetEvents requestTypeField (boolean value) {
      this.requestField("type", value);
      return this;
    }
    public APIRequestGetEvents requestUpdatedTimeField () {
      return this.requestUpdatedTimeField(true);
    }
    public APIRequestGetEvents requestUpdatedTimeField (boolean value) {
      this.requestField("updated_time", value);
      return this;
    }
  }

  public static class APIRequestCreateExtendThreadControl extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "duration",
      "recipient",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response, String header) throws APIException {
      return Page.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, Page>() {
           public Page apply(ResponseWrapper result) {
             try {
               return APIRequestCreateExtendThreadControl.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateExtendThreadControl(String nodeId, APIContext context) {
      super(context, nodeId, "/extend_thread_control", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateExtendThreadControl setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateExtendThreadControl setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateExtendThreadControl setDuration (Long duration) {
      this.setParam("duration", duration);
      return this;
    }
    public APIRequestCreateExtendThreadControl setDuration (String duration) {
      this.setParam("duration", duration);
      return this;
    }

    public APIRequestCreateExtendThreadControl setRecipient (Object recipient) {
      this.setParam("recipient", recipient);
      return this;
    }
    public APIRequestCreateExtendThreadControl setRecipient (String recipient) {
      this.setParam("recipient", recipient);
      return this;
    }

    public APIRequestCreateExtendThreadControl requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateExtendThreadControl requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateExtendThreadControl requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateExtendThreadControl requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateExtendThreadControl requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateExtendThreadControl requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetFantasyGames extends APIRequest<FantasyGame> {

    APINodeList<FantasyGame> lastResponse = null;
    @Override
    public APINodeList<FantasyGame> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "id",
      "name",
    };

    @Override
    public APINodeList<FantasyGame> parseResponse(String response, String header) throws APIException {
      return FantasyGame.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<FantasyGame> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<FantasyGame> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<FantasyGame>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<FantasyGame>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<FantasyGame>>() {
           public APINodeList<FantasyGame> apply(ResponseWrapper result) {
             try {
               return APIRequestGetFantasyGames.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetFantasyGames(String nodeId, APIContext context) {
      super(context, nodeId, "/fantasy_games", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetFantasyGames setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetFantasyGames setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetFantasyGames requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetFantasyGames requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetFantasyGames requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetFantasyGames requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetFantasyGames requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetFantasyGames requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetFantasyGames requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetFantasyGames requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetFantasyGames requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetFantasyGames requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
  }

  public static class APIRequestGetFeed extends APIRequest<PagePost> {

    APINodeList<PagePost> lastResponse = null;
    @Override
    public APINodeList<PagePost> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "include_hidden",
      "limit",
      "show_expired",
      "with",
    };

    public static final String[] FIELDS = {
      "actions",
      "admin_creator",
      "allowed_advertising_objectives",
      "application",
      "backdated_time",
      "call_to_action",
      "can_reply_privately",
      "child_attachments",
      "comments_mirroring_domain",
      "coordinates",
      "created_time",
      "event",
      "expanded_height",
      "expanded_width",
      "feed_targeting",
      "from",
      "full_picture",
      "height",
      "icon",
      "id",
      "instagram_eligibility",
      "is_app_share",
      "is_eligible_for_promotion",
      "is_expired",
      "is_hidden",
      "is_inline_created",
      "is_instagram_eligible",
      "is_popular",
      "is_published",
      "is_spherical",
      "message",
      "message_tags",
      "multi_share_end_card",
      "multi_share_optimized",
      "parent_id",
      "permalink_url",
      "picture",
      "place",
      "privacy",
      "promotable_id",
      "promotion_status",
      "properties",
      "scheduled_publish_time",
      "shares",
      "status_type",
      "story",
      "story_tags",
      "subscribed",
      "target",
      "targeting",
      "timeline_visibility",
      "updated_time",
      "via",
      "video_buying_eligibility",
      "width",
    };

    @Override
    public APINodeList<PagePost> parseResponse(String response, String header) throws APIException {
      return PagePost.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<PagePost> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<PagePost> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<PagePost>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<PagePost>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<PagePost>>() {
           public APINodeList<PagePost> apply(ResponseWrapper result) {
             try {
               return APIRequestGetFeed.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetFeed(String nodeId, APIContext context) {
      super(context, nodeId, "/feed", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetFeed setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetFeed setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetFeed setIncludeHidden (Boolean includeHidden) {
      this.setParam("include_hidden", includeHidden);
      return this;
    }
    public APIRequestGetFeed setIncludeHidden (String includeHidden) {
      this.setParam("include_hidden", includeHidden);
      return this;
    }

    public APIRequestGetFeed setLimit (Long limit) {
      this.setParam("limit", limit);
      return this;
    }
    public APIRequestGetFeed setLimit (String limit) {
      this.setParam("limit", limit);
      return this;
    }

    public APIRequestGetFeed setShowExpired (Boolean showExpired) {
      this.setParam("show_expired", showExpired);
      return this;
    }
    public APIRequestGetFeed setShowExpired (String showExpired) {
      this.setParam("show_expired", showExpired);
      return this;
    }

    public APIRequestGetFeed setWith (PagePost.EnumWith with) {
      this.setParam("with", with);
      return this;
    }
    public APIRequestGetFeed setWith (String with) {
      this.setParam("with", with);
      return this;
    }

    public APIRequestGetFeed requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetFeed requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetFeed requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetFeed requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetFeed requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetFeed requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetFeed requestActionsField () {
      return this.requestActionsField(true);
    }
    public APIRequestGetFeed requestActionsField (boolean value) {
      this.requestField("actions", value);
      return this;
    }
    public APIRequestGetFeed requestAdminCreatorField () {
      return this.requestAdminCreatorField(true);
    }
    public APIRequestGetFeed requestAdminCreatorField (boolean value) {
      this.requestField("admin_creator", value);
      return this;
    }
    public APIRequestGetFeed requestAllowedAdvertisingObjectivesField () {
      return this.requestAllowedAdvertisingObjectivesField(true);
    }
    public APIRequestGetFeed requestAllowedAdvertisingObjectivesField (boolean value) {
      this.requestField("allowed_advertising_objectives", value);
      return this;
    }
    public APIRequestGetFeed requestApplicationField () {
      return this.requestApplicationField(true);
    }
    public APIRequestGetFeed requestApplicationField (boolean value) {
      this.requestField("application", value);
      return this;
    }
    public APIRequestGetFeed requestBackdatedTimeField () {
      return this.requestBackdatedTimeField(true);
    }
    public APIRequestGetFeed requestBackdatedTimeField (boolean value) {
      this.requestField("backdated_time", value);
      return this;
    }
    public APIRequestGetFeed requestCallToActionField () {
      return this.requestCallToActionField(true);
    }
    public APIRequestGetFeed requestCallToActionField (boolean value) {
      this.requestField("call_to_action", value);
      return this;
    }
    public APIRequestGetFeed requestCanReplyPrivatelyField () {
      return this.requestCanReplyPrivatelyField(true);
    }
    public APIRequestGetFeed requestCanReplyPrivatelyField (boolean value) {
      this.requestField("can_reply_privately", value);
      return this;
    }
    public APIRequestGetFeed requestChildAttachmentsField () {
      return this.requestChildAttachmentsField(true);
    }
    public APIRequestGetFeed requestChildAttachmentsField (boolean value) {
      this.requestField("child_attachments", value);
      return this;
    }
    public APIRequestGetFeed requestCommentsMirroringDomainField () {
      return this.requestCommentsMirroringDomainField(true);
    }
    public APIRequestGetFeed requestCommentsMirroringDomainField (boolean value) {
      this.requestField("comments_mirroring_domain", value);
      return this;
    }
    public APIRequestGetFeed requestCoordinatesField () {
      return this.requestCoordinatesField(true);
    }
    public APIRequestGetFeed requestCoordinatesField (boolean value) {
      this.requestField("coordinates", value);
      return this;
    }
    public APIRequestGetFeed requestCreatedTimeField () {
      return this.requestCreatedTimeField(true);
    }
    public APIRequestGetFeed requestCreatedTimeField (boolean value) {
      this.requestField("created_time", value);
      return this;
    }
    public APIRequestGetFeed requestEventField () {
      return this.requestEventField(true);
    }
    public APIRequestGetFeed requestEventField (boolean value) {
      this.requestField("event", value);
      return this;
    }
    public APIRequestGetFeed requestExpandedHeightField () {
      return this.requestExpandedHeightField(true);
    }
    public APIRequestGetFeed requestExpandedHeightField (boolean value) {
      this.requestField("expanded_height", value);
      return this;
    }
    public APIRequestGetFeed requestExpandedWidthField () {
      return this.requestExpandedWidthField(true);
    }
    public APIRequestGetFeed requestExpandedWidthField (boolean value) {
      this.requestField("expanded_width", value);
      return this;
    }
    public APIRequestGetFeed requestFeedTargetingField () {
      return this.requestFeedTargetingField(true);
    }
    public APIRequestGetFeed requestFeedTargetingField (boolean value) {
      this.requestField("feed_targeting", value);
      return this;
    }
    public APIRequestGetFeed requestFromField () {
      return this.requestFromField(true);
    }
    public APIRequestGetFeed requestFromField (boolean value) {
      this.requestField("from", value);
      return this;
    }
    public APIRequestGetFeed requestFullPictureField () {
      return this.requestFullPictureField(true);
    }
    public APIRequestGetFeed requestFullPictureField (boolean value) {
      this.requestField("full_picture", value);
      return this;
    }
    public APIRequestGetFeed requestHeightField () {
      return this.requestHeightField(true);
    }
    public APIRequestGetFeed requestHeightField (boolean value) {
      this.requestField("height", value);
      return this;
    }
    public APIRequestGetFeed requestIconField () {
      return this.requestIconField(true);
    }
    public APIRequestGetFeed requestIconField (boolean value) {
      this.requestField("icon", value);
      return this;
    }
    public APIRequestGetFeed requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetFeed requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetFeed requestInstagramEligibilityField () {
      return this.requestInstagramEligibilityField(true);
    }
    public APIRequestGetFeed requestInstagramEligibilityField (boolean value) {
      this.requestField("instagram_eligibility", value);
      return this;
    }
    public APIRequestGetFeed requestIsAppShareField () {
      return this.requestIsAppShareField(true);
    }
    public APIRequestGetFeed requestIsAppShareField (boolean value) {
      this.requestField("is_app_share", value);
      return this;
    }
    public APIRequestGetFeed requestIsEligibleForPromotionField () {
      return this.requestIsEligibleForPromotionField(true);
    }
    public APIRequestGetFeed requestIsEligibleForPromotionField (boolean value) {
      this.requestField("is_eligible_for_promotion", value);
      return this;
    }
    public APIRequestGetFeed requestIsExpiredField () {
      return this.requestIsExpiredField(true);
    }
    public APIRequestGetFeed requestIsExpiredField (boolean value) {
      this.requestField("is_expired", value);
      return this;
    }
    public APIRequestGetFeed requestIsHiddenField () {
      return this.requestIsHiddenField(true);
    }
    public APIRequestGetFeed requestIsHiddenField (boolean value) {
      this.requestField("is_hidden", value);
      return this;
    }
    public APIRequestGetFeed requestIsInlineCreatedField () {
      return this.requestIsInlineCreatedField(true);
    }
    public APIRequestGetFeed requestIsInlineCreatedField (boolean value) {
      this.requestField("is_inline_created", value);
      return this;
    }
    public APIRequestGetFeed requestIsInstagramEligibleField () {
      return this.requestIsInstagramEligibleField(true);
    }
    public APIRequestGetFeed requestIsInstagramEligibleField (boolean value) {
      this.requestField("is_instagram_eligible", value);
      return this;
    }
    public APIRequestGetFeed requestIsPopularField () {
      return this.requestIsPopularField(true);
    }
    public APIRequestGetFeed requestIsPopularField (boolean value) {
      this.requestField("is_popular", value);
      return this;
    }
    public APIRequestGetFeed requestIsPublishedField () {
      return this.requestIsPublishedField(true);
    }
    public APIRequestGetFeed requestIsPublishedField (boolean value) {
      this.requestField("is_published", value);
      return this;
    }
    public APIRequestGetFeed requestIsSphericalField () {
      return this.requestIsSphericalField(true);
    }
    public APIRequestGetFeed requestIsSphericalField (boolean value) {
      this.requestField("is_spherical", value);
      return this;
    }
    public APIRequestGetFeed requestMessageField () {
      return this.requestMessageField(true);
    }
    public APIRequestGetFeed requestMessageField (boolean value) {
      this.requestField("message", value);
      return this;
    }
    public APIRequestGetFeed requestMessageTagsField () {
      return this.requestMessageTagsField(true);
    }
    public APIRequestGetFeed requestMessageTagsField (boolean value) {
      this.requestField("message_tags", value);
      return this;
    }
    public APIRequestGetFeed requestMultiShareEndCardField () {
      return this.requestMultiShareEndCardField(true);
    }
    public APIRequestGetFeed requestMultiShareEndCardField (boolean value) {
      this.requestField("multi_share_end_card", value);
      return this;
    }
    public APIRequestGetFeed requestMultiShareOptimizedField () {
      return this.requestMultiShareOptimizedField(true);
    }
    public APIRequestGetFeed requestMultiShareOptimizedField (boolean value) {
      this.requestField("multi_share_optimized", value);
      return this;
    }
    public APIRequestGetFeed requestParentIdField () {
      return this.requestParentIdField(true);
    }
    public APIRequestGetFeed requestParentIdField (boolean value) {
      this.requestField("parent_id", value);
      return this;
    }
    public APIRequestGetFeed requestPermalinkUrlField () {
      return this.requestPermalinkUrlField(true);
    }
    public APIRequestGetFeed requestPermalinkUrlField (boolean value) {
      this.requestField("permalink_url", value);
      return this;
    }
    public APIRequestGetFeed requestPictureField () {
      return this.requestPictureField(true);
    }
    public APIRequestGetFeed requestPictureField (boolean value) {
      this.requestField("picture", value);
      return this;
    }
    public APIRequestGetFeed requestPlaceField () {
      return this.requestPlaceField(true);
    }
    public APIRequestGetFeed requestPlaceField (boolean value) {
      this.requestField("place", value);
      return this;
    }
    public APIRequestGetFeed requestPrivacyField () {
      return this.requestPrivacyField(true);
    }
    public APIRequestGetFeed requestPrivacyField (boolean value) {
      this.requestField("privacy", value);
      return this;
    }
    public APIRequestGetFeed requestPromotableIdField () {
      return this.requestPromotableIdField(true);
    }
    public APIRequestGetFeed requestPromotableIdField (boolean value) {
      this.requestField("promotable_id", value);
      return this;
    }
    public APIRequestGetFeed requestPromotionStatusField () {
      return this.requestPromotionStatusField(true);
    }
    public APIRequestGetFeed requestPromotionStatusField (boolean value) {
      this.requestField("promotion_status", value);
      return this;
    }
    public APIRequestGetFeed requestPropertiesField () {
      return this.requestPropertiesField(true);
    }
    public APIRequestGetFeed requestPropertiesField (boolean value) {
      this.requestField("properties", value);
      return this;
    }
    public APIRequestGetFeed requestScheduledPublishTimeField () {
      return this.requestScheduledPublishTimeField(true);
    }
    public APIRequestGetFeed requestScheduledPublishTimeField (boolean value) {
      this.requestField("scheduled_publish_time", value);
      return this;
    }
    public APIRequestGetFeed requestSharesField () {
      return this.requestSharesField(true);
    }
    public APIRequestGetFeed requestSharesField (boolean value) {
      this.requestField("shares", value);
      return this;
    }
    public APIRequestGetFeed requestStatusTypeField () {
      return this.requestStatusTypeField(true);
    }
    public APIRequestGetFeed requestStatusTypeField (boolean value) {
      this.requestField("status_type", value);
      return this;
    }
    public APIRequestGetFeed requestStoryField () {
      return this.requestStoryField(true);
    }
    public APIRequestGetFeed requestStoryField (boolean value) {
      this.requestField("story", value);
      return this;
    }
    public APIRequestGetFeed requestStoryTagsField () {
      return this.requestStoryTagsField(true);
    }
    public APIRequestGetFeed requestStoryTagsField (boolean value) {
      this.requestField("story_tags", value);
      return this;
    }
    public APIRequestGetFeed requestSubscribedField () {
      return this.requestSubscribedField(true);
    }
    public APIRequestGetFeed requestSubscribedField (boolean value) {
      this.requestField("subscribed", value);
      return this;
    }
    public APIRequestGetFeed requestTargetField () {
      return this.requestTargetField(true);
    }
    public APIRequestGetFeed requestTargetField (boolean value) {
      this.requestField("target", value);
      return this;
    }
    public APIRequestGetFeed requestTargetingField () {
      return this.requestTargetingField(true);
    }
    public APIRequestGetFeed requestTargetingField (boolean value) {
      this.requestField("targeting", value);
      return this;
    }
    public APIRequestGetFeed requestTimelineVisibilityField () {
      return this.requestTimelineVisibilityField(true);
    }
    public APIRequestGetFeed requestTimelineVisibilityField (boolean value) {
      this.requestField("timeline_visibility", value);
      return this;
    }
    public APIRequestGetFeed requestUpdatedTimeField () {
      return this.requestUpdatedTimeField(true);
    }
    public APIRequestGetFeed requestUpdatedTimeField (boolean value) {
      this.requestField("updated_time", value);
      return this;
    }
    public APIRequestGetFeed requestViaField () {
      return this.requestViaField(true);
    }
    public APIRequestGetFeed requestViaField (boolean value) {
      this.requestField("via", value);
      return this;
    }
    public APIRequestGetFeed requestVideoBuyingEligibilityField () {
      return this.requestVideoBuyingEligibilityField(true);
    }
    public APIRequestGetFeed requestVideoBuyingEligibilityField (boolean value) {
      this.requestField("video_buying_eligibility", value);
      return this;
    }
    public APIRequestGetFeed requestWidthField () {
      return this.requestWidthField(true);
    }
    public APIRequestGetFeed requestWidthField (boolean value) {
      this.requestField("width", value);
      return this;
    }
  }

  public static class APIRequestCreateFeed extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "actions",
      "album_id",
      "android_key_hash",
      "application_id",
      "asked_fun_fact_prompt_id",
      "asset3d_id",
      "associated_id",
      "attach_place_suggestion",
      "attached_media",
      "audience_exp",
      "backdated_time",
      "backdated_time_granularity",
      "breaking_news",
      "breaking_news_expiration",
      "call_to_action",
      "caption",
      "child_attachments",
      "client_mutation_id",
      "composer_entry_picker",
      "composer_entry_point",
      "composer_entry_time",
      "composer_session_events_log",
      "composer_session_id",
      "composer_source_surface",
      "composer_type",
      "connection_class",
      "content_attachment",
      "coordinates",
      "cta_link",
      "cta_type",
      "description",
      "direct_share_status",
      "enforce_link_ownership",
      "expanded_height",
      "expanded_width",
      "feed_targeting",
      "formatting",
      "fun_fact_prompt_id",
      "fun_fact_toastee_id",
      "height",
      "home_checkin_city_id",
      "image_crops",
      "implicit_with_tags",
      "instant_game_entry_point_data",
      "ios_bundle_id",
      "is_backout_draft",
      "is_boost_intended",
      "is_explicit_location",
      "is_explicit_share",
      "is_group_linking_post",
      "is_photo_container",
      "link",
      "location_source_id",
      "manual_privacy",
      "message",
      "multi_share_end_card",
      "multi_share_optimized",
      "name",
      "nectar_module",
      "object_attachment",
      "og_action_type_id",
      "og_hide_object_attachment",
      "og_icon_id",
      "og_object_id",
      "og_phrase",
      "og_set_profile_badge",
      "og_suggestion_mechanism",
      "page_recommendation",
      "picture",
      "place",
      "place_attachment_setting",
      "place_list",
      "place_list_data",
      "post_surfaces_blacklist",
      "posting_to_redspace",
      "privacy",
      "prompt_id",
      "prompt_tracking_string",
      "properties",
      "proxied_app_id",
      "publish_event_id",
      "published",
      "quote",
      "ref",
      "referenceable_image_ids",
      "referral_id",
      "scheduled_publish_time",
      "source",
      "sponsor_id",
      "sponsor_relationship",
      "suggested_place_id",
      "tags",
      "target_surface",
      "targeting",
      "text_format_metadata",
      "text_format_preset_id",
      "text_only_place",
      "thumbnail",
      "time_since_original_post",
      "title",
      "tracking_info",
      "unpublished_content_type",
      "user_selected_tags",
      "video_start_time_ms",
      "viewer_coordinates",
      "width",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response, String header) throws APIException {
      return Page.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, Page>() {
           public Page apply(ResponseWrapper result) {
             try {
               return APIRequestCreateFeed.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateFeed(String nodeId, APIContext context) {
      super(context, nodeId, "/feed", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateFeed setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateFeed setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateFeed setActions (Object actions) {
      this.setParam("actions", actions);
      return this;
    }
    public APIRequestCreateFeed setActions (String actions) {
      this.setParam("actions", actions);
      return this;
    }

    public APIRequestCreateFeed setAlbumId (String albumId) {
      this.setParam("album_id", albumId);
      return this;
    }

    public APIRequestCreateFeed setAndroidKeyHash (String androidKeyHash) {
      this.setParam("android_key_hash", androidKeyHash);
      return this;
    }

    public APIRequestCreateFeed setApplicationId (String applicationId) {
      this.setParam("application_id", applicationId);
      return this;
    }

    public APIRequestCreateFeed setAskedFunFactPromptId (Long askedFunFactPromptId) {
      this.setParam("asked_fun_fact_prompt_id", askedFunFactPromptId);
      return this;
    }
    public APIRequestCreateFeed setAskedFunFactPromptId (String askedFunFactPromptId) {
      this.setParam("asked_fun_fact_prompt_id", askedFunFactPromptId);
      return this;
    }

    public APIRequestCreateFeed setAsset3dId (String asset3dId) {
      this.setParam("asset3d_id", asset3dId);
      return this;
    }

    public APIRequestCreateFeed setAssociatedId (String associatedId) {
      this.setParam("associated_id", associatedId);
      return this;
    }

    public APIRequestCreateFeed setAttachPlaceSuggestion (Boolean attachPlaceSuggestion) {
      this.setParam("attach_place_suggestion", attachPlaceSuggestion);
      return this;
    }
    public APIRequestCreateFeed setAttachPlaceSuggestion (String attachPlaceSuggestion) {
      this.setParam("attach_place_suggestion", attachPlaceSuggestion);
      return this;
    }

    public APIRequestCreateFeed setAttachedMedia (List<Object> attachedMedia) {
      this.setParam("attached_media", attachedMedia);
      return this;
    }
    public APIRequestCreateFeed setAttachedMedia (String attachedMedia) {
      this.setParam("attached_media", attachedMedia);
      return this;
    }

    public APIRequestCreateFeed setAudienceExp (Boolean audienceExp) {
      this.setParam("audience_exp", audienceExp);
      return this;
    }
    public APIRequestCreateFeed setAudienceExp (String audienceExp) {
      this.setParam("audience_exp", audienceExp);
      return this;
    }

    public APIRequestCreateFeed setBackdatedTime (String backdatedTime) {
      this.setParam("backdated_time", backdatedTime);
      return this;
    }

    public APIRequestCreateFeed setBackdatedTimeGranularity (Page.EnumBackdatedTimeGranularity backdatedTimeGranularity) {
      this.setParam("backdated_time_granularity", backdatedTimeGranularity);
      return this;
    }
    public APIRequestCreateFeed setBackdatedTimeGranularity (String backdatedTimeGranularity) {
      this.setParam("backdated_time_granularity", backdatedTimeGranularity);
      return this;
    }

    public APIRequestCreateFeed setBreakingNews (Boolean breakingNews) {
      this.setParam("breaking_news", breakingNews);
      return this;
    }
    public APIRequestCreateFeed setBreakingNews (String breakingNews) {
      this.setParam("breaking_news", breakingNews);
      return this;
    }

    public APIRequestCreateFeed setBreakingNewsExpiration (Long breakingNewsExpiration) {
      this.setParam("breaking_news_expiration", breakingNewsExpiration);
      return this;
    }
    public APIRequestCreateFeed setBreakingNewsExpiration (String breakingNewsExpiration) {
      this.setParam("breaking_news_expiration", breakingNewsExpiration);
      return this;
    }

    public APIRequestCreateFeed setCallToAction (Object callToAction) {
      this.setParam("call_to_action", callToAction);
      return this;
    }
    public APIRequestCreateFeed setCallToAction (String callToAction) {
      this.setParam("call_to_action", callToAction);
      return this;
    }

    public APIRequestCreateFeed setCaption (String caption) {
      this.setParam("caption", caption);
      return this;
    }

    public APIRequestCreateFeed setChildAttachments (List<Object> childAttachments) {
      this.setParam("child_attachments", childAttachments);
      return this;
    }
    public APIRequestCreateFeed setChildAttachments (String childAttachments) {
      this.setParam("child_attachments", childAttachments);
      return this;
    }

    public APIRequestCreateFeed setClientMutationId (String clientMutationId) {
      this.setParam("client_mutation_id", clientMutationId);
      return this;
    }

    public APIRequestCreateFeed setComposerEntryPicker (String composerEntryPicker) {
      this.setParam("composer_entry_picker", composerEntryPicker);
      return this;
    }

    public APIRequestCreateFeed setComposerEntryPoint (String composerEntryPoint) {
      this.setParam("composer_entry_point", composerEntryPoint);
      return this;
    }

    public APIRequestCreateFeed setComposerEntryTime (Long composerEntryTime) {
      this.setParam("composer_entry_time", composerEntryTime);
      return this;
    }
    public APIRequestCreateFeed setComposerEntryTime (String composerEntryTime) {
      this.setParam("composer_entry_time", composerEntryTime);
      return this;
    }

    public APIRequestCreateFeed setComposerSessionEventsLog (String composerSessionEventsLog) {
      this.setParam("composer_session_events_log", composerSessionEventsLog);
      return this;
    }

    public APIRequestCreateFeed setComposerSessionId (String composerSessionId) {
      this.setParam("composer_session_id", composerSessionId);
      return this;
    }

    public APIRequestCreateFeed setComposerSourceSurface (String composerSourceSurface) {
      this.setParam("composer_source_surface", composerSourceSurface);
      return this;
    }

    public APIRequestCreateFeed setComposerType (String composerType) {
      this.setParam("composer_type", composerType);
      return this;
    }

    public APIRequestCreateFeed setConnectionClass (String connectionClass) {
      this.setParam("connection_class", connectionClass);
      return this;
    }

    public APIRequestCreateFeed setContentAttachment (String contentAttachment) {
      this.setParam("content_attachment", contentAttachment);
      return this;
    }

    public APIRequestCreateFeed setCoordinates (Object coordinates) {
      this.setParam("coordinates", coordinates);
      return this;
    }
    public APIRequestCreateFeed setCoordinates (String coordinates) {
      this.setParam("coordinates", coordinates);
      return this;
    }

    public APIRequestCreateFeed setCtaLink (String ctaLink) {
      this.setParam("cta_link", ctaLink);
      return this;
    }

    public APIRequestCreateFeed setCtaType (String ctaType) {
      this.setParam("cta_type", ctaType);
      return this;
    }

    public APIRequestCreateFeed setDescription (String description) {
      this.setParam("description", description);
      return this;
    }

    public APIRequestCreateFeed setDirectShareStatus (Long directShareStatus) {
      this.setParam("direct_share_status", directShareStatus);
      return this;
    }
    public APIRequestCreateFeed setDirectShareStatus (String directShareStatus) {
      this.setParam("direct_share_status", directShareStatus);
      return this;
    }

    public APIRequestCreateFeed setEnforceLinkOwnership (Boolean enforceLinkOwnership) {
      this.setParam("enforce_link_ownership", enforceLinkOwnership);
      return this;
    }
    public APIRequestCreateFeed setEnforceLinkOwnership (String enforceLinkOwnership) {
      this.setParam("enforce_link_ownership", enforceLinkOwnership);
      return this;
    }

    public APIRequestCreateFeed setExpandedHeight (Long expandedHeight) {
      this.setParam("expanded_height", expandedHeight);
      return this;
    }
    public APIRequestCreateFeed setExpandedHeight (String expandedHeight) {
      this.setParam("expanded_height", expandedHeight);
      return this;
    }

    public APIRequestCreateFeed setExpandedWidth (Long expandedWidth) {
      this.setParam("expanded_width", expandedWidth);
      return this;
    }
    public APIRequestCreateFeed setExpandedWidth (String expandedWidth) {
      this.setParam("expanded_width", expandedWidth);
      return this;
    }

    public APIRequestCreateFeed setFeedTargeting (Object feedTargeting) {
      this.setParam("feed_targeting", feedTargeting);
      return this;
    }
    public APIRequestCreateFeed setFeedTargeting (String feedTargeting) {
      this.setParam("feed_targeting", feedTargeting);
      return this;
    }

    public APIRequestCreateFeed setFormatting (Page.EnumFormatting formatting) {
      this.setParam("formatting", formatting);
      return this;
    }
    public APIRequestCreateFeed setFormatting (String formatting) {
      this.setParam("formatting", formatting);
      return this;
    }

    public APIRequestCreateFeed setFunFactPromptId (String funFactPromptId) {
      this.setParam("fun_fact_prompt_id", funFactPromptId);
      return this;
    }

    public APIRequestCreateFeed setFunFactToasteeId (Long funFactToasteeId) {
      this.setParam("fun_fact_toastee_id", funFactToasteeId);
      return this;
    }
    public APIRequestCreateFeed setFunFactToasteeId (String funFactToasteeId) {
      this.setParam("fun_fact_toastee_id", funFactToasteeId);
      return this;
    }

    public APIRequestCreateFeed setHeight (Long height) {
      this.setParam("height", height);
      return this;
    }
    public APIRequestCreateFeed setHeight (String height) {
      this.setParam("height", height);
      return this;
    }

    public APIRequestCreateFeed setHomeCheckinCityId (Object homeCheckinCityId) {
      this.setParam("home_checkin_city_id", homeCheckinCityId);
      return this;
    }
    public APIRequestCreateFeed setHomeCheckinCityId (String homeCheckinCityId) {
      this.setParam("home_checkin_city_id", homeCheckinCityId);
      return this;
    }

    public APIRequestCreateFeed setImageCrops (Map<String, String> imageCrops) {
      this.setParam("image_crops", imageCrops);
      return this;
    }
    public APIRequestCreateFeed setImageCrops (String imageCrops) {
      this.setParam("image_crops", imageCrops);
      return this;
    }

    public APIRequestCreateFeed setImplicitWithTags (List<Long> implicitWithTags) {
      this.setParam("implicit_with_tags", implicitWithTags);
      return this;
    }
    public APIRequestCreateFeed setImplicitWithTags (String implicitWithTags) {
      this.setParam("implicit_with_tags", implicitWithTags);
      return this;
    }

    public APIRequestCreateFeed setInstantGameEntryPointData (String instantGameEntryPointData) {
      this.setParam("instant_game_entry_point_data", instantGameEntryPointData);
      return this;
    }

    public APIRequestCreateFeed setIosBundleId (String iosBundleId) {
      this.setParam("ios_bundle_id", iosBundleId);
      return this;
    }

    public APIRequestCreateFeed setIsBackoutDraft (Boolean isBackoutDraft) {
      this.setParam("is_backout_draft", isBackoutDraft);
      return this;
    }
    public APIRequestCreateFeed setIsBackoutDraft (String isBackoutDraft) {
      this.setParam("is_backout_draft", isBackoutDraft);
      return this;
    }

    public APIRequestCreateFeed setIsBoostIntended (Boolean isBoostIntended) {
      this.setParam("is_boost_intended", isBoostIntended);
      return this;
    }
    public APIRequestCreateFeed setIsBoostIntended (String isBoostIntended) {
      this.setParam("is_boost_intended", isBoostIntended);
      return this;
    }

    public APIRequestCreateFeed setIsExplicitLocation (Boolean isExplicitLocation) {
      this.setParam("is_explicit_location", isExplicitLocation);
      return this;
    }
    public APIRequestCreateFeed setIsExplicitLocation (String isExplicitLocation) {
      this.setParam("is_explicit_location", isExplicitLocation);
      return this;
    }

    public APIRequestCreateFeed setIsExplicitShare (Boolean isExplicitShare) {
      this.setParam("is_explicit_share", isExplicitShare);
      return this;
    }
    public APIRequestCreateFeed setIsExplicitShare (String isExplicitShare) {
      this.setParam("is_explicit_share", isExplicitShare);
      return this;
    }

    public APIRequestCreateFeed setIsGroupLinkingPost (Boolean isGroupLinkingPost) {
      this.setParam("is_group_linking_post", isGroupLinkingPost);
      return this;
    }
    public APIRequestCreateFeed setIsGroupLinkingPost (String isGroupLinkingPost) {
      this.setParam("is_group_linking_post", isGroupLinkingPost);
      return this;
    }

    public APIRequestCreateFeed setIsPhotoContainer (Boolean isPhotoContainer) {
      this.setParam("is_photo_container", isPhotoContainer);
      return this;
    }
    public APIRequestCreateFeed setIsPhotoContainer (String isPhotoContainer) {
      this.setParam("is_photo_container", isPhotoContainer);
      return this;
    }

    public APIRequestCreateFeed setLink (String link) {
      this.setParam("link", link);
      return this;
    }

    public APIRequestCreateFeed setLocationSourceId (String locationSourceId) {
      this.setParam("location_source_id", locationSourceId);
      return this;
    }

    public APIRequestCreateFeed setManualPrivacy (Boolean manualPrivacy) {
      this.setParam("manual_privacy", manualPrivacy);
      return this;
    }
    public APIRequestCreateFeed setManualPrivacy (String manualPrivacy) {
      this.setParam("manual_privacy", manualPrivacy);
      return this;
    }

    public APIRequestCreateFeed setMessage (String message) {
      this.setParam("message", message);
      return this;
    }

    public APIRequestCreateFeed setMultiShareEndCard (Boolean multiShareEndCard) {
      this.setParam("multi_share_end_card", multiShareEndCard);
      return this;
    }
    public APIRequestCreateFeed setMultiShareEndCard (String multiShareEndCard) {
      this.setParam("multi_share_end_card", multiShareEndCard);
      return this;
    }

    public APIRequestCreateFeed setMultiShareOptimized (Boolean multiShareOptimized) {
      this.setParam("multi_share_optimized", multiShareOptimized);
      return this;
    }
    public APIRequestCreateFeed setMultiShareOptimized (String multiShareOptimized) {
      this.setParam("multi_share_optimized", multiShareOptimized);
      return this;
    }

    public APIRequestCreateFeed setName (String name) {
      this.setParam("name", name);
      return this;
    }

    public APIRequestCreateFeed setNectarModule (String nectarModule) {
      this.setParam("nectar_module", nectarModule);
      return this;
    }

    public APIRequestCreateFeed setObjectAttachment (String objectAttachment) {
      this.setParam("object_attachment", objectAttachment);
      return this;
    }

    public APIRequestCreateFeed setOgActionTypeId (String ogActionTypeId) {
      this.setParam("og_action_type_id", ogActionTypeId);
      return this;
    }

    public APIRequestCreateFeed setOgHideObjectAttachment (Boolean ogHideObjectAttachment) {
      this.setParam("og_hide_object_attachment", ogHideObjectAttachment);
      return this;
    }
    public APIRequestCreateFeed setOgHideObjectAttachment (String ogHideObjectAttachment) {
      this.setParam("og_hide_object_attachment", ogHideObjectAttachment);
      return this;
    }

    public APIRequestCreateFeed setOgIconId (String ogIconId) {
      this.setParam("og_icon_id", ogIconId);
      return this;
    }

    public APIRequestCreateFeed setOgObjectId (String ogObjectId) {
      this.setParam("og_object_id", ogObjectId);
      return this;
    }

    public APIRequestCreateFeed setOgPhrase (String ogPhrase) {
      this.setParam("og_phrase", ogPhrase);
      return this;
    }

    public APIRequestCreateFeed setOgSetProfileBadge (Boolean ogSetProfileBadge) {
      this.setParam("og_set_profile_badge", ogSetProfileBadge);
      return this;
    }
    public APIRequestCreateFeed setOgSetProfileBadge (String ogSetProfileBadge) {
      this.setParam("og_set_profile_badge", ogSetProfileBadge);
      return this;
    }

    public APIRequestCreateFeed setOgSuggestionMechanism (String ogSuggestionMechanism) {
      this.setParam("og_suggestion_mechanism", ogSuggestionMechanism);
      return this;
    }

    public APIRequestCreateFeed setPageRecommendation (String pageRecommendation) {
      this.setParam("page_recommendation", pageRecommendation);
      return this;
    }

    public APIRequestCreateFeed setPicture (String picture) {
      this.setParam("picture", picture);
      return this;
    }

    public APIRequestCreateFeed setPlace (Object place) {
      this.setParam("place", place);
      return this;
    }
    public APIRequestCreateFeed setPlace (String place) {
      this.setParam("place", place);
      return this;
    }

    public APIRequestCreateFeed setPlaceAttachmentSetting (Page.EnumPlaceAttachmentSetting placeAttachmentSetting) {
      this.setParam("place_attachment_setting", placeAttachmentSetting);
      return this;
    }
    public APIRequestCreateFeed setPlaceAttachmentSetting (String placeAttachmentSetting) {
      this.setParam("place_attachment_setting", placeAttachmentSetting);
      return this;
    }

    public APIRequestCreateFeed setPlaceList (String placeList) {
      this.setParam("place_list", placeList);
      return this;
    }

    public APIRequestCreateFeed setPlaceListData (JsonArray placeListData) {
      this.setParam("place_list_data", placeListData);
      return this;
    }
    public APIRequestCreateFeed setPlaceListData (String placeListData) {
      this.setParam("place_list_data", placeListData);
      return this;
    }

    public APIRequestCreateFeed setPostSurfacesBlacklist (List<Page.EnumPostSurfacesBlacklist> postSurfacesBlacklist) {
      this.setParam("post_surfaces_blacklist", postSurfacesBlacklist);
      return this;
    }
    public APIRequestCreateFeed setPostSurfacesBlacklist (String postSurfacesBlacklist) {
      this.setParam("post_surfaces_blacklist", postSurfacesBlacklist);
      return this;
    }

    public APIRequestCreateFeed setPostingToRedspace (Page.EnumPostingToRedspace postingToRedspace) {
      this.setParam("posting_to_redspace", postingToRedspace);
      return this;
    }
    public APIRequestCreateFeed setPostingToRedspace (String postingToRedspace) {
      this.setParam("posting_to_redspace", postingToRedspace);
      return this;
    }

    public APIRequestCreateFeed setPrivacy (String privacy) {
      this.setParam("privacy", privacy);
      return this;
    }

    public APIRequestCreateFeed setPromptId (String promptId) {
      this.setParam("prompt_id", promptId);
      return this;
    }

    public APIRequestCreateFeed setPromptTrackingString (String promptTrackingString) {
      this.setParam("prompt_tracking_string", promptTrackingString);
      return this;
    }

    public APIRequestCreateFeed setProperties (Object properties) {
      this.setParam("properties", properties);
      return this;
    }
    public APIRequestCreateFeed setProperties (String properties) {
      this.setParam("properties", properties);
      return this;
    }

    public APIRequestCreateFeed setProxiedAppId (String proxiedAppId) {
      this.setParam("proxied_app_id", proxiedAppId);
      return this;
    }

    public APIRequestCreateFeed setPublishEventId (Long publishEventId) {
      this.setParam("publish_event_id", publishEventId);
      return this;
    }
    public APIRequestCreateFeed setPublishEventId (String publishEventId) {
      this.setParam("publish_event_id", publishEventId);
      return this;
    }

    public APIRequestCreateFeed setPublished (Boolean published) {
      this.setParam("published", published);
      return this;
    }
    public APIRequestCreateFeed setPublished (String published) {
      this.setParam("published", published);
      return this;
    }

    public APIRequestCreateFeed setQuote (String quote) {
      this.setParam("quote", quote);
      return this;
    }

    public APIRequestCreateFeed setRef (List<String> ref) {
      this.setParam("ref", ref);
      return this;
    }
    public APIRequestCreateFeed setRef (String ref) {
      this.setParam("ref", ref);
      return this;
    }

    public APIRequestCreateFeed setReferenceableImageIds (List<String> referenceableImageIds) {
      this.setParam("referenceable_image_ids", referenceableImageIds);
      return this;
    }
    public APIRequestCreateFeed setReferenceableImageIds (String referenceableImageIds) {
      this.setParam("referenceable_image_ids", referenceableImageIds);
      return this;
    }

    public APIRequestCreateFeed setReferralId (String referralId) {
      this.setParam("referral_id", referralId);
      return this;
    }

    public APIRequestCreateFeed setScheduledPublishTime (String scheduledPublishTime) {
      this.setParam("scheduled_publish_time", scheduledPublishTime);
      return this;
    }

    public APIRequestCreateFeed setSource (String source) {
      this.setParam("source", source);
      return this;
    }

    public APIRequestCreateFeed setSponsorId (String sponsorId) {
      this.setParam("sponsor_id", sponsorId);
      return this;
    }

    public APIRequestCreateFeed setSponsorRelationship (Long sponsorRelationship) {
      this.setParam("sponsor_relationship", sponsorRelationship);
      return this;
    }
    public APIRequestCreateFeed setSponsorRelationship (String sponsorRelationship) {
      this.setParam("sponsor_relationship", sponsorRelationship);
      return this;
    }

    public APIRequestCreateFeed setSuggestedPlaceId (Object suggestedPlaceId) {
      this.setParam("suggested_place_id", suggestedPlaceId);
      return this;
    }
    public APIRequestCreateFeed setSuggestedPlaceId (String suggestedPlaceId) {
      this.setParam("suggested_place_id", suggestedPlaceId);
      return this;
    }

    public APIRequestCreateFeed setTags (List<Long> tags) {
      this.setParam("tags", tags);
      return this;
    }
    public APIRequestCreateFeed setTags (String tags) {
      this.setParam("tags", tags);
      return this;
    }

    public APIRequestCreateFeed setTargetSurface (Page.EnumTargetSurface targetSurface) {
      this.setParam("target_surface", targetSurface);
      return this;
    }
    public APIRequestCreateFeed setTargetSurface (String targetSurface) {
      this.setParam("target_surface", targetSurface);
      return this;
    }

    public APIRequestCreateFeed setTargeting (Object targeting) {
      this.setParam("targeting", targeting);
      return this;
    }
    public APIRequestCreateFeed setTargeting (String targeting) {
      this.setParam("targeting", targeting);
      return this;
    }

    public APIRequestCreateFeed setTextFormatMetadata (String textFormatMetadata) {
      this.setParam("text_format_metadata", textFormatMetadata);
      return this;
    }

    public APIRequestCreateFeed setTextFormatPresetId (String textFormatPresetId) {
      this.setParam("text_format_preset_id", textFormatPresetId);
      return this;
    }

    public APIRequestCreateFeed setTextOnlyPlace (String textOnlyPlace) {
      this.setParam("text_only_place", textOnlyPlace);
      return this;
    }

    public APIRequestCreateFeed setThumbnail (File thumbnail) {
      this.setParam("thumbnail", thumbnail);
      return this;
    }
    public APIRequestCreateFeed setThumbnail (String thumbnail) {
      this.setParam("thumbnail", thumbnail);
      return this;
    }

    public APIRequestCreateFeed setTimeSinceOriginalPost (Long timeSinceOriginalPost) {
      this.setParam("time_since_original_post", timeSinceOriginalPost);
      return this;
    }
    public APIRequestCreateFeed setTimeSinceOriginalPost (String timeSinceOriginalPost) {
      this.setParam("time_since_original_post", timeSinceOriginalPost);
      return this;
    }

    public APIRequestCreateFeed setTitle (String title) {
      this.setParam("title", title);
      return this;
    }

    public APIRequestCreateFeed setTrackingInfo (String trackingInfo) {
      this.setParam("tracking_info", trackingInfo);
      return this;
    }

    public APIRequestCreateFeed setUnpublishedContentType (Page.EnumUnpublishedContentType unpublishedContentType) {
      this.setParam("unpublished_content_type", unpublishedContentType);
      return this;
    }
    public APIRequestCreateFeed setUnpublishedContentType (String unpublishedContentType) {
      this.setParam("unpublished_content_type", unpublishedContentType);
      return this;
    }

    public APIRequestCreateFeed setUserSelectedTags (Boolean userSelectedTags) {
      this.setParam("user_selected_tags", userSelectedTags);
      return this;
    }
    public APIRequestCreateFeed setUserSelectedTags (String userSelectedTags) {
      this.setParam("user_selected_tags", userSelectedTags);
      return this;
    }

    public APIRequestCreateFeed setVideoStartTimeMs (Long videoStartTimeMs) {
      this.setParam("video_start_time_ms", videoStartTimeMs);
      return this;
    }
    public APIRequestCreateFeed setVideoStartTimeMs (String videoStartTimeMs) {
      this.setParam("video_start_time_ms", videoStartTimeMs);
      return this;
    }

    public APIRequestCreateFeed setViewerCoordinates (Object viewerCoordinates) {
      this.setParam("viewer_coordinates", viewerCoordinates);
      return this;
    }
    public APIRequestCreateFeed setViewerCoordinates (String viewerCoordinates) {
      this.setParam("viewer_coordinates", viewerCoordinates);
      return this;
    }

    public APIRequestCreateFeed setWidth (Long width) {
      this.setParam("width", width);
      return this;
    }
    public APIRequestCreateFeed setWidth (String width) {
      this.setParam("width", width);
      return this;
    }

    public APIRequestCreateFeed requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateFeed requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateFeed requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateFeed requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateFeed requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateFeed requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetGlobalBrandChildren extends APIRequest<Page> {

    APINodeList<Page> lastResponse = null;
    @Override
    public APINodeList<Page> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "about",
      "access_token",
      "ad_campaign",
      "affiliation",
      "app_id",
      "artists_we_like",
      "attire",
      "available_promo_offer_ids",
      "awards",
      "band_interests",
      "band_members",
      "best_page",
      "bio",
      "birthday",
      "booking_agent",
      "breaking_news_usage",
      "built",
      "business",
      "can_checkin",
      "can_post",
      "category",
      "category_list",
      "checkins",
      "company_overview",
      "connected_instagram_account",
      "connected_page_backed_instagram_account",
      "contact_address",
      "copyright_attribution_insights",
      "copyright_whitelisted_ig_partners",
      "country_page_likes",
      "cover",
      "culinary_team",
      "current_location",
      "delivery_and_pickup_option_info",
      "description",
      "description_html",
      "differently_open_offerings",
      "directed_by",
      "display_subtext",
      "displayed_message_response_time",
      "does_viewer_have_page_permission_link_ig",
      "emails",
      "engagement",
      "fan_count",
      "featured_video",
      "features",
      "followers_count",
      "food_styles",
      "founded",
      "general_info",
      "general_manager",
      "genre",
      "global_brand_page_name",
      "global_brand_root_id",
      "has_added_app",
      "has_lead_access",
      "has_transitioned_to_new_page_experience",
      "has_whatsapp_business_number",
      "has_whatsapp_number",
      "hometown",
      "hours",
      "id",
      "impressum",
      "influences",
      "instagram_business_account",
      "is_always_open",
      "is_calling_eligible",
      "is_chain",
      "is_community_page",
      "is_eligible_for_branded_content",
      "is_eligible_for_disable_connect_ig_btn_for_non_page_admin_am_web",
      "is_messenger_bot_get_started_enabled",
      "is_messenger_platform_bot",
      "is_owned",
      "is_permanently_closed",
      "is_published",
      "is_unclaimed",
      "is_verified",
      "is_webhooks_subscribed",
      "keywords",
      "leadgen_tos_acceptance_time",
      "leadgen_tos_accepted",
      "leadgen_tos_accepting_user",
      "link",
      "location",
      "members",
      "merchant_id",
      "merchant_review_status",
      "messaging_feature_status",
      "messenger_ads_default_icebreakers",
      "messenger_ads_default_quick_replies",
      "messenger_ads_quick_replies_type",
      "mini_shop_storefront",
      "mission",
      "mpg",
      "name",
      "name_with_location_descriptor",
      "network",
      "new_like_count",
      "offer_eligible",
      "overall_star_rating",
      "owner_business",
      "page_token",
      "parent_page",
      "parking",
      "payment_options",
      "personal_info",
      "personal_interests",
      "pharma_safety_info",
      "phone",
      "pickup_options",
      "place_type",
      "plot_outline",
      "preferred_audience",
      "press_contact",
      "price_range",
      "privacy_info_url",
      "produced_by",
      "products",
      "promotion_eligible",
      "promotion_ineligible_reason",
      "public_transit",
      "rating_count",
      "recipient",
      "record_label",
      "release_date",
      "restaurant_services",
      "restaurant_specialties",
      "schedule",
      "screenplay_by",
      "season",
      "single_line_address",
      "starring",
      "start_info",
      "store_code",
      "store_location_descriptor",
      "store_number",
      "studio",
      "supports_donate_button_in_live_video",
      "talking_about_count",
      "temporary_status",
      "unread_message_count",
      "unread_notif_count",
      "unseen_message_count",
      "user_access_expire_time",
      "username",
      "verification_status",
      "voip_info",
      "website",
      "were_here_count",
      "whatsapp_number",
      "written_by",
    };

    @Override
    public APINodeList<Page> parseResponse(String response, String header) throws APIException {
      return Page.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<Page> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Page> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Page>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Page>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<Page>>() {
           public APINodeList<Page> apply(ResponseWrapper result) {
             try {
               return APIRequestGetGlobalBrandChildren.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetGlobalBrandChildren(String nodeId, APIContext context) {
      super(context, nodeId, "/global_brand_children", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetGlobalBrandChildren setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetGlobalBrandChildren setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetGlobalBrandChildren requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetGlobalBrandChildren requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetGlobalBrandChildren requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetGlobalBrandChildren requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetGlobalBrandChildren requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetGlobalBrandChildren requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetGlobalBrandChildren requestAboutField () {
      return this.requestAboutField(true);
    }
    public APIRequestGetGlobalBrandChildren requestAboutField (boolean value) {
      this.requestField("about", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestAccessTokenField () {
      return this.requestAccessTokenField(true);
    }
    public APIRequestGetGlobalBrandChildren requestAccessTokenField (boolean value) {
      this.requestField("access_token", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestAdCampaignField () {
      return this.requestAdCampaignField(true);
    }
    public APIRequestGetGlobalBrandChildren requestAdCampaignField (boolean value) {
      this.requestField("ad_campaign", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestAffiliationField () {
      return this.requestAffiliationField(true);
    }
    public APIRequestGetGlobalBrandChildren requestAffiliationField (boolean value) {
      this.requestField("affiliation", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestAppIdField () {
      return this.requestAppIdField(true);
    }
    public APIRequestGetGlobalBrandChildren requestAppIdField (boolean value) {
      this.requestField("app_id", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestArtistsWeLikeField () {
      return this.requestArtistsWeLikeField(true);
    }
    public APIRequestGetGlobalBrandChildren requestArtistsWeLikeField (boolean value) {
      this.requestField("artists_we_like", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestAttireField () {
      return this.requestAttireField(true);
    }
    public APIRequestGetGlobalBrandChildren requestAttireField (boolean value) {
      this.requestField("attire", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestAvailablePromoOfferIdsField () {
      return this.requestAvailablePromoOfferIdsField(true);
    }
    public APIRequestGetGlobalBrandChildren requestAvailablePromoOfferIdsField (boolean value) {
      this.requestField("available_promo_offer_ids", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestAwardsField () {
      return this.requestAwardsField(true);
    }
    public APIRequestGetGlobalBrandChildren requestAwardsField (boolean value) {
      this.requestField("awards", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestBandInterestsField () {
      return this.requestBandInterestsField(true);
    }
    public APIRequestGetGlobalBrandChildren requestBandInterestsField (boolean value) {
      this.requestField("band_interests", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestBandMembersField () {
      return this.requestBandMembersField(true);
    }
    public APIRequestGetGlobalBrandChildren requestBandMembersField (boolean value) {
      this.requestField("band_members", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestBestPageField () {
      return this.requestBestPageField(true);
    }
    public APIRequestGetGlobalBrandChildren requestBestPageField (boolean value) {
      this.requestField("best_page", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestBioField () {
      return this.requestBioField(true);
    }
    public APIRequestGetGlobalBrandChildren requestBioField (boolean value) {
      this.requestField("bio", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestBirthdayField () {
      return this.requestBirthdayField(true);
    }
    public APIRequestGetGlobalBrandChildren requestBirthdayField (boolean value) {
      this.requestField("birthday", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestBookingAgentField () {
      return this.requestBookingAgentField(true);
    }
    public APIRequestGetGlobalBrandChildren requestBookingAgentField (boolean value) {
      this.requestField("booking_agent", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestBreakingNewsUsageField () {
      return this.requestBreakingNewsUsageField(true);
    }
    public APIRequestGetGlobalBrandChildren requestBreakingNewsUsageField (boolean value) {
      this.requestField("breaking_news_usage", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestBuiltField () {
      return this.requestBuiltField(true);
    }
    public APIRequestGetGlobalBrandChildren requestBuiltField (boolean value) {
      this.requestField("built", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestBusinessField () {
      return this.requestBusinessField(true);
    }
    public APIRequestGetGlobalBrandChildren requestBusinessField (boolean value) {
      this.requestField("business", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestCanCheckinField () {
      return this.requestCanCheckinField(true);
    }
    public APIRequestGetGlobalBrandChildren requestCanCheckinField (boolean value) {
      this.requestField("can_checkin", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestCanPostField () {
      return this.requestCanPostField(true);
    }
    public APIRequestGetGlobalBrandChildren requestCanPostField (boolean value) {
      this.requestField("can_post", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestCategoryField () {
      return this.requestCategoryField(true);
    }
    public APIRequestGetGlobalBrandChildren requestCategoryField (boolean value) {
      this.requestField("category", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestCategoryListField () {
      return this.requestCategoryListField(true);
    }
    public APIRequestGetGlobalBrandChildren requestCategoryListField (boolean value) {
      this.requestField("category_list", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestCheckinsField () {
      return this.requestCheckinsField(true);
    }
    public APIRequestGetGlobalBrandChildren requestCheckinsField (boolean value) {
      this.requestField("checkins", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestCompanyOverviewField () {
      return this.requestCompanyOverviewField(true);
    }
    public APIRequestGetGlobalBrandChildren requestCompanyOverviewField (boolean value) {
      this.requestField("company_overview", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestConnectedInstagramAccountField () {
      return this.requestConnectedInstagramAccountField(true);
    }
    public APIRequestGetGlobalBrandChildren requestConnectedInstagramAccountField (boolean value) {
      this.requestField("connected_instagram_account", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestConnectedPageBackedInstagramAccountField () {
      return this.requestConnectedPageBackedInstagramAccountField(true);
    }
    public APIRequestGetGlobalBrandChildren requestConnectedPageBackedInstagramAccountField (boolean value) {
      this.requestField("connected_page_backed_instagram_account", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestContactAddressField () {
      return this.requestContactAddressField(true);
    }
    public APIRequestGetGlobalBrandChildren requestContactAddressField (boolean value) {
      this.requestField("contact_address", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestCopyrightAttributionInsightsField () {
      return this.requestCopyrightAttributionInsightsField(true);
    }
    public APIRequestGetGlobalBrandChildren requestCopyrightAttributionInsightsField (boolean value) {
      this.requestField("copyright_attribution_insights", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestCopyrightWhitelistedIgPartnersField () {
      return this.requestCopyrightWhitelistedIgPartnersField(true);
    }
    public APIRequestGetGlobalBrandChildren requestCopyrightWhitelistedIgPartnersField (boolean value) {
      this.requestField("copyright_whitelisted_ig_partners", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestCountryPageLikesField () {
      return this.requestCountryPageLikesField(true);
    }
    public APIRequestGetGlobalBrandChildren requestCountryPageLikesField (boolean value) {
      this.requestField("country_page_likes", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestCoverField () {
      return this.requestCoverField(true);
    }
    public APIRequestGetGlobalBrandChildren requestCoverField (boolean value) {
      this.requestField("cover", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestCulinaryTeamField () {
      return this.requestCulinaryTeamField(true);
    }
    public APIRequestGetGlobalBrandChildren requestCulinaryTeamField (boolean value) {
      this.requestField("culinary_team", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestCurrentLocationField () {
      return this.requestCurrentLocationField(true);
    }
    public APIRequestGetGlobalBrandChildren requestCurrentLocationField (boolean value) {
      this.requestField("current_location", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestDeliveryAndPickupOptionInfoField () {
      return this.requestDeliveryAndPickupOptionInfoField(true);
    }
    public APIRequestGetGlobalBrandChildren requestDeliveryAndPickupOptionInfoField (boolean value) {
      this.requestField("delivery_and_pickup_option_info", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetGlobalBrandChildren requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestDescriptionHtmlField () {
      return this.requestDescriptionHtmlField(true);
    }
    public APIRequestGetGlobalBrandChildren requestDescriptionHtmlField (boolean value) {
      this.requestField("description_html", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestDifferentlyOpenOfferingsField () {
      return this.requestDifferentlyOpenOfferingsField(true);
    }
    public APIRequestGetGlobalBrandChildren requestDifferentlyOpenOfferingsField (boolean value) {
      this.requestField("differently_open_offerings", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestDirectedByField () {
      return this.requestDirectedByField(true);
    }
    public APIRequestGetGlobalBrandChildren requestDirectedByField (boolean value) {
      this.requestField("directed_by", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestDisplaySubtextField () {
      return this.requestDisplaySubtextField(true);
    }
    public APIRequestGetGlobalBrandChildren requestDisplaySubtextField (boolean value) {
      this.requestField("display_subtext", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestDisplayedMessageResponseTimeField () {
      return this.requestDisplayedMessageResponseTimeField(true);
    }
    public APIRequestGetGlobalBrandChildren requestDisplayedMessageResponseTimeField (boolean value) {
      this.requestField("displayed_message_response_time", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestDoesViewerHavePagePermissionLinkIgField () {
      return this.requestDoesViewerHavePagePermissionLinkIgField(true);
    }
    public APIRequestGetGlobalBrandChildren requestDoesViewerHavePagePermissionLinkIgField (boolean value) {
      this.requestField("does_viewer_have_page_permission_link_ig", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestEmailsField () {
      return this.requestEmailsField(true);
    }
    public APIRequestGetGlobalBrandChildren requestEmailsField (boolean value) {
      this.requestField("emails", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestEngagementField () {
      return this.requestEngagementField(true);
    }
    public APIRequestGetGlobalBrandChildren requestEngagementField (boolean value) {
      this.requestField("engagement", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestFanCountField () {
      return this.requestFanCountField(true);
    }
    public APIRequestGetGlobalBrandChildren requestFanCountField (boolean value) {
      this.requestField("fan_count", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestFeaturedVideoField () {
      return this.requestFeaturedVideoField(true);
    }
    public APIRequestGetGlobalBrandChildren requestFeaturedVideoField (boolean value) {
      this.requestField("featured_video", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestFeaturesField () {
      return this.requestFeaturesField(true);
    }
    public APIRequestGetGlobalBrandChildren requestFeaturesField (boolean value) {
      this.requestField("features", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestFollowersCountField () {
      return this.requestFollowersCountField(true);
    }
    public APIRequestGetGlobalBrandChildren requestFollowersCountField (boolean value) {
      this.requestField("followers_count", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestFoodStylesField () {
      return this.requestFoodStylesField(true);
    }
    public APIRequestGetGlobalBrandChildren requestFoodStylesField (boolean value) {
      this.requestField("food_styles", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestFoundedField () {
      return this.requestFoundedField(true);
    }
    public APIRequestGetGlobalBrandChildren requestFoundedField (boolean value) {
      this.requestField("founded", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestGeneralInfoField () {
      return this.requestGeneralInfoField(true);
    }
    public APIRequestGetGlobalBrandChildren requestGeneralInfoField (boolean value) {
      this.requestField("general_info", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestGeneralManagerField () {
      return this.requestGeneralManagerField(true);
    }
    public APIRequestGetGlobalBrandChildren requestGeneralManagerField (boolean value) {
      this.requestField("general_manager", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestGenreField () {
      return this.requestGenreField(true);
    }
    public APIRequestGetGlobalBrandChildren requestGenreField (boolean value) {
      this.requestField("genre", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestGlobalBrandPageNameField () {
      return this.requestGlobalBrandPageNameField(true);
    }
    public APIRequestGetGlobalBrandChildren requestGlobalBrandPageNameField (boolean value) {
      this.requestField("global_brand_page_name", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestGlobalBrandRootIdField () {
      return this.requestGlobalBrandRootIdField(true);
    }
    public APIRequestGetGlobalBrandChildren requestGlobalBrandRootIdField (boolean value) {
      this.requestField("global_brand_root_id", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestHasAddedAppField () {
      return this.requestHasAddedAppField(true);
    }
    public APIRequestGetGlobalBrandChildren requestHasAddedAppField (boolean value) {
      this.requestField("has_added_app", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestHasLeadAccessField () {
      return this.requestHasLeadAccessField(true);
    }
    public APIRequestGetGlobalBrandChildren requestHasLeadAccessField (boolean value) {
      this.requestField("has_lead_access", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestHasTransitionedToNewPageExperienceField () {
      return this.requestHasTransitionedToNewPageExperienceField(true);
    }
    public APIRequestGetGlobalBrandChildren requestHasTransitionedToNewPageExperienceField (boolean value) {
      this.requestField("has_transitioned_to_new_page_experience", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestHasWhatsappBusinessNumberField () {
      return this.requestHasWhatsappBusinessNumberField(true);
    }
    public APIRequestGetGlobalBrandChildren requestHasWhatsappBusinessNumberField (boolean value) {
      this.requestField("has_whatsapp_business_number", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestHasWhatsappNumberField () {
      return this.requestHasWhatsappNumberField(true);
    }
    public APIRequestGetGlobalBrandChildren requestHasWhatsappNumberField (boolean value) {
      this.requestField("has_whatsapp_number", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestHometownField () {
      return this.requestHometownField(true);
    }
    public APIRequestGetGlobalBrandChildren requestHometownField (boolean value) {
      this.requestField("hometown", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestHoursField () {
      return this.requestHoursField(true);
    }
    public APIRequestGetGlobalBrandChildren requestHoursField (boolean value) {
      this.requestField("hours", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestImpressumField () {
      return this.requestImpressumField(true);
    }
    public APIRequestGetGlobalBrandChildren requestImpressumField (boolean value) {
      this.requestField("impressum", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestInfluencesField () {
      return this.requestInfluencesField(true);
    }
    public APIRequestGetGlobalBrandChildren requestInfluencesField (boolean value) {
      this.requestField("influences", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestInstagramBusinessAccountField () {
      return this.requestInstagramBusinessAccountField(true);
    }
    public APIRequestGetGlobalBrandChildren requestInstagramBusinessAccountField (boolean value) {
      this.requestField("instagram_business_account", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIsAlwaysOpenField () {
      return this.requestIsAlwaysOpenField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIsAlwaysOpenField (boolean value) {
      this.requestField("is_always_open", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIsCallingEligibleField () {
      return this.requestIsCallingEligibleField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIsCallingEligibleField (boolean value) {
      this.requestField("is_calling_eligible", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIsChainField () {
      return this.requestIsChainField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIsChainField (boolean value) {
      this.requestField("is_chain", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIsCommunityPageField () {
      return this.requestIsCommunityPageField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIsCommunityPageField (boolean value) {
      this.requestField("is_community_page", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIsEligibleForBrandedContentField () {
      return this.requestIsEligibleForBrandedContentField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIsEligibleForBrandedContentField (boolean value) {
      this.requestField("is_eligible_for_branded_content", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIsEligibleForDisableConnectIgBtnForNonPageAdminAmWebField () {
      return this.requestIsEligibleForDisableConnectIgBtnForNonPageAdminAmWebField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIsEligibleForDisableConnectIgBtnForNonPageAdminAmWebField (boolean value) {
      this.requestField("is_eligible_for_disable_connect_ig_btn_for_non_page_admin_am_web", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIsMessengerBotGetStartedEnabledField () {
      return this.requestIsMessengerBotGetStartedEnabledField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIsMessengerBotGetStartedEnabledField (boolean value) {
      this.requestField("is_messenger_bot_get_started_enabled", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIsMessengerPlatformBotField () {
      return this.requestIsMessengerPlatformBotField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIsMessengerPlatformBotField (boolean value) {
      this.requestField("is_messenger_platform_bot", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIsOwnedField () {
      return this.requestIsOwnedField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIsOwnedField (boolean value) {
      this.requestField("is_owned", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIsPermanentlyClosedField () {
      return this.requestIsPermanentlyClosedField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIsPermanentlyClosedField (boolean value) {
      this.requestField("is_permanently_closed", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIsPublishedField () {
      return this.requestIsPublishedField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIsPublishedField (boolean value) {
      this.requestField("is_published", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIsUnclaimedField () {
      return this.requestIsUnclaimedField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIsUnclaimedField (boolean value) {
      this.requestField("is_unclaimed", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIsVerifiedField () {
      return this.requestIsVerifiedField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIsVerifiedField (boolean value) {
      this.requestField("is_verified", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIsWebhooksSubscribedField () {
      return this.requestIsWebhooksSubscribedField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIsWebhooksSubscribedField (boolean value) {
      this.requestField("is_webhooks_subscribed", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestKeywordsField () {
      return this.requestKeywordsField(true);
    }
    public APIRequestGetGlobalBrandChildren requestKeywordsField (boolean value) {
      this.requestField("keywords", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestLeadgenTosAcceptanceTimeField () {
      return this.requestLeadgenTosAcceptanceTimeField(true);
    }
    public APIRequestGetGlobalBrandChildren requestLeadgenTosAcceptanceTimeField (boolean value) {
      this.requestField("leadgen_tos_acceptance_time", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestLeadgenTosAcceptedField () {
      return this.requestLeadgenTosAcceptedField(true);
    }
    public APIRequestGetGlobalBrandChildren requestLeadgenTosAcceptedField (boolean value) {
      this.requestField("leadgen_tos_accepted", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestLeadgenTosAcceptingUserField () {
      return this.requestLeadgenTosAcceptingUserField(true);
    }
    public APIRequestGetGlobalBrandChildren requestLeadgenTosAcceptingUserField (boolean value) {
      this.requestField("leadgen_tos_accepting_user", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestLinkField () {
      return this.requestLinkField(true);
    }
    public APIRequestGetGlobalBrandChildren requestLinkField (boolean value) {
      this.requestField("link", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestLocationField () {
      return this.requestLocationField(true);
    }
    public APIRequestGetGlobalBrandChildren requestLocationField (boolean value) {
      this.requestField("location", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestMembersField () {
      return this.requestMembersField(true);
    }
    public APIRequestGetGlobalBrandChildren requestMembersField (boolean value) {
      this.requestField("members", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestMerchantIdField () {
      return this.requestMerchantIdField(true);
    }
    public APIRequestGetGlobalBrandChildren requestMerchantIdField (boolean value) {
      this.requestField("merchant_id", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestMerchantReviewStatusField () {
      return this.requestMerchantReviewStatusField(true);
    }
    public APIRequestGetGlobalBrandChildren requestMerchantReviewStatusField (boolean value) {
      this.requestField("merchant_review_status", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestMessagingFeatureStatusField () {
      return this.requestMessagingFeatureStatusField(true);
    }
    public APIRequestGetGlobalBrandChildren requestMessagingFeatureStatusField (boolean value) {
      this.requestField("messaging_feature_status", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestMessengerAdsDefaultIcebreakersField () {
      return this.requestMessengerAdsDefaultIcebreakersField(true);
    }
    public APIRequestGetGlobalBrandChildren requestMessengerAdsDefaultIcebreakersField (boolean value) {
      this.requestField("messenger_ads_default_icebreakers", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestMessengerAdsDefaultQuickRepliesField () {
      return this.requestMessengerAdsDefaultQuickRepliesField(true);
    }
    public APIRequestGetGlobalBrandChildren requestMessengerAdsDefaultQuickRepliesField (boolean value) {
      this.requestField("messenger_ads_default_quick_replies", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestMessengerAdsQuickRepliesTypeField () {
      return this.requestMessengerAdsQuickRepliesTypeField(true);
    }
    public APIRequestGetGlobalBrandChildren requestMessengerAdsQuickRepliesTypeField (boolean value) {
      this.requestField("messenger_ads_quick_replies_type", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestMiniShopStorefrontField () {
      return this.requestMiniShopStorefrontField(true);
    }
    public APIRequestGetGlobalBrandChildren requestMiniShopStorefrontField (boolean value) {
      this.requestField("mini_shop_storefront", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestMissionField () {
      return this.requestMissionField(true);
    }
    public APIRequestGetGlobalBrandChildren requestMissionField (boolean value) {
      this.requestField("mission", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestMpgField () {
      return this.requestMpgField(true);
    }
    public APIRequestGetGlobalBrandChildren requestMpgField (boolean value) {
      this.requestField("mpg", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetGlobalBrandChildren requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestNameWithLocationDescriptorField () {
      return this.requestNameWithLocationDescriptorField(true);
    }
    public APIRequestGetGlobalBrandChildren requestNameWithLocationDescriptorField (boolean value) {
      this.requestField("name_with_location_descriptor", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestNetworkField () {
      return this.requestNetworkField(true);
    }
    public APIRequestGetGlobalBrandChildren requestNetworkField (boolean value) {
      this.requestField("network", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestNewLikeCountField () {
      return this.requestNewLikeCountField(true);
    }
    public APIRequestGetGlobalBrandChildren requestNewLikeCountField (boolean value) {
      this.requestField("new_like_count", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestOfferEligibleField () {
      return this.requestOfferEligibleField(true);
    }
    public APIRequestGetGlobalBrandChildren requestOfferEligibleField (boolean value) {
      this.requestField("offer_eligible", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestOverallStarRatingField () {
      return this.requestOverallStarRatingField(true);
    }
    public APIRequestGetGlobalBrandChildren requestOverallStarRatingField (boolean value) {
      this.requestField("overall_star_rating", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestOwnerBusinessField () {
      return this.requestOwnerBusinessField(true);
    }
    public APIRequestGetGlobalBrandChildren requestOwnerBusinessField (boolean value) {
      this.requestField("owner_business", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPageTokenField () {
      return this.requestPageTokenField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPageTokenField (boolean value) {
      this.requestField("page_token", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestParentPageField () {
      return this.requestParentPageField(true);
    }
    public APIRequestGetGlobalBrandChildren requestParentPageField (boolean value) {
      this.requestField("parent_page", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestParkingField () {
      return this.requestParkingField(true);
    }
    public APIRequestGetGlobalBrandChildren requestParkingField (boolean value) {
      this.requestField("parking", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPaymentOptionsField () {
      return this.requestPaymentOptionsField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPaymentOptionsField (boolean value) {
      this.requestField("payment_options", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPersonalInfoField () {
      return this.requestPersonalInfoField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPersonalInfoField (boolean value) {
      this.requestField("personal_info", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPersonalInterestsField () {
      return this.requestPersonalInterestsField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPersonalInterestsField (boolean value) {
      this.requestField("personal_interests", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPharmaSafetyInfoField () {
      return this.requestPharmaSafetyInfoField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPharmaSafetyInfoField (boolean value) {
      this.requestField("pharma_safety_info", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPhoneField () {
      return this.requestPhoneField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPhoneField (boolean value) {
      this.requestField("phone", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPickupOptionsField () {
      return this.requestPickupOptionsField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPickupOptionsField (boolean value) {
      this.requestField("pickup_options", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPlaceTypeField () {
      return this.requestPlaceTypeField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPlaceTypeField (boolean value) {
      this.requestField("place_type", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPlotOutlineField () {
      return this.requestPlotOutlineField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPlotOutlineField (boolean value) {
      this.requestField("plot_outline", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPreferredAudienceField () {
      return this.requestPreferredAudienceField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPreferredAudienceField (boolean value) {
      this.requestField("preferred_audience", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPressContactField () {
      return this.requestPressContactField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPressContactField (boolean value) {
      this.requestField("press_contact", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPriceRangeField () {
      return this.requestPriceRangeField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPriceRangeField (boolean value) {
      this.requestField("price_range", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPrivacyInfoUrlField () {
      return this.requestPrivacyInfoUrlField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPrivacyInfoUrlField (boolean value) {
      this.requestField("privacy_info_url", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestProducedByField () {
      return this.requestProducedByField(true);
    }
    public APIRequestGetGlobalBrandChildren requestProducedByField (boolean value) {
      this.requestField("produced_by", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestProductsField () {
      return this.requestProductsField(true);
    }
    public APIRequestGetGlobalBrandChildren requestProductsField (boolean value) {
      this.requestField("products", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPromotionEligibleField () {
      return this.requestPromotionEligibleField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPromotionEligibleField (boolean value) {
      this.requestField("promotion_eligible", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPromotionIneligibleReasonField () {
      return this.requestPromotionIneligibleReasonField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPromotionIneligibleReasonField (boolean value) {
      this.requestField("promotion_ineligible_reason", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPublicTransitField () {
      return this.requestPublicTransitField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPublicTransitField (boolean value) {
      this.requestField("public_transit", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestRatingCountField () {
      return this.requestRatingCountField(true);
    }
    public APIRequestGetGlobalBrandChildren requestRatingCountField (boolean value) {
      this.requestField("rating_count", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestRecipientField () {
      return this.requestRecipientField(true);
    }
    public APIRequestGetGlobalBrandChildren requestRecipientField (boolean value) {
      this.requestField("recipient", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestRecordLabelField () {
      return this.requestRecordLabelField(true);
    }
    public APIRequestGetGlobalBrandChildren requestRecordLabelField (boolean value) {
      this.requestField("record_label", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestReleaseDateField () {
      return this.requestReleaseDateField(true);
    }
    public APIRequestGetGlobalBrandChildren requestReleaseDateField (boolean value) {
      this.requestField("release_date", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestRestaurantServicesField () {
      return this.requestRestaurantServicesField(true);
    }
    public APIRequestGetGlobalBrandChildren requestRestaurantServicesField (boolean value) {
      this.requestField("restaurant_services", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestRestaurantSpecialtiesField () {
      return this.requestRestaurantSpecialtiesField(true);
    }
    public APIRequestGetGlobalBrandChildren requestRestaurantSpecialtiesField (boolean value) {
      this.requestField("restaurant_specialties", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestScheduleField () {
      return this.requestScheduleField(true);
    }
    public APIRequestGetGlobalBrandChildren requestScheduleField (boolean value) {
      this.requestField("schedule", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestScreenplayByField () {
      return this.requestScreenplayByField(true);
    }
    public APIRequestGetGlobalBrandChildren requestScreenplayByField (boolean value) {
      this.requestField("screenplay_by", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestSeasonField () {
      return this.requestSeasonField(true);
    }
    public APIRequestGetGlobalBrandChildren requestSeasonField (boolean value) {
      this.requestField("season", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestSingleLineAddressField () {
      return this.requestSingleLineAddressField(true);
    }
    public APIRequestGetGlobalBrandChildren requestSingleLineAddressField (boolean value) {
      this.requestField("single_line_address", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestStarringField () {
      return this.requestStarringField(true);
    }
    public APIRequestGetGlobalBrandChildren requestStarringField (boolean value) {
      this.requestField("starring", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestStartInfoField () {
      return this.requestStartInfoField(true);
    }
    public APIRequestGetGlobalBrandChildren requestStartInfoField (boolean value) {
      this.requestField("start_info", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestStoreCodeField () {
      return this.requestStoreCodeField(true);
    }
    public APIRequestGetGlobalBrandChildren requestStoreCodeField (boolean value) {
      this.requestField("store_code", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestStoreLocationDescriptorField () {
      return this.requestStoreLocationDescriptorField(true);
    }
    public APIRequestGetGlobalBrandChildren requestStoreLocationDescriptorField (boolean value) {
      this.requestField("store_location_descriptor", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestStoreNumberField () {
      return this.requestStoreNumberField(true);
    }
    public APIRequestGetGlobalBrandChildren requestStoreNumberField (boolean value) {
      this.requestField("store_number", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestStudioField () {
      return this.requestStudioField(true);
    }
    public APIRequestGetGlobalBrandChildren requestStudioField (boolean value) {
      this.requestField("studio", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestSupportsDonateButtonInLiveVideoField () {
      return this.requestSupportsDonateButtonInLiveVideoField(true);
    }
    public APIRequestGetGlobalBrandChildren requestSupportsDonateButtonInLiveVideoField (boolean value) {
      this.requestField("supports_donate_button_in_live_video", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestTalkingAboutCountField () {
      return this.requestTalkingAboutCountField(true);
    }
    public APIRequestGetGlobalBrandChildren requestTalkingAboutCountField (boolean value) {
      this.requestField("talking_about_count", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestTemporaryStatusField () {
      return this.requestTemporaryStatusField(true);
    }
    public APIRequestGetGlobalBrandChildren requestTemporaryStatusField (boolean value) {
      this.requestField("temporary_status", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestUnreadMessageCountField () {
      return this.requestUnreadMessageCountField(true);
    }
    public APIRequestGetGlobalBrandChildren requestUnreadMessageCountField (boolean value) {
      this.requestField("unread_message_count", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestUnreadNotifCountField () {
      return this.requestUnreadNotifCountField(true);
    }
    public APIRequestGetGlobalBrandChildren requestUnreadNotifCountField (boolean value) {
      this.requestField("unread_notif_count", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestUnseenMessageCountField () {
      return this.requestUnseenMessageCountField(true);
    }
    public APIRequestGetGlobalBrandChildren requestUnseenMessageCountField (boolean value) {
      this.requestField("unseen_message_count", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestUserAccessExpireTimeField () {
      return this.requestUserAccessExpireTimeField(true);
    }
    public APIRequestGetGlobalBrandChildren requestUserAccessExpireTimeField (boolean value) {
      this.requestField("user_access_expire_time", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestUsernameField () {
      return this.requestUsernameField(true);
    }
    public APIRequestGetGlobalBrandChildren requestUsernameField (boolean value) {
      this.requestField("username", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestVerificationStatusField () {
      return this.requestVerificationStatusField(true);
    }
    public APIRequestGetGlobalBrandChildren requestVerificationStatusField (boolean value) {
      this.requestField("verification_status", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestVoipInfoField () {
      return this.requestVoipInfoField(true);
    }
    public APIRequestGetGlobalBrandChildren requestVoipInfoField (boolean value) {
      this.requestField("voip_info", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestWebsiteField () {
      return this.requestWebsiteField(true);
    }
    public APIRequestGetGlobalBrandChildren requestWebsiteField (boolean value) {
      this.requestField("website", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestWereHereCountField () {
      return this.requestWereHereCountField(true);
    }
    public APIRequestGetGlobalBrandChildren requestWereHereCountField (boolean value) {
      this.requestField("were_here_count", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestWhatsappNumberField () {
      return this.requestWhatsappNumberField(true);
    }
    public APIRequestGetGlobalBrandChildren requestWhatsappNumberField (boolean value) {
      this.requestField("whatsapp_number", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestWrittenByField () {
      return this.requestWrittenByField(true);
    }
    public APIRequestGetGlobalBrandChildren requestWrittenByField (boolean value) {
      this.requestField("written_by", value);
      return this;
    }
  }

  public static class APIRequestGetImageCopyrights extends APIRequest<ImageCopyright> {

    APINodeList<ImageCopyright> lastResponse = null;
    @Override
    public APINodeList<ImageCopyright> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "artist",
      "copyright_monitoring_status",
      "creation_time",
      "creator",
      "custom_id",
      "description",
      "filename",
      "id",
      "image",
      "matches_count",
      "original_content_creation_date",
      "ownership_countries",
      "tags",
      "title",
      "update_time",
    };

    @Override
    public APINodeList<ImageCopyright> parseResponse(String response, String header) throws APIException {
      return ImageCopyright.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<ImageCopyright> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<ImageCopyright> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<ImageCopyright>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<ImageCopyright>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<ImageCopyright>>() {
           public APINodeList<ImageCopyright> apply(ResponseWrapper result) {
             try {
               return APIRequestGetImageCopyrights.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetImageCopyrights(String nodeId, APIContext context) {
      super(context, nodeId, "/image_copyrights", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetImageCopyrights setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetImageCopyrights setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetImageCopyrights requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetImageCopyrights requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetImageCopyrights requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetImageCopyrights requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetImageCopyrights requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetImageCopyrights requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetImageCopyrights requestArtistField () {
      return this.requestArtistField(true);
    }
    public APIRequestGetImageCopyrights requestArtistField (boolean value) {
      this.requestField("artist", value);
      return this;
    }
    public APIRequestGetImageCopyrights requestCopyrightMonitoringStatusField () {
      return this.requestCopyrightMonitoringStatusField(true);
    }
    public APIRequestGetImageCopyrights requestCopyrightMonitoringStatusField (boolean value) {
      this.requestField("copyright_monitoring_status", value);
      return this;
    }
    public APIRequestGetImageCopyrights requestCreationTimeField () {
      return this.requestCreationTimeField(true);
    }
    public APIRequestGetImageCopyrights requestCreationTimeField (boolean value) {
      this.requestField("creation_time", value);
      return this;
    }
    public APIRequestGetImageCopyrights requestCreatorField () {
      return this.requestCreatorField(true);
    }
    public APIRequestGetImageCopyrights requestCreatorField (boolean value) {
      this.requestField("creator", value);
      return this;
    }
    public APIRequestGetImageCopyrights requestCustomIdField () {
      return this.requestCustomIdField(true);
    }
    public APIRequestGetImageCopyrights requestCustomIdField (boolean value) {
      this.requestField("custom_id", value);
      return this;
    }
    public APIRequestGetImageCopyrights requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetImageCopyrights requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetImageCopyrights requestFilenameField () {
      return this.requestFilenameField(true);
    }
    public APIRequestGetImageCopyrights requestFilenameField (boolean value) {
      this.requestField("filename", value);
      return this;
    }
    public APIRequestGetImageCopyrights requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetImageCopyrights requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetImageCopyrights requestImageField () {
      return this.requestImageField(true);
    }
    public APIRequestGetImageCopyrights requestImageField (boolean value) {
      this.requestField("image", value);
      return this;
    }
    public APIRequestGetImageCopyrights requestMatchesCountField () {
      return this.requestMatchesCountField(true);
    }
    public APIRequestGetImageCopyrights requestMatchesCountField (boolean value) {
      this.requestField("matches_count", value);
      return this;
    }
    public APIRequestGetImageCopyrights requestOriginalContentCreationDateField () {
      return this.requestOriginalContentCreationDateField(true);
    }
    public APIRequestGetImageCopyrights requestOriginalContentCreationDateField (boolean value) {
      this.requestField("original_content_creation_date", value);
      return this;
    }
    public APIRequestGetImageCopyrights requestOwnershipCountriesField () {
      return this.requestOwnershipCountriesField(true);
    }
    public APIRequestGetImageCopyrights requestOwnershipCountriesField (boolean value) {
      this.requestField("ownership_countries", value);
      return this;
    }
    public APIRequestGetImageCopyrights requestTagsField () {
      return this.requestTagsField(true);
    }
    public APIRequestGetImageCopyrights requestTagsField (boolean value) {
      this.requestField("tags", value);
      return this;
    }
    public APIRequestGetImageCopyrights requestTitleField () {
      return this.requestTitleField(true);
    }
    public APIRequestGetImageCopyrights requestTitleField (boolean value) {
      this.requestField("title", value);
      return this;
    }
    public APIRequestGetImageCopyrights requestUpdateTimeField () {
      return this.requestUpdateTimeField(true);
    }
    public APIRequestGetImageCopyrights requestUpdateTimeField (boolean value) {
      this.requestField("update_time", value);
      return this;
    }
  }

  public static class APIRequestCreateImageCopyright extends APIRequest<ImageCopyright> {

    ImageCopyright lastResponse = null;
    @Override
    public ImageCopyright getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "artist",
      "attribution_link",
      "creator",
      "custom_id",
      "description",
      "filename",
      "geo_ownership",
      "original_content_creation_date",
      "reference_photo",
      "title",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public ImageCopyright parseResponse(String response, String header) throws APIException {
      return ImageCopyright.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public ImageCopyright execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public ImageCopyright execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<ImageCopyright> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<ImageCopyright> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, ImageCopyright>() {
           public ImageCopyright apply(ResponseWrapper result) {
             try {
               return APIRequestCreateImageCopyright.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateImageCopyright(String nodeId, APIContext context) {
      super(context, nodeId, "/image_copyrights", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateImageCopyright setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateImageCopyright setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateImageCopyright setArtist (String artist) {
      this.setParam("artist", artist);
      return this;
    }

    public APIRequestCreateImageCopyright setAttributionLink (String attributionLink) {
      this.setParam("attribution_link", attributionLink);
      return this;
    }

    public APIRequestCreateImageCopyright setCreator (String creator) {
      this.setParam("creator", creator);
      return this;
    }

    public APIRequestCreateImageCopyright setCustomId (String customId) {
      this.setParam("custom_id", customId);
      return this;
    }

    public APIRequestCreateImageCopyright setDescription (String description) {
      this.setParam("description", description);
      return this;
    }

    public APIRequestCreateImageCopyright setFilename (String filename) {
      this.setParam("filename", filename);
      return this;
    }

    public APIRequestCreateImageCopyright setGeoOwnership (List<ImageCopyright.EnumGeoOwnership> geoOwnership) {
      this.setParam("geo_ownership", geoOwnership);
      return this;
    }
    public APIRequestCreateImageCopyright setGeoOwnership (String geoOwnership) {
      this.setParam("geo_ownership", geoOwnership);
      return this;
    }

    public APIRequestCreateImageCopyright setOriginalContentCreationDate (Long originalContentCreationDate) {
      this.setParam("original_content_creation_date", originalContentCreationDate);
      return this;
    }
    public APIRequestCreateImageCopyright setOriginalContentCreationDate (String originalContentCreationDate) {
      this.setParam("original_content_creation_date", originalContentCreationDate);
      return this;
    }

    public APIRequestCreateImageCopyright setReferencePhoto (String referencePhoto) {
      this.setParam("reference_photo", referencePhoto);
      return this;
    }

    public APIRequestCreateImageCopyright setTitle (String title) {
      this.setParam("title", title);
      return this;
    }

    public APIRequestCreateImageCopyright requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateImageCopyright requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateImageCopyright requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateImageCopyright requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateImageCopyright requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateImageCopyright requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetIndexedVideos extends APIRequest<AdVideo> {

    APINodeList<AdVideo> lastResponse = null;
    @Override
    public APINodeList<AdVideo> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "ad_breaks",
      "admin_creator",
      "audio_isrc",
      "backdated_time",
      "backdated_time_granularity",
      "boost_eligibility_info",
      "content_category",
      "content_tags",
      "copyright",
      "copyright_check_information",
      "copyright_monitoring_status",
      "created_time",
      "custom_labels",
      "description",
      "embed_html",
      "embeddable",
      "event",
      "expiration",
      "format",
      "from",
      "icon",
      "id",
      "is_crosspost_video",
      "is_crossposting_eligible",
      "is_episode",
      "is_instagram_eligible",
      "is_reference_only",
      "length",
      "live_audience_count",
      "live_status",
      "music_video_copyright",
      "permalink_url",
      "picture",
      "place",
      "post_id",
      "post_views",
      "premiere_living_room_status",
      "privacy",
      "published",
      "scheduled_publish_time",
      "season",
      "source",
      "spherical",
      "status",
      "title",
      "universal_video_id",
      "updated_time",
      "views",
    };

    @Override
    public APINodeList<AdVideo> parseResponse(String response, String header) throws APIException {
      return AdVideo.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<AdVideo> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<AdVideo> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<AdVideo>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<AdVideo>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<AdVideo>>() {
           public APINodeList<AdVideo> apply(ResponseWrapper result) {
             try {
               return APIRequestGetIndexedVideos.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetIndexedVideos(String nodeId, APIContext context) {
      super(context, nodeId, "/indexed_videos", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetIndexedVideos setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetIndexedVideos setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetIndexedVideos requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetIndexedVideos requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetIndexedVideos requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetIndexedVideos requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetIndexedVideos requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetIndexedVideos requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetIndexedVideos requestAdBreaksField () {
      return this.requestAdBreaksField(true);
    }
    public APIRequestGetIndexedVideos requestAdBreaksField (boolean value) {
      this.requestField("ad_breaks", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestAdminCreatorField () {
      return this.requestAdminCreatorField(true);
    }
    public APIRequestGetIndexedVideos requestAdminCreatorField (boolean value) {
      this.requestField("admin_creator", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestAudioIsrcField () {
      return this.requestAudioIsrcField(true);
    }
    public APIRequestGetIndexedVideos requestAudioIsrcField (boolean value) {
      this.requestField("audio_isrc", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestBackdatedTimeField () {
      return this.requestBackdatedTimeField(true);
    }
    public APIRequestGetIndexedVideos requestBackdatedTimeField (boolean value) {
      this.requestField("backdated_time", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestBackdatedTimeGranularityField () {
      return this.requestBackdatedTimeGranularityField(true);
    }
    public APIRequestGetIndexedVideos requestBackdatedTimeGranularityField (boolean value) {
      this.requestField("backdated_time_granularity", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestBoostEligibilityInfoField () {
      return this.requestBoostEligibilityInfoField(true);
    }
    public APIRequestGetIndexedVideos requestBoostEligibilityInfoField (boolean value) {
      this.requestField("boost_eligibility_info", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestContentCategoryField () {
      return this.requestContentCategoryField(true);
    }
    public APIRequestGetIndexedVideos requestContentCategoryField (boolean value) {
      this.requestField("content_category", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestContentTagsField () {
      return this.requestContentTagsField(true);
    }
    public APIRequestGetIndexedVideos requestContentTagsField (boolean value) {
      this.requestField("content_tags", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestCopyrightField () {
      return this.requestCopyrightField(true);
    }
    public APIRequestGetIndexedVideos requestCopyrightField (boolean value) {
      this.requestField("copyright", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestCopyrightCheckInformationField () {
      return this.requestCopyrightCheckInformationField(true);
    }
    public APIRequestGetIndexedVideos requestCopyrightCheckInformationField (boolean value) {
      this.requestField("copyright_check_information", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestCopyrightMonitoringStatusField () {
      return this.requestCopyrightMonitoringStatusField(true);
    }
    public APIRequestGetIndexedVideos requestCopyrightMonitoringStatusField (boolean value) {
      this.requestField("copyright_monitoring_status", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestCreatedTimeField () {
      return this.requestCreatedTimeField(true);
    }
    public APIRequestGetIndexedVideos requestCreatedTimeField (boolean value) {
      this.requestField("created_time", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestCustomLabelsField () {
      return this.requestCustomLabelsField(true);
    }
    public APIRequestGetIndexedVideos requestCustomLabelsField (boolean value) {
      this.requestField("custom_labels", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetIndexedVideos requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestEmbedHtmlField () {
      return this.requestEmbedHtmlField(true);
    }
    public APIRequestGetIndexedVideos requestEmbedHtmlField (boolean value) {
      this.requestField("embed_html", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestEmbeddableField () {
      return this.requestEmbeddableField(true);
    }
    public APIRequestGetIndexedVideos requestEmbeddableField (boolean value) {
      this.requestField("embeddable", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestEventField () {
      return this.requestEventField(true);
    }
    public APIRequestGetIndexedVideos requestEventField (boolean value) {
      this.requestField("event", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestExpirationField () {
      return this.requestExpirationField(true);
    }
    public APIRequestGetIndexedVideos requestExpirationField (boolean value) {
      this.requestField("expiration", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestFormatField () {
      return this.requestFormatField(true);
    }
    public APIRequestGetIndexedVideos requestFormatField (boolean value) {
      this.requestField("format", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestFromField () {
      return this.requestFromField(true);
    }
    public APIRequestGetIndexedVideos requestFromField (boolean value) {
      this.requestField("from", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestIconField () {
      return this.requestIconField(true);
    }
    public APIRequestGetIndexedVideos requestIconField (boolean value) {
      this.requestField("icon", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetIndexedVideos requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestIsCrosspostVideoField () {
      return this.requestIsCrosspostVideoField(true);
    }
    public APIRequestGetIndexedVideos requestIsCrosspostVideoField (boolean value) {
      this.requestField("is_crosspost_video", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestIsCrosspostingEligibleField () {
      return this.requestIsCrosspostingEligibleField(true);
    }
    public APIRequestGetIndexedVideos requestIsCrosspostingEligibleField (boolean value) {
      this.requestField("is_crossposting_eligible", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestIsEpisodeField () {
      return this.requestIsEpisodeField(true);
    }
    public APIRequestGetIndexedVideos requestIsEpisodeField (boolean value) {
      this.requestField("is_episode", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestIsInstagramEligibleField () {
      return this.requestIsInstagramEligibleField(true);
    }
    public APIRequestGetIndexedVideos requestIsInstagramEligibleField (boolean value) {
      this.requestField("is_instagram_eligible", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestIsReferenceOnlyField () {
      return this.requestIsReferenceOnlyField(true);
    }
    public APIRequestGetIndexedVideos requestIsReferenceOnlyField (boolean value) {
      this.requestField("is_reference_only", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestLengthField () {
      return this.requestLengthField(true);
    }
    public APIRequestGetIndexedVideos requestLengthField (boolean value) {
      this.requestField("length", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestLiveAudienceCountField () {
      return this.requestLiveAudienceCountField(true);
    }
    public APIRequestGetIndexedVideos requestLiveAudienceCountField (boolean value) {
      this.requestField("live_audience_count", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestLiveStatusField () {
      return this.requestLiveStatusField(true);
    }
    public APIRequestGetIndexedVideos requestLiveStatusField (boolean value) {
      this.requestField("live_status", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestMusicVideoCopyrightField () {
      return this.requestMusicVideoCopyrightField(true);
    }
    public APIRequestGetIndexedVideos requestMusicVideoCopyrightField (boolean value) {
      this.requestField("music_video_copyright", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestPermalinkUrlField () {
      return this.requestPermalinkUrlField(true);
    }
    public APIRequestGetIndexedVideos requestPermalinkUrlField (boolean value) {
      this.requestField("permalink_url", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestPictureField () {
      return this.requestPictureField(true);
    }
    public APIRequestGetIndexedVideos requestPictureField (boolean value) {
      this.requestField("picture", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestPlaceField () {
      return this.requestPlaceField(true);
    }
    public APIRequestGetIndexedVideos requestPlaceField (boolean value) {
      this.requestField("place", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestPostIdField () {
      return this.requestPostIdField(true);
    }
    public APIRequestGetIndexedVideos requestPostIdField (boolean value) {
      this.requestField("post_id", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestPostViewsField () {
      return this.requestPostViewsField(true);
    }
    public APIRequestGetIndexedVideos requestPostViewsField (boolean value) {
      this.requestField("post_views", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestPremiereLivingRoomStatusField () {
      return this.requestPremiereLivingRoomStatusField(true);
    }
    public APIRequestGetIndexedVideos requestPremiereLivingRoomStatusField (boolean value) {
      this.requestField("premiere_living_room_status", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestPrivacyField () {
      return this.requestPrivacyField(true);
    }
    public APIRequestGetIndexedVideos requestPrivacyField (boolean value) {
      this.requestField("privacy", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestPublishedField () {
      return this.requestPublishedField(true);
    }
    public APIRequestGetIndexedVideos requestPublishedField (boolean value) {
      this.requestField("published", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestScheduledPublishTimeField () {
      return this.requestScheduledPublishTimeField(true);
    }
    public APIRequestGetIndexedVideos requestScheduledPublishTimeField (boolean value) {
      this.requestField("scheduled_publish_time", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestSeasonField () {
      return this.requestSeasonField(true);
    }
    public APIRequestGetIndexedVideos requestSeasonField (boolean value) {
      this.requestField("season", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestSourceField () {
      return this.requestSourceField(true);
    }
    public APIRequestGetIndexedVideos requestSourceField (boolean value) {
      this.requestField("source", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestSphericalField () {
      return this.requestSphericalField(true);
    }
    public APIRequestGetIndexedVideos requestSphericalField (boolean value) {
      this.requestField("spherical", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestStatusField () {
      return this.requestStatusField(true);
    }
    public APIRequestGetIndexedVideos requestStatusField (boolean value) {
      this.requestField("status", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestTitleField () {
      return this.requestTitleField(true);
    }
    public APIRequestGetIndexedVideos requestTitleField (boolean value) {
      this.requestField("title", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestUniversalVideoIdField () {
      return this.requestUniversalVideoIdField(true);
    }
    public APIRequestGetIndexedVideos requestUniversalVideoIdField (boolean value) {
      this.requestField("universal_video_id", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestUpdatedTimeField () {
      return this.requestUpdatedTimeField(true);
    }
    public APIRequestGetIndexedVideos requestUpdatedTimeField (boolean value) {
      this.requestField("updated_time", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestViewsField () {
      return this.requestViewsField(true);
    }
    public APIRequestGetIndexedVideos requestViewsField (boolean value) {
      this.requestField("views", value);
      return this;
    }
  }

  public static class APIRequestGetInsights extends APIRequest<InsightsResult> {

    APINodeList<InsightsResult> lastResponse = null;
    @Override
    public APINodeList<InsightsResult> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "breakdown",
      "date_preset",
      "metric",
      "period",
      "show_description_from_api_doc",
      "since",
      "until",
    };

    public static final String[] FIELDS = {
      "description",
      "description_from_api_doc",
      "id",
      "name",
      "period",
      "title",
      "values",
    };

    @Override
    public APINodeList<InsightsResult> parseResponse(String response, String header) throws APIException {
      return InsightsResult.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<InsightsResult> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<InsightsResult> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<InsightsResult>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<InsightsResult>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<InsightsResult>>() {
           public APINodeList<InsightsResult> apply(ResponseWrapper result) {
             try {
               return APIRequestGetInsights.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetInsights(String nodeId, APIContext context) {
      super(context, nodeId, "/insights", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetInsights setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetInsights setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetInsights setBreakdown (List<Object> breakdown) {
      this.setParam("breakdown", breakdown);
      return this;
    }
    public APIRequestGetInsights setBreakdown (String breakdown) {
      this.setParam("breakdown", breakdown);
      return this;
    }

    public APIRequestGetInsights setDatePreset (InsightsResult.EnumDatePreset datePreset) {
      this.setParam("date_preset", datePreset);
      return this;
    }
    public APIRequestGetInsights setDatePreset (String datePreset) {
      this.setParam("date_preset", datePreset);
      return this;
    }

    public APIRequestGetInsights setMetric (List<Object> metric) {
      this.setParam("metric", metric);
      return this;
    }
    public APIRequestGetInsights setMetric (String metric) {
      this.setParam("metric", metric);
      return this;
    }

    public APIRequestGetInsights setPeriod (InsightsResult.EnumPeriod period) {
      this.setParam("period", period);
      return this;
    }
    public APIRequestGetInsights setPeriod (String period) {
      this.setParam("period", period);
      return this;
    }

    public APIRequestGetInsights setShowDescriptionFromApiDoc (Boolean showDescriptionFromApiDoc) {
      this.setParam("show_description_from_api_doc", showDescriptionFromApiDoc);
      return this;
    }
    public APIRequestGetInsights setShowDescriptionFromApiDoc (String showDescriptionFromApiDoc) {
      this.setParam("show_description_from_api_doc", showDescriptionFromApiDoc);
      return this;
    }

    public APIRequestGetInsights setSince (String since) {
      this.setParam("since", since);
      return this;
    }

    public APIRequestGetInsights setUntil (String until) {
      this.setParam("until", until);
      return this;
    }

    public APIRequestGetInsights requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetInsights requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetInsights requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetInsights requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetInsights requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetInsights requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetInsights requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetInsights requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetInsights requestDescriptionFromApiDocField () {
      return this.requestDescriptionFromApiDocField(true);
    }
    public APIRequestGetInsights requestDescriptionFromApiDocField (boolean value) {
      this.requestField("description_from_api_doc", value);
      return this;
    }
    public APIRequestGetInsights requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetInsights requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetInsights requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetInsights requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetInsights requestPeriodField () {
      return this.requestPeriodField(true);
    }
    public APIRequestGetInsights requestPeriodField (boolean value) {
      this.requestField("period", value);
      return this;
    }
    public APIRequestGetInsights requestTitleField () {
      return this.requestTitleField(true);
    }
    public APIRequestGetInsights requestTitleField (boolean value) {
      this.requestField("title", value);
      return this;
    }
    public APIRequestGetInsights requestValuesField () {
      return this.requestValuesField(true);
    }
    public APIRequestGetInsights requestValuesField (boolean value) {
      this.requestField("values", value);
      return this;
    }
  }

  public static class APIRequestGetInstagramAccounts extends APIRequest<IGUser> {

    APINodeList<IGUser> lastResponse = null;
    @Override
    public APINodeList<IGUser> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "biography",
      "business_discovery",
      "followers_count",
      "follows_count",
      "has_profile_pic",
      "id",
      "ig_id",
      "is_published",
      "legacy_instagram_user_id",
      "media_count",
      "mentioned_comment",
      "mentioned_media",
      "name",
      "owner_business",
      "profile_picture_url",
      "shopping_product_tag_eligibility",
      "shopping_review_status",
      "username",
      "website",
    };

    @Override
    public APINodeList<IGUser> parseResponse(String response, String header) throws APIException {
      return IGUser.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<IGUser> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<IGUser> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<IGUser>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<IGUser>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<IGUser>>() {
           public APINodeList<IGUser> apply(ResponseWrapper result) {
             try {
               return APIRequestGetInstagramAccounts.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetInstagramAccounts(String nodeId, APIContext context) {
      super(context, nodeId, "/instagram_accounts", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetInstagramAccounts setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetInstagramAccounts setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetInstagramAccounts requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetInstagramAccounts requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetInstagramAccounts requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetInstagramAccounts requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetInstagramAccounts requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetInstagramAccounts requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetInstagramAccounts requestBiographyField () {
      return this.requestBiographyField(true);
    }
    public APIRequestGetInstagramAccounts requestBiographyField (boolean value) {
      this.requestField("biography", value);
      return this;
    }
    public APIRequestGetInstagramAccounts requestBusinessDiscoveryField () {
      return this.requestBusinessDiscoveryField(true);
    }
    public APIRequestGetInstagramAccounts requestBusinessDiscoveryField (boolean value) {
      this.requestField("business_discovery", value);
      return this;
    }
    public APIRequestGetInstagramAccounts requestFollowersCountField () {
      return this.requestFollowersCountField(true);
    }
    public APIRequestGetInstagramAccounts requestFollowersCountField (boolean value) {
      this.requestField("followers_count", value);
      return this;
    }
    public APIRequestGetInstagramAccounts requestFollowsCountField () {
      return this.requestFollowsCountField(true);
    }
    public APIRequestGetInstagramAccounts requestFollowsCountField (boolean value) {
      this.requestField("follows_count", value);
      return this;
    }
    public APIRequestGetInstagramAccounts requestHasProfilePicField () {
      return this.requestHasProfilePicField(true);
    }
    public APIRequestGetInstagramAccounts requestHasProfilePicField (boolean value) {
      this.requestField("has_profile_pic", value);
      return this;
    }
    public APIRequestGetInstagramAccounts requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetInstagramAccounts requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetInstagramAccounts requestIgIdField () {
      return this.requestIgIdField(true);
    }
    public APIRequestGetInstagramAccounts requestIgIdField (boolean value) {
      this.requestField("ig_id", value);
      return this;
    }
    public APIRequestGetInstagramAccounts requestIsPublishedField () {
      return this.requestIsPublishedField(true);
    }
    public APIRequestGetInstagramAccounts requestIsPublishedField (boolean value) {
      this.requestField("is_published", value);
      return this;
    }
    public APIRequestGetInstagramAccounts requestLegacyInstagramUserIdField () {
      return this.requestLegacyInstagramUserIdField(true);
    }
    public APIRequestGetInstagramAccounts requestLegacyInstagramUserIdField (boolean value) {
      this.requestField("legacy_instagram_user_id", value);
      return this;
    }
    public APIRequestGetInstagramAccounts requestMediaCountField () {
      return this.requestMediaCountField(true);
    }
    public APIRequestGetInstagramAccounts requestMediaCountField (boolean value) {
      this.requestField("media_count", value);
      return this;
    }
    public APIRequestGetInstagramAccounts requestMentionedCommentField () {
      return this.requestMentionedCommentField(true);
    }
    public APIRequestGetInstagramAccounts requestMentionedCommentField (boolean value) {
      this.requestField("mentioned_comment", value);
      return this;
    }
    public APIRequestGetInstagramAccounts requestMentionedMediaField () {
      return this.requestMentionedMediaField(true);
    }
    public APIRequestGetInstagramAccounts requestMentionedMediaField (boolean value) {
      this.requestField("mentioned_media", value);
      return this;
    }
    public APIRequestGetInstagramAccounts requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetInstagramAccounts requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetInstagramAccounts requestOwnerBusinessField () {
      return this.requestOwnerBusinessField(true);
    }
    public APIRequestGetInstagramAccounts requestOwnerBusinessField (boolean value) {
      this.requestField("owner_business", value);
      return this;
    }
    public APIRequestGetInstagramAccounts requestProfilePictureUrlField () {
      return this.requestProfilePictureUrlField(true);
    }
    public APIRequestGetInstagramAccounts requestProfilePictureUrlField (boolean value) {
      this.requestField("profile_picture_url", value);
      return this;
    }
    public APIRequestGetInstagramAccounts requestShoppingProductTagEligibilityField () {
      return this.requestShoppingProductTagEligibilityField(true);
    }
    public APIRequestGetInstagramAccounts requestShoppingProductTagEligibilityField (boolean value) {
      this.requestField("shopping_product_tag_eligibility", value);
      return this;
    }
    public APIRequestGetInstagramAccounts requestShoppingReviewStatusField () {
      return this.requestShoppingReviewStatusField(true);
    }
    public APIRequestGetInstagramAccounts requestShoppingReviewStatusField (boolean value) {
      this.requestField("shopping_review_status", value);
      return this;
    }
    public APIRequestGetInstagramAccounts requestUsernameField () {
      return this.requestUsernameField(true);
    }
    public APIRequestGetInstagramAccounts requestUsernameField (boolean value) {
      this.requestField("username", value);
      return this;
    }
    public APIRequestGetInstagramAccounts requestWebsiteField () {
      return this.requestWebsiteField(true);
    }
    public APIRequestGetInstagramAccounts requestWebsiteField (boolean value) {
      this.requestField("website", value);
      return this;
    }
  }

  public static class APIRequestGetLeadGenForms extends APIRequest<LeadgenForm> {

    APINodeList<LeadgenForm> lastResponse = null;
    @Override
    public APINodeList<LeadgenForm> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "allow_organic_lead",
      "block_display_for_non_targeted_viewer",
      "context_card",
      "created_time",
      "creator",
      "expired_leads_count",
      "follow_up_action_text",
      "follow_up_action_url",
      "id",
      "is_optimized_for_quality",
      "leads_count",
      "legal_content",
      "locale",
      "name",
      "organic_leads_count",
      "page",
      "page_id",
      "privacy_policy_url",
      "question_page_custom_headline",
      "questions",
      "status",
      "thank_you_page",
      "tracking_parameters",
    };

    @Override
    public APINodeList<LeadgenForm> parseResponse(String response, String header) throws APIException {
      return LeadgenForm.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<LeadgenForm> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<LeadgenForm> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<LeadgenForm>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<LeadgenForm>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<LeadgenForm>>() {
           public APINodeList<LeadgenForm> apply(ResponseWrapper result) {
             try {
               return APIRequestGetLeadGenForms.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetLeadGenForms(String nodeId, APIContext context) {
      super(context, nodeId, "/leadgen_forms", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetLeadGenForms setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetLeadGenForms setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetLeadGenForms requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetLeadGenForms requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLeadGenForms requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetLeadGenForms requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLeadGenForms requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetLeadGenForms requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetLeadGenForms requestAllowOrganicLeadField () {
      return this.requestAllowOrganicLeadField(true);
    }
    public APIRequestGetLeadGenForms requestAllowOrganicLeadField (boolean value) {
      this.requestField("allow_organic_lead", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestBlockDisplayForNonTargetedViewerField () {
      return this.requestBlockDisplayForNonTargetedViewerField(true);
    }
    public APIRequestGetLeadGenForms requestBlockDisplayForNonTargetedViewerField (boolean value) {
      this.requestField("block_display_for_non_targeted_viewer", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestContextCardField () {
      return this.requestContextCardField(true);
    }
    public APIRequestGetLeadGenForms requestContextCardField (boolean value) {
      this.requestField("context_card", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestCreatedTimeField () {
      return this.requestCreatedTimeField(true);
    }
    public APIRequestGetLeadGenForms requestCreatedTimeField (boolean value) {
      this.requestField("created_time", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestCreatorField () {
      return this.requestCreatorField(true);
    }
    public APIRequestGetLeadGenForms requestCreatorField (boolean value) {
      this.requestField("creator", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestExpiredLeadsCountField () {
      return this.requestExpiredLeadsCountField(true);
    }
    public APIRequestGetLeadGenForms requestExpiredLeadsCountField (boolean value) {
      this.requestField("expired_leads_count", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestFollowUpActionTextField () {
      return this.requestFollowUpActionTextField(true);
    }
    public APIRequestGetLeadGenForms requestFollowUpActionTextField (boolean value) {
      this.requestField("follow_up_action_text", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestFollowUpActionUrlField () {
      return this.requestFollowUpActionUrlField(true);
    }
    public APIRequestGetLeadGenForms requestFollowUpActionUrlField (boolean value) {
      this.requestField("follow_up_action_url", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetLeadGenForms requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestIsOptimizedForQualityField () {
      return this.requestIsOptimizedForQualityField(true);
    }
    public APIRequestGetLeadGenForms requestIsOptimizedForQualityField (boolean value) {
      this.requestField("is_optimized_for_quality", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestLeadsCountField () {
      return this.requestLeadsCountField(true);
    }
    public APIRequestGetLeadGenForms requestLeadsCountField (boolean value) {
      this.requestField("leads_count", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestLegalContentField () {
      return this.requestLegalContentField(true);
    }
    public APIRequestGetLeadGenForms requestLegalContentField (boolean value) {
      this.requestField("legal_content", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestLocaleField () {
      return this.requestLocaleField(true);
    }
    public APIRequestGetLeadGenForms requestLocaleField (boolean value) {
      this.requestField("locale", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetLeadGenForms requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestOrganicLeadsCountField () {
      return this.requestOrganicLeadsCountField(true);
    }
    public APIRequestGetLeadGenForms requestOrganicLeadsCountField (boolean value) {
      this.requestField("organic_leads_count", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestPageField () {
      return this.requestPageField(true);
    }
    public APIRequestGetLeadGenForms requestPageField (boolean value) {
      this.requestField("page", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestPageIdField () {
      return this.requestPageIdField(true);
    }
    public APIRequestGetLeadGenForms requestPageIdField (boolean value) {
      this.requestField("page_id", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestPrivacyPolicyUrlField () {
      return this.requestPrivacyPolicyUrlField(true);
    }
    public APIRequestGetLeadGenForms requestPrivacyPolicyUrlField (boolean value) {
      this.requestField("privacy_policy_url", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestQuestionPageCustomHeadlineField () {
      return this.requestQuestionPageCustomHeadlineField(true);
    }
    public APIRequestGetLeadGenForms requestQuestionPageCustomHeadlineField (boolean value) {
      this.requestField("question_page_custom_headline", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestQuestionsField () {
      return this.requestQuestionsField(true);
    }
    public APIRequestGetLeadGenForms requestQuestionsField (boolean value) {
      this.requestField("questions", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestStatusField () {
      return this.requestStatusField(true);
    }
    public APIRequestGetLeadGenForms requestStatusField (boolean value) {
      this.requestField("status", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestThankYouPageField () {
      return this.requestThankYouPageField(true);
    }
    public APIRequestGetLeadGenForms requestThankYouPageField (boolean value) {
      this.requestField("thank_you_page", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestTrackingParametersField () {
      return this.requestTrackingParametersField(true);
    }
    public APIRequestGetLeadGenForms requestTrackingParametersField (boolean value) {
      this.requestField("tracking_parameters", value);
      return this;
    }
  }

  public static class APIRequestCreateLeadGenForm extends APIRequest<LeadgenForm> {

    LeadgenForm lastResponse = null;
    @Override
    public LeadgenForm getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "allow_organic_lead_retrieval",
      "block_display_for_non_targeted_viewer",
      "context_card",
      "cover_photo",
      "custom_disclaimer",
      "follow_up_action_url",
      "is_for_canvas",
      "is_optimized_for_quality",
      "is_phone_sms_verify_enabled",
      "locale",
      "name",
      "privacy_policy",
      "question_page_custom_headline",
      "questions",
      "should_enforce_work_email",
      "thank_you_page",
      "tracking_parameters",
      "upload_gated_file",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public LeadgenForm parseResponse(String response, String header) throws APIException {
      return LeadgenForm.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public LeadgenForm execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public LeadgenForm execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<LeadgenForm> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<LeadgenForm> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, LeadgenForm>() {
           public LeadgenForm apply(ResponseWrapper result) {
             try {
               return APIRequestCreateLeadGenForm.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateLeadGenForm(String nodeId, APIContext context) {
      super(context, nodeId, "/leadgen_forms", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateLeadGenForm setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateLeadGenForm setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateLeadGenForm setAllowOrganicLeadRetrieval (Boolean allowOrganicLeadRetrieval) {
      this.setParam("allow_organic_lead_retrieval", allowOrganicLeadRetrieval);
      return this;
    }
    public APIRequestCreateLeadGenForm setAllowOrganicLeadRetrieval (String allowOrganicLeadRetrieval) {
      this.setParam("allow_organic_lead_retrieval", allowOrganicLeadRetrieval);
      return this;
    }

    public APIRequestCreateLeadGenForm setBlockDisplayForNonTargetedViewer (Boolean blockDisplayForNonTargetedViewer) {
      this.setParam("block_display_for_non_targeted_viewer", blockDisplayForNonTargetedViewer);
      return this;
    }
    public APIRequestCreateLeadGenForm setBlockDisplayForNonTargetedViewer (String blockDisplayForNonTargetedViewer) {
      this.setParam("block_display_for_non_targeted_viewer", blockDisplayForNonTargetedViewer);
      return this;
    }

    public APIRequestCreateLeadGenForm setContextCard (Object contextCard) {
      this.setParam("context_card", contextCard);
      return this;
    }
    public APIRequestCreateLeadGenForm setContextCard (String contextCard) {
      this.setParam("context_card", contextCard);
      return this;
    }

    public APIRequestCreateLeadGenForm setCoverPhoto (File coverPhoto) {
      this.setParam("cover_photo", coverPhoto);
      return this;
    }
    public APIRequestCreateLeadGenForm setCoverPhoto (String coverPhoto) {
      this.setParam("cover_photo", coverPhoto);
      return this;
    }

    public APIRequestCreateLeadGenForm setCustomDisclaimer (Object customDisclaimer) {
      this.setParam("custom_disclaimer", customDisclaimer);
      return this;
    }
    public APIRequestCreateLeadGenForm setCustomDisclaimer (String customDisclaimer) {
      this.setParam("custom_disclaimer", customDisclaimer);
      return this;
    }

    public APIRequestCreateLeadGenForm setFollowUpActionUrl (String followUpActionUrl) {
      this.setParam("follow_up_action_url", followUpActionUrl);
      return this;
    }

    public APIRequestCreateLeadGenForm setIsForCanvas (Boolean isForCanvas) {
      this.setParam("is_for_canvas", isForCanvas);
      return this;
    }
    public APIRequestCreateLeadGenForm setIsForCanvas (String isForCanvas) {
      this.setParam("is_for_canvas", isForCanvas);
      return this;
    }

    public APIRequestCreateLeadGenForm setIsOptimizedForQuality (Boolean isOptimizedForQuality) {
      this.setParam("is_optimized_for_quality", isOptimizedForQuality);
      return this;
    }
    public APIRequestCreateLeadGenForm setIsOptimizedForQuality (String isOptimizedForQuality) {
      this.setParam("is_optimized_for_quality", isOptimizedForQuality);
      return this;
    }

    public APIRequestCreateLeadGenForm setIsPhoneSmsVerifyEnabled (Boolean isPhoneSmsVerifyEnabled) {
      this.setParam("is_phone_sms_verify_enabled", isPhoneSmsVerifyEnabled);
      return this;
    }
    public APIRequestCreateLeadGenForm setIsPhoneSmsVerifyEnabled (String isPhoneSmsVerifyEnabled) {
      this.setParam("is_phone_sms_verify_enabled", isPhoneSmsVerifyEnabled);
      return this;
    }

    public APIRequestCreateLeadGenForm setLocale (LeadgenForm.EnumLocale locale) {
      this.setParam("locale", locale);
      return this;
    }
    public APIRequestCreateLeadGenForm setLocale (String locale) {
      this.setParam("locale", locale);
      return this;
    }

    public APIRequestCreateLeadGenForm setName (String name) {
      this.setParam("name", name);
      return this;
    }

    public APIRequestCreateLeadGenForm setPrivacyPolicy (Object privacyPolicy) {
      this.setParam("privacy_policy", privacyPolicy);
      return this;
    }
    public APIRequestCreateLeadGenForm setPrivacyPolicy (String privacyPolicy) {
      this.setParam("privacy_policy", privacyPolicy);
      return this;
    }

    public APIRequestCreateLeadGenForm setQuestionPageCustomHeadline (String questionPageCustomHeadline) {
      this.setParam("question_page_custom_headline", questionPageCustomHeadline);
      return this;
    }

    public APIRequestCreateLeadGenForm setQuestions (List<Object> questions) {
      this.setParam("questions", questions);
      return this;
    }
    public APIRequestCreateLeadGenForm setQuestions (String questions) {
      this.setParam("questions", questions);
      return this;
    }

    public APIRequestCreateLeadGenForm setShouldEnforceWorkEmail (Boolean shouldEnforceWorkEmail) {
      this.setParam("should_enforce_work_email", shouldEnforceWorkEmail);
      return this;
    }
    public APIRequestCreateLeadGenForm setShouldEnforceWorkEmail (String shouldEnforceWorkEmail) {
      this.setParam("should_enforce_work_email", shouldEnforceWorkEmail);
      return this;
    }

    public APIRequestCreateLeadGenForm setThankYouPage (Object thankYouPage) {
      this.setParam("thank_you_page", thankYouPage);
      return this;
    }
    public APIRequestCreateLeadGenForm setThankYouPage (String thankYouPage) {
      this.setParam("thank_you_page", thankYouPage);
      return this;
    }

    public APIRequestCreateLeadGenForm setTrackingParameters (Map<String, String> trackingParameters) {
      this.setParam("tracking_parameters", trackingParameters);
      return this;
    }
    public APIRequestCreateLeadGenForm setTrackingParameters (String trackingParameters) {
      this.setParam("tracking_parameters", trackingParameters);
      return this;
    }

    public APIRequestCreateLeadGenForm setUploadGatedFile (File uploadGatedFile) {
      this.setParam("upload_gated_file", uploadGatedFile);
      return this;
    }
    public APIRequestCreateLeadGenForm setUploadGatedFile (String uploadGatedFile) {
      this.setParam("upload_gated_file", uploadGatedFile);
      return this;
    }

    public APIRequestCreateLeadGenForm requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateLeadGenForm requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLeadGenForm requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateLeadGenForm requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLeadGenForm requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateLeadGenForm requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetLikes extends APIRequest<Page> {

    APINodeList<Page> lastResponse = null;
    @Override
    public APINodeList<Page> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "target_id",
    };

    public static final String[] FIELDS = {
      "about",
      "access_token",
      "ad_campaign",
      "affiliation",
      "app_id",
      "artists_we_like",
      "attire",
      "available_promo_offer_ids",
      "awards",
      "band_interests",
      "band_members",
      "best_page",
      "bio",
      "birthday",
      "booking_agent",
      "breaking_news_usage",
      "built",
      "business",
      "can_checkin",
      "can_post",
      "category",
      "category_list",
      "checkins",
      "company_overview",
      "connected_instagram_account",
      "connected_page_backed_instagram_account",
      "contact_address",
      "copyright_attribution_insights",
      "copyright_whitelisted_ig_partners",
      "country_page_likes",
      "cover",
      "culinary_team",
      "current_location",
      "delivery_and_pickup_option_info",
      "description",
      "description_html",
      "differently_open_offerings",
      "directed_by",
      "display_subtext",
      "displayed_message_response_time",
      "does_viewer_have_page_permission_link_ig",
      "emails",
      "engagement",
      "fan_count",
      "featured_video",
      "features",
      "followers_count",
      "food_styles",
      "founded",
      "general_info",
      "general_manager",
      "genre",
      "global_brand_page_name",
      "global_brand_root_id",
      "has_added_app",
      "has_lead_access",
      "has_transitioned_to_new_page_experience",
      "has_whatsapp_business_number",
      "has_whatsapp_number",
      "hometown",
      "hours",
      "id",
      "impressum",
      "influences",
      "instagram_business_account",
      "is_always_open",
      "is_calling_eligible",
      "is_chain",
      "is_community_page",
      "is_eligible_for_branded_content",
      "is_eligible_for_disable_connect_ig_btn_for_non_page_admin_am_web",
      "is_messenger_bot_get_started_enabled",
      "is_messenger_platform_bot",
      "is_owned",
      "is_permanently_closed",
      "is_published",
      "is_unclaimed",
      "is_verified",
      "is_webhooks_subscribed",
      "keywords",
      "leadgen_tos_acceptance_time",
      "leadgen_tos_accepted",
      "leadgen_tos_accepting_user",
      "link",
      "location",
      "members",
      "merchant_id",
      "merchant_review_status",
      "messaging_feature_status",
      "messenger_ads_default_icebreakers",
      "messenger_ads_default_quick_replies",
      "messenger_ads_quick_replies_type",
      "mini_shop_storefront",
      "mission",
      "mpg",
      "name",
      "name_with_location_descriptor",
      "network",
      "new_like_count",
      "offer_eligible",
      "overall_star_rating",
      "owner_business",
      "page_token",
      "parent_page",
      "parking",
      "payment_options",
      "personal_info",
      "personal_interests",
      "pharma_safety_info",
      "phone",
      "pickup_options",
      "place_type",
      "plot_outline",
      "preferred_audience",
      "press_contact",
      "price_range",
      "privacy_info_url",
      "produced_by",
      "products",
      "promotion_eligible",
      "promotion_ineligible_reason",
      "public_transit",
      "rating_count",
      "recipient",
      "record_label",
      "release_date",
      "restaurant_services",
      "restaurant_specialties",
      "schedule",
      "screenplay_by",
      "season",
      "single_line_address",
      "starring",
      "start_info",
      "store_code",
      "store_location_descriptor",
      "store_number",
      "studio",
      "supports_donate_button_in_live_video",
      "talking_about_count",
      "temporary_status",
      "unread_message_count",
      "unread_notif_count",
      "unseen_message_count",
      "user_access_expire_time",
      "username",
      "verification_status",
      "voip_info",
      "website",
      "were_here_count",
      "whatsapp_number",
      "written_by",
    };

    @Override
    public APINodeList<Page> parseResponse(String response, String header) throws APIException {
      return Page.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<Page> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Page> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Page>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Page>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<Page>>() {
           public APINodeList<Page> apply(ResponseWrapper result) {
             try {
               return APIRequestGetLikes.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetLikes(String nodeId, APIContext context) {
      super(context, nodeId, "/likes", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetLikes setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetLikes setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetLikes setTargetId (String targetId) {
      this.setParam("target_id", targetId);
      return this;
    }

    public APIRequestGetLikes requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetLikes requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLikes requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetLikes requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLikes requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetLikes requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetLikes requestAboutField () {
      return this.requestAboutField(true);
    }
    public APIRequestGetLikes requestAboutField (boolean value) {
      this.requestField("about", value);
      return this;
    }
    public APIRequestGetLikes requestAccessTokenField () {
      return this.requestAccessTokenField(true);
    }
    public APIRequestGetLikes requestAccessTokenField (boolean value) {
      this.requestField("access_token", value);
      return this;
    }
    public APIRequestGetLikes requestAdCampaignField () {
      return this.requestAdCampaignField(true);
    }
    public APIRequestGetLikes requestAdCampaignField (boolean value) {
      this.requestField("ad_campaign", value);
      return this;
    }
    public APIRequestGetLikes requestAffiliationField () {
      return this.requestAffiliationField(true);
    }
    public APIRequestGetLikes requestAffiliationField (boolean value) {
      this.requestField("affiliation", value);
      return this;
    }
    public APIRequestGetLikes requestAppIdField () {
      return this.requestAppIdField(true);
    }
    public APIRequestGetLikes requestAppIdField (boolean value) {
      this.requestField("app_id", value);
      return this;
    }
    public APIRequestGetLikes requestArtistsWeLikeField () {
      return this.requestArtistsWeLikeField(true);
    }
    public APIRequestGetLikes requestArtistsWeLikeField (boolean value) {
      this.requestField("artists_we_like", value);
      return this;
    }
    public APIRequestGetLikes requestAttireField () {
      return this.requestAttireField(true);
    }
    public APIRequestGetLikes requestAttireField (boolean value) {
      this.requestField("attire", value);
      return this;
    }
    public APIRequestGetLikes requestAvailablePromoOfferIdsField () {
      return this.requestAvailablePromoOfferIdsField(true);
    }
    public APIRequestGetLikes requestAvailablePromoOfferIdsField (boolean value) {
      this.requestField("available_promo_offer_ids", value);
      return this;
    }
    public APIRequestGetLikes requestAwardsField () {
      return this.requestAwardsField(true);
    }
    public APIRequestGetLikes requestAwardsField (boolean value) {
      this.requestField("awards", value);
      return this;
    }
    public APIRequestGetLikes requestBandInterestsField () {
      return this.requestBandInterestsField(true);
    }
    public APIRequestGetLikes requestBandInterestsField (boolean value) {
      this.requestField("band_interests", value);
      return this;
    }
    public APIRequestGetLikes requestBandMembersField () {
      return this.requestBandMembersField(true);
    }
    public APIRequestGetLikes requestBandMembersField (boolean value) {
      this.requestField("band_members", value);
      return this;
    }
    public APIRequestGetLikes requestBestPageField () {
      return this.requestBestPageField(true);
    }
    public APIRequestGetLikes requestBestPageField (boolean value) {
      this.requestField("best_page", value);
      return this;
    }
    public APIRequestGetLikes requestBioField () {
      return this.requestBioField(true);
    }
    public APIRequestGetLikes requestBioField (boolean value) {
      this.requestField("bio", value);
      return this;
    }
    public APIRequestGetLikes requestBirthdayField () {
      return this.requestBirthdayField(true);
    }
    public APIRequestGetLikes requestBirthdayField (boolean value) {
      this.requestField("birthday", value);
      return this;
    }
    public APIRequestGetLikes requestBookingAgentField () {
      return this.requestBookingAgentField(true);
    }
    public APIRequestGetLikes requestBookingAgentField (boolean value) {
      this.requestField("booking_agent", value);
      return this;
    }
    public APIRequestGetLikes requestBreakingNewsUsageField () {
      return this.requestBreakingNewsUsageField(true);
    }
    public APIRequestGetLikes requestBreakingNewsUsageField (boolean value) {
      this.requestField("breaking_news_usage", value);
      return this;
    }
    public APIRequestGetLikes requestBuiltField () {
      return this.requestBuiltField(true);
    }
    public APIRequestGetLikes requestBuiltField (boolean value) {
      this.requestField("built", value);
      return this;
    }
    public APIRequestGetLikes requestBusinessField () {
      return this.requestBusinessField(true);
    }
    public APIRequestGetLikes requestBusinessField (boolean value) {
      this.requestField("business", value);
      return this;
    }
    public APIRequestGetLikes requestCanCheckinField () {
      return this.requestCanCheckinField(true);
    }
    public APIRequestGetLikes requestCanCheckinField (boolean value) {
      this.requestField("can_checkin", value);
      return this;
    }
    public APIRequestGetLikes requestCanPostField () {
      return this.requestCanPostField(true);
    }
    public APIRequestGetLikes requestCanPostField (boolean value) {
      this.requestField("can_post", value);
      return this;
    }
    public APIRequestGetLikes requestCategoryField () {
      return this.requestCategoryField(true);
    }
    public APIRequestGetLikes requestCategoryField (boolean value) {
      this.requestField("category", value);
      return this;
    }
    public APIRequestGetLikes requestCategoryListField () {
      return this.requestCategoryListField(true);
    }
    public APIRequestGetLikes requestCategoryListField (boolean value) {
      this.requestField("category_list", value);
      return this;
    }
    public APIRequestGetLikes requestCheckinsField () {
      return this.requestCheckinsField(true);
    }
    public APIRequestGetLikes requestCheckinsField (boolean value) {
      this.requestField("checkins", value);
      return this;
    }
    public APIRequestGetLikes requestCompanyOverviewField () {
      return this.requestCompanyOverviewField(true);
    }
    public APIRequestGetLikes requestCompanyOverviewField (boolean value) {
      this.requestField("company_overview", value);
      return this;
    }
    public APIRequestGetLikes requestConnectedInstagramAccountField () {
      return this.requestConnectedInstagramAccountField(true);
    }
    public APIRequestGetLikes requestConnectedInstagramAccountField (boolean value) {
      this.requestField("connected_instagram_account", value);
      return this;
    }
    public APIRequestGetLikes requestConnectedPageBackedInstagramAccountField () {
      return this.requestConnectedPageBackedInstagramAccountField(true);
    }
    public APIRequestGetLikes requestConnectedPageBackedInstagramAccountField (boolean value) {
      this.requestField("connected_page_backed_instagram_account", value);
      return this;
    }
    public APIRequestGetLikes requestContactAddressField () {
      return this.requestContactAddressField(true);
    }
    public APIRequestGetLikes requestContactAddressField (boolean value) {
      this.requestField("contact_address", value);
      return this;
    }
    public APIRequestGetLikes requestCopyrightAttributionInsightsField () {
      return this.requestCopyrightAttributionInsightsField(true);
    }
    public APIRequestGetLikes requestCopyrightAttributionInsightsField (boolean value) {
      this.requestField("copyright_attribution_insights", value);
      return this;
    }
    public APIRequestGetLikes requestCopyrightWhitelistedIgPartnersField () {
      return this.requestCopyrightWhitelistedIgPartnersField(true);
    }
    public APIRequestGetLikes requestCopyrightWhitelistedIgPartnersField (boolean value) {
      this.requestField("copyright_whitelisted_ig_partners", value);
      return this;
    }
    public APIRequestGetLikes requestCountryPageLikesField () {
      return this.requestCountryPageLikesField(true);
    }
    public APIRequestGetLikes requestCountryPageLikesField (boolean value) {
      this.requestField("country_page_likes", value);
      return this;
    }
    public APIRequestGetLikes requestCoverField () {
      return this.requestCoverField(true);
    }
    public APIRequestGetLikes requestCoverField (boolean value) {
      this.requestField("cover", value);
      return this;
    }
    public APIRequestGetLikes requestCulinaryTeamField () {
      return this.requestCulinaryTeamField(true);
    }
    public APIRequestGetLikes requestCulinaryTeamField (boolean value) {
      this.requestField("culinary_team", value);
      return this;
    }
    public APIRequestGetLikes requestCurrentLocationField () {
      return this.requestCurrentLocationField(true);
    }
    public APIRequestGetLikes requestCurrentLocationField (boolean value) {
      this.requestField("current_location", value);
      return this;
    }
    public APIRequestGetLikes requestDeliveryAndPickupOptionInfoField () {
      return this.requestDeliveryAndPickupOptionInfoField(true);
    }
    public APIRequestGetLikes requestDeliveryAndPickupOptionInfoField (boolean value) {
      this.requestField("delivery_and_pickup_option_info", value);
      return this;
    }
    public APIRequestGetLikes requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetLikes requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetLikes requestDescriptionHtmlField () {
      return this.requestDescriptionHtmlField(true);
    }
    public APIRequestGetLikes requestDescriptionHtmlField (boolean value) {
      this.requestField("description_html", value);
      return this;
    }
    public APIRequestGetLikes requestDifferentlyOpenOfferingsField () {
      return this.requestDifferentlyOpenOfferingsField(true);
    }
    public APIRequestGetLikes requestDifferentlyOpenOfferingsField (boolean value) {
      this.requestField("differently_open_offerings", value);
      return this;
    }
    public APIRequestGetLikes requestDirectedByField () {
      return this.requestDirectedByField(true);
    }
    public APIRequestGetLikes requestDirectedByField (boolean value) {
      this.requestField("directed_by", value);
      return this;
    }
    public APIRequestGetLikes requestDisplaySubtextField () {
      return this.requestDisplaySubtextField(true);
    }
    public APIRequestGetLikes requestDisplaySubtextField (boolean value) {
      this.requestField("display_subtext", value);
      return this;
    }
    public APIRequestGetLikes requestDisplayedMessageResponseTimeField () {
      return this.requestDisplayedMessageResponseTimeField(true);
    }
    public APIRequestGetLikes requestDisplayedMessageResponseTimeField (boolean value) {
      this.requestField("displayed_message_response_time", value);
      return this;
    }
    public APIRequestGetLikes requestDoesViewerHavePagePermissionLinkIgField () {
      return this.requestDoesViewerHavePagePermissionLinkIgField(true);
    }
    public APIRequestGetLikes requestDoesViewerHavePagePermissionLinkIgField (boolean value) {
      this.requestField("does_viewer_have_page_permission_link_ig", value);
      return this;
    }
    public APIRequestGetLikes requestEmailsField () {
      return this.requestEmailsField(true);
    }
    public APIRequestGetLikes requestEmailsField (boolean value) {
      this.requestField("emails", value);
      return this;
    }
    public APIRequestGetLikes requestEngagementField () {
      return this.requestEngagementField(true);
    }
    public APIRequestGetLikes requestEngagementField (boolean value) {
      this.requestField("engagement", value);
      return this;
    }
    public APIRequestGetLikes requestFanCountField () {
      return this.requestFanCountField(true);
    }
    public APIRequestGetLikes requestFanCountField (boolean value) {
      this.requestField("fan_count", value);
      return this;
    }
    public APIRequestGetLikes requestFeaturedVideoField () {
      return this.requestFeaturedVideoField(true);
    }
    public APIRequestGetLikes requestFeaturedVideoField (boolean value) {
      this.requestField("featured_video", value);
      return this;
    }
    public APIRequestGetLikes requestFeaturesField () {
      return this.requestFeaturesField(true);
    }
    public APIRequestGetLikes requestFeaturesField (boolean value) {
      this.requestField("features", value);
      return this;
    }
    public APIRequestGetLikes requestFollowersCountField () {
      return this.requestFollowersCountField(true);
    }
    public APIRequestGetLikes requestFollowersCountField (boolean value) {
      this.requestField("followers_count", value);
      return this;
    }
    public APIRequestGetLikes requestFoodStylesField () {
      return this.requestFoodStylesField(true);
    }
    public APIRequestGetLikes requestFoodStylesField (boolean value) {
      this.requestField("food_styles", value);
      return this;
    }
    public APIRequestGetLikes requestFoundedField () {
      return this.requestFoundedField(true);
    }
    public APIRequestGetLikes requestFoundedField (boolean value) {
      this.requestField("founded", value);
      return this;
    }
    public APIRequestGetLikes requestGeneralInfoField () {
      return this.requestGeneralInfoField(true);
    }
    public APIRequestGetLikes requestGeneralInfoField (boolean value) {
      this.requestField("general_info", value);
      return this;
    }
    public APIRequestGetLikes requestGeneralManagerField () {
      return this.requestGeneralManagerField(true);
    }
    public APIRequestGetLikes requestGeneralManagerField (boolean value) {
      this.requestField("general_manager", value);
      return this;
    }
    public APIRequestGetLikes requestGenreField () {
      return this.requestGenreField(true);
    }
    public APIRequestGetLikes requestGenreField (boolean value) {
      this.requestField("genre", value);
      return this;
    }
    public APIRequestGetLikes requestGlobalBrandPageNameField () {
      return this.requestGlobalBrandPageNameField(true);
    }
    public APIRequestGetLikes requestGlobalBrandPageNameField (boolean value) {
      this.requestField("global_brand_page_name", value);
      return this;
    }
    public APIRequestGetLikes requestGlobalBrandRootIdField () {
      return this.requestGlobalBrandRootIdField(true);
    }
    public APIRequestGetLikes requestGlobalBrandRootIdField (boolean value) {
      this.requestField("global_brand_root_id", value);
      return this;
    }
    public APIRequestGetLikes requestHasAddedAppField () {
      return this.requestHasAddedAppField(true);
    }
    public APIRequestGetLikes requestHasAddedAppField (boolean value) {
      this.requestField("has_added_app", value);
      return this;
    }
    public APIRequestGetLikes requestHasLeadAccessField () {
      return this.requestHasLeadAccessField(true);
    }
    public APIRequestGetLikes requestHasLeadAccessField (boolean value) {
      this.requestField("has_lead_access", value);
      return this;
    }
    public APIRequestGetLikes requestHasTransitionedToNewPageExperienceField () {
      return this.requestHasTransitionedToNewPageExperienceField(true);
    }
    public APIRequestGetLikes requestHasTransitionedToNewPageExperienceField (boolean value) {
      this.requestField("has_transitioned_to_new_page_experience", value);
      return this;
    }
    public APIRequestGetLikes requestHasWhatsappBusinessNumberField () {
      return this.requestHasWhatsappBusinessNumberField(true);
    }
    public APIRequestGetLikes requestHasWhatsappBusinessNumberField (boolean value) {
      this.requestField("has_whatsapp_business_number", value);
      return this;
    }
    public APIRequestGetLikes requestHasWhatsappNumberField () {
      return this.requestHasWhatsappNumberField(true);
    }
    public APIRequestGetLikes requestHasWhatsappNumberField (boolean value) {
      this.requestField("has_whatsapp_number", value);
      return this;
    }
    public APIRequestGetLikes requestHometownField () {
      return this.requestHometownField(true);
    }
    public APIRequestGetLikes requestHometownField (boolean value) {
      this.requestField("hometown", value);
      return this;
    }
    public APIRequestGetLikes requestHoursField () {
      return this.requestHoursField(true);
    }
    public APIRequestGetLikes requestHoursField (boolean value) {
      this.requestField("hours", value);
      return this;
    }
    public APIRequestGetLikes requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetLikes requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetLikes requestImpressumField () {
      return this.requestImpressumField(true);
    }
    public APIRequestGetLikes requestImpressumField (boolean value) {
      this.requestField("impressum", value);
      return this;
    }
    public APIRequestGetLikes requestInfluencesField () {
      return this.requestInfluencesField(true);
    }
    public APIRequestGetLikes requestInfluencesField (boolean value) {
      this.requestField("influences", value);
      return this;
    }
    public APIRequestGetLikes requestInstagramBusinessAccountField () {
      return this.requestInstagramBusinessAccountField(true);
    }
    public APIRequestGetLikes requestInstagramBusinessAccountField (boolean value) {
      this.requestField("instagram_business_account", value);
      return this;
    }
    public APIRequestGetLikes requestIsAlwaysOpenField () {
      return this.requestIsAlwaysOpenField(true);
    }
    public APIRequestGetLikes requestIsAlwaysOpenField (boolean value) {
      this.requestField("is_always_open", value);
      return this;
    }
    public APIRequestGetLikes requestIsCallingEligibleField () {
      return this.requestIsCallingEligibleField(true);
    }
    public APIRequestGetLikes requestIsCallingEligibleField (boolean value) {
      this.requestField("is_calling_eligible", value);
      return this;
    }
    public APIRequestGetLikes requestIsChainField () {
      return this.requestIsChainField(true);
    }
    public APIRequestGetLikes requestIsChainField (boolean value) {
      this.requestField("is_chain", value);
      return this;
    }
    public APIRequestGetLikes requestIsCommunityPageField () {
      return this.requestIsCommunityPageField(true);
    }
    public APIRequestGetLikes requestIsCommunityPageField (boolean value) {
      this.requestField("is_community_page", value);
      return this;
    }
    public APIRequestGetLikes requestIsEligibleForBrandedContentField () {
      return this.requestIsEligibleForBrandedContentField(true);
    }
    public APIRequestGetLikes requestIsEligibleForBrandedContentField (boolean value) {
      this.requestField("is_eligible_for_branded_content", value);
      return this;
    }
    public APIRequestGetLikes requestIsEligibleForDisableConnectIgBtnForNonPageAdminAmWebField () {
      return this.requestIsEligibleForDisableConnectIgBtnForNonPageAdminAmWebField(true);
    }
    public APIRequestGetLikes requestIsEligibleForDisableConnectIgBtnForNonPageAdminAmWebField (boolean value) {
      this.requestField("is_eligible_for_disable_connect_ig_btn_for_non_page_admin_am_web", value);
      return this;
    }
    public APIRequestGetLikes requestIsMessengerBotGetStartedEnabledField () {
      return this.requestIsMessengerBotGetStartedEnabledField(true);
    }
    public APIRequestGetLikes requestIsMessengerBotGetStartedEnabledField (boolean value) {
      this.requestField("is_messenger_bot_get_started_enabled", value);
      return this;
    }
    public APIRequestGetLikes requestIsMessengerPlatformBotField () {
      return this.requestIsMessengerPlatformBotField(true);
    }
    public APIRequestGetLikes requestIsMessengerPlatformBotField (boolean value) {
      this.requestField("is_messenger_platform_bot", value);
      return this;
    }
    public APIRequestGetLikes requestIsOwnedField () {
      return this.requestIsOwnedField(true);
    }
    public APIRequestGetLikes requestIsOwnedField (boolean value) {
      this.requestField("is_owned", value);
      return this;
    }
    public APIRequestGetLikes requestIsPermanentlyClosedField () {
      return this.requestIsPermanentlyClosedField(true);
    }
    public APIRequestGetLikes requestIsPermanentlyClosedField (boolean value) {
      this.requestField("is_permanently_closed", value);
      return this;
    }
    public APIRequestGetLikes requestIsPublishedField () {
      return this.requestIsPublishedField(true);
    }
    public APIRequestGetLikes requestIsPublishedField (boolean value) {
      this.requestField("is_published", value);
      return this;
    }
    public APIRequestGetLikes requestIsUnclaimedField () {
      return this.requestIsUnclaimedField(true);
    }
    public APIRequestGetLikes requestIsUnclaimedField (boolean value) {
      this.requestField("is_unclaimed", value);
      return this;
    }
    public APIRequestGetLikes requestIsVerifiedField () {
      return this.requestIsVerifiedField(true);
    }
    public APIRequestGetLikes requestIsVerifiedField (boolean value) {
      this.requestField("is_verified", value);
      return this;
    }
    public APIRequestGetLikes requestIsWebhooksSubscribedField () {
      return this.requestIsWebhooksSubscribedField(true);
    }
    public APIRequestGetLikes requestIsWebhooksSubscribedField (boolean value) {
      this.requestField("is_webhooks_subscribed", value);
      return this;
    }
    public APIRequestGetLikes requestKeywordsField () {
      return this.requestKeywordsField(true);
    }
    public APIRequestGetLikes requestKeywordsField (boolean value) {
      this.requestField("keywords", value);
      return this;
    }
    public APIRequestGetLikes requestLeadgenTosAcceptanceTimeField () {
      return this.requestLeadgenTosAcceptanceTimeField(true);
    }
    public APIRequestGetLikes requestLeadgenTosAcceptanceTimeField (boolean value) {
      this.requestField("leadgen_tos_acceptance_time", value);
      return this;
    }
    public APIRequestGetLikes requestLeadgenTosAcceptedField () {
      return this.requestLeadgenTosAcceptedField(true);
    }
    public APIRequestGetLikes requestLeadgenTosAcceptedField (boolean value) {
      this.requestField("leadgen_tos_accepted", value);
      return this;
    }
    public APIRequestGetLikes requestLeadgenTosAcceptingUserField () {
      return this.requestLeadgenTosAcceptingUserField(true);
    }
    public APIRequestGetLikes requestLeadgenTosAcceptingUserField (boolean value) {
      this.requestField("leadgen_tos_accepting_user", value);
      return this;
    }
    public APIRequestGetLikes requestLinkField () {
      return this.requestLinkField(true);
    }
    public APIRequestGetLikes requestLinkField (boolean value) {
      this.requestField("link", value);
      return this;
    }
    public APIRequestGetLikes requestLocationField () {
      return this.requestLocationField(true);
    }
    public APIRequestGetLikes requestLocationField (boolean value) {
      this.requestField("location", value);
      return this;
    }
    public APIRequestGetLikes requestMembersField () {
      return this.requestMembersField(true);
    }
    public APIRequestGetLikes requestMembersField (boolean value) {
      this.requestField("members", value);
      return this;
    }
    public APIRequestGetLikes requestMerchantIdField () {
      return this.requestMerchantIdField(true);
    }
    public APIRequestGetLikes requestMerchantIdField (boolean value) {
      this.requestField("merchant_id", value);
      return this;
    }
    public APIRequestGetLikes requestMerchantReviewStatusField () {
      return this.requestMerchantReviewStatusField(true);
    }
    public APIRequestGetLikes requestMerchantReviewStatusField (boolean value) {
      this.requestField("merchant_review_status", value);
      return this;
    }
    public APIRequestGetLikes requestMessagingFeatureStatusField () {
      return this.requestMessagingFeatureStatusField(true);
    }
    public APIRequestGetLikes requestMessagingFeatureStatusField (boolean value) {
      this.requestField("messaging_feature_status", value);
      return this;
    }
    public APIRequestGetLikes requestMessengerAdsDefaultIcebreakersField () {
      return this.requestMessengerAdsDefaultIcebreakersField(true);
    }
    public APIRequestGetLikes requestMessengerAdsDefaultIcebreakersField (boolean value) {
      this.requestField("messenger_ads_default_icebreakers", value);
      return this;
    }
    public APIRequestGetLikes requestMessengerAdsDefaultQuickRepliesField () {
      return this.requestMessengerAdsDefaultQuickRepliesField(true);
    }
    public APIRequestGetLikes requestMessengerAdsDefaultQuickRepliesField (boolean value) {
      this.requestField("messenger_ads_default_quick_replies", value);
      return this;
    }
    public APIRequestGetLikes requestMessengerAdsQuickRepliesTypeField () {
      return this.requestMessengerAdsQuickRepliesTypeField(true);
    }
    public APIRequestGetLikes requestMessengerAdsQuickRepliesTypeField (boolean value) {
      this.requestField("messenger_ads_quick_replies_type", value);
      return this;
    }
    public APIRequestGetLikes requestMiniShopStorefrontField () {
      return this.requestMiniShopStorefrontField(true);
    }
    public APIRequestGetLikes requestMiniShopStorefrontField (boolean value) {
      this.requestField("mini_shop_storefront", value);
      return this;
    }
    public APIRequestGetLikes requestMissionField () {
      return this.requestMissionField(true);
    }
    public APIRequestGetLikes requestMissionField (boolean value) {
      this.requestField("mission", value);
      return this;
    }
    public APIRequestGetLikes requestMpgField () {
      return this.requestMpgField(true);
    }
    public APIRequestGetLikes requestMpgField (boolean value) {
      this.requestField("mpg", value);
      return this;
    }
    public APIRequestGetLikes requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetLikes requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetLikes requestNameWithLocationDescriptorField () {
      return this.requestNameWithLocationDescriptorField(true);
    }
    public APIRequestGetLikes requestNameWithLocationDescriptorField (boolean value) {
      this.requestField("name_with_location_descriptor", value);
      return this;
    }
    public APIRequestGetLikes requestNetworkField () {
      return this.requestNetworkField(true);
    }
    public APIRequestGetLikes requestNetworkField (boolean value) {
      this.requestField("network", value);
      return this;
    }
    public APIRequestGetLikes requestNewLikeCountField () {
      return this.requestNewLikeCountField(true);
    }
    public APIRequestGetLikes requestNewLikeCountField (boolean value) {
      this.requestField("new_like_count", value);
      return this;
    }
    public APIRequestGetLikes requestOfferEligibleField () {
      return this.requestOfferEligibleField(true);
    }
    public APIRequestGetLikes requestOfferEligibleField (boolean value) {
      this.requestField("offer_eligible", value);
      return this;
    }
    public APIRequestGetLikes requestOverallStarRatingField () {
      return this.requestOverallStarRatingField(true);
    }
    public APIRequestGetLikes requestOverallStarRatingField (boolean value) {
      this.requestField("overall_star_rating", value);
      return this;
    }
    public APIRequestGetLikes requestOwnerBusinessField () {
      return this.requestOwnerBusinessField(true);
    }
    public APIRequestGetLikes requestOwnerBusinessField (boolean value) {
      this.requestField("owner_business", value);
      return this;
    }
    public APIRequestGetLikes requestPageTokenField () {
      return this.requestPageTokenField(true);
    }
    public APIRequestGetLikes requestPageTokenField (boolean value) {
      this.requestField("page_token", value);
      return this;
    }
    public APIRequestGetLikes requestParentPageField () {
      return this.requestParentPageField(true);
    }
    public APIRequestGetLikes requestParentPageField (boolean value) {
      this.requestField("parent_page", value);
      return this;
    }
    public APIRequestGetLikes requestParkingField () {
      return this.requestParkingField(true);
    }
    public APIRequestGetLikes requestParkingField (boolean value) {
      this.requestField("parking", value);
      return this;
    }
    public APIRequestGetLikes requestPaymentOptionsField () {
      return this.requestPaymentOptionsField(true);
    }
    public APIRequestGetLikes requestPaymentOptionsField (boolean value) {
      this.requestField("payment_options", value);
      return this;
    }
    public APIRequestGetLikes requestPersonalInfoField () {
      return this.requestPersonalInfoField(true);
    }
    public APIRequestGetLikes requestPersonalInfoField (boolean value) {
      this.requestField("personal_info", value);
      return this;
    }
    public APIRequestGetLikes requestPersonalInterestsField () {
      return this.requestPersonalInterestsField(true);
    }
    public APIRequestGetLikes requestPersonalInterestsField (boolean value) {
      this.requestField("personal_interests", value);
      return this;
    }
    public APIRequestGetLikes requestPharmaSafetyInfoField () {
      return this.requestPharmaSafetyInfoField(true);
    }
    public APIRequestGetLikes requestPharmaSafetyInfoField (boolean value) {
      this.requestField("pharma_safety_info", value);
      return this;
    }
    public APIRequestGetLikes requestPhoneField () {
      return this.requestPhoneField(true);
    }
    public APIRequestGetLikes requestPhoneField (boolean value) {
      this.requestField("phone", value);
      return this;
    }
    public APIRequestGetLikes requestPickupOptionsField () {
      return this.requestPickupOptionsField(true);
    }
    public APIRequestGetLikes requestPickupOptionsField (boolean value) {
      this.requestField("pickup_options", value);
      return this;
    }
    public APIRequestGetLikes requestPlaceTypeField () {
      return this.requestPlaceTypeField(true);
    }
    public APIRequestGetLikes requestPlaceTypeField (boolean value) {
      this.requestField("place_type", value);
      return this;
    }
    public APIRequestGetLikes requestPlotOutlineField () {
      return this.requestPlotOutlineField(true);
    }
    public APIRequestGetLikes requestPlotOutlineField (boolean value) {
      this.requestField("plot_outline", value);
      return this;
    }
    public APIRequestGetLikes requestPreferredAudienceField () {
      return this.requestPreferredAudienceField(true);
    }
    public APIRequestGetLikes requestPreferredAudienceField (boolean value) {
      this.requestField("preferred_audience", value);
      return this;
    }
    public APIRequestGetLikes requestPressContactField () {
      return this.requestPressContactField(true);
    }
    public APIRequestGetLikes requestPressContactField (boolean value) {
      this.requestField("press_contact", value);
      return this;
    }
    public APIRequestGetLikes requestPriceRangeField () {
      return this.requestPriceRangeField(true);
    }
    public APIRequestGetLikes requestPriceRangeField (boolean value) {
      this.requestField("price_range", value);
      return this;
    }
    public APIRequestGetLikes requestPrivacyInfoUrlField () {
      return this.requestPrivacyInfoUrlField(true);
    }
    public APIRequestGetLikes requestPrivacyInfoUrlField (boolean value) {
      this.requestField("privacy_info_url", value);
      return this;
    }
    public APIRequestGetLikes requestProducedByField () {
      return this.requestProducedByField(true);
    }
    public APIRequestGetLikes requestProducedByField (boolean value) {
      this.requestField("produced_by", value);
      return this;
    }
    public APIRequestGetLikes requestProductsField () {
      return this.requestProductsField(true);
    }
    public APIRequestGetLikes requestProductsField (boolean value) {
      this.requestField("products", value);
      return this;
    }
    public APIRequestGetLikes requestPromotionEligibleField () {
      return this.requestPromotionEligibleField(true);
    }
    public APIRequestGetLikes requestPromotionEligibleField (boolean value) {
      this.requestField("promotion_eligible", value);
      return this;
    }
    public APIRequestGetLikes requestPromotionIneligibleReasonField () {
      return this.requestPromotionIneligibleReasonField(true);
    }
    public APIRequestGetLikes requestPromotionIneligibleReasonField (boolean value) {
      this.requestField("promotion_ineligible_reason", value);
      return this;
    }
    public APIRequestGetLikes requestPublicTransitField () {
      return this.requestPublicTransitField(true);
    }
    public APIRequestGetLikes requestPublicTransitField (boolean value) {
      this.requestField("public_transit", value);
      return this;
    }
    public APIRequestGetLikes requestRatingCountField () {
      return this.requestRatingCountField(true);
    }
    public APIRequestGetLikes requestRatingCountField (boolean value) {
      this.requestField("rating_count", value);
      return this;
    }
    public APIRequestGetLikes requestRecipientField () {
      return this.requestRecipientField(true);
    }
    public APIRequestGetLikes requestRecipientField (boolean value) {
      this.requestField("recipient", value);
      return this;
    }
    public APIRequestGetLikes requestRecordLabelField () {
      return this.requestRecordLabelField(true);
    }
    public APIRequestGetLikes requestRecordLabelField (boolean value) {
      this.requestField("record_label", value);
      return this;
    }
    public APIRequestGetLikes requestReleaseDateField () {
      return this.requestReleaseDateField(true);
    }
    public APIRequestGetLikes requestReleaseDateField (boolean value) {
      this.requestField("release_date", value);
      return this;
    }
    public APIRequestGetLikes requestRestaurantServicesField () {
      return this.requestRestaurantServicesField(true);
    }
    public APIRequestGetLikes requestRestaurantServicesField (boolean value) {
      this.requestField("restaurant_services", value);
      return this;
    }
    public APIRequestGetLikes requestRestaurantSpecialtiesField () {
      return this.requestRestaurantSpecialtiesField(true);
    }
    public APIRequestGetLikes requestRestaurantSpecialtiesField (boolean value) {
      this.requestField("restaurant_specialties", value);
      return this;
    }
    public APIRequestGetLikes requestScheduleField () {
      return this.requestScheduleField(true);
    }
    public APIRequestGetLikes requestScheduleField (boolean value) {
      this.requestField("schedule", value);
      return this;
    }
    public APIRequestGetLikes requestScreenplayByField () {
      return this.requestScreenplayByField(true);
    }
    public APIRequestGetLikes requestScreenplayByField (boolean value) {
      this.requestField("screenplay_by", value);
      return this;
    }
    public APIRequestGetLikes requestSeasonField () {
      return this.requestSeasonField(true);
    }
    public APIRequestGetLikes requestSeasonField (boolean value) {
      this.requestField("season", value);
      return this;
    }
    public APIRequestGetLikes requestSingleLineAddressField () {
      return this.requestSingleLineAddressField(true);
    }
    public APIRequestGetLikes requestSingleLineAddressField (boolean value) {
      this.requestField("single_line_address", value);
      return this;
    }
    public APIRequestGetLikes requestStarringField () {
      return this.requestStarringField(true);
    }
    public APIRequestGetLikes requestStarringField (boolean value) {
      this.requestField("starring", value);
      return this;
    }
    public APIRequestGetLikes requestStartInfoField () {
      return this.requestStartInfoField(true);
    }
    public APIRequestGetLikes requestStartInfoField (boolean value) {
      this.requestField("start_info", value);
      return this;
    }
    public APIRequestGetLikes requestStoreCodeField () {
      return this.requestStoreCodeField(true);
    }
    public APIRequestGetLikes requestStoreCodeField (boolean value) {
      this.requestField("store_code", value);
      return this;
    }
    public APIRequestGetLikes requestStoreLocationDescriptorField () {
      return this.requestStoreLocationDescriptorField(true);
    }
    public APIRequestGetLikes requestStoreLocationDescriptorField (boolean value) {
      this.requestField("store_location_descriptor", value);
      return this;
    }
    public APIRequestGetLikes requestStoreNumberField () {
      return this.requestStoreNumberField(true);
    }
    public APIRequestGetLikes requestStoreNumberField (boolean value) {
      this.requestField("store_number", value);
      return this;
    }
    public APIRequestGetLikes requestStudioField () {
      return this.requestStudioField(true);
    }
    public APIRequestGetLikes requestStudioField (boolean value) {
      this.requestField("studio", value);
      return this;
    }
    public APIRequestGetLikes requestSupportsDonateButtonInLiveVideoField () {
      return this.requestSupportsDonateButtonInLiveVideoField(true);
    }
    public APIRequestGetLikes requestSupportsDonateButtonInLiveVideoField (boolean value) {
      this.requestField("supports_donate_button_in_live_video", value);
      return this;
    }
    public APIRequestGetLikes requestTalkingAboutCountField () {
      return this.requestTalkingAboutCountField(true);
    }
    public APIRequestGetLikes requestTalkingAboutCountField (boolean value) {
      this.requestField("talking_about_count", value);
      return this;
    }
    public APIRequestGetLikes requestTemporaryStatusField () {
      return this.requestTemporaryStatusField(true);
    }
    public APIRequestGetLikes requestTemporaryStatusField (boolean value) {
      this.requestField("temporary_status", value);
      return this;
    }
    public APIRequestGetLikes requestUnreadMessageCountField () {
      return this.requestUnreadMessageCountField(true);
    }
    public APIRequestGetLikes requestUnreadMessageCountField (boolean value) {
      this.requestField("unread_message_count", value);
      return this;
    }
    public APIRequestGetLikes requestUnreadNotifCountField () {
      return this.requestUnreadNotifCountField(true);
    }
    public APIRequestGetLikes requestUnreadNotifCountField (boolean value) {
      this.requestField("unread_notif_count", value);
      return this;
    }
    public APIRequestGetLikes requestUnseenMessageCountField () {
      return this.requestUnseenMessageCountField(true);
    }
    public APIRequestGetLikes requestUnseenMessageCountField (boolean value) {
      this.requestField("unseen_message_count", value);
      return this;
    }
    public APIRequestGetLikes requestUserAccessExpireTimeField () {
      return this.requestUserAccessExpireTimeField(true);
    }
    public APIRequestGetLikes requestUserAccessExpireTimeField (boolean value) {
      this.requestField("user_access_expire_time", value);
      return this;
    }
    public APIRequestGetLikes requestUsernameField () {
      return this.requestUsernameField(true);
    }
    public APIRequestGetLikes requestUsernameField (boolean value) {
      this.requestField("username", value);
      return this;
    }
    public APIRequestGetLikes requestVerificationStatusField () {
      return this.requestVerificationStatusField(true);
    }
    public APIRequestGetLikes requestVerificationStatusField (boolean value) {
      this.requestField("verification_status", value);
      return this;
    }
    public APIRequestGetLikes requestVoipInfoField () {
      return this.requestVoipInfoField(true);
    }
    public APIRequestGetLikes requestVoipInfoField (boolean value) {
      this.requestField("voip_info", value);
      return this;
    }
    public APIRequestGetLikes requestWebsiteField () {
      return this.requestWebsiteField(true);
    }
    public APIRequestGetLikes requestWebsiteField (boolean value) {
      this.requestField("website", value);
      return this;
    }
    public APIRequestGetLikes requestWereHereCountField () {
      return this.requestWereHereCountField(true);
    }
    public APIRequestGetLikes requestWereHereCountField (boolean value) {
      this.requestField("were_here_count", value);
      return this;
    }
    public APIRequestGetLikes requestWhatsappNumberField () {
      return this.requestWhatsappNumberField(true);
    }
    public APIRequestGetLikes requestWhatsappNumberField (boolean value) {
      this.requestField("whatsapp_number", value);
      return this;
    }
    public APIRequestGetLikes requestWrittenByField () {
      return this.requestWrittenByField(true);
    }
    public APIRequestGetLikes requestWrittenByField (boolean value) {
      this.requestField("written_by", value);
      return this;
    }
  }

  public static class APIRequestGetLiveVideos extends APIRequest<LiveVideo> {

    APINodeList<LiveVideo> lastResponse = null;
    @Override
    public APINodeList<LiveVideo> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "broadcast_status",
      "source",
    };

    public static final String[] FIELDS = {
      "ad_break_config",
      "ad_break_failure_reason",
      "broadcast_start_time",
      "copyright",
      "creation_time",
      "dash_ingest_url",
      "dash_preview_url",
      "description",
      "embed_html",
      "from",
      "id",
      "ingest_streams",
      "is_manual_mode",
      "is_reference_only",
      "live_views",
      "overlay_url",
      "permalink_url",
      "planned_start_time",
      "recommended_encoder_settings",
      "seconds_left",
      "secure_stream_url",
      "status",
      "stream_url",
      "targeting",
      "title",
      "total_views",
      "video",
    };

    @Override
    public APINodeList<LiveVideo> parseResponse(String response, String header) throws APIException {
      return LiveVideo.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<LiveVideo> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<LiveVideo> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<LiveVideo>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<LiveVideo>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<LiveVideo>>() {
           public APINodeList<LiveVideo> apply(ResponseWrapper result) {
             try {
               return APIRequestGetLiveVideos.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetLiveVideos(String nodeId, APIContext context) {
      super(context, nodeId, "/live_videos", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetLiveVideos setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetLiveVideos setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetLiveVideos setBroadcastStatus (List<LiveVideo.EnumBroadcastStatus> broadcastStatus) {
      this.setParam("broadcast_status", broadcastStatus);
      return this;
    }
    public APIRequestGetLiveVideos setBroadcastStatus (String broadcastStatus) {
      this.setParam("broadcast_status", broadcastStatus);
      return this;
    }

    public APIRequestGetLiveVideos setSource (LiveVideo.EnumSource source) {
      this.setParam("source", source);
      return this;
    }
    public APIRequestGetLiveVideos setSource (String source) {
      this.setParam("source", source);
      return this;
    }

    public APIRequestGetLiveVideos requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetLiveVideos requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLiveVideos requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetLiveVideos requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLiveVideos requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetLiveVideos requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetLiveVideos requestAdBreakConfigField () {
      return this.requestAdBreakConfigField(true);
    }
    public APIRequestGetLiveVideos requestAdBreakConfigField (boolean value) {
      this.requestField("ad_break_config", value);
      return this;
    }
    public APIRequestGetLiveVideos requestAdBreakFailureReasonField () {
      return this.requestAdBreakFailureReasonField(true);
    }
    public APIRequestGetLiveVideos requestAdBreakFailureReasonField (boolean value) {
      this.requestField("ad_break_failure_reason", value);
      return this;
    }
    public APIRequestGetLiveVideos requestBroadcastStartTimeField () {
      return this.requestBroadcastStartTimeField(true);
    }
    public APIRequestGetLiveVideos requestBroadcastStartTimeField (boolean value) {
      this.requestField("broadcast_start_time", value);
      return this;
    }
    public APIRequestGetLiveVideos requestCopyrightField () {
      return this.requestCopyrightField(true);
    }
    public APIRequestGetLiveVideos requestCopyrightField (boolean value) {
      this.requestField("copyright", value);
      return this;
    }
    public APIRequestGetLiveVideos requestCreationTimeField () {
      return this.requestCreationTimeField(true);
    }
    public APIRequestGetLiveVideos requestCreationTimeField (boolean value) {
      this.requestField("creation_time", value);
      return this;
    }
    public APIRequestGetLiveVideos requestDashIngestUrlField () {
      return this.requestDashIngestUrlField(true);
    }
    public APIRequestGetLiveVideos requestDashIngestUrlField (boolean value) {
      this.requestField("dash_ingest_url", value);
      return this;
    }
    public APIRequestGetLiveVideos requestDashPreviewUrlField () {
      return this.requestDashPreviewUrlField(true);
    }
    public APIRequestGetLiveVideos requestDashPreviewUrlField (boolean value) {
      this.requestField("dash_preview_url", value);
      return this;
    }
    public APIRequestGetLiveVideos requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetLiveVideos requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetLiveVideos requestEmbedHtmlField () {
      return this.requestEmbedHtmlField(true);
    }
    public APIRequestGetLiveVideos requestEmbedHtmlField (boolean value) {
      this.requestField("embed_html", value);
      return this;
    }
    public APIRequestGetLiveVideos requestFromField () {
      return this.requestFromField(true);
    }
    public APIRequestGetLiveVideos requestFromField (boolean value) {
      this.requestField("from", value);
      return this;
    }
    public APIRequestGetLiveVideos requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetLiveVideos requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetLiveVideos requestIngestStreamsField () {
      return this.requestIngestStreamsField(true);
    }
    public APIRequestGetLiveVideos requestIngestStreamsField (boolean value) {
      this.requestField("ingest_streams", value);
      return this;
    }
    public APIRequestGetLiveVideos requestIsManualModeField () {
      return this.requestIsManualModeField(true);
    }
    public APIRequestGetLiveVideos requestIsManualModeField (boolean value) {
      this.requestField("is_manual_mode", value);
      return this;
    }
    public APIRequestGetLiveVideos requestIsReferenceOnlyField () {
      return this.requestIsReferenceOnlyField(true);
    }
    public APIRequestGetLiveVideos requestIsReferenceOnlyField (boolean value) {
      this.requestField("is_reference_only", value);
      return this;
    }
    public APIRequestGetLiveVideos requestLiveViewsField () {
      return this.requestLiveViewsField(true);
    }
    public APIRequestGetLiveVideos requestLiveViewsField (boolean value) {
      this.requestField("live_views", value);
      return this;
    }
    public APIRequestGetLiveVideos requestOverlayUrlField () {
      return this.requestOverlayUrlField(true);
    }
    public APIRequestGetLiveVideos requestOverlayUrlField (boolean value) {
      this.requestField("overlay_url", value);
      return this;
    }
    public APIRequestGetLiveVideos requestPermalinkUrlField () {
      return this.requestPermalinkUrlField(true);
    }
    public APIRequestGetLiveVideos requestPermalinkUrlField (boolean value) {
      this.requestField("permalink_url", value);
      return this;
    }
    public APIRequestGetLiveVideos requestPlannedStartTimeField () {
      return this.requestPlannedStartTimeField(true);
    }
    public APIRequestGetLiveVideos requestPlannedStartTimeField (boolean value) {
      this.requestField("planned_start_time", value);
      return this;
    }
    public APIRequestGetLiveVideos requestRecommendedEncoderSettingsField () {
      return this.requestRecommendedEncoderSettingsField(true);
    }
    public APIRequestGetLiveVideos requestRecommendedEncoderSettingsField (boolean value) {
      this.requestField("recommended_encoder_settings", value);
      return this;
    }
    public APIRequestGetLiveVideos requestSecondsLeftField () {
      return this.requestSecondsLeftField(true);
    }
    public APIRequestGetLiveVideos requestSecondsLeftField (boolean value) {
      this.requestField("seconds_left", value);
      return this;
    }
    public APIRequestGetLiveVideos requestSecureStreamUrlField () {
      return this.requestSecureStreamUrlField(true);
    }
    public APIRequestGetLiveVideos requestSecureStreamUrlField (boolean value) {
      this.requestField("secure_stream_url", value);
      return this;
    }
    public APIRequestGetLiveVideos requestStatusField () {
      return this.requestStatusField(true);
    }
    public APIRequestGetLiveVideos requestStatusField (boolean value) {
      this.requestField("status", value);
      return this;
    }
    public APIRequestGetLiveVideos requestStreamUrlField () {
      return this.requestStreamUrlField(true);
    }
    public APIRequestGetLiveVideos requestStreamUrlField (boolean value) {
      this.requestField("stream_url", value);
      return this;
    }
    public APIRequestGetLiveVideos requestTargetingField () {
      return this.requestTargetingField(true);
    }
    public APIRequestGetLiveVideos requestTargetingField (boolean value) {
      this.requestField("targeting", value);
      return this;
    }
    public APIRequestGetLiveVideos requestTitleField () {
      return this.requestTitleField(true);
    }
    public APIRequestGetLiveVideos requestTitleField (boolean value) {
      this.requestField("title", value);
      return this;
    }
    public APIRequestGetLiveVideos requestTotalViewsField () {
      return this.requestTotalViewsField(true);
    }
    public APIRequestGetLiveVideos requestTotalViewsField (boolean value) {
      this.requestField("total_views", value);
      return this;
    }
    public APIRequestGetLiveVideos requestVideoField () {
      return this.requestVideoField(true);
    }
    public APIRequestGetLiveVideos requestVideoField (boolean value) {
      this.requestField("video", value);
      return this;
    }
  }

  public static class APIRequestCreateLiveVideo extends APIRequest<LiveVideo> {

    LiveVideo lastResponse = null;
    @Override
    public LiveVideo getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "content_tags",
      "crossposting_actions",
      "custom_labels",
      "description",
      "enable_backup_ingest",
      "encoding_settings",
      "event_params",
      "fisheye_video_cropped",
      "front_z_rotation",
      "game_show",
      "is_audio_only",
      "is_spherical",
      "original_fov",
      "privacy",
      "projection",
      "published",
      "schedule_custom_profile_image",
      "spatial_audio_format",
      "status",
      "stereoscopic_mode",
      "stop_on_delete_stream",
      "stream_type",
      "targeting",
      "title",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public LiveVideo parseResponse(String response, String header) throws APIException {
      return LiveVideo.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public LiveVideo execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public LiveVideo execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<LiveVideo> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<LiveVideo> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, LiveVideo>() {
           public LiveVideo apply(ResponseWrapper result) {
             try {
               return APIRequestCreateLiveVideo.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateLiveVideo(String nodeId, APIContext context) {
      super(context, nodeId, "/live_videos", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateLiveVideo setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateLiveVideo setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateLiveVideo setContentTags (List<String> contentTags) {
      this.setParam("content_tags", contentTags);
      return this;
    }
    public APIRequestCreateLiveVideo setContentTags (String contentTags) {
      this.setParam("content_tags", contentTags);
      return this;
    }

    public APIRequestCreateLiveVideo setCrosspostingActions (List<Map<String, String>> crosspostingActions) {
      this.setParam("crossposting_actions", crosspostingActions);
      return this;
    }
    public APIRequestCreateLiveVideo setCrosspostingActions (String crosspostingActions) {
      this.setParam("crossposting_actions", crosspostingActions);
      return this;
    }

    public APIRequestCreateLiveVideo setCustomLabels (List<String> customLabels) {
      this.setParam("custom_labels", customLabels);
      return this;
    }
    public APIRequestCreateLiveVideo setCustomLabels (String customLabels) {
      this.setParam("custom_labels", customLabels);
      return this;
    }

    public APIRequestCreateLiveVideo setDescription (String description) {
      this.setParam("description", description);
      return this;
    }

    public APIRequestCreateLiveVideo setEnableBackupIngest (Boolean enableBackupIngest) {
      this.setParam("enable_backup_ingest", enableBackupIngest);
      return this;
    }
    public APIRequestCreateLiveVideo setEnableBackupIngest (String enableBackupIngest) {
      this.setParam("enable_backup_ingest", enableBackupIngest);
      return this;
    }

    public APIRequestCreateLiveVideo setEncodingSettings (String encodingSettings) {
      this.setParam("encoding_settings", encodingSettings);
      return this;
    }

    public APIRequestCreateLiveVideo setEventParams (Object eventParams) {
      this.setParam("event_params", eventParams);
      return this;
    }
    public APIRequestCreateLiveVideo setEventParams (String eventParams) {
      this.setParam("event_params", eventParams);
      return this;
    }

    public APIRequestCreateLiveVideo setFisheyeVideoCropped (Boolean fisheyeVideoCropped) {
      this.setParam("fisheye_video_cropped", fisheyeVideoCropped);
      return this;
    }
    public APIRequestCreateLiveVideo setFisheyeVideoCropped (String fisheyeVideoCropped) {
      this.setParam("fisheye_video_cropped", fisheyeVideoCropped);
      return this;
    }

    public APIRequestCreateLiveVideo setFrontZRotation (Double frontZRotation) {
      this.setParam("front_z_rotation", frontZRotation);
      return this;
    }
    public APIRequestCreateLiveVideo setFrontZRotation (String frontZRotation) {
      this.setParam("front_z_rotation", frontZRotation);
      return this;
    }

    public APIRequestCreateLiveVideo setGameShow (Map<String, String> gameShow) {
      this.setParam("game_show", gameShow);
      return this;
    }
    public APIRequestCreateLiveVideo setGameShow (String gameShow) {
      this.setParam("game_show", gameShow);
      return this;
    }

    public APIRequestCreateLiveVideo setIsAudioOnly (Boolean isAudioOnly) {
      this.setParam("is_audio_only", isAudioOnly);
      return this;
    }
    public APIRequestCreateLiveVideo setIsAudioOnly (String isAudioOnly) {
      this.setParam("is_audio_only", isAudioOnly);
      return this;
    }

    public APIRequestCreateLiveVideo setIsSpherical (Boolean isSpherical) {
      this.setParam("is_spherical", isSpherical);
      return this;
    }
    public APIRequestCreateLiveVideo setIsSpherical (String isSpherical) {
      this.setParam("is_spherical", isSpherical);
      return this;
    }

    public APIRequestCreateLiveVideo setOriginalFov (Long originalFov) {
      this.setParam("original_fov", originalFov);
      return this;
    }
    public APIRequestCreateLiveVideo setOriginalFov (String originalFov) {
      this.setParam("original_fov", originalFov);
      return this;
    }

    public APIRequestCreateLiveVideo setPrivacy (String privacy) {
      this.setParam("privacy", privacy);
      return this;
    }

    public APIRequestCreateLiveVideo setProjection (LiveVideo.EnumProjection projection) {
      this.setParam("projection", projection);
      return this;
    }
    public APIRequestCreateLiveVideo setProjection (String projection) {
      this.setParam("projection", projection);
      return this;
    }

    public APIRequestCreateLiveVideo setPublished (Boolean published) {
      this.setParam("published", published);
      return this;
    }
    public APIRequestCreateLiveVideo setPublished (String published) {
      this.setParam("published", published);
      return this;
    }

    public APIRequestCreateLiveVideo setScheduleCustomProfileImage (File scheduleCustomProfileImage) {
      this.setParam("schedule_custom_profile_image", scheduleCustomProfileImage);
      return this;
    }
    public APIRequestCreateLiveVideo setScheduleCustomProfileImage (String scheduleCustomProfileImage) {
      this.setParam("schedule_custom_profile_image", scheduleCustomProfileImage);
      return this;
    }

    public APIRequestCreateLiveVideo setSpatialAudioFormat (LiveVideo.EnumSpatialAudioFormat spatialAudioFormat) {
      this.setParam("spatial_audio_format", spatialAudioFormat);
      return this;
    }
    public APIRequestCreateLiveVideo setSpatialAudioFormat (String spatialAudioFormat) {
      this.setParam("spatial_audio_format", spatialAudioFormat);
      return this;
    }

    public APIRequestCreateLiveVideo setStatus (LiveVideo.EnumStatus status) {
      this.setParam("status", status);
      return this;
    }
    public APIRequestCreateLiveVideo setStatus (String status) {
      this.setParam("status", status);
      return this;
    }

    public APIRequestCreateLiveVideo setStereoscopicMode (LiveVideo.EnumStereoscopicMode stereoscopicMode) {
      this.setParam("stereoscopic_mode", stereoscopicMode);
      return this;
    }
    public APIRequestCreateLiveVideo setStereoscopicMode (String stereoscopicMode) {
      this.setParam("stereoscopic_mode", stereoscopicMode);
      return this;
    }

    public APIRequestCreateLiveVideo setStopOnDeleteStream (Boolean stopOnDeleteStream) {
      this.setParam("stop_on_delete_stream", stopOnDeleteStream);
      return this;
    }
    public APIRequestCreateLiveVideo setStopOnDeleteStream (String stopOnDeleteStream) {
      this.setParam("stop_on_delete_stream", stopOnDeleteStream);
      return this;
    }

    public APIRequestCreateLiveVideo setStreamType (LiveVideo.EnumStreamType streamType) {
      this.setParam("stream_type", streamType);
      return this;
    }
    public APIRequestCreateLiveVideo setStreamType (String streamType) {
      this.setParam("stream_type", streamType);
      return this;
    }

    public APIRequestCreateLiveVideo setTargeting (Object targeting) {
      this.setParam("targeting", targeting);
      return this;
    }
    public APIRequestCreateLiveVideo setTargeting (String targeting) {
      this.setParam("targeting", targeting);
      return this;
    }

    public APIRequestCreateLiveVideo setTitle (String title) {
      this.setParam("title", title);
      return this;
    }

    public APIRequestCreateLiveVideo requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateLiveVideo requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLiveVideo requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateLiveVideo requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLiveVideo requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateLiveVideo requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestDeleteLocations extends APIRequest<APINode> {

    APINodeList<APINode> lastResponse = null;
    @Override
    public APINodeList<APINode> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "location_page_ids",
      "store_numbers",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
      return APINode.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<APINode> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<APINode>>() {
           public APINodeList<APINode> apply(ResponseWrapper result) {
             try {
               return APIRequestDeleteLocations.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestDeleteLocations(String nodeId, APIContext context) {
      super(context, nodeId, "/locations", "DELETE", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestDeleteLocations setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestDeleteLocations setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestDeleteLocations setLocationPageIds (List<String> locationPageIds) {
      this.setParam("location_page_ids", locationPageIds);
      return this;
    }
    public APIRequestDeleteLocations setLocationPageIds (String locationPageIds) {
      this.setParam("location_page_ids", locationPageIds);
      return this;
    }

    public APIRequestDeleteLocations setStoreNumbers (List<Long> storeNumbers) {
      this.setParam("store_numbers", storeNumbers);
      return this;
    }
    public APIRequestDeleteLocations setStoreNumbers (String storeNumbers) {
      this.setParam("store_numbers", storeNumbers);
      return this;
    }

    public APIRequestDeleteLocations requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestDeleteLocations requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteLocations requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestDeleteLocations requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteLocations requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestDeleteLocations requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetLocations extends APIRequest<Page> {

    APINodeList<Page> lastResponse = null;
    @Override
    public APINodeList<Page> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "about",
      "access_token",
      "ad_campaign",
      "affiliation",
      "app_id",
      "artists_we_like",
      "attire",
      "available_promo_offer_ids",
      "awards",
      "band_interests",
      "band_members",
      "best_page",
      "bio",
      "birthday",
      "booking_agent",
      "breaking_news_usage",
      "built",
      "business",
      "can_checkin",
      "can_post",
      "category",
      "category_list",
      "checkins",
      "company_overview",
      "connected_instagram_account",
      "connected_page_backed_instagram_account",
      "contact_address",
      "copyright_attribution_insights",
      "copyright_whitelisted_ig_partners",
      "country_page_likes",
      "cover",
      "culinary_team",
      "current_location",
      "delivery_and_pickup_option_info",
      "description",
      "description_html",
      "differently_open_offerings",
      "directed_by",
      "display_subtext",
      "displayed_message_response_time",
      "does_viewer_have_page_permission_link_ig",
      "emails",
      "engagement",
      "fan_count",
      "featured_video",
      "features",
      "followers_count",
      "food_styles",
      "founded",
      "general_info",
      "general_manager",
      "genre",
      "global_brand_page_name",
      "global_brand_root_id",
      "has_added_app",
      "has_lead_access",
      "has_transitioned_to_new_page_experience",
      "has_whatsapp_business_number",
      "has_whatsapp_number",
      "hometown",
      "hours",
      "id",
      "impressum",
      "influences",
      "instagram_business_account",
      "is_always_open",
      "is_calling_eligible",
      "is_chain",
      "is_community_page",
      "is_eligible_for_branded_content",
      "is_eligible_for_disable_connect_ig_btn_for_non_page_admin_am_web",
      "is_messenger_bot_get_started_enabled",
      "is_messenger_platform_bot",
      "is_owned",
      "is_permanently_closed",
      "is_published",
      "is_unclaimed",
      "is_verified",
      "is_webhooks_subscribed",
      "keywords",
      "leadgen_tos_acceptance_time",
      "leadgen_tos_accepted",
      "leadgen_tos_accepting_user",
      "link",
      "location",
      "members",
      "merchant_id",
      "merchant_review_status",
      "messaging_feature_status",
      "messenger_ads_default_icebreakers",
      "messenger_ads_default_quick_replies",
      "messenger_ads_quick_replies_type",
      "mini_shop_storefront",
      "mission",
      "mpg",
      "name",
      "name_with_location_descriptor",
      "network",
      "new_like_count",
      "offer_eligible",
      "overall_star_rating",
      "owner_business",
      "page_token",
      "parent_page",
      "parking",
      "payment_options",
      "personal_info",
      "personal_interests",
      "pharma_safety_info",
      "phone",
      "pickup_options",
      "place_type",
      "plot_outline",
      "preferred_audience",
      "press_contact",
      "price_range",
      "privacy_info_url",
      "produced_by",
      "products",
      "promotion_eligible",
      "promotion_ineligible_reason",
      "public_transit",
      "rating_count",
      "recipient",
      "record_label",
      "release_date",
      "restaurant_services",
      "restaurant_specialties",
      "schedule",
      "screenplay_by",
      "season",
      "single_line_address",
      "starring",
      "start_info",
      "store_code",
      "store_location_descriptor",
      "store_number",
      "studio",
      "supports_donate_button_in_live_video",
      "talking_about_count",
      "temporary_status",
      "unread_message_count",
      "unread_notif_count",
      "unseen_message_count",
      "user_access_expire_time",
      "username",
      "verification_status",
      "voip_info",
      "website",
      "were_here_count",
      "whatsapp_number",
      "written_by",
    };

    @Override
    public APINodeList<Page> parseResponse(String response, String header) throws APIException {
      return Page.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<Page> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Page> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Page>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Page>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<Page>>() {
           public APINodeList<Page> apply(ResponseWrapper result) {
             try {
               return APIRequestGetLocations.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetLocations(String nodeId, APIContext context) {
      super(context, nodeId, "/locations", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetLocations setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetLocations setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetLocations requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetLocations requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLocations requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetLocations requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLocations requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetLocations requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetLocations requestAboutField () {
      return this.requestAboutField(true);
    }
    public APIRequestGetLocations requestAboutField (boolean value) {
      this.requestField("about", value);
      return this;
    }
    public APIRequestGetLocations requestAccessTokenField () {
      return this.requestAccessTokenField(true);
    }
    public APIRequestGetLocations requestAccessTokenField (boolean value) {
      this.requestField("access_token", value);
      return this;
    }
    public APIRequestGetLocations requestAdCampaignField () {
      return this.requestAdCampaignField(true);
    }
    public APIRequestGetLocations requestAdCampaignField (boolean value) {
      this.requestField("ad_campaign", value);
      return this;
    }
    public APIRequestGetLocations requestAffiliationField () {
      return this.requestAffiliationField(true);
    }
    public APIRequestGetLocations requestAffiliationField (boolean value) {
      this.requestField("affiliation", value);
      return this;
    }
    public APIRequestGetLocations requestAppIdField () {
      return this.requestAppIdField(true);
    }
    public APIRequestGetLocations requestAppIdField (boolean value) {
      this.requestField("app_id", value);
      return this;
    }
    public APIRequestGetLocations requestArtistsWeLikeField () {
      return this.requestArtistsWeLikeField(true);
    }
    public APIRequestGetLocations requestArtistsWeLikeField (boolean value) {
      this.requestField("artists_we_like", value);
      return this;
    }
    public APIRequestGetLocations requestAttireField () {
      return this.requestAttireField(true);
    }
    public APIRequestGetLocations requestAttireField (boolean value) {
      this.requestField("attire", value);
      return this;
    }
    public APIRequestGetLocations requestAvailablePromoOfferIdsField () {
      return this.requestAvailablePromoOfferIdsField(true);
    }
    public APIRequestGetLocations requestAvailablePromoOfferIdsField (boolean value) {
      this.requestField("available_promo_offer_ids", value);
      return this;
    }
    public APIRequestGetLocations requestAwardsField () {
      return this.requestAwardsField(true);
    }
    public APIRequestGetLocations requestAwardsField (boolean value) {
      this.requestField("awards", value);
      return this;
    }
    public APIRequestGetLocations requestBandInterestsField () {
      return this.requestBandInterestsField(true);
    }
    public APIRequestGetLocations requestBandInterestsField (boolean value) {
      this.requestField("band_interests", value);
      return this;
    }
    public APIRequestGetLocations requestBandMembersField () {
      return this.requestBandMembersField(true);
    }
    public APIRequestGetLocations requestBandMembersField (boolean value) {
      this.requestField("band_members", value);
      return this;
    }
    public APIRequestGetLocations requestBestPageField () {
      return this.requestBestPageField(true);
    }
    public APIRequestGetLocations requestBestPageField (boolean value) {
      this.requestField("best_page", value);
      return this;
    }
    public APIRequestGetLocations requestBioField () {
      return this.requestBioField(true);
    }
    public APIRequestGetLocations requestBioField (boolean value) {
      this.requestField("bio", value);
      return this;
    }
    public APIRequestGetLocations requestBirthdayField () {
      return this.requestBirthdayField(true);
    }
    public APIRequestGetLocations requestBirthdayField (boolean value) {
      this.requestField("birthday", value);
      return this;
    }
    public APIRequestGetLocations requestBookingAgentField () {
      return this.requestBookingAgentField(true);
    }
    public APIRequestGetLocations requestBookingAgentField (boolean value) {
      this.requestField("booking_agent", value);
      return this;
    }
    public APIRequestGetLocations requestBreakingNewsUsageField () {
      return this.requestBreakingNewsUsageField(true);
    }
    public APIRequestGetLocations requestBreakingNewsUsageField (boolean value) {
      this.requestField("breaking_news_usage", value);
      return this;
    }
    public APIRequestGetLocations requestBuiltField () {
      return this.requestBuiltField(true);
    }
    public APIRequestGetLocations requestBuiltField (boolean value) {
      this.requestField("built", value);
      return this;
    }
    public APIRequestGetLocations requestBusinessField () {
      return this.requestBusinessField(true);
    }
    public APIRequestGetLocations requestBusinessField (boolean value) {
      this.requestField("business", value);
      return this;
    }
    public APIRequestGetLocations requestCanCheckinField () {
      return this.requestCanCheckinField(true);
    }
    public APIRequestGetLocations requestCanCheckinField (boolean value) {
      this.requestField("can_checkin", value);
      return this;
    }
    public APIRequestGetLocations requestCanPostField () {
      return this.requestCanPostField(true);
    }
    public APIRequestGetLocations requestCanPostField (boolean value) {
      this.requestField("can_post", value);
      return this;
    }
    public APIRequestGetLocations requestCategoryField () {
      return this.requestCategoryField(true);
    }
    public APIRequestGetLocations requestCategoryField (boolean value) {
      this.requestField("category", value);
      return this;
    }
    public APIRequestGetLocations requestCategoryListField () {
      return this.requestCategoryListField(true);
    }
    public APIRequestGetLocations requestCategoryListField (boolean value) {
      this.requestField("category_list", value);
      return this;
    }
    public APIRequestGetLocations requestCheckinsField () {
      return this.requestCheckinsField(true);
    }
    public APIRequestGetLocations requestCheckinsField (boolean value) {
      this.requestField("checkins", value);
      return this;
    }
    public APIRequestGetLocations requestCompanyOverviewField () {
      return this.requestCompanyOverviewField(true);
    }
    public APIRequestGetLocations requestCompanyOverviewField (boolean value) {
      this.requestField("company_overview", value);
      return this;
    }
    public APIRequestGetLocations requestConnectedInstagramAccountField () {
      return this.requestConnectedInstagramAccountField(true);
    }
    public APIRequestGetLocations requestConnectedInstagramAccountField (boolean value) {
      this.requestField("connected_instagram_account", value);
      return this;
    }
    public APIRequestGetLocations requestConnectedPageBackedInstagramAccountField () {
      return this.requestConnectedPageBackedInstagramAccountField(true);
    }
    public APIRequestGetLocations requestConnectedPageBackedInstagramAccountField (boolean value) {
      this.requestField("connected_page_backed_instagram_account", value);
      return this;
    }
    public APIRequestGetLocations requestContactAddressField () {
      return this.requestContactAddressField(true);
    }
    public APIRequestGetLocations requestContactAddressField (boolean value) {
      this.requestField("contact_address", value);
      return this;
    }
    public APIRequestGetLocations requestCopyrightAttributionInsightsField () {
      return this.requestCopyrightAttributionInsightsField(true);
    }
    public APIRequestGetLocations requestCopyrightAttributionInsightsField (boolean value) {
      this.requestField("copyright_attribution_insights", value);
      return this;
    }
    public APIRequestGetLocations requestCopyrightWhitelistedIgPartnersField () {
      return this.requestCopyrightWhitelistedIgPartnersField(true);
    }
    public APIRequestGetLocations requestCopyrightWhitelistedIgPartnersField (boolean value) {
      this.requestField("copyright_whitelisted_ig_partners", value);
      return this;
    }
    public APIRequestGetLocations requestCountryPageLikesField () {
      return this.requestCountryPageLikesField(true);
    }
    public APIRequestGetLocations requestCountryPageLikesField (boolean value) {
      this.requestField("country_page_likes", value);
      return this;
    }
    public APIRequestGetLocations requestCoverField () {
      return this.requestCoverField(true);
    }
    public APIRequestGetLocations requestCoverField (boolean value) {
      this.requestField("cover", value);
      return this;
    }
    public APIRequestGetLocations requestCulinaryTeamField () {
      return this.requestCulinaryTeamField(true);
    }
    public APIRequestGetLocations requestCulinaryTeamField (boolean value) {
      this.requestField("culinary_team", value);
      return this;
    }
    public APIRequestGetLocations requestCurrentLocationField () {
      return this.requestCurrentLocationField(true);
    }
    public APIRequestGetLocations requestCurrentLocationField (boolean value) {
      this.requestField("current_location", value);
      return this;
    }
    public APIRequestGetLocations requestDeliveryAndPickupOptionInfoField () {
      return this.requestDeliveryAndPickupOptionInfoField(true);
    }
    public APIRequestGetLocations requestDeliveryAndPickupOptionInfoField (boolean value) {
      this.requestField("delivery_and_pickup_option_info", value);
      return this;
    }
    public APIRequestGetLocations requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetLocations requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetLocations requestDescriptionHtmlField () {
      return this.requestDescriptionHtmlField(true);
    }
    public APIRequestGetLocations requestDescriptionHtmlField (boolean value) {
      this.requestField("description_html", value);
      return this;
    }
    public APIRequestGetLocations requestDifferentlyOpenOfferingsField () {
      return this.requestDifferentlyOpenOfferingsField(true);
    }
    public APIRequestGetLocations requestDifferentlyOpenOfferingsField (boolean value) {
      this.requestField("differently_open_offerings", value);
      return this;
    }
    public APIRequestGetLocations requestDirectedByField () {
      return this.requestDirectedByField(true);
    }
    public APIRequestGetLocations requestDirectedByField (boolean value) {
      this.requestField("directed_by", value);
      return this;
    }
    public APIRequestGetLocations requestDisplaySubtextField () {
      return this.requestDisplaySubtextField(true);
    }
    public APIRequestGetLocations requestDisplaySubtextField (boolean value) {
      this.requestField("display_subtext", value);
      return this;
    }
    public APIRequestGetLocations requestDisplayedMessageResponseTimeField () {
      return this.requestDisplayedMessageResponseTimeField(true);
    }
    public APIRequestGetLocations requestDisplayedMessageResponseTimeField (boolean value) {
      this.requestField("displayed_message_response_time", value);
      return this;
    }
    public APIRequestGetLocations requestDoesViewerHavePagePermissionLinkIgField () {
      return this.requestDoesViewerHavePagePermissionLinkIgField(true);
    }
    public APIRequestGetLocations requestDoesViewerHavePagePermissionLinkIgField (boolean value) {
      this.requestField("does_viewer_have_page_permission_link_ig", value);
      return this;
    }
    public APIRequestGetLocations requestEmailsField () {
      return this.requestEmailsField(true);
    }
    public APIRequestGetLocations requestEmailsField (boolean value) {
      this.requestField("emails", value);
      return this;
    }
    public APIRequestGetLocations requestEngagementField () {
      return this.requestEngagementField(true);
    }
    public APIRequestGetLocations requestEngagementField (boolean value) {
      this.requestField("engagement", value);
      return this;
    }
    public APIRequestGetLocations requestFanCountField () {
      return this.requestFanCountField(true);
    }
    public APIRequestGetLocations requestFanCountField (boolean value) {
      this.requestField("fan_count", value);
      return this;
    }
    public APIRequestGetLocations requestFeaturedVideoField () {
      return this.requestFeaturedVideoField(true);
    }
    public APIRequestGetLocations requestFeaturedVideoField (boolean value) {
      this.requestField("featured_video", value);
      return this;
    }
    public APIRequestGetLocations requestFeaturesField () {
      return this.requestFeaturesField(true);
    }
    public APIRequestGetLocations requestFeaturesField (boolean value) {
      this.requestField("features", value);
      return this;
    }
    public APIRequestGetLocations requestFollowersCountField () {
      return this.requestFollowersCountField(true);
    }
    public APIRequestGetLocations requestFollowersCountField (boolean value) {
      this.requestField("followers_count", value);
      return this;
    }
    public APIRequestGetLocations requestFoodStylesField () {
      return this.requestFoodStylesField(true);
    }
    public APIRequestGetLocations requestFoodStylesField (boolean value) {
      this.requestField("food_styles", value);
      return this;
    }
    public APIRequestGetLocations requestFoundedField () {
      return this.requestFoundedField(true);
    }
    public APIRequestGetLocations requestFoundedField (boolean value) {
      this.requestField("founded", value);
      return this;
    }
    public APIRequestGetLocations requestGeneralInfoField () {
      return this.requestGeneralInfoField(true);
    }
    public APIRequestGetLocations requestGeneralInfoField (boolean value) {
      this.requestField("general_info", value);
      return this;
    }
    public APIRequestGetLocations requestGeneralManagerField () {
      return this.requestGeneralManagerField(true);
    }
    public APIRequestGetLocations requestGeneralManagerField (boolean value) {
      this.requestField("general_manager", value);
      return this;
    }
    public APIRequestGetLocations requestGenreField () {
      return this.requestGenreField(true);
    }
    public APIRequestGetLocations requestGenreField (boolean value) {
      this.requestField("genre", value);
      return this;
    }
    public APIRequestGetLocations requestGlobalBrandPageNameField () {
      return this.requestGlobalBrandPageNameField(true);
    }
    public APIRequestGetLocations requestGlobalBrandPageNameField (boolean value) {
      this.requestField("global_brand_page_name", value);
      return this;
    }
    public APIRequestGetLocations requestGlobalBrandRootIdField () {
      return this.requestGlobalBrandRootIdField(true);
    }
    public APIRequestGetLocations requestGlobalBrandRootIdField (boolean value) {
      this.requestField("global_brand_root_id", value);
      return this;
    }
    public APIRequestGetLocations requestHasAddedAppField () {
      return this.requestHasAddedAppField(true);
    }
    public APIRequestGetLocations requestHasAddedAppField (boolean value) {
      this.requestField("has_added_app", value);
      return this;
    }
    public APIRequestGetLocations requestHasLeadAccessField () {
      return this.requestHasLeadAccessField(true);
    }
    public APIRequestGetLocations requestHasLeadAccessField (boolean value) {
      this.requestField("has_lead_access", value);
      return this;
    }
    public APIRequestGetLocations requestHasTransitionedToNewPageExperienceField () {
      return this.requestHasTransitionedToNewPageExperienceField(true);
    }
    public APIRequestGetLocations requestHasTransitionedToNewPageExperienceField (boolean value) {
      this.requestField("has_transitioned_to_new_page_experience", value);
      return this;
    }
    public APIRequestGetLocations requestHasWhatsappBusinessNumberField () {
      return this.requestHasWhatsappBusinessNumberField(true);
    }
    public APIRequestGetLocations requestHasWhatsappBusinessNumberField (boolean value) {
      this.requestField("has_whatsapp_business_number", value);
      return this;
    }
    public APIRequestGetLocations requestHasWhatsappNumberField () {
      return this.requestHasWhatsappNumberField(true);
    }
    public APIRequestGetLocations requestHasWhatsappNumberField (boolean value) {
      this.requestField("has_whatsapp_number", value);
      return this;
    }
    public APIRequestGetLocations requestHometownField () {
      return this.requestHometownField(true);
    }
    public APIRequestGetLocations requestHometownField (boolean value) {
      this.requestField("hometown", value);
      return this;
    }
    public APIRequestGetLocations requestHoursField () {
      return this.requestHoursField(true);
    }
    public APIRequestGetLocations requestHoursField (boolean value) {
      this.requestField("hours", value);
      return this;
    }
    public APIRequestGetLocations requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetLocations requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetLocations requestImpressumField () {
      return this.requestImpressumField(true);
    }
    public APIRequestGetLocations requestImpressumField (boolean value) {
      this.requestField("impressum", value);
      return this;
    }
    public APIRequestGetLocations requestInfluencesField () {
      return this.requestInfluencesField(true);
    }
    public APIRequestGetLocations requestInfluencesField (boolean value) {
      this.requestField("influences", value);
      return this;
    }
    public APIRequestGetLocations requestInstagramBusinessAccountField () {
      return this.requestInstagramBusinessAccountField(true);
    }
    public APIRequestGetLocations requestInstagramBusinessAccountField (boolean value) {
      this.requestField("instagram_business_account", value);
      return this;
    }
    public APIRequestGetLocations requestIsAlwaysOpenField () {
      return this.requestIsAlwaysOpenField(true);
    }
    public APIRequestGetLocations requestIsAlwaysOpenField (boolean value) {
      this.requestField("is_always_open", value);
      return this;
    }
    public APIRequestGetLocations requestIsCallingEligibleField () {
      return this.requestIsCallingEligibleField(true);
    }
    public APIRequestGetLocations requestIsCallingEligibleField (boolean value) {
      this.requestField("is_calling_eligible", value);
      return this;
    }
    public APIRequestGetLocations requestIsChainField () {
      return this.requestIsChainField(true);
    }
    public APIRequestGetLocations requestIsChainField (boolean value) {
      this.requestField("is_chain", value);
      return this;
    }
    public APIRequestGetLocations requestIsCommunityPageField () {
      return this.requestIsCommunityPageField(true);
    }
    public APIRequestGetLocations requestIsCommunityPageField (boolean value) {
      this.requestField("is_community_page", value);
      return this;
    }
    public APIRequestGetLocations requestIsEligibleForBrandedContentField () {
      return this.requestIsEligibleForBrandedContentField(true);
    }
    public APIRequestGetLocations requestIsEligibleForBrandedContentField (boolean value) {
      this.requestField("is_eligible_for_branded_content", value);
      return this;
    }
    public APIRequestGetLocations requestIsEligibleForDisableConnectIgBtnForNonPageAdminAmWebField () {
      return this.requestIsEligibleForDisableConnectIgBtnForNonPageAdminAmWebField(true);
    }
    public APIRequestGetLocations requestIsEligibleForDisableConnectIgBtnForNonPageAdminAmWebField (boolean value) {
      this.requestField("is_eligible_for_disable_connect_ig_btn_for_non_page_admin_am_web", value);
      return this;
    }
    public APIRequestGetLocations requestIsMessengerBotGetStartedEnabledField () {
      return this.requestIsMessengerBotGetStartedEnabledField(true);
    }
    public APIRequestGetLocations requestIsMessengerBotGetStartedEnabledField (boolean value) {
      this.requestField("is_messenger_bot_get_started_enabled", value);
      return this;
    }
    public APIRequestGetLocations requestIsMessengerPlatformBotField () {
      return this.requestIsMessengerPlatformBotField(true);
    }
    public APIRequestGetLocations requestIsMessengerPlatformBotField (boolean value) {
      this.requestField("is_messenger_platform_bot", value);
      return this;
    }
    public APIRequestGetLocations requestIsOwnedField () {
      return this.requestIsOwnedField(true);
    }
    public APIRequestGetLocations requestIsOwnedField (boolean value) {
      this.requestField("is_owned", value);
      return this;
    }
    public APIRequestGetLocations requestIsPermanentlyClosedField () {
      return this.requestIsPermanentlyClosedField(true);
    }
    public APIRequestGetLocations requestIsPermanentlyClosedField (boolean value) {
      this.requestField("is_permanently_closed", value);
      return this;
    }
    public APIRequestGetLocations requestIsPublishedField () {
      return this.requestIsPublishedField(true);
    }
    public APIRequestGetLocations requestIsPublishedField (boolean value) {
      this.requestField("is_published", value);
      return this;
    }
    public APIRequestGetLocations requestIsUnclaimedField () {
      return this.requestIsUnclaimedField(true);
    }
    public APIRequestGetLocations requestIsUnclaimedField (boolean value) {
      this.requestField("is_unclaimed", value);
      return this;
    }
    public APIRequestGetLocations requestIsVerifiedField () {
      return this.requestIsVerifiedField(true);
    }
    public APIRequestGetLocations requestIsVerifiedField (boolean value) {
      this.requestField("is_verified", value);
      return this;
    }
    public APIRequestGetLocations requestIsWebhooksSubscribedField () {
      return this.requestIsWebhooksSubscribedField(true);
    }
    public APIRequestGetLocations requestIsWebhooksSubscribedField (boolean value) {
      this.requestField("is_webhooks_subscribed", value);
      return this;
    }
    public APIRequestGetLocations requestKeywordsField () {
      return this.requestKeywordsField(true);
    }
    public APIRequestGetLocations requestKeywordsField (boolean value) {
      this.requestField("keywords", value);
      return this;
    }
    public APIRequestGetLocations requestLeadgenTosAcceptanceTimeField () {
      return this.requestLeadgenTosAcceptanceTimeField(true);
    }
    public APIRequestGetLocations requestLeadgenTosAcceptanceTimeField (boolean value) {
      this.requestField("leadgen_tos_acceptance_time", value);
      return this;
    }
    public APIRequestGetLocations requestLeadgenTosAcceptedField () {
      return this.requestLeadgenTosAcceptedField(true);
    }
    public APIRequestGetLocations requestLeadgenTosAcceptedField (boolean value) {
      this.requestField("leadgen_tos_accepted", value);
      return this;
    }
    public APIRequestGetLocations requestLeadgenTosAcceptingUserField () {
      return this.requestLeadgenTosAcceptingUserField(true);
    }
    public APIRequestGetLocations requestLeadgenTosAcceptingUserField (boolean value) {
      this.requestField("leadgen_tos_accepting_user", value);
      return this;
    }
    public APIRequestGetLocations requestLinkField () {
      return this.requestLinkField(true);
    }
    public APIRequestGetLocations requestLinkField (boolean value) {
      this.requestField("link", value);
      return this;
    }
    public APIRequestGetLocations requestLocationField () {
      return this.requestLocationField(true);
    }
    public APIRequestGetLocations requestLocationField (boolean value) {
      this.requestField("location", value);
      return this;
    }
    public APIRequestGetLocations requestMembersField () {
      return this.requestMembersField(true);
    }
    public APIRequestGetLocations requestMembersField (boolean value) {
      this.requestField("members", value);
      return this;
    }
    public APIRequestGetLocations requestMerchantIdField () {
      return this.requestMerchantIdField(true);
    }
    public APIRequestGetLocations requestMerchantIdField (boolean value) {
      this.requestField("merchant_id", value);
      return this;
    }
    public APIRequestGetLocations requestMerchantReviewStatusField () {
      return this.requestMerchantReviewStatusField(true);
    }
    public APIRequestGetLocations requestMerchantReviewStatusField (boolean value) {
      this.requestField("merchant_review_status", value);
      return this;
    }
    public APIRequestGetLocations requestMessagingFeatureStatusField () {
      return this.requestMessagingFeatureStatusField(true);
    }
    public APIRequestGetLocations requestMessagingFeatureStatusField (boolean value) {
      this.requestField("messaging_feature_status", value);
      return this;
    }
    public APIRequestGetLocations requestMessengerAdsDefaultIcebreakersField () {
      return this.requestMessengerAdsDefaultIcebreakersField(true);
    }
    public APIRequestGetLocations requestMessengerAdsDefaultIcebreakersField (boolean value) {
      this.requestField("messenger_ads_default_icebreakers", value);
      return this;
    }
    public APIRequestGetLocations requestMessengerAdsDefaultQuickRepliesField () {
      return this.requestMessengerAdsDefaultQuickRepliesField(true);
    }
    public APIRequestGetLocations requestMessengerAdsDefaultQuickRepliesField (boolean value) {
      this.requestField("messenger_ads_default_quick_replies", value);
      return this;
    }
    public APIRequestGetLocations requestMessengerAdsQuickRepliesTypeField () {
      return this.requestMessengerAdsQuickRepliesTypeField(true);
    }
    public APIRequestGetLocations requestMessengerAdsQuickRepliesTypeField (boolean value) {
      this.requestField("messenger_ads_quick_replies_type", value);
      return this;
    }
    public APIRequestGetLocations requestMiniShopStorefrontField () {
      return this.requestMiniShopStorefrontField(true);
    }
    public APIRequestGetLocations requestMiniShopStorefrontField (boolean value) {
      this.requestField("mini_shop_storefront", value);
      return this;
    }
    public APIRequestGetLocations requestMissionField () {
      return this.requestMissionField(true);
    }
    public APIRequestGetLocations requestMissionField (boolean value) {
      this.requestField("mission", value);
      return this;
    }
    public APIRequestGetLocations requestMpgField () {
      return this.requestMpgField(true);
    }
    public APIRequestGetLocations requestMpgField (boolean value) {
      this.requestField("mpg", value);
      return this;
    }
    public APIRequestGetLocations requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetLocations requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetLocations requestNameWithLocationDescriptorField () {
      return this.requestNameWithLocationDescriptorField(true);
    }
    public APIRequestGetLocations requestNameWithLocationDescriptorField (boolean value) {
      this.requestField("name_with_location_descriptor", value);
      return this;
    }
    public APIRequestGetLocations requestNetworkField () {
      return this.requestNetworkField(true);
    }
    public APIRequestGetLocations requestNetworkField (boolean value) {
      this.requestField("network", value);
      return this;
    }
    public APIRequestGetLocations requestNewLikeCountField () {
      return this.requestNewLikeCountField(true);
    }
    public APIRequestGetLocations requestNewLikeCountField (boolean value) {
      this.requestField("new_like_count", value);
      return this;
    }
    public APIRequestGetLocations requestOfferEligibleField () {
      return this.requestOfferEligibleField(true);
    }
    public APIRequestGetLocations requestOfferEligibleField (boolean value) {
      this.requestField("offer_eligible", value);
      return this;
    }
    public APIRequestGetLocations requestOverallStarRatingField () {
      return this.requestOverallStarRatingField(true);
    }
    public APIRequestGetLocations requestOverallStarRatingField (boolean value) {
      this.requestField("overall_star_rating", value);
      return this;
    }
    public APIRequestGetLocations requestOwnerBusinessField () {
      return this.requestOwnerBusinessField(true);
    }
    public APIRequestGetLocations requestOwnerBusinessField (boolean value) {
      this.requestField("owner_business", value);
      return this;
    }
    public APIRequestGetLocations requestPageTokenField () {
      return this.requestPageTokenField(true);
    }
    public APIRequestGetLocations requestPageTokenField (boolean value) {
      this.requestField("page_token", value);
      return this;
    }
    public APIRequestGetLocations requestParentPageField () {
      return this.requestParentPageField(true);
    }
    public APIRequestGetLocations requestParentPageField (boolean value) {
      this.requestField("parent_page", value);
      return this;
    }
    public APIRequestGetLocations requestParkingField () {
      return this.requestParkingField(true);
    }
    public APIRequestGetLocations requestParkingField (boolean value) {
      this.requestField("parking", value);
      return this;
    }
    public APIRequestGetLocations requestPaymentOptionsField () {
      return this.requestPaymentOptionsField(true);
    }
    public APIRequestGetLocations requestPaymentOptionsField (boolean value) {
      this.requestField("payment_options", value);
      return this;
    }
    public APIRequestGetLocations requestPersonalInfoField () {
      return this.requestPersonalInfoField(true);
    }
    public APIRequestGetLocations requestPersonalInfoField (boolean value) {
      this.requestField("personal_info", value);
      return this;
    }
    public APIRequestGetLocations requestPersonalInterestsField () {
      return this.requestPersonalInterestsField(true);
    }
    public APIRequestGetLocations requestPersonalInterestsField (boolean value) {
      this.requestField("personal_interests", value);
      return this;
    }
    public APIRequestGetLocations requestPharmaSafetyInfoField () {
      return this.requestPharmaSafetyInfoField(true);
    }
    public APIRequestGetLocations requestPharmaSafetyInfoField (boolean value) {
      this.requestField("pharma_safety_info", value);
      return this;
    }
    public APIRequestGetLocations requestPhoneField () {
      return this.requestPhoneField(true);
    }
    public APIRequestGetLocations requestPhoneField (boolean value) {
      this.requestField("phone", value);
      return this;
    }
    public APIRequestGetLocations requestPickupOptionsField () {
      return this.requestPickupOptionsField(true);
    }
    public APIRequestGetLocations requestPickupOptionsField (boolean value) {
      this.requestField("pickup_options", value);
      return this;
    }
    public APIRequestGetLocations requestPlaceTypeField () {
      return this.requestPlaceTypeField(true);
    }
    public APIRequestGetLocations requestPlaceTypeField (boolean value) {
      this.requestField("place_type", value);
      return this;
    }
    public APIRequestGetLocations requestPlotOutlineField () {
      return this.requestPlotOutlineField(true);
    }
    public APIRequestGetLocations requestPlotOutlineField (boolean value) {
      this.requestField("plot_outline", value);
      return this;
    }
    public APIRequestGetLocations requestPreferredAudienceField () {
      return this.requestPreferredAudienceField(true);
    }
    public APIRequestGetLocations requestPreferredAudienceField (boolean value) {
      this.requestField("preferred_audience", value);
      return this;
    }
    public APIRequestGetLocations requestPressContactField () {
      return this.requestPressContactField(true);
    }
    public APIRequestGetLocations requestPressContactField (boolean value) {
      this.requestField("press_contact", value);
      return this;
    }
    public APIRequestGetLocations requestPriceRangeField () {
      return this.requestPriceRangeField(true);
    }
    public APIRequestGetLocations requestPriceRangeField (boolean value) {
      this.requestField("price_range", value);
      return this;
    }
    public APIRequestGetLocations requestPrivacyInfoUrlField () {
      return this.requestPrivacyInfoUrlField(true);
    }
    public APIRequestGetLocations requestPrivacyInfoUrlField (boolean value) {
      this.requestField("privacy_info_url", value);
      return this;
    }
    public APIRequestGetLocations requestProducedByField () {
      return this.requestProducedByField(true);
    }
    public APIRequestGetLocations requestProducedByField (boolean value) {
      this.requestField("produced_by", value);
      return this;
    }
    public APIRequestGetLocations requestProductsField () {
      return this.requestProductsField(true);
    }
    public APIRequestGetLocations requestProductsField (boolean value) {
      this.requestField("products", value);
      return this;
    }
    public APIRequestGetLocations requestPromotionEligibleField () {
      return this.requestPromotionEligibleField(true);
    }
    public APIRequestGetLocations requestPromotionEligibleField (boolean value) {
      this.requestField("promotion_eligible", value);
      return this;
    }
    public APIRequestGetLocations requestPromotionIneligibleReasonField () {
      return this.requestPromotionIneligibleReasonField(true);
    }
    public APIRequestGetLocations requestPromotionIneligibleReasonField (boolean value) {
      this.requestField("promotion_ineligible_reason", value);
      return this;
    }
    public APIRequestGetLocations requestPublicTransitField () {
      return this.requestPublicTransitField(true);
    }
    public APIRequestGetLocations requestPublicTransitField (boolean value) {
      this.requestField("public_transit", value);
      return this;
    }
    public APIRequestGetLocations requestRatingCountField () {
      return this.requestRatingCountField(true);
    }
    public APIRequestGetLocations requestRatingCountField (boolean value) {
      this.requestField("rating_count", value);
      return this;
    }
    public APIRequestGetLocations requestRecipientField () {
      return this.requestRecipientField(true);
    }
    public APIRequestGetLocations requestRecipientField (boolean value) {
      this.requestField("recipient", value);
      return this;
    }
    public APIRequestGetLocations requestRecordLabelField () {
      return this.requestRecordLabelField(true);
    }
    public APIRequestGetLocations requestRecordLabelField (boolean value) {
      this.requestField("record_label", value);
      return this;
    }
    public APIRequestGetLocations requestReleaseDateField () {
      return this.requestReleaseDateField(true);
    }
    public APIRequestGetLocations requestReleaseDateField (boolean value) {
      this.requestField("release_date", value);
      return this;
    }
    public APIRequestGetLocations requestRestaurantServicesField () {
      return this.requestRestaurantServicesField(true);
    }
    public APIRequestGetLocations requestRestaurantServicesField (boolean value) {
      this.requestField("restaurant_services", value);
      return this;
    }
    public APIRequestGetLocations requestRestaurantSpecialtiesField () {
      return this.requestRestaurantSpecialtiesField(true);
    }
    public APIRequestGetLocations requestRestaurantSpecialtiesField (boolean value) {
      this.requestField("restaurant_specialties", value);
      return this;
    }
    public APIRequestGetLocations requestScheduleField () {
      return this.requestScheduleField(true);
    }
    public APIRequestGetLocations requestScheduleField (boolean value) {
      this.requestField("schedule", value);
      return this;
    }
    public APIRequestGetLocations requestScreenplayByField () {
      return this.requestScreenplayByField(true);
    }
    public APIRequestGetLocations requestScreenplayByField (boolean value) {
      this.requestField("screenplay_by", value);
      return this;
    }
    public APIRequestGetLocations requestSeasonField () {
      return this.requestSeasonField(true);
    }
    public APIRequestGetLocations requestSeasonField (boolean value) {
      this.requestField("season", value);
      return this;
    }
    public APIRequestGetLocations requestSingleLineAddressField () {
      return this.requestSingleLineAddressField(true);
    }
    public APIRequestGetLocations requestSingleLineAddressField (boolean value) {
      this.requestField("single_line_address", value);
      return this;
    }
    public APIRequestGetLocations requestStarringField () {
      return this.requestStarringField(true);
    }
    public APIRequestGetLocations requestStarringField (boolean value) {
      this.requestField("starring", value);
      return this;
    }
    public APIRequestGetLocations requestStartInfoField () {
      return this.requestStartInfoField(true);
    }
    public APIRequestGetLocations requestStartInfoField (boolean value) {
      this.requestField("start_info", value);
      return this;
    }
    public APIRequestGetLocations requestStoreCodeField () {
      return this.requestStoreCodeField(true);
    }
    public APIRequestGetLocations requestStoreCodeField (boolean value) {
      this.requestField("store_code", value);
      return this;
    }
    public APIRequestGetLocations requestStoreLocationDescriptorField () {
      return this.requestStoreLocationDescriptorField(true);
    }
    public APIRequestGetLocations requestStoreLocationDescriptorField (boolean value) {
      this.requestField("store_location_descriptor", value);
      return this;
    }
    public APIRequestGetLocations requestStoreNumberField () {
      return this.requestStoreNumberField(true);
    }
    public APIRequestGetLocations requestStoreNumberField (boolean value) {
      this.requestField("store_number", value);
      return this;
    }
    public APIRequestGetLocations requestStudioField () {
      return this.requestStudioField(true);
    }
    public APIRequestGetLocations requestStudioField (boolean value) {
      this.requestField("studio", value);
      return this;
    }
    public APIRequestGetLocations requestSupportsDonateButtonInLiveVideoField () {
      return this.requestSupportsDonateButtonInLiveVideoField(true);
    }
    public APIRequestGetLocations requestSupportsDonateButtonInLiveVideoField (boolean value) {
      this.requestField("supports_donate_button_in_live_video", value);
      return this;
    }
    public APIRequestGetLocations requestTalkingAboutCountField () {
      return this.requestTalkingAboutCountField(true);
    }
    public APIRequestGetLocations requestTalkingAboutCountField (boolean value) {
      this.requestField("talking_about_count", value);
      return this;
    }
    public APIRequestGetLocations requestTemporaryStatusField () {
      return this.requestTemporaryStatusField(true);
    }
    public APIRequestGetLocations requestTemporaryStatusField (boolean value) {
      this.requestField("temporary_status", value);
      return this;
    }
    public APIRequestGetLocations requestUnreadMessageCountField () {
      return this.requestUnreadMessageCountField(true);
    }
    public APIRequestGetLocations requestUnreadMessageCountField (boolean value) {
      this.requestField("unread_message_count", value);
      return this;
    }
    public APIRequestGetLocations requestUnreadNotifCountField () {
      return this.requestUnreadNotifCountField(true);
    }
    public APIRequestGetLocations requestUnreadNotifCountField (boolean value) {
      this.requestField("unread_notif_count", value);
      return this;
    }
    public APIRequestGetLocations requestUnseenMessageCountField () {
      return this.requestUnseenMessageCountField(true);
    }
    public APIRequestGetLocations requestUnseenMessageCountField (boolean value) {
      this.requestField("unseen_message_count", value);
      return this;
    }
    public APIRequestGetLocations requestUserAccessExpireTimeField () {
      return this.requestUserAccessExpireTimeField(true);
    }
    public APIRequestGetLocations requestUserAccessExpireTimeField (boolean value) {
      this.requestField("user_access_expire_time", value);
      return this;
    }
    public APIRequestGetLocations requestUsernameField () {
      return this.requestUsernameField(true);
    }
    public APIRequestGetLocations requestUsernameField (boolean value) {
      this.requestField("username", value);
      return this;
    }
    public APIRequestGetLocations requestVerificationStatusField () {
      return this.requestVerificationStatusField(true);
    }
    public APIRequestGetLocations requestVerificationStatusField (boolean value) {
      this.requestField("verification_status", value);
      return this;
    }
    public APIRequestGetLocations requestVoipInfoField () {
      return this.requestVoipInfoField(true);
    }
    public APIRequestGetLocations requestVoipInfoField (boolean value) {
      this.requestField("voip_info", value);
      return this;
    }
    public APIRequestGetLocations requestWebsiteField () {
      return this.requestWebsiteField(true);
    }
    public APIRequestGetLocations requestWebsiteField (boolean value) {
      this.requestField("website", value);
      return this;
    }
    public APIRequestGetLocations requestWereHereCountField () {
      return this.requestWereHereCountField(true);
    }
    public APIRequestGetLocations requestWereHereCountField (boolean value) {
      this.requestField("were_here_count", value);
      return this;
    }
    public APIRequestGetLocations requestWhatsappNumberField () {
      return this.requestWhatsappNumberField(true);
    }
    public APIRequestGetLocations requestWhatsappNumberField (boolean value) {
      this.requestField("whatsapp_number", value);
      return this;
    }
    public APIRequestGetLocations requestWrittenByField () {
      return this.requestWrittenByField(true);
    }
    public APIRequestGetLocations requestWrittenByField (boolean value) {
      this.requestField("written_by", value);
      return this;
    }
  }

  public static class APIRequestCreateLocation extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "always_open",
      "delivery_and_pickup_option_info",
      "differently_open_offerings",
      "hours",
      "ignore_warnings",
      "location",
      "location_page_id",
      "old_store_number",
      "page_username",
      "permanently_closed",
      "phone",
      "pickup_options",
      "place_topics",
      "price_range",
      "recommendation_action",
      "recommendation_ds",
      "recommendation_store_id",
      "store_code",
      "store_location_descriptor",
      "store_name",
      "store_number",
      "temporary_status",
      "type",
      "website",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response, String header) throws APIException {
      return Page.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, Page>() {
           public Page apply(ResponseWrapper result) {
             try {
               return APIRequestCreateLocation.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateLocation(String nodeId, APIContext context) {
      super(context, nodeId, "/locations", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateLocation setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateLocation setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateLocation setAlwaysOpen (Boolean alwaysOpen) {
      this.setParam("always_open", alwaysOpen);
      return this;
    }
    public APIRequestCreateLocation setAlwaysOpen (String alwaysOpen) {
      this.setParam("always_open", alwaysOpen);
      return this;
    }

    public APIRequestCreateLocation setDeliveryAndPickupOptionInfo (List<String> deliveryAndPickupOptionInfo) {
      this.setParam("delivery_and_pickup_option_info", deliveryAndPickupOptionInfo);
      return this;
    }
    public APIRequestCreateLocation setDeliveryAndPickupOptionInfo (String deliveryAndPickupOptionInfo) {
      this.setParam("delivery_and_pickup_option_info", deliveryAndPickupOptionInfo);
      return this;
    }

    public APIRequestCreateLocation setDifferentlyOpenOfferings (Map<String, String> differentlyOpenOfferings) {
      this.setParam("differently_open_offerings", differentlyOpenOfferings);
      return this;
    }
    public APIRequestCreateLocation setDifferentlyOpenOfferings (String differentlyOpenOfferings) {
      this.setParam("differently_open_offerings", differentlyOpenOfferings);
      return this;
    }

    public APIRequestCreateLocation setHours (Map<String, String> hours) {
      this.setParam("hours", hours);
      return this;
    }
    public APIRequestCreateLocation setHours (String hours) {
      this.setParam("hours", hours);
      return this;
    }

    public APIRequestCreateLocation setIgnoreWarnings (Boolean ignoreWarnings) {
      this.setParam("ignore_warnings", ignoreWarnings);
      return this;
    }
    public APIRequestCreateLocation setIgnoreWarnings (String ignoreWarnings) {
      this.setParam("ignore_warnings", ignoreWarnings);
      return this;
    }

    public APIRequestCreateLocation setLocation (Object location) {
      this.setParam("location", location);
      return this;
    }
    public APIRequestCreateLocation setLocation (String location) {
      this.setParam("location", location);
      return this;
    }

    public APIRequestCreateLocation setLocationPageId (String locationPageId) {
      this.setParam("location_page_id", locationPageId);
      return this;
    }

    public APIRequestCreateLocation setOldStoreNumber (Long oldStoreNumber) {
      this.setParam("old_store_number", oldStoreNumber);
      return this;
    }
    public APIRequestCreateLocation setOldStoreNumber (String oldStoreNumber) {
      this.setParam("old_store_number", oldStoreNumber);
      return this;
    }

    public APIRequestCreateLocation setPageUsername (String pageUsername) {
      this.setParam("page_username", pageUsername);
      return this;
    }

    public APIRequestCreateLocation setPermanentlyClosed (Boolean permanentlyClosed) {
      this.setParam("permanently_closed", permanentlyClosed);
      return this;
    }
    public APIRequestCreateLocation setPermanentlyClosed (String permanentlyClosed) {
      this.setParam("permanently_closed", permanentlyClosed);
      return this;
    }

    public APIRequestCreateLocation setPhone (String phone) {
      this.setParam("phone", phone);
      return this;
    }

    public APIRequestCreateLocation setPickupOptions (List<Page.EnumPickupOptions> pickupOptions) {
      this.setParam("pickup_options", pickupOptions);
      return this;
    }
    public APIRequestCreateLocation setPickupOptions (String pickupOptions) {
      this.setParam("pickup_options", pickupOptions);
      return this;
    }

    public APIRequestCreateLocation setPlaceTopics (List<String> placeTopics) {
      this.setParam("place_topics", placeTopics);
      return this;
    }
    public APIRequestCreateLocation setPlaceTopics (String placeTopics) {
      this.setParam("place_topics", placeTopics);
      return this;
    }

    public APIRequestCreateLocation setPriceRange (String priceRange) {
      this.setParam("price_range", priceRange);
      return this;
    }

    public APIRequestCreateLocation setRecommendationAction (Page.EnumRecommendationAction recommendationAction) {
      this.setParam("recommendation_action", recommendationAction);
      return this;
    }
    public APIRequestCreateLocation setRecommendationAction (String recommendationAction) {
      this.setParam("recommendation_action", recommendationAction);
      return this;
    }

    public APIRequestCreateLocation setRecommendationDs (String recommendationDs) {
      this.setParam("recommendation_ds", recommendationDs);
      return this;
    }

    public APIRequestCreateLocation setRecommendationStoreId (Long recommendationStoreId) {
      this.setParam("recommendation_store_id", recommendationStoreId);
      return this;
    }
    public APIRequestCreateLocation setRecommendationStoreId (String recommendationStoreId) {
      this.setParam("recommendation_store_id", recommendationStoreId);
      return this;
    }

    public APIRequestCreateLocation setStoreCode (String storeCode) {
      this.setParam("store_code", storeCode);
      return this;
    }

    public APIRequestCreateLocation setStoreLocationDescriptor (String storeLocationDescriptor) {
      this.setParam("store_location_descriptor", storeLocationDescriptor);
      return this;
    }

    public APIRequestCreateLocation setStoreName (String storeName) {
      this.setParam("store_name", storeName);
      return this;
    }

    public APIRequestCreateLocation setStoreNumber (Long storeNumber) {
      this.setParam("store_number", storeNumber);
      return this;
    }
    public APIRequestCreateLocation setStoreNumber (String storeNumber) {
      this.setParam("store_number", storeNumber);
      return this;
    }

    public APIRequestCreateLocation setTemporaryStatus (Page.EnumTemporaryStatus temporaryStatus) {
      this.setParam("temporary_status", temporaryStatus);
      return this;
    }
    public APIRequestCreateLocation setTemporaryStatus (String temporaryStatus) {
      this.setParam("temporary_status", temporaryStatus);
      return this;
    }

    public APIRequestCreateLocation setType (String type) {
      this.setParam("type", type);
      return this;
    }

    public APIRequestCreateLocation setWebsite (String website) {
      this.setParam("website", website);
      return this;
    }

    public APIRequestCreateLocation requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateLocation requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLocation requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateLocation requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLocation requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateLocation requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetMediaFingerprints extends APIRequest<MediaFingerprint> {

    APINodeList<MediaFingerprint> lastResponse = null;
    @Override
    public APINodeList<MediaFingerprint> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "universal_content_id",
    };

    public static final String[] FIELDS = {
      "duration_in_sec",
      "fingerprint_content_type",
      "fingerprint_type",
      "id",
      "metadata",
      "title",
      "universal_content_id",
    };

    @Override
    public APINodeList<MediaFingerprint> parseResponse(String response, String header) throws APIException {
      return MediaFingerprint.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<MediaFingerprint> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<MediaFingerprint> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<MediaFingerprint>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<MediaFingerprint>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<MediaFingerprint>>() {
           public APINodeList<MediaFingerprint> apply(ResponseWrapper result) {
             try {
               return APIRequestGetMediaFingerprints.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetMediaFingerprints(String nodeId, APIContext context) {
      super(context, nodeId, "/media_fingerprints", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetMediaFingerprints setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetMediaFingerprints setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetMediaFingerprints setUniversalContentId (String universalContentId) {
      this.setParam("universal_content_id", universalContentId);
      return this;
    }

    public APIRequestGetMediaFingerprints requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetMediaFingerprints requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetMediaFingerprints requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetMediaFingerprints requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetMediaFingerprints requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetMediaFingerprints requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetMediaFingerprints requestDurationInSecField () {
      return this.requestDurationInSecField(true);
    }
    public APIRequestGetMediaFingerprints requestDurationInSecField (boolean value) {
      this.requestField("duration_in_sec", value);
      return this;
    }
    public APIRequestGetMediaFingerprints requestFingerprintContentTypeField () {
      return this.requestFingerprintContentTypeField(true);
    }
    public APIRequestGetMediaFingerprints requestFingerprintContentTypeField (boolean value) {
      this.requestField("fingerprint_content_type", value);
      return this;
    }
    public APIRequestGetMediaFingerprints requestFingerprintTypeField () {
      return this.requestFingerprintTypeField(true);
    }
    public APIRequestGetMediaFingerprints requestFingerprintTypeField (boolean value) {
      this.requestField("fingerprint_type", value);
      return this;
    }
    public APIRequestGetMediaFingerprints requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetMediaFingerprints requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetMediaFingerprints requestMetadataField () {
      return this.requestMetadataField(true);
    }
    public APIRequestGetMediaFingerprints requestMetadataField (boolean value) {
      this.requestField("metadata", value);
      return this;
    }
    public APIRequestGetMediaFingerprints requestTitleField () {
      return this.requestTitleField(true);
    }
    public APIRequestGetMediaFingerprints requestTitleField (boolean value) {
      this.requestField("title", value);
      return this;
    }
    public APIRequestGetMediaFingerprints requestUniversalContentIdField () {
      return this.requestUniversalContentIdField(true);
    }
    public APIRequestGetMediaFingerprints requestUniversalContentIdField (boolean value) {
      this.requestField("universal_content_id", value);
      return this;
    }
  }

  public static class APIRequestCreateMediaFingerprint extends APIRequest<MediaFingerprint> {

    MediaFingerprint lastResponse = null;
    @Override
    public MediaFingerprint getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "fingerprint_content_type",
      "metadata",
      "source",
      "title",
      "universal_content_id",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public MediaFingerprint parseResponse(String response, String header) throws APIException {
      return MediaFingerprint.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public MediaFingerprint execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public MediaFingerprint execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<MediaFingerprint> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<MediaFingerprint> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, MediaFingerprint>() {
           public MediaFingerprint apply(ResponseWrapper result) {
             try {
               return APIRequestCreateMediaFingerprint.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateMediaFingerprint(String nodeId, APIContext context) {
      super(context, nodeId, "/media_fingerprints", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateMediaFingerprint setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateMediaFingerprint setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateMediaFingerprint setFingerprintContentType (MediaFingerprint.EnumFingerprintContentType fingerprintContentType) {
      this.setParam("fingerprint_content_type", fingerprintContentType);
      return this;
    }
    public APIRequestCreateMediaFingerprint setFingerprintContentType (String fingerprintContentType) {
      this.setParam("fingerprint_content_type", fingerprintContentType);
      return this;
    }

    public APIRequestCreateMediaFingerprint setMetadata (JsonArray metadata) {
      this.setParam("metadata", metadata);
      return this;
    }
    public APIRequestCreateMediaFingerprint setMetadata (String metadata) {
      this.setParam("metadata", metadata);
      return this;
    }

    public APIRequestCreateMediaFingerprint setSource (String source) {
      this.setParam("source", source);
      return this;
    }

    public APIRequestCreateMediaFingerprint setTitle (String title) {
      this.setParam("title", title);
      return this;
    }

    public APIRequestCreateMediaFingerprint setUniversalContentId (String universalContentId) {
      this.setParam("universal_content_id", universalContentId);
      return this;
    }

    public APIRequestCreateMediaFingerprint requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateMediaFingerprint requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMediaFingerprint requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateMediaFingerprint requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMediaFingerprint requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateMediaFingerprint requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestCreateMessageAttachment extends APIRequest<APINode> {

    APINode lastResponse = null;
    @Override
    public APINode getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "message",
      "platform",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINode parseResponse(String response, String header) throws APIException {
      return APINode.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public APINode execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINode execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINode> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINode>() {
           public APINode apply(ResponseWrapper result) {
             try {
               return APIRequestCreateMessageAttachment.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateMessageAttachment(String nodeId, APIContext context) {
      super(context, nodeId, "/message_attachments", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateMessageAttachment setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateMessageAttachment setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateMessageAttachment setMessage (Object message) {
      this.setParam("message", message);
      return this;
    }
    public APIRequestCreateMessageAttachment setMessage (String message) {
      this.setParam("message", message);
      return this;
    }

    public APIRequestCreateMessageAttachment setPlatform (EnumPlatform platform) {
      this.setParam("platform", platform);
      return this;
    }
    public APIRequestCreateMessageAttachment setPlatform (String platform) {
      this.setParam("platform", platform);
      return this;
    }

    public APIRequestCreateMessageAttachment requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateMessageAttachment requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMessageAttachment requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateMessageAttachment requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMessageAttachment requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateMessageAttachment requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestDeleteMessageTemplates extends APIRequest<APINode> {

    APINodeList<APINode> lastResponse = null;
    @Override
    public APINodeList<APINode> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "name",
      "template_id",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
      return APINode.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<APINode> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<APINode>>() {
           public APINodeList<APINode> apply(ResponseWrapper result) {
             try {
               return APIRequestDeleteMessageTemplates.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestDeleteMessageTemplates(String nodeId, APIContext context) {
      super(context, nodeId, "/message_templates", "DELETE", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestDeleteMessageTemplates setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestDeleteMessageTemplates setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestDeleteMessageTemplates setName (String name) {
      this.setParam("name", name);
      return this;
    }

    public APIRequestDeleteMessageTemplates setTemplateId (String templateId) {
      this.setParam("template_id", templateId);
      return this;
    }

    public APIRequestDeleteMessageTemplates requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestDeleteMessageTemplates requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteMessageTemplates requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestDeleteMessageTemplates requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteMessageTemplates requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestDeleteMessageTemplates requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetMessageTemplates extends APIRequest<MessengerBusinessTemplate> {

    APINodeList<MessengerBusinessTemplate> lastResponse = null;
    @Override
    public APINodeList<MessengerBusinessTemplate> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "category",
      "content",
      "language",
      "name",
      "name_or_content",
      "status",
    };

    public static final String[] FIELDS = {
      "category",
      "components",
      "creation_time",
      "id",
      "language",
      "language_count",
      "last_updated_time",
      "library_template_name",
      "name",
      "rejected_reason",
      "rejection_reasons",
      "specific_rejection_reasons",
      "status",
    };

    @Override
    public APINodeList<MessengerBusinessTemplate> parseResponse(String response, String header) throws APIException {
      return MessengerBusinessTemplate.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<MessengerBusinessTemplate> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<MessengerBusinessTemplate> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<MessengerBusinessTemplate>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<MessengerBusinessTemplate>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<MessengerBusinessTemplate>>() {
           public APINodeList<MessengerBusinessTemplate> apply(ResponseWrapper result) {
             try {
               return APIRequestGetMessageTemplates.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetMessageTemplates(String nodeId, APIContext context) {
      super(context, nodeId, "/message_templates", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetMessageTemplates setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetMessageTemplates setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetMessageTemplates setCategory (List<Page.EnumCategory> category) {
      this.setParam("category", category);
      return this;
    }
    public APIRequestGetMessageTemplates setCategory (String category) {
      this.setParam("category", category);
      return this;
    }

    public APIRequestGetMessageTemplates setContent (String content) {
      this.setParam("content", content);
      return this;
    }

    public APIRequestGetMessageTemplates setLanguage (List<String> language) {
      this.setParam("language", language);
      return this;
    }
    public APIRequestGetMessageTemplates setLanguage (String language) {
      this.setParam("language", language);
      return this;
    }

    public APIRequestGetMessageTemplates setName (String name) {
      this.setParam("name", name);
      return this;
    }

    public APIRequestGetMessageTemplates setNameOrContent (String nameOrContent) {
      this.setParam("name_or_content", nameOrContent);
      return this;
    }

    public APIRequestGetMessageTemplates setStatus (List<MessengerBusinessTemplate.EnumStatus> status) {
      this.setParam("status", status);
      return this;
    }
    public APIRequestGetMessageTemplates setStatus (String status) {
      this.setParam("status", status);
      return this;
    }

    public APIRequestGetMessageTemplates requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetMessageTemplates requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetMessageTemplates requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetMessageTemplates requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetMessageTemplates requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetMessageTemplates requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetMessageTemplates requestCategoryField () {
      return this.requestCategoryField(true);
    }
    public APIRequestGetMessageTemplates requestCategoryField (boolean value) {
      this.requestField("category", value);
      return this;
    }
    public APIRequestGetMessageTemplates requestComponentsField () {
      return this.requestComponentsField(true);
    }
    public APIRequestGetMessageTemplates requestComponentsField (boolean value) {
      this.requestField("components", value);
      return this;
    }
    public APIRequestGetMessageTemplates requestCreationTimeField () {
      return this.requestCreationTimeField(true);
    }
    public APIRequestGetMessageTemplates requestCreationTimeField (boolean value) {
      this.requestField("creation_time", value);
      return this;
    }
    public APIRequestGetMessageTemplates requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetMessageTemplates requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetMessageTemplates requestLanguageField () {
      return this.requestLanguageField(true);
    }
    public APIRequestGetMessageTemplates requestLanguageField (boolean value) {
      this.requestField("language", value);
      return this;
    }
    public APIRequestGetMessageTemplates requestLanguageCountField () {
      return this.requestLanguageCountField(true);
    }
    public APIRequestGetMessageTemplates requestLanguageCountField (boolean value) {
      this.requestField("language_count", value);
      return this;
    }
    public APIRequestGetMessageTemplates requestLastUpdatedTimeField () {
      return this.requestLastUpdatedTimeField(true);
    }
    public APIRequestGetMessageTemplates requestLastUpdatedTimeField (boolean value) {
      this.requestField("last_updated_time", value);
      return this;
    }
    public APIRequestGetMessageTemplates requestLibraryTemplateNameField () {
      return this.requestLibraryTemplateNameField(true);
    }
    public APIRequestGetMessageTemplates requestLibraryTemplateNameField (boolean value) {
      this.requestField("library_template_name", value);
      return this;
    }
    public APIRequestGetMessageTemplates requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetMessageTemplates requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetMessageTemplates requestRejectedReasonField () {
      return this.requestRejectedReasonField(true);
    }
    public APIRequestGetMessageTemplates requestRejectedReasonField (boolean value) {
      this.requestField("rejected_reason", value);
      return this;
    }
    public APIRequestGetMessageTemplates requestRejectionReasonsField () {
      return this.requestRejectionReasonsField(true);
    }
    public APIRequestGetMessageTemplates requestRejectionReasonsField (boolean value) {
      this.requestField("rejection_reasons", value);
      return this;
    }
    public APIRequestGetMessageTemplates requestSpecificRejectionReasonsField () {
      return this.requestSpecificRejectionReasonsField(true);
    }
    public APIRequestGetMessageTemplates requestSpecificRejectionReasonsField (boolean value) {
      this.requestField("specific_rejection_reasons", value);
      return this;
    }
    public APIRequestGetMessageTemplates requestStatusField () {
      return this.requestStatusField(true);
    }
    public APIRequestGetMessageTemplates requestStatusField (boolean value) {
      this.requestField("status", value);
      return this;
    }
  }

  public static class APIRequestCreateMessageTemplate extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "category",
      "components",
      "language",
      "library_template_button_inputs",
      "library_template_name",
      "name",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response, String header) throws APIException {
      return Page.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, Page>() {
           public Page apply(ResponseWrapper result) {
             try {
               return APIRequestCreateMessageTemplate.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateMessageTemplate(String nodeId, APIContext context) {
      super(context, nodeId, "/message_templates", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateMessageTemplate setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateMessageTemplate setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateMessageTemplate setCategory (Page.EnumCategory category) {
      this.setParam("category", category);
      return this;
    }
    public APIRequestCreateMessageTemplate setCategory (String category) {
      this.setParam("category", category);
      return this;
    }

    public APIRequestCreateMessageTemplate setComponents (List<Map<String, String>> components) {
      this.setParam("components", components);
      return this;
    }
    public APIRequestCreateMessageTemplate setComponents (String components) {
      this.setParam("components", components);
      return this;
    }

    public APIRequestCreateMessageTemplate setLanguage (String language) {
      this.setParam("language", language);
      return this;
    }

    public APIRequestCreateMessageTemplate setLibraryTemplateButtonInputs (List<Map<String, String>> libraryTemplateButtonInputs) {
      this.setParam("library_template_button_inputs", libraryTemplateButtonInputs);
      return this;
    }
    public APIRequestCreateMessageTemplate setLibraryTemplateButtonInputs (String libraryTemplateButtonInputs) {
      this.setParam("library_template_button_inputs", libraryTemplateButtonInputs);
      return this;
    }

    public APIRequestCreateMessageTemplate setLibraryTemplateName (String libraryTemplateName) {
      this.setParam("library_template_name", libraryTemplateName);
      return this;
    }

    public APIRequestCreateMessageTemplate setName (String name) {
      this.setParam("name", name);
      return this;
    }

    public APIRequestCreateMessageTemplate requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateMessageTemplate requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMessageTemplate requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateMessageTemplate requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMessageTemplate requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateMessageTemplate requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestCreateMessage extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "message",
      "messaging_type",
      "notification_type",
      "payload",
      "persona_id",
      "recipient",
      "reply_to",
      "sender_action",
      "suggestion_action",
      "tag",
      "thread_control",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response, String header) throws APIException {
      return Page.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, Page>() {
           public Page apply(ResponseWrapper result) {
             try {
               return APIRequestCreateMessage.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateMessage(String nodeId, APIContext context) {
      super(context, nodeId, "/messages", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateMessage setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateMessage setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateMessage setMessage (Object message) {
      this.setParam("message", message);
      return this;
    }
    public APIRequestCreateMessage setMessage (String message) {
      this.setParam("message", message);
      return this;
    }

    public APIRequestCreateMessage setMessagingType (Page.EnumMessagingType messagingType) {
      this.setParam("messaging_type", messagingType);
      return this;
    }
    public APIRequestCreateMessage setMessagingType (String messagingType) {
      this.setParam("messaging_type", messagingType);
      return this;
    }

    public APIRequestCreateMessage setNotificationType (Page.EnumNotificationType notificationType) {
      this.setParam("notification_type", notificationType);
      return this;
    }
    public APIRequestCreateMessage setNotificationType (String notificationType) {
      this.setParam("notification_type", notificationType);
      return this;
    }

    public APIRequestCreateMessage setPayload (String payload) {
      this.setParam("payload", payload);
      return this;
    }

    public APIRequestCreateMessage setPersonaId (String personaId) {
      this.setParam("persona_id", personaId);
      return this;
    }

    public APIRequestCreateMessage setRecipient (Object recipient) {
      this.setParam("recipient", recipient);
      return this;
    }
    public APIRequestCreateMessage setRecipient (String recipient) {
      this.setParam("recipient", recipient);
      return this;
    }

    public APIRequestCreateMessage setReplyTo (Object replyTo) {
      this.setParam("reply_to", replyTo);
      return this;
    }
    public APIRequestCreateMessage setReplyTo (String replyTo) {
      this.setParam("reply_to", replyTo);
      return this;
    }

    public APIRequestCreateMessage setSenderAction (Page.EnumSenderAction senderAction) {
      this.setParam("sender_action", senderAction);
      return this;
    }
    public APIRequestCreateMessage setSenderAction (String senderAction) {
      this.setParam("sender_action", senderAction);
      return this;
    }

    public APIRequestCreateMessage setSuggestionAction (Page.EnumSuggestionAction suggestionAction) {
      this.setParam("suggestion_action", suggestionAction);
      return this;
    }
    public APIRequestCreateMessage setSuggestionAction (String suggestionAction) {
      this.setParam("suggestion_action", suggestionAction);
      return this;
    }

    public APIRequestCreateMessage setTag (Object tag) {
      this.setParam("tag", tag);
      return this;
    }
    public APIRequestCreateMessage setTag (String tag) {
      this.setParam("tag", tag);
      return this;
    }

    public APIRequestCreateMessage setThreadControl (Object threadControl) {
      this.setParam("thread_control", threadControl);
      return this;
    }
    public APIRequestCreateMessage setThreadControl (String threadControl) {
      this.setParam("thread_control", threadControl);
      return this;
    }

    public APIRequestCreateMessage requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateMessage requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMessage requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateMessage requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMessage requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateMessage requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetMessagingFeatureReview extends APIRequest<MessagingFeatureReview> {

    APINodeList<MessagingFeatureReview> lastResponse = null;
    @Override
    public APINodeList<MessagingFeatureReview> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "feature",
      "status",
    };

    @Override
    public APINodeList<MessagingFeatureReview> parseResponse(String response, String header) throws APIException {
      return MessagingFeatureReview.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<MessagingFeatureReview> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<MessagingFeatureReview> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<MessagingFeatureReview>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<MessagingFeatureReview>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<MessagingFeatureReview>>() {
           public APINodeList<MessagingFeatureReview> apply(ResponseWrapper result) {
             try {
               return APIRequestGetMessagingFeatureReview.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetMessagingFeatureReview(String nodeId, APIContext context) {
      super(context, nodeId, "/messaging_feature_review", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetMessagingFeatureReview setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetMessagingFeatureReview setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetMessagingFeatureReview requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetMessagingFeatureReview requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetMessagingFeatureReview requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetMessagingFeatureReview requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetMessagingFeatureReview requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetMessagingFeatureReview requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetMessagingFeatureReview requestFeatureField () {
      return this.requestFeatureField(true);
    }
    public APIRequestGetMessagingFeatureReview requestFeatureField (boolean value) {
      this.requestField("feature", value);
      return this;
    }
    public APIRequestGetMessagingFeatureReview requestStatusField () {
      return this.requestStatusField(true);
    }
    public APIRequestGetMessagingFeatureReview requestStatusField (boolean value) {
      this.requestField("status", value);
      return this;
    }
  }

  public static class APIRequestGetMessengerCallSettings extends APIRequest<MessengerCallSettings> {

    APINodeList<MessengerCallSettings> lastResponse = null;
    @Override
    public APINodeList<MessengerCallSettings> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "audio_enabled",
      "call_hours",
      "call_routing",
      "icon_enabled",
      "video",
    };

    @Override
    public APINodeList<MessengerCallSettings> parseResponse(String response, String header) throws APIException {
      return MessengerCallSettings.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<MessengerCallSettings> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<MessengerCallSettings> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<MessengerCallSettings>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<MessengerCallSettings>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<MessengerCallSettings>>() {
           public APINodeList<MessengerCallSettings> apply(ResponseWrapper result) {
             try {
               return APIRequestGetMessengerCallSettings.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetMessengerCallSettings(String nodeId, APIContext context) {
      super(context, nodeId, "/messenger_call_settings", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetMessengerCallSettings setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetMessengerCallSettings setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetMessengerCallSettings requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetMessengerCallSettings requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetMessengerCallSettings requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetMessengerCallSettings requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetMessengerCallSettings requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetMessengerCallSettings requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetMessengerCallSettings requestAudioEnabledField () {
      return this.requestAudioEnabledField(true);
    }
    public APIRequestGetMessengerCallSettings requestAudioEnabledField (boolean value) {
      this.requestField("audio_enabled", value);
      return this;
    }
    public APIRequestGetMessengerCallSettings requestCallHoursField () {
      return this.requestCallHoursField(true);
    }
    public APIRequestGetMessengerCallSettings requestCallHoursField (boolean value) {
      this.requestField("call_hours", value);
      return this;
    }
    public APIRequestGetMessengerCallSettings requestCallRoutingField () {
      return this.requestCallRoutingField(true);
    }
    public APIRequestGetMessengerCallSettings requestCallRoutingField (boolean value) {
      this.requestField("call_routing", value);
      return this;
    }
    public APIRequestGetMessengerCallSettings requestIconEnabledField () {
      return this.requestIconEnabledField(true);
    }
    public APIRequestGetMessengerCallSettings requestIconEnabledField (boolean value) {
      this.requestField("icon_enabled", value);
      return this;
    }
    public APIRequestGetMessengerCallSettings requestVideoField () {
      return this.requestVideoField(true);
    }
    public APIRequestGetMessengerCallSettings requestVideoField (boolean value) {
      this.requestField("video", value);
      return this;
    }
  }

  public static class APIRequestCreateMessengerCallSetting extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "audio_enabled",
      "call_hours",
      "call_routing",
      "icon_enabled",
      "video",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response, String header) throws APIException {
      return Page.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, Page>() {
           public Page apply(ResponseWrapper result) {
             try {
               return APIRequestCreateMessengerCallSetting.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateMessengerCallSetting(String nodeId, APIContext context) {
      super(context, nodeId, "/messenger_call_settings", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateMessengerCallSetting setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateMessengerCallSetting setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateMessengerCallSetting setAudioEnabled (Boolean audioEnabled) {
      this.setParam("audio_enabled", audioEnabled);
      return this;
    }
    public APIRequestCreateMessengerCallSetting setAudioEnabled (String audioEnabled) {
      this.setParam("audio_enabled", audioEnabled);
      return this;
    }

    public APIRequestCreateMessengerCallSetting setCallHours (Map<String, String> callHours) {
      this.setParam("call_hours", callHours);
      return this;
    }
    public APIRequestCreateMessengerCallSetting setCallHours (String callHours) {
      this.setParam("call_hours", callHours);
      return this;
    }

    public APIRequestCreateMessengerCallSetting setCallRouting (Map<String, String> callRouting) {
      this.setParam("call_routing", callRouting);
      return this;
    }
    public APIRequestCreateMessengerCallSetting setCallRouting (String callRouting) {
      this.setParam("call_routing", callRouting);
      return this;
    }

    public APIRequestCreateMessengerCallSetting setIconEnabled (Boolean iconEnabled) {
      this.setParam("icon_enabled", iconEnabled);
      return this;
    }
    public APIRequestCreateMessengerCallSetting setIconEnabled (String iconEnabled) {
      this.setParam("icon_enabled", iconEnabled);
      return this;
    }

    public APIRequestCreateMessengerCallSetting setVideo (Map<String, String> video) {
      this.setParam("video", video);
      return this;
    }
    public APIRequestCreateMessengerCallSetting setVideo (String video) {
      this.setParam("video", video);
      return this;
    }

    public APIRequestCreateMessengerCallSetting requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateMessengerCallSetting requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMessengerCallSetting requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateMessengerCallSetting requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMessengerCallSetting requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateMessengerCallSetting requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetMessengerLeadForms extends APIRequest<MessengerAdsPartialAutomatedStepList> {

    APINodeList<MessengerAdsPartialAutomatedStepList> lastResponse = null;
    @Override
    public APINodeList<MessengerAdsPartialAutomatedStepList> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "fblead_form",
      "first_step_id",
      "id",
      "page",
      "privacy_url",
      "reminder_text",
      "stop_question_message",
    };

    @Override
    public APINodeList<MessengerAdsPartialAutomatedStepList> parseResponse(String response, String header) throws APIException {
      return MessengerAdsPartialAutomatedStepList.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<MessengerAdsPartialAutomatedStepList> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<MessengerAdsPartialAutomatedStepList> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<MessengerAdsPartialAutomatedStepList>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<MessengerAdsPartialAutomatedStepList>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<MessengerAdsPartialAutomatedStepList>>() {
           public APINodeList<MessengerAdsPartialAutomatedStepList> apply(ResponseWrapper result) {
             try {
               return APIRequestGetMessengerLeadForms.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetMessengerLeadForms(String nodeId, APIContext context) {
      super(context, nodeId, "/messenger_lead_forms", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetMessengerLeadForms setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetMessengerLeadForms setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetMessengerLeadForms requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetMessengerLeadForms requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetMessengerLeadForms requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetMessengerLeadForms requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetMessengerLeadForms requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetMessengerLeadForms requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetMessengerLeadForms requestFbleadFormField () {
      return this.requestFbleadFormField(true);
    }
    public APIRequestGetMessengerLeadForms requestFbleadFormField (boolean value) {
      this.requestField("fblead_form", value);
      return this;
    }
    public APIRequestGetMessengerLeadForms requestFirstStepIdField () {
      return this.requestFirstStepIdField(true);
    }
    public APIRequestGetMessengerLeadForms requestFirstStepIdField (boolean value) {
      this.requestField("first_step_id", value);
      return this;
    }
    public APIRequestGetMessengerLeadForms requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetMessengerLeadForms requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetMessengerLeadForms requestPageField () {
      return this.requestPageField(true);
    }
    public APIRequestGetMessengerLeadForms requestPageField (boolean value) {
      this.requestField("page", value);
      return this;
    }
    public APIRequestGetMessengerLeadForms requestPrivacyUrlField () {
      return this.requestPrivacyUrlField(true);
    }
    public APIRequestGetMessengerLeadForms requestPrivacyUrlField (boolean value) {
      this.requestField("privacy_url", value);
      return this;
    }
    public APIRequestGetMessengerLeadForms requestReminderTextField () {
      return this.requestReminderTextField(true);
    }
    public APIRequestGetMessengerLeadForms requestReminderTextField (boolean value) {
      this.requestField("reminder_text", value);
      return this;
    }
    public APIRequestGetMessengerLeadForms requestStopQuestionMessageField () {
      return this.requestStopQuestionMessageField(true);
    }
    public APIRequestGetMessengerLeadForms requestStopQuestionMessageField (boolean value) {
      this.requestField("stop_question_message", value);
      return this;
    }
  }

  public static class APIRequestCreateMessengerLeadForm extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "account_id",
      "block_send_api",
      "exit_keyphrases",
      "handover_app_id",
      "handover_summary",
      "privacy_url",
      "reminder_text",
      "step_list",
      "stop_question_message",
      "template_name",
      "tracking_parameters",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response, String header) throws APIException {
      return Page.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, Page>() {
           public Page apply(ResponseWrapper result) {
             try {
               return APIRequestCreateMessengerLeadForm.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateMessengerLeadForm(String nodeId, APIContext context) {
      super(context, nodeId, "/messenger_lead_forms", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateMessengerLeadForm setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateMessengerLeadForm setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateMessengerLeadForm setAccountId (Long accountId) {
      this.setParam("account_id", accountId);
      return this;
    }
    public APIRequestCreateMessengerLeadForm setAccountId (String accountId) {
      this.setParam("account_id", accountId);
      return this;
    }

    public APIRequestCreateMessengerLeadForm setBlockSendApi (Boolean blockSendApi) {
      this.setParam("block_send_api", blockSendApi);
      return this;
    }
    public APIRequestCreateMessengerLeadForm setBlockSendApi (String blockSendApi) {
      this.setParam("block_send_api", blockSendApi);
      return this;
    }

    public APIRequestCreateMessengerLeadForm setExitKeyphrases (String exitKeyphrases) {
      this.setParam("exit_keyphrases", exitKeyphrases);
      return this;
    }

    public APIRequestCreateMessengerLeadForm setHandoverAppId (Long handoverAppId) {
      this.setParam("handover_app_id", handoverAppId);
      return this;
    }
    public APIRequestCreateMessengerLeadForm setHandoverAppId (String handoverAppId) {
      this.setParam("handover_app_id", handoverAppId);
      return this;
    }

    public APIRequestCreateMessengerLeadForm setHandoverSummary (Boolean handoverSummary) {
      this.setParam("handover_summary", handoverSummary);
      return this;
    }
    public APIRequestCreateMessengerLeadForm setHandoverSummary (String handoverSummary) {
      this.setParam("handover_summary", handoverSummary);
      return this;
    }

    public APIRequestCreateMessengerLeadForm setPrivacyUrl (String privacyUrl) {
      this.setParam("privacy_url", privacyUrl);
      return this;
    }

    public APIRequestCreateMessengerLeadForm setReminderText (String reminderText) {
      this.setParam("reminder_text", reminderText);
      return this;
    }

    public APIRequestCreateMessengerLeadForm setStepList (List<Map<String, String>> stepList) {
      this.setParam("step_list", stepList);
      return this;
    }
    public APIRequestCreateMessengerLeadForm setStepList (String stepList) {
      this.setParam("step_list", stepList);
      return this;
    }

    public APIRequestCreateMessengerLeadForm setStopQuestionMessage (String stopQuestionMessage) {
      this.setParam("stop_question_message", stopQuestionMessage);
      return this;
    }

    public APIRequestCreateMessengerLeadForm setTemplateName (String templateName) {
      this.setParam("template_name", templateName);
      return this;
    }

    public APIRequestCreateMessengerLeadForm setTrackingParameters (Map<String, String> trackingParameters) {
      this.setParam("tracking_parameters", trackingParameters);
      return this;
    }
    public APIRequestCreateMessengerLeadForm setTrackingParameters (String trackingParameters) {
      this.setParam("tracking_parameters", trackingParameters);
      return this;
    }

    public APIRequestCreateMessengerLeadForm requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateMessengerLeadForm requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMessengerLeadForm requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateMessengerLeadForm requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMessengerLeadForm requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateMessengerLeadForm requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestDeleteMessengerProfile extends APIRequest<APINode> {

    APINodeList<APINode> lastResponse = null;
    @Override
    public APINodeList<APINode> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "fields",
      "platform",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
      return APINode.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<APINode> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<APINode>>() {
           public APINodeList<APINode> apply(ResponseWrapper result) {
             try {
               return APIRequestDeleteMessengerProfile.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestDeleteMessengerProfile(String nodeId, APIContext context) {
      super(context, nodeId, "/messenger_profile", "DELETE", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestDeleteMessengerProfile setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestDeleteMessengerProfile setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestDeleteMessengerProfile setFields (List<EnumFields> fields) {
      this.setParam("fields", fields);
      return this;
    }
    public APIRequestDeleteMessengerProfile setFields (String fields) {
      this.setParam("fields", fields);
      return this;
    }

    public APIRequestDeleteMessengerProfile setPlatform (Page.EnumPlatform platform) {
      this.setParam("platform", platform);
      return this;
    }
    public APIRequestDeleteMessengerProfile setPlatform (String platform) {
      this.setParam("platform", platform);
      return this;
    }

    public APIRequestDeleteMessengerProfile requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestDeleteMessengerProfile requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteMessengerProfile requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestDeleteMessengerProfile requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteMessengerProfile requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestDeleteMessengerProfile requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetMessengerProfile extends APIRequest<MessengerProfile> {

    APINodeList<MessengerProfile> lastResponse = null;
    @Override
    public APINodeList<MessengerProfile> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "platform",
    };

    public static final String[] FIELDS = {
      "account_linking_url",
      "commands",
      "get_started",
      "greeting",
      "ice_breakers",
      "persistent_menu",
      "subject_to_new_eu_privacy_rules",
      "whitelisted_domains",
    };

    @Override
    public APINodeList<MessengerProfile> parseResponse(String response, String header) throws APIException {
      return MessengerProfile.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<MessengerProfile> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<MessengerProfile> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<MessengerProfile>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<MessengerProfile>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<MessengerProfile>>() {
           public APINodeList<MessengerProfile> apply(ResponseWrapper result) {
             try {
               return APIRequestGetMessengerProfile.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetMessengerProfile(String nodeId, APIContext context) {
      super(context, nodeId, "/messenger_profile", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetMessengerProfile setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetMessengerProfile setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetMessengerProfile setPlatform (Page.EnumPlatform platform) {
      this.setParam("platform", platform);
      return this;
    }
    public APIRequestGetMessengerProfile setPlatform (String platform) {
      this.setParam("platform", platform);
      return this;
    }

    public APIRequestGetMessengerProfile requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetMessengerProfile requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetMessengerProfile requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetMessengerProfile requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetMessengerProfile requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetMessengerProfile requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetMessengerProfile requestAccountLinkingUrlField () {
      return this.requestAccountLinkingUrlField(true);
    }
    public APIRequestGetMessengerProfile requestAccountLinkingUrlField (boolean value) {
      this.requestField("account_linking_url", value);
      return this;
    }
    public APIRequestGetMessengerProfile requestCommandsField () {
      return this.requestCommandsField(true);
    }
    public APIRequestGetMessengerProfile requestCommandsField (boolean value) {
      this.requestField("commands", value);
      return this;
    }
    public APIRequestGetMessengerProfile requestGetStartedField () {
      return this.requestGetStartedField(true);
    }
    public APIRequestGetMessengerProfile requestGetStartedField (boolean value) {
      this.requestField("get_started", value);
      return this;
    }
    public APIRequestGetMessengerProfile requestGreetingField () {
      return this.requestGreetingField(true);
    }
    public APIRequestGetMessengerProfile requestGreetingField (boolean value) {
      this.requestField("greeting", value);
      return this;
    }
    public APIRequestGetMessengerProfile requestIceBreakersField () {
      return this.requestIceBreakersField(true);
    }
    public APIRequestGetMessengerProfile requestIceBreakersField (boolean value) {
      this.requestField("ice_breakers", value);
      return this;
    }
    public APIRequestGetMessengerProfile requestPersistentMenuField () {
      return this.requestPersistentMenuField(true);
    }
    public APIRequestGetMessengerProfile requestPersistentMenuField (boolean value) {
      this.requestField("persistent_menu", value);
      return this;
    }
    public APIRequestGetMessengerProfile requestSubjectToNewEuPrivacyRulesField () {
      return this.requestSubjectToNewEuPrivacyRulesField(true);
    }
    public APIRequestGetMessengerProfile requestSubjectToNewEuPrivacyRulesField (boolean value) {
      this.requestField("subject_to_new_eu_privacy_rules", value);
      return this;
    }
    public APIRequestGetMessengerProfile requestWhitelistedDomainsField () {
      return this.requestWhitelistedDomainsField(true);
    }
    public APIRequestGetMessengerProfile requestWhitelistedDomainsField (boolean value) {
      this.requestField("whitelisted_domains", value);
      return this;
    }
  }

  public static class APIRequestCreateMessengerProfile extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "account_linking_url",
      "commands",
      "description",
      "get_started",
      "greeting",
      "ice_breakers",
      "persistent_menu",
      "platform",
      "title",
      "whitelisted_domains",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response, String header) throws APIException {
      return Page.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, Page>() {
           public Page apply(ResponseWrapper result) {
             try {
               return APIRequestCreateMessengerProfile.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateMessengerProfile(String nodeId, APIContext context) {
      super(context, nodeId, "/messenger_profile", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateMessengerProfile setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateMessengerProfile setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateMessengerProfile setAccountLinkingUrl (String accountLinkingUrl) {
      this.setParam("account_linking_url", accountLinkingUrl);
      return this;
    }

    public APIRequestCreateMessengerProfile setCommands (List<Object> commands) {
      this.setParam("commands", commands);
      return this;
    }
    public APIRequestCreateMessengerProfile setCommands (String commands) {
      this.setParam("commands", commands);
      return this;
    }

    public APIRequestCreateMessengerProfile setDescription (List<Object> description) {
      this.setParam("description", description);
      return this;
    }
    public APIRequestCreateMessengerProfile setDescription (String description) {
      this.setParam("description", description);
      return this;
    }

    public APIRequestCreateMessengerProfile setGetStarted (Object getStarted) {
      this.setParam("get_started", getStarted);
      return this;
    }
    public APIRequestCreateMessengerProfile setGetStarted (String getStarted) {
      this.setParam("get_started", getStarted);
      return this;
    }

    public APIRequestCreateMessengerProfile setGreeting (List<Object> greeting) {
      this.setParam("greeting", greeting);
      return this;
    }
    public APIRequestCreateMessengerProfile setGreeting (String greeting) {
      this.setParam("greeting", greeting);
      return this;
    }

    public APIRequestCreateMessengerProfile setIceBreakers (List<Map<String, String>> iceBreakers) {
      this.setParam("ice_breakers", iceBreakers);
      return this;
    }
    public APIRequestCreateMessengerProfile setIceBreakers (String iceBreakers) {
      this.setParam("ice_breakers", iceBreakers);
      return this;
    }

    public APIRequestCreateMessengerProfile setPersistentMenu (List<Object> persistentMenu) {
      this.setParam("persistent_menu", persistentMenu);
      return this;
    }
    public APIRequestCreateMessengerProfile setPersistentMenu (String persistentMenu) {
      this.setParam("persistent_menu", persistentMenu);
      return this;
    }

    public APIRequestCreateMessengerProfile setPlatform (Page.EnumPlatform platform) {
      this.setParam("platform", platform);
      return this;
    }
    public APIRequestCreateMessengerProfile setPlatform (String platform) {
      this.setParam("platform", platform);
      return this;
    }

    public APIRequestCreateMessengerProfile setTitle (List<Object> title) {
      this.setParam("title", title);
      return this;
    }
    public APIRequestCreateMessengerProfile setTitle (String title) {
      this.setParam("title", title);
      return this;
    }

    public APIRequestCreateMessengerProfile setWhitelistedDomains (List<String> whitelistedDomains) {
      this.setParam("whitelisted_domains", whitelistedDomains);
      return this;
    }
    public APIRequestCreateMessengerProfile setWhitelistedDomains (String whitelistedDomains) {
      this.setParam("whitelisted_domains", whitelistedDomains);
      return this;
    }

    public APIRequestCreateMessengerProfile requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateMessengerProfile requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMessengerProfile requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateMessengerProfile requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMessengerProfile requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateMessengerProfile requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestCreateModerateConversation extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "actions",
      "user_ids",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response, String header) throws APIException {
      return Page.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, Page>() {
           public Page apply(ResponseWrapper result) {
             try {
               return APIRequestCreateModerateConversation.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateModerateConversation(String nodeId, APIContext context) {
      super(context, nodeId, "/moderate_conversations", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateModerateConversation setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateModerateConversation setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateModerateConversation setActions (List<Page.EnumActions> actions) {
      this.setParam("actions", actions);
      return this;
    }
    public APIRequestCreateModerateConversation setActions (String actions) {
      this.setParam("actions", actions);
      return this;
    }

    public APIRequestCreateModerateConversation setUserIds (List<Map<String, String>> userIds) {
      this.setParam("user_ids", userIds);
      return this;
    }
    public APIRequestCreateModerateConversation setUserIds (String userIds) {
      this.setParam("user_ids", userIds);
      return this;
    }

    public APIRequestCreateModerateConversation requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateModerateConversation requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateModerateConversation requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateModerateConversation requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateModerateConversation requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateModerateConversation requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestCreateNlpConfig extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "api_version",
      "custom_token",
      "model",
      "n_best",
      "nlp_enabled",
      "other_language_support",
      "verbose",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response, String header) throws APIException {
      return Page.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, Page>() {
           public Page apply(ResponseWrapper result) {
             try {
               return APIRequestCreateNlpConfig.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateNlpConfig(String nodeId, APIContext context) {
      super(context, nodeId, "/nlp_configs", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateNlpConfig setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateNlpConfig setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateNlpConfig setApiVersion (Object apiVersion) {
      this.setParam("api_version", apiVersion);
      return this;
    }
    public APIRequestCreateNlpConfig setApiVersion (String apiVersion) {
      this.setParam("api_version", apiVersion);
      return this;
    }

    public APIRequestCreateNlpConfig setCustomToken (String customToken) {
      this.setParam("custom_token", customToken);
      return this;
    }

    public APIRequestCreateNlpConfig setModel (Page.EnumModel model) {
      this.setParam("model", model);
      return this;
    }
    public APIRequestCreateNlpConfig setModel (String model) {
      this.setParam("model", model);
      return this;
    }

    public APIRequestCreateNlpConfig setNBest (Long nBest) {
      this.setParam("n_best", nBest);
      return this;
    }
    public APIRequestCreateNlpConfig setNBest (String nBest) {
      this.setParam("n_best", nBest);
      return this;
    }

    public APIRequestCreateNlpConfig setNlpEnabled (Boolean nlpEnabled) {
      this.setParam("nlp_enabled", nlpEnabled);
      return this;
    }
    public APIRequestCreateNlpConfig setNlpEnabled (String nlpEnabled) {
      this.setParam("nlp_enabled", nlpEnabled);
      return this;
    }

    public APIRequestCreateNlpConfig setOtherLanguageSupport (Map<String, String> otherLanguageSupport) {
      this.setParam("other_language_support", otherLanguageSupport);
      return this;
    }
    public APIRequestCreateNlpConfig setOtherLanguageSupport (String otherLanguageSupport) {
      this.setParam("other_language_support", otherLanguageSupport);
      return this;
    }

    public APIRequestCreateNlpConfig setVerbose (Boolean verbose) {
      this.setParam("verbose", verbose);
      return this;
    }
    public APIRequestCreateNlpConfig setVerbose (String verbose) {
      this.setParam("verbose", verbose);
      return this;
    }

    public APIRequestCreateNlpConfig requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateNlpConfig requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateNlpConfig requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateNlpConfig requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateNlpConfig requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateNlpConfig requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetNotificationMessageTokens extends APIRequest<UserPageOneTimeOptInTokenSettings> {

    APINodeList<UserPageOneTimeOptInTokenSettings> lastResponse = null;
    @Override
    public APINodeList<UserPageOneTimeOptInTokenSettings> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "custom_audience_ids",
    };

    public static final String[] FIELDS = {
      "creation_timestamp",
      "custom_audience_ids",
      "next_eligible_time",
      "next_eligible_time_for_paid_messaging",
      "notification_messages_frequency",
      "notification_messages_reoptin",
      "notification_messages_timezone",
      "notification_messages_token",
      "recipient_id",
      "token_expiry_timestamp",
      "topic_title",
      "user_token_status",
      "id",
    };

    @Override
    public APINodeList<UserPageOneTimeOptInTokenSettings> parseResponse(String response, String header) throws APIException {
      return UserPageOneTimeOptInTokenSettings.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<UserPageOneTimeOptInTokenSettings> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<UserPageOneTimeOptInTokenSettings> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<UserPageOneTimeOptInTokenSettings>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<UserPageOneTimeOptInTokenSettings>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<UserPageOneTimeOptInTokenSettings>>() {
           public APINodeList<UserPageOneTimeOptInTokenSettings> apply(ResponseWrapper result) {
             try {
               return APIRequestGetNotificationMessageTokens.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetNotificationMessageTokens(String nodeId, APIContext context) {
      super(context, nodeId, "/notification_message_tokens", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetNotificationMessageTokens setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetNotificationMessageTokens setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetNotificationMessageTokens setCustomAudienceIds (List<String> customAudienceIds) {
      this.setParam("custom_audience_ids", customAudienceIds);
      return this;
    }
    public APIRequestGetNotificationMessageTokens setCustomAudienceIds (String customAudienceIds) {
      this.setParam("custom_audience_ids", customAudienceIds);
      return this;
    }

    public APIRequestGetNotificationMessageTokens requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetNotificationMessageTokens requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetNotificationMessageTokens requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetNotificationMessageTokens requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetNotificationMessageTokens requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetNotificationMessageTokens requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetNotificationMessageTokens requestCreationTimestampField () {
      return this.requestCreationTimestampField(true);
    }
    public APIRequestGetNotificationMessageTokens requestCreationTimestampField (boolean value) {
      this.requestField("creation_timestamp", value);
      return this;
    }
    public APIRequestGetNotificationMessageTokens requestCustomAudienceIdsField () {
      return this.requestCustomAudienceIdsField(true);
    }
    public APIRequestGetNotificationMessageTokens requestCustomAudienceIdsField (boolean value) {
      this.requestField("custom_audience_ids", value);
      return this;
    }
    public APIRequestGetNotificationMessageTokens requestNextEligibleTimeField () {
      return this.requestNextEligibleTimeField(true);
    }
    public APIRequestGetNotificationMessageTokens requestNextEligibleTimeField (boolean value) {
      this.requestField("next_eligible_time", value);
      return this;
    }
    public APIRequestGetNotificationMessageTokens requestNextEligibleTimeForPaidMessagingField () {
      return this.requestNextEligibleTimeForPaidMessagingField(true);
    }
    public APIRequestGetNotificationMessageTokens requestNextEligibleTimeForPaidMessagingField (boolean value) {
      this.requestField("next_eligible_time_for_paid_messaging", value);
      return this;
    }
    public APIRequestGetNotificationMessageTokens requestNotificationMessagesFrequencyField () {
      return this.requestNotificationMessagesFrequencyField(true);
    }
    public APIRequestGetNotificationMessageTokens requestNotificationMessagesFrequencyField (boolean value) {
      this.requestField("notification_messages_frequency", value);
      return this;
    }
    public APIRequestGetNotificationMessageTokens requestNotificationMessagesReoptinField () {
      return this.requestNotificationMessagesReoptinField(true);
    }
    public APIRequestGetNotificationMessageTokens requestNotificationMessagesReoptinField (boolean value) {
      this.requestField("notification_messages_reoptin", value);
      return this;
    }
    public APIRequestGetNotificationMessageTokens requestNotificationMessagesTimezoneField () {
      return this.requestNotificationMessagesTimezoneField(true);
    }
    public APIRequestGetNotificationMessageTokens requestNotificationMessagesTimezoneField (boolean value) {
      this.requestField("notification_messages_timezone", value);
      return this;
    }
    public APIRequestGetNotificationMessageTokens requestNotificationMessagesTokenField () {
      return this.requestNotificationMessagesTokenField(true);
    }
    public APIRequestGetNotificationMessageTokens requestNotificationMessagesTokenField (boolean value) {
      this.requestField("notification_messages_token", value);
      return this;
    }
    public APIRequestGetNotificationMessageTokens requestRecipientIdField () {
      return this.requestRecipientIdField(true);
    }
    public APIRequestGetNotificationMessageTokens requestRecipientIdField (boolean value) {
      this.requestField("recipient_id", value);
      return this;
    }
    public APIRequestGetNotificationMessageTokens requestTokenExpiryTimestampField () {
      return this.requestTokenExpiryTimestampField(true);
    }
    public APIRequestGetNotificationMessageTokens requestTokenExpiryTimestampField (boolean value) {
      this.requestField("token_expiry_timestamp", value);
      return this;
    }
    public APIRequestGetNotificationMessageTokens requestTopicTitleField () {
      return this.requestTopicTitleField(true);
    }
    public APIRequestGetNotificationMessageTokens requestTopicTitleField (boolean value) {
      this.requestField("topic_title", value);
      return this;
    }
    public APIRequestGetNotificationMessageTokens requestUserTokenStatusField () {
      return this.requestUserTokenStatusField(true);
    }
    public APIRequestGetNotificationMessageTokens requestUserTokenStatusField (boolean value) {
      this.requestField("user_token_status", value);
      return this;
    }
    public APIRequestGetNotificationMessageTokens requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetNotificationMessageTokens requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
  }

  public static class APIRequestCreateNotificationMessagesDevSupport extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "developer_action",
      "recipient",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response, String header) throws APIException {
      return Page.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, Page>() {
           public Page apply(ResponseWrapper result) {
             try {
               return APIRequestCreateNotificationMessagesDevSupport.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateNotificationMessagesDevSupport(String nodeId, APIContext context) {
      super(context, nodeId, "/notification_messages_dev_support", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateNotificationMessagesDevSupport setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateNotificationMessagesDevSupport setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateNotificationMessagesDevSupport setDeveloperAction (Page.EnumDeveloperAction developerAction) {
      this.setParam("developer_action", developerAction);
      return this;
    }
    public APIRequestCreateNotificationMessagesDevSupport setDeveloperAction (String developerAction) {
      this.setParam("developer_action", developerAction);
      return this;
    }

    public APIRequestCreateNotificationMessagesDevSupport setRecipient (Object recipient) {
      this.setParam("recipient", recipient);
      return this;
    }
    public APIRequestCreateNotificationMessagesDevSupport setRecipient (String recipient) {
      this.setParam("recipient", recipient);
      return this;
    }

    public APIRequestCreateNotificationMessagesDevSupport requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateNotificationMessagesDevSupport requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateNotificationMessagesDevSupport requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateNotificationMessagesDevSupport requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateNotificationMessagesDevSupport requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateNotificationMessagesDevSupport requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetPageBackedInstagramAccounts extends APIRequest<IGUser> {

    APINodeList<IGUser> lastResponse = null;
    @Override
    public APINodeList<IGUser> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "biography",
      "business_discovery",
      "followers_count",
      "follows_count",
      "has_profile_pic",
      "id",
      "ig_id",
      "is_published",
      "legacy_instagram_user_id",
      "media_count",
      "mentioned_comment",
      "mentioned_media",
      "name",
      "owner_business",
      "profile_picture_url",
      "shopping_product_tag_eligibility",
      "shopping_review_status",
      "username",
      "website",
    };

    @Override
    public APINodeList<IGUser> parseResponse(String response, String header) throws APIException {
      return IGUser.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<IGUser> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<IGUser> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<IGUser>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<IGUser>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<IGUser>>() {
           public APINodeList<IGUser> apply(ResponseWrapper result) {
             try {
               return APIRequestGetPageBackedInstagramAccounts.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetPageBackedInstagramAccounts(String nodeId, APIContext context) {
      super(context, nodeId, "/page_backed_instagram_accounts", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetPageBackedInstagramAccounts setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetPageBackedInstagramAccounts setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetPageBackedInstagramAccounts requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetPageBackedInstagramAccounts requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetPageBackedInstagramAccounts requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetPageBackedInstagramAccounts requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetPageBackedInstagramAccounts requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetPageBackedInstagramAccounts requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetPageBackedInstagramAccounts requestBiographyField () {
      return this.requestBiographyField(true);
    }
    public APIRequestGetPageBackedInstagramAccounts requestBiographyField (boolean value) {
      this.requestField("biography", value);
      return this;
    }
    public APIRequestGetPageBackedInstagramAccounts requestBusinessDiscoveryField () {
      return this.requestBusinessDiscoveryField(true);
    }
    public APIRequestGetPageBackedInstagramAccounts requestBusinessDiscoveryField (boolean value) {
      this.requestField("business_discovery", value);
      return this;
    }
    public APIRequestGetPageBackedInstagramAccounts requestFollowersCountField () {
      return this.requestFollowersCountField(true);
    }
    public APIRequestGetPageBackedInstagramAccounts requestFollowersCountField (boolean value) {
      this.requestField("followers_count", value);
      return this;
    }
    public APIRequestGetPageBackedInstagramAccounts requestFollowsCountField () {
      return this.requestFollowsCountField(true);
    }
    public APIRequestGetPageBackedInstagramAccounts requestFollowsCountField (boolean value) {
      this.requestField("follows_count", value);
      return this;
    }
    public APIRequestGetPageBackedInstagramAccounts requestHasProfilePicField () {
      return this.requestHasProfilePicField(true);
    }
    public APIRequestGetPageBackedInstagramAccounts requestHasProfilePicField (boolean value) {
      this.requestField("has_profile_pic", value);
      return this;
    }
    public APIRequestGetPageBackedInstagramAccounts requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetPageBackedInstagramAccounts requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetPageBackedInstagramAccounts requestIgIdField () {
      return this.requestIgIdField(true);
    }
    public APIRequestGetPageBackedInstagramAccounts requestIgIdField (boolean value) {
      this.requestField("ig_id", value);
      return this;
    }
    public APIRequestGetPageBackedInstagramAccounts requestIsPublishedField () {
      return this.requestIsPublishedField(true);
    }
    public APIRequestGetPageBackedInstagramAccounts requestIsPublishedField (boolean value) {
      this.requestField("is_published", value);
      return this;
    }
    public APIRequestGetPageBackedInstagramAccounts requestLegacyInstagramUserIdField () {
      return this.requestLegacyInstagramUserIdField(true);
    }
    public APIRequestGetPageBackedInstagramAccounts requestLegacyInstagramUserIdField (boolean value) {
      this.requestField("legacy_instagram_user_id", value);
      return this;
    }
    public APIRequestGetPageBackedInstagramAccounts requestMediaCountField () {
      return this.requestMediaCountField(true);
    }
    public APIRequestGetPageBackedInstagramAccounts requestMediaCountField (boolean value) {
      this.requestField("media_count", value);
      return this;
    }
    public APIRequestGetPageBackedInstagramAccounts requestMentionedCommentField () {
      return this.requestMentionedCommentField(true);
    }
    public APIRequestGetPageBackedInstagramAccounts requestMentionedCommentField (boolean value) {
      this.requestField("mentioned_comment", value);
      return this;
    }
    public APIRequestGetPageBackedInstagramAccounts requestMentionedMediaField () {
      return this.requestMentionedMediaField(true);
    }
    public APIRequestGetPageBackedInstagramAccounts requestMentionedMediaField (boolean value) {
      this.requestField("mentioned_media", value);
      return this;
    }
    public APIRequestGetPageBackedInstagramAccounts requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetPageBackedInstagramAccounts requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetPageBackedInstagramAccounts requestOwnerBusinessField () {
      return this.requestOwnerBusinessField(true);
    }
    public APIRequestGetPageBackedInstagramAccounts requestOwnerBusinessField (boolean value) {
      this.requestField("owner_business", value);
      return this;
    }
    public APIRequestGetPageBackedInstagramAccounts requestProfilePictureUrlField () {
      return this.requestProfilePictureUrlField(true);
    }
    public APIRequestGetPageBackedInstagramAccounts requestProfilePictureUrlField (boolean value) {
      this.requestField("profile_picture_url", value);
      return this;
    }
    public APIRequestGetPageBackedInstagramAccounts requestShoppingProductTagEligibilityField () {
      return this.requestShoppingProductTagEligibilityField(true);
    }
    public APIRequestGetPageBackedInstagramAccounts requestShoppingProductTagEligibilityField (boolean value) {
      this.requestField("shopping_product_tag_eligibility", value);
      return this;
    }
    public APIRequestGetPageBackedInstagramAccounts requestShoppingReviewStatusField () {
      return this.requestShoppingReviewStatusField(true);
    }
    public APIRequestGetPageBackedInstagramAccounts requestShoppingReviewStatusField (boolean value) {
      this.requestField("shopping_review_status", value);
      return this;
    }
    public APIRequestGetPageBackedInstagramAccounts requestUsernameField () {
      return this.requestUsernameField(true);
    }
    public APIRequestGetPageBackedInstagramAccounts requestUsernameField (boolean value) {
      this.requestField("username", value);
      return this;
    }
    public APIRequestGetPageBackedInstagramAccounts requestWebsiteField () {
      return this.requestWebsiteField(true);
    }
    public APIRequestGetPageBackedInstagramAccounts requestWebsiteField (boolean value) {
      this.requestField("website", value);
      return this;
    }
  }

  public static class APIRequestCreatePageBackedInstagramAccount extends APIRequest<IGUser> {

    IGUser lastResponse = null;
    @Override
    public IGUser getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
    };

    @Override
    public IGUser parseResponse(String response, String header) throws APIException {
      return IGUser.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public IGUser execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public IGUser execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<IGUser> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<IGUser> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, IGUser>() {
           public IGUser apply(ResponseWrapper result) {
             try {
               return APIRequestCreatePageBackedInstagramAccount.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreatePageBackedInstagramAccount(String nodeId, APIContext context) {
      super(context, nodeId, "/page_backed_instagram_accounts", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreatePageBackedInstagramAccount setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreatePageBackedInstagramAccount setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreatePageBackedInstagramAccount requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreatePageBackedInstagramAccount requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreatePageBackedInstagramAccount requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreatePageBackedInstagramAccount requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreatePageBackedInstagramAccount requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreatePageBackedInstagramAccount requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestCreatePageWhatsAppNumberVerification extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "verification_code",
      "whatsapp_number",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response, String header) throws APIException {
      return Page.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, Page>() {
           public Page apply(ResponseWrapper result) {
             try {
               return APIRequestCreatePageWhatsAppNumberVerification.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreatePageWhatsAppNumberVerification(String nodeId, APIContext context) {
      super(context, nodeId, "/page_whatsapp_number_verification", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreatePageWhatsAppNumberVerification setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreatePageWhatsAppNumberVerification setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreatePageWhatsAppNumberVerification setVerificationCode (String verificationCode) {
      this.setParam("verification_code", verificationCode);
      return this;
    }

    public APIRequestCreatePageWhatsAppNumberVerification setWhatsappNumber (String whatsappNumber) {
      this.setParam("whatsapp_number", whatsappNumber);
      return this;
    }

    public APIRequestCreatePageWhatsAppNumberVerification requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreatePageWhatsAppNumberVerification requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreatePageWhatsAppNumberVerification requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreatePageWhatsAppNumberVerification requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreatePageWhatsAppNumberVerification requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreatePageWhatsAppNumberVerification requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestCreatePassThreadControl extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "metadata",
      "recipient",
      "target_app_id",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response, String header) throws APIException {
      return Page.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, Page>() {
           public Page apply(ResponseWrapper result) {
             try {
               return APIRequestCreatePassThreadControl.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreatePassThreadControl(String nodeId, APIContext context) {
      super(context, nodeId, "/pass_thread_control", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreatePassThreadControl setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreatePassThreadControl setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreatePassThreadControl setMetadata (String metadata) {
      this.setParam("metadata", metadata);
      return this;
    }

    public APIRequestCreatePassThreadControl setRecipient (Object recipient) {
      this.setParam("recipient", recipient);
      return this;
    }
    public APIRequestCreatePassThreadControl setRecipient (String recipient) {
      this.setParam("recipient", recipient);
      return this;
    }

    public APIRequestCreatePassThreadControl setTargetAppId (String targetAppId) {
      this.setParam("target_app_id", targetAppId);
      return this;
    }

    public APIRequestCreatePassThreadControl requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreatePassThreadControl requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreatePassThreadControl requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreatePassThreadControl requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreatePassThreadControl requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreatePassThreadControl requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetPersonas extends APIRequest<Persona> {

    APINodeList<Persona> lastResponse = null;
    @Override
    public APINodeList<Persona> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "id",
      "name",
      "profile_picture_url",
    };

    @Override
    public APINodeList<Persona> parseResponse(String response, String header) throws APIException {
      return Persona.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<Persona> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Persona> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Persona>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Persona>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<Persona>>() {
           public APINodeList<Persona> apply(ResponseWrapper result) {
             try {
               return APIRequestGetPersonas.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetPersonas(String nodeId, APIContext context) {
      super(context, nodeId, "/personas", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetPersonas setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetPersonas setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetPersonas requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetPersonas requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetPersonas requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetPersonas requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetPersonas requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetPersonas requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetPersonas requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetPersonas requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetPersonas requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetPersonas requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetPersonas requestProfilePictureUrlField () {
      return this.requestProfilePictureUrlField(true);
    }
    public APIRequestGetPersonas requestProfilePictureUrlField (boolean value) {
      this.requestField("profile_picture_url", value);
      return this;
    }
  }

  public static class APIRequestCreatePersona extends APIRequest<Persona> {

    Persona lastResponse = null;
    @Override
    public Persona getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "name",
      "profile_picture_url",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Persona parseResponse(String response, String header) throws APIException {
      return Persona.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public Persona execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Persona execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<Persona> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Persona> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, Persona>() {
           public Persona apply(ResponseWrapper result) {
             try {
               return APIRequestCreatePersona.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreatePersona(String nodeId, APIContext context) {
      super(context, nodeId, "/personas", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreatePersona setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreatePersona setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreatePersona setName (String name) {
      this.setParam("name", name);
      return this;
    }

    public APIRequestCreatePersona setProfilePictureUrl (String profilePictureUrl) {
      this.setParam("profile_picture_url", profilePictureUrl);
      return this;
    }

    public APIRequestCreatePersona requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreatePersona requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreatePersona requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreatePersona requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreatePersona requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreatePersona requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestCreatePhotoStory extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "photo_id",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response, String header) throws APIException {
      return Page.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, Page>() {
           public Page apply(ResponseWrapper result) {
             try {
               return APIRequestCreatePhotoStory.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreatePhotoStory(String nodeId, APIContext context) {
      super(context, nodeId, "/photo_stories", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreatePhotoStory setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreatePhotoStory setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreatePhotoStory setPhotoId (String photoId) {
      this.setParam("photo_id", photoId);
      return this;
    }

    public APIRequestCreatePhotoStory requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreatePhotoStory requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreatePhotoStory requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreatePhotoStory requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreatePhotoStory requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreatePhotoStory requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetPhotos extends APIRequest<Photo> {

    APINodeList<Photo> lastResponse = null;
    @Override
    public APINodeList<Photo> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "biz_tag_id",
      "business_id",
      "type",
    };

    public static final String[] FIELDS = {
      "album",
      "alt_text",
      "alt_text_custom",
      "backdated_time",
      "backdated_time_granularity",
      "can_backdate",
      "can_delete",
      "can_tag",
      "created_time",
      "event",
      "from",
      "height",
      "icon",
      "id",
      "images",
      "link",
      "name",
      "name_tags",
      "page_story_id",
      "picture",
      "place",
      "position",
      "source",
      "target",
      "updated_time",
      "webp_images",
      "width",
    };

    @Override
    public APINodeList<Photo> parseResponse(String response, String header) throws APIException {
      return Photo.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<Photo> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Photo> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Photo>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Photo>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<Photo>>() {
           public APINodeList<Photo> apply(ResponseWrapper result) {
             try {
               return APIRequestGetPhotos.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetPhotos(String nodeId, APIContext context) {
      super(context, nodeId, "/photos", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetPhotos setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetPhotos setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetPhotos setBizTagId (Long bizTagId) {
      this.setParam("biz_tag_id", bizTagId);
      return this;
    }
    public APIRequestGetPhotos setBizTagId (String bizTagId) {
      this.setParam("biz_tag_id", bizTagId);
      return this;
    }

    public APIRequestGetPhotos setBusinessId (String businessId) {
      this.setParam("business_id", businessId);
      return this;
    }

    public APIRequestGetPhotos setType (Photo.EnumType type) {
      this.setParam("type", type);
      return this;
    }
    public APIRequestGetPhotos setType (String type) {
      this.setParam("type", type);
      return this;
    }

    public APIRequestGetPhotos requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetPhotos requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetPhotos requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetPhotos requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetPhotos requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetPhotos requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetPhotos requestAlbumField () {
      return this.requestAlbumField(true);
    }
    public APIRequestGetPhotos requestAlbumField (boolean value) {
      this.requestField("album", value);
      return this;
    }
    public APIRequestGetPhotos requestAltTextField () {
      return this.requestAltTextField(true);
    }
    public APIRequestGetPhotos requestAltTextField (boolean value) {
      this.requestField("alt_text", value);
      return this;
    }
    public APIRequestGetPhotos requestAltTextCustomField () {
      return this.requestAltTextCustomField(true);
    }
    public APIRequestGetPhotos requestAltTextCustomField (boolean value) {
      this.requestField("alt_text_custom", value);
      return this;
    }
    public APIRequestGetPhotos requestBackdatedTimeField () {
      return this.requestBackdatedTimeField(true);
    }
    public APIRequestGetPhotos requestBackdatedTimeField (boolean value) {
      this.requestField("backdated_time", value);
      return this;
    }
    public APIRequestGetPhotos requestBackdatedTimeGranularityField () {
      return this.requestBackdatedTimeGranularityField(true);
    }
    public APIRequestGetPhotos requestBackdatedTimeGranularityField (boolean value) {
      this.requestField("backdated_time_granularity", value);
      return this;
    }
    public APIRequestGetPhotos requestCanBackdateField () {
      return this.requestCanBackdateField(true);
    }
    public APIRequestGetPhotos requestCanBackdateField (boolean value) {
      this.requestField("can_backdate", value);
      return this;
    }
    public APIRequestGetPhotos requestCanDeleteField () {
      return this.requestCanDeleteField(true);
    }
    public APIRequestGetPhotos requestCanDeleteField (boolean value) {
      this.requestField("can_delete", value);
      return this;
    }
    public APIRequestGetPhotos requestCanTagField () {
      return this.requestCanTagField(true);
    }
    public APIRequestGetPhotos requestCanTagField (boolean value) {
      this.requestField("can_tag", value);
      return this;
    }
    public APIRequestGetPhotos requestCreatedTimeField () {
      return this.requestCreatedTimeField(true);
    }
    public APIRequestGetPhotos requestCreatedTimeField (boolean value) {
      this.requestField("created_time", value);
      return this;
    }
    public APIRequestGetPhotos requestEventField () {
      return this.requestEventField(true);
    }
    public APIRequestGetPhotos requestEventField (boolean value) {
      this.requestField("event", value);
      return this;
    }
    public APIRequestGetPhotos requestFromField () {
      return this.requestFromField(true);
    }
    public APIRequestGetPhotos requestFromField (boolean value) {
      this.requestField("from", value);
      return this;
    }
    public APIRequestGetPhotos requestHeightField () {
      return this.requestHeightField(true);
    }
    public APIRequestGetPhotos requestHeightField (boolean value) {
      this.requestField("height", value);
      return this;
    }
    public APIRequestGetPhotos requestIconField () {
      return this.requestIconField(true);
    }
    public APIRequestGetPhotos requestIconField (boolean value) {
      this.requestField("icon", value);
      return this;
    }
    public APIRequestGetPhotos requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetPhotos requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetPhotos requestImagesField () {
      return this.requestImagesField(true);
    }
    public APIRequestGetPhotos requestImagesField (boolean value) {
      this.requestField("images", value);
      return this;
    }
    public APIRequestGetPhotos requestLinkField () {
      return this.requestLinkField(true);
    }
    public APIRequestGetPhotos requestLinkField (boolean value) {
      this.requestField("link", value);
      return this;
    }
    public APIRequestGetPhotos requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetPhotos requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetPhotos requestNameTagsField () {
      return this.requestNameTagsField(true);
    }
    public APIRequestGetPhotos requestNameTagsField (boolean value) {
      this.requestField("name_tags", value);
      return this;
    }
    public APIRequestGetPhotos requestPageStoryIdField () {
      return this.requestPageStoryIdField(true);
    }
    public APIRequestGetPhotos requestPageStoryIdField (boolean value) {
      this.requestField("page_story_id", value);
      return this;
    }
    public APIRequestGetPhotos requestPictureField () {
      return this.requestPictureField(true);
    }
    public APIRequestGetPhotos requestPictureField (boolean value) {
      this.requestField("picture", value);
      return this;
    }
    public APIRequestGetPhotos requestPlaceField () {
      return this.requestPlaceField(true);
    }
    public APIRequestGetPhotos requestPlaceField (boolean value) {
      this.requestField("place", value);
      return this;
    }
    public APIRequestGetPhotos requestPositionField () {
      return this.requestPositionField(true);
    }
    public APIRequestGetPhotos requestPositionField (boolean value) {
      this.requestField("position", value);
      return this;
    }
    public APIRequestGetPhotos requestSourceField () {
      return this.requestSourceField(true);
    }
    public APIRequestGetPhotos requestSourceField (boolean value) {
      this.requestField("source", value);
      return this;
    }
    public APIRequestGetPhotos requestTargetField () {
      return this.requestTargetField(true);
    }
    public APIRequestGetPhotos requestTargetField (boolean value) {
      this.requestField("target", value);
      return this;
    }
    public APIRequestGetPhotos requestUpdatedTimeField () {
      return this.requestUpdatedTimeField(true);
    }
    public APIRequestGetPhotos requestUpdatedTimeField (boolean value) {
      this.requestField("updated_time", value);
      return this;
    }
    public APIRequestGetPhotos requestWebpImagesField () {
      return this.requestWebpImagesField(true);
    }
    public APIRequestGetPhotos requestWebpImagesField (boolean value) {
      this.requestField("webp_images", value);
      return this;
    }
    public APIRequestGetPhotos requestWidthField () {
      return this.requestWidthField(true);
    }
    public APIRequestGetPhotos requestWidthField (boolean value) {
      this.requestField("width", value);
      return this;
    }
  }

  public static class APIRequestCreatePhoto extends APIRequest<Photo> {

    Photo lastResponse = null;
    @Override
    public Photo getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "aid",
      "allow_spherical_photo",
      "alt_text_custom",
      "android_key_hash",
      "application_id",
      "attempt",
      "audience_exp",
      "backdated_time",
      "backdated_time_granularity",
      "caption",
      "composer_session_id",
      "direct_share_status",
      "feed_targeting",
      "filter_type",
      "full_res_is_coming_later",
      "initial_view_heading_override_degrees",
      "initial_view_pitch_override_degrees",
      "initial_view_vertical_fov_override_degrees",
      "ios_bundle_id",
      "is_explicit_location",
      "is_explicit_place",
      "location_source_id",
      "manual_privacy",
      "message",
      "name",
      "nectar_module",
      "no_story",
      "offline_id",
      "og_action_type_id",
      "og_icon_id",
      "og_object_id",
      "og_phrase",
      "og_set_profile_badge",
      "og_suggestion_mechanism",
      "parent_media_id",
      "place",
      "privacy",
      "profile_id",
      "provenance_info",
      "proxied_app_id",
      "published",
      "qn",
      "scheduled_publish_time",
      "spherical_metadata",
      "sponsor_id",
      "sponsor_relationship",
      "tags",
      "target_id",
      "targeting",
      "temporary",
      "time_since_original_post",
      "uid",
      "unpublished_content_type",
      "url",
      "user_selected_tags",
      "vault_image_id",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Photo parseResponse(String response, String header) throws APIException {
      return Photo.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public Photo execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Photo execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<Photo> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Photo> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, Photo>() {
           public Photo apply(ResponseWrapper result) {
             try {
               return APIRequestCreatePhoto.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreatePhoto(String nodeId, APIContext context) {
      super(context, nodeId, "/photos", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreatePhoto setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreatePhoto setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreatePhoto setAid (String aid) {
      this.setParam("aid", aid);
      return this;
    }

    public APIRequestCreatePhoto setAllowSphericalPhoto (Boolean allowSphericalPhoto) {
      this.setParam("allow_spherical_photo", allowSphericalPhoto);
      return this;
    }
    public APIRequestCreatePhoto setAllowSphericalPhoto (String allowSphericalPhoto) {
      this.setParam("allow_spherical_photo", allowSphericalPhoto);
      return this;
    }

    public APIRequestCreatePhoto setAltTextCustom (String altTextCustom) {
      this.setParam("alt_text_custom", altTextCustom);
      return this;
    }

    public APIRequestCreatePhoto setAndroidKeyHash (String androidKeyHash) {
      this.setParam("android_key_hash", androidKeyHash);
      return this;
    }

    public APIRequestCreatePhoto setApplicationId (String applicationId) {
      this.setParam("application_id", applicationId);
      return this;
    }

    public APIRequestCreatePhoto setAttempt (Long attempt) {
      this.setParam("attempt", attempt);
      return this;
    }
    public APIRequestCreatePhoto setAttempt (String attempt) {
      this.setParam("attempt", attempt);
      return this;
    }

    public APIRequestCreatePhoto setAudienceExp (Boolean audienceExp) {
      this.setParam("audience_exp", audienceExp);
      return this;
    }
    public APIRequestCreatePhoto setAudienceExp (String audienceExp) {
      this.setParam("audience_exp", audienceExp);
      return this;
    }

    public APIRequestCreatePhoto setBackdatedTime (String backdatedTime) {
      this.setParam("backdated_time", backdatedTime);
      return this;
    }

    public APIRequestCreatePhoto setBackdatedTimeGranularity (Photo.EnumBackdatedTimeGranularity backdatedTimeGranularity) {
      this.setParam("backdated_time_granularity", backdatedTimeGranularity);
      return this;
    }
    public APIRequestCreatePhoto setBackdatedTimeGranularity (String backdatedTimeGranularity) {
      this.setParam("backdated_time_granularity", backdatedTimeGranularity);
      return this;
    }

    public APIRequestCreatePhoto setCaption (String caption) {
      this.setParam("caption", caption);
      return this;
    }

    public APIRequestCreatePhoto setComposerSessionId (String composerSessionId) {
      this.setParam("composer_session_id", composerSessionId);
      return this;
    }

    public APIRequestCreatePhoto setDirectShareStatus (Long directShareStatus) {
      this.setParam("direct_share_status", directShareStatus);
      return this;
    }
    public APIRequestCreatePhoto setDirectShareStatus (String directShareStatus) {
      this.setParam("direct_share_status", directShareStatus);
      return this;
    }

    public APIRequestCreatePhoto setFeedTargeting (Object feedTargeting) {
      this.setParam("feed_targeting", feedTargeting);
      return this;
    }
    public APIRequestCreatePhoto setFeedTargeting (String feedTargeting) {
      this.setParam("feed_targeting", feedTargeting);
      return this;
    }

    public APIRequestCreatePhoto setFilterType (Long filterType) {
      this.setParam("filter_type", filterType);
      return this;
    }
    public APIRequestCreatePhoto setFilterType (String filterType) {
      this.setParam("filter_type", filterType);
      return this;
    }

    public APIRequestCreatePhoto setFullResIsComingLater (Boolean fullResIsComingLater) {
      this.setParam("full_res_is_coming_later", fullResIsComingLater);
      return this;
    }
    public APIRequestCreatePhoto setFullResIsComingLater (String fullResIsComingLater) {
      this.setParam("full_res_is_coming_later", fullResIsComingLater);
      return this;
    }

    public APIRequestCreatePhoto setInitialViewHeadingOverrideDegrees (Long initialViewHeadingOverrideDegrees) {
      this.setParam("initial_view_heading_override_degrees", initialViewHeadingOverrideDegrees);
      return this;
    }
    public APIRequestCreatePhoto setInitialViewHeadingOverrideDegrees (String initialViewHeadingOverrideDegrees) {
      this.setParam("initial_view_heading_override_degrees", initialViewHeadingOverrideDegrees);
      return this;
    }

    public APIRequestCreatePhoto setInitialViewPitchOverrideDegrees (Long initialViewPitchOverrideDegrees) {
      this.setParam("initial_view_pitch_override_degrees", initialViewPitchOverrideDegrees);
      return this;
    }
    public APIRequestCreatePhoto setInitialViewPitchOverrideDegrees (String initialViewPitchOverrideDegrees) {
      this.setParam("initial_view_pitch_override_degrees", initialViewPitchOverrideDegrees);
      return this;
    }

    public APIRequestCreatePhoto setInitialViewVerticalFovOverrideDegrees (Long initialViewVerticalFovOverrideDegrees) {
      this.setParam("initial_view_vertical_fov_override_degrees", initialViewVerticalFovOverrideDegrees);
      return this;
    }
    public APIRequestCreatePhoto setInitialViewVerticalFovOverrideDegrees (String initialViewVerticalFovOverrideDegrees) {
      this.setParam("initial_view_vertical_fov_override_degrees", initialViewVerticalFovOverrideDegrees);
      return this;
    }

    public APIRequestCreatePhoto setIosBundleId (String iosBundleId) {
      this.setParam("ios_bundle_id", iosBundleId);
      return this;
    }

    public APIRequestCreatePhoto setIsExplicitLocation (Boolean isExplicitLocation) {
      this.setParam("is_explicit_location", isExplicitLocation);
      return this;
    }
    public APIRequestCreatePhoto setIsExplicitLocation (String isExplicitLocation) {
      this.setParam("is_explicit_location", isExplicitLocation);
      return this;
    }

    public APIRequestCreatePhoto setIsExplicitPlace (Boolean isExplicitPlace) {
      this.setParam("is_explicit_place", isExplicitPlace);
      return this;
    }
    public APIRequestCreatePhoto setIsExplicitPlace (String isExplicitPlace) {
      this.setParam("is_explicit_place", isExplicitPlace);
      return this;
    }

    public APIRequestCreatePhoto setLocationSourceId (String locationSourceId) {
      this.setParam("location_source_id", locationSourceId);
      return this;
    }

    public APIRequestCreatePhoto setManualPrivacy (Boolean manualPrivacy) {
      this.setParam("manual_privacy", manualPrivacy);
      return this;
    }
    public APIRequestCreatePhoto setManualPrivacy (String manualPrivacy) {
      this.setParam("manual_privacy", manualPrivacy);
      return this;
    }

    public APIRequestCreatePhoto setMessage (String message) {
      this.setParam("message", message);
      return this;
    }

    public APIRequestCreatePhoto setName (String name) {
      this.setParam("name", name);
      return this;
    }

    public APIRequestCreatePhoto setNectarModule (String nectarModule) {
      this.setParam("nectar_module", nectarModule);
      return this;
    }

    public APIRequestCreatePhoto setNoStory (Boolean noStory) {
      this.setParam("no_story", noStory);
      return this;
    }
    public APIRequestCreatePhoto setNoStory (String noStory) {
      this.setParam("no_story", noStory);
      return this;
    }

    public APIRequestCreatePhoto setOfflineId (Long offlineId) {
      this.setParam("offline_id", offlineId);
      return this;
    }
    public APIRequestCreatePhoto setOfflineId (String offlineId) {
      this.setParam("offline_id", offlineId);
      return this;
    }

    public APIRequestCreatePhoto setOgActionTypeId (String ogActionTypeId) {
      this.setParam("og_action_type_id", ogActionTypeId);
      return this;
    }

    public APIRequestCreatePhoto setOgIconId (String ogIconId) {
      this.setParam("og_icon_id", ogIconId);
      return this;
    }

    public APIRequestCreatePhoto setOgObjectId (String ogObjectId) {
      this.setParam("og_object_id", ogObjectId);
      return this;
    }

    public APIRequestCreatePhoto setOgPhrase (String ogPhrase) {
      this.setParam("og_phrase", ogPhrase);
      return this;
    }

    public APIRequestCreatePhoto setOgSetProfileBadge (Boolean ogSetProfileBadge) {
      this.setParam("og_set_profile_badge", ogSetProfileBadge);
      return this;
    }
    public APIRequestCreatePhoto setOgSetProfileBadge (String ogSetProfileBadge) {
      this.setParam("og_set_profile_badge", ogSetProfileBadge);
      return this;
    }

    public APIRequestCreatePhoto setOgSuggestionMechanism (String ogSuggestionMechanism) {
      this.setParam("og_suggestion_mechanism", ogSuggestionMechanism);
      return this;
    }

    public APIRequestCreatePhoto setParentMediaId (Long parentMediaId) {
      this.setParam("parent_media_id", parentMediaId);
      return this;
    }
    public APIRequestCreatePhoto setParentMediaId (String parentMediaId) {
      this.setParam("parent_media_id", parentMediaId);
      return this;
    }

    public APIRequestCreatePhoto setPlace (Object place) {
      this.setParam("place", place);
      return this;
    }
    public APIRequestCreatePhoto setPlace (String place) {
      this.setParam("place", place);
      return this;
    }

    public APIRequestCreatePhoto setPrivacy (String privacy) {
      this.setParam("privacy", privacy);
      return this;
    }

    public APIRequestCreatePhoto setProfileId (Long profileId) {
      this.setParam("profile_id", profileId);
      return this;
    }
    public APIRequestCreatePhoto setProfileId (String profileId) {
      this.setParam("profile_id", profileId);
      return this;
    }

    public APIRequestCreatePhoto setProvenanceInfo (Map<String, String> provenanceInfo) {
      this.setParam("provenance_info", provenanceInfo);
      return this;
    }
    public APIRequestCreatePhoto setProvenanceInfo (String provenanceInfo) {
      this.setParam("provenance_info", provenanceInfo);
      return this;
    }

    public APIRequestCreatePhoto setProxiedAppId (String proxiedAppId) {
      this.setParam("proxied_app_id", proxiedAppId);
      return this;
    }

    public APIRequestCreatePhoto setPublished (Boolean published) {
      this.setParam("published", published);
      return this;
    }
    public APIRequestCreatePhoto setPublished (String published) {
      this.setParam("published", published);
      return this;
    }

    public APIRequestCreatePhoto setQn (String qn) {
      this.setParam("qn", qn);
      return this;
    }

    public APIRequestCreatePhoto setScheduledPublishTime (Long scheduledPublishTime) {
      this.setParam("scheduled_publish_time", scheduledPublishTime);
      return this;
    }
    public APIRequestCreatePhoto setScheduledPublishTime (String scheduledPublishTime) {
      this.setParam("scheduled_publish_time", scheduledPublishTime);
      return this;
    }

    public APIRequestCreatePhoto setSphericalMetadata (Map<String, String> sphericalMetadata) {
      this.setParam("spherical_metadata", sphericalMetadata);
      return this;
    }
    public APIRequestCreatePhoto setSphericalMetadata (String sphericalMetadata) {
      this.setParam("spherical_metadata", sphericalMetadata);
      return this;
    }

    public APIRequestCreatePhoto setSponsorId (String sponsorId) {
      this.setParam("sponsor_id", sponsorId);
      return this;
    }

    public APIRequestCreatePhoto setSponsorRelationship (Long sponsorRelationship) {
      this.setParam("sponsor_relationship", sponsorRelationship);
      return this;
    }
    public APIRequestCreatePhoto setSponsorRelationship (String sponsorRelationship) {
      this.setParam("sponsor_relationship", sponsorRelationship);
      return this;
    }

    public APIRequestCreatePhoto setTags (List<Object> tags) {
      this.setParam("tags", tags);
      return this;
    }
    public APIRequestCreatePhoto setTags (String tags) {
      this.setParam("tags", tags);
      return this;
    }

    public APIRequestCreatePhoto setTargetId (Long targetId) {
      this.setParam("target_id", targetId);
      return this;
    }
    public APIRequestCreatePhoto setTargetId (String targetId) {
      this.setParam("target_id", targetId);
      return this;
    }

    public APIRequestCreatePhoto setTargeting (Object targeting) {
      this.setParam("targeting", targeting);
      return this;
    }
    public APIRequestCreatePhoto setTargeting (String targeting) {
      this.setParam("targeting", targeting);
      return this;
    }

    public APIRequestCreatePhoto setTemporary (Boolean temporary) {
      this.setParam("temporary", temporary);
      return this;
    }
    public APIRequestCreatePhoto setTemporary (String temporary) {
      this.setParam("temporary", temporary);
      return this;
    }

    public APIRequestCreatePhoto setTimeSinceOriginalPost (Long timeSinceOriginalPost) {
      this.setParam("time_since_original_post", timeSinceOriginalPost);
      return this;
    }
    public APIRequestCreatePhoto setTimeSinceOriginalPost (String timeSinceOriginalPost) {
      this.setParam("time_since_original_post", timeSinceOriginalPost);
      return this;
    }

    public APIRequestCreatePhoto setUid (Long uid) {
      this.setParam("uid", uid);
      return this;
    }
    public APIRequestCreatePhoto setUid (String uid) {
      this.setParam("uid", uid);
      return this;
    }

    public APIRequestCreatePhoto setUnpublishedContentType (Photo.EnumUnpublishedContentType unpublishedContentType) {
      this.setParam("unpublished_content_type", unpublishedContentType);
      return this;
    }
    public APIRequestCreatePhoto setUnpublishedContentType (String unpublishedContentType) {
      this.setParam("unpublished_content_type", unpublishedContentType);
      return this;
    }

    public APIRequestCreatePhoto setUrl (String url) {
      this.setParam("url", url);
      return this;
    }

    public APIRequestCreatePhoto setUserSelectedTags (Boolean userSelectedTags) {
      this.setParam("user_selected_tags", userSelectedTags);
      return this;
    }
    public APIRequestCreatePhoto setUserSelectedTags (String userSelectedTags) {
      this.setParam("user_selected_tags", userSelectedTags);
      return this;
    }

    public APIRequestCreatePhoto setVaultImageId (String vaultImageId) {
      this.setParam("vault_image_id", vaultImageId);
      return this;
    }

    public APIRequestCreatePhoto requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreatePhoto requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreatePhoto requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreatePhoto requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreatePhoto requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreatePhoto requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetPicture extends APIRequest<ProfilePictureSource> {

    APINodeList<ProfilePictureSource> lastResponse = null;
    @Override
    public APINodeList<ProfilePictureSource> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "height",
      "redirect",
      "type",
      "width",
    };

    public static final String[] FIELDS = {
      "bottom",
      "cache_key",
      "height",
      "is_silhouette",
      "left",
      "right",
      "top",
      "url",
      "width",
    };

    @Override
    public APINodeList<ProfilePictureSource> parseResponse(String response, String header) throws APIException {
      return ProfilePictureSource.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<ProfilePictureSource> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<ProfilePictureSource> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<ProfilePictureSource>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<ProfilePictureSource>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<ProfilePictureSource>>() {
           public APINodeList<ProfilePictureSource> apply(ResponseWrapper result) {
             try {
               return APIRequestGetPicture.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetPicture(String nodeId, APIContext context) {
      super(context, nodeId, "/picture", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetPicture setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetPicture setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetPicture setHeight (Long height) {
      this.setParam("height", height);
      return this;
    }
    public APIRequestGetPicture setHeight (String height) {
      this.setParam("height", height);
      return this;
    }

    public APIRequestGetPicture setRedirect (Boolean redirect) {
      this.setParam("redirect", redirect);
      return this;
    }
    public APIRequestGetPicture setRedirect (String redirect) {
      this.setParam("redirect", redirect);
      return this;
    }

    public APIRequestGetPicture setType (ProfilePictureSource.EnumType type) {
      this.setParam("type", type);
      return this;
    }
    public APIRequestGetPicture setType (String type) {
      this.setParam("type", type);
      return this;
    }

    public APIRequestGetPicture setWidth (Long width) {
      this.setParam("width", width);
      return this;
    }
    public APIRequestGetPicture setWidth (String width) {
      this.setParam("width", width);
      return this;
    }

    public APIRequestGetPicture requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetPicture requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetPicture requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetPicture requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetPicture requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetPicture requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetPicture requestBottomField () {
      return this.requestBottomField(true);
    }
    public APIRequestGetPicture requestBottomField (boolean value) {
      this.requestField("bottom", value);
      return this;
    }
    public APIRequestGetPicture requestCacheKeyField () {
      return this.requestCacheKeyField(true);
    }
    public APIRequestGetPicture requestCacheKeyField (boolean value) {
      this.requestField("cache_key", value);
      return this;
    }
    public APIRequestGetPicture requestHeightField () {
      return this.requestHeightField(true);
    }
    public APIRequestGetPicture requestHeightField (boolean value) {
      this.requestField("height", value);
      return this;
    }
    public APIRequestGetPicture requestIsSilhouetteField () {
      return this.requestIsSilhouetteField(true);
    }
    public APIRequestGetPicture requestIsSilhouetteField (boolean value) {
      this.requestField("is_silhouette", value);
      return this;
    }
    public APIRequestGetPicture requestLeftField () {
      return this.requestLeftField(true);
    }
    public APIRequestGetPicture requestLeftField (boolean value) {
      this.requestField("left", value);
      return this;
    }
    public APIRequestGetPicture requestRightField () {
      return this.requestRightField(true);
    }
    public APIRequestGetPicture requestRightField (boolean value) {
      this.requestField("right", value);
      return this;
    }
    public APIRequestGetPicture requestTopField () {
      return this.requestTopField(true);
    }
    public APIRequestGetPicture requestTopField (boolean value) {
      this.requestField("top", value);
      return this;
    }
    public APIRequestGetPicture requestUrlField () {
      return this.requestUrlField(true);
    }
    public APIRequestGetPicture requestUrlField (boolean value) {
      this.requestField("url", value);
      return this;
    }
    public APIRequestGetPicture requestWidthField () {
      return this.requestWidthField(true);
    }
    public APIRequestGetPicture requestWidthField (boolean value) {
      this.requestField("width", value);
      return this;
    }
  }

  public static class APIRequestCreatePicture extends APIRequest<ProfilePictureSource> {

    ProfilePictureSource lastResponse = null;
    @Override
    public ProfilePictureSource getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "android_key_hash",
      "burn_media_effect",
      "caption",
      "composer_session_id",
      "frame_entrypoint",
      "has_umg",
      "height",
      "ios_bundle_id",
      "media_effect_ids",
      "media_effect_source_object_id",
      "msqrd_mask_id",
      "photo",
      "picture",
      "profile_pic_method",
      "profile_pic_source",
      "proxied_app_id",
      "qn",
      "reuse",
      "scaled_crop_rect",
      "set_profile_photo_shield",
      "sticker_id",
      "sticker_source_object_id",
      "suppress_stories",
      "width",
      "x",
      "y",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public ProfilePictureSource parseResponse(String response, String header) throws APIException {
      return ProfilePictureSource.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public ProfilePictureSource execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public ProfilePictureSource execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<ProfilePictureSource> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<ProfilePictureSource> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, ProfilePictureSource>() {
           public ProfilePictureSource apply(ResponseWrapper result) {
             try {
               return APIRequestCreatePicture.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreatePicture(String nodeId, APIContext context) {
      super(context, nodeId, "/picture", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreatePicture setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreatePicture setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreatePicture setAndroidKeyHash (String androidKeyHash) {
      this.setParam("android_key_hash", androidKeyHash);
      return this;
    }

    public APIRequestCreatePicture setBurnMediaEffect (Boolean burnMediaEffect) {
      this.setParam("burn_media_effect", burnMediaEffect);
      return this;
    }
    public APIRequestCreatePicture setBurnMediaEffect (String burnMediaEffect) {
      this.setParam("burn_media_effect", burnMediaEffect);
      return this;
    }

    public APIRequestCreatePicture setCaption (String caption) {
      this.setParam("caption", caption);
      return this;
    }

    public APIRequestCreatePicture setComposerSessionId (String composerSessionId) {
      this.setParam("composer_session_id", composerSessionId);
      return this;
    }

    public APIRequestCreatePicture setFrameEntrypoint (String frameEntrypoint) {
      this.setParam("frame_entrypoint", frameEntrypoint);
      return this;
    }

    public APIRequestCreatePicture setHasUmg (Boolean hasUmg) {
      this.setParam("has_umg", hasUmg);
      return this;
    }
    public APIRequestCreatePicture setHasUmg (String hasUmg) {
      this.setParam("has_umg", hasUmg);
      return this;
    }

    public APIRequestCreatePicture setHeight (Long height) {
      this.setParam("height", height);
      return this;
    }
    public APIRequestCreatePicture setHeight (String height) {
      this.setParam("height", height);
      return this;
    }

    public APIRequestCreatePicture setIosBundleId (String iosBundleId) {
      this.setParam("ios_bundle_id", iosBundleId);
      return this;
    }

    public APIRequestCreatePicture setMediaEffectIds (List<Long> mediaEffectIds) {
      this.setParam("media_effect_ids", mediaEffectIds);
      return this;
    }
    public APIRequestCreatePicture setMediaEffectIds (String mediaEffectIds) {
      this.setParam("media_effect_ids", mediaEffectIds);
      return this;
    }

    public APIRequestCreatePicture setMediaEffectSourceObjectId (Long mediaEffectSourceObjectId) {
      this.setParam("media_effect_source_object_id", mediaEffectSourceObjectId);
      return this;
    }
    public APIRequestCreatePicture setMediaEffectSourceObjectId (String mediaEffectSourceObjectId) {
      this.setParam("media_effect_source_object_id", mediaEffectSourceObjectId);
      return this;
    }

    public APIRequestCreatePicture setMsqrdMaskId (String msqrdMaskId) {
      this.setParam("msqrd_mask_id", msqrdMaskId);
      return this;
    }

    public APIRequestCreatePicture setPhoto (String photo) {
      this.setParam("photo", photo);
      return this;
    }

    public APIRequestCreatePicture setPicture (String picture) {
      this.setParam("picture", picture);
      return this;
    }

    public APIRequestCreatePicture setProfilePicMethod (String profilePicMethod) {
      this.setParam("profile_pic_method", profilePicMethod);
      return this;
    }

    public APIRequestCreatePicture setProfilePicSource (String profilePicSource) {
      this.setParam("profile_pic_source", profilePicSource);
      return this;
    }

    public APIRequestCreatePicture setProxiedAppId (Long proxiedAppId) {
      this.setParam("proxied_app_id", proxiedAppId);
      return this;
    }
    public APIRequestCreatePicture setProxiedAppId (String proxiedAppId) {
      this.setParam("proxied_app_id", proxiedAppId);
      return this;
    }

    public APIRequestCreatePicture setQn (String qn) {
      this.setParam("qn", qn);
      return this;
    }

    public APIRequestCreatePicture setReuse (Boolean reuse) {
      this.setParam("reuse", reuse);
      return this;
    }
    public APIRequestCreatePicture setReuse (String reuse) {
      this.setParam("reuse", reuse);
      return this;
    }

    public APIRequestCreatePicture setScaledCropRect (Object scaledCropRect) {
      this.setParam("scaled_crop_rect", scaledCropRect);
      return this;
    }
    public APIRequestCreatePicture setScaledCropRect (String scaledCropRect) {
      this.setParam("scaled_crop_rect", scaledCropRect);
      return this;
    }

    public APIRequestCreatePicture setSetProfilePhotoShield (String setProfilePhotoShield) {
      this.setParam("set_profile_photo_shield", setProfilePhotoShield);
      return this;
    }

    public APIRequestCreatePicture setStickerId (Long stickerId) {
      this.setParam("sticker_id", stickerId);
      return this;
    }
    public APIRequestCreatePicture setStickerId (String stickerId) {
      this.setParam("sticker_id", stickerId);
      return this;
    }

    public APIRequestCreatePicture setStickerSourceObjectId (Long stickerSourceObjectId) {
      this.setParam("sticker_source_object_id", stickerSourceObjectId);
      return this;
    }
    public APIRequestCreatePicture setStickerSourceObjectId (String stickerSourceObjectId) {
      this.setParam("sticker_source_object_id", stickerSourceObjectId);
      return this;
    }

    public APIRequestCreatePicture setSuppressStories (Boolean suppressStories) {
      this.setParam("suppress_stories", suppressStories);
      return this;
    }
    public APIRequestCreatePicture setSuppressStories (String suppressStories) {
      this.setParam("suppress_stories", suppressStories);
      return this;
    }

    public APIRequestCreatePicture setWidth (Long width) {
      this.setParam("width", width);
      return this;
    }
    public APIRequestCreatePicture setWidth (String width) {
      this.setParam("width", width);
      return this;
    }

    public APIRequestCreatePicture setX (Long x) {
      this.setParam("x", x);
      return this;
    }
    public APIRequestCreatePicture setX (String x) {
      this.setParam("x", x);
      return this;
    }

    public APIRequestCreatePicture setY (Long y) {
      this.setParam("y", y);
      return this;
    }
    public APIRequestCreatePicture setY (String y) {
      this.setParam("y", y);
      return this;
    }

    public APIRequestCreatePicture requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreatePicture requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreatePicture requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreatePicture requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreatePicture requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreatePicture requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetPosts extends APIRequest<PagePost> {

    APINodeList<PagePost> lastResponse = null;
    @Override
    public APINodeList<PagePost> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "include_hidden",
      "limit",
      "q",
      "show_expired",
      "with",
    };

    public static final String[] FIELDS = {
      "actions",
      "admin_creator",
      "allowed_advertising_objectives",
      "application",
      "backdated_time",
      "call_to_action",
      "can_reply_privately",
      "child_attachments",
      "comments_mirroring_domain",
      "coordinates",
      "created_time",
      "event",
      "expanded_height",
      "expanded_width",
      "feed_targeting",
      "from",
      "full_picture",
      "height",
      "icon",
      "id",
      "instagram_eligibility",
      "is_app_share",
      "is_eligible_for_promotion",
      "is_expired",
      "is_hidden",
      "is_inline_created",
      "is_instagram_eligible",
      "is_popular",
      "is_published",
      "is_spherical",
      "message",
      "message_tags",
      "multi_share_end_card",
      "multi_share_optimized",
      "parent_id",
      "permalink_url",
      "picture",
      "place",
      "privacy",
      "promotable_id",
      "promotion_status",
      "properties",
      "scheduled_publish_time",
      "shares",
      "status_type",
      "story",
      "story_tags",
      "subscribed",
      "target",
      "targeting",
      "timeline_visibility",
      "updated_time",
      "via",
      "video_buying_eligibility",
      "width",
    };

    @Override
    public APINodeList<PagePost> parseResponse(String response, String header) throws APIException {
      return PagePost.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<PagePost> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<PagePost> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<PagePost>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<PagePost>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<PagePost>>() {
           public APINodeList<PagePost> apply(ResponseWrapper result) {
             try {
               return APIRequestGetPosts.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetPosts(String nodeId, APIContext context) {
      super(context, nodeId, "/posts", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetPosts setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetPosts setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetPosts setIncludeHidden (Boolean includeHidden) {
      this.setParam("include_hidden", includeHidden);
      return this;
    }
    public APIRequestGetPosts setIncludeHidden (String includeHidden) {
      this.setParam("include_hidden", includeHidden);
      return this;
    }

    public APIRequestGetPosts setLimit (Long limit) {
      this.setParam("limit", limit);
      return this;
    }
    public APIRequestGetPosts setLimit (String limit) {
      this.setParam("limit", limit);
      return this;
    }

    public APIRequestGetPosts setQ (String q) {
      this.setParam("q", q);
      return this;
    }

    public APIRequestGetPosts setShowExpired (Boolean showExpired) {
      this.setParam("show_expired", showExpired);
      return this;
    }
    public APIRequestGetPosts setShowExpired (String showExpired) {
      this.setParam("show_expired", showExpired);
      return this;
    }

    public APIRequestGetPosts setWith (PagePost.EnumWith with) {
      this.setParam("with", with);
      return this;
    }
    public APIRequestGetPosts setWith (String with) {
      this.setParam("with", with);
      return this;
    }

    public APIRequestGetPosts requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetPosts requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetPosts requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetPosts requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetPosts requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetPosts requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetPosts requestActionsField () {
      return this.requestActionsField(true);
    }
    public APIRequestGetPosts requestActionsField (boolean value) {
      this.requestField("actions", value);
      return this;
    }
    public APIRequestGetPosts requestAdminCreatorField () {
      return this.requestAdminCreatorField(true);
    }
    public APIRequestGetPosts requestAdminCreatorField (boolean value) {
      this.requestField("admin_creator", value);
      return this;
    }
    public APIRequestGetPosts requestAllowedAdvertisingObjectivesField () {
      return this.requestAllowedAdvertisingObjectivesField(true);
    }
    public APIRequestGetPosts requestAllowedAdvertisingObjectivesField (boolean value) {
      this.requestField("allowed_advertising_objectives", value);
      return this;
    }
    public APIRequestGetPosts requestApplicationField () {
      return this.requestApplicationField(true);
    }
    public APIRequestGetPosts requestApplicationField (boolean value) {
      this.requestField("application", value);
      return this;
    }
    public APIRequestGetPosts requestBackdatedTimeField () {
      return this.requestBackdatedTimeField(true);
    }
    public APIRequestGetPosts requestBackdatedTimeField (boolean value) {
      this.requestField("backdated_time", value);
      return this;
    }
    public APIRequestGetPosts requestCallToActionField () {
      return this.requestCallToActionField(true);
    }
    public APIRequestGetPosts requestCallToActionField (boolean value) {
      this.requestField("call_to_action", value);
      return this;
    }
    public APIRequestGetPosts requestCanReplyPrivatelyField () {
      return this.requestCanReplyPrivatelyField(true);
    }
    public APIRequestGetPosts requestCanReplyPrivatelyField (boolean value) {
      this.requestField("can_reply_privately", value);
      return this;
    }
    public APIRequestGetPosts requestChildAttachmentsField () {
      return this.requestChildAttachmentsField(true);
    }
    public APIRequestGetPosts requestChildAttachmentsField (boolean value) {
      this.requestField("child_attachments", value);
      return this;
    }
    public APIRequestGetPosts requestCommentsMirroringDomainField () {
      return this.requestCommentsMirroringDomainField(true);
    }
    public APIRequestGetPosts requestCommentsMirroringDomainField (boolean value) {
      this.requestField("comments_mirroring_domain", value);
      return this;
    }
    public APIRequestGetPosts requestCoordinatesField () {
      return this.requestCoordinatesField(true);
    }
    public APIRequestGetPosts requestCoordinatesField (boolean value) {
      this.requestField("coordinates", value);
      return this;
    }
    public APIRequestGetPosts requestCreatedTimeField () {
      return this.requestCreatedTimeField(true);
    }
    public APIRequestGetPosts requestCreatedTimeField (boolean value) {
      this.requestField("created_time", value);
      return this;
    }
    public APIRequestGetPosts requestEventField () {
      return this.requestEventField(true);
    }
    public APIRequestGetPosts requestEventField (boolean value) {
      this.requestField("event", value);
      return this;
    }
    public APIRequestGetPosts requestExpandedHeightField () {
      return this.requestExpandedHeightField(true);
    }
    public APIRequestGetPosts requestExpandedHeightField (boolean value) {
      this.requestField("expanded_height", value);
      return this;
    }
    public APIRequestGetPosts requestExpandedWidthField () {
      return this.requestExpandedWidthField(true);
    }
    public APIRequestGetPosts requestExpandedWidthField (boolean value) {
      this.requestField("expanded_width", value);
      return this;
    }
    public APIRequestGetPosts requestFeedTargetingField () {
      return this.requestFeedTargetingField(true);
    }
    public APIRequestGetPosts requestFeedTargetingField (boolean value) {
      this.requestField("feed_targeting", value);
      return this;
    }
    public APIRequestGetPosts requestFromField () {
      return this.requestFromField(true);
    }
    public APIRequestGetPosts requestFromField (boolean value) {
      this.requestField("from", value);
      return this;
    }
    public APIRequestGetPosts requestFullPictureField () {
      return this.requestFullPictureField(true);
    }
    public APIRequestGetPosts requestFullPictureField (boolean value) {
      this.requestField("full_picture", value);
      return this;
    }
    public APIRequestGetPosts requestHeightField () {
      return this.requestHeightField(true);
    }
    public APIRequestGetPosts requestHeightField (boolean value) {
      this.requestField("height", value);
      return this;
    }
    public APIRequestGetPosts requestIconField () {
      return this.requestIconField(true);
    }
    public APIRequestGetPosts requestIconField (boolean value) {
      this.requestField("icon", value);
      return this;
    }
    public APIRequestGetPosts requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetPosts requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetPosts requestInstagramEligibilityField () {
      return this.requestInstagramEligibilityField(true);
    }
    public APIRequestGetPosts requestInstagramEligibilityField (boolean value) {
      this.requestField("instagram_eligibility", value);
      return this;
    }
    public APIRequestGetPosts requestIsAppShareField () {
      return this.requestIsAppShareField(true);
    }
    public APIRequestGetPosts requestIsAppShareField (boolean value) {
      this.requestField("is_app_share", value);
      return this;
    }
    public APIRequestGetPosts requestIsEligibleForPromotionField () {
      return this.requestIsEligibleForPromotionField(true);
    }
    public APIRequestGetPosts requestIsEligibleForPromotionField (boolean value) {
      this.requestField("is_eligible_for_promotion", value);
      return this;
    }
    public APIRequestGetPosts requestIsExpiredField () {
      return this.requestIsExpiredField(true);
    }
    public APIRequestGetPosts requestIsExpiredField (boolean value) {
      this.requestField("is_expired", value);
      return this;
    }
    public APIRequestGetPosts requestIsHiddenField () {
      return this.requestIsHiddenField(true);
    }
    public APIRequestGetPosts requestIsHiddenField (boolean value) {
      this.requestField("is_hidden", value);
      return this;
    }
    public APIRequestGetPosts requestIsInlineCreatedField () {
      return this.requestIsInlineCreatedField(true);
    }
    public APIRequestGetPosts requestIsInlineCreatedField (boolean value) {
      this.requestField("is_inline_created", value);
      return this;
    }
    public APIRequestGetPosts requestIsInstagramEligibleField () {
      return this.requestIsInstagramEligibleField(true);
    }
    public APIRequestGetPosts requestIsInstagramEligibleField (boolean value) {
      this.requestField("is_instagram_eligible", value);
      return this;
    }
    public APIRequestGetPosts requestIsPopularField () {
      return this.requestIsPopularField(true);
    }
    public APIRequestGetPosts requestIsPopularField (boolean value) {
      this.requestField("is_popular", value);
      return this;
    }
    public APIRequestGetPosts requestIsPublishedField () {
      return this.requestIsPublishedField(true);
    }
    public APIRequestGetPosts requestIsPublishedField (boolean value) {
      this.requestField("is_published", value);
      return this;
    }
    public APIRequestGetPosts requestIsSphericalField () {
      return this.requestIsSphericalField(true);
    }
    public APIRequestGetPosts requestIsSphericalField (boolean value) {
      this.requestField("is_spherical", value);
      return this;
    }
    public APIRequestGetPosts requestMessageField () {
      return this.requestMessageField(true);
    }
    public APIRequestGetPosts requestMessageField (boolean value) {
      this.requestField("message", value);
      return this;
    }
    public APIRequestGetPosts requestMessageTagsField () {
      return this.requestMessageTagsField(true);
    }
    public APIRequestGetPosts requestMessageTagsField (boolean value) {
      this.requestField("message_tags", value);
      return this;
    }
    public APIRequestGetPosts requestMultiShareEndCardField () {
      return this.requestMultiShareEndCardField(true);
    }
    public APIRequestGetPosts requestMultiShareEndCardField (boolean value) {
      this.requestField("multi_share_end_card", value);
      return this;
    }
    public APIRequestGetPosts requestMultiShareOptimizedField () {
      return this.requestMultiShareOptimizedField(true);
    }
    public APIRequestGetPosts requestMultiShareOptimizedField (boolean value) {
      this.requestField("multi_share_optimized", value);
      return this;
    }
    public APIRequestGetPosts requestParentIdField () {
      return this.requestParentIdField(true);
    }
    public APIRequestGetPosts requestParentIdField (boolean value) {
      this.requestField("parent_id", value);
      return this;
    }
    public APIRequestGetPosts requestPermalinkUrlField () {
      return this.requestPermalinkUrlField(true);
    }
    public APIRequestGetPosts requestPermalinkUrlField (boolean value) {
      this.requestField("permalink_url", value);
      return this;
    }
    public APIRequestGetPosts requestPictureField () {
      return this.requestPictureField(true);
    }
    public APIRequestGetPosts requestPictureField (boolean value) {
      this.requestField("picture", value);
      return this;
    }
    public APIRequestGetPosts requestPlaceField () {
      return this.requestPlaceField(true);
    }
    public APIRequestGetPosts requestPlaceField (boolean value) {
      this.requestField("place", value);
      return this;
    }
    public APIRequestGetPosts requestPrivacyField () {
      return this.requestPrivacyField(true);
    }
    public APIRequestGetPosts requestPrivacyField (boolean value) {
      this.requestField("privacy", value);
      return this;
    }
    public APIRequestGetPosts requestPromotableIdField () {
      return this.requestPromotableIdField(true);
    }
    public APIRequestGetPosts requestPromotableIdField (boolean value) {
      this.requestField("promotable_id", value);
      return this;
    }
    public APIRequestGetPosts requestPromotionStatusField () {
      return this.requestPromotionStatusField(true);
    }
    public APIRequestGetPosts requestPromotionStatusField (boolean value) {
      this.requestField("promotion_status", value);
      return this;
    }
    public APIRequestGetPosts requestPropertiesField () {
      return this.requestPropertiesField(true);
    }
    public APIRequestGetPosts requestPropertiesField (boolean value) {
      this.requestField("properties", value);
      return this;
    }
    public APIRequestGetPosts requestScheduledPublishTimeField () {
      return this.requestScheduledPublishTimeField(true);
    }
    public APIRequestGetPosts requestScheduledPublishTimeField (boolean value) {
      this.requestField("scheduled_publish_time", value);
      return this;
    }
    public APIRequestGetPosts requestSharesField () {
      return this.requestSharesField(true);
    }
    public APIRequestGetPosts requestSharesField (boolean value) {
      this.requestField("shares", value);
      return this;
    }
    public APIRequestGetPosts requestStatusTypeField () {
      return this.requestStatusTypeField(true);
    }
    public APIRequestGetPosts requestStatusTypeField (boolean value) {
      this.requestField("status_type", value);
      return this;
    }
    public APIRequestGetPosts requestStoryField () {
      return this.requestStoryField(true);
    }
    public APIRequestGetPosts requestStoryField (boolean value) {
      this.requestField("story", value);
      return this;
    }
    public APIRequestGetPosts requestStoryTagsField () {
      return this.requestStoryTagsField(true);
    }
    public APIRequestGetPosts requestStoryTagsField (boolean value) {
      this.requestField("story_tags", value);
      return this;
    }
    public APIRequestGetPosts requestSubscribedField () {
      return this.requestSubscribedField(true);
    }
    public APIRequestGetPosts requestSubscribedField (boolean value) {
      this.requestField("subscribed", value);
      return this;
    }
    public APIRequestGetPosts requestTargetField () {
      return this.requestTargetField(true);
    }
    public APIRequestGetPosts requestTargetField (boolean value) {
      this.requestField("target", value);
      return this;
    }
    public APIRequestGetPosts requestTargetingField () {
      return this.requestTargetingField(true);
    }
    public APIRequestGetPosts requestTargetingField (boolean value) {
      this.requestField("targeting", value);
      return this;
    }
    public APIRequestGetPosts requestTimelineVisibilityField () {
      return this.requestTimelineVisibilityField(true);
    }
    public APIRequestGetPosts requestTimelineVisibilityField (boolean value) {
      this.requestField("timeline_visibility", value);
      return this;
    }
    public APIRequestGetPosts requestUpdatedTimeField () {
      return this.requestUpdatedTimeField(true);
    }
    public APIRequestGetPosts requestUpdatedTimeField (boolean value) {
      this.requestField("updated_time", value);
      return this;
    }
    public APIRequestGetPosts requestViaField () {
      return this.requestViaField(true);
    }
    public APIRequestGetPosts requestViaField (boolean value) {
      this.requestField("via", value);
      return this;
    }
    public APIRequestGetPosts requestVideoBuyingEligibilityField () {
      return this.requestVideoBuyingEligibilityField(true);
    }
    public APIRequestGetPosts requestVideoBuyingEligibilityField (boolean value) {
      this.requestField("video_buying_eligibility", value);
      return this;
    }
    public APIRequestGetPosts requestWidthField () {
      return this.requestWidthField(true);
    }
    public APIRequestGetPosts requestWidthField (boolean value) {
      this.requestField("width", value);
      return this;
    }
  }

  public static class APIRequestGetProductCatalogs extends APIRequest<ProductCatalog> {

    APINodeList<ProductCatalog> lastResponse = null;
    @Override
    public APINodeList<ProductCatalog> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "ad_account_to_collaborative_ads_share_settings",
      "agency_collaborative_ads_share_settings",
      "business",
      "catalog_store",
      "commerce_merchant_settings",
      "creator_user",
      "da_display_settings",
      "default_image_url",
      "fallback_image_url",
      "feed_count",
      "id",
      "is_catalog_segment",
      "is_local_catalog",
      "name",
      "owner_business",
      "product_count",
      "store_catalog_settings",
      "user_access_expire_time",
      "vertical",
    };

    @Override
    public APINodeList<ProductCatalog> parseResponse(String response, String header) throws APIException {
      return ProductCatalog.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<ProductCatalog> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<ProductCatalog> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<ProductCatalog>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<ProductCatalog>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<ProductCatalog>>() {
           public APINodeList<ProductCatalog> apply(ResponseWrapper result) {
             try {
               return APIRequestGetProductCatalogs.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetProductCatalogs(String nodeId, APIContext context) {
      super(context, nodeId, "/product_catalogs", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetProductCatalogs setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetProductCatalogs setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetProductCatalogs requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetProductCatalogs requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetProductCatalogs requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetProductCatalogs requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetProductCatalogs requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetProductCatalogs requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetProductCatalogs requestAdAccountToCollaborativeAdsShareSettingsField () {
      return this.requestAdAccountToCollaborativeAdsShareSettingsField(true);
    }
    public APIRequestGetProductCatalogs requestAdAccountToCollaborativeAdsShareSettingsField (boolean value) {
      this.requestField("ad_account_to_collaborative_ads_share_settings", value);
      return this;
    }
    public APIRequestGetProductCatalogs requestAgencyCollaborativeAdsShareSettingsField () {
      return this.requestAgencyCollaborativeAdsShareSettingsField(true);
    }
    public APIRequestGetProductCatalogs requestAgencyCollaborativeAdsShareSettingsField (boolean value) {
      this.requestField("agency_collaborative_ads_share_settings", value);
      return this;
    }
    public APIRequestGetProductCatalogs requestBusinessField () {
      return this.requestBusinessField(true);
    }
    public APIRequestGetProductCatalogs requestBusinessField (boolean value) {
      this.requestField("business", value);
      return this;
    }
    public APIRequestGetProductCatalogs requestCatalogStoreField () {
      return this.requestCatalogStoreField(true);
    }
    public APIRequestGetProductCatalogs requestCatalogStoreField (boolean value) {
      this.requestField("catalog_store", value);
      return this;
    }
    public APIRequestGetProductCatalogs requestCommerceMerchantSettingsField () {
      return this.requestCommerceMerchantSettingsField(true);
    }
    public APIRequestGetProductCatalogs requestCommerceMerchantSettingsField (boolean value) {
      this.requestField("commerce_merchant_settings", value);
      return this;
    }
    public APIRequestGetProductCatalogs requestCreatorUserField () {
      return this.requestCreatorUserField(true);
    }
    public APIRequestGetProductCatalogs requestCreatorUserField (boolean value) {
      this.requestField("creator_user", value);
      return this;
    }
    public APIRequestGetProductCatalogs requestDaDisplaySettingsField () {
      return this.requestDaDisplaySettingsField(true);
    }
    public APIRequestGetProductCatalogs requestDaDisplaySettingsField (boolean value) {
      this.requestField("da_display_settings", value);
      return this;
    }
    public APIRequestGetProductCatalogs requestDefaultImageUrlField () {
      return this.requestDefaultImageUrlField(true);
    }
    public APIRequestGetProductCatalogs requestDefaultImageUrlField (boolean value) {
      this.requestField("default_image_url", value);
      return this;
    }
    public APIRequestGetProductCatalogs requestFallbackImageUrlField () {
      return this.requestFallbackImageUrlField(true);
    }
    public APIRequestGetProductCatalogs requestFallbackImageUrlField (boolean value) {
      this.requestField("fallback_image_url", value);
      return this;
    }
    public APIRequestGetProductCatalogs requestFeedCountField () {
      return this.requestFeedCountField(true);
    }
    public APIRequestGetProductCatalogs requestFeedCountField (boolean value) {
      this.requestField("feed_count", value);
      return this;
    }
    public APIRequestGetProductCatalogs requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetProductCatalogs requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetProductCatalogs requestIsCatalogSegmentField () {
      return this.requestIsCatalogSegmentField(true);
    }
    public APIRequestGetProductCatalogs requestIsCatalogSegmentField (boolean value) {
      this.requestField("is_catalog_segment", value);
      return this;
    }
    public APIRequestGetProductCatalogs requestIsLocalCatalogField () {
      return this.requestIsLocalCatalogField(true);
    }
    public APIRequestGetProductCatalogs requestIsLocalCatalogField (boolean value) {
      this.requestField("is_local_catalog", value);
      return this;
    }
    public APIRequestGetProductCatalogs requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetProductCatalogs requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetProductCatalogs requestOwnerBusinessField () {
      return this.requestOwnerBusinessField(true);
    }
    public APIRequestGetProductCatalogs requestOwnerBusinessField (boolean value) {
      this.requestField("owner_business", value);
      return this;
    }
    public APIRequestGetProductCatalogs requestProductCountField () {
      return this.requestProductCountField(true);
    }
    public APIRequestGetProductCatalogs requestProductCountField (boolean value) {
      this.requestField("product_count", value);
      return this;
    }
    public APIRequestGetProductCatalogs requestStoreCatalogSettingsField () {
      return this.requestStoreCatalogSettingsField(true);
    }
    public APIRequestGetProductCatalogs requestStoreCatalogSettingsField (boolean value) {
      this.requestField("store_catalog_settings", value);
      return this;
    }
    public APIRequestGetProductCatalogs requestUserAccessExpireTimeField () {
      return this.requestUserAccessExpireTimeField(true);
    }
    public APIRequestGetProductCatalogs requestUserAccessExpireTimeField (boolean value) {
      this.requestField("user_access_expire_time", value);
      return this;
    }
    public APIRequestGetProductCatalogs requestVerticalField () {
      return this.requestVerticalField(true);
    }
    public APIRequestGetProductCatalogs requestVerticalField (boolean value) {
      this.requestField("vertical", value);
      return this;
    }
  }

  public static class APIRequestGetPublishedPosts extends APIRequest<PagePost> {

    APINodeList<PagePost> lastResponse = null;
    @Override
    public APINodeList<PagePost> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "include_hidden",
      "limit",
      "show_expired",
      "with",
    };

    public static final String[] FIELDS = {
      "actions",
      "admin_creator",
      "allowed_advertising_objectives",
      "application",
      "backdated_time",
      "call_to_action",
      "can_reply_privately",
      "child_attachments",
      "comments_mirroring_domain",
      "coordinates",
      "created_time",
      "event",
      "expanded_height",
      "expanded_width",
      "feed_targeting",
      "from",
      "full_picture",
      "height",
      "icon",
      "id",
      "instagram_eligibility",
      "is_app_share",
      "is_eligible_for_promotion",
      "is_expired",
      "is_hidden",
      "is_inline_created",
      "is_instagram_eligible",
      "is_popular",
      "is_published",
      "is_spherical",
      "message",
      "message_tags",
      "multi_share_end_card",
      "multi_share_optimized",
      "parent_id",
      "permalink_url",
      "picture",
      "place",
      "privacy",
      "promotable_id",
      "promotion_status",
      "properties",
      "scheduled_publish_time",
      "shares",
      "status_type",
      "story",
      "story_tags",
      "subscribed",
      "target",
      "targeting",
      "timeline_visibility",
      "updated_time",
      "via",
      "video_buying_eligibility",
      "width",
    };

    @Override
    public APINodeList<PagePost> parseResponse(String response, String header) throws APIException {
      return PagePost.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<PagePost> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<PagePost> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<PagePost>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<PagePost>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<PagePost>>() {
           public APINodeList<PagePost> apply(ResponseWrapper result) {
             try {
               return APIRequestGetPublishedPosts.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetPublishedPosts(String nodeId, APIContext context) {
      super(context, nodeId, "/published_posts", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetPublishedPosts setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetPublishedPosts setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetPublishedPosts setIncludeHidden (Boolean includeHidden) {
      this.setParam("include_hidden", includeHidden);
      return this;
    }
    public APIRequestGetPublishedPosts setIncludeHidden (String includeHidden) {
      this.setParam("include_hidden", includeHidden);
      return this;
    }

    public APIRequestGetPublishedPosts setLimit (Long limit) {
      this.setParam("limit", limit);
      return this;
    }
    public APIRequestGetPublishedPosts setLimit (String limit) {
      this.setParam("limit", limit);
      return this;
    }

    public APIRequestGetPublishedPosts setShowExpired (Boolean showExpired) {
      this.setParam("show_expired", showExpired);
      return this;
    }
    public APIRequestGetPublishedPosts setShowExpired (String showExpired) {
      this.setParam("show_expired", showExpired);
      return this;
    }

    public APIRequestGetPublishedPosts setWith (PagePost.EnumWith with) {
      this.setParam("with", with);
      return this;
    }
    public APIRequestGetPublishedPosts setWith (String with) {
      this.setParam("with", with);
      return this;
    }

    public APIRequestGetPublishedPosts requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetPublishedPosts requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetPublishedPosts requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetPublishedPosts requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetPublishedPosts requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetPublishedPosts requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetPublishedPosts requestActionsField () {
      return this.requestActionsField(true);
    }
    public APIRequestGetPublishedPosts requestActionsField (boolean value) {
      this.requestField("actions", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestAdminCreatorField () {
      return this.requestAdminCreatorField(true);
    }
    public APIRequestGetPublishedPosts requestAdminCreatorField (boolean value) {
      this.requestField("admin_creator", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestAllowedAdvertisingObjectivesField () {
      return this.requestAllowedAdvertisingObjectivesField(true);
    }
    public APIRequestGetPublishedPosts requestAllowedAdvertisingObjectivesField (boolean value) {
      this.requestField("allowed_advertising_objectives", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestApplicationField () {
      return this.requestApplicationField(true);
    }
    public APIRequestGetPublishedPosts requestApplicationField (boolean value) {
      this.requestField("application", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestBackdatedTimeField () {
      return this.requestBackdatedTimeField(true);
    }
    public APIRequestGetPublishedPosts requestBackdatedTimeField (boolean value) {
      this.requestField("backdated_time", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestCallToActionField () {
      return this.requestCallToActionField(true);
    }
    public APIRequestGetPublishedPosts requestCallToActionField (boolean value) {
      this.requestField("call_to_action", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestCanReplyPrivatelyField () {
      return this.requestCanReplyPrivatelyField(true);
    }
    public APIRequestGetPublishedPosts requestCanReplyPrivatelyField (boolean value) {
      this.requestField("can_reply_privately", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestChildAttachmentsField () {
      return this.requestChildAttachmentsField(true);
    }
    public APIRequestGetPublishedPosts requestChildAttachmentsField (boolean value) {
      this.requestField("child_attachments", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestCommentsMirroringDomainField () {
      return this.requestCommentsMirroringDomainField(true);
    }
    public APIRequestGetPublishedPosts requestCommentsMirroringDomainField (boolean value) {
      this.requestField("comments_mirroring_domain", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestCoordinatesField () {
      return this.requestCoordinatesField(true);
    }
    public APIRequestGetPublishedPosts requestCoordinatesField (boolean value) {
      this.requestField("coordinates", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestCreatedTimeField () {
      return this.requestCreatedTimeField(true);
    }
    public APIRequestGetPublishedPosts requestCreatedTimeField (boolean value) {
      this.requestField("created_time", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestEventField () {
      return this.requestEventField(true);
    }
    public APIRequestGetPublishedPosts requestEventField (boolean value) {
      this.requestField("event", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestExpandedHeightField () {
      return this.requestExpandedHeightField(true);
    }
    public APIRequestGetPublishedPosts requestExpandedHeightField (boolean value) {
      this.requestField("expanded_height", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestExpandedWidthField () {
      return this.requestExpandedWidthField(true);
    }
    public APIRequestGetPublishedPosts requestExpandedWidthField (boolean value) {
      this.requestField("expanded_width", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestFeedTargetingField () {
      return this.requestFeedTargetingField(true);
    }
    public APIRequestGetPublishedPosts requestFeedTargetingField (boolean value) {
      this.requestField("feed_targeting", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestFromField () {
      return this.requestFromField(true);
    }
    public APIRequestGetPublishedPosts requestFromField (boolean value) {
      this.requestField("from", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestFullPictureField () {
      return this.requestFullPictureField(true);
    }
    public APIRequestGetPublishedPosts requestFullPictureField (boolean value) {
      this.requestField("full_picture", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestHeightField () {
      return this.requestHeightField(true);
    }
    public APIRequestGetPublishedPosts requestHeightField (boolean value) {
      this.requestField("height", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestIconField () {
      return this.requestIconField(true);
    }
    public APIRequestGetPublishedPosts requestIconField (boolean value) {
      this.requestField("icon", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetPublishedPosts requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestInstagramEligibilityField () {
      return this.requestInstagramEligibilityField(true);
    }
    public APIRequestGetPublishedPosts requestInstagramEligibilityField (boolean value) {
      this.requestField("instagram_eligibility", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestIsAppShareField () {
      return this.requestIsAppShareField(true);
    }
    public APIRequestGetPublishedPosts requestIsAppShareField (boolean value) {
      this.requestField("is_app_share", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestIsEligibleForPromotionField () {
      return this.requestIsEligibleForPromotionField(true);
    }
    public APIRequestGetPublishedPosts requestIsEligibleForPromotionField (boolean value) {
      this.requestField("is_eligible_for_promotion", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestIsExpiredField () {
      return this.requestIsExpiredField(true);
    }
    public APIRequestGetPublishedPosts requestIsExpiredField (boolean value) {
      this.requestField("is_expired", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestIsHiddenField () {
      return this.requestIsHiddenField(true);
    }
    public APIRequestGetPublishedPosts requestIsHiddenField (boolean value) {
      this.requestField("is_hidden", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestIsInlineCreatedField () {
      return this.requestIsInlineCreatedField(true);
    }
    public APIRequestGetPublishedPosts requestIsInlineCreatedField (boolean value) {
      this.requestField("is_inline_created", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestIsInstagramEligibleField () {
      return this.requestIsInstagramEligibleField(true);
    }
    public APIRequestGetPublishedPosts requestIsInstagramEligibleField (boolean value) {
      this.requestField("is_instagram_eligible", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestIsPopularField () {
      return this.requestIsPopularField(true);
    }
    public APIRequestGetPublishedPosts requestIsPopularField (boolean value) {
      this.requestField("is_popular", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestIsPublishedField () {
      return this.requestIsPublishedField(true);
    }
    public APIRequestGetPublishedPosts requestIsPublishedField (boolean value) {
      this.requestField("is_published", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestIsSphericalField () {
      return this.requestIsSphericalField(true);
    }
    public APIRequestGetPublishedPosts requestIsSphericalField (boolean value) {
      this.requestField("is_spherical", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestMessageField () {
      return this.requestMessageField(true);
    }
    public APIRequestGetPublishedPosts requestMessageField (boolean value) {
      this.requestField("message", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestMessageTagsField () {
      return this.requestMessageTagsField(true);
    }
    public APIRequestGetPublishedPosts requestMessageTagsField (boolean value) {
      this.requestField("message_tags", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestMultiShareEndCardField () {
      return this.requestMultiShareEndCardField(true);
    }
    public APIRequestGetPublishedPosts requestMultiShareEndCardField (boolean value) {
      this.requestField("multi_share_end_card", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestMultiShareOptimizedField () {
      return this.requestMultiShareOptimizedField(true);
    }
    public APIRequestGetPublishedPosts requestMultiShareOptimizedField (boolean value) {
      this.requestField("multi_share_optimized", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestParentIdField () {
      return this.requestParentIdField(true);
    }
    public APIRequestGetPublishedPosts requestParentIdField (boolean value) {
      this.requestField("parent_id", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestPermalinkUrlField () {
      return this.requestPermalinkUrlField(true);
    }
    public APIRequestGetPublishedPosts requestPermalinkUrlField (boolean value) {
      this.requestField("permalink_url", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestPictureField () {
      return this.requestPictureField(true);
    }
    public APIRequestGetPublishedPosts requestPictureField (boolean value) {
      this.requestField("picture", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestPlaceField () {
      return this.requestPlaceField(true);
    }
    public APIRequestGetPublishedPosts requestPlaceField (boolean value) {
      this.requestField("place", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestPrivacyField () {
      return this.requestPrivacyField(true);
    }
    public APIRequestGetPublishedPosts requestPrivacyField (boolean value) {
      this.requestField("privacy", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestPromotableIdField () {
      return this.requestPromotableIdField(true);
    }
    public APIRequestGetPublishedPosts requestPromotableIdField (boolean value) {
      this.requestField("promotable_id", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestPromotionStatusField () {
      return this.requestPromotionStatusField(true);
    }
    public APIRequestGetPublishedPosts requestPromotionStatusField (boolean value) {
      this.requestField("promotion_status", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestPropertiesField () {
      return this.requestPropertiesField(true);
    }
    public APIRequestGetPublishedPosts requestPropertiesField (boolean value) {
      this.requestField("properties", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestScheduledPublishTimeField () {
      return this.requestScheduledPublishTimeField(true);
    }
    public APIRequestGetPublishedPosts requestScheduledPublishTimeField (boolean value) {
      this.requestField("scheduled_publish_time", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestSharesField () {
      return this.requestSharesField(true);
    }
    public APIRequestGetPublishedPosts requestSharesField (boolean value) {
      this.requestField("shares", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestStatusTypeField () {
      return this.requestStatusTypeField(true);
    }
    public APIRequestGetPublishedPosts requestStatusTypeField (boolean value) {
      this.requestField("status_type", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestStoryField () {
      return this.requestStoryField(true);
    }
    public APIRequestGetPublishedPosts requestStoryField (boolean value) {
      this.requestField("story", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestStoryTagsField () {
      return this.requestStoryTagsField(true);
    }
    public APIRequestGetPublishedPosts requestStoryTagsField (boolean value) {
      this.requestField("story_tags", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestSubscribedField () {
      return this.requestSubscribedField(true);
    }
    public APIRequestGetPublishedPosts requestSubscribedField (boolean value) {
      this.requestField("subscribed", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestTargetField () {
      return this.requestTargetField(true);
    }
    public APIRequestGetPublishedPosts requestTargetField (boolean value) {
      this.requestField("target", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestTargetingField () {
      return this.requestTargetingField(true);
    }
    public APIRequestGetPublishedPosts requestTargetingField (boolean value) {
      this.requestField("targeting", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestTimelineVisibilityField () {
      return this.requestTimelineVisibilityField(true);
    }
    public APIRequestGetPublishedPosts requestTimelineVisibilityField (boolean value) {
      this.requestField("timeline_visibility", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestUpdatedTimeField () {
      return this.requestUpdatedTimeField(true);
    }
    public APIRequestGetPublishedPosts requestUpdatedTimeField (boolean value) {
      this.requestField("updated_time", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestViaField () {
      return this.requestViaField(true);
    }
    public APIRequestGetPublishedPosts requestViaField (boolean value) {
      this.requestField("via", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestVideoBuyingEligibilityField () {
      return this.requestVideoBuyingEligibilityField(true);
    }
    public APIRequestGetPublishedPosts requestVideoBuyingEligibilityField (boolean value) {
      this.requestField("video_buying_eligibility", value);
      return this;
    }
    public APIRequestGetPublishedPosts requestWidthField () {
      return this.requestWidthField(true);
    }
    public APIRequestGetPublishedPosts requestWidthField (boolean value) {
      this.requestField("width", value);
      return this;
    }
  }

  public static class APIRequestGetRatings extends APIRequest<Recommendation> {

    APINodeList<Recommendation> lastResponse = null;
    @Override
    public APINodeList<Recommendation> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "created_time",
      "has_rating",
      "has_review",
      "open_graph_story",
      "rating",
      "recommendation_type",
      "review_text",
      "reviewer",
    };

    @Override
    public APINodeList<Recommendation> parseResponse(String response, String header) throws APIException {
      return Recommendation.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<Recommendation> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Recommendation> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Recommendation>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Recommendation>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<Recommendation>>() {
           public APINodeList<Recommendation> apply(ResponseWrapper result) {
             try {
               return APIRequestGetRatings.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetRatings(String nodeId, APIContext context) {
      super(context, nodeId, "/ratings", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetRatings setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetRatings setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetRatings requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetRatings requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetRatings requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetRatings requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetRatings requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetRatings requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetRatings requestCreatedTimeField () {
      return this.requestCreatedTimeField(true);
    }
    public APIRequestGetRatings requestCreatedTimeField (boolean value) {
      this.requestField("created_time", value);
      return this;
    }
    public APIRequestGetRatings requestHasRatingField () {
      return this.requestHasRatingField(true);
    }
    public APIRequestGetRatings requestHasRatingField (boolean value) {
      this.requestField("has_rating", value);
      return this;
    }
    public APIRequestGetRatings requestHasReviewField () {
      return this.requestHasReviewField(true);
    }
    public APIRequestGetRatings requestHasReviewField (boolean value) {
      this.requestField("has_review", value);
      return this;
    }
    public APIRequestGetRatings requestOpenGraphStoryField () {
      return this.requestOpenGraphStoryField(true);
    }
    public APIRequestGetRatings requestOpenGraphStoryField (boolean value) {
      this.requestField("open_graph_story", value);
      return this;
    }
    public APIRequestGetRatings requestRatingField () {
      return this.requestRatingField(true);
    }
    public APIRequestGetRatings requestRatingField (boolean value) {
      this.requestField("rating", value);
      return this;
    }
    public APIRequestGetRatings requestRecommendationTypeField () {
      return this.requestRecommendationTypeField(true);
    }
    public APIRequestGetRatings requestRecommendationTypeField (boolean value) {
      this.requestField("recommendation_type", value);
      return this;
    }
    public APIRequestGetRatings requestReviewTextField () {
      return this.requestReviewTextField(true);
    }
    public APIRequestGetRatings requestReviewTextField (boolean value) {
      this.requestField("review_text", value);
      return this;
    }
    public APIRequestGetRatings requestReviewerField () {
      return this.requestReviewerField(true);
    }
    public APIRequestGetRatings requestReviewerField (boolean value) {
      this.requestField("reviewer", value);
      return this;
    }
  }

  public static class APIRequestCreateReleaseThreadControl extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "recipient",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response, String header) throws APIException {
      return Page.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, Page>() {
           public Page apply(ResponseWrapper result) {
             try {
               return APIRequestCreateReleaseThreadControl.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateReleaseThreadControl(String nodeId, APIContext context) {
      super(context, nodeId, "/release_thread_control", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateReleaseThreadControl setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateReleaseThreadControl setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateReleaseThreadControl setRecipient (Object recipient) {
      this.setParam("recipient", recipient);
      return this;
    }
    public APIRequestCreateReleaseThreadControl setRecipient (String recipient) {
      this.setParam("recipient", recipient);
      return this;
    }

    public APIRequestCreateReleaseThreadControl requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateReleaseThreadControl requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateReleaseThreadControl requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateReleaseThreadControl requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateReleaseThreadControl requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateReleaseThreadControl requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestCreateRequestThreadControl extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "metadata",
      "recipient",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response, String header) throws APIException {
      return Page.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, Page>() {
           public Page apply(ResponseWrapper result) {
             try {
               return APIRequestCreateRequestThreadControl.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateRequestThreadControl(String nodeId, APIContext context) {
      super(context, nodeId, "/request_thread_control", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateRequestThreadControl setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateRequestThreadControl setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateRequestThreadControl setMetadata (String metadata) {
      this.setParam("metadata", metadata);
      return this;
    }

    public APIRequestCreateRequestThreadControl setRecipient (Object recipient) {
      this.setParam("recipient", recipient);
      return this;
    }
    public APIRequestCreateRequestThreadControl setRecipient (String recipient) {
      this.setParam("recipient", recipient);
      return this;
    }

    public APIRequestCreateRequestThreadControl requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateRequestThreadControl requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateRequestThreadControl requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateRequestThreadControl requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateRequestThreadControl requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateRequestThreadControl requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetRoles extends APIRequest<User> {

    APINodeList<User> lastResponse = null;
    @Override
    public APINodeList<User> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "include_deactivated",
      "uid",
    };

    public static final String[] FIELDS = {
      "about",
      "age_range",
      "birthday",
      "client_business_id",
      "community",
      "cover",
      "currency",
      "education",
      "email",
      "favorite_athletes",
      "favorite_teams",
      "first_name",
      "gender",
      "hometown",
      "id",
      "inspirational_people",
      "install_type",
      "installed",
      "is_guest_user",
      "is_work_account",
      "languages",
      "last_name",
      "link",
      "local_news_megaphone_dismiss_status",
      "local_news_subscription_status",
      "locale",
      "location",
      "meeting_for",
      "middle_name",
      "name",
      "name_format",
      "payment_pricepoints",
      "political",
      "profile_pic",
      "quotes",
      "relationship_status",
      "religion",
      "shared_login_upgrade_required_by",
      "short_name",
      "significant_other",
      "sports",
      "supports_donate_button_in_live_video",
      "third_party_id",
      "timezone",
      "token_for_business",
      "updated_time",
      "verified",
      "video_upload_limits",
      "website",
    };

    @Override
    public APINodeList<User> parseResponse(String response, String header) throws APIException {
      return User.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<User> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<User> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<User>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<User>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<User>>() {
           public APINodeList<User> apply(ResponseWrapper result) {
             try {
               return APIRequestGetRoles.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetRoles(String nodeId, APIContext context) {
      super(context, nodeId, "/roles", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetRoles setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetRoles setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetRoles setIncludeDeactivated (Boolean includeDeactivated) {
      this.setParam("include_deactivated", includeDeactivated);
      return this;
    }
    public APIRequestGetRoles setIncludeDeactivated (String includeDeactivated) {
      this.setParam("include_deactivated", includeDeactivated);
      return this;
    }

    public APIRequestGetRoles setUid (Long uid) {
      this.setParam("uid", uid);
      return this;
    }
    public APIRequestGetRoles setUid (String uid) {
      this.setParam("uid", uid);
      return this;
    }

    public APIRequestGetRoles requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetRoles requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetRoles requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetRoles requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetRoles requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetRoles requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetRoles requestAboutField () {
      return this.requestAboutField(true);
    }
    public APIRequestGetRoles requestAboutField (boolean value) {
      this.requestField("about", value);
      return this;
    }
    public APIRequestGetRoles requestAgeRangeField () {
      return this.requestAgeRangeField(true);
    }
    public APIRequestGetRoles requestAgeRangeField (boolean value) {
      this.requestField("age_range", value);
      return this;
    }
    public APIRequestGetRoles requestBirthdayField () {
      return this.requestBirthdayField(true);
    }
    public APIRequestGetRoles requestBirthdayField (boolean value) {
      this.requestField("birthday", value);
      return this;
    }
    public APIRequestGetRoles requestClientBusinessIdField () {
      return this.requestClientBusinessIdField(true);
    }
    public APIRequestGetRoles requestClientBusinessIdField (boolean value) {
      this.requestField("client_business_id", value);
      return this;
    }
    public APIRequestGetRoles requestCommunityField () {
      return this.requestCommunityField(true);
    }
    public APIRequestGetRoles requestCommunityField (boolean value) {
      this.requestField("community", value);
      return this;
    }
    public APIRequestGetRoles requestCoverField () {
      return this.requestCoverField(true);
    }
    public APIRequestGetRoles requestCoverField (boolean value) {
      this.requestField("cover", value);
      return this;
    }
    public APIRequestGetRoles requestCurrencyField () {
      return this.requestCurrencyField(true);
    }
    public APIRequestGetRoles requestCurrencyField (boolean value) {
      this.requestField("currency", value);
      return this;
    }
    public APIRequestGetRoles requestEducationField () {
      return this.requestEducationField(true);
    }
    public APIRequestGetRoles requestEducationField (boolean value) {
      this.requestField("education", value);
      return this;
    }
    public APIRequestGetRoles requestEmailField () {
      return this.requestEmailField(true);
    }
    public APIRequestGetRoles requestEmailField (boolean value) {
      this.requestField("email", value);
      return this;
    }
    public APIRequestGetRoles requestFavoriteAthletesField () {
      return this.requestFavoriteAthletesField(true);
    }
    public APIRequestGetRoles requestFavoriteAthletesField (boolean value) {
      this.requestField("favorite_athletes", value);
      return this;
    }
    public APIRequestGetRoles requestFavoriteTeamsField () {
      return this.requestFavoriteTeamsField(true);
    }
    public APIRequestGetRoles requestFavoriteTeamsField (boolean value) {
      this.requestField("favorite_teams", value);
      return this;
    }
    public APIRequestGetRoles requestFirstNameField () {
      return this.requestFirstNameField(true);
    }
    public APIRequestGetRoles requestFirstNameField (boolean value) {
      this.requestField("first_name", value);
      return this;
    }
    public APIRequestGetRoles requestGenderField () {
      return this.requestGenderField(true);
    }
    public APIRequestGetRoles requestGenderField (boolean value) {
      this.requestField("gender", value);
      return this;
    }
    public APIRequestGetRoles requestHometownField () {
      return this.requestHometownField(true);
    }
    public APIRequestGetRoles requestHometownField (boolean value) {
      this.requestField("hometown", value);
      return this;
    }
    public APIRequestGetRoles requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetRoles requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetRoles requestInspirationalPeopleField () {
      return this.requestInspirationalPeopleField(true);
    }
    public APIRequestGetRoles requestInspirationalPeopleField (boolean value) {
      this.requestField("inspirational_people", value);
      return this;
    }
    public APIRequestGetRoles requestInstallTypeField () {
      return this.requestInstallTypeField(true);
    }
    public APIRequestGetRoles requestInstallTypeField (boolean value) {
      this.requestField("install_type", value);
      return this;
    }
    public APIRequestGetRoles requestInstalledField () {
      return this.requestInstalledField(true);
    }
    public APIRequestGetRoles requestInstalledField (boolean value) {
      this.requestField("installed", value);
      return this;
    }
    public APIRequestGetRoles requestIsGuestUserField () {
      return this.requestIsGuestUserField(true);
    }
    public APIRequestGetRoles requestIsGuestUserField (boolean value) {
      this.requestField("is_guest_user", value);
      return this;
    }
    public APIRequestGetRoles requestIsWorkAccountField () {
      return this.requestIsWorkAccountField(true);
    }
    public APIRequestGetRoles requestIsWorkAccountField (boolean value) {
      this.requestField("is_work_account", value);
      return this;
    }
    public APIRequestGetRoles requestLanguagesField () {
      return this.requestLanguagesField(true);
    }
    public APIRequestGetRoles requestLanguagesField (boolean value) {
      this.requestField("languages", value);
      return this;
    }
    public APIRequestGetRoles requestLastNameField () {
      return this.requestLastNameField(true);
    }
    public APIRequestGetRoles requestLastNameField (boolean value) {
      this.requestField("last_name", value);
      return this;
    }
    public APIRequestGetRoles requestLinkField () {
      return this.requestLinkField(true);
    }
    public APIRequestGetRoles requestLinkField (boolean value) {
      this.requestField("link", value);
      return this;
    }
    public APIRequestGetRoles requestLocalNewsMegaphoneDismissStatusField () {
      return this.requestLocalNewsMegaphoneDismissStatusField(true);
    }
    public APIRequestGetRoles requestLocalNewsMegaphoneDismissStatusField (boolean value) {
      this.requestField("local_news_megaphone_dismiss_status", value);
      return this;
    }
    public APIRequestGetRoles requestLocalNewsSubscriptionStatusField () {
      return this.requestLocalNewsSubscriptionStatusField(true);
    }
    public APIRequestGetRoles requestLocalNewsSubscriptionStatusField (boolean value) {
      this.requestField("local_news_subscription_status", value);
      return this;
    }
    public APIRequestGetRoles requestLocaleField () {
      return this.requestLocaleField(true);
    }
    public APIRequestGetRoles requestLocaleField (boolean value) {
      this.requestField("locale", value);
      return this;
    }
    public APIRequestGetRoles requestLocationField () {
      return this.requestLocationField(true);
    }
    public APIRequestGetRoles requestLocationField (boolean value) {
      this.requestField("location", value);
      return this;
    }
    public APIRequestGetRoles requestMeetingForField () {
      return this.requestMeetingForField(true);
    }
    public APIRequestGetRoles requestMeetingForField (boolean value) {
      this.requestField("meeting_for", value);
      return this;
    }
    public APIRequestGetRoles requestMiddleNameField () {
      return this.requestMiddleNameField(true);
    }
    public APIRequestGetRoles requestMiddleNameField (boolean value) {
      this.requestField("middle_name", value);
      return this;
    }
    public APIRequestGetRoles requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetRoles requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetRoles requestNameFormatField () {
      return this.requestNameFormatField(true);
    }
    public APIRequestGetRoles requestNameFormatField (boolean value) {
      this.requestField("name_format", value);
      return this;
    }
    public APIRequestGetRoles requestPaymentPricepointsField () {
      return this.requestPaymentPricepointsField(true);
    }
    public APIRequestGetRoles requestPaymentPricepointsField (boolean value) {
      this.requestField("payment_pricepoints", value);
      return this;
    }
    public APIRequestGetRoles requestPoliticalField () {
      return this.requestPoliticalField(true);
    }
    public APIRequestGetRoles requestPoliticalField (boolean value) {
      this.requestField("political", value);
      return this;
    }
    public APIRequestGetRoles requestProfilePicField () {
      return this.requestProfilePicField(true);
    }
    public APIRequestGetRoles requestProfilePicField (boolean value) {
      this.requestField("profile_pic", value);
      return this;
    }
    public APIRequestGetRoles requestQuotesField () {
      return this.requestQuotesField(true);
    }
    public APIRequestGetRoles requestQuotesField (boolean value) {
      this.requestField("quotes", value);
      return this;
    }
    public APIRequestGetRoles requestRelationshipStatusField () {
      return this.requestRelationshipStatusField(true);
    }
    public APIRequestGetRoles requestRelationshipStatusField (boolean value) {
      this.requestField("relationship_status", value);
      return this;
    }
    public APIRequestGetRoles requestReligionField () {
      return this.requestReligionField(true);
    }
    public APIRequestGetRoles requestReligionField (boolean value) {
      this.requestField("religion", value);
      return this;
    }
    public APIRequestGetRoles requestSharedLoginUpgradeRequiredByField () {
      return this.requestSharedLoginUpgradeRequiredByField(true);
    }
    public APIRequestGetRoles requestSharedLoginUpgradeRequiredByField (boolean value) {
      this.requestField("shared_login_upgrade_required_by", value);
      return this;
    }
    public APIRequestGetRoles requestShortNameField () {
      return this.requestShortNameField(true);
    }
    public APIRequestGetRoles requestShortNameField (boolean value) {
      this.requestField("short_name", value);
      return this;
    }
    public APIRequestGetRoles requestSignificantOtherField () {
      return this.requestSignificantOtherField(true);
    }
    public APIRequestGetRoles requestSignificantOtherField (boolean value) {
      this.requestField("significant_other", value);
      return this;
    }
    public APIRequestGetRoles requestSportsField () {
      return this.requestSportsField(true);
    }
    public APIRequestGetRoles requestSportsField (boolean value) {
      this.requestField("sports", value);
      return this;
    }
    public APIRequestGetRoles requestSupportsDonateButtonInLiveVideoField () {
      return this.requestSupportsDonateButtonInLiveVideoField(true);
    }
    public APIRequestGetRoles requestSupportsDonateButtonInLiveVideoField (boolean value) {
      this.requestField("supports_donate_button_in_live_video", value);
      return this;
    }
    public APIRequestGetRoles requestThirdPartyIdField () {
      return this.requestThirdPartyIdField(true);
    }
    public APIRequestGetRoles requestThirdPartyIdField (boolean value) {
      this.requestField("third_party_id", value);
      return this;
    }
    public APIRequestGetRoles requestTimezoneField () {
      return this.requestTimezoneField(true);
    }
    public APIRequestGetRoles requestTimezoneField (boolean value) {
      this.requestField("timezone", value);
      return this;
    }
    public APIRequestGetRoles requestTokenForBusinessField () {
      return this.requestTokenForBusinessField(true);
    }
    public APIRequestGetRoles requestTokenForBusinessField (boolean value) {
      this.requestField("token_for_business", value);
      return this;
    }
    public APIRequestGetRoles requestUpdatedTimeField () {
      return this.requestUpdatedTimeField(true);
    }
    public APIRequestGetRoles requestUpdatedTimeField (boolean value) {
      this.requestField("updated_time", value);
      return this;
    }
    public APIRequestGetRoles requestVerifiedField () {
      return this.requestVerifiedField(true);
    }
    public APIRequestGetRoles requestVerifiedField (boolean value) {
      this.requestField("verified", value);
      return this;
    }
    public APIRequestGetRoles requestVideoUploadLimitsField () {
      return this.requestVideoUploadLimitsField(true);
    }
    public APIRequestGetRoles requestVideoUploadLimitsField (boolean value) {
      this.requestField("video_upload_limits", value);
      return this;
    }
    public APIRequestGetRoles requestWebsiteField () {
      return this.requestWebsiteField(true);
    }
    public APIRequestGetRoles requestWebsiteField (boolean value) {
      this.requestField("website", value);
      return this;
    }
  }

  public static class APIRequestGetRtbDynamicPosts extends APIRequest<RTBDynamicPost> {

    APINodeList<RTBDynamicPost> lastResponse = null;
    @Override
    public APINodeList<RTBDynamicPost> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "child_attachments",
      "created",
      "description",
      "id",
      "image_url",
      "link",
      "message",
      "owner_id",
      "place_id",
      "product_id",
      "title",
    };

    @Override
    public APINodeList<RTBDynamicPost> parseResponse(String response, String header) throws APIException {
      return RTBDynamicPost.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<RTBDynamicPost> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<RTBDynamicPost> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<RTBDynamicPost>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<RTBDynamicPost>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<RTBDynamicPost>>() {
           public APINodeList<RTBDynamicPost> apply(ResponseWrapper result) {
             try {
               return APIRequestGetRtbDynamicPosts.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetRtbDynamicPosts(String nodeId, APIContext context) {
      super(context, nodeId, "/rtb_dynamic_posts", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetRtbDynamicPosts setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetRtbDynamicPosts setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetRtbDynamicPosts requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetRtbDynamicPosts requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetRtbDynamicPosts requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetRtbDynamicPosts requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetRtbDynamicPosts requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetRtbDynamicPosts requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetRtbDynamicPosts requestChildAttachmentsField () {
      return this.requestChildAttachmentsField(true);
    }
    public APIRequestGetRtbDynamicPosts requestChildAttachmentsField (boolean value) {
      this.requestField("child_attachments", value);
      return this;
    }
    public APIRequestGetRtbDynamicPosts requestCreatedField () {
      return this.requestCreatedField(true);
    }
    public APIRequestGetRtbDynamicPosts requestCreatedField (boolean value) {
      this.requestField("created", value);
      return this;
    }
    public APIRequestGetRtbDynamicPosts requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetRtbDynamicPosts requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetRtbDynamicPosts requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetRtbDynamicPosts requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetRtbDynamicPosts requestImageUrlField () {
      return this.requestImageUrlField(true);
    }
    public APIRequestGetRtbDynamicPosts requestImageUrlField (boolean value) {
      this.requestField("image_url", value);
      return this;
    }
    public APIRequestGetRtbDynamicPosts requestLinkField () {
      return this.requestLinkField(true);
    }
    public APIRequestGetRtbDynamicPosts requestLinkField (boolean value) {
      this.requestField("link", value);
      return this;
    }
    public APIRequestGetRtbDynamicPosts requestMessageField () {
      return this.requestMessageField(true);
    }
    public APIRequestGetRtbDynamicPosts requestMessageField (boolean value) {
      this.requestField("message", value);
      return this;
    }
    public APIRequestGetRtbDynamicPosts requestOwnerIdField () {
      return this.requestOwnerIdField(true);
    }
    public APIRequestGetRtbDynamicPosts requestOwnerIdField (boolean value) {
      this.requestField("owner_id", value);
      return this;
    }
    public APIRequestGetRtbDynamicPosts requestPlaceIdField () {
      return this.requestPlaceIdField(true);
    }
    public APIRequestGetRtbDynamicPosts requestPlaceIdField (boolean value) {
      this.requestField("place_id", value);
      return this;
    }
    public APIRequestGetRtbDynamicPosts requestProductIdField () {
      return this.requestProductIdField(true);
    }
    public APIRequestGetRtbDynamicPosts requestProductIdField (boolean value) {
      this.requestField("product_id", value);
      return this;
    }
    public APIRequestGetRtbDynamicPosts requestTitleField () {
      return this.requestTitleField(true);
    }
    public APIRequestGetRtbDynamicPosts requestTitleField (boolean value) {
      this.requestField("title", value);
      return this;
    }
  }

  public static class APIRequestGetScheduledPosts extends APIRequest<PagePost> {

    APINodeList<PagePost> lastResponse = null;
    @Override
    public APINodeList<PagePost> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "actions",
      "admin_creator",
      "allowed_advertising_objectives",
      "application",
      "backdated_time",
      "call_to_action",
      "can_reply_privately",
      "child_attachments",
      "comments_mirroring_domain",
      "coordinates",
      "created_time",
      "event",
      "expanded_height",
      "expanded_width",
      "feed_targeting",
      "from",
      "full_picture",
      "height",
      "icon",
      "id",
      "instagram_eligibility",
      "is_app_share",
      "is_eligible_for_promotion",
      "is_expired",
      "is_hidden",
      "is_inline_created",
      "is_instagram_eligible",
      "is_popular",
      "is_published",
      "is_spherical",
      "message",
      "message_tags",
      "multi_share_end_card",
      "multi_share_optimized",
      "parent_id",
      "permalink_url",
      "picture",
      "place",
      "privacy",
      "promotable_id",
      "promotion_status",
      "properties",
      "scheduled_publish_time",
      "shares",
      "status_type",
      "story",
      "story_tags",
      "subscribed",
      "target",
      "targeting",
      "timeline_visibility",
      "updated_time",
      "via",
      "video_buying_eligibility",
      "width",
    };

    @Override
    public APINodeList<PagePost> parseResponse(String response, String header) throws APIException {
      return PagePost.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<PagePost> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<PagePost> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<PagePost>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<PagePost>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<PagePost>>() {
           public APINodeList<PagePost> apply(ResponseWrapper result) {
             try {
               return APIRequestGetScheduledPosts.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetScheduledPosts(String nodeId, APIContext context) {
      super(context, nodeId, "/scheduled_posts", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetScheduledPosts setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetScheduledPosts setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetScheduledPosts requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetScheduledPosts requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetScheduledPosts requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetScheduledPosts requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetScheduledPosts requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetScheduledPosts requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetScheduledPosts requestActionsField () {
      return this.requestActionsField(true);
    }
    public APIRequestGetScheduledPosts requestActionsField (boolean value) {
      this.requestField("actions", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestAdminCreatorField () {
      return this.requestAdminCreatorField(true);
    }
    public APIRequestGetScheduledPosts requestAdminCreatorField (boolean value) {
      this.requestField("admin_creator", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestAllowedAdvertisingObjectivesField () {
      return this.requestAllowedAdvertisingObjectivesField(true);
    }
    public APIRequestGetScheduledPosts requestAllowedAdvertisingObjectivesField (boolean value) {
      this.requestField("allowed_advertising_objectives", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestApplicationField () {
      return this.requestApplicationField(true);
    }
    public APIRequestGetScheduledPosts requestApplicationField (boolean value) {
      this.requestField("application", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestBackdatedTimeField () {
      return this.requestBackdatedTimeField(true);
    }
    public APIRequestGetScheduledPosts requestBackdatedTimeField (boolean value) {
      this.requestField("backdated_time", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestCallToActionField () {
      return this.requestCallToActionField(true);
    }
    public APIRequestGetScheduledPosts requestCallToActionField (boolean value) {
      this.requestField("call_to_action", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestCanReplyPrivatelyField () {
      return this.requestCanReplyPrivatelyField(true);
    }
    public APIRequestGetScheduledPosts requestCanReplyPrivatelyField (boolean value) {
      this.requestField("can_reply_privately", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestChildAttachmentsField () {
      return this.requestChildAttachmentsField(true);
    }
    public APIRequestGetScheduledPosts requestChildAttachmentsField (boolean value) {
      this.requestField("child_attachments", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestCommentsMirroringDomainField () {
      return this.requestCommentsMirroringDomainField(true);
    }
    public APIRequestGetScheduledPosts requestCommentsMirroringDomainField (boolean value) {
      this.requestField("comments_mirroring_domain", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestCoordinatesField () {
      return this.requestCoordinatesField(true);
    }
    public APIRequestGetScheduledPosts requestCoordinatesField (boolean value) {
      this.requestField("coordinates", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestCreatedTimeField () {
      return this.requestCreatedTimeField(true);
    }
    public APIRequestGetScheduledPosts requestCreatedTimeField (boolean value) {
      this.requestField("created_time", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestEventField () {
      return this.requestEventField(true);
    }
    public APIRequestGetScheduledPosts requestEventField (boolean value) {
      this.requestField("event", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestExpandedHeightField () {
      return this.requestExpandedHeightField(true);
    }
    public APIRequestGetScheduledPosts requestExpandedHeightField (boolean value) {
      this.requestField("expanded_height", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestExpandedWidthField () {
      return this.requestExpandedWidthField(true);
    }
    public APIRequestGetScheduledPosts requestExpandedWidthField (boolean value) {
      this.requestField("expanded_width", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestFeedTargetingField () {
      return this.requestFeedTargetingField(true);
    }
    public APIRequestGetScheduledPosts requestFeedTargetingField (boolean value) {
      this.requestField("feed_targeting", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestFromField () {
      return this.requestFromField(true);
    }
    public APIRequestGetScheduledPosts requestFromField (boolean value) {
      this.requestField("from", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestFullPictureField () {
      return this.requestFullPictureField(true);
    }
    public APIRequestGetScheduledPosts requestFullPictureField (boolean value) {
      this.requestField("full_picture", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestHeightField () {
      return this.requestHeightField(true);
    }
    public APIRequestGetScheduledPosts requestHeightField (boolean value) {
      this.requestField("height", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestIconField () {
      return this.requestIconField(true);
    }
    public APIRequestGetScheduledPosts requestIconField (boolean value) {
      this.requestField("icon", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetScheduledPosts requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestInstagramEligibilityField () {
      return this.requestInstagramEligibilityField(true);
    }
    public APIRequestGetScheduledPosts requestInstagramEligibilityField (boolean value) {
      this.requestField("instagram_eligibility", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestIsAppShareField () {
      return this.requestIsAppShareField(true);
    }
    public APIRequestGetScheduledPosts requestIsAppShareField (boolean value) {
      this.requestField("is_app_share", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestIsEligibleForPromotionField () {
      return this.requestIsEligibleForPromotionField(true);
    }
    public APIRequestGetScheduledPosts requestIsEligibleForPromotionField (boolean value) {
      this.requestField("is_eligible_for_promotion", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestIsExpiredField () {
      return this.requestIsExpiredField(true);
    }
    public APIRequestGetScheduledPosts requestIsExpiredField (boolean value) {
      this.requestField("is_expired", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestIsHiddenField () {
      return this.requestIsHiddenField(true);
    }
    public APIRequestGetScheduledPosts requestIsHiddenField (boolean value) {
      this.requestField("is_hidden", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestIsInlineCreatedField () {
      return this.requestIsInlineCreatedField(true);
    }
    public APIRequestGetScheduledPosts requestIsInlineCreatedField (boolean value) {
      this.requestField("is_inline_created", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestIsInstagramEligibleField () {
      return this.requestIsInstagramEligibleField(true);
    }
    public APIRequestGetScheduledPosts requestIsInstagramEligibleField (boolean value) {
      this.requestField("is_instagram_eligible", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestIsPopularField () {
      return this.requestIsPopularField(true);
    }
    public APIRequestGetScheduledPosts requestIsPopularField (boolean value) {
      this.requestField("is_popular", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestIsPublishedField () {
      return this.requestIsPublishedField(true);
    }
    public APIRequestGetScheduledPosts requestIsPublishedField (boolean value) {
      this.requestField("is_published", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestIsSphericalField () {
      return this.requestIsSphericalField(true);
    }
    public APIRequestGetScheduledPosts requestIsSphericalField (boolean value) {
      this.requestField("is_spherical", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestMessageField () {
      return this.requestMessageField(true);
    }
    public APIRequestGetScheduledPosts requestMessageField (boolean value) {
      this.requestField("message", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestMessageTagsField () {
      return this.requestMessageTagsField(true);
    }
    public APIRequestGetScheduledPosts requestMessageTagsField (boolean value) {
      this.requestField("message_tags", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestMultiShareEndCardField () {
      return this.requestMultiShareEndCardField(true);
    }
    public APIRequestGetScheduledPosts requestMultiShareEndCardField (boolean value) {
      this.requestField("multi_share_end_card", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestMultiShareOptimizedField () {
      return this.requestMultiShareOptimizedField(true);
    }
    public APIRequestGetScheduledPosts requestMultiShareOptimizedField (boolean value) {
      this.requestField("multi_share_optimized", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestParentIdField () {
      return this.requestParentIdField(true);
    }
    public APIRequestGetScheduledPosts requestParentIdField (boolean value) {
      this.requestField("parent_id", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestPermalinkUrlField () {
      return this.requestPermalinkUrlField(true);
    }
    public APIRequestGetScheduledPosts requestPermalinkUrlField (boolean value) {
      this.requestField("permalink_url", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestPictureField () {
      return this.requestPictureField(true);
    }
    public APIRequestGetScheduledPosts requestPictureField (boolean value) {
      this.requestField("picture", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestPlaceField () {
      return this.requestPlaceField(true);
    }
    public APIRequestGetScheduledPosts requestPlaceField (boolean value) {
      this.requestField("place", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestPrivacyField () {
      return this.requestPrivacyField(true);
    }
    public APIRequestGetScheduledPosts requestPrivacyField (boolean value) {
      this.requestField("privacy", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestPromotableIdField () {
      return this.requestPromotableIdField(true);
    }
    public APIRequestGetScheduledPosts requestPromotableIdField (boolean value) {
      this.requestField("promotable_id", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestPromotionStatusField () {
      return this.requestPromotionStatusField(true);
    }
    public APIRequestGetScheduledPosts requestPromotionStatusField (boolean value) {
      this.requestField("promotion_status", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestPropertiesField () {
      return this.requestPropertiesField(true);
    }
    public APIRequestGetScheduledPosts requestPropertiesField (boolean value) {
      this.requestField("properties", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestScheduledPublishTimeField () {
      return this.requestScheduledPublishTimeField(true);
    }
    public APIRequestGetScheduledPosts requestScheduledPublishTimeField (boolean value) {
      this.requestField("scheduled_publish_time", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestSharesField () {
      return this.requestSharesField(true);
    }
    public APIRequestGetScheduledPosts requestSharesField (boolean value) {
      this.requestField("shares", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestStatusTypeField () {
      return this.requestStatusTypeField(true);
    }
    public APIRequestGetScheduledPosts requestStatusTypeField (boolean value) {
      this.requestField("status_type", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestStoryField () {
      return this.requestStoryField(true);
    }
    public APIRequestGetScheduledPosts requestStoryField (boolean value) {
      this.requestField("story", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestStoryTagsField () {
      return this.requestStoryTagsField(true);
    }
    public APIRequestGetScheduledPosts requestStoryTagsField (boolean value) {
      this.requestField("story_tags", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestSubscribedField () {
      return this.requestSubscribedField(true);
    }
    public APIRequestGetScheduledPosts requestSubscribedField (boolean value) {
      this.requestField("subscribed", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestTargetField () {
      return this.requestTargetField(true);
    }
    public APIRequestGetScheduledPosts requestTargetField (boolean value) {
      this.requestField("target", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestTargetingField () {
      return this.requestTargetingField(true);
    }
    public APIRequestGetScheduledPosts requestTargetingField (boolean value) {
      this.requestField("targeting", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestTimelineVisibilityField () {
      return this.requestTimelineVisibilityField(true);
    }
    public APIRequestGetScheduledPosts requestTimelineVisibilityField (boolean value) {
      this.requestField("timeline_visibility", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestUpdatedTimeField () {
      return this.requestUpdatedTimeField(true);
    }
    public APIRequestGetScheduledPosts requestUpdatedTimeField (boolean value) {
      this.requestField("updated_time", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestViaField () {
      return this.requestViaField(true);
    }
    public APIRequestGetScheduledPosts requestViaField (boolean value) {
      this.requestField("via", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestVideoBuyingEligibilityField () {
      return this.requestVideoBuyingEligibilityField(true);
    }
    public APIRequestGetScheduledPosts requestVideoBuyingEligibilityField (boolean value) {
      this.requestField("video_buying_eligibility", value);
      return this;
    }
    public APIRequestGetScheduledPosts requestWidthField () {
      return this.requestWidthField(true);
    }
    public APIRequestGetScheduledPosts requestWidthField (boolean value) {
      this.requestField("width", value);
      return this;
    }
  }

  public static class APIRequestGetSecondaryReceivers extends APIRequest<Application> {

    APINodeList<Application> lastResponse = null;
    @Override
    public APINodeList<Application> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "platform",
    };

    public static final String[] FIELDS = {
      "aam_rules",
      "an_ad_space_limit",
      "an_platforms",
      "android_key_hash",
      "android_sdk_error_categories",
      "app_domains",
      "app_events_config",
      "app_events_feature_bitmask",
      "app_events_session_timeout",
      "app_install_tracked",
      "app_name",
      "app_signals_binding_ios",
      "app_type",
      "auth_dialog_data_help_url",
      "auth_dialog_headline",
      "auth_dialog_perms_explanation",
      "auth_referral_default_activity_privacy",
      "auth_referral_enabled",
      "auth_referral_extended_perms",
      "auth_referral_friend_perms",
      "auth_referral_response_type",
      "auth_referral_user_perms",
      "auto_event_mapping_android",
      "auto_event_mapping_ios",
      "auto_event_setup_enabled",
      "auto_log_app_events_default",
      "auto_log_app_events_enabled",
      "business",
      "canvas_fluid_height",
      "canvas_fluid_width",
      "canvas_url",
      "category",
      "client_config",
      "company",
      "configured_ios_sso",
      "contact_email",
      "created_time",
      "creator_uid",
      "daily_active_users",
      "daily_active_users_rank",
      "deauth_callback_url",
      "default_share_mode",
      "description",
      "enigma_config",
      "financial_id",
      "gdpv4_chrome_custom_tabs_enabled",
      "gdpv4_enabled",
      "gdpv4_nux_content",
      "gdpv4_nux_enabled",
      "has_messenger_product",
      "hosting_url",
      "icon_url",
      "id",
      "ios_bundle_id",
      "ios_sdk_dialog_flows",
      "ios_sdk_error_categories",
      "ios_sfvc_attr",
      "ios_supports_native_proxy_auth_flow",
      "ios_supports_system_auth",
      "ipad_app_store_id",
      "iphone_app_store_id",
      "latest_sdk_version",
      "link",
      "logging_token",
      "logo_url",
      "migrations",
      "mobile_profile_section_url",
      "mobile_web_url",
      "monthly_active_users",
      "monthly_active_users_rank",
      "name",
      "namespace",
      "object_store_urls",
      "owner_business",
      "page_tab_default_name",
      "page_tab_url",
      "photo_url",
      "privacy_policy_url",
      "profile_section_url",
      "property_id",
      "protected_mode_rules",
      "real_time_mode_devices",
      "restrictions",
      "restrictive_data_filter_params",
      "restrictive_data_filter_rules",
      "sdk_update_message",
      "seamless_login",
      "secure_canvas_url",
      "secure_page_tab_url",
      "server_ip_whitelist",
      "smart_login_bookmark_icon_url",
      "smart_login_menu_icon_url",
      "social_discovery",
      "subcategory",
      "suggested_events_setting",
      "supported_platforms",
      "supports_apprequests_fast_app_switch",
      "supports_attribution",
      "supports_implicit_sdk_logging",
      "suppress_native_ios_gdp",
      "terms_of_service_url",
      "url_scheme_suffix",
      "user_support_email",
      "user_support_url",
      "website_url",
      "weekly_active_users",
    };

    @Override
    public APINodeList<Application> parseResponse(String response, String header) throws APIException {
      return Application.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<Application> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Application> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Application>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Application>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<Application>>() {
           public APINodeList<Application> apply(ResponseWrapper result) {
             try {
               return APIRequestGetSecondaryReceivers.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetSecondaryReceivers(String nodeId, APIContext context) {
      super(context, nodeId, "/secondary_receivers", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetSecondaryReceivers setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetSecondaryReceivers setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetSecondaryReceivers setPlatform (Application.EnumPlatform platform) {
      this.setParam("platform", platform);
      return this;
    }
    public APIRequestGetSecondaryReceivers setPlatform (String platform) {
      this.setParam("platform", platform);
      return this;
    }

    public APIRequestGetSecondaryReceivers requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetSecondaryReceivers requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetSecondaryReceivers requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetSecondaryReceivers requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetSecondaryReceivers requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetSecondaryReceivers requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetSecondaryReceivers requestAamRulesField () {
      return this.requestAamRulesField(true);
    }
    public APIRequestGetSecondaryReceivers requestAamRulesField (boolean value) {
      this.requestField("aam_rules", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestAnAdSpaceLimitField () {
      return this.requestAnAdSpaceLimitField(true);
    }
    public APIRequestGetSecondaryReceivers requestAnAdSpaceLimitField (boolean value) {
      this.requestField("an_ad_space_limit", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestAnPlatformsField () {
      return this.requestAnPlatformsField(true);
    }
    public APIRequestGetSecondaryReceivers requestAnPlatformsField (boolean value) {
      this.requestField("an_platforms", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestAndroidKeyHashField () {
      return this.requestAndroidKeyHashField(true);
    }
    public APIRequestGetSecondaryReceivers requestAndroidKeyHashField (boolean value) {
      this.requestField("android_key_hash", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestAndroidSdkErrorCategoriesField () {
      return this.requestAndroidSdkErrorCategoriesField(true);
    }
    public APIRequestGetSecondaryReceivers requestAndroidSdkErrorCategoriesField (boolean value) {
      this.requestField("android_sdk_error_categories", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestAppDomainsField () {
      return this.requestAppDomainsField(true);
    }
    public APIRequestGetSecondaryReceivers requestAppDomainsField (boolean value) {
      this.requestField("app_domains", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestAppEventsConfigField () {
      return this.requestAppEventsConfigField(true);
    }
    public APIRequestGetSecondaryReceivers requestAppEventsConfigField (boolean value) {
      this.requestField("app_events_config", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestAppEventsFeatureBitmaskField () {
      return this.requestAppEventsFeatureBitmaskField(true);
    }
    public APIRequestGetSecondaryReceivers requestAppEventsFeatureBitmaskField (boolean value) {
      this.requestField("app_events_feature_bitmask", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestAppEventsSessionTimeoutField () {
      return this.requestAppEventsSessionTimeoutField(true);
    }
    public APIRequestGetSecondaryReceivers requestAppEventsSessionTimeoutField (boolean value) {
      this.requestField("app_events_session_timeout", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestAppInstallTrackedField () {
      return this.requestAppInstallTrackedField(true);
    }
    public APIRequestGetSecondaryReceivers requestAppInstallTrackedField (boolean value) {
      this.requestField("app_install_tracked", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestAppNameField () {
      return this.requestAppNameField(true);
    }
    public APIRequestGetSecondaryReceivers requestAppNameField (boolean value) {
      this.requestField("app_name", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestAppSignalsBindingIosField () {
      return this.requestAppSignalsBindingIosField(true);
    }
    public APIRequestGetSecondaryReceivers requestAppSignalsBindingIosField (boolean value) {
      this.requestField("app_signals_binding_ios", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestAppTypeField () {
      return this.requestAppTypeField(true);
    }
    public APIRequestGetSecondaryReceivers requestAppTypeField (boolean value) {
      this.requestField("app_type", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestAuthDialogDataHelpUrlField () {
      return this.requestAuthDialogDataHelpUrlField(true);
    }
    public APIRequestGetSecondaryReceivers requestAuthDialogDataHelpUrlField (boolean value) {
      this.requestField("auth_dialog_data_help_url", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestAuthDialogHeadlineField () {
      return this.requestAuthDialogHeadlineField(true);
    }
    public APIRequestGetSecondaryReceivers requestAuthDialogHeadlineField (boolean value) {
      this.requestField("auth_dialog_headline", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestAuthDialogPermsExplanationField () {
      return this.requestAuthDialogPermsExplanationField(true);
    }
    public APIRequestGetSecondaryReceivers requestAuthDialogPermsExplanationField (boolean value) {
      this.requestField("auth_dialog_perms_explanation", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestAuthReferralDefaultActivityPrivacyField () {
      return this.requestAuthReferralDefaultActivityPrivacyField(true);
    }
    public APIRequestGetSecondaryReceivers requestAuthReferralDefaultActivityPrivacyField (boolean value) {
      this.requestField("auth_referral_default_activity_privacy", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestAuthReferralEnabledField () {
      return this.requestAuthReferralEnabledField(true);
    }
    public APIRequestGetSecondaryReceivers requestAuthReferralEnabledField (boolean value) {
      this.requestField("auth_referral_enabled", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestAuthReferralExtendedPermsField () {
      return this.requestAuthReferralExtendedPermsField(true);
    }
    public APIRequestGetSecondaryReceivers requestAuthReferralExtendedPermsField (boolean value) {
      this.requestField("auth_referral_extended_perms", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestAuthReferralFriendPermsField () {
      return this.requestAuthReferralFriendPermsField(true);
    }
    public APIRequestGetSecondaryReceivers requestAuthReferralFriendPermsField (boolean value) {
      this.requestField("auth_referral_friend_perms", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestAuthReferralResponseTypeField () {
      return this.requestAuthReferralResponseTypeField(true);
    }
    public APIRequestGetSecondaryReceivers requestAuthReferralResponseTypeField (boolean value) {
      this.requestField("auth_referral_response_type", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestAuthReferralUserPermsField () {
      return this.requestAuthReferralUserPermsField(true);
    }
    public APIRequestGetSecondaryReceivers requestAuthReferralUserPermsField (boolean value) {
      this.requestField("auth_referral_user_perms", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestAutoEventMappingAndroidField () {
      return this.requestAutoEventMappingAndroidField(true);
    }
    public APIRequestGetSecondaryReceivers requestAutoEventMappingAndroidField (boolean value) {
      this.requestField("auto_event_mapping_android", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestAutoEventMappingIosField () {
      return this.requestAutoEventMappingIosField(true);
    }
    public APIRequestGetSecondaryReceivers requestAutoEventMappingIosField (boolean value) {
      this.requestField("auto_event_mapping_ios", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestAutoEventSetupEnabledField () {
      return this.requestAutoEventSetupEnabledField(true);
    }
    public APIRequestGetSecondaryReceivers requestAutoEventSetupEnabledField (boolean value) {
      this.requestField("auto_event_setup_enabled", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestAutoLogAppEventsDefaultField () {
      return this.requestAutoLogAppEventsDefaultField(true);
    }
    public APIRequestGetSecondaryReceivers requestAutoLogAppEventsDefaultField (boolean value) {
      this.requestField("auto_log_app_events_default", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestAutoLogAppEventsEnabledField () {
      return this.requestAutoLogAppEventsEnabledField(true);
    }
    public APIRequestGetSecondaryReceivers requestAutoLogAppEventsEnabledField (boolean value) {
      this.requestField("auto_log_app_events_enabled", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestBusinessField () {
      return this.requestBusinessField(true);
    }
    public APIRequestGetSecondaryReceivers requestBusinessField (boolean value) {
      this.requestField("business", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestCanvasFluidHeightField () {
      return this.requestCanvasFluidHeightField(true);
    }
    public APIRequestGetSecondaryReceivers requestCanvasFluidHeightField (boolean value) {
      this.requestField("canvas_fluid_height", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestCanvasFluidWidthField () {
      return this.requestCanvasFluidWidthField(true);
    }
    public APIRequestGetSecondaryReceivers requestCanvasFluidWidthField (boolean value) {
      this.requestField("canvas_fluid_width", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestCanvasUrlField () {
      return this.requestCanvasUrlField(true);
    }
    public APIRequestGetSecondaryReceivers requestCanvasUrlField (boolean value) {
      this.requestField("canvas_url", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestCategoryField () {
      return this.requestCategoryField(true);
    }
    public APIRequestGetSecondaryReceivers requestCategoryField (boolean value) {
      this.requestField("category", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestClientConfigField () {
      return this.requestClientConfigField(true);
    }
    public APIRequestGetSecondaryReceivers requestClientConfigField (boolean value) {
      this.requestField("client_config", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestCompanyField () {
      return this.requestCompanyField(true);
    }
    public APIRequestGetSecondaryReceivers requestCompanyField (boolean value) {
      this.requestField("company", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestConfiguredIosSsoField () {
      return this.requestConfiguredIosSsoField(true);
    }
    public APIRequestGetSecondaryReceivers requestConfiguredIosSsoField (boolean value) {
      this.requestField("configured_ios_sso", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestContactEmailField () {
      return this.requestContactEmailField(true);
    }
    public APIRequestGetSecondaryReceivers requestContactEmailField (boolean value) {
      this.requestField("contact_email", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestCreatedTimeField () {
      return this.requestCreatedTimeField(true);
    }
    public APIRequestGetSecondaryReceivers requestCreatedTimeField (boolean value) {
      this.requestField("created_time", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestCreatorUidField () {
      return this.requestCreatorUidField(true);
    }
    public APIRequestGetSecondaryReceivers requestCreatorUidField (boolean value) {
      this.requestField("creator_uid", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestDailyActiveUsersField () {
      return this.requestDailyActiveUsersField(true);
    }
    public APIRequestGetSecondaryReceivers requestDailyActiveUsersField (boolean value) {
      this.requestField("daily_active_users", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestDailyActiveUsersRankField () {
      return this.requestDailyActiveUsersRankField(true);
    }
    public APIRequestGetSecondaryReceivers requestDailyActiveUsersRankField (boolean value) {
      this.requestField("daily_active_users_rank", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestDeauthCallbackUrlField () {
      return this.requestDeauthCallbackUrlField(true);
    }
    public APIRequestGetSecondaryReceivers requestDeauthCallbackUrlField (boolean value) {
      this.requestField("deauth_callback_url", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestDefaultShareModeField () {
      return this.requestDefaultShareModeField(true);
    }
    public APIRequestGetSecondaryReceivers requestDefaultShareModeField (boolean value) {
      this.requestField("default_share_mode", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetSecondaryReceivers requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestEnigmaConfigField () {
      return this.requestEnigmaConfigField(true);
    }
    public APIRequestGetSecondaryReceivers requestEnigmaConfigField (boolean value) {
      this.requestField("enigma_config", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestFinancialIdField () {
      return this.requestFinancialIdField(true);
    }
    public APIRequestGetSecondaryReceivers requestFinancialIdField (boolean value) {
      this.requestField("financial_id", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestGdpv4ChromeCustomTabsEnabledField () {
      return this.requestGdpv4ChromeCustomTabsEnabledField(true);
    }
    public APIRequestGetSecondaryReceivers requestGdpv4ChromeCustomTabsEnabledField (boolean value) {
      this.requestField("gdpv4_chrome_custom_tabs_enabled", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestGdpv4EnabledField () {
      return this.requestGdpv4EnabledField(true);
    }
    public APIRequestGetSecondaryReceivers requestGdpv4EnabledField (boolean value) {
      this.requestField("gdpv4_enabled", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestGdpv4NuxContentField () {
      return this.requestGdpv4NuxContentField(true);
    }
    public APIRequestGetSecondaryReceivers requestGdpv4NuxContentField (boolean value) {
      this.requestField("gdpv4_nux_content", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestGdpv4NuxEnabledField () {
      return this.requestGdpv4NuxEnabledField(true);
    }
    public APIRequestGetSecondaryReceivers requestGdpv4NuxEnabledField (boolean value) {
      this.requestField("gdpv4_nux_enabled", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestHasMessengerProductField () {
      return this.requestHasMessengerProductField(true);
    }
    public APIRequestGetSecondaryReceivers requestHasMessengerProductField (boolean value) {
      this.requestField("has_messenger_product", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestHostingUrlField () {
      return this.requestHostingUrlField(true);
    }
    public APIRequestGetSecondaryReceivers requestHostingUrlField (boolean value) {
      this.requestField("hosting_url", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestIconUrlField () {
      return this.requestIconUrlField(true);
    }
    public APIRequestGetSecondaryReceivers requestIconUrlField (boolean value) {
      this.requestField("icon_url", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetSecondaryReceivers requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestIosBundleIdField () {
      return this.requestIosBundleIdField(true);
    }
    public APIRequestGetSecondaryReceivers requestIosBundleIdField (boolean value) {
      this.requestField("ios_bundle_id", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestIosSdkDialogFlowsField () {
      return this.requestIosSdkDialogFlowsField(true);
    }
    public APIRequestGetSecondaryReceivers requestIosSdkDialogFlowsField (boolean value) {
      this.requestField("ios_sdk_dialog_flows", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestIosSdkErrorCategoriesField () {
      return this.requestIosSdkErrorCategoriesField(true);
    }
    public APIRequestGetSecondaryReceivers requestIosSdkErrorCategoriesField (boolean value) {
      this.requestField("ios_sdk_error_categories", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestIosSfvcAttrField () {
      return this.requestIosSfvcAttrField(true);
    }
    public APIRequestGetSecondaryReceivers requestIosSfvcAttrField (boolean value) {
      this.requestField("ios_sfvc_attr", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestIosSupportsNativeProxyAuthFlowField () {
      return this.requestIosSupportsNativeProxyAuthFlowField(true);
    }
    public APIRequestGetSecondaryReceivers requestIosSupportsNativeProxyAuthFlowField (boolean value) {
      this.requestField("ios_supports_native_proxy_auth_flow", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestIosSupportsSystemAuthField () {
      return this.requestIosSupportsSystemAuthField(true);
    }
    public APIRequestGetSecondaryReceivers requestIosSupportsSystemAuthField (boolean value) {
      this.requestField("ios_supports_system_auth", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestIpadAppStoreIdField () {
      return this.requestIpadAppStoreIdField(true);
    }
    public APIRequestGetSecondaryReceivers requestIpadAppStoreIdField (boolean value) {
      this.requestField("ipad_app_store_id", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestIphoneAppStoreIdField () {
      return this.requestIphoneAppStoreIdField(true);
    }
    public APIRequestGetSecondaryReceivers requestIphoneAppStoreIdField (boolean value) {
      this.requestField("iphone_app_store_id", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestLatestSdkVersionField () {
      return this.requestLatestSdkVersionField(true);
    }
    public APIRequestGetSecondaryReceivers requestLatestSdkVersionField (boolean value) {
      this.requestField("latest_sdk_version", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestLinkField () {
      return this.requestLinkField(true);
    }
    public APIRequestGetSecondaryReceivers requestLinkField (boolean value) {
      this.requestField("link", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestLoggingTokenField () {
      return this.requestLoggingTokenField(true);
    }
    public APIRequestGetSecondaryReceivers requestLoggingTokenField (boolean value) {
      this.requestField("logging_token", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestLogoUrlField () {
      return this.requestLogoUrlField(true);
    }
    public APIRequestGetSecondaryReceivers requestLogoUrlField (boolean value) {
      this.requestField("logo_url", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestMigrationsField () {
      return this.requestMigrationsField(true);
    }
    public APIRequestGetSecondaryReceivers requestMigrationsField (boolean value) {
      this.requestField("migrations", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestMobileProfileSectionUrlField () {
      return this.requestMobileProfileSectionUrlField(true);
    }
    public APIRequestGetSecondaryReceivers requestMobileProfileSectionUrlField (boolean value) {
      this.requestField("mobile_profile_section_url", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestMobileWebUrlField () {
      return this.requestMobileWebUrlField(true);
    }
    public APIRequestGetSecondaryReceivers requestMobileWebUrlField (boolean value) {
      this.requestField("mobile_web_url", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestMonthlyActiveUsersField () {
      return this.requestMonthlyActiveUsersField(true);
    }
    public APIRequestGetSecondaryReceivers requestMonthlyActiveUsersField (boolean value) {
      this.requestField("monthly_active_users", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestMonthlyActiveUsersRankField () {
      return this.requestMonthlyActiveUsersRankField(true);
    }
    public APIRequestGetSecondaryReceivers requestMonthlyActiveUsersRankField (boolean value) {
      this.requestField("monthly_active_users_rank", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetSecondaryReceivers requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestNamespaceField () {
      return this.requestNamespaceField(true);
    }
    public APIRequestGetSecondaryReceivers requestNamespaceField (boolean value) {
      this.requestField("namespace", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestObjectStoreUrlsField () {
      return this.requestObjectStoreUrlsField(true);
    }
    public APIRequestGetSecondaryReceivers requestObjectStoreUrlsField (boolean value) {
      this.requestField("object_store_urls", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestOwnerBusinessField () {
      return this.requestOwnerBusinessField(true);
    }
    public APIRequestGetSecondaryReceivers requestOwnerBusinessField (boolean value) {
      this.requestField("owner_business", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestPageTabDefaultNameField () {
      return this.requestPageTabDefaultNameField(true);
    }
    public APIRequestGetSecondaryReceivers requestPageTabDefaultNameField (boolean value) {
      this.requestField("page_tab_default_name", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestPageTabUrlField () {
      return this.requestPageTabUrlField(true);
    }
    public APIRequestGetSecondaryReceivers requestPageTabUrlField (boolean value) {
      this.requestField("page_tab_url", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestPhotoUrlField () {
      return this.requestPhotoUrlField(true);
    }
    public APIRequestGetSecondaryReceivers requestPhotoUrlField (boolean value) {
      this.requestField("photo_url", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestPrivacyPolicyUrlField () {
      return this.requestPrivacyPolicyUrlField(true);
    }
    public APIRequestGetSecondaryReceivers requestPrivacyPolicyUrlField (boolean value) {
      this.requestField("privacy_policy_url", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestProfileSectionUrlField () {
      return this.requestProfileSectionUrlField(true);
    }
    public APIRequestGetSecondaryReceivers requestProfileSectionUrlField (boolean value) {
      this.requestField("profile_section_url", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestPropertyIdField () {
      return this.requestPropertyIdField(true);
    }
    public APIRequestGetSecondaryReceivers requestPropertyIdField (boolean value) {
      this.requestField("property_id", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestProtectedModeRulesField () {
      return this.requestProtectedModeRulesField(true);
    }
    public APIRequestGetSecondaryReceivers requestProtectedModeRulesField (boolean value) {
      this.requestField("protected_mode_rules", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestRealTimeModeDevicesField () {
      return this.requestRealTimeModeDevicesField(true);
    }
    public APIRequestGetSecondaryReceivers requestRealTimeModeDevicesField (boolean value) {
      this.requestField("real_time_mode_devices", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestRestrictionsField () {
      return this.requestRestrictionsField(true);
    }
    public APIRequestGetSecondaryReceivers requestRestrictionsField (boolean value) {
      this.requestField("restrictions", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestRestrictiveDataFilterParamsField () {
      return this.requestRestrictiveDataFilterParamsField(true);
    }
    public APIRequestGetSecondaryReceivers requestRestrictiveDataFilterParamsField (boolean value) {
      this.requestField("restrictive_data_filter_params", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestRestrictiveDataFilterRulesField () {
      return this.requestRestrictiveDataFilterRulesField(true);
    }
    public APIRequestGetSecondaryReceivers requestRestrictiveDataFilterRulesField (boolean value) {
      this.requestField("restrictive_data_filter_rules", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestSdkUpdateMessageField () {
      return this.requestSdkUpdateMessageField(true);
    }
    public APIRequestGetSecondaryReceivers requestSdkUpdateMessageField (boolean value) {
      this.requestField("sdk_update_message", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestSeamlessLoginField () {
      return this.requestSeamlessLoginField(true);
    }
    public APIRequestGetSecondaryReceivers requestSeamlessLoginField (boolean value) {
      this.requestField("seamless_login", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestSecureCanvasUrlField () {
      return this.requestSecureCanvasUrlField(true);
    }
    public APIRequestGetSecondaryReceivers requestSecureCanvasUrlField (boolean value) {
      this.requestField("secure_canvas_url", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestSecurePageTabUrlField () {
      return this.requestSecurePageTabUrlField(true);
    }
    public APIRequestGetSecondaryReceivers requestSecurePageTabUrlField (boolean value) {
      this.requestField("secure_page_tab_url", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestServerIpWhitelistField () {
      return this.requestServerIpWhitelistField(true);
    }
    public APIRequestGetSecondaryReceivers requestServerIpWhitelistField (boolean value) {
      this.requestField("server_ip_whitelist", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestSmartLoginBookmarkIconUrlField () {
      return this.requestSmartLoginBookmarkIconUrlField(true);
    }
    public APIRequestGetSecondaryReceivers requestSmartLoginBookmarkIconUrlField (boolean value) {
      this.requestField("smart_login_bookmark_icon_url", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestSmartLoginMenuIconUrlField () {
      return this.requestSmartLoginMenuIconUrlField(true);
    }
    public APIRequestGetSecondaryReceivers requestSmartLoginMenuIconUrlField (boolean value) {
      this.requestField("smart_login_menu_icon_url", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestSocialDiscoveryField () {
      return this.requestSocialDiscoveryField(true);
    }
    public APIRequestGetSecondaryReceivers requestSocialDiscoveryField (boolean value) {
      this.requestField("social_discovery", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestSubcategoryField () {
      return this.requestSubcategoryField(true);
    }
    public APIRequestGetSecondaryReceivers requestSubcategoryField (boolean value) {
      this.requestField("subcategory", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestSuggestedEventsSettingField () {
      return this.requestSuggestedEventsSettingField(true);
    }
    public APIRequestGetSecondaryReceivers requestSuggestedEventsSettingField (boolean value) {
      this.requestField("suggested_events_setting", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestSupportedPlatformsField () {
      return this.requestSupportedPlatformsField(true);
    }
    public APIRequestGetSecondaryReceivers requestSupportedPlatformsField (boolean value) {
      this.requestField("supported_platforms", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestSupportsApprequestsFastAppSwitchField () {
      return this.requestSupportsApprequestsFastAppSwitchField(true);
    }
    public APIRequestGetSecondaryReceivers requestSupportsApprequestsFastAppSwitchField (boolean value) {
      this.requestField("supports_apprequests_fast_app_switch", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestSupportsAttributionField () {
      return this.requestSupportsAttributionField(true);
    }
    public APIRequestGetSecondaryReceivers requestSupportsAttributionField (boolean value) {
      this.requestField("supports_attribution", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestSupportsImplicitSdkLoggingField () {
      return this.requestSupportsImplicitSdkLoggingField(true);
    }
    public APIRequestGetSecondaryReceivers requestSupportsImplicitSdkLoggingField (boolean value) {
      this.requestField("supports_implicit_sdk_logging", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestSuppressNativeIosGdpField () {
      return this.requestSuppressNativeIosGdpField(true);
    }
    public APIRequestGetSecondaryReceivers requestSuppressNativeIosGdpField (boolean value) {
      this.requestField("suppress_native_ios_gdp", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestTermsOfServiceUrlField () {
      return this.requestTermsOfServiceUrlField(true);
    }
    public APIRequestGetSecondaryReceivers requestTermsOfServiceUrlField (boolean value) {
      this.requestField("terms_of_service_url", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestUrlSchemeSuffixField () {
      return this.requestUrlSchemeSuffixField(true);
    }
    public APIRequestGetSecondaryReceivers requestUrlSchemeSuffixField (boolean value) {
      this.requestField("url_scheme_suffix", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestUserSupportEmailField () {
      return this.requestUserSupportEmailField(true);
    }
    public APIRequestGetSecondaryReceivers requestUserSupportEmailField (boolean value) {
      this.requestField("user_support_email", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestUserSupportUrlField () {
      return this.requestUserSupportUrlField(true);
    }
    public APIRequestGetSecondaryReceivers requestUserSupportUrlField (boolean value) {
      this.requestField("user_support_url", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestWebsiteUrlField () {
      return this.requestWebsiteUrlField(true);
    }
    public APIRequestGetSecondaryReceivers requestWebsiteUrlField (boolean value) {
      this.requestField("website_url", value);
      return this;
    }
    public APIRequestGetSecondaryReceivers requestWeeklyActiveUsersField () {
      return this.requestWeeklyActiveUsersField(true);
    }
    public APIRequestGetSecondaryReceivers requestWeeklyActiveUsersField (boolean value) {
      this.requestField("weekly_active_users", value);
      return this;
    }
  }

  public static class APIRequestGetSettings extends APIRequest<PageSettings> {

    APINodeList<PageSettings> lastResponse = null;
    @Override
    public APINodeList<PageSettings> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "setting",
      "value",
    };

    @Override
    public APINodeList<PageSettings> parseResponse(String response, String header) throws APIException {
      return PageSettings.parseResponse(response, getContext(), this, header);
    }

    @Override
    public APINodeList<PageSettings> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<PageSettings> execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(),rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<APINodeList<PageSettings>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<PageSettings>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, APINodeList<PageSettings>>() {
           public APINodeList<PageSettings> apply(ResponseWrapper result) {
             try {
               return APIRequestGetSettings.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestGetSettings(String nodeId, APIContext context) {
      super(context, nodeId, "/settings", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetSettings setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetSettings setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetSettings requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetSettings requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetSettings requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetSettings requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetSettings requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetSettings requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetSettings requestSettingField () {
      return this.requestSettingField(true);
    }
    public APIRequestGetSettings requestSettingField (boolean value) {
      this.requestField("setting", value);
      return this;
    }
    public APIRequestGetSettings requestValueField () {
      return this.requestValueField(true);
    }
    public APIRequestGetSettings requestValueField (boolean value) {
      this.requestField("value", value);
      return this;
    }
  }

  public static class APIRequestCreateSetting extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "option",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response, String header) throws APIException {
      return Page.parseResponse(response, getContext(), this, header).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      ResponseWrapper rw = executeInternal(extraParams);
      lastResponse = parseResponse(rw.getBody(), rw.getHeader());
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<ResponseWrapper, Page>() {
           public Page apply(ResponseWrapper result) {
             try {
               return APIRequestCreateSetting.this.parseResponse(result.getBody(), result.getHeader());
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         },
         MoreExecutors.directExecutor()
      );
    };

    public APIRequestCreateSetting(String nodeId, APIContext context) {
      super(context, nodeId, "/settings", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateSetting setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateSetting setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateSetting setOption (Object option) {
      this.setParam("option", option);
      return this;
    }
    public APIRequestCreateSetting setOption (String option) {
      this.setParam("option", option);
      return this;
    }

    public APIRequestCreateSetting requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateSetting requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateSetting requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateSetting requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateSetting requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateSetting requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetShopSetupStatus extends APIRequest<CommerceMerchantSettingsSetupStatus> {

    APINodeList<CommerceMerchantSettingsSetupStatus> lastResponse = null;
    @Override
    public APINodeList<CommerceMerchantSettingsSetupStatus> getLastResponse() {
      return las