/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class AdCreativeRewardInfo
extends APINode {
    @SerializedName(value="reward_offer_id")
    private String mRewardOfferId = null;
    @SerializedName(value="reward_program_id")
    private String mRewardProgramId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdCreativeRewardInfo loadJSON(String json, APIContext context, String header) {
        AdCreativeRewardInfo adCreativeRewardInfo = (AdCreativeRewardInfo)AdCreativeRewardInfo.getGson().fromJson(json, AdCreativeRewardInfo.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCreativeRewardInfo.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCreativeRewardInfo.context = context;
        adCreativeRewardInfo.rawValue = json;
        adCreativeRewardInfo.header = header;
        return adCreativeRewardInfo;
    }

    public static APINodeList<AdCreativeRewardInfo> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCreativeRewardInfo> adCreativeRewardInfos = new APINodeList<AdCreativeRewardInfo>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCreativeRewardInfos.add(AdCreativeRewardInfo.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adCreativeRewardInfos;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCreativeRewardInfos.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCreativeRewardInfos.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCreativeRewardInfos.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCreativeRewardInfos.add(AdCreativeRewardInfo.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCreativeRewardInfos.add(AdCreativeRewardInfo.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCreativeRewardInfos.add(AdCreativeRewardInfo.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adCreativeRewardInfos;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCreativeRewardInfos.add(AdCreativeRewardInfo.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adCreativeRewardInfos;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCreativeRewardInfos.add(AdCreativeRewardInfo.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCreativeRewardInfos;
                }
                adCreativeRewardInfos.clear();
                adCreativeRewardInfos.add(AdCreativeRewardInfo.loadJSON(json, context, header));
                return adCreativeRewardInfos;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCreativeRewardInfo.getGson().toJson((Object)this);
    }

    public String getFieldRewardOfferId() {
        return this.mRewardOfferId;
    }

    public AdCreativeRewardInfo setFieldRewardOfferId(String value) {
        this.mRewardOfferId = value;
        return this;
    }

    public String getFieldRewardProgramId() {
        return this.mRewardProgramId;
    }

    public AdCreativeRewardInfo setFieldRewardProgramId(String value) {
        this.mRewardProgramId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCreativeRewardInfo copyFrom(AdCreativeRewardInfo instance) {
        this.mRewardOfferId = instance.mRewardOfferId;
        this.mRewardProgramId = instance.mRewardProgramId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCreativeRewardInfo> getParser() {
        return new APIRequest.ResponseParser<AdCreativeRewardInfo>(){

            @Override
            public APINodeList<AdCreativeRewardInfo> parseResponse(String response, APIContext context, APIRequest<AdCreativeRewardInfo> request, String header) throws APIException.MalformedResponseException {
                return AdCreativeRewardInfo.parseResponse(response, context, request, header);
            }
        };
    }
}

