/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAccount;
import com.facebook.ads.sdk.AdKeywords;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class AdSavedKeywords
extends APINode {
    @SerializedName(value="account")
    private AdAccount mAccount = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="keywords")
    private AdKeywords mKeywords = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="run_status")
    private String mRunStatus = null;
    @SerializedName(value="time_created")
    private String mTimeCreated = null;
    @SerializedName(value="time_updated")
    private String mTimeUpdated = null;
    protected static Gson gson = null;

    AdSavedKeywords() {
    }

    public AdSavedKeywords(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdSavedKeywords(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdSavedKeywords fetch() throws APIException {
        AdSavedKeywords newInstance = AdSavedKeywords.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdSavedKeywords fetchById(Long id, APIContext context) throws APIException {
        return AdSavedKeywords.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdSavedKeywords> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdSavedKeywords.fetchByIdAsync(id.toString(), context);
    }

    public static AdSavedKeywords fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdSavedKeywords> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdSavedKeywords> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdSavedKeywords>(context, "", "/", "GET", AdSavedKeywords.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdSavedKeywords>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdSavedKeywords>(context, "", "/", "GET", AdSavedKeywords.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdSavedKeywords loadJSON(String json, APIContext context, String header) {
        AdSavedKeywords adSavedKeywords = (AdSavedKeywords)AdSavedKeywords.getGson().fromJson(json, AdSavedKeywords.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adSavedKeywords.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adSavedKeywords.context = context;
        adSavedKeywords.rawValue = json;
        adSavedKeywords.header = header;
        return adSavedKeywords;
    }

    public static APINodeList<AdSavedKeywords> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdSavedKeywords> adSavedKeywordss = new APINodeList<AdSavedKeywords>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adSavedKeywordss.add(AdSavedKeywords.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adSavedKeywordss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adSavedKeywordss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adSavedKeywordss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adSavedKeywordss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adSavedKeywordss.add(AdSavedKeywords.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adSavedKeywordss.add(AdSavedKeywords.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adSavedKeywordss.add(AdSavedKeywords.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adSavedKeywordss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adSavedKeywordss.add(AdSavedKeywords.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adSavedKeywordss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adSavedKeywordss.add(AdSavedKeywords.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adSavedKeywordss;
                }
                adSavedKeywordss.clear();
                adSavedKeywordss.add(AdSavedKeywords.loadJSON(json, context, header));
                return adSavedKeywordss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdSavedKeywords.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public AdAccount getFieldAccount() {
        if (this.mAccount != null) {
            this.mAccount.context = this.getContext();
        }
        return this.mAccount;
    }

    public String getFieldId() {
        return this.mId;
    }

    public AdKeywords getFieldKeywords() {
        return this.mKeywords;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldRunStatus() {
        return this.mRunStatus;
    }

    public String getFieldTimeCreated() {
        return this.mTimeCreated;
    }

    public String getFieldTimeUpdated() {
        return this.mTimeUpdated;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdSavedKeywords copyFrom(AdSavedKeywords instance) {
        this.mAccount = instance.mAccount;
        this.mId = instance.mId;
        this.mKeywords = instance.mKeywords;
        this.mName = instance.mName;
        this.mRunStatus = instance.mRunStatus;
        this.mTimeCreated = instance.mTimeCreated;
        this.mTimeUpdated = instance.mTimeUpdated;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdSavedKeywords> getParser() {
        return new APIRequest.ResponseParser<AdSavedKeywords>(){

            @Override
            public APINodeList<AdSavedKeywords> parseResponse(String response, APIContext context, APIRequest<AdSavedKeywords> request, String header) throws APIException.MalformedResponseException {
                return AdSavedKeywords.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<AdSavedKeywords> {
        AdSavedKeywords lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account", "id", "keywords", "name", "run_status", "time_created", "time_updated"};

        @Override
        public AdSavedKeywords getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdSavedKeywords parseResponse(String response, String header) throws APIException {
            return AdSavedKeywords.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdSavedKeywords execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdSavedKeywords execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdSavedKeywords> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdSavedKeywords> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdSavedKeywords>(){

                public AdSavedKeywords apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAccountField() {
            return this.requestAccountField(true);
        }

        public APIRequestGet requestAccountField(boolean value) {
            this.requestField("account", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestKeywordsField() {
            return this.requestKeywordsField(true);
        }

        public APIRequestGet requestKeywordsField(boolean value) {
            this.requestField("keywords", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestRunStatusField() {
            return this.requestRunStatusField(true);
        }

        public APIRequestGet requestRunStatusField(boolean value) {
            this.requestField("run_status", value);
            return this;
        }

        public APIRequestGet requestTimeCreatedField() {
            return this.requestTimeCreatedField(true);
        }

        public APIRequestGet requestTimeCreatedField(boolean value) {
            this.requestField("time_created", value);
            return this;
        }

        public APIRequestGet requestTimeUpdatedField() {
            return this.requestTimeUpdatedField(true);
        }

        public APIRequestGet requestTimeUpdatedField(boolean value) {
            this.requestField("time_updated", value);
            return this;
        }
    }
}

