/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class BCPCampaign
extends APINode {
    @SerializedName(value="ads_permission_required")
    private Boolean mAdsPermissionRequired = null;
    @SerializedName(value="application_deadline")
    private String mApplicationDeadline = null;
    @SerializedName(value="campaign_goal")
    private String mCampaignGoal = null;
    @SerializedName(value="campaign_goal_other")
    private String mCampaignGoalOther = null;
    @SerializedName(value="content_delivery_deadline")
    private String mContentDeliveryDeadline = null;
    @SerializedName(value="content_delivery_start_date")
    private String mContentDeliveryStartDate = null;
    @SerializedName(value="content_requirements")
    private List<Map<String, Long>> mContentRequirements = null;
    @SerializedName(value="content_requirements_description")
    private String mContentRequirementsDescription = null;
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="deal_negotiation_type")
    private String mDealNegotiationType = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="has_free_product")
    private Boolean mHasFreeProduct = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="payment_amount_for_ads")
    private Long mPaymentAmountForAds = null;
    @SerializedName(value="payment_amount_for_content")
    private Long mPaymentAmountForContent = null;
    @SerializedName(value="payment_description")
    private String mPaymentDescription = null;
    protected static Gson gson = null;

    BCPCampaign() {
    }

    public BCPCampaign(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public BCPCampaign(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public BCPCampaign fetch() throws APIException {
        BCPCampaign newInstance = BCPCampaign.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static BCPCampaign fetchById(Long id, APIContext context) throws APIException {
        return BCPCampaign.fetchById(id.toString(), context);
    }

    public static ListenableFuture<BCPCampaign> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return BCPCampaign.fetchByIdAsync(id.toString(), context);
    }

    public static BCPCampaign fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<BCPCampaign> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<BCPCampaign> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<BCPCampaign>(context, "", "/", "GET", BCPCampaign.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<BCPCampaign>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<BCPCampaign>(context, "", "/", "GET", BCPCampaign.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static BCPCampaign loadJSON(String json, APIContext context, String header) {
        BCPCampaign bcpCampaign = (BCPCampaign)BCPCampaign.getGson().fromJson(json, BCPCampaign.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(bcpCampaign.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        bcpCampaign.context = context;
        bcpCampaign.rawValue = json;
        bcpCampaign.header = header;
        return bcpCampaign;
    }

    public static APINodeList<BCPCampaign> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BCPCampaign> bcpCampaigns = new APINodeList<BCPCampaign>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        bcpCampaigns.add(BCPCampaign.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return bcpCampaigns;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            bcpCampaigns.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        bcpCampaigns.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            bcpCampaigns.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            bcpCampaigns.add(BCPCampaign.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                bcpCampaigns.add(BCPCampaign.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            bcpCampaigns.add(BCPCampaign.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return bcpCampaigns;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        bcpCampaigns.add(BCPCampaign.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return bcpCampaigns;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        bcpCampaigns.add(BCPCampaign.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return bcpCampaigns;
                }
                bcpCampaigns.clear();
                bcpCampaigns.add(BCPCampaign.loadJSON(json, context, header));
                return bcpCampaigns;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BCPCampaign.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Boolean getFieldAdsPermissionRequired() {
        return this.mAdsPermissionRequired;
    }

    public String getFieldApplicationDeadline() {
        return this.mApplicationDeadline;
    }

    public String getFieldCampaignGoal() {
        return this.mCampaignGoal;
    }

    public String getFieldCampaignGoalOther() {
        return this.mCampaignGoalOther;
    }

    public String getFieldContentDeliveryDeadline() {
        return this.mContentDeliveryDeadline;
    }

    public String getFieldContentDeliveryStartDate() {
        return this.mContentDeliveryStartDate;
    }

    public List<Map<String, Long>> getFieldContentRequirements() {
        return this.mContentRequirements;
    }

    public String getFieldContentRequirementsDescription() {
        return this.mContentRequirementsDescription;
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public String getFieldDealNegotiationType() {
        return this.mDealNegotiationType;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public Boolean getFieldHasFreeProduct() {
        return this.mHasFreeProduct;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Long getFieldPaymentAmountForAds() {
        return this.mPaymentAmountForAds;
    }

    public Long getFieldPaymentAmountForContent() {
        return this.mPaymentAmountForContent;
    }

    public String getFieldPaymentDescription() {
        return this.mPaymentDescription;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BCPCampaign copyFrom(BCPCampaign instance) {
        this.mAdsPermissionRequired = instance.mAdsPermissionRequired;
        this.mApplicationDeadline = instance.mApplicationDeadline;
        this.mCampaignGoal = instance.mCampaignGoal;
        this.mCampaignGoalOther = instance.mCampaignGoalOther;
        this.mContentDeliveryDeadline = instance.mContentDeliveryDeadline;
        this.mContentDeliveryStartDate = instance.mContentDeliveryStartDate;
        this.mContentRequirements = instance.mContentRequirements;
        this.mContentRequirementsDescription = instance.mContentRequirementsDescription;
        this.mCurrency = instance.mCurrency;
        this.mDealNegotiationType = instance.mDealNegotiationType;
        this.mDescription = instance.mDescription;
        this.mHasFreeProduct = instance.mHasFreeProduct;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.mPaymentAmountForAds = instance.mPaymentAmountForAds;
        this.mPaymentAmountForContent = instance.mPaymentAmountForContent;
        this.mPaymentDescription = instance.mPaymentDescription;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BCPCampaign> getParser() {
        return new APIRequest.ResponseParser<BCPCampaign>(){

            @Override
            public APINodeList<BCPCampaign> parseResponse(String response, APIContext context, APIRequest<BCPCampaign> request, String header) throws APIException.MalformedResponseException {
                return BCPCampaign.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<BCPCampaign> {
        BCPCampaign lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ads_permission_required", "application_deadline", "campaign_goal", "campaign_goal_other", "content_delivery_deadline", "content_delivery_start_date", "content_requirements", "content_requirements_description", "currency", "deal_negotiation_type", "description", "has_free_product", "id", "name", "payment_amount_for_ads", "payment_amount_for_content", "payment_description"};

        @Override
        public BCPCampaign getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BCPCampaign parseResponse(String response, String header) throws APIException {
            return BCPCampaign.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public BCPCampaign execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BCPCampaign execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<BCPCampaign> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BCPCampaign> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, BCPCampaign>(){

                public BCPCampaign apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdsPermissionRequiredField() {
            return this.requestAdsPermissionRequiredField(true);
        }

        public APIRequestGet requestAdsPermissionRequiredField(boolean value) {
            this.requestField("ads_permission_required", value);
            return this;
        }

        public APIRequestGet requestApplicationDeadlineField() {
            return this.requestApplicationDeadlineField(true);
        }

        public APIRequestGet requestApplicationDeadlineField(boolean value) {
            this.requestField("application_deadline", value);
            return this;
        }

        public APIRequestGet requestCampaignGoalField() {
            return this.requestCampaignGoalField(true);
        }

        public APIRequestGet requestCampaignGoalField(boolean value) {
            this.requestField("campaign_goal", value);
            return this;
        }

        public APIRequestGet requestCampaignGoalOtherField() {
            return this.requestCampaignGoalOtherField(true);
        }

        public APIRequestGet requestCampaignGoalOtherField(boolean value) {
            this.requestField("campaign_goal_other", value);
            return this;
        }

        public APIRequestGet requestContentDeliveryDeadlineField() {
            return this.requestContentDeliveryDeadlineField(true);
        }

        public APIRequestGet requestContentDeliveryDeadlineField(boolean value) {
            this.requestField("content_delivery_deadline", value);
            return this;
        }

        public APIRequestGet requestContentDeliveryStartDateField() {
            return this.requestContentDeliveryStartDateField(true);
        }

        public APIRequestGet requestContentDeliveryStartDateField(boolean value) {
            this.requestField("content_delivery_start_date", value);
            return this;
        }

        public APIRequestGet requestContentRequirementsField() {
            return this.requestContentRequirementsField(true);
        }

        public APIRequestGet requestContentRequirementsField(boolean value) {
            this.requestField("content_requirements", value);
            return this;
        }

        public APIRequestGet requestContentRequirementsDescriptionField() {
            return this.requestContentRequirementsDescriptionField(true);
        }

        public APIRequestGet requestContentRequirementsDescriptionField(boolean value) {
            this.requestField("content_requirements_description", value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestDealNegotiationTypeField() {
            return this.requestDealNegotiationTypeField(true);
        }

        public APIRequestGet requestDealNegotiationTypeField(boolean value) {
            this.requestField("deal_negotiation_type", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestHasFreeProductField() {
            return this.requestHasFreeProductField(true);
        }

        public APIRequestGet requestHasFreeProductField(boolean value) {
            this.requestField("has_free_product", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPaymentAmountForAdsField() {
            return this.requestPaymentAmountForAdsField(true);
        }

        public APIRequestGet requestPaymentAmountForAdsField(boolean value) {
            this.requestField("payment_amount_for_ads", value);
            return this;
        }

        public APIRequestGet requestPaymentAmountForContentField() {
            return this.requestPaymentAmountForContentField(true);
        }

        public APIRequestGet requestPaymentAmountForContentField(boolean value) {
            this.requestField("payment_amount_for_content", value);
            return this;
        }

        public APIRequestGet requestPaymentDescriptionField() {
            return this.requestPaymentDescriptionField(true);
        }

        public APIRequestGet requestPaymentDescriptionField(boolean value) {
            this.requestField("payment_description", value);
            return this;
        }
    }
}

