/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Photo;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class LeadGenContextCard
extends APINode {
    @SerializedName(value="button_text")
    private String mButtonText = null;
    @SerializedName(value="content")
    private List<String> mContent = null;
    @SerializedName(value="cover_photo")
    private Photo mCoverPhoto = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="style")
    private String mStyle = null;
    @SerializedName(value="title")
    private String mTitle = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static LeadGenContextCard loadJSON(String json, APIContext context, String header) {
        LeadGenContextCard leadGenContextCard = (LeadGenContextCard)LeadGenContextCard.getGson().fromJson(json, LeadGenContextCard.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(leadGenContextCard.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        leadGenContextCard.context = context;
        leadGenContextCard.rawValue = json;
        leadGenContextCard.header = header;
        return leadGenContextCard;
    }

    public static APINodeList<LeadGenContextCard> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<LeadGenContextCard> leadGenContextCards = new APINodeList<LeadGenContextCard>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        leadGenContextCards.add(LeadGenContextCard.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return leadGenContextCards;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            leadGenContextCards.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        leadGenContextCards.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            leadGenContextCards.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            leadGenContextCards.add(LeadGenContextCard.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                leadGenContextCards.add(LeadGenContextCard.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            leadGenContextCards.add(LeadGenContextCard.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return leadGenContextCards;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        leadGenContextCards.add(LeadGenContextCard.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return leadGenContextCards;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        leadGenContextCards.add(LeadGenContextCard.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return leadGenContextCards;
                }
                leadGenContextCards.clear();
                leadGenContextCards.add(LeadGenContextCard.loadJSON(json, context, header));
                return leadGenContextCards;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return LeadGenContextCard.getGson().toJson((Object)this);
    }

    public String getFieldButtonText() {
        return this.mButtonText;
    }

    public LeadGenContextCard setFieldButtonText(String value) {
        this.mButtonText = value;
        return this;
    }

    public List<String> getFieldContent() {
        return this.mContent;
    }

    public LeadGenContextCard setFieldContent(List<String> value) {
        this.mContent = value;
        return this;
    }

    public Photo getFieldCoverPhoto() {
        if (this.mCoverPhoto != null) {
            this.mCoverPhoto.context = this.getContext();
        }
        return this.mCoverPhoto;
    }

    public LeadGenContextCard setFieldCoverPhoto(Photo value) {
        this.mCoverPhoto = value;
        return this;
    }

    public LeadGenContextCard setFieldCoverPhoto(String value) {
        Type type = new TypeToken<Photo>(){}.getType();
        this.mCoverPhoto = (Photo)Photo.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public LeadGenContextCard setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldStyle() {
        return this.mStyle;
    }

    public LeadGenContextCard setFieldStyle(String value) {
        this.mStyle = value;
        return this;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public LeadGenContextCard setFieldTitle(String value) {
        this.mTitle = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public LeadGenContextCard copyFrom(LeadGenContextCard instance) {
        this.mButtonText = instance.mButtonText;
        this.mContent = instance.mContent;
        this.mCoverPhoto = instance.mCoverPhoto;
        this.mId = instance.mId;
        this.mStyle = instance.mStyle;
        this.mTitle = instance.mTitle;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<LeadGenContextCard> getParser() {
        return new APIRequest.ResponseParser<LeadGenContextCard>(){

            @Override
            public APINodeList<LeadGenContextCard> parseResponse(String response, APIContext context, APIRequest<LeadGenContextCard> request, String header) throws APIException.MalformedResponseException {
                return LeadGenContextCard.parseResponse(response, context, request, header);
            }
        };
    }
}

