/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.LeadgenForm;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class LeadGenDirectCRMIntegrationConfig
extends APINode {
    @SerializedName(value="auth_id")
    private String mAuthId = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="lead_gen_data")
    private LeadgenForm mLeadGenData = null;
    @SerializedName(value="matched_fields")
    private List<Map<String, String>> mMatchedFields = null;
    @SerializedName(value="matched_fields_labels")
    private List<Map<String, String>> mMatchedFieldsLabels = null;
    @SerializedName(value="resources")
    private List<Map<String, String>> mResources = null;
    @SerializedName(value="third_party_app_id")
    private String mThirdPartyAppId = null;
    protected static Gson gson = null;

    LeadGenDirectCRMIntegrationConfig() {
    }

    public LeadGenDirectCRMIntegrationConfig(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public LeadGenDirectCRMIntegrationConfig(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public LeadGenDirectCRMIntegrationConfig fetch() throws APIException {
        LeadGenDirectCRMIntegrationConfig newInstance = LeadGenDirectCRMIntegrationConfig.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static LeadGenDirectCRMIntegrationConfig fetchById(Long id, APIContext context) throws APIException {
        return LeadGenDirectCRMIntegrationConfig.fetchById(id.toString(), context);
    }

    public static ListenableFuture<LeadGenDirectCRMIntegrationConfig> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return LeadGenDirectCRMIntegrationConfig.fetchByIdAsync(id.toString(), context);
    }

    public static LeadGenDirectCRMIntegrationConfig fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<LeadGenDirectCRMIntegrationConfig> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<LeadGenDirectCRMIntegrationConfig> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<LeadGenDirectCRMIntegrationConfig>(context, "", "/", "GET", LeadGenDirectCRMIntegrationConfig.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<LeadGenDirectCRMIntegrationConfig>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<LeadGenDirectCRMIntegrationConfig>(context, "", "/", "GET", LeadGenDirectCRMIntegrationConfig.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static LeadGenDirectCRMIntegrationConfig loadJSON(String json, APIContext context, String header) {
        LeadGenDirectCRMIntegrationConfig leadGenDirectCRMIntegrationConfig = (LeadGenDirectCRMIntegrationConfig)LeadGenDirectCRMIntegrationConfig.getGson().fromJson(json, LeadGenDirectCRMIntegrationConfig.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(leadGenDirectCRMIntegrationConfig.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        leadGenDirectCRMIntegrationConfig.context = context;
        leadGenDirectCRMIntegrationConfig.rawValue = json;
        leadGenDirectCRMIntegrationConfig.header = header;
        return leadGenDirectCRMIntegrationConfig;
    }

    public static APINodeList<LeadGenDirectCRMIntegrationConfig> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<LeadGenDirectCRMIntegrationConfig> leadGenDirectCRMIntegrationConfigs = new APINodeList<LeadGenDirectCRMIntegrationConfig>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        leadGenDirectCRMIntegrationConfigs.add(LeadGenDirectCRMIntegrationConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return leadGenDirectCRMIntegrationConfigs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            leadGenDirectCRMIntegrationConfigs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        leadGenDirectCRMIntegrationConfigs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            leadGenDirectCRMIntegrationConfigs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            leadGenDirectCRMIntegrationConfigs.add(LeadGenDirectCRMIntegrationConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                leadGenDirectCRMIntegrationConfigs.add(LeadGenDirectCRMIntegrationConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            leadGenDirectCRMIntegrationConfigs.add(LeadGenDirectCRMIntegrationConfig.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return leadGenDirectCRMIntegrationConfigs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        leadGenDirectCRMIntegrationConfigs.add(LeadGenDirectCRMIntegrationConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return leadGenDirectCRMIntegrationConfigs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        leadGenDirectCRMIntegrationConfigs.add(LeadGenDirectCRMIntegrationConfig.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return leadGenDirectCRMIntegrationConfigs;
                }
                leadGenDirectCRMIntegrationConfigs.clear();
                leadGenDirectCRMIntegrationConfigs.add(LeadGenDirectCRMIntegrationConfig.loadJSON(json, context, header));
                return leadGenDirectCRMIntegrationConfigs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return LeadGenDirectCRMIntegrationConfig.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAuthId() {
        return this.mAuthId;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public String getFieldId() {
        return this.mId;
    }

    public LeadgenForm getFieldLeadGenData() {
        if (this.mLeadGenData != null) {
            this.mLeadGenData.context = this.getContext();
        }
        return this.mLeadGenData;
    }

    public List<Map<String, String>> getFieldMatchedFields() {
        return this.mMatchedFields;
    }

    public List<Map<String, String>> getFieldMatchedFieldsLabels() {
        return this.mMatchedFieldsLabels;
    }

    public List<Map<String, String>> getFieldResources() {
        return this.mResources;
    }

    public String getFieldThirdPartyAppId() {
        return this.mThirdPartyAppId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public LeadGenDirectCRMIntegrationConfig copyFrom(LeadGenDirectCRMIntegrationConfig instance) {
        this.mAuthId = instance.mAuthId;
        this.mCreationTime = instance.mCreationTime;
        this.mId = instance.mId;
        this.mLeadGenData = instance.mLeadGenData;
        this.mMatchedFields = instance.mMatchedFields;
        this.mMatchedFieldsLabels = instance.mMatchedFieldsLabels;
        this.mResources = instance.mResources;
        this.mThirdPartyAppId = instance.mThirdPartyAppId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<LeadGenDirectCRMIntegrationConfig> getParser() {
        return new APIRequest.ResponseParser<LeadGenDirectCRMIntegrationConfig>(){

            @Override
            public APINodeList<LeadGenDirectCRMIntegrationConfig> parseResponse(String response, APIContext context, APIRequest<LeadGenDirectCRMIntegrationConfig> request, String header) throws APIException.MalformedResponseException {
                return LeadGenDirectCRMIntegrationConfig.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<LeadGenDirectCRMIntegrationConfig> {
        LeadGenDirectCRMIntegrationConfig lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"auth_id", "creation_time", "id", "lead_gen_data", "matched_fields", "matched_fields_labels", "resources", "third_party_app_id"};

        @Override
        public LeadGenDirectCRMIntegrationConfig getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public LeadGenDirectCRMIntegrationConfig parseResponse(String response, String header) throws APIException {
            return LeadGenDirectCRMIntegrationConfig.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public LeadGenDirectCRMIntegrationConfig execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public LeadGenDirectCRMIntegrationConfig execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<LeadGenDirectCRMIntegrationConfig> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<LeadGenDirectCRMIntegrationConfig> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, LeadGenDirectCRMIntegrationConfig>(){

                public LeadGenDirectCRMIntegrationConfig apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAuthIdField() {
            return this.requestAuthIdField(true);
        }

        public APIRequestGet requestAuthIdField(boolean value) {
            this.requestField("auth_id", value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestLeadGenDataField() {
            return this.requestLeadGenDataField(true);
        }

        public APIRequestGet requestLeadGenDataField(boolean value) {
            this.requestField("lead_gen_data", value);
            return this;
        }

        public APIRequestGet requestMatchedFieldsField() {
            return this.requestMatchedFieldsField(true);
        }

        public APIRequestGet requestMatchedFieldsField(boolean value) {
            this.requestField("matched_fields", value);
            return this;
        }

        public APIRequestGet requestMatchedFieldsLabelsField() {
            return this.requestMatchedFieldsLabelsField(true);
        }

        public APIRequestGet requestMatchedFieldsLabelsField(boolean value) {
            this.requestField("matched_fields_labels", value);
            return this;
        }

        public APIRequestGet requestResourcesField() {
            return this.requestResourcesField(true);
        }

        public APIRequestGet requestResourcesField(boolean value) {
            this.requestField("resources", value);
            return this;
        }

        public APIRequestGet requestThirdPartyAppIdField() {
            return this.requestThirdPartyAppIdField(true);
        }

        public APIRequestGet requestThirdPartyAppIdField(boolean value) {
            this.requestField("third_party_app_id", value);
            return this;
        }
    }
}

