/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAccount;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class AdColumnSizes
extends APINode {
    @SerializedName(value="admarket_account")
    private AdAccount mAdmarketAccount = null;
    @SerializedName(value="app_id")
    private String mAppId = null;
    @SerializedName(value="columns")
    private List<Map<String, String>> mColumns = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="owner")
    private User mOwner = null;
    @SerializedName(value="page")
    private String mPage = null;
    @SerializedName(value="report")
    private String mReport = null;
    @SerializedName(value="tab")
    private String mTab = null;
    @SerializedName(value="view")
    private String mView = null;
    protected static Gson gson = null;

    AdColumnSizes() {
    }

    public AdColumnSizes(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdColumnSizes(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdColumnSizes fetch() throws APIException {
        AdColumnSizes newInstance = AdColumnSizes.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdColumnSizes fetchById(Long id, APIContext context) throws APIException {
        return AdColumnSizes.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdColumnSizes> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdColumnSizes.fetchByIdAsync(id.toString(), context);
    }

    public static AdColumnSizes fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdColumnSizes> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdColumnSizes> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdColumnSizes>(context, "", "/", "GET", AdColumnSizes.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdColumnSizes>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdColumnSizes>(context, "", "/", "GET", AdColumnSizes.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdColumnSizes loadJSON(String json, APIContext context, String header) {
        AdColumnSizes adColumnSizes = (AdColumnSizes)AdColumnSizes.getGson().fromJson(json, AdColumnSizes.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adColumnSizes.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adColumnSizes.context = context;
        adColumnSizes.rawValue = json;
        adColumnSizes.header = header;
        return adColumnSizes;
    }

    public static APINodeList<AdColumnSizes> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdColumnSizes> adColumnSizess = new APINodeList<AdColumnSizes>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adColumnSizess.add(AdColumnSizes.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adColumnSizess;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adColumnSizess.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adColumnSizess.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adColumnSizess.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adColumnSizess.add(AdColumnSizes.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adColumnSizess.add(AdColumnSizes.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adColumnSizess.add(AdColumnSizes.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adColumnSizess;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adColumnSizess.add(AdColumnSizes.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adColumnSizess;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adColumnSizess.add(AdColumnSizes.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adColumnSizess;
                }
                adColumnSizess.clear();
                adColumnSizess.add(AdColumnSizes.loadJSON(json, context, header));
                return adColumnSizess;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdColumnSizes.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public AdAccount getFieldAdmarketAccount() {
        if (this.mAdmarketAccount != null) {
            this.mAdmarketAccount.context = this.getContext();
        }
        return this.mAdmarketAccount;
    }

    public String getFieldAppId() {
        return this.mAppId;
    }

    public List<Map<String, String>> getFieldColumns() {
        return this.mColumns;
    }

    public String getFieldId() {
        return this.mId;
    }

    public User getFieldOwner() {
        if (this.mOwner != null) {
            this.mOwner.context = this.getContext();
        }
        return this.mOwner;
    }

    public String getFieldPage() {
        return this.mPage;
    }

    public String getFieldReport() {
        return this.mReport;
    }

    public String getFieldTab() {
        return this.mTab;
    }

    public String getFieldView() {
        return this.mView;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdColumnSizes copyFrom(AdColumnSizes instance) {
        this.mAdmarketAccount = instance.mAdmarketAccount;
        this.mAppId = instance.mAppId;
        this.mColumns = instance.mColumns;
        this.mId = instance.mId;
        this.mOwner = instance.mOwner;
        this.mPage = instance.mPage;
        this.mReport = instance.mReport;
        this.mTab = instance.mTab;
        this.mView = instance.mView;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdColumnSizes> getParser() {
        return new APIRequest.ResponseParser<AdColumnSizes>(){

            @Override
            public APINodeList<AdColumnSizes> parseResponse(String response, APIContext context, APIRequest<AdColumnSizes> request, String header) throws APIException.MalformedResponseException {
                return AdColumnSizes.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<AdColumnSizes> {
        AdColumnSizes lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"admarket_account", "app_id", "columns", "id", "owner", "page", "report", "tab", "view"};

        @Override
        public AdColumnSizes getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdColumnSizes parseResponse(String response, String header) throws APIException {
            return AdColumnSizes.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdColumnSizes execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdColumnSizes execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdColumnSizes> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdColumnSizes> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdColumnSizes>(){

                public AdColumnSizes apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdmarketAccountField() {
            return this.requestAdmarketAccountField(true);
        }

        public APIRequestGet requestAdmarketAccountField(boolean value) {
            this.requestField("admarket_account", value);
            return this;
        }

        public APIRequestGet requestAppIdField() {
            return this.requestAppIdField(true);
        }

        public APIRequestGet requestAppIdField(boolean value) {
            this.requestField("app_id", value);
            return this;
        }

        public APIRequestGet requestColumnsField() {
            return this.requestColumnsField(true);
        }

        public APIRequestGet requestColumnsField(boolean value) {
            this.requestField("columns", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGet requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGet requestPageField() {
            return this.requestPageField(true);
        }

        public APIRequestGet requestPageField(boolean value) {
            this.requestField("page", value);
            return this;
        }

        public APIRequestGet requestReportField() {
            return this.requestReportField(true);
        }

        public APIRequestGet requestReportField(boolean value) {
            this.requestField("report", value);
            return this;
        }

        public APIRequestGet requestTabField() {
            return this.requestTabField(true);
        }

        public APIRequestGet requestTabField(boolean value) {
            this.requestField("tab", value);
            return this;
        }

        public APIRequestGet requestViewField() {
            return this.requestViewField(true);
        }

        public APIRequestGet requestViewField(boolean value) {
            this.requestField("view", value);
            return this;
        }
    }
}

