/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

public class ColumnSuggestions
extends APINode {
    @SerializedName(value="explanations")
    private Object mExplanations = null;
    @SerializedName(value="format")
    private List<String> mFormat = null;
    @SerializedName(value="objective")
    private List<String> mObjective = null;
    @SerializedName(value="optimization_goals")
    private List<String> mOptimizationGoals = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static ColumnSuggestions loadJSON(String json, APIContext context, String header) {
        ColumnSuggestions columnSuggestions = (ColumnSuggestions)ColumnSuggestions.getGson().fromJson(json, ColumnSuggestions.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(columnSuggestions.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        columnSuggestions.context = context;
        columnSuggestions.rawValue = json;
        columnSuggestions.header = header;
        return columnSuggestions;
    }

    public static APINodeList<ColumnSuggestions> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ColumnSuggestions> columnSuggestionss = new APINodeList<ColumnSuggestions>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        columnSuggestionss.add(ColumnSuggestions.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return columnSuggestionss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            columnSuggestionss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        columnSuggestionss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            columnSuggestionss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            columnSuggestionss.add(ColumnSuggestions.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                columnSuggestionss.add(ColumnSuggestions.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            columnSuggestionss.add(ColumnSuggestions.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return columnSuggestionss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        columnSuggestionss.add(ColumnSuggestions.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return columnSuggestionss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        columnSuggestionss.add(ColumnSuggestions.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return columnSuggestionss;
                }
                columnSuggestionss.clear();
                columnSuggestionss.add(ColumnSuggestions.loadJSON(json, context, header));
                return columnSuggestionss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ColumnSuggestions.getGson().toJson((Object)this);
    }

    public Object getFieldExplanations() {
        return this.mExplanations;
    }

    public ColumnSuggestions setFieldExplanations(Object value) {
        this.mExplanations = value;
        return this;
    }

    public List<String> getFieldFormat() {
        return this.mFormat;
    }

    public ColumnSuggestions setFieldFormat(List<String> value) {
        this.mFormat = value;
        return this;
    }

    public List<String> getFieldObjective() {
        return this.mObjective;
    }

    public ColumnSuggestions setFieldObjective(List<String> value) {
        this.mObjective = value;
        return this;
    }

    public List<String> getFieldOptimizationGoals() {
        return this.mOptimizationGoals;
    }

    public ColumnSuggestions setFieldOptimizationGoals(List<String> value) {
        this.mOptimizationGoals = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ColumnSuggestions copyFrom(ColumnSuggestions instance) {
        this.mExplanations = instance.mExplanations;
        this.mFormat = instance.mFormat;
        this.mObjective = instance.mObjective;
        this.mOptimizationGoals = instance.mOptimizationGoals;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ColumnSuggestions> getParser() {
        return new APIRequest.ResponseParser<ColumnSuggestions>(){

            @Override
            public APINodeList<ColumnSuggestions> parseResponse(String response, APIContext context, APIRequest<ColumnSuggestions> request, String header) throws APIException.MalformedResponseException {
                return ColumnSuggestions.parseResponse(response, context, request, header);
            }
        };
    }
}

