/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Place;
import com.facebook.ads.sdk.Targeting;
import com.facebook.ads.sdk.User;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

public class ScheduledPost
extends APINode {
    @SerializedName(value="admin_creator")
    private User mAdminCreator = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="feed_audience_description")
    private String mFeedAudienceDescription = null;
    @SerializedName(value="feed_targeting")
    private Targeting mFeedTargeting = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_post_in_good_state")
    private Boolean mIsPostInGoodState = null;
    @SerializedName(value="message")
    private String mMessage = null;
    @SerializedName(value="modified_time")
    private String mModifiedTime = null;
    @SerializedName(value="og_action_summary")
    private String mOgActionSummary = null;
    @SerializedName(value="permalink_url")
    private String mPermalinkUrl = null;
    @SerializedName(value="place")
    private Place mPlace = null;
    @SerializedName(value="privacy_description")
    private String mPrivacyDescription = null;
    @SerializedName(value="scheduled_failure_notice")
    private String mScheduledFailureNotice = null;
    @SerializedName(value="scheduled_publish_time")
    private String mScheduledPublishTime = null;
    @SerializedName(value="story_token")
    private String mStoryToken = null;
    @SerializedName(value="thumbnail")
    private String mThumbnail = null;
    @SerializedName(value="video_id")
    private String mVideoId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ScheduledPost loadJSON(String json, APIContext context, String header) {
        ScheduledPost scheduledPost = (ScheduledPost)ScheduledPost.getGson().fromJson(json, ScheduledPost.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(scheduledPost.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        scheduledPost.context = context;
        scheduledPost.rawValue = json;
        scheduledPost.header = header;
        return scheduledPost;
    }

    public static APINodeList<ScheduledPost> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ScheduledPost> scheduledPosts = new APINodeList<ScheduledPost>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        scheduledPosts.add(ScheduledPost.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return scheduledPosts;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            scheduledPosts.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        scheduledPosts.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            scheduledPosts.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            scheduledPosts.add(ScheduledPost.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                scheduledPosts.add(ScheduledPost.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            scheduledPosts.add(ScheduledPost.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return scheduledPosts;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        scheduledPosts.add(ScheduledPost.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return scheduledPosts;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        scheduledPosts.add(ScheduledPost.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return scheduledPosts;
                }
                scheduledPosts.clear();
                scheduledPosts.add(ScheduledPost.loadJSON(json, context, header));
                return scheduledPosts;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ScheduledPost.getGson().toJson((Object)this);
    }

    public User getFieldAdminCreator() {
        if (this.mAdminCreator != null) {
            this.mAdminCreator.context = this.getContext();
        }
        return this.mAdminCreator;
    }

    public ScheduledPost setFieldAdminCreator(User value) {
        this.mAdminCreator = value;
        return this;
    }

    public ScheduledPost setFieldAdminCreator(String value) {
        Type type = new TypeToken<User>(){}.getType();
        this.mAdminCreator = (User)User.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public ScheduledPost setFieldCreationTime(String value) {
        this.mCreationTime = value;
        return this;
    }

    public String getFieldFeedAudienceDescription() {
        return this.mFeedAudienceDescription;
    }

    public ScheduledPost setFieldFeedAudienceDescription(String value) {
        this.mFeedAudienceDescription = value;
        return this;
    }

    public Targeting getFieldFeedTargeting() {
        return this.mFeedTargeting;
    }

    public ScheduledPost setFieldFeedTargeting(Targeting value) {
        this.mFeedTargeting = value;
        return this;
    }

    public ScheduledPost setFieldFeedTargeting(String value) {
        Type type = new TypeToken<Targeting>(){}.getType();
        this.mFeedTargeting = (Targeting)Targeting.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public ScheduledPost setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public Boolean getFieldIsPostInGoodState() {
        return this.mIsPostInGoodState;
    }

    public ScheduledPost setFieldIsPostInGoodState(Boolean value) {
        this.mIsPostInGoodState = value;
        return this;
    }

    public String getFieldMessage() {
        return this.mMessage;
    }

    public ScheduledPost setFieldMessage(String value) {
        this.mMessage = value;
        return this;
    }

    public String getFieldModifiedTime() {
        return this.mModifiedTime;
    }

    public ScheduledPost setFieldModifiedTime(String value) {
        this.mModifiedTime = value;
        return this;
    }

    public String getFieldOgActionSummary() {
        return this.mOgActionSummary;
    }

    public ScheduledPost setFieldOgActionSummary(String value) {
        this.mOgActionSummary = value;
        return this;
    }

    public String getFieldPermalinkUrl() {
        return this.mPermalinkUrl;
    }

    public ScheduledPost setFieldPermalinkUrl(String value) {
        this.mPermalinkUrl = value;
        return this;
    }

    public Place getFieldPlace() {
        if (this.mPlace != null) {
            this.mPlace.context = this.getContext();
        }
        return this.mPlace;
    }

    public ScheduledPost setFieldPlace(Place value) {
        this.mPlace = value;
        return this;
    }

    public ScheduledPost setFieldPlace(String value) {
        Type type = new TypeToken<Place>(){}.getType();
        this.mPlace = (Place)Place.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldPrivacyDescription() {
        return this.mPrivacyDescription;
    }

    public ScheduledPost setFieldPrivacyDescription(String value) {
        this.mPrivacyDescription = value;
        return this;
    }

    public String getFieldScheduledFailureNotice() {
        return this.mScheduledFailureNotice;
    }

    public ScheduledPost setFieldScheduledFailureNotice(String value) {
        this.mScheduledFailureNotice = value;
        return this;
    }

    public String getFieldScheduledPublishTime() {
        return this.mScheduledPublishTime;
    }

    public ScheduledPost setFieldScheduledPublishTime(String value) {
        this.mScheduledPublishTime = value;
        return this;
    }

    public String getFieldStoryToken() {
        return this.mStoryToken;
    }

    public ScheduledPost setFieldStoryToken(String value) {
        this.mStoryToken = value;
        return this;
    }

    public String getFieldThumbnail() {
        return this.mThumbnail;
    }

    public ScheduledPost setFieldThumbnail(String value) {
        this.mThumbnail = value;
        return this;
    }

    public String getFieldVideoId() {
        return this.mVideoId;
    }

    public ScheduledPost setFieldVideoId(String value) {
        this.mVideoId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ScheduledPost copyFrom(ScheduledPost instance) {
        this.mAdminCreator = instance.mAdminCreator;
        this.mCreationTime = instance.mCreationTime;
        this.mFeedAudienceDescription = instance.mFeedAudienceDescription;
        this.mFeedTargeting = instance.mFeedTargeting;
        this.mId = instance.mId;
        this.mIsPostInGoodState = instance.mIsPostInGoodState;
        this.mMessage = instance.mMessage;
        this.mModifiedTime = instance.mModifiedTime;
        this.mOgActionSummary = instance.mOgActionSummary;
        this.mPermalinkUrl = instance.mPermalinkUrl;
        this.mPlace = instance.mPlace;
        this.mPrivacyDescription = instance.mPrivacyDescription;
        this.mScheduledFailureNotice = instance.mScheduledFailureNotice;
        this.mScheduledPublishTime = instance.mScheduledPublishTime;
        this.mStoryToken = instance.mStoryToken;
        this.mThumbnail = instance.mThumbnail;
        this.mVideoId = instance.mVideoId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ScheduledPost> getParser() {
        return new APIRequest.ResponseParser<ScheduledPost>(){

            @Override
            public APINodeList<ScheduledPost> parseResponse(String response, APIContext context, APIRequest<ScheduledPost> request, String header) throws APIException.MalformedResponseException {
                return ScheduledPost.parseResponse(response, context, request, header);
            }
        };
    }
}

