/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk.serverside;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ExtendedDeviceInfo {
    private static final int EXT_INFO_ARRAY_MAX_SIZE = 16;
    private static final int EXT_INFO_VERSION = 0;
    private static final int APP_PACKAGE_NAME = 1;
    private static final int SHORT_VERSION = 2;
    private static final int LONG_VERSION = 3;
    private static final int OS_VERSION = 4;
    private static final int DEVICE_MODEL_NAME = 5;
    private static final int LOCALE = 6;
    private static final int TIMEZONE_ABBREVIATION = 7;
    private static final int CARRIER = 8;
    private static final int SCREEN_WIDTH = 9;
    private static final int SCREEN_HEIGHT = 10;
    private static final int SCREEN_DENSITY = 11;
    private static final int CPU_CORE_COUNT = 12;
    private static final int TOTAL_DISK_SPACE_GB = 13;
    private static final int FREE_DISK_SPACE_GB = 14;
    private static final int DEVICE_TIME_ZONE = 15;
    private final String[] extendedDeviceInfoArray = new String[16];

    public List<String> getExtendedDeviceInfoArray() {
        return Arrays.stream(this.extendedDeviceInfoArray).map(it -> it != null ? it : "").collect(Collectors.toList());
    }

    public ExtendedDeviceInfo extinfoVersion(String extinfoVersion) {
        this.setExtinfoVersion(extinfoVersion);
        return this;
    }

    public String getExtinfoVersion() {
        return this.extendedDeviceInfoArray[0];
    }

    public void setExtinfoVersion(String extinfoVersion) {
        this.extendedDeviceInfoArray[0] = extinfoVersion;
    }

    public ExtendedDeviceInfo appPackageName(String appPackageName) {
        this.setAppPackageName(appPackageName);
        return this;
    }

    public String getAppPackageName() {
        return this.extendedDeviceInfoArray[1];
    }

    public void setAppPackageName(String appPackageName) {
        this.extendedDeviceInfoArray[1] = appPackageName;
    }

    public ExtendedDeviceInfo shortVersion(String shortVersion) {
        this.setShortVersion(shortVersion);
        return this;
    }

    public String getShortVersion() {
        return this.extendedDeviceInfoArray[2];
    }

    public void setShortVersion(String shortVersion) {
        this.extendedDeviceInfoArray[2] = shortVersion;
    }

    public ExtendedDeviceInfo longVersion(String longVersion) {
        this.setLongVersion(longVersion);
        return this;
    }

    public String getLongVersion() {
        return this.extendedDeviceInfoArray[3];
    }

    public void setLongVersion(String longVersion) {
        this.extendedDeviceInfoArray[3] = longVersion;
    }

    public ExtendedDeviceInfo osVersion(String osVersion) {
        this.setOsVersion(osVersion);
        return this;
    }

    public String getOsVersion() {
        return this.extendedDeviceInfoArray[4];
    }

    public void setOsVersion(String osVersion) {
        this.extendedDeviceInfoArray[4] = osVersion;
    }

    public ExtendedDeviceInfo deviceModelName(String deviceModelName) {
        this.setDeviceModelName(deviceModelName);
        return this;
    }

    public String getDeviceModelName() {
        return this.extendedDeviceInfoArray[5];
    }

    public void setDeviceModelName(String deviceModelName) {
        this.extendedDeviceInfoArray[5] = deviceModelName;
    }

    public ExtendedDeviceInfo locale(String locale) {
        this.setLocale(locale);
        return this;
    }

    public String getLocale() {
        return this.extendedDeviceInfoArray[6];
    }

    public void setLocale(String locale) {
        this.extendedDeviceInfoArray[6] = locale;
    }

    public ExtendedDeviceInfo timezoneAbbreviation(String timezoneAbbreviation) {
        this.setTimezoneAbbreviation(timezoneAbbreviation);
        return this;
    }

    public String getTimezoneAbbreviation() {
        return this.extendedDeviceInfoArray[7];
    }

    public void setTimezoneAbbreviation(String timezoneAbbreviation) {
        this.extendedDeviceInfoArray[7] = timezoneAbbreviation;
    }

    public ExtendedDeviceInfo carrier(String carrier) {
        this.setCarrier(carrier);
        return this;
    }

    public String getCarrier() {
        return this.extendedDeviceInfoArray[8];
    }

    public void setCarrier(String carrier) {
        this.extendedDeviceInfoArray[8] = carrier;
    }

    public ExtendedDeviceInfo screenWidth(Integer screenWidth) {
        this.setScreenWidth(screenWidth);
        return this;
    }

    public Integer getScreenWidth() {
        String screenWithStr = this.extendedDeviceInfoArray[9];
        return screenWithStr != null ? Integer.valueOf(Integer.parseInt(screenWithStr)) : null;
    }

    public void setScreenWidth(Integer screenWidth) {
        this.extendedDeviceInfoArray[9] = screenWidth != null ? String.valueOf(screenWidth) : null;
    }

    public ExtendedDeviceInfo screenHeight(Integer screenHeight) {
        this.setScreenHeight(screenHeight);
        return this;
    }

    public Integer getScreenHeight() {
        String screenHeightStr = this.extendedDeviceInfoArray[10];
        return screenHeightStr != null ? Integer.valueOf(Integer.parseInt(screenHeightStr)) : null;
    }

    public void setScreenHeight(Integer screenHeight) {
        this.extendedDeviceInfoArray[10] = screenHeight != null ? String.valueOf(screenHeight) : null;
    }

    public ExtendedDeviceInfo screenDensity(String screenDensity) {
        this.setScreenDensity(screenDensity);
        return this;
    }

    public String getScreenDensity() {
        return this.extendedDeviceInfoArray[11];
    }

    public void setScreenDensity(String screenDensity) {
        this.extendedDeviceInfoArray[11] = screenDensity;
    }

    public ExtendedDeviceInfo cpuCoresCount(Integer cpuCoresCount) {
        this.setCpuCoresCount(cpuCoresCount);
        return this;
    }

    public Integer getCpuCoresCount() {
        String cpuCoresCount = this.extendedDeviceInfoArray[12];
        return cpuCoresCount != null ? Integer.valueOf(Integer.parseInt(cpuCoresCount)) : null;
    }

    public void setCpuCoresCount(Integer cpuCoresCount) {
        this.extendedDeviceInfoArray[12] = cpuCoresCount != null ? String.valueOf(cpuCoresCount) : null;
    }

    public ExtendedDeviceInfo totalDiskGB(Integer totalDiskGB) {
        this.setTotalDiskGB(totalDiskGB);
        return this;
    }

    public Integer getTotalDiskGB() {
        String totalDiskGBStr = this.extendedDeviceInfoArray[13];
        return totalDiskGBStr != null ? Integer.valueOf(Integer.parseInt(totalDiskGBStr)) : null;
    }

    public void setTotalDiskGB(Integer totalDiskGB) {
        this.extendedDeviceInfoArray[13] = totalDiskGB != null ? String.valueOf(totalDiskGB) : null;
    }

    public ExtendedDeviceInfo freeDiskGB(Integer freeDiskGB) {
        this.setFreeDiskGB(freeDiskGB);
        return this;
    }

    public Integer getFreeDiskGB() {
        String freeDiskGBStr = this.extendedDeviceInfoArray[14];
        return freeDiskGBStr != null ? Integer.valueOf(Integer.parseInt(freeDiskGBStr)) : null;
    }

    public void setFreeDiskGB(Integer freeDiskGB) {
        this.extendedDeviceInfoArray[14] = freeDiskGB != null ? String.valueOf(freeDiskGB) : null;
    }

    public ExtendedDeviceInfo deviceTimeZone(String deviceTimeZone) {
        this.setDeviceTimeZone(deviceTimeZone);
        return this;
    }

    public String getDeviceTimeZone() {
        return this.extendedDeviceInfoArray[15];
    }

    public void setDeviceTimeZone(String deviceTimeZone) {
        this.extendedDeviceInfoArray[15] = deviceTimeZone;
    }

    public String toString() {
        return "{ extinfoVersion='" + this.getExtinfoVersion() + "', appPackageName='" + this.getAppPackageName() + "', shortVersion='" + this.getShortVersion() + "', longVersion='" + this.getLongVersion() + "', osVersion='" + this.getOsVersion() + "', deviceModelName='" + this.getDeviceModelName() + "', locale='" + this.getLocale() + "', timezoneAbbreviation='" + this.getTimezoneAbbreviation() + "', carrier='" + this.getCarrier() + "', screenWidth='" + this.getScreenWidth() + "', screenHeight='" + this.getScreenHeight() + "', screenDensity='" + this.getScreenDensity() + "', cpuCoresCount='" + this.getCpuCoresCount() + "', totalDiskGB='" + this.getTotalDiskGB() + "', freeDiskGB='" + this.getFreeDiskGB() + "', deviceTimeZone='" + this.getDeviceTimeZone() + "'}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtendedDeviceInfo)) {
            return false;
        }
        ExtendedDeviceInfo extendedDeviceInfo = (ExtendedDeviceInfo)o;
        return Objects.equals(this.getExtinfoVersion(), extendedDeviceInfo.getExtinfoVersion()) && Objects.equals(this.getAppPackageName(), extendedDeviceInfo.getAppPackageName()) && Objects.equals(this.getShortVersion(), extendedDeviceInfo.getShortVersion()) && Objects.equals(this.getLongVersion(), extendedDeviceInfo.getLongVersion()) && Objects.equals(this.getOsVersion(), extendedDeviceInfo.getOsVersion()) && Objects.equals(this.getDeviceModelName(), extendedDeviceInfo.getDeviceModelName()) && Objects.equals(this.getLocale(), extendedDeviceInfo.getLocale()) && Objects.equals(this.getTimezoneAbbreviation(), extendedDeviceInfo.getTimezoneAbbreviation()) && Objects.equals(this.getCarrier(), extendedDeviceInfo.getCarrier()) && this.getScreenWidth() == extendedDeviceInfo.getScreenWidth() && this.getScreenHeight() == extendedDeviceInfo.getScreenHeight() && Objects.equals(this.getScreenDensity(), extendedDeviceInfo.getScreenDensity()) && this.getCpuCoresCount() == extendedDeviceInfo.getCpuCoresCount() && this.getTotalDiskGB() == extendedDeviceInfo.getTotalDiskGB() && this.getFreeDiskGB() == extendedDeviceInfo.getFreeDiskGB() && Objects.equals(this.getDeviceTimeZone(), extendedDeviceInfo.getDeviceTimeZone());
    }

    public int hashCode() {
        return Objects.hash(this.getExtinfoVersion(), this.getAppPackageName(), this.getShortVersion(), this.getLongVersion(), this.getOsVersion(), this.getDeviceModelName(), this.getLocale(), this.getTimezoneAbbreviation(), this.getCarrier(), this.getScreenWidth(), this.getScreenHeight(), this.getScreenDensity(), this.getCpuCoresCount(), this.getTotalDiskGB(), this.getFreeDiskGB(), this.getDeviceTimeZone());
    }
}

