/**
 * Copyright (c) 2015-present, Facebook, Inc. All rights reserved.
 *
 * You are hereby granted a non-exclusive, worldwide, royalty-free license to
 * use, copy, modify, and distribute this software in source code or binary
 * form for use in connection with the web services and APIs provided by
 * Facebook.
 *
 * As with any software that integrates with the Facebook platform, your use
 * of this software is subject to the Facebook Developer Principles and
 * Policies [http://developers.facebook.com/policy/]. This copyright notice
 * shall be included in all copies or substantial portions of the software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */

package com.facebook.ads.sdk;

import java.io.File;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.gson.JsonObject;
import com.google.gson.JsonArray;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;

import com.facebook.ads.sdk.APIException.MalformedResponseException;

/**
 * This class is auto-generated.
 *
 * For any issues or feature requests related to this class, please let us know
 * on github and we'll fix in our codegen framework. We'll not be able to accept
 * pull request for this class.
 *
 */
public class Page extends APINode {
  @SerializedName("about")
  private String mAbout = null;
  @SerializedName("access_token")
  private String mAccessToken = null;
  @SerializedName("ad_campaign")
  private AdSet mAdCampaign = null;
  @SerializedName("affiliation")
  private String mAffiliation = null;
  @SerializedName("app_id")
  private String mAppId = null;
  @SerializedName("app_links")
  private AppLinks mAppLinks = null;
  @SerializedName("artists_we_like")
  private String mArtistsWeLike = null;
  @SerializedName("attire")
  private String mAttire = null;
  @SerializedName("awards")
  private String mAwards = null;
  @SerializedName("band_interests")
  private String mBandInterests = null;
  @SerializedName("band_members")
  private String mBandMembers = null;
  @SerializedName("best_page")
  private Page mBestPage = null;
  @SerializedName("bio")
  private String mBio = null;
  @SerializedName("birthday")
  private String mBirthday = null;
  @SerializedName("booking_agent")
  private String mBookingAgent = null;
  @SerializedName("built")
  private String mBuilt = null;
  @SerializedName("business")
  private Object mBusiness = null;
  @SerializedName("can_checkin")
  private Boolean mCanCheckin = null;
  @SerializedName("can_post")
  private Boolean mCanPost = null;
  @SerializedName("category")
  private String mCategory = null;
  @SerializedName("category_list")
  private List<PageCategory> mCategoryList = null;
  @SerializedName("checkins")
  private Long mCheckins = null;
  @SerializedName("company_overview")
  private String mCompanyOverview = null;
  @SerializedName("connected_instagram_account")
  private ShadowIGUser mConnectedInstagramAccount = null;
  @SerializedName("contact_address")
  private MailingAddress mContactAddress = null;
  @SerializedName("context")
  private OpenGraphContext mContext = null;
  @SerializedName("copyright_attribution_insights")
  private CopyrightAttributionInsights mCopyrightAttributionInsights = null;
  @SerializedName("copyright_whitelisted_ig_partners")
  private List<String> mCopyrightWhitelistedIgPartners = null;
  @SerializedName("country_page_likes")
  private Long mCountryPageLikes = null;
  @SerializedName("cover")
  private CoverPhoto mCover = null;
  @SerializedName("culinary_team")
  private String mCulinaryTeam = null;
  @SerializedName("current_location")
  private String mCurrentLocation = null;
  @SerializedName("description")
  private String mDescription = null;
  @SerializedName("description_html")
  private String mDescriptionHtml = null;
  @SerializedName("directed_by")
  private String mDirectedBy = null;
  @SerializedName("display_subtext")
  private String mDisplaySubtext = null;
  @SerializedName("displayed_message_response_time")
  private String mDisplayedMessageResponseTime = null;
  @SerializedName("emails")
  private List<String> mEmails = null;
  @SerializedName("engagement")
  private Engagement mEngagement = null;
  @SerializedName("fan_count")
  private Long mFanCount = null;
  @SerializedName("featured_video")
  private AdVideo mFeaturedVideo = null;
  @SerializedName("features")
  private String mFeatures = null;
  @SerializedName("food_styles")
  private List<String> mFoodStyles = null;
  @SerializedName("founded")
  private String mFounded = null;
  @SerializedName("general_info")
  private String mGeneralInfo = null;
  @SerializedName("general_manager")
  private String mGeneralManager = null;
  @SerializedName("genre")
  private String mGenre = null;
  @SerializedName("global_brand_page_name")
  private String mGlobalBrandPageName = null;
  @SerializedName("global_brand_parent_page")
  private Page mGlobalBrandParentPage = null;
  @SerializedName("global_brand_root_id")
  private String mGlobalBrandRootId = null;
  @SerializedName("has_added_app")
  private Boolean mHasAddedApp = null;
  @SerializedName("has_whatsapp_business_number")
  private Boolean mHasWhatsappBusinessNumber = null;
  @SerializedName("has_whatsapp_number")
  private Boolean mHasWhatsappNumber = null;
  @SerializedName("hometown")
  private String mHometown = null;
  @SerializedName("hours")
  private Map<String, String> mHours = null;
  @SerializedName("id")
  private String mId = null;
  @SerializedName("impressum")
  private String mImpressum = null;
  @SerializedName("influences")
  private String mInfluences = null;
  @SerializedName("instagram_business_account")
  private ShadowIGUser mInstagramBusinessAccount = null;
  @SerializedName("instant_articles_review_status")
  private String mInstantArticlesReviewStatus = null;
  @SerializedName("is_always_open")
  private Boolean mIsAlwaysOpen = null;
  @SerializedName("is_chain")
  private Boolean mIsChain = null;
  @SerializedName("is_community_page")
  private Boolean mIsCommunityPage = null;
  @SerializedName("is_eligible_for_branded_content")
  private Boolean mIsEligibleForBrandedContent = null;
  @SerializedName("is_messenger_bot_get_started_enabled")
  private Boolean mIsMessengerBotGetStartedEnabled = null;
  @SerializedName("is_messenger_platform_bot")
  private Boolean mIsMessengerPlatformBot = null;
  @SerializedName("is_owned")
  private Boolean mIsOwned = null;
  @SerializedName("is_permanently_closed")
  private Boolean mIsPermanentlyClosed = null;
  @SerializedName("is_published")
  private Boolean mIsPublished = null;
  @SerializedName("is_unclaimed")
  private Boolean mIsUnclaimed = null;
  @SerializedName("is_verified")
  private Boolean mIsVerified = null;
  @SerializedName("is_webhooks_subscribed")
  private Boolean mIsWebhooksSubscribed = null;
  @SerializedName("keywords")
  private Object mKeywords = null;
  @SerializedName("leadgen_form_preview_details")
  private LeadGenFormPreviewDetails mLeadgenFormPreviewDetails = null;
  @SerializedName("leadgen_has_crm_integration")
  private Boolean mLeadgenHasCrmIntegration = null;
  @SerializedName("leadgen_has_fat_ping_crm_integration")
  private Boolean mLeadgenHasFatPingCrmIntegration = null;
  @SerializedName("leadgen_tos_acceptance_time")
  private String mLeadgenTosAcceptanceTime = null;
  @SerializedName("leadgen_tos_accepted")
  private Boolean mLeadgenTosAccepted = null;
  @SerializedName("leadgen_tos_accepting_user")
  private User mLeadgenTosAcceptingUser = null;
  @SerializedName("link")
  private String mLink = null;
  @SerializedName("location")
  private Location mLocation = null;
  @SerializedName("members")
  private String mMembers = null;
  @SerializedName("merchant_id")
  private String mMerchantId = null;
  @SerializedName("merchant_review_status")
  private String mMerchantReviewStatus = null;
  @SerializedName("messenger_ads_default_icebreakers")
  private List<String> mMessengerAdsDefaultIcebreakers = null;
  @SerializedName("messenger_ads_default_page_welcome_message")
  private MessengerDestinationPageWelcomeMessage mMessengerAdsDefaultPageWelcomeMessage = null;
  @SerializedName("messenger_ads_default_quick_replies")
  private List<String> mMessengerAdsDefaultQuickReplies = null;
  @SerializedName("messenger_ads_quick_replies_type")
  private String mMessengerAdsQuickRepliesType = null;
  @SerializedName("mission")
  private String mMission = null;
  @SerializedName("mpg")
  private String mMpg = null;
  @SerializedName("name")
  private String mName = null;
  @SerializedName("name_with_location_descriptor")
  private String mNameWithLocationDescriptor = null;
  @SerializedName("network")
  private String mNetwork = null;
  @SerializedName("new_like_count")
  private Long mNewLikeCount = null;
  @SerializedName("offer_eligible")
  private Boolean mOfferEligible = null;
  @SerializedName("overall_star_rating")
  private Double mOverallStarRating = null;
  @SerializedName("page_token")
  private String mPageToken = null;
  @SerializedName("parent_page")
  private Page mParentPage = null;
  @SerializedName("parking")
  private PageParking mParking = null;
  @SerializedName("payment_options")
  private PagePaymentOptions mPaymentOptions = null;
  @SerializedName("personal_info")
  private String mPersonalInfo = null;
  @SerializedName("personal_interests")
  private String mPersonalInterests = null;
  @SerializedName("pharma_safety_info")
  private String mPharmaSafetyInfo = null;
  @SerializedName("phone")
  private String mPhone = null;
  @SerializedName("place_type")
  private String mPlaceType = null;
  @SerializedName("plot_outline")
  private String mPlotOutline = null;
  @SerializedName("preferred_audience")
  private Targeting mPreferredAudience = null;
  @SerializedName("press_contact")
  private String mPressContact = null;
  @SerializedName("price_range")
  private String mPriceRange = null;
  @SerializedName("produced_by")
  private String mProducedBy = null;
  @SerializedName("products")
  private String mProducts = null;
  @SerializedName("promotion_eligible")
  private Boolean mPromotionEligible = null;
  @SerializedName("promotion_ineligible_reason")
  private String mPromotionIneligibleReason = null;
  @SerializedName("public_transit")
  private String mPublicTransit = null;
  @SerializedName("publisher_space")
  private PublisherSpace mPublisherSpace = null;
  @SerializedName("rating_count")
  private Long mRatingCount = null;
  @SerializedName("recipient")
  private String mRecipient = null;
  @SerializedName("record_label")
  private String mRecordLabel = null;
  @SerializedName("release_date")
  private String mReleaseDate = null;
  @SerializedName("restaurant_services")
  private PageRestaurantServices mRestaurantServices = null;
  @SerializedName("restaurant_specialties")
  private PageRestaurantSpecialties mRestaurantSpecialties = null;
  @SerializedName("schedule")
  private String mSchedule = null;
  @SerializedName("screenplay_by")
  private String mScreenplayBy = null;
  @SerializedName("season")
  private String mSeason = null;
  @SerializedName("single_line_address")
  private String mSingleLineAddress = null;
  @SerializedName("starring")
  private String mStarring = null;
  @SerializedName("start_info")
  private PageStartInfo mStartInfo = null;
  @SerializedName("store_code")
  private String mStoreCode = null;
  @SerializedName("store_location_descriptor")
  private String mStoreLocationDescriptor = null;
  @SerializedName("store_number")
  private Long mStoreNumber = null;
  @SerializedName("studio")
  private String mStudio = null;
  @SerializedName("supports_instant_articles")
  private Boolean mSupportsInstantArticles = null;
  @SerializedName("talking_about_count")
  private Long mTalkingAboutCount = null;
  @SerializedName("unread_message_count")
  private Long mUnreadMessageCount = null;
  @SerializedName("unread_notif_count")
  private Long mUnreadNotifCount = null;
  @SerializedName("unseen_message_count")
  private Long mUnseenMessageCount = null;
  @SerializedName("username")
  private String mUsername = null;
  @SerializedName("verification_status")
  private String mVerificationStatus = null;
  @SerializedName("voip_info")
  private VoipInfo mVoipInfo = null;
  @SerializedName("website")
  private String mWebsite = null;
  @SerializedName("were_here_count")
  private Long mWereHereCount = null;
  @SerializedName("whatsapp_number")
  private String mWhatsappNumber = null;
  @SerializedName("written_by")
  private String mWrittenBy = null;
  protected static Gson gson = null;

  Page() {
  }

  public Page(Long id, APIContext context) {
    this(id.toString(), context);
  }

  public Page(String id, APIContext context) {
    this.mId = id;

    this.context = context;
  }

  public Page fetch() throws APIException{
    Page newInstance = fetchById(this.getPrefixedId().toString(), this.context);
    this.copyFrom(newInstance);
    return this;
  }

  public static Page fetchById(Long id, APIContext context) throws APIException {
    return fetchById(id.toString(), context);
  }

  public static ListenableFuture<Page> fetchByIdAsync(Long id, APIContext context) throws APIException {
    return fetchByIdAsync(id.toString(), context);
  }

  public static Page fetchById(String id, APIContext context) throws APIException {
    return
      new APIRequestGet(id, context)
      .requestAllFields()
      .execute();
  }

  public static ListenableFuture<Page> fetchByIdAsync(String id, APIContext context) throws APIException {
    return
      new APIRequestGet(id, context)
      .requestAllFields()
      .executeAsync();
  }

  public static APINodeList<Page> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
    return (APINodeList<Page>)(
      new APIRequest<Page>(context, "", "/", "GET", Page.getParser())
        .setParam("ids", APIRequest.joinStringList(ids))
        .requestFields(fields)
        .execute()
    );
  }

  public static ListenableFuture<APINodeList<Page>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
    return
      new APIRequest(context, "", "/", "GET", Page.getParser())
        .setParam("ids", APIRequest.joinStringList(ids))
        .requestFields(fields)
        .executeAsyncBase();
  }

  private String getPrefixedId() {
    return getId();
  }

  public String getId() {
    return getFieldId().toString();
  }
  public static Page loadJSON(String json, APIContext context) {
    Page page = getGson().fromJson(json, Page.class);
    if (context.isDebug()) {
      JsonParser parser = new JsonParser();
      JsonElement o1 = parser.parse(json);
      JsonElement o2 = parser.parse(page.toString());
      if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
        o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
      }
      if (!o1.equals(o2)) {
        context.log("[Warning] When parsing response, object is not consistent with JSON:");
        context.log("[JSON]" + o1);
        context.log("[Object]" + o2);
      };
    }
    page.context = context;
    page.rawValue = json;
    return page;
  }

  public static APINodeList<Page> parseResponse(String json, APIContext context, APIRequest request) throws MalformedResponseException {
    APINodeList<Page> pages = new APINodeList<Page>(request, json);
    JsonArray arr;
    JsonObject obj;
    JsonParser parser = new JsonParser();
    Exception exception = null;
    try{
      JsonElement result = parser.parse(json);
      if (result.isJsonArray()) {
        // First, check if it's a pure JSON Array
        arr = result.getAsJsonArray();
        for (int i = 0; i < arr.size(); i++) {
          pages.add(loadJSON(arr.get(i).getAsJsonObject().toString(), context));
        };
        return pages;
      } else if (result.isJsonObject()) {
        obj = result.getAsJsonObject();
        if (obj.has("data")) {
          if (obj.has("paging")) {
            JsonObject paging = obj.get("paging").getAsJsonObject();
            if (paging.has("cursors")) {
                JsonObject cursors = paging.get("cursors").getAsJsonObject();
                String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                pages.setCursors(before, after);
            }
            String previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
            String next = paging.has("next") ? paging.get("next").getAsString() : null;
            pages.setPaging(previous, next);
            if (context.hasAppSecret()) {
              pages.setAppSecret(context.getAppSecretProof());
            }
          }
          if (obj.get("data").isJsonArray()) {
            // Second, check if it's a JSON array with "data"
            arr = obj.get("data").getAsJsonArray();
            for (int i = 0; i < arr.size(); i++) {
              pages.add(loadJSON(arr.get(i).getAsJsonObject().toString(), context));
            };
          } else if (obj.get("data").isJsonObject()) {
            // Third, check if it's a JSON object with "data"
            obj = obj.get("data").getAsJsonObject();
            boolean isRedownload = false;
            for (String s : new String[]{"campaigns", "adsets", "ads"}) {
              if (obj.has(s)) {
                isRedownload = true;
                obj = obj.getAsJsonObject(s);
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                  pages.add(loadJSON(entry.getValue().toString(), context));
                }
                break;
              }
            }
            if (!isRedownload) {
              pages.add(loadJSON(obj.toString(), context));
            }
          }
          return pages;
        } else if (obj.has("images")) {
          // Fourth, check if it's a map of image objects
          obj = obj.get("images").getAsJsonObject();
          for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
              pages.add(loadJSON(entry.getValue().toString(), context));
          }
          return pages;
        } else {
          // Fifth, check if it's an array of objects indexed by id
          boolean isIdIndexedArray = true;
          for (Map.Entry entry : obj.entrySet()) {
            String key = (String) entry.getKey();
            if (key.equals("__fb_trace_id__")) {
              continue;
            }
            JsonElement value = (JsonElement) entry.getValue();
            if (
              value != null &&
              value.isJsonObject() &&
              value.getAsJsonObject().has("id") &&
              value.getAsJsonObject().get("id") != null &&
              value.getAsJsonObject().get("id").getAsString().equals(key)
            ) {
              pages.add(loadJSON(value.toString(), context));
            } else {
              isIdIndexedArray = false;
              break;
            }
          }
          if (isIdIndexedArray) {
            return pages;
          }

          // Sixth, check if it's pure JsonObject
          pages.clear();
          pages.add(loadJSON(json, context));
          return pages;
        }
      }
    } catch (Exception e) {
      exception = e;
    }
    throw new MalformedResponseException(
      "Invalid response string: " + json,
      exception
    );
  }

  @Override
  public APIContext getContext() {
    return context;
  }

  @Override
  public void setContext(APIContext context) {
    this.context = context;
  }

  @Override
  public String toString() {
    return getGson().toJson(this);
  }

  public APIRequestCreateActivity createActivity() {
    return new APIRequestCreateActivity(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetAdminNotes getAdminNotes() {
    return new APIRequestGetAdminNotes(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateAdminNote createAdminNote() {
    return new APIRequestCreateAdminNote(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateAdminSetting createAdminSetting() {
    return new APIRequestCreateAdminSetting(this.getPrefixedId().toString(), context);
  }

  public APIRequestDeleteAdmins deleteAdmins() {
    return new APIRequestDeleteAdmins(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateAdmin createAdmin() {
    return new APIRequestCreateAdmin(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateAdminStickySetting createAdminStickySetting() {
    return new APIRequestCreateAdminStickySetting(this.getPrefixedId().toString(), context);
  }

  public APIRequestDeleteAgencies deleteAgencies() {
    return new APIRequestDeleteAgencies(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetAgencies getAgencies() {
    return new APIRequestGetAgencies(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateAgency createAgency() {
    return new APIRequestCreateAgency(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetAlbums getAlbums() {
    return new APIRequestGetAlbums(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateAlbum createAlbum() {
    return new APIRequestCreateAlbum(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetAsset3Ds getAsset3Ds() {
    return new APIRequestGetAsset3Ds(this.getPrefixedId().toString(), context);
  }

  public APIRequestDeleteAssignedUsers deleteAssignedUsers() {
    return new APIRequestDeleteAssignedUsers(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetAssignedUsers getAssignedUsers() {
    return new APIRequestGetAssignedUsers(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateAssignedUser createAssignedUser() {
    return new APIRequestCreateAssignedUser(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetAudioCopyrights getAudioCopyrights() {
    return new APIRequestGetAudioCopyrights(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetAudioMediaCopyrights getAudioMediaCopyrights() {
    return new APIRequestGetAudioMediaCopyrights(this.getPrefixedId().toString(), context);
  }

  public APIRequestDeleteBlocked deleteBlocked() {
    return new APIRequestDeleteBlocked(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetBlocked getBlocked() {
    return new APIRequestGetBlocked(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateBlocked createBlocked() {
    return new APIRequestCreateBlocked(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetBroadcastMessages getBroadcastMessages() {
    return new APIRequestGetBroadcastMessages(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateBroadcastMessage createBroadcastMessage() {
    return new APIRequestCreateBroadcastMessage(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateBroadcastReachEstimation createBroadcastReachEstimation() {
    return new APIRequestCreateBroadcastReachEstimation(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetBusinessActivities getBusinessActivities() {
    return new APIRequestGetBusinessActivities(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateBusiness createBusiness() {
    return new APIRequestCreateBusiness(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetBusinessProjects getBusinessProjects() {
    return new APIRequestGetBusinessProjects(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetBusinessSettingLogs getBusinessSettingLogs() {
    return new APIRequestGetBusinessSettingLogs(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetCallToActions getCallToActions() {
    return new APIRequestGetCallToActions(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateCallToAction createCallToAction() {
    return new APIRequestCreateCallToAction(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetCanvasElements getCanvasElements() {
    return new APIRequestGetCanvasElements(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateCanvasElement createCanvasElement() {
    return new APIRequestCreateCanvasElement(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetCanvases getCanvases() {
    return new APIRequestGetCanvases(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateCanvase createCanvase() {
    return new APIRequestCreateCanvase(this.getPrefixedId().toString(), context);
  }

  public APIRequestDeleteClaimedUrls deleteClaimedUrls() {
    return new APIRequestDeleteClaimedUrls(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetConversations getConversations() {
    return new APIRequestGetConversations(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateCopyrightManualClaim createCopyrightManualClaim() {
    return new APIRequestCreateCopyrightManualClaim(this.getPrefixedId().toString(), context);
  }

  public APIRequestDeleteCopyrightWhitelistedIgPartners deleteCopyrightWhitelistedIgPartners() {
    return new APIRequestDeleteCopyrightWhitelistedIgPartners(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateCopyrightWhitelistedIgPartner createCopyrightWhitelistedIgPartner() {
    return new APIRequestCreateCopyrightWhitelistedIgPartner(this.getPrefixedId().toString(), context);
  }

  public APIRequestDeleteCopyrightWhitelistedPartners deleteCopyrightWhitelistedPartners() {
    return new APIRequestDeleteCopyrightWhitelistedPartners(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetCopyrightWhitelistedPartners getCopyrightWhitelistedPartners() {
    return new APIRequestGetCopyrightWhitelistedPartners(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateCopyrightWhitelistedPartner createCopyrightWhitelistedPartner() {
    return new APIRequestCreateCopyrightWhitelistedPartner(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetCrosspostPendingApprovalPages getCrosspostPendingApprovalPages() {
    return new APIRequestGetCrosspostPendingApprovalPages(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetCrosspostWhitelistedPages getCrosspostWhitelistedPages() {
    return new APIRequestGetCrosspostWhitelistedPages(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetCustomLabels getCustomLabels() {
    return new APIRequestGetCustomLabels(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateCustomLabel createCustomLabel() {
    return new APIRequestCreateCustomLabel(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetEvents getEvents() {
    return new APIRequestGetEvents(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateEvent createEvent() {
    return new APIRequestCreateEvent(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetExpiredPosts getExpiredPosts() {
    return new APIRequestGetExpiredPosts(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetExpiringPosts getExpiringPosts() {
    return new APIRequestGetExpiringPosts(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetFeatureDVideosCollection getFeatureDVideosCollection() {
    return new APIRequestGetFeatureDVideosCollection(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetFeed getFeed() {
    return new APIRequestGetFeed(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateFeed createFeed() {
    return new APIRequestCreateFeed(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateFlag createFlag() {
    return new APIRequestCreateFlag(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetGlobalBrandChildren getGlobalBrandChildren() {
    return new APIRequestGetGlobalBrandChildren(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetIndexedVideoCopyrights getIndexedVideoCopyrights() {
    return new APIRequestGetIndexedVideoCopyrights(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetIndexedVideos getIndexedVideos() {
    return new APIRequestGetIndexedVideos(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetInsights getInsights() {
    return new APIRequestGetInsights(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetInsightsExports getInsightsExports() {
    return new APIRequestGetInsightsExports(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetInstantArticles getInstantArticles() {
    return new APIRequestGetInstantArticles(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateInstantArticle createInstantArticle() {
    return new APIRequestCreateInstantArticle(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetInstantArticlesInsights getInstantArticlesInsights() {
    return new APIRequestGetInstantArticlesInsights(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateInstantArticlesPublish createInstantArticlesPublish() {
    return new APIRequestCreateInstantArticlesPublish(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetLabels getLabels() {
    return new APIRequestGetLabels(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateLabel createLabel() {
    return new APIRequestCreateLabel(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetLeadGenConditionalQuestionsGroup getLeadGenConditionalQuestionsGroup() {
    return new APIRequestGetLeadGenConditionalQuestionsGroup(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateLeadGenConditionalQuestionsGroup createLeadGenConditionalQuestionsGroup() {
    return new APIRequestCreateLeadGenConditionalQuestionsGroup(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetLeadGenContextCards getLeadGenContextCards() {
    return new APIRequestGetLeadGenContextCards(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateLeadGenContextCard createLeadGenContextCard() {
    return new APIRequestCreateLeadGenContextCard(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetLeadGenDraftForms getLeadGenDraftForms() {
    return new APIRequestGetLeadGenDraftForms(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateLeadGenDraftForm createLeadGenDraftForm() {
    return new APIRequestCreateLeadGenDraftForm(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetLeadGenForms getLeadGenForms() {
    return new APIRequestGetLeadGenForms(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateLeadGenForm createLeadGenForm() {
    return new APIRequestCreateLeadGenForm(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetLeadGenLegalContent getLeadGenLegalContent() {
    return new APIRequestGetLeadGenLegalContent(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateLeadGenLegalContent createLeadGenLegalContent() {
    return new APIRequestCreateLeadGenLegalContent(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetLeadGenQualifiers getLeadGenQualifiers() {
    return new APIRequestGetLeadGenQualifiers(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateLeadGenThankYouPage createLeadGenThankYouPage() {
    return new APIRequestCreateLeadGenThankYouPage(this.getPrefixedId().toString(), context);
  }

  public APIRequestDeleteLeadGenWhitelistedUsers deleteLeadGenWhitelistedUsers() {
    return new APIRequestDeleteLeadGenWhitelistedUsers(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetLeadGenWhitelistedUsers getLeadGenWhitelistedUsers() {
    return new APIRequestGetLeadGenWhitelistedUsers(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateLeadGenWhitelistedUser createLeadGenWhitelistedUser() {
    return new APIRequestCreateLeadGenWhitelistedUser(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetLikes getLikes() {
    return new APIRequestGetLikes(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateLink createLink() {
    return new APIRequestCreateLink(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetLiveVideos getLiveVideos() {
    return new APIRequestGetLiveVideos(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateLiveVideo createLiveVideo() {
    return new APIRequestCreateLiveVideo(this.getPrefixedId().toString(), context);
  }

  public APIRequestDeleteLocations deleteLocations() {
    return new APIRequestDeleteLocations(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetLocations getLocations() {
    return new APIRequestGetLocations(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateLocation createLocation() {
    return new APIRequestCreateLocation(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetMediaFingerprints getMediaFingerprints() {
    return new APIRequestGetMediaFingerprints(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateMediaFingerprint createMediaFingerprint() {
    return new APIRequestCreateMediaFingerprint(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateMessageAttachment createMessageAttachment() {
    return new APIRequestCreateMessageAttachment(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateMessageCreative createMessageCreative() {
    return new APIRequestCreateMessageCreative(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateMessage createMessage() {
    return new APIRequestCreateMessage(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetMessagingFeatureReview getMessagingFeatureReview() {
    return new APIRequestGetMessagingFeatureReview(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetMessengerAdsPageWelcomeMessages getMessengerAdsPageWelcomeMessages() {
    return new APIRequestGetMessengerAdsPageWelcomeMessages(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateMessengerCode createMessengerCode() {
    return new APIRequestCreateMessengerCode(this.getPrefixedId().toString(), context);
  }

  public APIRequestDeleteMessengerProfile deleteMessengerProfile() {
    return new APIRequestDeleteMessengerProfile(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetMessengerProfile getMessengerProfile() {
    return new APIRequestGetMessengerProfile(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateMessengerProfile createMessengerProfile() {
    return new APIRequestCreateMessengerProfile(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetMilestones getMilestones() {
    return new APIRequestGetMilestones(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateMilestone createMilestone() {
    return new APIRequestCreateMilestone(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetMusicVideoCopyrights getMusicVideoCopyrights() {
    return new APIRequestGetMusicVideoCopyrights(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetMusicVideoMediaCopyrights getMusicVideoMediaCopyrights() {
    return new APIRequestGetMusicVideoMediaCopyrights(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetNativeOffers getNativeOffers() {
    return new APIRequestGetNativeOffers(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateNativeOffer createNativeOffer() {
    return new APIRequestCreateNativeOffer(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateNlpConfig createNlpConfig() {
    return new APIRequestCreateNlpConfig(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateNote createNote() {
    return new APIRequestCreateNote(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateNotification createNotification() {
    return new APIRequestCreateNotification(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreatePageBackedInstagramAccount createPageBackedInstagramAccount() {
    return new APIRequestCreatePageBackedInstagramAccount(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreatePassThreadControl createPassThreadControl() {
    return new APIRequestCreatePassThreadControl(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetPersonas getPersonas() {
    return new APIRequestGetPersonas(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreatePersona createPersona() {
    return new APIRequestCreatePersona(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetPhotos getPhotos() {
    return new APIRequestGetPhotos(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreatePhoto createPhoto() {
    return new APIRequestCreatePhoto(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetPicture getPicture() {
    return new APIRequestGetPicture(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreatePicture createPicture() {
    return new APIRequestCreatePicture(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetPlaceTopics getPlaceTopics() {
    return new APIRequestGetPlaceTopics(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetPosts getPosts() {
    return new APIRequestGetPosts(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetProductCatalogs getProductCatalogs() {
    return new APIRequestGetProductCatalogs(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetPromotablePosts getPromotablePosts() {
    return new APIRequestGetPromotablePosts(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreatePromotion createPromotion() {
    return new APIRequestCreatePromotion(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetPublishedPosts getPublishedPosts() {
    return new APIRequestGetPublishedPosts(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateQuestion createQuestion() {
    return new APIRequestCreateQuestion(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetRatings getRatings() {
    return new APIRequestGetRatings(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateRequestThreadControl createRequestThreadControl() {
    return new APIRequestCreateRequestThreadControl(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetRestaurantOrders getRestaurantOrders() {
    return new APIRequestGetRestaurantOrders(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetRoles getRoles() {
    return new APIRequestGetRoles(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetRtbDynamicPosts getRtbDynamicPosts() {
    return new APIRequestGetRtbDynamicPosts(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetSavedFilters getSavedFilters() {
    return new APIRequestGetSavedFilters(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateSavedFilter createSavedFilter() {
    return new APIRequestCreateSavedFilter(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetSavedMessageResponses getSavedMessageResponses() {
    return new APIRequestGetSavedMessageResponses(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateSavedMessageResponse createSavedMessageResponse() {
    return new APIRequestCreateSavedMessageResponse(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetScheduleDPosts getScheduleDPosts() {
    return new APIRequestGetScheduleDPosts(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetScreenNames getScreenNames() {
    return new APIRequestGetScreenNames(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetSeasons getSeasons() {
    return new APIRequestGetSeasons(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetSecondaryReceivers getSecondaryReceivers() {
    return new APIRequestGetSecondaryReceivers(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetSettings getSettings() {
    return new APIRequestGetSettings(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateSetting createSetting() {
    return new APIRequestCreateSetting(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetShowPlaylists getShowPlaylists() {
    return new APIRequestGetShowPlaylists(this.getPrefixedId().toString(), context);
  }

  public APIRequestDeleteSubscribedApps deleteSubscribedApps() {
    return new APIRequestDeleteSubscribedApps(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetSubscribedApps getSubscribedApps() {
    return new APIRequestGetSubscribedApps(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateSubscribedApp createSubscribedApp() {
    return new APIRequestCreateSubscribedApp(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateSubscription createSubscription() {
    return new APIRequestCreateSubscription(this.getPrefixedId().toString(), context);
  }

  public APIRequestDeleteTabs deleteTabs() {
    return new APIRequestDeleteTabs(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetTabs getTabs() {
    return new APIRequestGetTabs(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateTab createTab() {
    return new APIRequestCreateTab(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetTagged getTagged() {
    return new APIRequestGetTagged(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateTakeThreadControl createTakeThreadControl() {
    return new APIRequestCreateTakeThreadControl(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetThreadOwner getThreadOwner() {
    return new APIRequestGetThreadOwner(this.getPrefixedId().toString(), context);
  }

  public APIRequestDeleteThreadSettings deleteThreadSettings() {
    return new APIRequestDeleteThreadSettings(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetThreadSettings getThreadSettings() {
    return new APIRequestGetThreadSettings(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateThreadSetting createThreadSetting() {
    return new APIRequestCreateThreadSetting(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetThreads getThreads() {
    return new APIRequestGetThreads(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetTours getTours() {
    return new APIRequestGetTours(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateUnlinkAccount createUnlinkAccount() {
    return new APIRequestCreateUnlinkAccount(this.getPrefixedId().toString(), context);
  }

  public APIRequestDeleteUserPermissions deleteUserPermissions() {
    return new APIRequestDeleteUserPermissions(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateUserPermission createUserPermission() {
    return new APIRequestCreateUserPermission(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetVideoBroadcasts getVideoBroadcasts() {
    return new APIRequestGetVideoBroadcasts(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetVideoCopyrightRules getVideoCopyrightRules() {
    return new APIRequestGetVideoCopyrightRules(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateVideoCopyrightRule createVideoCopyrightRule() {
    return new APIRequestCreateVideoCopyrightRule(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetVideoCopyrights getVideoCopyrights() {
    return new APIRequestGetVideoCopyrights(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateVideoCopyright createVideoCopyright() {
    return new APIRequestCreateVideoCopyright(this.getPrefixedId().toString(), context);
  }

  public APIRequestDeleteVideoLists deleteVideoLists() {
    return new APIRequestDeleteVideoLists(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetVideoLists getVideoLists() {
    return new APIRequestGetVideoLists(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateVideoList createVideoList() {
    return new APIRequestCreateVideoList(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetVideoMediaCopyrights getVideoMediaCopyrights() {
    return new APIRequestGetVideoMediaCopyrights(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetVideos getVideos() {
    return new APIRequestGetVideos(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateVideo createVideo() {
    return new APIRequestCreateVideo(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetVideosYouCanUse getVideosYouCanUse() {
    return new APIRequestGetVideosYouCanUse(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetVisitorPosts getVisitorPosts() {
    return new APIRequestGetVisitorPosts(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetWorkFlows getWorkFlows() {
    return new APIRequestGetWorkFlows(this.getPrefixedId().toString(), context);
  }

  public APIRequestGet get() {
    return new APIRequestGet(this.getPrefixedId().toString(), context);
  }

  public APIRequestUpdate update() {
    return new APIRequestUpdate(this.getPrefixedId().toString(), context);
  }


  public String getFieldAbout() {
    return mAbout;
  }

  public String getFieldAccessToken() {
    return mAccessToken;
  }

  public AdSet getFieldAdCampaign() {
    if (mAdCampaign != null) {
      mAdCampaign.context = getContext();
    }
    return mAdCampaign;
  }

  public String getFieldAffiliation() {
    return mAffiliation;
  }

  public String getFieldAppId() {
    return mAppId;
  }

  public AppLinks getFieldAppLinks() {
    if (mAppLinks != null) {
      mAppLinks.context = getContext();
    }
    return mAppLinks;
  }

  public String getFieldArtistsWeLike() {
    return mArtistsWeLike;
  }

  public String getFieldAttire() {
    return mAttire;
  }

  public String getFieldAwards() {
    return mAwards;
  }

  public String getFieldBandInterests() {
    return mBandInterests;
  }

  public String getFieldBandMembers() {
    return mBandMembers;
  }

  public Page getFieldBestPage() {
    if (mBestPage != null) {
      mBestPage.context = getContext();
    }
    return mBestPage;
  }

  public String getFieldBio() {
    return mBio;
  }

  public String getFieldBirthday() {
    return mBirthday;
  }

  public String getFieldBookingAgent() {
    return mBookingAgent;
  }

  public String getFieldBuilt() {
    return mBuilt;
  }

  public Object getFieldBusiness() {
    return mBusiness;
  }

  public Boolean getFieldCanCheckin() {
    return mCanCheckin;
  }

  public Boolean getFieldCanPost() {
    return mCanPost;
  }

  public String getFieldCategory() {
    return mCategory;
  }

  public List<PageCategory> getFieldCategoryList() {
    return mCategoryList;
  }

  public Long getFieldCheckins() {
    return mCheckins;
  }

  public String getFieldCompanyOverview() {
    return mCompanyOverview;
  }

  public ShadowIGUser getFieldConnectedInstagramAccount() {
    if (mConnectedInstagramAccount != null) {
      mConnectedInstagramAccount.context = getContext();
    }
    return mConnectedInstagramAccount;
  }

  public MailingAddress getFieldContactAddress() {
    if (mContactAddress != null) {
      mContactAddress.context = getContext();
    }
    return mContactAddress;
  }

  public OpenGraphContext getFieldContext() {
    if (mContext != null) {
      mContext.context = getContext();
    }
    return mContext;
  }

  public CopyrightAttributionInsights getFieldCopyrightAttributionInsights() {
    if (mCopyrightAttributionInsights != null) {
      mCopyrightAttributionInsights.context = getContext();
    }
    return mCopyrightAttributionInsights;
  }

  public List<String> getFieldCopyrightWhitelistedIgPartners() {
    return mCopyrightWhitelistedIgPartners;
  }

  public Long getFieldCountryPageLikes() {
    return mCountryPageLikes;
  }

  public CoverPhoto getFieldCover() {
    if (mCover != null) {
      mCover.context = getContext();
    }
    return mCover;
  }

  public String getFieldCulinaryTeam() {
    return mCulinaryTeam;
  }

  public String getFieldCurrentLocation() {
    return mCurrentLocation;
  }

  public String getFieldDescription() {
    return mDescription;
  }

  public String getFieldDescriptionHtml() {
    return mDescriptionHtml;
  }

  public String getFieldDirectedBy() {
    return mDirectedBy;
  }

  public String getFieldDisplaySubtext() {
    return mDisplaySubtext;
  }

  public String getFieldDisplayedMessageResponseTime() {
    return mDisplayedMessageResponseTime;
  }

  public List<String> getFieldEmails() {
    return mEmails;
  }

  public Engagement getFieldEngagement() {
    if (mEngagement != null) {
      mEngagement.context = getContext();
    }
    return mEngagement;
  }

  public Long getFieldFanCount() {
    return mFanCount;
  }

  public AdVideo getFieldFeaturedVideo() {
    if (mFeaturedVideo != null) {
      mFeaturedVideo.context = getContext();
    }
    return mFeaturedVideo;
  }

  public String getFieldFeatures() {
    return mFeatures;
  }

  public List<String> getFieldFoodStyles() {
    return mFoodStyles;
  }

  public String getFieldFounded() {
    return mFounded;
  }

  public String getFieldGeneralInfo() {
    return mGeneralInfo;
  }

  public String getFieldGeneralManager() {
    return mGeneralManager;
  }

  public String getFieldGenre() {
    return mGenre;
  }

  public String getFieldGlobalBrandPageName() {
    return mGlobalBrandPageName;
  }

  public Page getFieldGlobalBrandParentPage() {
    if (mGlobalBrandParentPage != null) {
      mGlobalBrandParentPage.context = getContext();
    }
    return mGlobalBrandParentPage;
  }

  public String getFieldGlobalBrandRootId() {
    return mGlobalBrandRootId;
  }

  public Boolean getFieldHasAddedApp() {
    return mHasAddedApp;
  }

  public Boolean getFieldHasWhatsappBusinessNumber() {
    return mHasWhatsappBusinessNumber;
  }

  public Boolean getFieldHasWhatsappNumber() {
    return mHasWhatsappNumber;
  }

  public String getFieldHometown() {
    return mHometown;
  }

  public Map<String, String> getFieldHours() {
    return mHours;
  }

  public String getFieldId() {
    return mId;
  }

  public String getFieldImpressum() {
    return mImpressum;
  }

  public String getFieldInfluences() {
    return mInfluences;
  }

  public ShadowIGUser getFieldInstagramBusinessAccount() {
    if (mInstagramBusinessAccount != null) {
      mInstagramBusinessAccount.context = getContext();
    }
    return mInstagramBusinessAccount;
  }

  public String getFieldInstantArticlesReviewStatus() {
    return mInstantArticlesReviewStatus;
  }

  public Boolean getFieldIsAlwaysOpen() {
    return mIsAlwaysOpen;
  }

  public Boolean getFieldIsChain() {
    return mIsChain;
  }

  public Boolean getFieldIsCommunityPage() {
    return mIsCommunityPage;
  }

  public Boolean getFieldIsEligibleForBrandedContent() {
    return mIsEligibleForBrandedContent;
  }

  public Boolean getFieldIsMessengerBotGetStartedEnabled() {
    return mIsMessengerBotGetStartedEnabled;
  }

  public Boolean getFieldIsMessengerPlatformBot() {
    return mIsMessengerPlatformBot;
  }

  public Boolean getFieldIsOwned() {
    return mIsOwned;
  }

  public Boolean getFieldIsPermanentlyClosed() {
    return mIsPermanentlyClosed;
  }

  public Boolean getFieldIsPublished() {
    return mIsPublished;
  }

  public Boolean getFieldIsUnclaimed() {
    return mIsUnclaimed;
  }

  public Boolean getFieldIsVerified() {
    return mIsVerified;
  }

  public Boolean getFieldIsWebhooksSubscribed() {
    return mIsWebhooksSubscribed;
  }

  public Object getFieldKeywords() {
    return mKeywords;
  }

  public LeadGenFormPreviewDetails getFieldLeadgenFormPreviewDetails() {
    if (mLeadgenFormPreviewDetails != null) {
      mLeadgenFormPreviewDetails.context = getContext();
    }
    return mLeadgenFormPreviewDetails;
  }

  public Boolean getFieldLeadgenHasCrmIntegration() {
    return mLeadgenHasCrmIntegration;
  }

  public Boolean getFieldLeadgenHasFatPingCrmIntegration() {
    return mLeadgenHasFatPingCrmIntegration;
  }

  public String getFieldLeadgenTosAcceptanceTime() {
    return mLeadgenTosAcceptanceTime;
  }

  public Boolean getFieldLeadgenTosAccepted() {
    return mLeadgenTosAccepted;
  }

  public User getFieldLeadgenTosAcceptingUser() {
    if (mLeadgenTosAcceptingUser != null) {
      mLeadgenTosAcceptingUser.context = getContext();
    }
    return mLeadgenTosAcceptingUser;
  }

  public String getFieldLink() {
    return mLink;
  }

  public Location getFieldLocation() {
    if (mLocation != null) {
      mLocation.context = getContext();
    }
    return mLocation;
  }

  public String getFieldMembers() {
    return mMembers;
  }

  public String getFieldMerchantId() {
    return mMerchantId;
  }

  public String getFieldMerchantReviewStatus() {
    return mMerchantReviewStatus;
  }

  public List<String> getFieldMessengerAdsDefaultIcebreakers() {
    return mMessengerAdsDefaultIcebreakers;
  }

  public MessengerDestinationPageWelcomeMessage getFieldMessengerAdsDefaultPageWelcomeMessage() {
    if (mMessengerAdsDefaultPageWelcomeMessage != null) {
      mMessengerAdsDefaultPageWelcomeMessage.context = getContext();
    }
    return mMessengerAdsDefaultPageWelcomeMessage;
  }

  public List<String> getFieldMessengerAdsDefaultQuickReplies() {
    return mMessengerAdsDefaultQuickReplies;
  }

  public String getFieldMessengerAdsQuickRepliesType() {
    return mMessengerAdsQuickRepliesType;
  }

  public String getFieldMission() {
    return mMission;
  }

  public String getFieldMpg() {
    return mMpg;
  }

  public String getFieldName() {
    return mName;
  }

  public String getFieldNameWithLocationDescriptor() {
    return mNameWithLocationDescriptor;
  }

  public String getFieldNetwork() {
    return mNetwork;
  }

  public Long getFieldNewLikeCount() {
    return mNewLikeCount;
  }

  public Boolean getFieldOfferEligible() {
    return mOfferEligible;
  }

  public Double getFieldOverallStarRating() {
    return mOverallStarRating;
  }

  public String getFieldPageToken() {
    return mPageToken;
  }

  public Page getFieldParentPage() {
    if (mParentPage != null) {
      mParentPage.context = getContext();
    }
    return mParentPage;
  }

  public PageParking getFieldParking() {
    if (mParking != null) {
      mParking.context = getContext();
    }
    return mParking;
  }

  public PagePaymentOptions getFieldPaymentOptions() {
    if (mPaymentOptions != null) {
      mPaymentOptions.context = getContext();
    }
    return mPaymentOptions;
  }

  public String getFieldPersonalInfo() {
    return mPersonalInfo;
  }

  public String getFieldPersonalInterests() {
    return mPersonalInterests;
  }

  public String getFieldPharmaSafetyInfo() {
    return mPharmaSafetyInfo;
  }

  public String getFieldPhone() {
    return mPhone;
  }

  public String getFieldPlaceType() {
    return mPlaceType;
  }

  public String getFieldPlotOutline() {
    return mPlotOutline;
  }

  public Targeting getFieldPreferredAudience() {
    if (mPreferredAudience != null) {
      mPreferredAudience.context = getContext();
    }
    return mPreferredAudience;
  }

  public String getFieldPressContact() {
    return mPressContact;
  }

  public String getFieldPriceRange() {
    return mPriceRange;
  }

  public String getFieldProducedBy() {
    return mProducedBy;
  }

  public String getFieldProducts() {
    return mProducts;
  }

  public Boolean getFieldPromotionEligible() {
    return mPromotionEligible;
  }

  public String getFieldPromotionIneligibleReason() {
    return mPromotionIneligibleReason;
  }

  public String getFieldPublicTransit() {
    return mPublicTransit;
  }

  public PublisherSpace getFieldPublisherSpace() {
    if (mPublisherSpace != null) {
      mPublisherSpace.context = getContext();
    }
    return mPublisherSpace;
  }

  public Long getFieldRatingCount() {
    return mRatingCount;
  }

  public String getFieldRecipient() {
    return mRecipient;
  }

  public String getFieldRecordLabel() {
    return mRecordLabel;
  }

  public String getFieldReleaseDate() {
    return mReleaseDate;
  }

  public PageRestaurantServices getFieldRestaurantServices() {
    if (mRestaurantServices != null) {
      mRestaurantServices.context = getContext();
    }
    return mRestaurantServices;
  }

  public PageRestaurantSpecialties getFieldRestaurantSpecialties() {
    if (mRestaurantSpecialties != null) {
      mRestaurantSpecialties.context = getContext();
    }
    return mRestaurantSpecialties;
  }

  public String getFieldSchedule() {
    return mSchedule;
  }

  public String getFieldScreenplayBy() {
    return mScreenplayBy;
  }

  public String getFieldSeason() {
    return mSeason;
  }

  public String getFieldSingleLineAddress() {
    return mSingleLineAddress;
  }

  public String getFieldStarring() {
    return mStarring;
  }

  public PageStartInfo getFieldStartInfo() {
    if (mStartInfo != null) {
      mStartInfo.context = getContext();
    }
    return mStartInfo;
  }

  public String getFieldStoreCode() {
    return mStoreCode;
  }

  public String getFieldStoreLocationDescriptor() {
    return mStoreLocationDescriptor;
  }

  public Long getFieldStoreNumber() {
    return mStoreNumber;
  }

  public String getFieldStudio() {
    return mStudio;
  }

  public Boolean getFieldSupportsInstantArticles() {
    return mSupportsInstantArticles;
  }

  public Long getFieldTalkingAboutCount() {
    return mTalkingAboutCount;
  }

  public Long getFieldUnreadMessageCount() {
    return mUnreadMessageCount;
  }

  public Long getFieldUnreadNotifCount() {
    return mUnreadNotifCount;
  }

  public Long getFieldUnseenMessageCount() {
    return mUnseenMessageCount;
  }

  public String getFieldUsername() {
    return mUsername;
  }

  public String getFieldVerificationStatus() {
    return mVerificationStatus;
  }

  public VoipInfo getFieldVoipInfo() {
    if (mVoipInfo != null) {
      mVoipInfo.context = getContext();
    }
    return mVoipInfo;
  }

  public String getFieldWebsite() {
    return mWebsite;
  }

  public Long getFieldWereHereCount() {
    return mWereHereCount;
  }

  public String getFieldWhatsappNumber() {
    return mWhatsappNumber;
  }

  public String getFieldWrittenBy() {
    return mWrittenBy;
  }



  public static class APIRequestCreateActivity extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "page_scoped_user_id",
      "user_ref",
      "advertiser_tracking_enabled",
      "custom_events",
      "app_id",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response) throws APIException {
      return Page.parseResponse(response, getContext(), this).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, Page>() {
           public Page apply(String result) {
             try {
               return APIRequestCreateActivity.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateActivity(String nodeId, APIContext context) {
      super(context, nodeId, "/activities", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateActivity setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateActivity setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateActivity setPageScopedUserId (Long pageScopedUserId) {
      this.setParam("page_scoped_user_id", pageScopedUserId);
      return this;
    }
    public APIRequestCreateActivity setPageScopedUserId (String pageScopedUserId) {
      this.setParam("page_scoped_user_id", pageScopedUserId);
      return this;
    }

    public APIRequestCreateActivity setUserRef (String userRef) {
      this.setParam("user_ref", userRef);
      return this;
    }

    public APIRequestCreateActivity setAdvertiserTrackingEnabled (Boolean advertiserTrackingEnabled) {
      this.setParam("advertiser_tracking_enabled", advertiserTrackingEnabled);
      return this;
    }
    public APIRequestCreateActivity setAdvertiserTrackingEnabled (String advertiserTrackingEnabled) {
      this.setParam("advertiser_tracking_enabled", advertiserTrackingEnabled);
      return this;
    }

    public APIRequestCreateActivity setCustomEvents (List<Object> customEvents) {
      this.setParam("custom_events", customEvents);
      return this;
    }
    public APIRequestCreateActivity setCustomEvents (String customEvents) {
      this.setParam("custom_events", customEvents);
      return this;
    }

    public APIRequestCreateActivity setAppId (Object appId) {
      this.setParam("app_id", appId);
      return this;
    }
    public APIRequestCreateActivity setAppId (String appId) {
      this.setParam("app_id", appId);
      return this;
    }

    public APIRequestCreateActivity requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateActivity requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateActivity requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateActivity requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateActivity requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateActivity requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetAdminNotes extends APIRequest<PageAdminNote> {

    APINodeList<PageAdminNote> lastResponse = null;
    @Override
    public APINodeList<PageAdminNote> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "body",
      "from",
      "id",
      "user",
    };

    @Override
    public APINodeList<PageAdminNote> parseResponse(String response) throws APIException {
      return PageAdminNote.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<PageAdminNote> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<PageAdminNote> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<PageAdminNote>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<PageAdminNote>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<PageAdminNote>>() {
           public APINodeList<PageAdminNote> apply(String result) {
             try {
               return APIRequestGetAdminNotes.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetAdminNotes(String nodeId, APIContext context) {
      super(context, nodeId, "/admin_notes", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetAdminNotes setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetAdminNotes setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetAdminNotes requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetAdminNotes requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetAdminNotes requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetAdminNotes requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetAdminNotes requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetAdminNotes requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetAdminNotes requestBodyField () {
      return this.requestBodyField(true);
    }
    public APIRequestGetAdminNotes requestBodyField (boolean value) {
      this.requestField("body", value);
      return this;
    }
    public APIRequestGetAdminNotes requestFromField () {
      return this.requestFromField(true);
    }
    public APIRequestGetAdminNotes requestFromField (boolean value) {
      this.requestField("from", value);
      return this;
    }
    public APIRequestGetAdminNotes requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetAdminNotes requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetAdminNotes requestUserField () {
      return this.requestUserField(true);
    }
    public APIRequestGetAdminNotes requestUserField (boolean value) {
      this.requestField("user", value);
      return this;
    }
  }

  public static class APIRequestCreateAdminNote extends APIRequest<PageAdminNote> {

    PageAdminNote lastResponse = null;
    @Override
    public PageAdminNote getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "body",
      "user_id",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public PageAdminNote parseResponse(String response) throws APIException {
      return PageAdminNote.parseResponse(response, getContext(), this).head();
    }

    @Override
    public PageAdminNote execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public PageAdminNote execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<PageAdminNote> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<PageAdminNote> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, PageAdminNote>() {
           public PageAdminNote apply(String result) {
             try {
               return APIRequestCreateAdminNote.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateAdminNote(String nodeId, APIContext context) {
      super(context, nodeId, "/admin_notes", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateAdminNote setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateAdminNote setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateAdminNote setBody (String body) {
      this.setParam("body", body);
      return this;
    }

    public APIRequestCreateAdminNote setUserId (Long userId) {
      this.setParam("user_id", userId);
      return this;
    }
    public APIRequestCreateAdminNote setUserId (String userId) {
      this.setParam("user_id", userId);
      return this;
    }

    public APIRequestCreateAdminNote requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateAdminNote requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateAdminNote requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateAdminNote requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateAdminNote requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateAdminNote requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestCreateAdminSetting extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "setting",
      "value",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response) throws APIException {
      return Page.parseResponse(response, getContext(), this).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, Page>() {
           public Page apply(String result) {
             try {
               return APIRequestCreateAdminSetting.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateAdminSetting(String nodeId, APIContext context) {
      super(context, nodeId, "/admin_settings", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateAdminSetting setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateAdminSetting setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateAdminSetting setSetting (Page.EnumSetting setting) {
      this.setParam("setting", setting);
      return this;
    }
    public APIRequestCreateAdminSetting setSetting (String setting) {
      this.setParam("setting", setting);
      return this;
    }

    public APIRequestCreateAdminSetting setValue (Boolean value) {
      this.setParam("value", value);
      return this;
    }
    public APIRequestCreateAdminSetting setValue (String value) {
      this.setParam("value", value);
      return this;
    }

    public APIRequestCreateAdminSetting requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateAdminSetting requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateAdminSetting requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateAdminSetting requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateAdminSetting requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateAdminSetting requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestDeleteAdmins extends APIRequest<APINode> {

    APINodeList<APINode> lastResponse = null;
    @Override
    public APINodeList<APINode> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "trusted",
      "admin_id",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINodeList<APINode> parseResponse(String response) throws APIException {
      return APINode.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<APINode> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<APINode>>() {
           public APINodeList<APINode> apply(String result) {
             try {
               return APIRequestDeleteAdmins.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestDeleteAdmins(String nodeId, APIContext context) {
      super(context, nodeId, "/admins", "DELETE", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestDeleteAdmins setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestDeleteAdmins setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestDeleteAdmins setTrusted (Boolean trusted) {
      this.setParam("trusted", trusted);
      return this;
    }
    public APIRequestDeleteAdmins setTrusted (String trusted) {
      this.setParam("trusted", trusted);
      return this;
    }

    public APIRequestDeleteAdmins setAdminId (Long adminId) {
      this.setParam("admin_id", adminId);
      return this;
    }
    public APIRequestDeleteAdmins setAdminId (String adminId) {
      this.setParam("admin_id", adminId);
      return this;
    }

    public APIRequestDeleteAdmins requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestDeleteAdmins requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteAdmins requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestDeleteAdmins requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteAdmins requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestDeleteAdmins requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestCreateAdmin extends APIRequest<User> {

    User lastResponse = null;
    @Override
    public User getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "trusted",
      "admin_id",
      "tasks",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public User parseResponse(String response) throws APIException {
      return User.parseResponse(response, getContext(), this).head();
    }

    @Override
    public User execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public User execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<User> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<User> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, User>() {
           public User apply(String result) {
             try {
               return APIRequestCreateAdmin.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateAdmin(String nodeId, APIContext context) {
      super(context, nodeId, "/admins", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateAdmin setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateAdmin setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateAdmin setTrusted (Boolean trusted) {
      this.setParam("trusted", trusted);
      return this;
    }
    public APIRequestCreateAdmin setTrusted (String trusted) {
      this.setParam("trusted", trusted);
      return this;
    }

    public APIRequestCreateAdmin setAdminId (Long adminId) {
      this.setParam("admin_id", adminId);
      return this;
    }
    public APIRequestCreateAdmin setAdminId (String adminId) {
      this.setParam("admin_id", adminId);
      return this;
    }

    public APIRequestCreateAdmin setTasks (List<User.EnumTasks> tasks) {
      this.setParam("tasks", tasks);
      return this;
    }
    public APIRequestCreateAdmin setTasks (String tasks) {
      this.setParam("tasks", tasks);
      return this;
    }

    public APIRequestCreateAdmin requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateAdmin requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateAdmin requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateAdmin requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateAdmin requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateAdmin requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestCreateAdminStickySetting extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "budget",
      "currency",
      "ad_account_id",
      "audience",
      "targeting",
      "campaign_length",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response) throws APIException {
      return Page.parseResponse(response, getContext(), this).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, Page>() {
           public Page apply(String result) {
             try {
               return APIRequestCreateAdminStickySetting.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateAdminStickySetting(String nodeId, APIContext context) {
      super(context, nodeId, "/adminstickysettings", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateAdminStickySetting setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateAdminStickySetting setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateAdminStickySetting setBudget (Long budget) {
      this.setParam("budget", budget);
      return this;
    }
    public APIRequestCreateAdminStickySetting setBudget (String budget) {
      this.setParam("budget", budget);
      return this;
    }

    public APIRequestCreateAdminStickySetting setCurrency (String currency) {
      this.setParam("currency", currency);
      return this;
    }

    public APIRequestCreateAdminStickySetting setAdAccountId (String adAccountId) {
      this.setParam("ad_account_id", adAccountId);
      return this;
    }

    public APIRequestCreateAdminStickySetting setAudience (Page.EnumAudience audience) {
      this.setParam("audience", audience);
      return this;
    }
    public APIRequestCreateAdminStickySetting setAudience (String audience) {
      this.setParam("audience", audience);
      return this;
    }

    public APIRequestCreateAdminStickySetting setTargeting (Targeting targeting) {
      this.setParam("targeting", targeting);
      return this;
    }
    public APIRequestCreateAdminStickySetting setTargeting (String targeting) {
      this.setParam("targeting", targeting);
      return this;
    }

    public APIRequestCreateAdminStickySetting setCampaignLength (String campaignLength) {
      this.setParam("campaign_length", campaignLength);
      return this;
    }

    public APIRequestCreateAdminStickySetting requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateAdminStickySetting requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateAdminStickySetting requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateAdminStickySetting requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateAdminStickySetting requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateAdminStickySetting requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestDeleteAgencies extends APIRequest<APINode> {

    APINodeList<APINode> lastResponse = null;
    @Override
    public APINodeList<APINode> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "business",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINodeList<APINode> parseResponse(String response) throws APIException {
      return APINode.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<APINode> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<APINode>>() {
           public APINodeList<APINode> apply(String result) {
             try {
               return APIRequestDeleteAgencies.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestDeleteAgencies(String nodeId, APIContext context) {
      super(context, nodeId, "/agencies", "DELETE", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestDeleteAgencies setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestDeleteAgencies setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestDeleteAgencies setBusiness (String business) {
      this.setParam("business", business);
      return this;
    }

    public APIRequestDeleteAgencies requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestDeleteAgencies requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteAgencies requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestDeleteAgencies requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteAgencies requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestDeleteAgencies requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetAgencies extends APIRequest<Business> {

    APINodeList<Business> lastResponse = null;
    @Override
    public APINodeList<Business> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "block_offline_analytics",
      "created_by",
      "created_time",
      "extended_updated_time",
      "id",
      "is_hidden",
      "is_instagram_enabled_in_fb_analytics",
      "link",
      "name",
      "primary_page",
      "profile_picture_uri",
      "timezone_id",
      "two_factor_type",
      "updated_by",
      "updated_time",
      "verification_status",
      "vertical",
      "vertical_id",
    };

    @Override
    public APINodeList<Business> parseResponse(String response) throws APIException {
      return Business.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<Business> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Business> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Business>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Business>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<Business>>() {
           public APINodeList<Business> apply(String result) {
             try {
               return APIRequestGetAgencies.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetAgencies(String nodeId, APIContext context) {
      super(context, nodeId, "/agencies", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetAgencies setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetAgencies setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetAgencies requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetAgencies requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetAgencies requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetAgencies requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetAgencies requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetAgencies requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetAgencies requestBlockOfflineAnalyticsField () {
      return this.requestBlockOfflineAnalyticsField(true);
    }
    public APIRequestGetAgencies requestBlockOfflineAnalyticsField (boolean value) {
      this.requestField("block_offline_analytics", value);
      return this;
    }
    public APIRequestGetAgencies requestCreatedByField () {
      return this.requestCreatedByField(true);
    }
    public APIRequestGetAgencies requestCreatedByField (boolean value) {
      this.requestField("created_by", value);
      return this;
    }
    public APIRequestGetAgencies requestCreatedTimeField () {
      return this.requestCreatedTimeField(true);
    }
    public APIRequestGetAgencies requestCreatedTimeField (boolean value) {
      this.requestField("created_time", value);
      return this;
    }
    public APIRequestGetAgencies requestExtendedUpdatedTimeField () {
      return this.requestExtendedUpdatedTimeField(true);
    }
    public APIRequestGetAgencies requestExtendedUpdatedTimeField (boolean value) {
      this.requestField("extended_updated_time", value);
      return this;
    }
    public APIRequestGetAgencies requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetAgencies requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetAgencies requestIsHiddenField () {
      return this.requestIsHiddenField(true);
    }
    public APIRequestGetAgencies requestIsHiddenField (boolean value) {
      this.requestField("is_hidden", value);
      return this;
    }
    public APIRequestGetAgencies requestIsInstagramEnabledInFbAnalyticsField () {
      return this.requestIsInstagramEnabledInFbAnalyticsField(true);
    }
    public APIRequestGetAgencies requestIsInstagramEnabledInFbAnalyticsField (boolean value) {
      this.requestField("is_instagram_enabled_in_fb_analytics", value);
      return this;
    }
    public APIRequestGetAgencies requestLinkField () {
      return this.requestLinkField(true);
    }
    public APIRequestGetAgencies requestLinkField (boolean value) {
      this.requestField("link", value);
      return this;
    }
    public APIRequestGetAgencies requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetAgencies requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetAgencies requestPrimaryPageField () {
      return this.requestPrimaryPageField(true);
    }
    public APIRequestGetAgencies requestPrimaryPageField (boolean value) {
      this.requestField("primary_page", value);
      return this;
    }
    public APIRequestGetAgencies requestProfilePictureUriField () {
      return this.requestProfilePictureUriField(true);
    }
    public APIRequestGetAgencies requestProfilePictureUriField (boolean value) {
      this.requestField("profile_picture_uri", value);
      return this;
    }
    public APIRequestGetAgencies requestTimezoneIdField () {
      return this.requestTimezoneIdField(true);
    }
    public APIRequestGetAgencies requestTimezoneIdField (boolean value) {
      this.requestField("timezone_id", value);
      return this;
    }
    public APIRequestGetAgencies requestTwoFactorTypeField () {
      return this.requestTwoFactorTypeField(true);
    }
    public APIRequestGetAgencies requestTwoFactorTypeField (boolean value) {
      this.requestField("two_factor_type", value);
      return this;
    }
    public APIRequestGetAgencies requestUpdatedByField () {
      return this.requestUpdatedByField(true);
    }
    public APIRequestGetAgencies requestUpdatedByField (boolean value) {
      this.requestField("updated_by", value);
      return this;
    }
    public APIRequestGetAgencies requestUpdatedTimeField () {
      return this.requestUpdatedTimeField(true);
    }
    public APIRequestGetAgencies requestUpdatedTimeField (boolean value) {
      this.requestField("updated_time", value);
      return this;
    }
    public APIRequestGetAgencies requestVerificationStatusField () {
      return this.requestVerificationStatusField(true);
    }
    public APIRequestGetAgencies requestVerificationStatusField (boolean value) {
      this.requestField("verification_status", value);
      return this;
    }
    public APIRequestGetAgencies requestVerticalField () {
      return this.requestVerticalField(true);
    }
    public APIRequestGetAgencies requestVerticalField (boolean value) {
      this.requestField("vertical", value);
      return this;
    }
    public APIRequestGetAgencies requestVerticalIdField () {
      return this.requestVerticalIdField(true);
    }
    public APIRequestGetAgencies requestVerticalIdField (boolean value) {
      this.requestField("vertical_id", value);
      return this;
    }
  }

  public static class APIRequestCreateAgency extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "business",
      "permitted_tasks",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response) throws APIException {
      return Page.parseResponse(response, getContext(), this).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, Page>() {
           public Page apply(String result) {
             try {
               return APIRequestCreateAgency.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateAgency(String nodeId, APIContext context) {
      super(context, nodeId, "/agencies", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateAgency setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateAgency setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateAgency setBusiness (String business) {
      this.setParam("business", business);
      return this;
    }

    public APIRequestCreateAgency setPermittedTasks (List<Page.EnumPermittedTasks> permittedTasks) {
      this.setParam("permitted_tasks", permittedTasks);
      return this;
    }
    public APIRequestCreateAgency setPermittedTasks (String permittedTasks) {
      this.setParam("permitted_tasks", permittedTasks);
      return this;
    }

    public APIRequestCreateAgency requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateAgency requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateAgency requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateAgency requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateAgency requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateAgency requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetAlbums extends APIRequest<Album> {

    APINodeList<Album> lastResponse = null;
    @Override
    public APINodeList<Album> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "backdated_time",
      "backdated_time_granularity",
      "can_backdate",
      "can_upload",
      "count",
      "cover_photo",
      "created_time",
      "description",
      "edit_link",
      "event",
      "from",
      "id",
      "is_user_facing",
      "link",
      "location",
      "modified_major",
      "name",
      "photo_count",
      "place",
      "privacy",
      "type",
      "updated_time",
      "video_count",
    };

    @Override
    public APINodeList<Album> parseResponse(String response) throws APIException {
      return Album.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<Album> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Album> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Album>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Album>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<Album>>() {
           public APINodeList<Album> apply(String result) {
             try {
               return APIRequestGetAlbums.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetAlbums(String nodeId, APIContext context) {
      super(context, nodeId, "/albums", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetAlbums setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetAlbums setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetAlbums requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetAlbums requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetAlbums requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetAlbums requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetAlbums requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetAlbums requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetAlbums requestBackdatedTimeField () {
      return this.requestBackdatedTimeField(true);
    }
    public APIRequestGetAlbums requestBackdatedTimeField (boolean value) {
      this.requestField("backdated_time", value);
      return this;
    }
    public APIRequestGetAlbums requestBackdatedTimeGranularityField () {
      return this.requestBackdatedTimeGranularityField(true);
    }
    public APIRequestGetAlbums requestBackdatedTimeGranularityField (boolean value) {
      this.requestField("backdated_time_granularity", value);
      return this;
    }
    public APIRequestGetAlbums requestCanBackdateField () {
      return this.requestCanBackdateField(true);
    }
    public APIRequestGetAlbums requestCanBackdateField (boolean value) {
      this.requestField("can_backdate", value);
      return this;
    }
    public APIRequestGetAlbums requestCanUploadField () {
      return this.requestCanUploadField(true);
    }
    public APIRequestGetAlbums requestCanUploadField (boolean value) {
      this.requestField("can_upload", value);
      return this;
    }
    public APIRequestGetAlbums requestCountField () {
      return this.requestCountField(true);
    }
    public APIRequestGetAlbums requestCountField (boolean value) {
      this.requestField("count", value);
      return this;
    }
    public APIRequestGetAlbums requestCoverPhotoField () {
      return this.requestCoverPhotoField(true);
    }
    public APIRequestGetAlbums requestCoverPhotoField (boolean value) {
      this.requestField("cover_photo", value);
      return this;
    }
    public APIRequestGetAlbums requestCreatedTimeField () {
      return this.requestCreatedTimeField(true);
    }
    public APIRequestGetAlbums requestCreatedTimeField (boolean value) {
      this.requestField("created_time", value);
      return this;
    }
    public APIRequestGetAlbums requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetAlbums requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetAlbums requestEditLinkField () {
      return this.requestEditLinkField(true);
    }
    public APIRequestGetAlbums requestEditLinkField (boolean value) {
      this.requestField("edit_link", value);
      return this;
    }
    public APIRequestGetAlbums requestEventField () {
      return this.requestEventField(true);
    }
    public APIRequestGetAlbums requestEventField (boolean value) {
      this.requestField("event", value);
      return this;
    }
    public APIRequestGetAlbums requestFromField () {
      return this.requestFromField(true);
    }
    public APIRequestGetAlbums requestFromField (boolean value) {
      this.requestField("from", value);
      return this;
    }
    public APIRequestGetAlbums requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetAlbums requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetAlbums requestIsUserFacingField () {
      return this.requestIsUserFacingField(true);
    }
    public APIRequestGetAlbums requestIsUserFacingField (boolean value) {
      this.requestField("is_user_facing", value);
      return this;
    }
    public APIRequestGetAlbums requestLinkField () {
      return this.requestLinkField(true);
    }
    public APIRequestGetAlbums requestLinkField (boolean value) {
      this.requestField("link", value);
      return this;
    }
    public APIRequestGetAlbums requestLocationField () {
      return this.requestLocationField(true);
    }
    public APIRequestGetAlbums requestLocationField (boolean value) {
      this.requestField("location", value);
      return this;
    }
    public APIRequestGetAlbums requestModifiedMajorField () {
      return this.requestModifiedMajorField(true);
    }
    public APIRequestGetAlbums requestModifiedMajorField (boolean value) {
      this.requestField("modified_major", value);
      return this;
    }
    public APIRequestGetAlbums requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetAlbums requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetAlbums requestPhotoCountField () {
      return this.requestPhotoCountField(true);
    }
    public APIRequestGetAlbums requestPhotoCountField (boolean value) {
      this.requestField("photo_count", value);
      return this;
    }
    public APIRequestGetAlbums requestPlaceField () {
      return this.requestPlaceField(true);
    }
    public APIRequestGetAlbums requestPlaceField (boolean value) {
      this.requestField("place", value);
      return this;
    }
    public APIRequestGetAlbums requestPrivacyField () {
      return this.requestPrivacyField(true);
    }
    public APIRequestGetAlbums requestPrivacyField (boolean value) {
      this.requestField("privacy", value);
      return this;
    }
    public APIRequestGetAlbums requestTypeField () {
      return this.requestTypeField(true);
    }
    public APIRequestGetAlbums requestTypeField (boolean value) {
      this.requestField("type", value);
      return this;
    }
    public APIRequestGetAlbums requestUpdatedTimeField () {
      return this.requestUpdatedTimeField(true);
    }
    public APIRequestGetAlbums requestUpdatedTimeField (boolean value) {
      this.requestField("updated_time", value);
      return this;
    }
    public APIRequestGetAlbums requestVideoCountField () {
      return this.requestVideoCountField(true);
    }
    public APIRequestGetAlbums requestVideoCountField (boolean value) {
      this.requestField("video_count", value);
      return this;
    }
  }

  public static class APIRequestCreateAlbum extends APIRequest<Album> {

    Album lastResponse = null;
    @Override
    public Album getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "is_default",
      "name",
      "description",
      "contributors",
      "make_shared_album",
      "location",
      "visible",
      "privacy",
      "place",
      "tags",
      "message",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Album parseResponse(String response) throws APIException {
      return Album.parseResponse(response, getContext(), this).head();
    }

    @Override
    public Album execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Album execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<Album> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Album> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, Album>() {
           public Album apply(String result) {
             try {
               return APIRequestCreateAlbum.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateAlbum(String nodeId, APIContext context) {
      super(context, nodeId, "/albums", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateAlbum setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateAlbum setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateAlbum setIsDefault (Boolean isDefault) {
      this.setParam("is_default", isDefault);
      return this;
    }
    public APIRequestCreateAlbum setIsDefault (String isDefault) {
      this.setParam("is_default", isDefault);
      return this;
    }

    public APIRequestCreateAlbum setName (String name) {
      this.setParam("name", name);
      return this;
    }

    public APIRequestCreateAlbum setDescription (String description) {
      this.setParam("description", description);
      return this;
    }

    public APIRequestCreateAlbum setContributors (List<Long> contributors) {
      this.setParam("contributors", contributors);
      return this;
    }
    public APIRequestCreateAlbum setContributors (String contributors) {
      this.setParam("contributors", contributors);
      return this;
    }

    public APIRequestCreateAlbum setMakeSharedAlbum (Boolean makeSharedAlbum) {
      this.setParam("make_shared_album", makeSharedAlbum);
      return this;
    }
    public APIRequestCreateAlbum setMakeSharedAlbum (String makeSharedAlbum) {
      this.setParam("make_shared_album", makeSharedAlbum);
      return this;
    }

    public APIRequestCreateAlbum setLocation (String location) {
      this.setParam("location", location);
      return this;
    }

    public APIRequestCreateAlbum setVisible (String visible) {
      this.setParam("visible", visible);
      return this;
    }

    public APIRequestCreateAlbum setPrivacy (Object privacy) {
      this.setParam("privacy", privacy);
      return this;
    }
    public APIRequestCreateAlbum setPrivacy (String privacy) {
      this.setParam("privacy", privacy);
      return this;
    }

    public APIRequestCreateAlbum setPlace (Object place) {
      this.setParam("place", place);
      return this;
    }
    public APIRequestCreateAlbum setPlace (String place) {
      this.setParam("place", place);
      return this;
    }

    public APIRequestCreateAlbum setTags (List<Long> tags) {
      this.setParam("tags", tags);
      return this;
    }
    public APIRequestCreateAlbum setTags (String tags) {
      this.setParam("tags", tags);
      return this;
    }

    public APIRequestCreateAlbum setMessage (String message) {
      this.setParam("message", message);
      return this;
    }

    public APIRequestCreateAlbum requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateAlbum requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateAlbum requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateAlbum requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateAlbum requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateAlbum requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetAsset3Ds extends APIRequest<WithAsset3D> {

    APINodeList<WithAsset3D> lastResponse = null;
    @Override
    public APINodeList<WithAsset3D> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "id",
    };

    @Override
    public APINodeList<WithAsset3D> parseResponse(String response) throws APIException {
      return WithAsset3D.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<WithAsset3D> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<WithAsset3D> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<WithAsset3D>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<WithAsset3D>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<WithAsset3D>>() {
           public APINodeList<WithAsset3D> apply(String result) {
             try {
               return APIRequestGetAsset3Ds.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetAsset3Ds(String nodeId, APIContext context) {
      super(context, nodeId, "/asset3ds", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetAsset3Ds setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetAsset3Ds setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetAsset3Ds requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetAsset3Ds requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetAsset3Ds requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetAsset3Ds requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetAsset3Ds requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetAsset3Ds requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetAsset3Ds requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetAsset3Ds requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
  }

  public static class APIRequestDeleteAssignedUsers extends APIRequest<APINode> {

    APINodeList<APINode> lastResponse = null;
    @Override
    public APINodeList<APINode> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "user",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINodeList<APINode> parseResponse(String response) throws APIException {
      return APINode.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<APINode> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<APINode>>() {
           public APINodeList<APINode> apply(String result) {
             try {
               return APIRequestDeleteAssignedUsers.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestDeleteAssignedUsers(String nodeId, APIContext context) {
      super(context, nodeId, "/assigned_users", "DELETE", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestDeleteAssignedUsers setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestDeleteAssignedUsers setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestDeleteAssignedUsers setUser (Long user) {
      this.setParam("user", user);
      return this;
    }
    public APIRequestDeleteAssignedUsers setUser (String user) {
      this.setParam("user", user);
      return this;
    }

    public APIRequestDeleteAssignedUsers requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestDeleteAssignedUsers requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteAssignedUsers requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestDeleteAssignedUsers requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteAssignedUsers requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestDeleteAssignedUsers requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetAssignedUsers extends APIRequest<AssignedUser> {

    APINodeList<AssignedUser> lastResponse = null;
    @Override
    public APINodeList<AssignedUser> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "business",
    };

    public static final String[] FIELDS = {
      "business",
      "id",
      "name",
      "user_type",
    };

    @Override
    public APINodeList<AssignedUser> parseResponse(String response) throws APIException {
      return AssignedUser.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<AssignedUser> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<AssignedUser> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<AssignedUser>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<AssignedUser>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<AssignedUser>>() {
           public APINodeList<AssignedUser> apply(String result) {
             try {
               return APIRequestGetAssignedUsers.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetAssignedUsers(String nodeId, APIContext context) {
      super(context, nodeId, "/assigned_users", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetAssignedUsers setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetAssignedUsers setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetAssignedUsers setBusiness (String business) {
      this.setParam("business", business);
      return this;
    }

    public APIRequestGetAssignedUsers requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetAssignedUsers requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetAssignedUsers requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetAssignedUsers requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetAssignedUsers requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetAssignedUsers requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetAssignedUsers requestBusinessField () {
      return this.requestBusinessField(true);
    }
    public APIRequestGetAssignedUsers requestBusinessField (boolean value) {
      this.requestField("business", value);
      return this;
    }
    public APIRequestGetAssignedUsers requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetAssignedUsers requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetAssignedUsers requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetAssignedUsers requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetAssignedUsers requestUserTypeField () {
      return this.requestUserTypeField(true);
    }
    public APIRequestGetAssignedUsers requestUserTypeField (boolean value) {
      this.requestField("user_type", value);
      return this;
    }
  }

  public static class APIRequestCreateAssignedUser extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "user",
      "tasks",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response) throws APIException {
      return Page.parseResponse(response, getContext(), this).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, Page>() {
           public Page apply(String result) {
             try {
               return APIRequestCreateAssignedUser.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateAssignedUser(String nodeId, APIContext context) {
      super(context, nodeId, "/assigned_users", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateAssignedUser setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateAssignedUser setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateAssignedUser setUser (Long user) {
      this.setParam("user", user);
      return this;
    }
    public APIRequestCreateAssignedUser setUser (String user) {
      this.setParam("user", user);
      return this;
    }

    public APIRequestCreateAssignedUser setTasks (List<Page.EnumTasks> tasks) {
      this.setParam("tasks", tasks);
      return this;
    }
    public APIRequestCreateAssignedUser setTasks (String tasks) {
      this.setParam("tasks", tasks);
      return this;
    }

    public APIRequestCreateAssignedUser requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateAssignedUser requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateAssignedUser requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateAssignedUser requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateAssignedUser requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateAssignedUser requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetAudioCopyrights extends APIRequest<AudioCopyright> {

    APINodeList<AudioCopyright> lastResponse = null;
    @Override
    public APINodeList<AudioCopyright> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "creation_time",
      "displayed_matches_count",
      "id",
      "in_conflict",
      "isrc",
      "match_rule",
      "ownership_countries",
      "reference_file_status",
      "ridge_monitoring_status",
      "update_time",
      "whitelisted_fb_users",
      "whitelisted_ig_users",
    };

    @Override
    public APINodeList<AudioCopyright> parseResponse(String response) throws APIException {
      return AudioCopyright.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<AudioCopyright> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<AudioCopyright> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<AudioCopyright>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<AudioCopyright>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<AudioCopyright>>() {
           public APINodeList<AudioCopyright> apply(String result) {
             try {
               return APIRequestGetAudioCopyrights.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetAudioCopyrights(String nodeId, APIContext context) {
      super(context, nodeId, "/audio_copyrights", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetAudioCopyrights setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetAudioCopyrights setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetAudioCopyrights requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetAudioCopyrights requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetAudioCopyrights requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetAudioCopyrights requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetAudioCopyrights requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetAudioCopyrights requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetAudioCopyrights requestCreationTimeField () {
      return this.requestCreationTimeField(true);
    }
    public APIRequestGetAudioCopyrights requestCreationTimeField (boolean value) {
      this.requestField("creation_time", value);
      return this;
    }
    public APIRequestGetAudioCopyrights requestDisplayedMatchesCountField () {
      return this.requestDisplayedMatchesCountField(true);
    }
    public APIRequestGetAudioCopyrights requestDisplayedMatchesCountField (boolean value) {
      this.requestField("displayed_matches_count", value);
      return this;
    }
    public APIRequestGetAudioCopyrights requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetAudioCopyrights requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetAudioCopyrights requestInConflictField () {
      return this.requestInConflictField(true);
    }
    public APIRequestGetAudioCopyrights requestInConflictField (boolean value) {
      this.requestField("in_conflict", value);
      return this;
    }
    public APIRequestGetAudioCopyrights requestIsrcField () {
      return this.requestIsrcField(true);
    }
    public APIRequestGetAudioCopyrights requestIsrcField (boolean value) {
      this.requestField("isrc", value);
      return this;
    }
    public APIRequestGetAudioCopyrights requestMatchRuleField () {
      return this.requestMatchRuleField(true);
    }
    public APIRequestGetAudioCopyrights requestMatchRuleField (boolean value) {
      this.requestField("match_rule", value);
      return this;
    }
    public APIRequestGetAudioCopyrights requestOwnershipCountriesField () {
      return this.requestOwnershipCountriesField(true);
    }
    public APIRequestGetAudioCopyrights requestOwnershipCountriesField (boolean value) {
      this.requestField("ownership_countries", value);
      return this;
    }
    public APIRequestGetAudioCopyrights requestReferenceFileStatusField () {
      return this.requestReferenceFileStatusField(true);
    }
    public APIRequestGetAudioCopyrights requestReferenceFileStatusField (boolean value) {
      this.requestField("reference_file_status", value);
      return this;
    }
    public APIRequestGetAudioCopyrights requestRidgeMonitoringStatusField () {
      return this.requestRidgeMonitoringStatusField(true);
    }
    public APIRequestGetAudioCopyrights requestRidgeMonitoringStatusField (boolean value) {
      this.requestField("ridge_monitoring_status", value);
      return this;
    }
    public APIRequestGetAudioCopyrights requestUpdateTimeField () {
      return this.requestUpdateTimeField(true);
    }
    public APIRequestGetAudioCopyrights requestUpdateTimeField (boolean value) {
      this.requestField("update_time", value);
      return this;
    }
    public APIRequestGetAudioCopyrights requestWhitelistedFbUsersField () {
      return this.requestWhitelistedFbUsersField(true);
    }
    public APIRequestGetAudioCopyrights requestWhitelistedFbUsersField (boolean value) {
      this.requestField("whitelisted_fb_users", value);
      return this;
    }
    public APIRequestGetAudioCopyrights requestWhitelistedIgUsersField () {
      return this.requestWhitelistedIgUsersField(true);
    }
    public APIRequestGetAudioCopyrights requestWhitelistedIgUsersField (boolean value) {
      this.requestField("whitelisted_ig_users", value);
      return this;
    }
  }

  public static class APIRequestGetAudioMediaCopyrights extends APIRequest<AudioCopyright> {

    APINodeList<AudioCopyright> lastResponse = null;
    @Override
    public APINodeList<AudioCopyright> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "creation_time",
      "displayed_matches_count",
      "id",
      "in_conflict",
      "isrc",
      "match_rule",
      "ownership_countries",
      "reference_file_status",
      "ridge_monitoring_status",
      "update_time",
      "whitelisted_fb_users",
      "whitelisted_ig_users",
    };

    @Override
    public APINodeList<AudioCopyright> parseResponse(String response) throws APIException {
      return AudioCopyright.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<AudioCopyright> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<AudioCopyright> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<AudioCopyright>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<AudioCopyright>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<AudioCopyright>>() {
           public APINodeList<AudioCopyright> apply(String result) {
             try {
               return APIRequestGetAudioMediaCopyrights.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetAudioMediaCopyrights(String nodeId, APIContext context) {
      super(context, nodeId, "/audio_media_copyrights", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetAudioMediaCopyrights setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetAudioMediaCopyrights setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetAudioMediaCopyrights requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetAudioMediaCopyrights requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetAudioMediaCopyrights requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetAudioMediaCopyrights requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetAudioMediaCopyrights requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetAudioMediaCopyrights requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetAudioMediaCopyrights requestCreationTimeField () {
      return this.requestCreationTimeField(true);
    }
    public APIRequestGetAudioMediaCopyrights requestCreationTimeField (boolean value) {
      this.requestField("creation_time", value);
      return this;
    }
    public APIRequestGetAudioMediaCopyrights requestDisplayedMatchesCountField () {
      return this.requestDisplayedMatchesCountField(true);
    }
    public APIRequestGetAudioMediaCopyrights requestDisplayedMatchesCountField (boolean value) {
      this.requestField("displayed_matches_count", value);
      return this;
    }
    public APIRequestGetAudioMediaCopyrights requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetAudioMediaCopyrights requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetAudioMediaCopyrights requestInConflictField () {
      return this.requestInConflictField(true);
    }
    public APIRequestGetAudioMediaCopyrights requestInConflictField (boolean value) {
      this.requestField("in_conflict", value);
      return this;
    }
    public APIRequestGetAudioMediaCopyrights requestIsrcField () {
      return this.requestIsrcField(true);
    }
    public APIRequestGetAudioMediaCopyrights requestIsrcField (boolean value) {
      this.requestField("isrc", value);
      return this;
    }
    public APIRequestGetAudioMediaCopyrights requestMatchRuleField () {
      return this.requestMatchRuleField(true);
    }
    public APIRequestGetAudioMediaCopyrights requestMatchRuleField (boolean value) {
      this.requestField("match_rule", value);
      return this;
    }
    public APIRequestGetAudioMediaCopyrights requestOwnershipCountriesField () {
      return this.requestOwnershipCountriesField(true);
    }
    public APIRequestGetAudioMediaCopyrights requestOwnershipCountriesField (boolean value) {
      this.requestField("ownership_countries", value);
      return this;
    }
    public APIRequestGetAudioMediaCopyrights requestReferenceFileStatusField () {
      return this.requestReferenceFileStatusField(true);
    }
    public APIRequestGetAudioMediaCopyrights requestReferenceFileStatusField (boolean value) {
      this.requestField("reference_file_status", value);
      return this;
    }
    public APIRequestGetAudioMediaCopyrights requestRidgeMonitoringStatusField () {
      return this.requestRidgeMonitoringStatusField(true);
    }
    public APIRequestGetAudioMediaCopyrights requestRidgeMonitoringStatusField (boolean value) {
      this.requestField("ridge_monitoring_status", value);
      return this;
    }
    public APIRequestGetAudioMediaCopyrights requestUpdateTimeField () {
      return this.requestUpdateTimeField(true);
    }
    public APIRequestGetAudioMediaCopyrights requestUpdateTimeField (boolean value) {
      this.requestField("update_time", value);
      return this;
    }
    public APIRequestGetAudioMediaCopyrights requestWhitelistedFbUsersField () {
      return this.requestWhitelistedFbUsersField(true);
    }
    public APIRequestGetAudioMediaCopyrights requestWhitelistedFbUsersField (boolean value) {
      this.requestField("whitelisted_fb_users", value);
      return this;
    }
    public APIRequestGetAudioMediaCopyrights requestWhitelistedIgUsersField () {
      return this.requestWhitelistedIgUsersField(true);
    }
    public APIRequestGetAudioMediaCopyrights requestWhitelistedIgUsersField (boolean value) {
      this.requestField("whitelisted_ig_users", value);
      return this;
    }
  }

  public static class APIRequestDeleteBlocked extends APIRequest<APINode> {

    APINodeList<APINode> lastResponse = null;
    @Override
    public APINodeList<APINode> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "uid",
      "user",
      "asid",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINodeList<APINode> parseResponse(String response) throws APIException {
      return APINode.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<APINode> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<APINode>>() {
           public APINodeList<APINode> apply(String result) {
             try {
               return APIRequestDeleteBlocked.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestDeleteBlocked(String nodeId, APIContext context) {
      super(context, nodeId, "/blocked", "DELETE", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestDeleteBlocked setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestDeleteBlocked setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestDeleteBlocked setUid (Long uid) {
      this.setParam("uid", uid);
      return this;
    }
    public APIRequestDeleteBlocked setUid (String uid) {
      this.setParam("uid", uid);
      return this;
    }

    public APIRequestDeleteBlocked setUser (Long user) {
      this.setParam("user", user);
      return this;
    }
    public APIRequestDeleteBlocked setUser (String user) {
      this.setParam("user", user);
      return this;
    }

    public APIRequestDeleteBlocked setAsid (Long asid) {
      this.setParam("asid", asid);
      return this;
    }
    public APIRequestDeleteBlocked setAsid (String asid) {
      this.setParam("asid", asid);
      return this;
    }

    public APIRequestDeleteBlocked requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestDeleteBlocked requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteBlocked requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestDeleteBlocked requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteBlocked requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestDeleteBlocked requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetBlocked extends APIRequest<Profile> {

    APINodeList<Profile> lastResponse = null;
    @Override
    public APINodeList<Profile> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "uid",
      "user",
    };

    public static final String[] FIELDS = {
      "can_post",
      "id",
      "link",
      "name",
      "pic",
      "pic_crop",
      "pic_large",
      "pic_small",
      "pic_square",
      "profile_type",
      "username",
    };

    @Override
    public APINodeList<Profile> parseResponse(String response) throws APIException {
      return Profile.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<Profile> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Profile> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Profile>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Profile>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<Profile>>() {
           public APINodeList<Profile> apply(String result) {
             try {
               return APIRequestGetBlocked.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetBlocked(String nodeId, APIContext context) {
      super(context, nodeId, "/blocked", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetBlocked setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetBlocked setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetBlocked setUid (Long uid) {
      this.setParam("uid", uid);
      return this;
    }
    public APIRequestGetBlocked setUid (String uid) {
      this.setParam("uid", uid);
      return this;
    }

    public APIRequestGetBlocked setUser (Long user) {
      this.setParam("user", user);
      return this;
    }
    public APIRequestGetBlocked setUser (String user) {
      this.setParam("user", user);
      return this;
    }

    public APIRequestGetBlocked requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetBlocked requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetBlocked requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetBlocked requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetBlocked requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetBlocked requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetBlocked requestCanPostField () {
      return this.requestCanPostField(true);
    }
    public APIRequestGetBlocked requestCanPostField (boolean value) {
      this.requestField("can_post", value);
      return this;
    }
    public APIRequestGetBlocked requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetBlocked requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetBlocked requestLinkField () {
      return this.requestLinkField(true);
    }
    public APIRequestGetBlocked requestLinkField (boolean value) {
      this.requestField("link", value);
      return this;
    }
    public APIRequestGetBlocked requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetBlocked requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetBlocked requestPicField () {
      return this.requestPicField(true);
    }
    public APIRequestGetBlocked requestPicField (boolean value) {
      this.requestField("pic", value);
      return this;
    }
    public APIRequestGetBlocked requestPicCropField () {
      return this.requestPicCropField(true);
    }
    public APIRequestGetBlocked requestPicCropField (boolean value) {
      this.requestField("pic_crop", value);
      return this;
    }
    public APIRequestGetBlocked requestPicLargeField () {
      return this.requestPicLargeField(true);
    }
    public APIRequestGetBlocked requestPicLargeField (boolean value) {
      this.requestField("pic_large", value);
      return this;
    }
    public APIRequestGetBlocked requestPicSmallField () {
      return this.requestPicSmallField(true);
    }
    public APIRequestGetBlocked requestPicSmallField (boolean value) {
      this.requestField("pic_small", value);
      return this;
    }
    public APIRequestGetBlocked requestPicSquareField () {
      return this.requestPicSquareField(true);
    }
    public APIRequestGetBlocked requestPicSquareField (boolean value) {
      this.requestField("pic_square", value);
      return this;
    }
    public APIRequestGetBlocked requestProfileTypeField () {
      return this.requestProfileTypeField(true);
    }
    public APIRequestGetBlocked requestProfileTypeField (boolean value) {
      this.requestField("profile_type", value);
      return this;
    }
    public APIRequestGetBlocked requestUsernameField () {
      return this.requestUsernameField(true);
    }
    public APIRequestGetBlocked requestUsernameField (boolean value) {
      this.requestField("username", value);
      return this;
    }
  }

  public static class APIRequestCreateBlocked extends APIRequest<APINode> {

    APINode lastResponse = null;
    @Override
    public APINode getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "user",
      "uid",
      "asid",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINode parseResponse(String response) throws APIException {
      return APINode.parseResponse(response, getContext(), this).head();
    }

    @Override
    public APINode execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINode execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINode> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINode>() {
           public APINode apply(String result) {
             try {
               return APIRequestCreateBlocked.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateBlocked(String nodeId, APIContext context) {
      super(context, nodeId, "/blocked", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateBlocked setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateBlocked setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateBlocked setUser (List<String> user) {
      this.setParam("user", user);
      return this;
    }
    public APIRequestCreateBlocked setUser (String user) {
      this.setParam("user", user);
      return this;
    }

    public APIRequestCreateBlocked setUid (List<String> uid) {
      this.setParam("uid", uid);
      return this;
    }
    public APIRequestCreateBlocked setUid (String uid) {
      this.setParam("uid", uid);
      return this;
    }

    public APIRequestCreateBlocked setAsid (Object asid) {
      this.setParam("asid", asid);
      return this;
    }
    public APIRequestCreateBlocked setAsid (String asid) {
      this.setParam("asid", asid);
      return this;
    }

    public APIRequestCreateBlocked requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateBlocked requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateBlocked requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateBlocked requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateBlocked requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateBlocked requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetBroadcastMessages extends APIRequest<PageBroadcast> {

    APINodeList<PageBroadcast> lastResponse = null;
    @Override
    public APINodeList<PageBroadcast> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "id",
      "scheduled_time",
      "status",
    };

    @Override
    public APINodeList<PageBroadcast> parseResponse(String response) throws APIException {
      return PageBroadcast.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<PageBroadcast> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<PageBroadcast> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<PageBroadcast>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<PageBroadcast>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<PageBroadcast>>() {
           public APINodeList<PageBroadcast> apply(String result) {
             try {
               return APIRequestGetBroadcastMessages.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetBroadcastMessages(String nodeId, APIContext context) {
      super(context, nodeId, "/broadcast_messages", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetBroadcastMessages setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetBroadcastMessages setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetBroadcastMessages requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetBroadcastMessages requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetBroadcastMessages requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetBroadcastMessages requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetBroadcastMessages requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetBroadcastMessages requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetBroadcastMessages requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetBroadcastMessages requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetBroadcastMessages requestScheduledTimeField () {
      return this.requestScheduledTimeField(true);
    }
    public APIRequestGetBroadcastMessages requestScheduledTimeField (boolean value) {
      this.requestField("scheduled_time", value);
      return this;
    }
    public APIRequestGetBroadcastMessages requestStatusField () {
      return this.requestStatusField(true);
    }
    public APIRequestGetBroadcastMessages requestStatusField (boolean value) {
      this.requestField("status", value);
      return this;
    }
  }

  public static class APIRequestCreateBroadcastMessage extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "message_creative_id",
      "notification_type",
      "tag",
      "messaging_type",
      "targeting",
      "custom_label_id",
      "schedule_time",
      "schedule_local_time",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response) throws APIException {
      return Page.parseResponse(response, getContext(), this).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, Page>() {
           public Page apply(String result) {
             try {
               return APIRequestCreateBroadcastMessage.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateBroadcastMessage(String nodeId, APIContext context) {
      super(context, nodeId, "/broadcast_messages", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateBroadcastMessage setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateBroadcastMessage setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateBroadcastMessage setMessageCreativeId (String messageCreativeId) {
      this.setParam("message_creative_id", messageCreativeId);
      return this;
    }

    public APIRequestCreateBroadcastMessage setNotificationType (Page.EnumNotificationType notificationType) {
      this.setParam("notification_type", notificationType);
      return this;
    }
    public APIRequestCreateBroadcastMessage setNotificationType (String notificationType) {
      this.setParam("notification_type", notificationType);
      return this;
    }

    public APIRequestCreateBroadcastMessage setTag (Object tag) {
      this.setParam("tag", tag);
      return this;
    }
    public APIRequestCreateBroadcastMessage setTag (String tag) {
      this.setParam("tag", tag);
      return this;
    }

    public APIRequestCreateBroadcastMessage setMessagingType (Page.EnumMessagingType messagingType) {
      this.setParam("messaging_type", messagingType);
      return this;
    }
    public APIRequestCreateBroadcastMessage setMessagingType (String messagingType) {
      this.setParam("messaging_type", messagingType);
      return this;
    }

    public APIRequestCreateBroadcastMessage setTargeting (Object targeting) {
      this.setParam("targeting", targeting);
      return this;
    }
    public APIRequestCreateBroadcastMessage setTargeting (String targeting) {
      this.setParam("targeting", targeting);
      return this;
    }

    public APIRequestCreateBroadcastMessage setCustomLabelId (Long customLabelId) {
      this.setParam("custom_label_id", customLabelId);
      return this;
    }
    public APIRequestCreateBroadcastMessage setCustomLabelId (String customLabelId) {
      this.setParam("custom_label_id", customLabelId);
      return this;
    }

    public APIRequestCreateBroadcastMessage setScheduleTime (Object scheduleTime) {
      this.setParam("schedule_time", scheduleTime);
      return this;
    }
    public APIRequestCreateBroadcastMessage setScheduleTime (String scheduleTime) {
      this.setParam("schedule_time", scheduleTime);
      return this;
    }

    public APIRequestCreateBroadcastMessage setScheduleLocalTime (String scheduleLocalTime) {
      this.setParam("schedule_local_time", scheduleLocalTime);
      return this;
    }

    public APIRequestCreateBroadcastMessage requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateBroadcastMessage requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateBroadcastMessage requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateBroadcastMessage requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateBroadcastMessage requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateBroadcastMessage requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestCreateBroadcastReachEstimation extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "custom_label_id",
      "targeting",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response) throws APIException {
      return Page.parseResponse(response, getContext(), this).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, Page>() {
           public Page apply(String result) {
             try {
               return APIRequestCreateBroadcastReachEstimation.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateBroadcastReachEstimation(String nodeId, APIContext context) {
      super(context, nodeId, "/broadcast_reach_estimations", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateBroadcastReachEstimation setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateBroadcastReachEstimation setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateBroadcastReachEstimation setCustomLabelId (Long customLabelId) {
      this.setParam("custom_label_id", customLabelId);
      return this;
    }
    public APIRequestCreateBroadcastReachEstimation setCustomLabelId (String customLabelId) {
      this.setParam("custom_label_id", customLabelId);
      return this;
    }

    public APIRequestCreateBroadcastReachEstimation setTargeting (Object targeting) {
      this.setParam("targeting", targeting);
      return this;
    }
    public APIRequestCreateBroadcastReachEstimation setTargeting (String targeting) {
      this.setParam("targeting", targeting);
      return this;
    }

    public APIRequestCreateBroadcastReachEstimation requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateBroadcastReachEstimation requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateBroadcastReachEstimation requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateBroadcastReachEstimation requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateBroadcastReachEstimation requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateBroadcastReachEstimation requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetBusinessActivities extends APIRequest<BusinessActivityLogEvent> {

    APINodeList<BusinessActivityLogEvent> lastResponse = null;
    @Override
    public APINodeList<BusinessActivityLogEvent> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "business",
    };

    public static final String[] FIELDS = {
      "acted_upon_business_id",
      "acted_upon_business_name",
      "acted_upon_business_object_id",
      "acted_upon_business_object_name",
      "acted_upon_business_object_type",
      "acted_upon_user_id",
      "acted_upon_user_name",
      "acting_business_id",
      "acting_business_name",
      "acting_user_id",
      "acting_user_name",
      "event_time",
      "event_type",
      "extra_data",
      "target_business_id",
      "target_business_name",
      "target_business_object_id",
      "target_business_object_name",
      "target_business_object_type",
      "id",
    };

    @Override
    public APINodeList<BusinessActivityLogEvent> parseResponse(String response) throws APIException {
      return BusinessActivityLogEvent.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<BusinessActivityLogEvent> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<BusinessActivityLogEvent> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<BusinessActivityLogEvent>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<BusinessActivityLogEvent>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<BusinessActivityLogEvent>>() {
           public APINodeList<BusinessActivityLogEvent> apply(String result) {
             try {
               return APIRequestGetBusinessActivities.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetBusinessActivities(String nodeId, APIContext context) {
      super(context, nodeId, "/business_activities", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetBusinessActivities setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetBusinessActivities setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetBusinessActivities setBusiness (String business) {
      this.setParam("business", business);
      return this;
    }

    public APIRequestGetBusinessActivities requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetBusinessActivities requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetBusinessActivities requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetBusinessActivities requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetBusinessActivities requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetBusinessActivities requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetBusinessActivities requestActedUponBusinessIdField () {
      return this.requestActedUponBusinessIdField(true);
    }
    public APIRequestGetBusinessActivities requestActedUponBusinessIdField (boolean value) {
      this.requestField("acted_upon_business_id", value);
      return this;
    }
    public APIRequestGetBusinessActivities requestActedUponBusinessNameField () {
      return this.requestActedUponBusinessNameField(true);
    }
    public APIRequestGetBusinessActivities requestActedUponBusinessNameField (boolean value) {
      this.requestField("acted_upon_business_name", value);
      return this;
    }
    public APIRequestGetBusinessActivities requestActedUponBusinessObjectIdField () {
      return this.requestActedUponBusinessObjectIdField(true);
    }
    public APIRequestGetBusinessActivities requestActedUponBusinessObjectIdField (boolean value) {
      this.requestField("acted_upon_business_object_id", value);
      return this;
    }
    public APIRequestGetBusinessActivities requestActedUponBusinessObjectNameField () {
      return this.requestActedUponBusinessObjectNameField(true);
    }
    public APIRequestGetBusinessActivities requestActedUponBusinessObjectNameField (boolean value) {
      this.requestField("acted_upon_business_object_name", value);
      return this;
    }
    public APIRequestGetBusinessActivities requestActedUponBusinessObjectTypeField () {
      return this.requestActedUponBusinessObjectTypeField(true);
    }
    public APIRequestGetBusinessActivities requestActedUponBusinessObjectTypeField (boolean value) {
      this.requestField("acted_upon_business_object_type", value);
      return this;
    }
    public APIRequestGetBusinessActivities requestActedUponUserIdField () {
      return this.requestActedUponUserIdField(true);
    }
    public APIRequestGetBusinessActivities requestActedUponUserIdField (boolean value) {
      this.requestField("acted_upon_user_id", value);
      return this;
    }
    public APIRequestGetBusinessActivities requestActedUponUserNameField () {
      return this.requestActedUponUserNameField(true);
    }
    public APIRequestGetBusinessActivities requestActedUponUserNameField (boolean value) {
      this.requestField("acted_upon_user_name", value);
      return this;
    }
    public APIRequestGetBusinessActivities requestActingBusinessIdField () {
      return this.requestActingBusinessIdField(true);
    }
    public APIRequestGetBusinessActivities requestActingBusinessIdField (boolean value) {
      this.requestField("acting_business_id", value);
      return this;
    }
    public APIRequestGetBusinessActivities requestActingBusinessNameField () {
      return this.requestActingBusinessNameField(true);
    }
    public APIRequestGetBusinessActivities requestActingBusinessNameField (boolean value) {
      this.requestField("acting_business_name", value);
      return this;
    }
    public APIRequestGetBusinessActivities requestActingUserIdField () {
      return this.requestActingUserIdField(true);
    }
    public APIRequestGetBusinessActivities requestActingUserIdField (boolean value) {
      this.requestField("acting_user_id", value);
      return this;
    }
    public APIRequestGetBusinessActivities requestActingUserNameField () {
      return this.requestActingUserNameField(true);
    }
    public APIRequestGetBusinessActivities requestActingUserNameField (boolean value) {
      this.requestField("acting_user_name", value);
      return this;
    }
    public APIRequestGetBusinessActivities requestEventTimeField () {
      return this.requestEventTimeField(true);
    }
    public APIRequestGetBusinessActivities requestEventTimeField (boolean value) {
      this.requestField("event_time", value);
      return this;
    }
    public APIRequestGetBusinessActivities requestEventTypeField () {
      return this.requestEventTypeField(true);
    }
    public APIRequestGetBusinessActivities requestEventTypeField (boolean value) {
      this.requestField("event_type", value);
      return this;
    }
    public APIRequestGetBusinessActivities requestExtraDataField () {
      return this.requestExtraDataField(true);
    }
    public APIRequestGetBusinessActivities requestExtraDataField (boolean value) {
      this.requestField("extra_data", value);
      return this;
    }
    public APIRequestGetBusinessActivities requestTargetBusinessIdField () {
      return this.requestTargetBusinessIdField(true);
    }
    public APIRequestGetBusinessActivities requestTargetBusinessIdField (boolean value) {
      this.requestField("target_business_id", value);
      return this;
    }
    public APIRequestGetBusinessActivities requestTargetBusinessNameField () {
      return this.requestTargetBusinessNameField(true);
    }
    public APIRequestGetBusinessActivities requestTargetBusinessNameField (boolean value) {
      this.requestField("target_business_name", value);
      return this;
    }
    public APIRequestGetBusinessActivities requestTargetBusinessObjectIdField () {
      return this.requestTargetBusinessObjectIdField(true);
    }
    public APIRequestGetBusinessActivities requestTargetBusinessObjectIdField (boolean value) {
      this.requestField("target_business_object_id", value);
      return this;
    }
    public APIRequestGetBusinessActivities requestTargetBusinessObjectNameField () {
      return this.requestTargetBusinessObjectNameField(true);
    }
    public APIRequestGetBusinessActivities requestTargetBusinessObjectNameField (boolean value) {
      this.requestField("target_business_object_name", value);
      return this;
    }
    public APIRequestGetBusinessActivities requestTargetBusinessObjectTypeField () {
      return this.requestTargetBusinessObjectTypeField(true);
    }
    public APIRequestGetBusinessActivities requestTargetBusinessObjectTypeField (boolean value) {
      this.requestField("target_business_object_type", value);
      return this;
    }
    public APIRequestGetBusinessActivities requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetBusinessActivities requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
  }

  public static class APIRequestCreateBusiness extends APIRequest<Business> {

    Business lastResponse = null;
    @Override
    public Business getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "business",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Business parseResponse(String response) throws APIException {
      return Business.parseResponse(response, getContext(), this).head();
    }

    @Override
    public Business execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Business execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<Business> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Business> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, Business>() {
           public Business apply(String result) {
             try {
               return APIRequestCreateBusiness.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateBusiness(String nodeId, APIContext context) {
      super(context, nodeId, "/businesses", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateBusiness setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateBusiness setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateBusiness setBusiness (String business) {
      this.setParam("business", business);
      return this;
    }

    public APIRequestCreateBusiness requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateBusiness requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateBusiness requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateBusiness requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateBusiness requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateBusiness requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetBusinessProjects extends APIRequest<BusinessProject> {

    APINodeList<BusinessProject> lastResponse = null;
    @Override
    public APINodeList<BusinessProject> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "business",
    };

    public static final String[] FIELDS = {
      "business",
      "created_time",
      "creator",
      "id",
      "name",
    };

    @Override
    public APINodeList<BusinessProject> parseResponse(String response) throws APIException {
      return BusinessProject.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<BusinessProject> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<BusinessProject> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<BusinessProject>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<BusinessProject>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<BusinessProject>>() {
           public APINodeList<BusinessProject> apply(String result) {
             try {
               return APIRequestGetBusinessProjects.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetBusinessProjects(String nodeId, APIContext context) {
      super(context, nodeId, "/businessprojects", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetBusinessProjects setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetBusinessProjects setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetBusinessProjects setBusiness (Object business) {
      this.setParam("business", business);
      return this;
    }
    public APIRequestGetBusinessProjects setBusiness (String business) {
      this.setParam("business", business);
      return this;
    }

    public APIRequestGetBusinessProjects requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetBusinessProjects requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetBusinessProjects requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetBusinessProjects requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetBusinessProjects requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetBusinessProjects requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetBusinessProjects requestBusinessField () {
      return this.requestBusinessField(true);
    }
    public APIRequestGetBusinessProjects requestBusinessField (boolean value) {
      this.requestField("business", value);
      return this;
    }
    public APIRequestGetBusinessProjects requestCreatedTimeField () {
      return this.requestCreatedTimeField(true);
    }
    public APIRequestGetBusinessProjects requestCreatedTimeField (boolean value) {
      this.requestField("created_time", value);
      return this;
    }
    public APIRequestGetBusinessProjects requestCreatorField () {
      return this.requestCreatorField(true);
    }
    public APIRequestGetBusinessProjects requestCreatorField (boolean value) {
      this.requestField("creator", value);
      return this;
    }
    public APIRequestGetBusinessProjects requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetBusinessProjects requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetBusinessProjects requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetBusinessProjects requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
  }

  public static class APIRequestGetBusinessSettingLogs extends APIRequest<BusinessSettingLogsData> {

    APINodeList<BusinessSettingLogsData> lastResponse = null;
    @Override
    public APINodeList<BusinessSettingLogsData> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "actor",
      "event_object",
      "event_time",
      "event_type",
      "extra_data",
      "id",
    };

    @Override
    public APINodeList<BusinessSettingLogsData> parseResponse(String response) throws APIException {
      return BusinessSettingLogsData.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<BusinessSettingLogsData> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<BusinessSettingLogsData> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<BusinessSettingLogsData>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<BusinessSettingLogsData>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<BusinessSettingLogsData>>() {
           public APINodeList<BusinessSettingLogsData> apply(String result) {
             try {
               return APIRequestGetBusinessSettingLogs.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetBusinessSettingLogs(String nodeId, APIContext context) {
      super(context, nodeId, "/businesssettinglogs", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetBusinessSettingLogs setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetBusinessSettingLogs setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetBusinessSettingLogs requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetBusinessSettingLogs requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetBusinessSettingLogs requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetBusinessSettingLogs requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetBusinessSettingLogs requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetBusinessSettingLogs requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetBusinessSettingLogs requestActorField () {
      return this.requestActorField(true);
    }
    public APIRequestGetBusinessSettingLogs requestActorField (boolean value) {
      this.requestField("actor", value);
      return this;
    }
    public APIRequestGetBusinessSettingLogs requestEventObjectField () {
      return this.requestEventObjectField(true);
    }
    public APIRequestGetBusinessSettingLogs requestEventObjectField (boolean value) {
      this.requestField("event_object", value);
      return this;
    }
    public APIRequestGetBusinessSettingLogs requestEventTimeField () {
      return this.requestEventTimeField(true);
    }
    public APIRequestGetBusinessSettingLogs requestEventTimeField (boolean value) {
      this.requestField("event_time", value);
      return this;
    }
    public APIRequestGetBusinessSettingLogs requestEventTypeField () {
      return this.requestEventTypeField(true);
    }
    public APIRequestGetBusinessSettingLogs requestEventTypeField (boolean value) {
      this.requestField("event_type", value);
      return this;
    }
    public APIRequestGetBusinessSettingLogs requestExtraDataField () {
      return this.requestExtraDataField(true);
    }
    public APIRequestGetBusinessSettingLogs requestExtraDataField (boolean value) {
      this.requestField("extra_data", value);
      return this;
    }
    public APIRequestGetBusinessSettingLogs requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetBusinessSettingLogs requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
  }

  public static class APIRequestGetCallToActions extends APIRequest<PageCallToAction> {

    APINodeList<PageCallToAction> lastResponse = null;
    @Override
    public APINodeList<PageCallToAction> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "android_app",
      "android_deeplink",
      "android_destination_type",
      "android_package_name",
      "android_url",
      "created_time",
      "email_address",
      "from",
      "id",
      "intl_number_with_plus",
      "iphone_app",
      "iphone_deeplink",
      "iphone_destination_type",
      "iphone_url",
      "status",
      "type",
      "updated_time",
      "web_destination_type",
      "web_url",
    };

    @Override
    public APINodeList<PageCallToAction> parseResponse(String response) throws APIException {
      return PageCallToAction.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<PageCallToAction> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<PageCallToAction> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<PageCallToAction>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<PageCallToAction>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<PageCallToAction>>() {
           public APINodeList<PageCallToAction> apply(String result) {
             try {
               return APIRequestGetCallToActions.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetCallToActions(String nodeId, APIContext context) {
      super(context, nodeId, "/call_to_actions", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetCallToActions setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetCallToActions setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetCallToActions requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetCallToActions requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCallToActions requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetCallToActions requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCallToActions requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetCallToActions requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetCallToActions requestAndroidAppField () {
      return this.requestAndroidAppField(true);
    }
    public APIRequestGetCallToActions requestAndroidAppField (boolean value) {
      this.requestField("android_app", value);
      return this;
    }
    public APIRequestGetCallToActions requestAndroidDeeplinkField () {
      return this.requestAndroidDeeplinkField(true);
    }
    public APIRequestGetCallToActions requestAndroidDeeplinkField (boolean value) {
      this.requestField("android_deeplink", value);
      return this;
    }
    public APIRequestGetCallToActions requestAndroidDestinationTypeField () {
      return this.requestAndroidDestinationTypeField(true);
    }
    public APIRequestGetCallToActions requestAndroidDestinationTypeField (boolean value) {
      this.requestField("android_destination_type", value);
      return this;
    }
    public APIRequestGetCallToActions requestAndroidPackageNameField () {
      return this.requestAndroidPackageNameField(true);
    }
    public APIRequestGetCallToActions requestAndroidPackageNameField (boolean value) {
      this.requestField("android_package_name", value);
      return this;
    }
    public APIRequestGetCallToActions requestAndroidUrlField () {
      return this.requestAndroidUrlField(true);
    }
    public APIRequestGetCallToActions requestAndroidUrlField (boolean value) {
      this.requestField("android_url", value);
      return this;
    }
    public APIRequestGetCallToActions requestCreatedTimeField () {
      return this.requestCreatedTimeField(true);
    }
    public APIRequestGetCallToActions requestCreatedTimeField (boolean value) {
      this.requestField("created_time", value);
      return this;
    }
    public APIRequestGetCallToActions requestEmailAddressField () {
      return this.requestEmailAddressField(true);
    }
    public APIRequestGetCallToActions requestEmailAddressField (boolean value) {
      this.requestField("email_address", value);
      return this;
    }
    public APIRequestGetCallToActions requestFromField () {
      return this.requestFromField(true);
    }
    public APIRequestGetCallToActions requestFromField (boolean value) {
      this.requestField("from", value);
      return this;
    }
    public APIRequestGetCallToActions requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetCallToActions requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetCallToActions requestIntlNumberWithPlusField () {
      return this.requestIntlNumberWithPlusField(true);
    }
    public APIRequestGetCallToActions requestIntlNumberWithPlusField (boolean value) {
      this.requestField("intl_number_with_plus", value);
      return this;
    }
    public APIRequestGetCallToActions requestIphoneAppField () {
      return this.requestIphoneAppField(true);
    }
    public APIRequestGetCallToActions requestIphoneAppField (boolean value) {
      this.requestField("iphone_app", value);
      return this;
    }
    public APIRequestGetCallToActions requestIphoneDeeplinkField () {
      return this.requestIphoneDeeplinkField(true);
    }
    public APIRequestGetCallToActions requestIphoneDeeplinkField (boolean value) {
      this.requestField("iphone_deeplink", value);
      return this;
    }
    public APIRequestGetCallToActions requestIphoneDestinationTypeField () {
      return this.requestIphoneDestinationTypeField(true);
    }
    public APIRequestGetCallToActions requestIphoneDestinationTypeField (boolean value) {
      this.requestField("iphone_destination_type", value);
      return this;
    }
    public APIRequestGetCallToActions requestIphoneUrlField () {
      return this.requestIphoneUrlField(true);
    }
    public APIRequestGetCallToActions requestIphoneUrlField (boolean value) {
      this.requestField("iphone_url", value);
      return this;
    }
    public APIRequestGetCallToActions requestStatusField () {
      return this.requestStatusField(true);
    }
    public APIRequestGetCallToActions requestStatusField (boolean value) {
      this.requestField("status", value);
      return this;
    }
    public APIRequestGetCallToActions requestTypeField () {
      return this.requestTypeField(true);
    }
    public APIRequestGetCallToActions requestTypeField (boolean value) {
      this.requestField("type", value);
      return this;
    }
    public APIRequestGetCallToActions requestUpdatedTimeField () {
      return this.requestUpdatedTimeField(true);
    }
    public APIRequestGetCallToActions requestUpdatedTimeField (boolean value) {
      this.requestField("updated_time", value);
      return this;
    }
    public APIRequestGetCallToActions requestWebDestinationTypeField () {
      return this.requestWebDestinationTypeField(true);
    }
    public APIRequestGetCallToActions requestWebDestinationTypeField (boolean value) {
      this.requestField("web_destination_type", value);
      return this;
    }
    public APIRequestGetCallToActions requestWebUrlField () {
      return this.requestWebUrlField(true);
    }
    public APIRequestGetCallToActions requestWebUrlField (boolean value) {
      this.requestField("web_url", value);
      return this;
    }
  }

  public static class APIRequestCreateCallToAction extends APIRequest<PageCallToAction> {

    PageCallToAction lastResponse = null;
    @Override
    public PageCallToAction getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "type",
      "web_destination_type",
      "android_destination_type",
      "iphone_destination_type",
      "intl_number_with_plus",
      "web_url",
      "android_app_id",
      "android_deeplink",
      "android_package_name",
      "android_url",
      "iphone_app_id",
      "iphone_deeplink",
      "iphone_url",
      "email_address",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public PageCallToAction parseResponse(String response) throws APIException {
      return PageCallToAction.parseResponse(response, getContext(), this).head();
    }

    @Override
    public PageCallToAction execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public PageCallToAction execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<PageCallToAction> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<PageCallToAction> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, PageCallToAction>() {
           public PageCallToAction apply(String result) {
             try {
               return APIRequestCreateCallToAction.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateCallToAction(String nodeId, APIContext context) {
      super(context, nodeId, "/call_to_actions", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateCallToAction setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateCallToAction setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateCallToAction setType (PageCallToAction.EnumType type) {
      this.setParam("type", type);
      return this;
    }
    public APIRequestCreateCallToAction setType (String type) {
      this.setParam("type", type);
      return this;
    }

    public APIRequestCreateCallToAction setWebDestinationType (PageCallToAction.EnumWebDestinationType webDestinationType) {
      this.setParam("web_destination_type", webDestinationType);
      return this;
    }
    public APIRequestCreateCallToAction setWebDestinationType (String webDestinationType) {
      this.setParam("web_destination_type", webDestinationType);
      return this;
    }

    public APIRequestCreateCallToAction setAndroidDestinationType (PageCallToAction.EnumAndroidDestinationType androidDestinationType) {
      this.setParam("android_destination_type", androidDestinationType);
      return this;
    }
    public APIRequestCreateCallToAction setAndroidDestinationType (String androidDestinationType) {
      this.setParam("android_destination_type", androidDestinationType);
      return this;
    }

    public APIRequestCreateCallToAction setIphoneDestinationType (PageCallToAction.EnumIphoneDestinationType iphoneDestinationType) {
      this.setParam("iphone_destination_type", iphoneDestinationType);
      return this;
    }
    public APIRequestCreateCallToAction setIphoneDestinationType (String iphoneDestinationType) {
      this.setParam("iphone_destination_type", iphoneDestinationType);
      return this;
    }

    public APIRequestCreateCallToAction setIntlNumberWithPlus (String intlNumberWithPlus) {
      this.setParam("intl_number_with_plus", intlNumberWithPlus);
      return this;
    }

    public APIRequestCreateCallToAction setWebUrl (String webUrl) {
      this.setParam("web_url", webUrl);
      return this;
    }

    public APIRequestCreateCallToAction setAndroidAppId (Long androidAppId) {
      this.setParam("android_app_id", androidAppId);
      return this;
    }
    public APIRequestCreateCallToAction setAndroidAppId (String androidAppId) {
      this.setParam("android_app_id", androidAppId);
      return this;
    }

    public APIRequestCreateCallToAction setAndroidDeeplink (String androidDeeplink) {
      this.setParam("android_deeplink", androidDeeplink);
      return this;
    }

    public APIRequestCreateCallToAction setAndroidPackageName (String androidPackageName) {
      this.setParam("android_package_name", androidPackageName);
      return this;
    }

    public APIRequestCreateCallToAction setAndroidUrl (String androidUrl) {
      this.setParam("android_url", androidUrl);
      return this;
    }

    public APIRequestCreateCallToAction setIphoneAppId (Long iphoneAppId) {
      this.setParam("iphone_app_id", iphoneAppId);
      return this;
    }
    public APIRequestCreateCallToAction setIphoneAppId (String iphoneAppId) {
      this.setParam("iphone_app_id", iphoneAppId);
      return this;
    }

    public APIRequestCreateCallToAction setIphoneDeeplink (String iphoneDeeplink) {
      this.setParam("iphone_deeplink", iphoneDeeplink);
      return this;
    }

    public APIRequestCreateCallToAction setIphoneUrl (String iphoneUrl) {
      this.setParam("iphone_url", iphoneUrl);
      return this;
    }

    public APIRequestCreateCallToAction setEmailAddress (String emailAddress) {
      this.setParam("email_address", emailAddress);
      return this;
    }

    public APIRequestCreateCallToAction requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateCallToAction requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateCallToAction requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateCallToAction requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateCallToAction requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateCallToAction requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetCanvasElements extends APIRequest<CanvasBodyElement> {

    APINodeList<CanvasBodyElement> lastResponse = null;
    @Override
    public APINodeList<CanvasBodyElement> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "element",
      "id",
    };

    @Override
    public APINodeList<CanvasBodyElement> parseResponse(String response) throws APIException {
      return CanvasBodyElement.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<CanvasBodyElement> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<CanvasBodyElement> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<CanvasBodyElement>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<CanvasBodyElement>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<CanvasBodyElement>>() {
           public APINodeList<CanvasBodyElement> apply(String result) {
             try {
               return APIRequestGetCanvasElements.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetCanvasElements(String nodeId, APIContext context) {
      super(context, nodeId, "/canvas_elements", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetCanvasElements setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetCanvasElements setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetCanvasElements requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetCanvasElements requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCanvasElements requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetCanvasElements requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCanvasElements requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetCanvasElements requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetCanvasElements requestElementField () {
      return this.requestElementField(true);
    }
    public APIRequestGetCanvasElements requestElementField (boolean value) {
      this.requestField("element", value);
      return this;
    }
    public APIRequestGetCanvasElements requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetCanvasElements requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
  }

  public static class APIRequestCreateCanvasElement extends APIRequest<CanvasBodyElement> {

    CanvasBodyElement lastResponse = null;
    @Override
    public CanvasBodyElement getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "canvas_photo",
      "canvas_video",
      "canvas_text",
      "canvas_button",
      "canvas_footer",
      "canvas_carousel",
      "canvas_header",
      "canvas_product_list",
      "canvas_product_set",
      "canvas_store_locator",
      "canvas_lead_form",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public CanvasBodyElement parseResponse(String response) throws APIException {
      return CanvasBodyElement.parseResponse(response, getContext(), this).head();
    }

    @Override
    public CanvasBodyElement execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public CanvasBodyElement execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<CanvasBodyElement> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<CanvasBodyElement> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, CanvasBodyElement>() {
           public CanvasBodyElement apply(String result) {
             try {
               return APIRequestCreateCanvasElement.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateCanvasElement(String nodeId, APIContext context) {
      super(context, nodeId, "/canvas_elements", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateCanvasElement setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateCanvasElement setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateCanvasElement setCanvasPhoto (Object canvasPhoto) {
      this.setParam("canvas_photo", canvasPhoto);
      return this;
    }
    public APIRequestCreateCanvasElement setCanvasPhoto (String canvasPhoto) {
      this.setParam("canvas_photo", canvasPhoto);
      return this;
    }

    public APIRequestCreateCanvasElement setCanvasVideo (Object canvasVideo) {
      this.setParam("canvas_video", canvasVideo);
      return this;
    }
    public APIRequestCreateCanvasElement setCanvasVideo (String canvasVideo) {
      this.setParam("canvas_video", canvasVideo);
      return this;
    }

    public APIRequestCreateCanvasElement setCanvasText (Object canvasText) {
      this.setParam("canvas_text", canvasText);
      return this;
    }
    public APIRequestCreateCanvasElement setCanvasText (String canvasText) {
      this.setParam("canvas_text", canvasText);
      return this;
    }

    public APIRequestCreateCanvasElement setCanvasButton (Object canvasButton) {
      this.setParam("canvas_button", canvasButton);
      return this;
    }
    public APIRequestCreateCanvasElement setCanvasButton (String canvasButton) {
      this.setParam("canvas_button", canvasButton);
      return this;
    }

    public APIRequestCreateCanvasElement setCanvasFooter (Object canvasFooter) {
      this.setParam("canvas_footer", canvasFooter);
      return this;
    }
    public APIRequestCreateCanvasElement setCanvasFooter (String canvasFooter) {
      this.setParam("canvas_footer", canvasFooter);
      return this;
    }

    public APIRequestCreateCanvasElement setCanvasCarousel (Object canvasCarousel) {
      this.setParam("canvas_carousel", canvasCarousel);
      return this;
    }
    public APIRequestCreateCanvasElement setCanvasCarousel (String canvasCarousel) {
      this.setParam("canvas_carousel", canvasCarousel);
      return this;
    }

    public APIRequestCreateCanvasElement setCanvasHeader (Object canvasHeader) {
      this.setParam("canvas_header", canvasHeader);
      return this;
    }
    public APIRequestCreateCanvasElement setCanvasHeader (String canvasHeader) {
      this.setParam("canvas_header", canvasHeader);
      return this;
    }

    public APIRequestCreateCanvasElement setCanvasProductList (Object canvasProductList) {
      this.setParam("canvas_product_list", canvasProductList);
      return this;
    }
    public APIRequestCreateCanvasElement setCanvasProductList (String canvasProductList) {
      this.setParam("canvas_product_list", canvasProductList);
      return this;
    }

    public APIRequestCreateCanvasElement setCanvasProductSet (Object canvasProductSet) {
      this.setParam("canvas_product_set", canvasProductSet);
      return this;
    }
    public APIRequestCreateCanvasElement setCanvasProductSet (String canvasProductSet) {
      this.setParam("canvas_product_set", canvasProductSet);
      return this;
    }

    public APIRequestCreateCanvasElement setCanvasStoreLocator (Object canvasStoreLocator) {
      this.setParam("canvas_store_locator", canvasStoreLocator);
      return this;
    }
    public APIRequestCreateCanvasElement setCanvasStoreLocator (String canvasStoreLocator) {
      this.setParam("canvas_store_locator", canvasStoreLocator);
      return this;
    }

    public APIRequestCreateCanvasElement setCanvasLeadForm (Object canvasLeadForm) {
      this.setParam("canvas_lead_form", canvasLeadForm);
      return this;
    }
    public APIRequestCreateCanvasElement setCanvasLeadForm (String canvasLeadForm) {
      this.setParam("canvas_lead_form", canvasLeadForm);
      return this;
    }

    public APIRequestCreateCanvasElement requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateCanvasElement requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateCanvasElement requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateCanvasElement requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateCanvasElement requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateCanvasElement requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetCanvases extends APIRequest<Canvas> {

    APINodeList<Canvas> lastResponse = null;
    @Override
    public APINodeList<Canvas> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "is_published",
    };

    public static final String[] FIELDS = {
      "background_color",
      "body_elements",
      "canvas_link",
      "id",
      "is_hidden",
      "is_published",
      "last_editor",
      "name",
      "owner",
      "update_time",
    };

    @Override
    public APINodeList<Canvas> parseResponse(String response) throws APIException {
      return Canvas.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<Canvas> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Canvas> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Canvas>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Canvas>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<Canvas>>() {
           public APINodeList<Canvas> apply(String result) {
             try {
               return APIRequestGetCanvases.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetCanvases(String nodeId, APIContext context) {
      super(context, nodeId, "/canvases", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetCanvases setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetCanvases setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetCanvases setIsPublished (Boolean isPublished) {
      this.setParam("is_published", isPublished);
      return this;
    }
    public APIRequestGetCanvases setIsPublished (String isPublished) {
      this.setParam("is_published", isPublished);
      return this;
    }

    public APIRequestGetCanvases requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetCanvases requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCanvases requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetCanvases requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCanvases requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetCanvases requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetCanvases requestBackgroundColorField () {
      return this.requestBackgroundColorField(true);
    }
    public APIRequestGetCanvases requestBackgroundColorField (boolean value) {
      this.requestField("background_color", value);
      return this;
    }
    public APIRequestGetCanvases requestBodyElementsField () {
      return this.requestBodyElementsField(true);
    }
    public APIRequestGetCanvases requestBodyElementsField (boolean value) {
      this.requestField("body_elements", value);
      return this;
    }
    public APIRequestGetCanvases requestCanvasLinkField () {
      return this.requestCanvasLinkField(true);
    }
    public APIRequestGetCanvases requestCanvasLinkField (boolean value) {
      this.requestField("canvas_link", value);
      return this;
    }
    public APIRequestGetCanvases requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetCanvases requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetCanvases requestIsHiddenField () {
      return this.requestIsHiddenField(true);
    }
    public APIRequestGetCanvases requestIsHiddenField (boolean value) {
      this.requestField("is_hidden", value);
      return this;
    }
    public APIRequestGetCanvases requestIsPublishedField () {
      return this.requestIsPublishedField(true);
    }
    public APIRequestGetCanvases requestIsPublishedField (boolean value) {
      this.requestField("is_published", value);
      return this;
    }
    public APIRequestGetCanvases requestLastEditorField () {
      return this.requestLastEditorField(true);
    }
    public APIRequestGetCanvases requestLastEditorField (boolean value) {
      this.requestField("last_editor", value);
      return this;
    }
    public APIRequestGetCanvases requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetCanvases requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetCanvases requestOwnerField () {
      return this.requestOwnerField(true);
    }
    public APIRequestGetCanvases requestOwnerField (boolean value) {
      this.requestField("owner", value);
      return this;
    }
    public APIRequestGetCanvases requestUpdateTimeField () {
      return this.requestUpdateTimeField(true);
    }
    public APIRequestGetCanvases requestUpdateTimeField (boolean value) {
      this.requestField("update_time", value);
      return this;
    }
  }

  public static class APIRequestCreateCanvase extends APIRequest<Canvas> {

    Canvas lastResponse = null;
    @Override
    public Canvas getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "body_element_ids",
      "background_color",
      "is_published",
      "is_hidden",
      "name",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Canvas parseResponse(String response) throws APIException {
      return Canvas.parseResponse(response, getContext(), this).head();
    }

    @Override
    public Canvas execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Canvas execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<Canvas> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Canvas> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, Canvas>() {
           public Canvas apply(String result) {
             try {
               return APIRequestCreateCanvase.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateCanvase(String nodeId, APIContext context) {
      super(context, nodeId, "/canvases", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateCanvase setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateCanvase setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateCanvase setBodyElementIds (List<String> bodyElementIds) {
      this.setParam("body_element_ids", bodyElementIds);
      return this;
    }
    public APIRequestCreateCanvase setBodyElementIds (String bodyElementIds) {
      this.setParam("body_element_ids", bodyElementIds);
      return this;
    }

    public APIRequestCreateCanvase setBackgroundColor (String backgroundColor) {
      this.setParam("background_color", backgroundColor);
      return this;
    }

    public APIRequestCreateCanvase setIsPublished (Boolean isPublished) {
      this.setParam("is_published", isPublished);
      return this;
    }
    public APIRequestCreateCanvase setIsPublished (String isPublished) {
      this.setParam("is_published", isPublished);
      return this;
    }

    public APIRequestCreateCanvase setIsHidden (Boolean isHidden) {
      this.setParam("is_hidden", isHidden);
      return this;
    }
    public APIRequestCreateCanvase setIsHidden (String isHidden) {
      this.setParam("is_hidden", isHidden);
      return this;
    }

    public APIRequestCreateCanvase setName (String name) {
      this.setParam("name", name);
      return this;
    }

    public APIRequestCreateCanvase requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateCanvase requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateCanvase requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateCanvase requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateCanvase requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateCanvase requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestDeleteClaimedUrls extends APIRequest<APINode> {

    APINodeList<APINode> lastResponse = null;
    @Override
    public APINodeList<APINode> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "url",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINodeList<APINode> parseResponse(String response) throws APIException {
      return APINode.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<APINode> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<APINode>>() {
           public APINodeList<APINode> apply(String result) {
             try {
               return APIRequestDeleteClaimedUrls.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestDeleteClaimedUrls(String nodeId, APIContext context) {
      super(context, nodeId, "/claimed_urls", "DELETE", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestDeleteClaimedUrls setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestDeleteClaimedUrls setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestDeleteClaimedUrls setUrl (String url) {
      this.setParam("url", url);
      return this;
    }

    public APIRequestDeleteClaimedUrls requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestDeleteClaimedUrls requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteClaimedUrls requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestDeleteClaimedUrls requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteClaimedUrls requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestDeleteClaimedUrls requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetConversations extends APIRequest<UnifiedThread> {

    APINodeList<UnifiedThread> lastResponse = null;
    @Override
    public APINodeList<UnifiedThread> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "tags",
      "folder",
      "psid",
    };

    public static final String[] FIELDS = {
      "can_reply",
      "former_participants",
      "id",
      "is_subscribed",
      "link",
      "message_count",
      "name",
      "participants",
      "scoped_thread_key",
      "senders",
      "snippet",
      "subject",
      "tags",
      "thread_key",
      "unread_count",
      "updated_time",
      "wallpaper",
    };

    @Override
    public APINodeList<UnifiedThread> parseResponse(String response) throws APIException {
      return UnifiedThread.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<UnifiedThread> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<UnifiedThread> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<UnifiedThread>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<UnifiedThread>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<UnifiedThread>>() {
           public APINodeList<UnifiedThread> apply(String result) {
             try {
               return APIRequestGetConversations.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetConversations(String nodeId, APIContext context) {
      super(context, nodeId, "/conversations", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetConversations setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetConversations setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetConversations setTags (List<String> tags) {
      this.setParam("tags", tags);
      return this;
    }
    public APIRequestGetConversations setTags (String tags) {
      this.setParam("tags", tags);
      return this;
    }

    public APIRequestGetConversations setFolder (String folder) {
      this.setParam("folder", folder);
      return this;
    }

    public APIRequestGetConversations setPsid (Object psid) {
      this.setParam("psid", psid);
      return this;
    }
    public APIRequestGetConversations setPsid (String psid) {
      this.setParam("psid", psid);
      return this;
    }

    public APIRequestGetConversations requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetConversations requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetConversations requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetConversations requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetConversations requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetConversations requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetConversations requestCanReplyField () {
      return this.requestCanReplyField(true);
    }
    public APIRequestGetConversations requestCanReplyField (boolean value) {
      this.requestField("can_reply", value);
      return this;
    }
    public APIRequestGetConversations requestFormerParticipantsField () {
      return this.requestFormerParticipantsField(true);
    }
    public APIRequestGetConversations requestFormerParticipantsField (boolean value) {
      this.requestField("former_participants", value);
      return this;
    }
    public APIRequestGetConversations requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetConversations requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetConversations requestIsSubscribedField () {
      return this.requestIsSubscribedField(true);
    }
    public APIRequestGetConversations requestIsSubscribedField (boolean value) {
      this.requestField("is_subscribed", value);
      return this;
    }
    public APIRequestGetConversations requestLinkField () {
      return this.requestLinkField(true);
    }
    public APIRequestGetConversations requestLinkField (boolean value) {
      this.requestField("link", value);
      return this;
    }
    public APIRequestGetConversations requestMessageCountField () {
      return this.requestMessageCountField(true);
    }
    public APIRequestGetConversations requestMessageCountField (boolean value) {
      this.requestField("message_count", value);
      return this;
    }
    public APIRequestGetConversations requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetConversations requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetConversations requestParticipantsField () {
      return this.requestParticipantsField(true);
    }
    public APIRequestGetConversations requestParticipantsField (boolean value) {
      this.requestField("participants", value);
      return this;
    }
    public APIRequestGetConversations requestScopedThreadKeyField () {
      return this.requestScopedThreadKeyField(true);
    }
    public APIRequestGetConversations requestScopedThreadKeyField (boolean value) {
      this.requestField("scoped_thread_key", value);
      return this;
    }
    public APIRequestGetConversations requestSendersField () {
      return this.requestSendersField(true);
    }
    public APIRequestGetConversations requestSendersField (boolean value) {
      this.requestField("senders", value);
      return this;
    }
    public APIRequestGetConversations requestSnippetField () {
      return this.requestSnippetField(true);
    }
    public APIRequestGetConversations requestSnippetField (boolean value) {
      this.requestField("snippet", value);
      return this;
    }
    public APIRequestGetConversations requestSubjectField () {
      return this.requestSubjectField(true);
    }
    public APIRequestGetConversations requestSubjectField (boolean value) {
      this.requestField("subject", value);
      return this;
    }
    public APIRequestGetConversations requestTagsField () {
      return this.requestTagsField(true);
    }
    public APIRequestGetConversations requestTagsField (boolean value) {
      this.requestField("tags", value);
      return this;
    }
    public APIRequestGetConversations requestThreadKeyField () {
      return this.requestThreadKeyField(true);
    }
    public APIRequestGetConversations requestThreadKeyField (boolean value) {
      this.requestField("thread_key", value);
      return this;
    }
    public APIRequestGetConversations requestUnreadCountField () {
      return this.requestUnreadCountField(true);
    }
    public APIRequestGetConversations requestUnreadCountField (boolean value) {
      this.requestField("unread_count", value);
      return this;
    }
    public APIRequestGetConversations requestUpdatedTimeField () {
      return this.requestUpdatedTimeField(true);
    }
    public APIRequestGetConversations requestUpdatedTimeField (boolean value) {
      this.requestField("updated_time", value);
      return this;
    }
    public APIRequestGetConversations requestWallpaperField () {
      return this.requestWallpaperField(true);
    }
    public APIRequestGetConversations requestWallpaperField (boolean value) {
      this.requestField("wallpaper", value);
      return this;
    }
  }

  public static class APIRequestCreateCopyrightManualClaim extends APIRequest<APINode> {

    APINode lastResponse = null;
    @Override
    public APINode getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "reference_asset_id",
      "matched_asset_id",
      "match_content_type",
      "action",
      "countries",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINode parseResponse(String response) throws APIException {
      return APINode.parseResponse(response, getContext(), this).head();
    }

    @Override
    public APINode execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINode execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINode> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINode>() {
           public APINode apply(String result) {
             try {
               return APIRequestCreateCopyrightManualClaim.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateCopyrightManualClaim(String nodeId, APIContext context) {
      super(context, nodeId, "/copyright_manual_claims", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateCopyrightManualClaim setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateCopyrightManualClaim setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateCopyrightManualClaim setReferenceAssetId (String referenceAssetId) {
      this.setParam("reference_asset_id", referenceAssetId);
      return this;
    }

    public APIRequestCreateCopyrightManualClaim setMatchedAssetId (String matchedAssetId) {
      this.setParam("matched_asset_id", matchedAssetId);
      return this;
    }

    public APIRequestCreateCopyrightManualClaim setMatchContentType (EnumMatchContentType matchContentType) {
      this.setParam("match_content_type", matchContentType);
      return this;
    }
    public APIRequestCreateCopyrightManualClaim setMatchContentType (String matchContentType) {
      this.setParam("match_content_type", matchContentType);
      return this;
    }

    public APIRequestCreateCopyrightManualClaim setAction (EnumAction action) {
      this.setParam("action", action);
      return this;
    }
    public APIRequestCreateCopyrightManualClaim setAction (String action) {
      this.setParam("action", action);
      return this;
    }

    public APIRequestCreateCopyrightManualClaim setCountries (Object countries) {
      this.setParam("countries", countries);
      return this;
    }
    public APIRequestCreateCopyrightManualClaim setCountries (String countries) {
      this.setParam("countries", countries);
      return this;
    }

    public APIRequestCreateCopyrightManualClaim requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateCopyrightManualClaim requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateCopyrightManualClaim requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateCopyrightManualClaim requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateCopyrightManualClaim requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateCopyrightManualClaim requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestDeleteCopyrightWhitelistedIgPartners extends APIRequest<APINode> {

    APINodeList<APINode> lastResponse = null;
    @Override
    public APINodeList<APINode> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "usernames",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINodeList<APINode> parseResponse(String response) throws APIException {
      return APINode.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<APINode> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<APINode>>() {
           public APINodeList<APINode> apply(String result) {
             try {
               return APIRequestDeleteCopyrightWhitelistedIgPartners.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestDeleteCopyrightWhitelistedIgPartners(String nodeId, APIContext context) {
      super(context, nodeId, "/copyright_whitelisted_ig_partners", "DELETE", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestDeleteCopyrightWhitelistedIgPartners setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestDeleteCopyrightWhitelistedIgPartners setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestDeleteCopyrightWhitelistedIgPartners setUsernames (List<String> usernames) {
      this.setParam("usernames", usernames);
      return this;
    }
    public APIRequestDeleteCopyrightWhitelistedIgPartners setUsernames (String usernames) {
      this.setParam("usernames", usernames);
      return this;
    }

    public APIRequestDeleteCopyrightWhitelistedIgPartners requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestDeleteCopyrightWhitelistedIgPartners requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteCopyrightWhitelistedIgPartners requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestDeleteCopyrightWhitelistedIgPartners requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteCopyrightWhitelistedIgPartners requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestDeleteCopyrightWhitelistedIgPartners requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestCreateCopyrightWhitelistedIgPartner extends APIRequest<APINode> {

    APINode lastResponse = null;
    @Override
    public APINode getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "usernames",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINode parseResponse(String response) throws APIException {
      return APINode.parseResponse(response, getContext(), this).head();
    }

    @Override
    public APINode execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINode execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINode> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINode>() {
           public APINode apply(String result) {
             try {
               return APIRequestCreateCopyrightWhitelistedIgPartner.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateCopyrightWhitelistedIgPartner(String nodeId, APIContext context) {
      super(context, nodeId, "/copyright_whitelisted_ig_partners", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateCopyrightWhitelistedIgPartner setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateCopyrightWhitelistedIgPartner setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateCopyrightWhitelistedIgPartner setUsernames (List<String> usernames) {
      this.setParam("usernames", usernames);
      return this;
    }
    public APIRequestCreateCopyrightWhitelistedIgPartner setUsernames (String usernames) {
      this.setParam("usernames", usernames);
      return this;
    }

    public APIRequestCreateCopyrightWhitelistedIgPartner requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateCopyrightWhitelistedIgPartner requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateCopyrightWhitelistedIgPartner requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateCopyrightWhitelistedIgPartner requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateCopyrightWhitelistedIgPartner requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateCopyrightWhitelistedIgPartner requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestDeleteCopyrightWhitelistedPartners extends APIRequest<APINode> {

    APINodeList<APINode> lastResponse = null;
    @Override
    public APINodeList<APINode> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "partner_ids",
      "urls",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINodeList<APINode> parseResponse(String response) throws APIException {
      return APINode.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<APINode> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<APINode>>() {
           public APINodeList<APINode> apply(String result) {
             try {
               return APIRequestDeleteCopyrightWhitelistedPartners.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestDeleteCopyrightWhitelistedPartners(String nodeId, APIContext context) {
      super(context, nodeId, "/copyright_whitelisted_partners", "DELETE", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestDeleteCopyrightWhitelistedPartners setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestDeleteCopyrightWhitelistedPartners setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestDeleteCopyrightWhitelistedPartners setPartnerIds (List<Object> partnerIds) {
      this.setParam("partner_ids", partnerIds);
      return this;
    }
    public APIRequestDeleteCopyrightWhitelistedPartners setPartnerIds (String partnerIds) {
      this.setParam("partner_ids", partnerIds);
      return this;
    }

    public APIRequestDeleteCopyrightWhitelistedPartners setUrls (List<String> urls) {
      this.setParam("urls", urls);
      return this;
    }
    public APIRequestDeleteCopyrightWhitelistedPartners setUrls (String urls) {
      this.setParam("urls", urls);
      return this;
    }

    public APIRequestDeleteCopyrightWhitelistedPartners requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestDeleteCopyrightWhitelistedPartners requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteCopyrightWhitelistedPartners requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestDeleteCopyrightWhitelistedPartners requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteCopyrightWhitelistedPartners requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestDeleteCopyrightWhitelistedPartners requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetCopyrightWhitelistedPartners extends APIRequest<Profile> {

    APINodeList<Profile> lastResponse = null;
    @Override
    public APINodeList<Profile> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "can_post",
      "id",
      "link",
      "name",
      "pic",
      "pic_crop",
      "pic_large",
      "pic_small",
      "pic_square",
      "profile_type",
      "username",
    };

    @Override
    public APINodeList<Profile> parseResponse(String response) throws APIException {
      return Profile.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<Profile> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Profile> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Profile>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Profile>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<Profile>>() {
           public APINodeList<Profile> apply(String result) {
             try {
               return APIRequestGetCopyrightWhitelistedPartners.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetCopyrightWhitelistedPartners(String nodeId, APIContext context) {
      super(context, nodeId, "/copyright_whitelisted_partners", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetCopyrightWhitelistedPartners setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetCopyrightWhitelistedPartners setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetCopyrightWhitelistedPartners requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetCopyrightWhitelistedPartners requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCopyrightWhitelistedPartners requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetCopyrightWhitelistedPartners requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCopyrightWhitelistedPartners requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetCopyrightWhitelistedPartners requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetCopyrightWhitelistedPartners requestCanPostField () {
      return this.requestCanPostField(true);
    }
    public APIRequestGetCopyrightWhitelistedPartners requestCanPostField (boolean value) {
      this.requestField("can_post", value);
      return this;
    }
    public APIRequestGetCopyrightWhitelistedPartners requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetCopyrightWhitelistedPartners requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetCopyrightWhitelistedPartners requestLinkField () {
      return this.requestLinkField(true);
    }
    public APIRequestGetCopyrightWhitelistedPartners requestLinkField (boolean value) {
      this.requestField("link", value);
      return this;
    }
    public APIRequestGetCopyrightWhitelistedPartners requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetCopyrightWhitelistedPartners requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetCopyrightWhitelistedPartners requestPicField () {
      return this.requestPicField(true);
    }
    public APIRequestGetCopyrightWhitelistedPartners requestPicField (boolean value) {
      this.requestField("pic", value);
      return this;
    }
    public APIRequestGetCopyrightWhitelistedPartners requestPicCropField () {
      return this.requestPicCropField(true);
    }
    public APIRequestGetCopyrightWhitelistedPartners requestPicCropField (boolean value) {
      this.requestField("pic_crop", value);
      return this;
    }
    public APIRequestGetCopyrightWhitelistedPartners requestPicLargeField () {
      return this.requestPicLargeField(true);
    }
    public APIRequestGetCopyrightWhitelistedPartners requestPicLargeField (boolean value) {
      this.requestField("pic_large", value);
      return this;
    }
    public APIRequestGetCopyrightWhitelistedPartners requestPicSmallField () {
      return this.requestPicSmallField(true);
    }
    public APIRequestGetCopyrightWhitelistedPartners requestPicSmallField (boolean value) {
      this.requestField("pic_small", value);
      return this;
    }
    public APIRequestGetCopyrightWhitelistedPartners requestPicSquareField () {
      return this.requestPicSquareField(true);
    }
    public APIRequestGetCopyrightWhitelistedPartners requestPicSquareField (boolean value) {
      this.requestField("pic_square", value);
      return this;
    }
    public APIRequestGetCopyrightWhitelistedPartners requestProfileTypeField () {
      return this.requestProfileTypeField(true);
    }
    public APIRequestGetCopyrightWhitelistedPartners requestProfileTypeField (boolean value) {
      this.requestField("profile_type", value);
      return this;
    }
    public APIRequestGetCopyrightWhitelistedPartners requestUsernameField () {
      return this.requestUsernameField(true);
    }
    public APIRequestGetCopyrightWhitelistedPartners requestUsernameField (boolean value) {
      this.requestField("username", value);
      return this;
    }
  }

  public static class APIRequestCreateCopyrightWhitelistedPartner extends APIRequest<APINode> {

    APINode lastResponse = null;
    @Override
    public APINode getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "partner_ids",
      "urls",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINode parseResponse(String response) throws APIException {
      return APINode.parseResponse(response, getContext(), this).head();
    }

    @Override
    public APINode execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINode execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINode> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINode>() {
           public APINode apply(String result) {
             try {
               return APIRequestCreateCopyrightWhitelistedPartner.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateCopyrightWhitelistedPartner(String nodeId, APIContext context) {
      super(context, nodeId, "/copyright_whitelisted_partners", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateCopyrightWhitelistedPartner setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateCopyrightWhitelistedPartner setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateCopyrightWhitelistedPartner setPartnerIds (List<Object> partnerIds) {
      this.setParam("partner_ids", partnerIds);
      return this;
    }
    public APIRequestCreateCopyrightWhitelistedPartner setPartnerIds (String partnerIds) {
      this.setParam("partner_ids", partnerIds);
      return this;
    }

    public APIRequestCreateCopyrightWhitelistedPartner setUrls (List<String> urls) {
      this.setParam("urls", urls);
      return this;
    }
    public APIRequestCreateCopyrightWhitelistedPartner setUrls (String urls) {
      this.setParam("urls", urls);
      return this;
    }

    public APIRequestCreateCopyrightWhitelistedPartner requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateCopyrightWhitelistedPartner requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateCopyrightWhitelistedPartner requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateCopyrightWhitelistedPartner requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateCopyrightWhitelistedPartner requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateCopyrightWhitelistedPartner requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetCrosspostPendingApprovalPages extends APIRequest<Page> {

    APINodeList<Page> lastResponse = null;
    @Override
    public APINodeList<Page> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "about",
      "access_token",
      "ad_campaign",
      "affiliation",
      "app_id",
      "app_links",
      "artists_we_like",
      "attire",
      "awards",
      "band_interests",
      "band_members",
      "best_page",
      "bio",
      "birthday",
      "booking_agent",
      "built",
      "business",
      "can_checkin",
      "can_post",
      "category",
      "category_list",
      "checkins",
      "company_overview",
      "connected_instagram_account",
      "contact_address",
      "context",
      "copyright_attribution_insights",
      "copyright_whitelisted_ig_partners",
      "country_page_likes",
      "cover",
      "culinary_team",
      "current_location",
      "description",
      "description_html",
      "directed_by",
      "display_subtext",
      "displayed_message_response_time",
      "emails",
      "engagement",
      "fan_count",
      "featured_video",
      "features",
      "food_styles",
      "founded",
      "general_info",
      "general_manager",
      "genre",
      "global_brand_page_name",
      "global_brand_parent_page",
      "global_brand_root_id",
      "has_added_app",
      "has_whatsapp_business_number",
      "has_whatsapp_number",
      "hometown",
      "hours",
      "id",
      "impressum",
      "influences",
      "instagram_business_account",
      "instant_articles_review_status",
      "is_always_open",
      "is_chain",
      "is_community_page",
      "is_eligible_for_branded_content",
      "is_messenger_bot_get_started_enabled",
      "is_messenger_platform_bot",
      "is_owned",
      "is_permanently_closed",
      "is_published",
      "is_unclaimed",
      "is_verified",
      "is_webhooks_subscribed",
      "keywords",
      "leadgen_form_preview_details",
      "leadgen_has_crm_integration",
      "leadgen_has_fat_ping_crm_integration",
      "leadgen_tos_acceptance_time",
      "leadgen_tos_accepted",
      "leadgen_tos_accepting_user",
      "link",
      "location",
      "members",
      "merchant_id",
      "merchant_review_status",
      "messenger_ads_default_icebreakers",
      "messenger_ads_default_page_welcome_message",
      "messenger_ads_default_quick_replies",
      "messenger_ads_quick_replies_type",
      "mission",
      "mpg",
      "name",
      "name_with_location_descriptor",
      "network",
      "new_like_count",
      "offer_eligible",
      "overall_star_rating",
      "page_token",
      "parent_page",
      "parking",
      "payment_options",
      "personal_info",
      "personal_interests",
      "pharma_safety_info",
      "phone",
      "place_type",
      "plot_outline",
      "preferred_audience",
      "press_contact",
      "price_range",
      "produced_by",
      "products",
      "promotion_eligible",
      "promotion_ineligible_reason",
      "public_transit",
      "publisher_space",
      "rating_count",
      "recipient",
      "record_label",
      "release_date",
      "restaurant_services",
      "restaurant_specialties",
      "schedule",
      "screenplay_by",
      "season",
      "single_line_address",
      "starring",
      "start_info",
      "store_code",
      "store_location_descriptor",
      "store_number",
      "studio",
      "supports_instant_articles",
      "talking_about_count",
      "unread_message_count",
      "unread_notif_count",
      "unseen_message_count",
      "username",
      "verification_status",
      "voip_info",
      "website",
      "were_here_count",
      "whatsapp_number",
      "written_by",
    };

    @Override
    public APINodeList<Page> parseResponse(String response) throws APIException {
      return Page.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<Page> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Page> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Page>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Page>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<Page>>() {
           public APINodeList<Page> apply(String result) {
             try {
               return APIRequestGetCrosspostPendingApprovalPages.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetCrosspostPendingApprovalPages(String nodeId, APIContext context) {
      super(context, nodeId, "/crosspost_pending_approval_pages", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetCrosspostPendingApprovalPages setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetCrosspostPendingApprovalPages setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetCrosspostPendingApprovalPages requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetCrosspostPendingApprovalPages requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCrosspostPendingApprovalPages requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetCrosspostPendingApprovalPages requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCrosspostPendingApprovalPages requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetCrosspostPendingApprovalPages requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetCrosspostPendingApprovalPages requestAboutField () {
      return this.requestAboutField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestAboutField (boolean value) {
      this.requestField("about", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestAccessTokenField () {
      return this.requestAccessTokenField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestAccessTokenField (boolean value) {
      this.requestField("access_token", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestAdCampaignField () {
      return this.requestAdCampaignField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestAdCampaignField (boolean value) {
      this.requestField("ad_campaign", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestAffiliationField () {
      return this.requestAffiliationField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestAffiliationField (boolean value) {
      this.requestField("affiliation", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestAppIdField () {
      return this.requestAppIdField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestAppIdField (boolean value) {
      this.requestField("app_id", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestAppLinksField () {
      return this.requestAppLinksField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestAppLinksField (boolean value) {
      this.requestField("app_links", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestArtistsWeLikeField () {
      return this.requestArtistsWeLikeField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestArtistsWeLikeField (boolean value) {
      this.requestField("artists_we_like", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestAttireField () {
      return this.requestAttireField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestAttireField (boolean value) {
      this.requestField("attire", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestAwardsField () {
      return this.requestAwardsField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestAwardsField (boolean value) {
      this.requestField("awards", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestBandInterestsField () {
      return this.requestBandInterestsField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestBandInterestsField (boolean value) {
      this.requestField("band_interests", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestBandMembersField () {
      return this.requestBandMembersField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestBandMembersField (boolean value) {
      this.requestField("band_members", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestBestPageField () {
      return this.requestBestPageField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestBestPageField (boolean value) {
      this.requestField("best_page", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestBioField () {
      return this.requestBioField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestBioField (boolean value) {
      this.requestField("bio", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestBirthdayField () {
      return this.requestBirthdayField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestBirthdayField (boolean value) {
      this.requestField("birthday", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestBookingAgentField () {
      return this.requestBookingAgentField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestBookingAgentField (boolean value) {
      this.requestField("booking_agent", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestBuiltField () {
      return this.requestBuiltField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestBuiltField (boolean value) {
      this.requestField("built", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestBusinessField () {
      return this.requestBusinessField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestBusinessField (boolean value) {
      this.requestField("business", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestCanCheckinField () {
      return this.requestCanCheckinField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestCanCheckinField (boolean value) {
      this.requestField("can_checkin", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestCanPostField () {
      return this.requestCanPostField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestCanPostField (boolean value) {
      this.requestField("can_post", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestCategoryField () {
      return this.requestCategoryField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestCategoryField (boolean value) {
      this.requestField("category", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestCategoryListField () {
      return this.requestCategoryListField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestCategoryListField (boolean value) {
      this.requestField("category_list", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestCheckinsField () {
      return this.requestCheckinsField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestCheckinsField (boolean value) {
      this.requestField("checkins", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestCompanyOverviewField () {
      return this.requestCompanyOverviewField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestCompanyOverviewField (boolean value) {
      this.requestField("company_overview", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestConnectedInstagramAccountField () {
      return this.requestConnectedInstagramAccountField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestConnectedInstagramAccountField (boolean value) {
      this.requestField("connected_instagram_account", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestContactAddressField () {
      return this.requestContactAddressField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestContactAddressField (boolean value) {
      this.requestField("contact_address", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestContextField () {
      return this.requestContextField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestContextField (boolean value) {
      this.requestField("context", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestCopyrightAttributionInsightsField () {
      return this.requestCopyrightAttributionInsightsField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestCopyrightAttributionInsightsField (boolean value) {
      this.requestField("copyright_attribution_insights", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestCopyrightWhitelistedIgPartnersField () {
      return this.requestCopyrightWhitelistedIgPartnersField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestCopyrightWhitelistedIgPartnersField (boolean value) {
      this.requestField("copyright_whitelisted_ig_partners", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestCountryPageLikesField () {
      return this.requestCountryPageLikesField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestCountryPageLikesField (boolean value) {
      this.requestField("country_page_likes", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestCoverField () {
      return this.requestCoverField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestCoverField (boolean value) {
      this.requestField("cover", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestCulinaryTeamField () {
      return this.requestCulinaryTeamField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestCulinaryTeamField (boolean value) {
      this.requestField("culinary_team", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestCurrentLocationField () {
      return this.requestCurrentLocationField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestCurrentLocationField (boolean value) {
      this.requestField("current_location", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestDescriptionHtmlField () {
      return this.requestDescriptionHtmlField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestDescriptionHtmlField (boolean value) {
      this.requestField("description_html", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestDirectedByField () {
      return this.requestDirectedByField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestDirectedByField (boolean value) {
      this.requestField("directed_by", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestDisplaySubtextField () {
      return this.requestDisplaySubtextField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestDisplaySubtextField (boolean value) {
      this.requestField("display_subtext", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestDisplayedMessageResponseTimeField () {
      return this.requestDisplayedMessageResponseTimeField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestDisplayedMessageResponseTimeField (boolean value) {
      this.requestField("displayed_message_response_time", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestEmailsField () {
      return this.requestEmailsField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestEmailsField (boolean value) {
      this.requestField("emails", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestEngagementField () {
      return this.requestEngagementField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestEngagementField (boolean value) {
      this.requestField("engagement", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestFanCountField () {
      return this.requestFanCountField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestFanCountField (boolean value) {
      this.requestField("fan_count", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestFeaturedVideoField () {
      return this.requestFeaturedVideoField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestFeaturedVideoField (boolean value) {
      this.requestField("featured_video", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestFeaturesField () {
      return this.requestFeaturesField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestFeaturesField (boolean value) {
      this.requestField("features", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestFoodStylesField () {
      return this.requestFoodStylesField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestFoodStylesField (boolean value) {
      this.requestField("food_styles", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestFoundedField () {
      return this.requestFoundedField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestFoundedField (boolean value) {
      this.requestField("founded", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestGeneralInfoField () {
      return this.requestGeneralInfoField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestGeneralInfoField (boolean value) {
      this.requestField("general_info", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestGeneralManagerField () {
      return this.requestGeneralManagerField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestGeneralManagerField (boolean value) {
      this.requestField("general_manager", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestGenreField () {
      return this.requestGenreField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestGenreField (boolean value) {
      this.requestField("genre", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestGlobalBrandPageNameField () {
      return this.requestGlobalBrandPageNameField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestGlobalBrandPageNameField (boolean value) {
      this.requestField("global_brand_page_name", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestGlobalBrandParentPageField () {
      return this.requestGlobalBrandParentPageField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestGlobalBrandParentPageField (boolean value) {
      this.requestField("global_brand_parent_page", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestGlobalBrandRootIdField () {
      return this.requestGlobalBrandRootIdField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestGlobalBrandRootIdField (boolean value) {
      this.requestField("global_brand_root_id", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestHasAddedAppField () {
      return this.requestHasAddedAppField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestHasAddedAppField (boolean value) {
      this.requestField("has_added_app", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestHasWhatsappBusinessNumberField () {
      return this.requestHasWhatsappBusinessNumberField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestHasWhatsappBusinessNumberField (boolean value) {
      this.requestField("has_whatsapp_business_number", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestHasWhatsappNumberField () {
      return this.requestHasWhatsappNumberField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestHasWhatsappNumberField (boolean value) {
      this.requestField("has_whatsapp_number", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestHometownField () {
      return this.requestHometownField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestHometownField (boolean value) {
      this.requestField("hometown", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestHoursField () {
      return this.requestHoursField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestHoursField (boolean value) {
      this.requestField("hours", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestImpressumField () {
      return this.requestImpressumField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestImpressumField (boolean value) {
      this.requestField("impressum", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestInfluencesField () {
      return this.requestInfluencesField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestInfluencesField (boolean value) {
      this.requestField("influences", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestInstagramBusinessAccountField () {
      return this.requestInstagramBusinessAccountField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestInstagramBusinessAccountField (boolean value) {
      this.requestField("instagram_business_account", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestInstantArticlesReviewStatusField () {
      return this.requestInstantArticlesReviewStatusField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestInstantArticlesReviewStatusField (boolean value) {
      this.requestField("instant_articles_review_status", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestIsAlwaysOpenField () {
      return this.requestIsAlwaysOpenField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestIsAlwaysOpenField (boolean value) {
      this.requestField("is_always_open", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestIsChainField () {
      return this.requestIsChainField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestIsChainField (boolean value) {
      this.requestField("is_chain", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestIsCommunityPageField () {
      return this.requestIsCommunityPageField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestIsCommunityPageField (boolean value) {
      this.requestField("is_community_page", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestIsEligibleForBrandedContentField () {
      return this.requestIsEligibleForBrandedContentField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestIsEligibleForBrandedContentField (boolean value) {
      this.requestField("is_eligible_for_branded_content", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestIsMessengerBotGetStartedEnabledField () {
      return this.requestIsMessengerBotGetStartedEnabledField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestIsMessengerBotGetStartedEnabledField (boolean value) {
      this.requestField("is_messenger_bot_get_started_enabled", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestIsMessengerPlatformBotField () {
      return this.requestIsMessengerPlatformBotField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestIsMessengerPlatformBotField (boolean value) {
      this.requestField("is_messenger_platform_bot", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestIsOwnedField () {
      return this.requestIsOwnedField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestIsOwnedField (boolean value) {
      this.requestField("is_owned", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestIsPermanentlyClosedField () {
      return this.requestIsPermanentlyClosedField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestIsPermanentlyClosedField (boolean value) {
      this.requestField("is_permanently_closed", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestIsPublishedField () {
      return this.requestIsPublishedField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestIsPublishedField (boolean value) {
      this.requestField("is_published", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestIsUnclaimedField () {
      return this.requestIsUnclaimedField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestIsUnclaimedField (boolean value) {
      this.requestField("is_unclaimed", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestIsVerifiedField () {
      return this.requestIsVerifiedField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestIsVerifiedField (boolean value) {
      this.requestField("is_verified", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestIsWebhooksSubscribedField () {
      return this.requestIsWebhooksSubscribedField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestIsWebhooksSubscribedField (boolean value) {
      this.requestField("is_webhooks_subscribed", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestKeywordsField () {
      return this.requestKeywordsField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestKeywordsField (boolean value) {
      this.requestField("keywords", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestLeadgenFormPreviewDetailsField () {
      return this.requestLeadgenFormPreviewDetailsField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestLeadgenFormPreviewDetailsField (boolean value) {
      this.requestField("leadgen_form_preview_details", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestLeadgenHasCrmIntegrationField () {
      return this.requestLeadgenHasCrmIntegrationField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestLeadgenHasCrmIntegrationField (boolean value) {
      this.requestField("leadgen_has_crm_integration", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestLeadgenHasFatPingCrmIntegrationField () {
      return this.requestLeadgenHasFatPingCrmIntegrationField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestLeadgenHasFatPingCrmIntegrationField (boolean value) {
      this.requestField("leadgen_has_fat_ping_crm_integration", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestLeadgenTosAcceptanceTimeField () {
      return this.requestLeadgenTosAcceptanceTimeField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestLeadgenTosAcceptanceTimeField (boolean value) {
      this.requestField("leadgen_tos_acceptance_time", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestLeadgenTosAcceptedField () {
      return this.requestLeadgenTosAcceptedField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestLeadgenTosAcceptedField (boolean value) {
      this.requestField("leadgen_tos_accepted", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestLeadgenTosAcceptingUserField () {
      return this.requestLeadgenTosAcceptingUserField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestLeadgenTosAcceptingUserField (boolean value) {
      this.requestField("leadgen_tos_accepting_user", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestLinkField () {
      return this.requestLinkField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestLinkField (boolean value) {
      this.requestField("link", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestLocationField () {
      return this.requestLocationField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestLocationField (boolean value) {
      this.requestField("location", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestMembersField () {
      return this.requestMembersField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestMembersField (boolean value) {
      this.requestField("members", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestMerchantIdField () {
      return this.requestMerchantIdField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestMerchantIdField (boolean value) {
      this.requestField("merchant_id", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestMerchantReviewStatusField () {
      return this.requestMerchantReviewStatusField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestMerchantReviewStatusField (boolean value) {
      this.requestField("merchant_review_status", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestMessengerAdsDefaultIcebreakersField () {
      return this.requestMessengerAdsDefaultIcebreakersField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestMessengerAdsDefaultIcebreakersField (boolean value) {
      this.requestField("messenger_ads_default_icebreakers", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestMessengerAdsDefaultPageWelcomeMessageField () {
      return this.requestMessengerAdsDefaultPageWelcomeMessageField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestMessengerAdsDefaultPageWelcomeMessageField (boolean value) {
      this.requestField("messenger_ads_default_page_welcome_message", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestMessengerAdsDefaultQuickRepliesField () {
      return this.requestMessengerAdsDefaultQuickRepliesField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestMessengerAdsDefaultQuickRepliesField (boolean value) {
      this.requestField("messenger_ads_default_quick_replies", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestMessengerAdsQuickRepliesTypeField () {
      return this.requestMessengerAdsQuickRepliesTypeField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestMessengerAdsQuickRepliesTypeField (boolean value) {
      this.requestField("messenger_ads_quick_replies_type", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestMissionField () {
      return this.requestMissionField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestMissionField (boolean value) {
      this.requestField("mission", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestMpgField () {
      return this.requestMpgField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestMpgField (boolean value) {
      this.requestField("mpg", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestNameWithLocationDescriptorField () {
      return this.requestNameWithLocationDescriptorField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestNameWithLocationDescriptorField (boolean value) {
      this.requestField("name_with_location_descriptor", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestNetworkField () {
      return this.requestNetworkField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestNetworkField (boolean value) {
      this.requestField("network", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestNewLikeCountField () {
      return this.requestNewLikeCountField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestNewLikeCountField (boolean value) {
      this.requestField("new_like_count", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestOfferEligibleField () {
      return this.requestOfferEligibleField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestOfferEligibleField (boolean value) {
      this.requestField("offer_eligible", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestOverallStarRatingField () {
      return this.requestOverallStarRatingField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestOverallStarRatingField (boolean value) {
      this.requestField("overall_star_rating", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPageTokenField () {
      return this.requestPageTokenField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPageTokenField (boolean value) {
      this.requestField("page_token", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestParentPageField () {
      return this.requestParentPageField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestParentPageField (boolean value) {
      this.requestField("parent_page", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestParkingField () {
      return this.requestParkingField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestParkingField (boolean value) {
      this.requestField("parking", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPaymentOptionsField () {
      return this.requestPaymentOptionsField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPaymentOptionsField (boolean value) {
      this.requestField("payment_options", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPersonalInfoField () {
      return this.requestPersonalInfoField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPersonalInfoField (boolean value) {
      this.requestField("personal_info", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPersonalInterestsField () {
      return this.requestPersonalInterestsField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPersonalInterestsField (boolean value) {
      this.requestField("personal_interests", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPharmaSafetyInfoField () {
      return this.requestPharmaSafetyInfoField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPharmaSafetyInfoField (boolean value) {
      this.requestField("pharma_safety_info", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPhoneField () {
      return this.requestPhoneField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPhoneField (boolean value) {
      this.requestField("phone", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPlaceTypeField () {
      return this.requestPlaceTypeField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPlaceTypeField (boolean value) {
      this.requestField("place_type", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPlotOutlineField () {
      return this.requestPlotOutlineField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPlotOutlineField (boolean value) {
      this.requestField("plot_outline", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPreferredAudienceField () {
      return this.requestPreferredAudienceField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPreferredAudienceField (boolean value) {
      this.requestField("preferred_audience", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPressContactField () {
      return this.requestPressContactField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPressContactField (boolean value) {
      this.requestField("press_contact", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPriceRangeField () {
      return this.requestPriceRangeField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPriceRangeField (boolean value) {
      this.requestField("price_range", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestProducedByField () {
      return this.requestProducedByField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestProducedByField (boolean value) {
      this.requestField("produced_by", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestProductsField () {
      return this.requestProductsField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestProductsField (boolean value) {
      this.requestField("products", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPromotionEligibleField () {
      return this.requestPromotionEligibleField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPromotionEligibleField (boolean value) {
      this.requestField("promotion_eligible", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPromotionIneligibleReasonField () {
      return this.requestPromotionIneligibleReasonField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPromotionIneligibleReasonField (boolean value) {
      this.requestField("promotion_ineligible_reason", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPublicTransitField () {
      return this.requestPublicTransitField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPublicTransitField (boolean value) {
      this.requestField("public_transit", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPublisherSpaceField () {
      return this.requestPublisherSpaceField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestPublisherSpaceField (boolean value) {
      this.requestField("publisher_space", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestRatingCountField () {
      return this.requestRatingCountField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestRatingCountField (boolean value) {
      this.requestField("rating_count", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestRecipientField () {
      return this.requestRecipientField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestRecipientField (boolean value) {
      this.requestField("recipient", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestRecordLabelField () {
      return this.requestRecordLabelField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestRecordLabelField (boolean value) {
      this.requestField("record_label", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestReleaseDateField () {
      return this.requestReleaseDateField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestReleaseDateField (boolean value) {
      this.requestField("release_date", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestRestaurantServicesField () {
      return this.requestRestaurantServicesField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestRestaurantServicesField (boolean value) {
      this.requestField("restaurant_services", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestRestaurantSpecialtiesField () {
      return this.requestRestaurantSpecialtiesField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestRestaurantSpecialtiesField (boolean value) {
      this.requestField("restaurant_specialties", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestScheduleField () {
      return this.requestScheduleField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestScheduleField (boolean value) {
      this.requestField("schedule", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestScreenplayByField () {
      return this.requestScreenplayByField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestScreenplayByField (boolean value) {
      this.requestField("screenplay_by", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestSeasonField () {
      return this.requestSeasonField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestSeasonField (boolean value) {
      this.requestField("season", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestSingleLineAddressField () {
      return this.requestSingleLineAddressField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestSingleLineAddressField (boolean value) {
      this.requestField("single_line_address", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestStarringField () {
      return this.requestStarringField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestStarringField (boolean value) {
      this.requestField("starring", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestStartInfoField () {
      return this.requestStartInfoField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestStartInfoField (boolean value) {
      this.requestField("start_info", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestStoreCodeField () {
      return this.requestStoreCodeField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestStoreCodeField (boolean value) {
      this.requestField("store_code", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestStoreLocationDescriptorField () {
      return this.requestStoreLocationDescriptorField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestStoreLocationDescriptorField (boolean value) {
      this.requestField("store_location_descriptor", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestStoreNumberField () {
      return this.requestStoreNumberField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestStoreNumberField (boolean value) {
      this.requestField("store_number", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestStudioField () {
      return this.requestStudioField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestStudioField (boolean value) {
      this.requestField("studio", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestSupportsInstantArticlesField () {
      return this.requestSupportsInstantArticlesField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestSupportsInstantArticlesField (boolean value) {
      this.requestField("supports_instant_articles", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestTalkingAboutCountField () {
      return this.requestTalkingAboutCountField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestTalkingAboutCountField (boolean value) {
      this.requestField("talking_about_count", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestUnreadMessageCountField () {
      return this.requestUnreadMessageCountField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestUnreadMessageCountField (boolean value) {
      this.requestField("unread_message_count", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestUnreadNotifCountField () {
      return this.requestUnreadNotifCountField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestUnreadNotifCountField (boolean value) {
      this.requestField("unread_notif_count", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestUnseenMessageCountField () {
      return this.requestUnseenMessageCountField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestUnseenMessageCountField (boolean value) {
      this.requestField("unseen_message_count", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestUsernameField () {
      return this.requestUsernameField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestUsernameField (boolean value) {
      this.requestField("username", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestVerificationStatusField () {
      return this.requestVerificationStatusField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestVerificationStatusField (boolean value) {
      this.requestField("verification_status", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestVoipInfoField () {
      return this.requestVoipInfoField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestVoipInfoField (boolean value) {
      this.requestField("voip_info", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestWebsiteField () {
      return this.requestWebsiteField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestWebsiteField (boolean value) {
      this.requestField("website", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestWereHereCountField () {
      return this.requestWereHereCountField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestWereHereCountField (boolean value) {
      this.requestField("were_here_count", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestWhatsappNumberField () {
      return this.requestWhatsappNumberField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestWhatsappNumberField (boolean value) {
      this.requestField("whatsapp_number", value);
      return this;
    }
    public APIRequestGetCrosspostPendingApprovalPages requestWrittenByField () {
      return this.requestWrittenByField(true);
    }
    public APIRequestGetCrosspostPendingApprovalPages requestWrittenByField (boolean value) {
      this.requestField("written_by", value);
      return this;
    }
  }

  public static class APIRequestGetCrosspostWhitelistedPages extends APIRequest<Page> {

    APINodeList<Page> lastResponse = null;
    @Override
    public APINodeList<Page> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "about",
      "access_token",
      "ad_campaign",
      "affiliation",
      "app_id",
      "app_links",
      "artists_we_like",
      "attire",
      "awards",
      "band_interests",
      "band_members",
      "best_page",
      "bio",
      "birthday",
      "booking_agent",
      "built",
      "business",
      "can_checkin",
      "can_post",
      "category",
      "category_list",
      "checkins",
      "company_overview",
      "connected_instagram_account",
      "contact_address",
      "context",
      "copyright_attribution_insights",
      "copyright_whitelisted_ig_partners",
      "country_page_likes",
      "cover",
      "culinary_team",
      "current_location",
      "description",
      "description_html",
      "directed_by",
      "display_subtext",
      "displayed_message_response_time",
      "emails",
      "engagement",
      "fan_count",
      "featured_video",
      "features",
      "food_styles",
      "founded",
      "general_info",
      "general_manager",
      "genre",
      "global_brand_page_name",
      "global_brand_parent_page",
      "global_brand_root_id",
      "has_added_app",
      "has_whatsapp_business_number",
      "has_whatsapp_number",
      "hometown",
      "hours",
      "id",
      "impressum",
      "influences",
      "instagram_business_account",
      "instant_articles_review_status",
      "is_always_open",
      "is_chain",
      "is_community_page",
      "is_eligible_for_branded_content",
      "is_messenger_bot_get_started_enabled",
      "is_messenger_platform_bot",
      "is_owned",
      "is_permanently_closed",
      "is_published",
      "is_unclaimed",
      "is_verified",
      "is_webhooks_subscribed",
      "keywords",
      "leadgen_form_preview_details",
      "leadgen_has_crm_integration",
      "leadgen_has_fat_ping_crm_integration",
      "leadgen_tos_acceptance_time",
      "leadgen_tos_accepted",
      "leadgen_tos_accepting_user",
      "link",
      "location",
      "members",
      "merchant_id",
      "merchant_review_status",
      "messenger_ads_default_icebreakers",
      "messenger_ads_default_page_welcome_message",
      "messenger_ads_default_quick_replies",
      "messenger_ads_quick_replies_type",
      "mission",
      "mpg",
      "name",
      "name_with_location_descriptor",
      "network",
      "new_like_count",
      "offer_eligible",
      "overall_star_rating",
      "page_token",
      "parent_page",
      "parking",
      "payment_options",
      "personal_info",
      "personal_interests",
      "pharma_safety_info",
      "phone",
      "place_type",
      "plot_outline",
      "preferred_audience",
      "press_contact",
      "price_range",
      "produced_by",
      "products",
      "promotion_eligible",
      "promotion_ineligible_reason",
      "public_transit",
      "publisher_space",
      "rating_count",
      "recipient",
      "record_label",
      "release_date",
      "restaurant_services",
      "restaurant_specialties",
      "schedule",
      "screenplay_by",
      "season",
      "single_line_address",
      "starring",
      "start_info",
      "store_code",
      "store_location_descriptor",
      "store_number",
      "studio",
      "supports_instant_articles",
      "talking_about_count",
      "unread_message_count",
      "unread_notif_count",
      "unseen_message_count",
      "username",
      "verification_status",
      "voip_info",
      "website",
      "were_here_count",
      "whatsapp_number",
      "written_by",
    };

    @Override
    public APINodeList<Page> parseResponse(String response) throws APIException {
      return Page.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<Page> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Page> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Page>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Page>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<Page>>() {
           public APINodeList<Page> apply(String result) {
             try {
               return APIRequestGetCrosspostWhitelistedPages.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetCrosspostWhitelistedPages(String nodeId, APIContext context) {
      super(context, nodeId, "/crosspost_whitelisted_pages", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetCrosspostWhitelistedPages setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetCrosspostWhitelistedPages setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetCrosspostWhitelistedPages requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetCrosspostWhitelistedPages requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCrosspostWhitelistedPages requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetCrosspostWhitelistedPages requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCrosspostWhitelistedPages requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetCrosspostWhitelistedPages requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetCrosspostWhitelistedPages requestAboutField () {
      return this.requestAboutField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestAboutField (boolean value) {
      this.requestField("about", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestAccessTokenField () {
      return this.requestAccessTokenField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestAccessTokenField (boolean value) {
      this.requestField("access_token", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestAdCampaignField () {
      return this.requestAdCampaignField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestAdCampaignField (boolean value) {
      this.requestField("ad_campaign", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestAffiliationField () {
      return this.requestAffiliationField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestAffiliationField (boolean value) {
      this.requestField("affiliation", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestAppIdField () {
      return this.requestAppIdField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestAppIdField (boolean value) {
      this.requestField("app_id", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestAppLinksField () {
      return this.requestAppLinksField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestAppLinksField (boolean value) {
      this.requestField("app_links", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestArtistsWeLikeField () {
      return this.requestArtistsWeLikeField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestArtistsWeLikeField (boolean value) {
      this.requestField("artists_we_like", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestAttireField () {
      return this.requestAttireField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestAttireField (boolean value) {
      this.requestField("attire", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestAwardsField () {
      return this.requestAwardsField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestAwardsField (boolean value) {
      this.requestField("awards", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestBandInterestsField () {
      return this.requestBandInterestsField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestBandInterestsField (boolean value) {
      this.requestField("band_interests", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestBandMembersField () {
      return this.requestBandMembersField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestBandMembersField (boolean value) {
      this.requestField("band_members", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestBestPageField () {
      return this.requestBestPageField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestBestPageField (boolean value) {
      this.requestField("best_page", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestBioField () {
      return this.requestBioField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestBioField (boolean value) {
      this.requestField("bio", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestBirthdayField () {
      return this.requestBirthdayField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestBirthdayField (boolean value) {
      this.requestField("birthday", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestBookingAgentField () {
      return this.requestBookingAgentField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestBookingAgentField (boolean value) {
      this.requestField("booking_agent", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestBuiltField () {
      return this.requestBuiltField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestBuiltField (boolean value) {
      this.requestField("built", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestBusinessField () {
      return this.requestBusinessField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestBusinessField (boolean value) {
      this.requestField("business", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestCanCheckinField () {
      return this.requestCanCheckinField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestCanCheckinField (boolean value) {
      this.requestField("can_checkin", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestCanPostField () {
      return this.requestCanPostField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestCanPostField (boolean value) {
      this.requestField("can_post", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestCategoryField () {
      return this.requestCategoryField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestCategoryField (boolean value) {
      this.requestField("category", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestCategoryListField () {
      return this.requestCategoryListField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestCategoryListField (boolean value) {
      this.requestField("category_list", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestCheckinsField () {
      return this.requestCheckinsField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestCheckinsField (boolean value) {
      this.requestField("checkins", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestCompanyOverviewField () {
      return this.requestCompanyOverviewField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestCompanyOverviewField (boolean value) {
      this.requestField("company_overview", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestConnectedInstagramAccountField () {
      return this.requestConnectedInstagramAccountField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestConnectedInstagramAccountField (boolean value) {
      this.requestField("connected_instagram_account", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestContactAddressField () {
      return this.requestContactAddressField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestContactAddressField (boolean value) {
      this.requestField("contact_address", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestContextField () {
      return this.requestContextField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestContextField (boolean value) {
      this.requestField("context", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestCopyrightAttributionInsightsField () {
      return this.requestCopyrightAttributionInsightsField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestCopyrightAttributionInsightsField (boolean value) {
      this.requestField("copyright_attribution_insights", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestCopyrightWhitelistedIgPartnersField () {
      return this.requestCopyrightWhitelistedIgPartnersField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestCopyrightWhitelistedIgPartnersField (boolean value) {
      this.requestField("copyright_whitelisted_ig_partners", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestCountryPageLikesField () {
      return this.requestCountryPageLikesField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestCountryPageLikesField (boolean value) {
      this.requestField("country_page_likes", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestCoverField () {
      return this.requestCoverField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestCoverField (boolean value) {
      this.requestField("cover", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestCulinaryTeamField () {
      return this.requestCulinaryTeamField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestCulinaryTeamField (boolean value) {
      this.requestField("culinary_team", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestCurrentLocationField () {
      return this.requestCurrentLocationField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestCurrentLocationField (boolean value) {
      this.requestField("current_location", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestDescriptionHtmlField () {
      return this.requestDescriptionHtmlField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestDescriptionHtmlField (boolean value) {
      this.requestField("description_html", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestDirectedByField () {
      return this.requestDirectedByField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestDirectedByField (boolean value) {
      this.requestField("directed_by", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestDisplaySubtextField () {
      return this.requestDisplaySubtextField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestDisplaySubtextField (boolean value) {
      this.requestField("display_subtext", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestDisplayedMessageResponseTimeField () {
      return this.requestDisplayedMessageResponseTimeField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestDisplayedMessageResponseTimeField (boolean value) {
      this.requestField("displayed_message_response_time", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestEmailsField () {
      return this.requestEmailsField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestEmailsField (boolean value) {
      this.requestField("emails", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestEngagementField () {
      return this.requestEngagementField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestEngagementField (boolean value) {
      this.requestField("engagement", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestFanCountField () {
      return this.requestFanCountField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestFanCountField (boolean value) {
      this.requestField("fan_count", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestFeaturedVideoField () {
      return this.requestFeaturedVideoField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestFeaturedVideoField (boolean value) {
      this.requestField("featured_video", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestFeaturesField () {
      return this.requestFeaturesField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestFeaturesField (boolean value) {
      this.requestField("features", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestFoodStylesField () {
      return this.requestFoodStylesField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestFoodStylesField (boolean value) {
      this.requestField("food_styles", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestFoundedField () {
      return this.requestFoundedField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestFoundedField (boolean value) {
      this.requestField("founded", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestGeneralInfoField () {
      return this.requestGeneralInfoField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestGeneralInfoField (boolean value) {
      this.requestField("general_info", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestGeneralManagerField () {
      return this.requestGeneralManagerField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestGeneralManagerField (boolean value) {
      this.requestField("general_manager", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestGenreField () {
      return this.requestGenreField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestGenreField (boolean value) {
      this.requestField("genre", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestGlobalBrandPageNameField () {
      return this.requestGlobalBrandPageNameField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestGlobalBrandPageNameField (boolean value) {
      this.requestField("global_brand_page_name", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestGlobalBrandParentPageField () {
      return this.requestGlobalBrandParentPageField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestGlobalBrandParentPageField (boolean value) {
      this.requestField("global_brand_parent_page", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestGlobalBrandRootIdField () {
      return this.requestGlobalBrandRootIdField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestGlobalBrandRootIdField (boolean value) {
      this.requestField("global_brand_root_id", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestHasAddedAppField () {
      return this.requestHasAddedAppField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestHasAddedAppField (boolean value) {
      this.requestField("has_added_app", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestHasWhatsappBusinessNumberField () {
      return this.requestHasWhatsappBusinessNumberField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestHasWhatsappBusinessNumberField (boolean value) {
      this.requestField("has_whatsapp_business_number", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestHasWhatsappNumberField () {
      return this.requestHasWhatsappNumberField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestHasWhatsappNumberField (boolean value) {
      this.requestField("has_whatsapp_number", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestHometownField () {
      return this.requestHometownField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestHometownField (boolean value) {
      this.requestField("hometown", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestHoursField () {
      return this.requestHoursField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestHoursField (boolean value) {
      this.requestField("hours", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestImpressumField () {
      return this.requestImpressumField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestImpressumField (boolean value) {
      this.requestField("impressum", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestInfluencesField () {
      return this.requestInfluencesField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestInfluencesField (boolean value) {
      this.requestField("influences", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestInstagramBusinessAccountField () {
      return this.requestInstagramBusinessAccountField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestInstagramBusinessAccountField (boolean value) {
      this.requestField("instagram_business_account", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestInstantArticlesReviewStatusField () {
      return this.requestInstantArticlesReviewStatusField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestInstantArticlesReviewStatusField (boolean value) {
      this.requestField("instant_articles_review_status", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsAlwaysOpenField () {
      return this.requestIsAlwaysOpenField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsAlwaysOpenField (boolean value) {
      this.requestField("is_always_open", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsChainField () {
      return this.requestIsChainField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsChainField (boolean value) {
      this.requestField("is_chain", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsCommunityPageField () {
      return this.requestIsCommunityPageField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsCommunityPageField (boolean value) {
      this.requestField("is_community_page", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsEligibleForBrandedContentField () {
      return this.requestIsEligibleForBrandedContentField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsEligibleForBrandedContentField (boolean value) {
      this.requestField("is_eligible_for_branded_content", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsMessengerBotGetStartedEnabledField () {
      return this.requestIsMessengerBotGetStartedEnabledField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsMessengerBotGetStartedEnabledField (boolean value) {
      this.requestField("is_messenger_bot_get_started_enabled", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsMessengerPlatformBotField () {
      return this.requestIsMessengerPlatformBotField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsMessengerPlatformBotField (boolean value) {
      this.requestField("is_messenger_platform_bot", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsOwnedField () {
      return this.requestIsOwnedField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsOwnedField (boolean value) {
      this.requestField("is_owned", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsPermanentlyClosedField () {
      return this.requestIsPermanentlyClosedField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsPermanentlyClosedField (boolean value) {
      this.requestField("is_permanently_closed", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsPublishedField () {
      return this.requestIsPublishedField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsPublishedField (boolean value) {
      this.requestField("is_published", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsUnclaimedField () {
      return this.requestIsUnclaimedField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsUnclaimedField (boolean value) {
      this.requestField("is_unclaimed", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsVerifiedField () {
      return this.requestIsVerifiedField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsVerifiedField (boolean value) {
      this.requestField("is_verified", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsWebhooksSubscribedField () {
      return this.requestIsWebhooksSubscribedField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestIsWebhooksSubscribedField (boolean value) {
      this.requestField("is_webhooks_subscribed", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestKeywordsField () {
      return this.requestKeywordsField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestKeywordsField (boolean value) {
      this.requestField("keywords", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestLeadgenFormPreviewDetailsField () {
      return this.requestLeadgenFormPreviewDetailsField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestLeadgenFormPreviewDetailsField (boolean value) {
      this.requestField("leadgen_form_preview_details", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestLeadgenHasCrmIntegrationField () {
      return this.requestLeadgenHasCrmIntegrationField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestLeadgenHasCrmIntegrationField (boolean value) {
      this.requestField("leadgen_has_crm_integration", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestLeadgenHasFatPingCrmIntegrationField () {
      return this.requestLeadgenHasFatPingCrmIntegrationField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestLeadgenHasFatPingCrmIntegrationField (boolean value) {
      this.requestField("leadgen_has_fat_ping_crm_integration", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestLeadgenTosAcceptanceTimeField () {
      return this.requestLeadgenTosAcceptanceTimeField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestLeadgenTosAcceptanceTimeField (boolean value) {
      this.requestField("leadgen_tos_acceptance_time", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestLeadgenTosAcceptedField () {
      return this.requestLeadgenTosAcceptedField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestLeadgenTosAcceptedField (boolean value) {
      this.requestField("leadgen_tos_accepted", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestLeadgenTosAcceptingUserField () {
      return this.requestLeadgenTosAcceptingUserField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestLeadgenTosAcceptingUserField (boolean value) {
      this.requestField("leadgen_tos_accepting_user", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestLinkField () {
      return this.requestLinkField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestLinkField (boolean value) {
      this.requestField("link", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestLocationField () {
      return this.requestLocationField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestLocationField (boolean value) {
      this.requestField("location", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestMembersField () {
      return this.requestMembersField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestMembersField (boolean value) {
      this.requestField("members", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestMerchantIdField () {
      return this.requestMerchantIdField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestMerchantIdField (boolean value) {
      this.requestField("merchant_id", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestMerchantReviewStatusField () {
      return this.requestMerchantReviewStatusField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestMerchantReviewStatusField (boolean value) {
      this.requestField("merchant_review_status", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestMessengerAdsDefaultIcebreakersField () {
      return this.requestMessengerAdsDefaultIcebreakersField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestMessengerAdsDefaultIcebreakersField (boolean value) {
      this.requestField("messenger_ads_default_icebreakers", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestMessengerAdsDefaultPageWelcomeMessageField () {
      return this.requestMessengerAdsDefaultPageWelcomeMessageField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestMessengerAdsDefaultPageWelcomeMessageField (boolean value) {
      this.requestField("messenger_ads_default_page_welcome_message", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestMessengerAdsDefaultQuickRepliesField () {
      return this.requestMessengerAdsDefaultQuickRepliesField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestMessengerAdsDefaultQuickRepliesField (boolean value) {
      this.requestField("messenger_ads_default_quick_replies", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestMessengerAdsQuickRepliesTypeField () {
      return this.requestMessengerAdsQuickRepliesTypeField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestMessengerAdsQuickRepliesTypeField (boolean value) {
      this.requestField("messenger_ads_quick_replies_type", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestMissionField () {
      return this.requestMissionField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestMissionField (boolean value) {
      this.requestField("mission", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestMpgField () {
      return this.requestMpgField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestMpgField (boolean value) {
      this.requestField("mpg", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestNameWithLocationDescriptorField () {
      return this.requestNameWithLocationDescriptorField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestNameWithLocationDescriptorField (boolean value) {
      this.requestField("name_with_location_descriptor", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestNetworkField () {
      return this.requestNetworkField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestNetworkField (boolean value) {
      this.requestField("network", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestNewLikeCountField () {
      return this.requestNewLikeCountField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestNewLikeCountField (boolean value) {
      this.requestField("new_like_count", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestOfferEligibleField () {
      return this.requestOfferEligibleField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestOfferEligibleField (boolean value) {
      this.requestField("offer_eligible", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestOverallStarRatingField () {
      return this.requestOverallStarRatingField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestOverallStarRatingField (boolean value) {
      this.requestField("overall_star_rating", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPageTokenField () {
      return this.requestPageTokenField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPageTokenField (boolean value) {
      this.requestField("page_token", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestParentPageField () {
      return this.requestParentPageField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestParentPageField (boolean value) {
      this.requestField("parent_page", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestParkingField () {
      return this.requestParkingField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestParkingField (boolean value) {
      this.requestField("parking", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPaymentOptionsField () {
      return this.requestPaymentOptionsField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPaymentOptionsField (boolean value) {
      this.requestField("payment_options", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPersonalInfoField () {
      return this.requestPersonalInfoField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPersonalInfoField (boolean value) {
      this.requestField("personal_info", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPersonalInterestsField () {
      return this.requestPersonalInterestsField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPersonalInterestsField (boolean value) {
      this.requestField("personal_interests", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPharmaSafetyInfoField () {
      return this.requestPharmaSafetyInfoField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPharmaSafetyInfoField (boolean value) {
      this.requestField("pharma_safety_info", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPhoneField () {
      return this.requestPhoneField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPhoneField (boolean value) {
      this.requestField("phone", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPlaceTypeField () {
      return this.requestPlaceTypeField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPlaceTypeField (boolean value) {
      this.requestField("place_type", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPlotOutlineField () {
      return this.requestPlotOutlineField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPlotOutlineField (boolean value) {
      this.requestField("plot_outline", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPreferredAudienceField () {
      return this.requestPreferredAudienceField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPreferredAudienceField (boolean value) {
      this.requestField("preferred_audience", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPressContactField () {
      return this.requestPressContactField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPressContactField (boolean value) {
      this.requestField("press_contact", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPriceRangeField () {
      return this.requestPriceRangeField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPriceRangeField (boolean value) {
      this.requestField("price_range", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestProducedByField () {
      return this.requestProducedByField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestProducedByField (boolean value) {
      this.requestField("produced_by", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestProductsField () {
      return this.requestProductsField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestProductsField (boolean value) {
      this.requestField("products", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPromotionEligibleField () {
      return this.requestPromotionEligibleField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPromotionEligibleField (boolean value) {
      this.requestField("promotion_eligible", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPromotionIneligibleReasonField () {
      return this.requestPromotionIneligibleReasonField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPromotionIneligibleReasonField (boolean value) {
      this.requestField("promotion_ineligible_reason", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPublicTransitField () {
      return this.requestPublicTransitField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPublicTransitField (boolean value) {
      this.requestField("public_transit", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestPublisherSpaceField () {
      return this.requestPublisherSpaceField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestPublisherSpaceField (boolean value) {
      this.requestField("publisher_space", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestRatingCountField () {
      return this.requestRatingCountField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestRatingCountField (boolean value) {
      this.requestField("rating_count", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestRecipientField () {
      return this.requestRecipientField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestRecipientField (boolean value) {
      this.requestField("recipient", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestRecordLabelField () {
      return this.requestRecordLabelField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestRecordLabelField (boolean value) {
      this.requestField("record_label", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestReleaseDateField () {
      return this.requestReleaseDateField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestReleaseDateField (boolean value) {
      this.requestField("release_date", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestRestaurantServicesField () {
      return this.requestRestaurantServicesField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestRestaurantServicesField (boolean value) {
      this.requestField("restaurant_services", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestRestaurantSpecialtiesField () {
      return this.requestRestaurantSpecialtiesField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestRestaurantSpecialtiesField (boolean value) {
      this.requestField("restaurant_specialties", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestScheduleField () {
      return this.requestScheduleField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestScheduleField (boolean value) {
      this.requestField("schedule", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestScreenplayByField () {
      return this.requestScreenplayByField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestScreenplayByField (boolean value) {
      this.requestField("screenplay_by", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestSeasonField () {
      return this.requestSeasonField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestSeasonField (boolean value) {
      this.requestField("season", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestSingleLineAddressField () {
      return this.requestSingleLineAddressField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestSingleLineAddressField (boolean value) {
      this.requestField("single_line_address", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestStarringField () {
      return this.requestStarringField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestStarringField (boolean value) {
      this.requestField("starring", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestStartInfoField () {
      return this.requestStartInfoField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestStartInfoField (boolean value) {
      this.requestField("start_info", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestStoreCodeField () {
      return this.requestStoreCodeField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestStoreCodeField (boolean value) {
      this.requestField("store_code", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestStoreLocationDescriptorField () {
      return this.requestStoreLocationDescriptorField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestStoreLocationDescriptorField (boolean value) {
      this.requestField("store_location_descriptor", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestStoreNumberField () {
      return this.requestStoreNumberField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestStoreNumberField (boolean value) {
      this.requestField("store_number", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestStudioField () {
      return this.requestStudioField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestStudioField (boolean value) {
      this.requestField("studio", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestSupportsInstantArticlesField () {
      return this.requestSupportsInstantArticlesField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestSupportsInstantArticlesField (boolean value) {
      this.requestField("supports_instant_articles", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestTalkingAboutCountField () {
      return this.requestTalkingAboutCountField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestTalkingAboutCountField (boolean value) {
      this.requestField("talking_about_count", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestUnreadMessageCountField () {
      return this.requestUnreadMessageCountField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestUnreadMessageCountField (boolean value) {
      this.requestField("unread_message_count", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestUnreadNotifCountField () {
      return this.requestUnreadNotifCountField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestUnreadNotifCountField (boolean value) {
      this.requestField("unread_notif_count", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestUnseenMessageCountField () {
      return this.requestUnseenMessageCountField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestUnseenMessageCountField (boolean value) {
      this.requestField("unseen_message_count", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestUsernameField () {
      return this.requestUsernameField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestUsernameField (boolean value) {
      this.requestField("username", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestVerificationStatusField () {
      return this.requestVerificationStatusField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestVerificationStatusField (boolean value) {
      this.requestField("verification_status", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestVoipInfoField () {
      return this.requestVoipInfoField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestVoipInfoField (boolean value) {
      this.requestField("voip_info", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestWebsiteField () {
      return this.requestWebsiteField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestWebsiteField (boolean value) {
      this.requestField("website", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestWereHereCountField () {
      return this.requestWereHereCountField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestWereHereCountField (boolean value) {
      this.requestField("were_here_count", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestWhatsappNumberField () {
      return this.requestWhatsappNumberField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestWhatsappNumberField (boolean value) {
      this.requestField("whatsapp_number", value);
      return this;
    }
    public APIRequestGetCrosspostWhitelistedPages requestWrittenByField () {
      return this.requestWrittenByField(true);
    }
    public APIRequestGetCrosspostWhitelistedPages requestWrittenByField (boolean value) {
      this.requestField("written_by", value);
      return this;
    }
  }

  public static class APIRequestGetCustomLabels extends APIRequest<PageUserMessageThreadLabel> {

    APINodeList<PageUserMessageThreadLabel> lastResponse = null;
    @Override
    public APINodeList<PageUserMessageThreadLabel> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "id",
      "name",
    };

    @Override
    public APINodeList<PageUserMessageThreadLabel> parseResponse(String response) throws APIException {
      return PageUserMessageThreadLabel.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<PageUserMessageThreadLabel> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<PageUserMessageThreadLabel> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<PageUserMessageThreadLabel>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<PageUserMessageThreadLabel>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<PageUserMessageThreadLabel>>() {
           public APINodeList<PageUserMessageThreadLabel> apply(String result) {
             try {
               return APIRequestGetCustomLabels.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetCustomLabels(String nodeId, APIContext context) {
      super(context, nodeId, "/custom_labels", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetCustomLabels setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetCustomLabels setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetCustomLabels requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetCustomLabels requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCustomLabels requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetCustomLabels requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetCustomLabels requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetCustomLabels requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetCustomLabels requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetCustomLabels requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetCustomLabels requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetCustomLabels requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
  }

  public static class APIRequestCreateCustomLabel extends APIRequest<PageUserMessageThreadLabel> {

    PageUserMessageThreadLabel lastResponse = null;
    @Override
    public PageUserMessageThreadLabel getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "name",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public PageUserMessageThreadLabel parseResponse(String response) throws APIException {
      return PageUserMessageThreadLabel.parseResponse(response, getContext(), this).head();
    }

    @Override
    public PageUserMessageThreadLabel execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public PageUserMessageThreadLabel execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<PageUserMessageThreadLabel> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<PageUserMessageThreadLabel> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, PageUserMessageThreadLabel>() {
           public PageUserMessageThreadLabel apply(String result) {
             try {
               return APIRequestCreateCustomLabel.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateCustomLabel(String nodeId, APIContext context) {
      super(context, nodeId, "/custom_labels", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateCustomLabel setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateCustomLabel setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateCustomLabel setName (String name) {
      this.setParam("name", name);
      return this;
    }

    public APIRequestCreateCustomLabel requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateCustomLabel requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateCustomLabel requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateCustomLabel requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateCustomLabel requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateCustomLabel requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetEvents extends APIRequest<Event> {

    APINodeList<Event> lastResponse = null;
    @Override
    public APINodeList<Event> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "type",
      "include_canceled",
      "time_filter",
      "event_state_filter",
    };

    public static final String[] FIELDS = {
      "attending_count",
      "can_guests_invite",
      "can_viewer_post",
      "category",
      "cover",
      "declined_count",
      "description",
      "discount_code_enabled",
      "end_time",
      "event_times",
      "guest_list_enabled",
      "id",
      "interested_count",
      "invited_count",
      "is_canceled",
      "is_date_only",
      "is_draft",
      "is_page_owned",
      "location",
      "maybe_count",
      "name",
      "noreply_count",
      "owner",
      "parent_group",
      "place",
      "privacy",
      "scheduled_publish_time",
      "start_time",
      "ticket_uri",
      "ticket_uri_start_sales_time",
      "ticketing_privacy_uri",
      "ticketing_terms_uri",
      "timezone",
      "type",
      "updated_time",
      "venue",
    };

    @Override
    public APINodeList<Event> parseResponse(String response) throws APIException {
      return Event.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<Event> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Event> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Event>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Event>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<Event>>() {
           public APINodeList<Event> apply(String result) {
             try {
               return APIRequestGetEvents.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetEvents(String nodeId, APIContext context) {
      super(context, nodeId, "/events", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetEvents setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetEvents setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetEvents setType (Event.EnumType type) {
      this.setParam("type", type);
      return this;
    }
    public APIRequestGetEvents setType (String type) {
      this.setParam("type", type);
      return this;
    }

    public APIRequestGetEvents setIncludeCanceled (Boolean includeCanceled) {
      this.setParam("include_canceled", includeCanceled);
      return this;
    }
    public APIRequestGetEvents setIncludeCanceled (String includeCanceled) {
      this.setParam("include_canceled", includeCanceled);
      return this;
    }

    public APIRequestGetEvents setTimeFilter (Event.EnumTimeFilter timeFilter) {
      this.setParam("time_filter", timeFilter);
      return this;
    }
    public APIRequestGetEvents setTimeFilter (String timeFilter) {
      this.setParam("time_filter", timeFilter);
      return this;
    }

    public APIRequestGetEvents setEventStateFilter (List<Event.EnumEventStateFilter> eventStateFilter) {
      this.setParam("event_state_filter", eventStateFilter);
      return this;
    }
    public APIRequestGetEvents setEventStateFilter (String eventStateFilter) {
      this.setParam("event_state_filter", eventStateFilter);
      return this;
    }

    public APIRequestGetEvents requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetEvents requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetEvents requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetEvents requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetEvents requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetEvents requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetEvents requestAttendingCountField () {
      return this.requestAttendingCountField(true);
    }
    public APIRequestGetEvents requestAttendingCountField (boolean value) {
      this.requestField("attending_count", value);
      return this;
    }
    public APIRequestGetEvents requestCanGuestsInviteField () {
      return this.requestCanGuestsInviteField(true);
    }
    public APIRequestGetEvents requestCanGuestsInviteField (boolean value) {
      this.requestField("can_guests_invite", value);
      return this;
    }
    public APIRequestGetEvents requestCanViewerPostField () {
      return this.requestCanViewerPostField(true);
    }
    public APIRequestGetEvents requestCanViewerPostField (boolean value) {
      this.requestField("can_viewer_post", value);
      return this;
    }
    public APIRequestGetEvents requestCategoryField () {
      return this.requestCategoryField(true);
    }
    public APIRequestGetEvents requestCategoryField (boolean value) {
      this.requestField("category", value);
      return this;
    }
    public APIRequestGetEvents requestCoverField () {
      return this.requestCoverField(true);
    }
    public APIRequestGetEvents requestCoverField (boolean value) {
      this.requestField("cover", value);
      return this;
    }
    public APIRequestGetEvents requestDeclinedCountField () {
      return this.requestDeclinedCountField(true);
    }
    public APIRequestGetEvents requestDeclinedCountField (boolean value) {
      this.requestField("declined_count", value);
      return this;
    }
    public APIRequestGetEvents requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetEvents requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetEvents requestDiscountCodeEnabledField () {
      return this.requestDiscountCodeEnabledField(true);
    }
    public APIRequestGetEvents requestDiscountCodeEnabledField (boolean value) {
      this.requestField("discount_code_enabled", value);
      return this;
    }
    public APIRequestGetEvents requestEndTimeField () {
      return this.requestEndTimeField(true);
    }
    public APIRequestGetEvents requestEndTimeField (boolean value) {
      this.requestField("end_time", value);
      return this;
    }
    public APIRequestGetEvents requestEventTimesField () {
      return this.requestEventTimesField(true);
    }
    public APIRequestGetEvents requestEventTimesField (boolean value) {
      this.requestField("event_times", value);
      return this;
    }
    public APIRequestGetEvents requestGuestListEnabledField () {
      return this.requestGuestListEnabledField(true);
    }
    public APIRequestGetEvents requestGuestListEnabledField (boolean value) {
      this.requestField("guest_list_enabled", value);
      return this;
    }
    public APIRequestGetEvents requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetEvents requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetEvents requestInterestedCountField () {
      return this.requestInterestedCountField(true);
    }
    public APIRequestGetEvents requestInterestedCountField (boolean value) {
      this.requestField("interested_count", value);
      return this;
    }
    public APIRequestGetEvents requestInvitedCountField () {
      return this.requestInvitedCountField(true);
    }
    public APIRequestGetEvents requestInvitedCountField (boolean value) {
      this.requestField("invited_count", value);
      return this;
    }
    public APIRequestGetEvents requestIsCanceledField () {
      return this.requestIsCanceledField(true);
    }
    public APIRequestGetEvents requestIsCanceledField (boolean value) {
      this.requestField("is_canceled", value);
      return this;
    }
    public APIRequestGetEvents requestIsDateOnlyField () {
      return this.requestIsDateOnlyField(true);
    }
    public APIRequestGetEvents requestIsDateOnlyField (boolean value) {
      this.requestField("is_date_only", value);
      return this;
    }
    public APIRequestGetEvents requestIsDraftField () {
      return this.requestIsDraftField(true);
    }
    public APIRequestGetEvents requestIsDraftField (boolean value) {
      this.requestField("is_draft", value);
      return this;
    }
    public APIRequestGetEvents requestIsPageOwnedField () {
      return this.requestIsPageOwnedField(true);
    }
    public APIRequestGetEvents requestIsPageOwnedField (boolean value) {
      this.requestField("is_page_owned", value);
      return this;
    }
    public APIRequestGetEvents requestLocationField () {
      return this.requestLocationField(true);
    }
    public APIRequestGetEvents requestLocationField (boolean value) {
      this.requestField("location", value);
      return this;
    }
    public APIRequestGetEvents requestMaybeCountField () {
      return this.requestMaybeCountField(true);
    }
    public APIRequestGetEvents requestMaybeCountField (boolean value) {
      this.requestField("maybe_count", value);
      return this;
    }
    public APIRequestGetEvents requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetEvents requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetEvents requestNoreplyCountField () {
      return this.requestNoreplyCountField(true);
    }
    public APIRequestGetEvents requestNoreplyCountField (boolean value) {
      this.requestField("noreply_count", value);
      return this;
    }
    public APIRequestGetEvents requestOwnerField () {
      return this.requestOwnerField(true);
    }
    public APIRequestGetEvents requestOwnerField (boolean value) {
      this.requestField("owner", value);
      return this;
    }
    public APIRequestGetEvents requestParentGroupField () {
      return this.requestParentGroupField(true);
    }
    public APIRequestGetEvents requestParentGroupField (boolean value) {
      this.requestField("parent_group", value);
      return this;
    }
    public APIRequestGetEvents requestPlaceField () {
      return this.requestPlaceField(true);
    }
    public APIRequestGetEvents requestPlaceField (boolean value) {
      this.requestField("place", value);
      return this;
    }
    public APIRequestGetEvents requestPrivacyField () {
      return this.requestPrivacyField(true);
    }
    public APIRequestGetEvents requestPrivacyField (boolean value) {
      this.requestField("privacy", value);
      return this;
    }
    public APIRequestGetEvents requestScheduledPublishTimeField () {
      return this.requestScheduledPublishTimeField(true);
    }
    public APIRequestGetEvents requestScheduledPublishTimeField (boolean value) {
      this.requestField("scheduled_publish_time", value);
      return this;
    }
    public APIRequestGetEvents requestStartTimeField () {
      return this.requestStartTimeField(true);
    }
    public APIRequestGetEvents requestStartTimeField (boolean value) {
      this.requestField("start_time", value);
      return this;
    }
    public APIRequestGetEvents requestTicketUriField () {
      return this.requestTicketUriField(true);
    }
    public APIRequestGetEvents requestTicketUriField (boolean value) {
      this.requestField("ticket_uri", value);
      return this;
    }
    public APIRequestGetEvents requestTicketUriStartSalesTimeField () {
      return this.requestTicketUriStartSalesTimeField(true);
    }
    public APIRequestGetEvents requestTicketUriStartSalesTimeField (boolean value) {
      this.requestField("ticket_uri_start_sales_time", value);
      return this;
    }
    public APIRequestGetEvents requestTicketingPrivacyUriField () {
      return this.requestTicketingPrivacyUriField(true);
    }
    public APIRequestGetEvents requestTicketingPrivacyUriField (boolean value) {
      this.requestField("ticketing_privacy_uri", value);
      return this;
    }
    public APIRequestGetEvents requestTicketingTermsUriField () {
      return this.requestTicketingTermsUriField(true);
    }
    public APIRequestGetEvents requestTicketingTermsUriField (boolean value) {
      this.requestField("ticketing_terms_uri", value);
      return this;
    }
    public APIRequestGetEvents requestTimezoneField () {
      return this.requestTimezoneField(true);
    }
    public APIRequestGetEvents requestTimezoneField (boolean value) {
      this.requestField("timezone", value);
      return this;
    }
    public APIRequestGetEvents requestTypeField () {
      return this.requestTypeField(true);
    }
    public APIRequestGetEvents requestTypeField (boolean value) {
      this.requestField("type", value);
      return this;
    }
    public APIRequestGetEvents requestUpdatedTimeField () {
      return this.requestUpdatedTimeField(true);
    }
    public APIRequestGetEvents requestUpdatedTimeField (boolean value) {
      this.requestField("updated_time", value);
      return this;
    }
    public APIRequestGetEvents requestVenueField () {
      return this.requestVenueField(true);
    }
    public APIRequestGetEvents requestVenueField (boolean value) {
      this.requestField("venue", value);
      return this;
    }
  }

  public static class APIRequestCreateEvent extends APIRequest<Event> {

    Event lastResponse = null;
    @Override
    public Event getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "event_info",
      "action_context",
      "app_context",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Event parseResponse(String response) throws APIException {
      return Event.parseResponse(response, getContext(), this).head();
    }

    @Override
    public Event execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Event execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<Event> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Event> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, Event>() {
           public Event apply(String result) {
             try {
               return APIRequestCreateEvent.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateEvent(String nodeId, APIContext context) {
      super(context, nodeId, "/events", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateEvent setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateEvent setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateEvent setEventInfo (Object eventInfo) {
      this.setParam("event_info", eventInfo);
      return this;
    }
    public APIRequestCreateEvent setEventInfo (String eventInfo) {
      this.setParam("event_info", eventInfo);
      return this;
    }

    public APIRequestCreateEvent setActionContext (Object actionContext) {
      this.setParam("action_context", actionContext);
      return this;
    }
    public APIRequestCreateEvent setActionContext (String actionContext) {
      this.setParam("action_context", actionContext);
      return this;
    }

    public APIRequestCreateEvent setAppContext (Object appContext) {
      this.setParam("app_context", appContext);
      return this;
    }
    public APIRequestCreateEvent setAppContext (String appContext) {
      this.setParam("app_context", appContext);
      return this;
    }

    public APIRequestCreateEvent requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateEvent requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateEvent requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateEvent requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateEvent requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateEvent requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetExpiredPosts extends APIRequest<ExpirablePost> {

    APINodeList<ExpirablePost> lastResponse = null;
    @Override
    public APINodeList<ExpirablePost> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "admin_creator",
      "can_republish",
      "content_type",
      "creation_time",
      "expiration",
      "feed_audience_description",
      "feed_targeting",
      "id",
      "message",
      "modified_time",
      "og_action_summary",
      "permalink_url",
      "place",
      "privacy_description",
      "promotion_info",
      "scheduled_publish_time",
      "story_token",
      "thumbnail",
      "video_id",
    };

    @Override
    public APINodeList<ExpirablePost> parseResponse(String response) throws APIException {
      return ExpirablePost.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<ExpirablePost> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<ExpirablePost> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<ExpirablePost>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<ExpirablePost>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<ExpirablePost>>() {
           public APINodeList<ExpirablePost> apply(String result) {
             try {
               return APIRequestGetExpiredPosts.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetExpiredPosts(String nodeId, APIContext context) {
      super(context, nodeId, "/expired_posts", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetExpiredPosts setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetExpiredPosts setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetExpiredPosts requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetExpiredPosts requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetExpiredPosts requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetExpiredPosts requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetExpiredPosts requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetExpiredPosts requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetExpiredPosts requestAdminCreatorField () {
      return this.requestAdminCreatorField(true);
    }
    public APIRequestGetExpiredPosts requestAdminCreatorField (boolean value) {
      this.requestField("admin_creator", value);
      return this;
    }
    public APIRequestGetExpiredPosts requestCanRepublishField () {
      return this.requestCanRepublishField(true);
    }
    public APIRequestGetExpiredPosts requestCanRepublishField (boolean value) {
      this.requestField("can_republish", value);
      return this;
    }
    public APIRequestGetExpiredPosts requestContentTypeField () {
      return this.requestContentTypeField(true);
    }
    public APIRequestGetExpiredPosts requestContentTypeField (boolean value) {
      this.requestField("content_type", value);
      return this;
    }
    public APIRequestGetExpiredPosts requestCreationTimeField () {
      return this.requestCreationTimeField(true);
    }
    public APIRequestGetExpiredPosts requestCreationTimeField (boolean value) {
      this.requestField("creation_time", value);
      return this;
    }
    public APIRequestGetExpiredPosts requestExpirationField () {
      return this.requestExpirationField(true);
    }
    public APIRequestGetExpiredPosts requestExpirationField (boolean value) {
      this.requestField("expiration", value);
      return this;
    }
    public APIRequestGetExpiredPosts requestFeedAudienceDescriptionField () {
      return this.requestFeedAudienceDescriptionField(true);
    }
    public APIRequestGetExpiredPosts requestFeedAudienceDescriptionField (boolean value) {
      this.requestField("feed_audience_description", value);
      return this;
    }
    public APIRequestGetExpiredPosts requestFeedTargetingField () {
      return this.requestFeedTargetingField(true);
    }
    public APIRequestGetExpiredPosts requestFeedTargetingField (boolean value) {
      this.requestField("feed_targeting", value);
      return this;
    }
    public APIRequestGetExpiredPosts requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetExpiredPosts requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetExpiredPosts requestMessageField () {
      return this.requestMessageField(true);
    }
    public APIRequestGetExpiredPosts requestMessageField (boolean value) {
      this.requestField("message", value);
      return this;
    }
    public APIRequestGetExpiredPosts requestModifiedTimeField () {
      return this.requestModifiedTimeField(true);
    }
    public APIRequestGetExpiredPosts requestModifiedTimeField (boolean value) {
      this.requestField("modified_time", value);
      return this;
    }
    public APIRequestGetExpiredPosts requestOgActionSummaryField () {
      return this.requestOgActionSummaryField(true);
    }
    public APIRequestGetExpiredPosts requestOgActionSummaryField (boolean value) {
      this.requestField("og_action_summary", value);
      return this;
    }
    public APIRequestGetExpiredPosts requestPermalinkUrlField () {
      return this.requestPermalinkUrlField(true);
    }
    public APIRequestGetExpiredPosts requestPermalinkUrlField (boolean value) {
      this.requestField("permalink_url", value);
      return this;
    }
    public APIRequestGetExpiredPosts requestPlaceField () {
      return this.requestPlaceField(true);
    }
    public APIRequestGetExpiredPosts requestPlaceField (boolean value) {
      this.requestField("place", value);
      return this;
    }
    public APIRequestGetExpiredPosts requestPrivacyDescriptionField () {
      return this.requestPrivacyDescriptionField(true);
    }
    public APIRequestGetExpiredPosts requestPrivacyDescriptionField (boolean value) {
      this.requestField("privacy_description", value);
      return this;
    }
    public APIRequestGetExpiredPosts requestPromotionInfoField () {
      return this.requestPromotionInfoField(true);
    }
    public APIRequestGetExpiredPosts requestPromotionInfoField (boolean value) {
      this.requestField("promotion_info", value);
      return this;
    }
    public APIRequestGetExpiredPosts requestScheduledPublishTimeField () {
      return this.requestScheduledPublishTimeField(true);
    }
    public APIRequestGetExpiredPosts requestScheduledPublishTimeField (boolean value) {
      this.requestField("scheduled_publish_time", value);
      return this;
    }
    public APIRequestGetExpiredPosts requestStoryTokenField () {
      return this.requestStoryTokenField(true);
    }
    public APIRequestGetExpiredPosts requestStoryTokenField (boolean value) {
      this.requestField("story_token", value);
      return this;
    }
    public APIRequestGetExpiredPosts requestThumbnailField () {
      return this.requestThumbnailField(true);
    }
    public APIRequestGetExpiredPosts requestThumbnailField (boolean value) {
      this.requestField("thumbnail", value);
      return this;
    }
    public APIRequestGetExpiredPosts requestVideoIdField () {
      return this.requestVideoIdField(true);
    }
    public APIRequestGetExpiredPosts requestVideoIdField (boolean value) {
      this.requestField("video_id", value);
      return this;
    }
  }

  public static class APIRequestGetExpiringPosts extends APIRequest<ExpirablePost> {

    APINodeList<ExpirablePost> lastResponse = null;
    @Override
    public APINodeList<ExpirablePost> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "admin_creator",
      "can_republish",
      "content_type",
      "creation_time",
      "expiration",
      "feed_audience_description",
      "feed_targeting",
      "id",
      "message",
      "modified_time",
      "og_action_summary",
      "permalink_url",
      "place",
      "privacy_description",
      "promotion_info",
      "scheduled_publish_time",
      "story_token",
      "thumbnail",
      "video_id",
    };

    @Override
    public APINodeList<ExpirablePost> parseResponse(String response) throws APIException {
      return ExpirablePost.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<ExpirablePost> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<ExpirablePost> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<ExpirablePost>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<ExpirablePost>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<ExpirablePost>>() {
           public APINodeList<ExpirablePost> apply(String result) {
             try {
               return APIRequestGetExpiringPosts.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetExpiringPosts(String nodeId, APIContext context) {
      super(context, nodeId, "/expiring_posts", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetExpiringPosts setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetExpiringPosts setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetExpiringPosts requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetExpiringPosts requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetExpiringPosts requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetExpiringPosts requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetExpiringPosts requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetExpiringPosts requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetExpiringPosts requestAdminCreatorField () {
      return this.requestAdminCreatorField(true);
    }
    public APIRequestGetExpiringPosts requestAdminCreatorField (boolean value) {
      this.requestField("admin_creator", value);
      return this;
    }
    public APIRequestGetExpiringPosts requestCanRepublishField () {
      return this.requestCanRepublishField(true);
    }
    public APIRequestGetExpiringPosts requestCanRepublishField (boolean value) {
      this.requestField("can_republish", value);
      return this;
    }
    public APIRequestGetExpiringPosts requestContentTypeField () {
      return this.requestContentTypeField(true);
    }
    public APIRequestGetExpiringPosts requestContentTypeField (boolean value) {
      this.requestField("content_type", value);
      return this;
    }
    public APIRequestGetExpiringPosts requestCreationTimeField () {
      return this.requestCreationTimeField(true);
    }
    public APIRequestGetExpiringPosts requestCreationTimeField (boolean value) {
      this.requestField("creation_time", value);
      return this;
    }
    public APIRequestGetExpiringPosts requestExpirationField () {
      return this.requestExpirationField(true);
    }
    public APIRequestGetExpiringPosts requestExpirationField (boolean value) {
      this.requestField("expiration", value);
      return this;
    }
    public APIRequestGetExpiringPosts requestFeedAudienceDescriptionField () {
      return this.requestFeedAudienceDescriptionField(true);
    }
    public APIRequestGetExpiringPosts requestFeedAudienceDescriptionField (boolean value) {
      this.requestField("feed_audience_description", value);
      return this;
    }
    public APIRequestGetExpiringPosts requestFeedTargetingField () {
      return this.requestFeedTargetingField(true);
    }
    public APIRequestGetExpiringPosts requestFeedTargetingField (boolean value) {
      this.requestField("feed_targeting", value);
      return this;
    }
    public APIRequestGetExpiringPosts requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetExpiringPosts requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetExpiringPosts requestMessageField () {
      return this.requestMessageField(true);
    }
    public APIRequestGetExpiringPosts requestMessageField (boolean value) {
      this.requestField("message", value);
      return this;
    }
    public APIRequestGetExpiringPosts requestModifiedTimeField () {
      return this.requestModifiedTimeField(true);
    }
    public APIRequestGetExpiringPosts requestModifiedTimeField (boolean value) {
      this.requestField("modified_time", value);
      return this;
    }
    public APIRequestGetExpiringPosts requestOgActionSummaryField () {
      return this.requestOgActionSummaryField(true);
    }
    public APIRequestGetExpiringPosts requestOgActionSummaryField (boolean value) {
      this.requestField("og_action_summary", value);
      return this;
    }
    public APIRequestGetExpiringPosts requestPermalinkUrlField () {
      return this.requestPermalinkUrlField(true);
    }
    public APIRequestGetExpiringPosts requestPermalinkUrlField (boolean value) {
      this.requestField("permalink_url", value);
      return this;
    }
    public APIRequestGetExpiringPosts requestPlaceField () {
      return this.requestPlaceField(true);
    }
    public APIRequestGetExpiringPosts requestPlaceField (boolean value) {
      this.requestField("place", value);
      return this;
    }
    public APIRequestGetExpiringPosts requestPrivacyDescriptionField () {
      return this.requestPrivacyDescriptionField(true);
    }
    public APIRequestGetExpiringPosts requestPrivacyDescriptionField (boolean value) {
      this.requestField("privacy_description", value);
      return this;
    }
    public APIRequestGetExpiringPosts requestPromotionInfoField () {
      return this.requestPromotionInfoField(true);
    }
    public APIRequestGetExpiringPosts requestPromotionInfoField (boolean value) {
      this.requestField("promotion_info", value);
      return this;
    }
    public APIRequestGetExpiringPosts requestScheduledPublishTimeField () {
      return this.requestScheduledPublishTimeField(true);
    }
    public APIRequestGetExpiringPosts requestScheduledPublishTimeField (boolean value) {
      this.requestField("scheduled_publish_time", value);
      return this;
    }
    public APIRequestGetExpiringPosts requestStoryTokenField () {
      return this.requestStoryTokenField(true);
    }
    public APIRequestGetExpiringPosts requestStoryTokenField (boolean value) {
      this.requestField("story_token", value);
      return this;
    }
    public APIRequestGetExpiringPosts requestThumbnailField () {
      return this.requestThumbnailField(true);
    }
    public APIRequestGetExpiringPosts requestThumbnailField (boolean value) {
      this.requestField("thumbnail", value);
      return this;
    }
    public APIRequestGetExpiringPosts requestVideoIdField () {
      return this.requestVideoIdField(true);
    }
    public APIRequestGetExpiringPosts requestVideoIdField (boolean value) {
      this.requestField("video_id", value);
      return this;
    }
  }

  public static class APIRequestGetFeatureDVideosCollection extends APIRequest<AdVideo> {

    APINodeList<AdVideo> lastResponse = null;
    @Override
    public APINodeList<AdVideo> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "ad_breaks",
      "backdated_time",
      "backdated_time_granularity",
      "content_category",
      "content_tags",
      "created_time",
      "custom_labels",
      "description",
      "embed_html",
      "embeddable",
      "event",
      "expiration",
      "format",
      "from",
      "icon",
      "id",
      "is_crosspost_video",
      "is_crossposting_eligible",
      "is_episode",
      "is_instagram_eligible",
      "length",
      "live_audience_count",
      "live_status",
      "name",
      "permalink_url",
      "picture",
      "place",
      "privacy",
      "published",
      "scheduled_publish_time",
      "source",
      "spherical",
      "status",
      "title",
      "tv_banner_ad",
      "universal_video_id",
      "updated_time",
    };

    @Override
    public APINodeList<AdVideo> parseResponse(String response) throws APIException {
      return AdVideo.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<AdVideo> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<AdVideo> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<AdVideo>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<AdVideo>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<AdVideo>>() {
           public APINodeList<AdVideo> apply(String result) {
             try {
               return APIRequestGetFeatureDVideosCollection.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetFeatureDVideosCollection(String nodeId, APIContext context) {
      super(context, nodeId, "/featured_videos_collection", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetFeatureDVideosCollection setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetFeatureDVideosCollection setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetFeatureDVideosCollection requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetFeatureDVideosCollection requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetFeatureDVideosCollection requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetFeatureDVideosCollection requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetFeatureDVideosCollection requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetFeatureDVideosCollection requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetFeatureDVideosCollection requestAdBreaksField () {
      return this.requestAdBreaksField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestAdBreaksField (boolean value) {
      this.requestField("ad_breaks", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestBackdatedTimeField () {
      return this.requestBackdatedTimeField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestBackdatedTimeField (boolean value) {
      this.requestField("backdated_time", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestBackdatedTimeGranularityField () {
      return this.requestBackdatedTimeGranularityField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestBackdatedTimeGranularityField (boolean value) {
      this.requestField("backdated_time_granularity", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestContentCategoryField () {
      return this.requestContentCategoryField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestContentCategoryField (boolean value) {
      this.requestField("content_category", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestContentTagsField () {
      return this.requestContentTagsField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestContentTagsField (boolean value) {
      this.requestField("content_tags", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestCreatedTimeField () {
      return this.requestCreatedTimeField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestCreatedTimeField (boolean value) {
      this.requestField("created_time", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestCustomLabelsField () {
      return this.requestCustomLabelsField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestCustomLabelsField (boolean value) {
      this.requestField("custom_labels", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestEmbedHtmlField () {
      return this.requestEmbedHtmlField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestEmbedHtmlField (boolean value) {
      this.requestField("embed_html", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestEmbeddableField () {
      return this.requestEmbeddableField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestEmbeddableField (boolean value) {
      this.requestField("embeddable", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestEventField () {
      return this.requestEventField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestEventField (boolean value) {
      this.requestField("event", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestExpirationField () {
      return this.requestExpirationField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestExpirationField (boolean value) {
      this.requestField("expiration", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestFormatField () {
      return this.requestFormatField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestFormatField (boolean value) {
      this.requestField("format", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestFromField () {
      return this.requestFromField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestFromField (boolean value) {
      this.requestField("from", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestIconField () {
      return this.requestIconField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestIconField (boolean value) {
      this.requestField("icon", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestIsCrosspostVideoField () {
      return this.requestIsCrosspostVideoField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestIsCrosspostVideoField (boolean value) {
      this.requestField("is_crosspost_video", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestIsCrosspostingEligibleField () {
      return this.requestIsCrosspostingEligibleField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestIsCrosspostingEligibleField (boolean value) {
      this.requestField("is_crossposting_eligible", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestIsEpisodeField () {
      return this.requestIsEpisodeField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestIsEpisodeField (boolean value) {
      this.requestField("is_episode", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestIsInstagramEligibleField () {
      return this.requestIsInstagramEligibleField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestIsInstagramEligibleField (boolean value) {
      this.requestField("is_instagram_eligible", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestLengthField () {
      return this.requestLengthField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestLengthField (boolean value) {
      this.requestField("length", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestLiveAudienceCountField () {
      return this.requestLiveAudienceCountField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestLiveAudienceCountField (boolean value) {
      this.requestField("live_audience_count", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestLiveStatusField () {
      return this.requestLiveStatusField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestLiveStatusField (boolean value) {
      this.requestField("live_status", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestPermalinkUrlField () {
      return this.requestPermalinkUrlField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestPermalinkUrlField (boolean value) {
      this.requestField("permalink_url", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestPictureField () {
      return this.requestPictureField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestPictureField (boolean value) {
      this.requestField("picture", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestPlaceField () {
      return this.requestPlaceField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestPlaceField (boolean value) {
      this.requestField("place", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestPrivacyField () {
      return this.requestPrivacyField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestPrivacyField (boolean value) {
      this.requestField("privacy", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestPublishedField () {
      return this.requestPublishedField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestPublishedField (boolean value) {
      this.requestField("published", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestScheduledPublishTimeField () {
      return this.requestScheduledPublishTimeField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestScheduledPublishTimeField (boolean value) {
      this.requestField("scheduled_publish_time", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestSourceField () {
      return this.requestSourceField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestSourceField (boolean value) {
      this.requestField("source", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestSphericalField () {
      return this.requestSphericalField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestSphericalField (boolean value) {
      this.requestField("spherical", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestStatusField () {
      return this.requestStatusField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestStatusField (boolean value) {
      this.requestField("status", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestTitleField () {
      return this.requestTitleField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestTitleField (boolean value) {
      this.requestField("title", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestTvBannerAdField () {
      return this.requestTvBannerAdField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestTvBannerAdField (boolean value) {
      this.requestField("tv_banner_ad", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestUniversalVideoIdField () {
      return this.requestUniversalVideoIdField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestUniversalVideoIdField (boolean value) {
      this.requestField("universal_video_id", value);
      return this;
    }
    public APIRequestGetFeatureDVideosCollection requestUpdatedTimeField () {
      return this.requestUpdatedTimeField(true);
    }
    public APIRequestGetFeatureDVideosCollection requestUpdatedTimeField (boolean value) {
      this.requestField("updated_time", value);
      return this;
    }
  }

  public static class APIRequestGetFeed extends APIRequest<PagePost> {

    APINodeList<PagePost> lastResponse = null;
    @Override
    public APINodeList<PagePost> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "include_hidden",
      "with",
      "show_expired",
    };

    public static final String[] FIELDS = {
      "actions",
      "admin_creator",
      "allowed_advertising_objectives",
      "application",
      "backdated_time",
      "call_to_action",
      "can_reply_privately",
      "caption",
      "child_attachments",
      "comments_mirroring_domain",
      "coordinates",
      "created_time",
      "description",
      "event",
      "expanded_height",
      "expanded_width",
      "feed_targeting",
      "from",
      "full_picture",
      "height",
      "icon",
      "id",
      "instagram_eligibility",
      "is_app_share",
      "is_expired",
      "is_hidden",
      "is_instagram_eligible",
      "is_popular",
      "is_published",
      "is_spherical",
      "link",
      "message",
      "message_tags",
      "multi_share_end_card",
      "multi_share_optimized",
      "name",
      "object_id",
      "parent_id",
      "permalink_url",
      "picture",
      "place",
      "privacy",
      "promotable_id",
      "promotion_status",
      "properties",
      "scheduled_publish_time",
      "shares",
      "source",
      "status_type",
      "story",
      "story_tags",
      "subscribed",
      "target",
      "targeting",
      "timeline_visibility",
      "type",
      "updated_time",
      "via",
      "video_buying_eligibility",
      "width",
    };

    @Override
    public APINodeList<PagePost> parseResponse(String response) throws APIException {
      return PagePost.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<PagePost> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<PagePost> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<PagePost>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<PagePost>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<PagePost>>() {
           public APINodeList<PagePost> apply(String result) {
             try {
               return APIRequestGetFeed.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetFeed(String nodeId, APIContext context) {
      super(context, nodeId, "/feed", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetFeed setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetFeed setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetFeed setIncludeHidden (Boolean includeHidden) {
      this.setParam("include_hidden", includeHidden);
      return this;
    }
    public APIRequestGetFeed setIncludeHidden (String includeHidden) {
      this.setParam("include_hidden", includeHidden);
      return this;
    }

    public APIRequestGetFeed setWith (PagePost.EnumWith with) {
      this.setParam("with", with);
      return this;
    }
    public APIRequestGetFeed setWith (String with) {
      this.setParam("with", with);
      return this;
    }

    public APIRequestGetFeed setShowExpired (Boolean showExpired) {
      this.setParam("show_expired", showExpired);
      return this;
    }
    public APIRequestGetFeed setShowExpired (String showExpired) {
      this.setParam("show_expired", showExpired);
      return this;
    }

    public APIRequestGetFeed requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetFeed requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetFeed requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetFeed requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetFeed requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetFeed requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetFeed requestActionsField () {
      return this.requestActionsField(true);
    }
    public APIRequestGetFeed requestActionsField (boolean value) {
      this.requestField("actions", value);
      return this;
    }
    public APIRequestGetFeed requestAdminCreatorField () {
      return this.requestAdminCreatorField(true);
    }
    public APIRequestGetFeed requestAdminCreatorField (boolean value) {
      this.requestField("admin_creator", value);
      return this;
    }
    public APIRequestGetFeed requestAllowedAdvertisingObjectivesField () {
      return this.requestAllowedAdvertisingObjectivesField(true);
    }
    public APIRequestGetFeed requestAllowedAdvertisingObjectivesField (boolean value) {
      this.requestField("allowed_advertising_objectives", value);
      return this;
    }
    public APIRequestGetFeed requestApplicationField () {
      return this.requestApplicationField(true);
    }
    public APIRequestGetFeed requestApplicationField (boolean value) {
      this.requestField("application", value);
      return this;
    }
    public APIRequestGetFeed requestBackdatedTimeField () {
      return this.requestBackdatedTimeField(true);
    }
    public APIRequestGetFeed requestBackdatedTimeField (boolean value) {
      this.requestField("backdated_time", value);
      return this;
    }
    public APIRequestGetFeed requestCallToActionField () {
      return this.requestCallToActionField(true);
    }
    public APIRequestGetFeed requestCallToActionField (boolean value) {
      this.requestField("call_to_action", value);
      return this;
    }
    public APIRequestGetFeed requestCanReplyPrivatelyField () {
      return this.requestCanReplyPrivatelyField(true);
    }
    public APIRequestGetFeed requestCanReplyPrivatelyField (boolean value) {
      this.requestField("can_reply_privately", value);
      return this;
    }
    public APIRequestGetFeed requestCaptionField () {
      return this.requestCaptionField(true);
    }
    public APIRequestGetFeed requestCaptionField (boolean value) {
      this.requestField("caption", value);
      return this;
    }
    public APIRequestGetFeed requestChildAttachmentsField () {
      return this.requestChildAttachmentsField(true);
    }
    public APIRequestGetFeed requestChildAttachmentsField (boolean value) {
      this.requestField("child_attachments", value);
      return this;
    }
    public APIRequestGetFeed requestCommentsMirroringDomainField () {
      return this.requestCommentsMirroringDomainField(true);
    }
    public APIRequestGetFeed requestCommentsMirroringDomainField (boolean value) {
      this.requestField("comments_mirroring_domain", value);
      return this;
    }
    public APIRequestGetFeed requestCoordinatesField () {
      return this.requestCoordinatesField(true);
    }
    public APIRequestGetFeed requestCoordinatesField (boolean value) {
      this.requestField("coordinates", value);
      return this;
    }
    public APIRequestGetFeed requestCreatedTimeField () {
      return this.requestCreatedTimeField(true);
    }
    public APIRequestGetFeed requestCreatedTimeField (boolean value) {
      this.requestField("created_time", value);
      return this;
    }
    public APIRequestGetFeed requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetFeed requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetFeed requestEventField () {
      return this.requestEventField(true);
    }
    public APIRequestGetFeed requestEventField (boolean value) {
      this.requestField("event", value);
      return this;
    }
    public APIRequestGetFeed requestExpandedHeightField () {
      return this.requestExpandedHeightField(true);
    }
    public APIRequestGetFeed requestExpandedHeightField (boolean value) {
      this.requestField("expanded_height", value);
      return this;
    }
    public APIRequestGetFeed requestExpandedWidthField () {
      return this.requestExpandedWidthField(true);
    }
    public APIRequestGetFeed requestExpandedWidthField (boolean value) {
      this.requestField("expanded_width", value);
      return this;
    }
    public APIRequestGetFeed requestFeedTargetingField () {
      return this.requestFeedTargetingField(true);
    }
    public APIRequestGetFeed requestFeedTargetingField (boolean value) {
      this.requestField("feed_targeting", value);
      return this;
    }
    public APIRequestGetFeed requestFromField () {
      return this.requestFromField(true);
    }
    public APIRequestGetFeed requestFromField (boolean value) {
      this.requestField("from", value);
      return this;
    }
    public APIRequestGetFeed requestFullPictureField () {
      return this.requestFullPictureField(true);
    }
    public APIRequestGetFeed requestFullPictureField (boolean value) {
      this.requestField("full_picture", value);
      return this;
    }
    public APIRequestGetFeed requestHeightField () {
      return this.requestHeightField(true);
    }
    public APIRequestGetFeed requestHeightField (boolean value) {
      this.requestField("height", value);
      return this;
    }
    public APIRequestGetFeed requestIconField () {
      return this.requestIconField(true);
    }
    public APIRequestGetFeed requestIconField (boolean value) {
      this.requestField("icon", value);
      return this;
    }
    public APIRequestGetFeed requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetFeed requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetFeed requestInstagramEligibilityField () {
      return this.requestInstagramEligibilityField(true);
    }
    public APIRequestGetFeed requestInstagramEligibilityField (boolean value) {
      this.requestField("instagram_eligibility", value);
      return this;
    }
    public APIRequestGetFeed requestIsAppShareField () {
      return this.requestIsAppShareField(true);
    }
    public APIRequestGetFeed requestIsAppShareField (boolean value) {
      this.requestField("is_app_share", value);
      return this;
    }
    public APIRequestGetFeed requestIsExpiredField () {
      return this.requestIsExpiredField(true);
    }
    public APIRequestGetFeed requestIsExpiredField (boolean value) {
      this.requestField("is_expired", value);
      return this;
    }
    public APIRequestGetFeed requestIsHiddenField () {
      return this.requestIsHiddenField(true);
    }
    public APIRequestGetFeed requestIsHiddenField (boolean value) {
      this.requestField("is_hidden", value);
      return this;
    }
    public APIRequestGetFeed requestIsInstagramEligibleField () {
      return this.requestIsInstagramEligibleField(true);
    }
    public APIRequestGetFeed requestIsInstagramEligibleField (boolean value) {
      this.requestField("is_instagram_eligible", value);
      return this;
    }
    public APIRequestGetFeed requestIsPopularField () {
      return this.requestIsPopularField(true);
    }
    public APIRequestGetFeed requestIsPopularField (boolean value) {
      this.requestField("is_popular", value);
      return this;
    }
    public APIRequestGetFeed requestIsPublishedField () {
      return this.requestIsPublishedField(true);
    }
    public APIRequestGetFeed requestIsPublishedField (boolean value) {
      this.requestField("is_published", value);
      return this;
    }
    public APIRequestGetFeed requestIsSphericalField () {
      return this.requestIsSphericalField(true);
    }
    public APIRequestGetFeed requestIsSphericalField (boolean value) {
      this.requestField("is_spherical", value);
      return this;
    }
    public APIRequestGetFeed requestLinkField () {
      return this.requestLinkField(true);
    }
    public APIRequestGetFeed requestLinkField (boolean value) {
      this.requestField("link", value);
      return this;
    }
    public APIRequestGetFeed requestMessageField () {
      return this.requestMessageField(true);
    }
    public APIRequestGetFeed requestMessageField (boolean value) {
      this.requestField("message", value);
      return this;
    }
    public APIRequestGetFeed requestMessageTagsField () {
      return this.requestMessageTagsField(true);
    }
    public APIRequestGetFeed requestMessageTagsField (boolean value) {
      this.requestField("message_tags", value);
      return this;
    }
    public APIRequestGetFeed requestMultiShareEndCardField () {
      return this.requestMultiShareEndCardField(true);
    }
    public APIRequestGetFeed requestMultiShareEndCardField (boolean value) {
      this.requestField("multi_share_end_card", value);
      return this;
    }
    public APIRequestGetFeed requestMultiShareOptimizedField () {
      return this.requestMultiShareOptimizedField(true);
    }
    public APIRequestGetFeed requestMultiShareOptimizedField (boolean value) {
      this.requestField("multi_share_optimized", value);
      return this;
    }
    public APIRequestGetFeed requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetFeed requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetFeed requestObjectIdField () {
      return this.requestObjectIdField(true);
    }
    public APIRequestGetFeed requestObjectIdField (boolean value) {
      this.requestField("object_id", value);
      return this;
    }
    public APIRequestGetFeed requestParentIdField () {
      return this.requestParentIdField(true);
    }
    public APIRequestGetFeed requestParentIdField (boolean value) {
      this.requestField("parent_id", value);
      return this;
    }
    public APIRequestGetFeed requestPermalinkUrlField () {
      return this.requestPermalinkUrlField(true);
    }
    public APIRequestGetFeed requestPermalinkUrlField (boolean value) {
      this.requestField("permalink_url", value);
      return this;
    }
    public APIRequestGetFeed requestPictureField () {
      return this.requestPictureField(true);
    }
    public APIRequestGetFeed requestPictureField (boolean value) {
      this.requestField("picture", value);
      return this;
    }
    public APIRequestGetFeed requestPlaceField () {
      return this.requestPlaceField(true);
    }
    public APIRequestGetFeed requestPlaceField (boolean value) {
      this.requestField("place", value);
      return this;
    }
    public APIRequestGetFeed requestPrivacyField () {
      return this.requestPrivacyField(true);
    }
    public APIRequestGetFeed requestPrivacyField (boolean value) {
      this.requestField("privacy", value);
      return this;
    }
    public APIRequestGetFeed requestPromotableIdField () {
      return this.requestPromotableIdField(true);
    }
    public APIRequestGetFeed requestPromotableIdField (boolean value) {
      this.requestField("promotable_id", value);
      return this;
    }
    public APIRequestGetFeed requestPromotionStatusField () {
      return this.requestPromotionStatusField(true);
    }
    public APIRequestGetFeed requestPromotionStatusField (boolean value) {
      this.requestField("promotion_status", value);
      return this;
    }
    public APIRequestGetFeed requestPropertiesField () {
      return this.requestPropertiesField(true);
    }
    public APIRequestGetFeed requestPropertiesField (boolean value) {
      this.requestField("properties", value);
      return this;
    }
    public APIRequestGetFeed requestScheduledPublishTimeField () {
      return this.requestScheduledPublishTimeField(true);
    }
    public APIRequestGetFeed requestScheduledPublishTimeField (boolean value) {
      this.requestField("scheduled_publish_time", value);
      return this;
    }
    public APIRequestGetFeed requestSharesField () {
      return this.requestSharesField(true);
    }
    public APIRequestGetFeed requestSharesField (boolean value) {
      this.requestField("shares", value);
      return this;
    }
    public APIRequestGetFeed requestSourceField () {
      return this.requestSourceField(true);
    }
    public APIRequestGetFeed requestSourceField (boolean value) {
      this.requestField("source", value);
      return this;
    }
    public APIRequestGetFeed requestStatusTypeField () {
      return this.requestStatusTypeField(true);
    }
    public APIRequestGetFeed requestStatusTypeField (boolean value) {
      this.requestField("status_type", value);
      return this;
    }
    public APIRequestGetFeed requestStoryField () {
      return this.requestStoryField(true);
    }
    public APIRequestGetFeed requestStoryField (boolean value) {
      this.requestField("story", value);
      return this;
    }
    public APIRequestGetFeed requestStoryTagsField () {
      return this.requestStoryTagsField(true);
    }
    public APIRequestGetFeed requestStoryTagsField (boolean value) {
      this.requestField("story_tags", value);
      return this;
    }
    public APIRequestGetFeed requestSubscribedField () {
      return this.requestSubscribedField(true);
    }
    public APIRequestGetFeed requestSubscribedField (boolean value) {
      this.requestField("subscribed", value);
      return this;
    }
    public APIRequestGetFeed requestTargetField () {
      return this.requestTargetField(true);
    }
    public APIRequestGetFeed requestTargetField (boolean value) {
      this.requestField("target", value);
      return this;
    }
    public APIRequestGetFeed requestTargetingField () {
      return this.requestTargetingField(true);
    }
    public APIRequestGetFeed requestTargetingField (boolean value) {
      this.requestField("targeting", value);
      return this;
    }
    public APIRequestGetFeed requestTimelineVisibilityField () {
      return this.requestTimelineVisibilityField(true);
    }
    public APIRequestGetFeed requestTimelineVisibilityField (boolean value) {
      this.requestField("timeline_visibility", value);
      return this;
    }
    public APIRequestGetFeed requestTypeField () {
      return this.requestTypeField(true);
    }
    public APIRequestGetFeed requestTypeField (boolean value) {
      this.requestField("type", value);
      return this;
    }
    public APIRequestGetFeed requestUpdatedTimeField () {
      return this.requestUpdatedTimeField(true);
    }
    public APIRequestGetFeed requestUpdatedTimeField (boolean value) {
      this.requestField("updated_time", value);
      return this;
    }
    public APIRequestGetFeed requestViaField () {
      return this.requestViaField(true);
    }
    public APIRequestGetFeed requestViaField (boolean value) {
      this.requestField("via", value);
      return this;
    }
    public APIRequestGetFeed requestVideoBuyingEligibilityField () {
      return this.requestVideoBuyingEligibilityField(true);
    }
    public APIRequestGetFeed requestVideoBuyingEligibilityField (boolean value) {
      this.requestField("video_buying_eligibility", value);
      return this;
    }
    public APIRequestGetFeed requestWidthField () {
      return this.requestWidthField(true);
    }
    public APIRequestGetFeed requestWidthField (boolean value) {
      this.requestField("width", value);
      return this;
    }
  }

  public static class APIRequestCreateFeed extends APIRequest<PagePost> {

    PagePost lastResponse = null;
    @Override
    public PagePost getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "picture",
      "name",
      "link",
      "caption",
      "description",
      "quote",
      "source",
      "properties",
      "object_attachment",
      "height",
      "width",
      "expanded_height",
      "expanded_width",
      "referral_id",
      "thumbnail",
      "image_crops",
      "call_to_action",
      "time_since_original_post",
      "client_mutation_id",
      "privacy",
      "composer_session_id",
      "content_attachment",
      "actions",
      "targeting",
      "feed_targeting",
      "ref",
      "tags",
      "place",
      "is_explicit_location",
      "og_action_type_id",
      "og_object_id",
      "og_phrase",
      "og_icon_id",
      "og_set_profile_badge",
      "og_suggestion_mechanism",
      "og_hide_object_attachment",
      "backdated_time",
      "backdated_time_granularity",
      "published",
      "scheduled_publish_time",
      "unpublished_content_type",
      "application_id",
      "proxied_app_id",
      "ios_bundle_id",
      "android_key_hash",
      "user_selected_tags",
      "nectar_module",
      "manual_privacy",
      "audience_exp",
      "coordinates",
      "is_explicit_share",
      "is_photo_container",
      "implicit_with_tags",
      "child_attachments",
      "suggested_place_id",
      "attach_place_suggestion",
      "viewer_coordinates",
      "album_id",
      "multi_share_optimized",
      "multi_share_end_card",
      "title",
      "attached_media",
      "home_checkin_city_id",
      "text_only_place",
      "connection_class",
      "associated_id",
      "posting_to_redspace",
      "place_attachment_setting",
      "checkin_entry_point",
      "is_backout_draft",
      "sponsor_id",
      "direct_share_status",
      "sponsor_relationship",
      "referenceable_image_ids",
      "prompt_id",
      "prompt_tracking_string",
      "post_surfaces_blacklist",
      "tracking_info",
      "text_format_preset_id",
      "cta_link",
      "cta_type",
      "place_list_data",
      "formatting",
      "target_surface",
      "adaptive_type",
      "animated_effect_id",
      "asked_fun_fact_prompt_id",
      "asset3d_id",
      "composer_entry_picker",
      "composer_entry_point",
      "composer_entry_time",
      "composer_session_events_log",
      "composer_source_surface",
      "composer_type",
      "fun_fact_prompt_id",
      "fun_fact_toastee_id",
      "is_group_linking_post",
      "has_nickname",
      "holiday_card",
      "instant_game_entry_point_data",
      "is_boost_intended",
      "location_source_id",
      "message",
      "offer_like_post_id",
      "page_recommendation",
      "place_list",
      "publish_event_id",
      "react_mode_metadata",
      "sales_promo_id",
      "text_format_metadata",
      "throwback_camera_roll_media",
      "video_start_time_ms",
      "enforce_link_ownership",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public PagePost parseResponse(String response) throws APIException {
      return PagePost.parseResponse(response, getContext(), this).head();
    }

    @Override
    public PagePost execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public PagePost execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<PagePost> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<PagePost> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, PagePost>() {
           public PagePost apply(String result) {
             try {
               return APIRequestCreateFeed.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateFeed(String nodeId, APIContext context) {
      super(context, nodeId, "/feed", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateFeed setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateFeed setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateFeed setPicture (String picture) {
      this.setParam("picture", picture);
      return this;
    }

    public APIRequestCreateFeed setName (String name) {
      this.setParam("name", name);
      return this;
    }

    public APIRequestCreateFeed setLink (String link) {
      this.setParam("link", link);
      return this;
    }

    public APIRequestCreateFeed setCaption (String caption) {
      this.setParam("caption", caption);
      return this;
    }

    public APIRequestCreateFeed setDescription (String description) {
      this.setParam("description", description);
      return this;
    }

    public APIRequestCreateFeed setQuote (String quote) {
      this.setParam("quote", quote);
      return this;
    }

    public APIRequestCreateFeed setSource (String source) {
      this.setParam("source", source);
      return this;
    }

    public APIRequestCreateFeed setProperties (Object properties) {
      this.setParam("properties", properties);
      return this;
    }
    public APIRequestCreateFeed setProperties (String properties) {
      this.setParam("properties", properties);
      return this;
    }

    public APIRequestCreateFeed setObjectAttachment (String objectAttachment) {
      this.setParam("object_attachment", objectAttachment);
      return this;
    }

    public APIRequestCreateFeed setHeight (Long height) {
      this.setParam("height", height);
      return this;
    }
    public APIRequestCreateFeed setHeight (String height) {
      this.setParam("height", height);
      return this;
    }

    public APIRequestCreateFeed setWidth (Long width) {
      this.setParam("width", width);
      return this;
    }
    public APIRequestCreateFeed setWidth (String width) {
      this.setParam("width", width);
      return this;
    }

    public APIRequestCreateFeed setExpandedHeight (Long expandedHeight) {
      this.setParam("expanded_height", expandedHeight);
      return this;
    }
    public APIRequestCreateFeed setExpandedHeight (String expandedHeight) {
      this.setParam("expanded_height", expandedHeight);
      return this;
    }

    public APIRequestCreateFeed setExpandedWidth (Long expandedWidth) {
      this.setParam("expanded_width", expandedWidth);
      return this;
    }
    public APIRequestCreateFeed setExpandedWidth (String expandedWidth) {
      this.setParam("expanded_width", expandedWidth);
      return this;
    }

    public APIRequestCreateFeed setReferralId (String referralId) {
      this.setParam("referral_id", referralId);
      return this;
    }

    public APIRequestCreateFeed setThumbnail (File thumbnail) {
      this.setParam("thumbnail", thumbnail);
      return this;
    }
    public APIRequestCreateFeed setThumbnail (String thumbnail) {
      this.setParam("thumbnail", thumbnail);
      return this;
    }

    public APIRequestCreateFeed setImageCrops (Map<String, String> imageCrops) {
      this.setParam("image_crops", imageCrops);
      return this;
    }
    public APIRequestCreateFeed setImageCrops (String imageCrops) {
      this.setParam("image_crops", imageCrops);
      return this;
    }

    public APIRequestCreateFeed setCallToAction (Object callToAction) {
      this.setParam("call_to_action", callToAction);
      return this;
    }
    public APIRequestCreateFeed setCallToAction (String callToAction) {
      this.setParam("call_to_action", callToAction);
      return this;
    }

    public APIRequestCreateFeed setTimeSinceOriginalPost (Long timeSinceOriginalPost) {
      this.setParam("time_since_original_post", timeSinceOriginalPost);
      return this;
    }
    public APIRequestCreateFeed setTimeSinceOriginalPost (String timeSinceOriginalPost) {
      this.setParam("time_since_original_post", timeSinceOriginalPost);
      return this;
    }

    public APIRequestCreateFeed setClientMutationId (String clientMutationId) {
      this.setParam("client_mutation_id", clientMutationId);
      return this;
    }

    public APIRequestCreateFeed setPrivacy (Object privacy) {
      this.setParam("privacy", privacy);
      return this;
    }
    public APIRequestCreateFeed setPrivacy (String privacy) {
      this.setParam("privacy", privacy);
      return this;
    }

    public APIRequestCreateFeed setComposerSessionId (String composerSessionId) {
      this.setParam("composer_session_id", composerSessionId);
      return this;
    }

    public APIRequestCreateFeed setContentAttachment (String contentAttachment) {
      this.setParam("content_attachment", contentAttachment);
      return this;
    }

    public APIRequestCreateFeed setActions (Object actions) {
      this.setParam("actions", actions);
      return this;
    }
    public APIRequestCreateFeed setActions (String actions) {
      this.setParam("actions", actions);
      return this;
    }

    public APIRequestCreateFeed setTargeting (Object targeting) {
      this.setParam("targeting", targeting);
      return this;
    }
    public APIRequestCreateFeed setTargeting (String targeting) {
      this.setParam("targeting", targeting);
      return this;
    }

    public APIRequestCreateFeed setFeedTargeting (Object feedTargeting) {
      this.setParam("feed_targeting", feedTargeting);
      return this;
    }
    public APIRequestCreateFeed setFeedTargeting (String feedTargeting) {
      this.setParam("feed_targeting", feedTargeting);
      return this;
    }

    public APIRequestCreateFeed setRef (List<String> ref) {
      this.setParam("ref", ref);
      return this;
    }
    public APIRequestCreateFeed setRef (String ref) {
      this.setParam("ref", ref);
      return this;
    }

    public APIRequestCreateFeed setTags (List<Long> tags) {
      this.setParam("tags", tags);
      return this;
    }
    public APIRequestCreateFeed setTags (String tags) {
      this.setParam("tags", tags);
      return this;
    }

    public APIRequestCreateFeed setPlace (Object place) {
      this.setParam("place", place);
      return this;
    }
    public APIRequestCreateFeed setPlace (String place) {
      this.setParam("place", place);
      return this;
    }

    public APIRequestCreateFeed setIsExplicitLocation (Boolean isExplicitLocation) {
      this.setParam("is_explicit_location", isExplicitLocation);
      return this;
    }
    public APIRequestCreateFeed setIsExplicitLocation (String isExplicitLocation) {
      this.setParam("is_explicit_location", isExplicitLocation);
      return this;
    }

    public APIRequestCreateFeed setOgActionTypeId (String ogActionTypeId) {
      this.setParam("og_action_type_id", ogActionTypeId);
      return this;
    }

    public APIRequestCreateFeed setOgObjectId (String ogObjectId) {
      this.setParam("og_object_id", ogObjectId);
      return this;
    }

    public APIRequestCreateFeed setOgPhrase (String ogPhrase) {
      this.setParam("og_phrase", ogPhrase);
      return this;
    }

    public APIRequestCreateFeed setOgIconId (String ogIconId) {
      this.setParam("og_icon_id", ogIconId);
      return this;
    }

    public APIRequestCreateFeed setOgSetProfileBadge (Boolean ogSetProfileBadge) {
      this.setParam("og_set_profile_badge", ogSetProfileBadge);
      return this;
    }
    public APIRequestCreateFeed setOgSetProfileBadge (String ogSetProfileBadge) {
      this.setParam("og_set_profile_badge", ogSetProfileBadge);
      return this;
    }

    public APIRequestCreateFeed setOgSuggestionMechanism (String ogSuggestionMechanism) {
      this.setParam("og_suggestion_mechanism", ogSuggestionMechanism);
      return this;
    }

    public APIRequestCreateFeed setOgHideObjectAttachment (Boolean ogHideObjectAttachment) {
      this.setParam("og_hide_object_attachment", ogHideObjectAttachment);
      return this;
    }
    public APIRequestCreateFeed setOgHideObjectAttachment (String ogHideObjectAttachment) {
      this.setParam("og_hide_object_attachment", ogHideObjectAttachment);
      return this;
    }

    public APIRequestCreateFeed setBackdatedTime (String backdatedTime) {
      this.setParam("backdated_time", backdatedTime);
      return this;
    }

    public APIRequestCreateFeed setBackdatedTimeGranularity (PagePost.EnumBackdatedTimeGranularity backdatedTimeGranularity) {
      this.setParam("backdated_time_granularity", backdatedTimeGranularity);
      return this;
    }
    public APIRequestCreateFeed setBackdatedTimeGranularity (String backdatedTimeGranularity) {
      this.setParam("backdated_time_granularity", backdatedTimeGranularity);
      return this;
    }

    public APIRequestCreateFeed setPublished (Boolean published) {
      this.setParam("published", published);
      return this;
    }
    public APIRequestCreateFeed setPublished (String published) {
      this.setParam("published", published);
      return this;
    }

    public APIRequestCreateFeed setScheduledPublishTime (String scheduledPublishTime) {
      this.setParam("scheduled_publish_time", scheduledPublishTime);
      return this;
    }

    public APIRequestCreateFeed setUnpublishedContentType (PagePost.EnumUnpublishedContentType unpublishedContentType) {
      this.setParam("unpublished_content_type", unpublishedContentType);
      return this;
    }
    public APIRequestCreateFeed setUnpublishedContentType (String unpublishedContentType) {
      this.setParam("unpublished_content_type", unpublishedContentType);
      return this;
    }

    public APIRequestCreateFeed setApplicationId (String applicationId) {
      this.setParam("application_id", applicationId);
      return this;
    }

    public APIRequestCreateFeed setProxiedAppId (String proxiedAppId) {
      this.setParam("proxied_app_id", proxiedAppId);
      return this;
    }

    public APIRequestCreateFeed setIosBundleId (String iosBundleId) {
      this.setParam("ios_bundle_id", iosBundleId);
      return this;
    }

    public APIRequestCreateFeed setAndroidKeyHash (String androidKeyHash) {
      this.setParam("android_key_hash", androidKeyHash);
      return this;
    }

    public APIRequestCreateFeed setUserSelectedTags (Boolean userSelectedTags) {
      this.setParam("user_selected_tags", userSelectedTags);
      return this;
    }
    public APIRequestCreateFeed setUserSelectedTags (String userSelectedTags) {
      this.setParam("user_selected_tags", userSelectedTags);
      return this;
    }

    public APIRequestCreateFeed setNectarModule (String nectarModule) {
      this.setParam("nectar_module", nectarModule);
      return this;
    }

    public APIRequestCreateFeed setManualPrivacy (Boolean manualPrivacy) {
      this.setParam("manual_privacy", manualPrivacy);
      return this;
    }
    public APIRequestCreateFeed setManualPrivacy (String manualPrivacy) {
      this.setParam("manual_privacy", manualPrivacy);
      return this;
    }

    public APIRequestCreateFeed setAudienceExp (Boolean audienceExp) {
      this.setParam("audience_exp", audienceExp);
      return this;
    }
    public APIRequestCreateFeed setAudienceExp (String audienceExp) {
      this.setParam("audience_exp", audienceExp);
      return this;
    }

    public APIRequestCreateFeed setCoordinates (Object coordinates) {
      this.setParam("coordinates", coordinates);
      return this;
    }
    public APIRequestCreateFeed setCoordinates (String coordinates) {
      this.setParam("coordinates", coordinates);
      return this;
    }

    public APIRequestCreateFeed setIsExplicitShare (Boolean isExplicitShare) {
      this.setParam("is_explicit_share", isExplicitShare);
      return this;
    }
    public APIRequestCreateFeed setIsExplicitShare (String isExplicitShare) {
      this.setParam("is_explicit_share", isExplicitShare);
      return this;
    }

    public APIRequestCreateFeed setIsPhotoContainer (Boolean isPhotoContainer) {
      this.setParam("is_photo_container", isPhotoContainer);
      return this;
    }
    public APIRequestCreateFeed setIsPhotoContainer (String isPhotoContainer) {
      this.setParam("is_photo_container", isPhotoContainer);
      return this;
    }

    public APIRequestCreateFeed setImplicitWithTags (List<Long> implicitWithTags) {
      this.setParam("implicit_with_tags", implicitWithTags);
      return this;
    }
    public APIRequestCreateFeed setImplicitWithTags (String implicitWithTags) {
      this.setParam("implicit_with_tags", implicitWithTags);
      return this;
    }

    public APIRequestCreateFeed setChildAttachments (List<Object> childAttachments) {
      this.setParam("child_attachments", childAttachments);
      return this;
    }
    public APIRequestCreateFeed setChildAttachments (String childAttachments) {
      this.setParam("child_attachments", childAttachments);
      return this;
    }

    public APIRequestCreateFeed setSuggestedPlaceId (Object suggestedPlaceId) {
      this.setParam("suggested_place_id", suggestedPlaceId);
      return this;
    }
    public APIRequestCreateFeed setSuggestedPlaceId (String suggestedPlaceId) {
      this.setParam("suggested_place_id", suggestedPlaceId);
      return this;
    }

    public APIRequestCreateFeed setAttachPlaceSuggestion (Boolean attachPlaceSuggestion) {
      this.setParam("attach_place_suggestion", attachPlaceSuggestion);
      return this;
    }
    public APIRequestCreateFeed setAttachPlaceSuggestion (String attachPlaceSuggestion) {
      this.setParam("attach_place_suggestion", attachPlaceSuggestion);
      return this;
    }

    public APIRequestCreateFeed setViewerCoordinates (Object viewerCoordinates) {
      this.setParam("viewer_coordinates", viewerCoordinates);
      return this;
    }
    public APIRequestCreateFeed setViewerCoordinates (String viewerCoordinates) {
      this.setParam("viewer_coordinates", viewerCoordinates);
      return this;
    }

    public APIRequestCreateFeed setAlbumId (String albumId) {
      this.setParam("album_id", albumId);
      return this;
    }

    public APIRequestCreateFeed setMultiShareOptimized (Boolean multiShareOptimized) {
      this.setParam("multi_share_optimized", multiShareOptimized);
      return this;
    }
    public APIRequestCreateFeed setMultiShareOptimized (String multiShareOptimized) {
      this.setParam("multi_share_optimized", multiShareOptimized);
      return this;
    }

    public APIRequestCreateFeed setMultiShareEndCard (Boolean multiShareEndCard) {
      this.setParam("multi_share_end_card", multiShareEndCard);
      return this;
    }
    public APIRequestCreateFeed setMultiShareEndCard (String multiShareEndCard) {
      this.setParam("multi_share_end_card", multiShareEndCard);
      return this;
    }

    public APIRequestCreateFeed setTitle (String title) {
      this.setParam("title", title);
      return this;
    }

    public APIRequestCreateFeed setAttachedMedia (List<Object> attachedMedia) {
      this.setParam("attached_media", attachedMedia);
      return this;
    }
    public APIRequestCreateFeed setAttachedMedia (String attachedMedia) {
      this.setParam("attached_media", attachedMedia);
      return this;
    }

    public APIRequestCreateFeed setHomeCheckinCityId (Object homeCheckinCityId) {
      this.setParam("home_checkin_city_id", homeCheckinCityId);
      return this;
    }
    public APIRequestCreateFeed setHomeCheckinCityId (String homeCheckinCityId) {
      this.setParam("home_checkin_city_id", homeCheckinCityId);
      return this;
    }

    public APIRequestCreateFeed setTextOnlyPlace (String textOnlyPlace) {
      this.setParam("text_only_place", textOnlyPlace);
      return this;
    }

    public APIRequestCreateFeed setConnectionClass (String connectionClass) {
      this.setParam("connection_class", connectionClass);
      return this;
    }

    public APIRequestCreateFeed setAssociatedId (String associatedId) {
      this.setParam("associated_id", associatedId);
      return this;
    }

    public APIRequestCreateFeed setPostingToRedspace (PagePost.EnumPostingToRedspace postingToRedspace) {
      this.setParam("posting_to_redspace", postingToRedspace);
      return this;
    }
    public APIRequestCreateFeed setPostingToRedspace (String postingToRedspace) {
      this.setParam("posting_to_redspace", postingToRedspace);
      return this;
    }

    public APIRequestCreateFeed setPlaceAttachmentSetting (PagePost.EnumPlaceAttachmentSetting placeAttachmentSetting) {
      this.setParam("place_attachment_setting", placeAttachmentSetting);
      return this;
    }
    public APIRequestCreateFeed setPlaceAttachmentSetting (String placeAttachmentSetting) {
      this.setParam("place_attachment_setting", placeAttachmentSetting);
      return this;
    }

    public APIRequestCreateFeed setCheckinEntryPoint (PagePost.EnumCheckinEntryPoint checkinEntryPoint) {
      this.setParam("checkin_entry_point", checkinEntryPoint);
      return this;
    }
    public APIRequestCreateFeed setCheckinEntryPoint (String checkinEntryPoint) {
      this.setParam("checkin_entry_point", checkinEntryPoint);
      return this;
    }

    public APIRequestCreateFeed setIsBackoutDraft (Boolean isBackoutDraft) {
      this.setParam("is_backout_draft", isBackoutDraft);
      return this;
    }
    public APIRequestCreateFeed setIsBackoutDraft (String isBackoutDraft) {
      this.setParam("is_backout_draft", isBackoutDraft);
      return this;
    }

    public APIRequestCreateFeed setSponsorId (String sponsorId) {
      this.setParam("sponsor_id", sponsorId);
      return this;
    }

    public APIRequestCreateFeed setDirectShareStatus (Long directShareStatus) {
      this.setParam("direct_share_status", directShareStatus);
      return this;
    }
    public APIRequestCreateFeed setDirectShareStatus (String directShareStatus) {
      this.setParam("direct_share_status", directShareStatus);
      return this;
    }

    public APIRequestCreateFeed setSponsorRelationship (Long sponsorRelationship) {
      this.setParam("sponsor_relationship", sponsorRelationship);
      return this;
    }
    public APIRequestCreateFeed setSponsorRelationship (String sponsorRelationship) {
      this.setParam("sponsor_relationship", sponsorRelationship);
      return this;
    }

    public APIRequestCreateFeed setReferenceableImageIds (List<String> referenceableImageIds) {
      this.setParam("referenceable_image_ids", referenceableImageIds);
      return this;
    }
    public APIRequestCreateFeed setReferenceableImageIds (String referenceableImageIds) {
      this.setParam("referenceable_image_ids", referenceableImageIds);
      return this;
    }

    public APIRequestCreateFeed setPromptId (String promptId) {
      this.setParam("prompt_id", promptId);
      return this;
    }

    public APIRequestCreateFeed setPromptTrackingString (String promptTrackingString) {
      this.setParam("prompt_tracking_string", promptTrackingString);
      return this;
    }

    public APIRequestCreateFeed setPostSurfacesBlacklist (List<PagePost.EnumPostSurfacesBlacklist> postSurfacesBlacklist) {
      this.setParam("post_surfaces_blacklist", postSurfacesBlacklist);
      return this;
    }
    public APIRequestCreateFeed setPostSurfacesBlacklist (String postSurfacesBlacklist) {
      this.setParam("post_surfaces_blacklist", postSurfacesBlacklist);
      return this;
    }

    public APIRequestCreateFeed setTrackingInfo (String trackingInfo) {
      this.setParam("tracking_info", trackingInfo);
      return this;
    }

    public APIRequestCreateFeed setTextFormatPresetId (String textFormatPresetId) {
      this.setParam("text_format_preset_id", textFormatPresetId);
      return this;
    }

    public APIRequestCreateFeed setCtaLink (String ctaLink) {
      this.setParam("cta_link", ctaLink);
      return this;
    }

    public APIRequestCreateFeed setCtaType (String ctaType) {
      this.setParam("cta_type", ctaType);
      return this;
    }

    public APIRequestCreateFeed setPlaceListData (Object placeListData) {
      this.setParam("place_list_data", placeListData);
      return this;
    }
    public APIRequestCreateFeed setPlaceListData (String placeListData) {
      this.setParam("place_list_data", placeListData);
      return this;
    }

    public APIRequestCreateFeed setFormatting (PagePost.EnumFormatting formatting) {
      this.setParam("formatting", formatting);
      return this;
    }
    public APIRequestCreateFeed setFormatting (String formatting) {
      this.setParam("formatting", formatting);
      return this;
    }

    public APIRequestCreateFeed setTargetSurface (PagePost.EnumTargetSurface targetSurface) {
      this.setParam("target_surface", targetSurface);
      return this;
    }
    public APIRequestCreateFeed setTargetSurface (String targetSurface) {
      this.setParam("target_surface", targetSurface);
      return this;
    }

    public APIRequestCreateFeed setAdaptiveType (String adaptiveType) {
      this.setParam("adaptive_type", adaptiveType);
      return this;
    }

    public APIRequestCreateFeed setAnimatedEffectId (Long animatedEffectId) {
      this.setParam("animated_effect_id", animatedEffectId);
      return this;
    }
    public APIRequestCreateFeed setAnimatedEffectId (String animatedEffectId) {
      this.setParam("animated_effect_id", animatedEffectId);
      return this;
    }

    public APIRequestCreateFeed setAskedFunFactPromptId (Long askedFunFactPromptId) {
      this.setParam("asked_fun_fact_prompt_id", askedFunFactPromptId);
      return this;
    }
    public APIRequestCreateFeed setAskedFunFactPromptId (String askedFunFactPromptId) {
      this.setParam("asked_fun_fact_prompt_id", askedFunFactPromptId);
      return this;
    }

    public APIRequestCreateFeed setAsset3dId (Long asset3dId) {
      this.setParam("asset3d_id", asset3dId);
      return this;
    }
    public APIRequestCreateFeed setAsset3dId (String asset3dId) {
      this.setParam("asset3d_id", asset3dId);
      return this;
    }

    public APIRequestCreateFeed setComposerEntryPicker (String composerEntryPicker) {
      this.setParam("composer_entry_picker", composerEntryPicker);
      return this;
    }

    public APIRequestCreateFeed setComposerEntryPoint (String composerEntryPoint) {
      this.setParam("composer_entry_point", composerEntryPoint);
      return this;
    }

    public APIRequestCreateFeed setComposerEntryTime (Long composerEntryTime) {
      this.setParam("composer_entry_time", composerEntryTime);
      return this;
    }
    public APIRequestCreateFeed setComposerEntryTime (String composerEntryTime) {
      this.setParam("composer_entry_time", composerEntryTime);
      return this;
    }

    public APIRequestCreateFeed setComposerSessionEventsLog (String composerSessionEventsLog) {
      this.setParam("composer_session_events_log", composerSessionEventsLog);
      return this;
    }

    public APIRequestCreateFeed setComposerSourceSurface (String composerSourceSurface) {
      this.setParam("composer_source_surface", composerSourceSurface);
      return this;
    }

    public APIRequestCreateFeed setComposerType (String composerType) {
      this.setParam("composer_type", composerType);
      return this;
    }

    public APIRequestCreateFeed setFunFactPromptId (String funFactPromptId) {
      this.setParam("fun_fact_prompt_id", funFactPromptId);
      return this;
    }

    public APIRequestCreateFeed setFunFactToasteeId (Long funFactToasteeId) {
      this.setParam("fun_fact_toastee_id", funFactToasteeId);
      return this;
    }
    public APIRequestCreateFeed setFunFactToasteeId (String funFactToasteeId) {
      this.setParam("fun_fact_toastee_id", funFactToasteeId);
      return this;
    }

    public APIRequestCreateFeed setIsGroupLinkingPost (Boolean isGroupLinkingPost) {
      this.setParam("is_group_linking_post", isGroupLinkingPost);
      return this;
    }
    public APIRequestCreateFeed setIsGroupLinkingPost (String isGroupLinkingPost) {
      this.setParam("is_group_linking_post", isGroupLinkingPost);
      return this;
    }

    public APIRequestCreateFeed setHasNickname (Boolean hasNickname) {
      this.setParam("has_nickname", hasNickname);
      return this;
    }
    public APIRequestCreateFeed setHasNickname (String hasNickname) {
      this.setParam("has_nickname", hasNickname);
      return this;
    }

    public APIRequestCreateFeed setHolidayCard (String holidayCard) {
      this.setParam("holiday_card", holidayCard);
      return this;
    }

    public APIRequestCreateFeed setInstantGameEntryPointData (String instantGameEntryPointData) {
      this.setParam("instant_game_entry_point_data", instantGameEntryPointData);
      return this;
    }

    public APIRequestCreateFeed setIsBoostIntended (Boolean isBoostIntended) {
      this.setParam("is_boost_intended", isBoostIntended);
      return this;
    }
    public APIRequestCreateFeed setIsBoostIntended (String isBoostIntended) {
      this.setParam("is_boost_intended", isBoostIntended);
      return this;
    }

    public APIRequestCreateFeed setLocationSourceId (String locationSourceId) {
      this.setParam("location_source_id", locationSourceId);
      return this;
    }

    public APIRequestCreateFeed setMessage (String message) {
      this.setParam("message", message);
      return this;
    }

    public APIRequestCreateFeed setOfferLikePostId (String offerLikePostId) {
      this.setParam("offer_like_post_id", offerLikePostId);
      return this;
    }

    public APIRequestCreateFeed setPageRecommendation (String pageRecommendation) {
      this.setParam("page_recommendation", pageRecommendation);
      return this;
    }

    public APIRequestCreateFeed setPlaceList (String placeList) {
      this.setParam("place_list", placeList);
      return this;
    }

    public APIRequestCreateFeed setPublishEventId (Long publishEventId) {
      this.setParam("publish_event_id", publishEventId);
      return this;
    }
    public APIRequestCreateFeed setPublishEventId (String publishEventId) {
      this.setParam("publish_event_id", publishEventId);
      return this;
    }

    public APIRequestCreateFeed setReactModeMetadata (String reactModeMetadata) {
      this.setParam("react_mode_metadata", reactModeMetadata);
      return this;
    }

    public APIRequestCreateFeed setSalesPromoId (Long salesPromoId) {
      this.setParam("sales_promo_id", salesPromoId);
      return this;
    }
    public APIRequestCreateFeed setSalesPromoId (String salesPromoId) {
      this.setParam("sales_promo_id", salesPromoId);
      return this;
    }

    public APIRequestCreateFeed setTextFormatMetadata (String textFormatMetadata) {
      this.setParam("text_format_metadata", textFormatMetadata);
      return this;
    }

    public APIRequestCreateFeed setThrowbackCameraRollMedia (String throwbackCameraRollMedia) {
      this.setParam("throwback_camera_roll_media", throwbackCameraRollMedia);
      return this;
    }

    public APIRequestCreateFeed setVideoStartTimeMs (Long videoStartTimeMs) {
      this.setParam("video_start_time_ms", videoStartTimeMs);
      return this;
    }
    public APIRequestCreateFeed setVideoStartTimeMs (String videoStartTimeMs) {
      this.setParam("video_start_time_ms", videoStartTimeMs);
      return this;
    }

    public APIRequestCreateFeed setEnforceLinkOwnership (Boolean enforceLinkOwnership) {
      this.setParam("enforce_link_ownership", enforceLinkOwnership);
      return this;
    }
    public APIRequestCreateFeed setEnforceLinkOwnership (String enforceLinkOwnership) {
      this.setParam("enforce_link_ownership", enforceLinkOwnership);
      return this;
    }

    public APIRequestCreateFeed requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateFeed requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateFeed requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateFeed requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateFeed requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateFeed requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestCreateFlag extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "page_id",
      "page_ids",
      "flag",
      "value",
      "entry_point",
      "endpoint",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response) throws APIException {
      return Page.parseResponse(response, getContext(), this).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, Page>() {
           public Page apply(String result) {
             try {
               return APIRequestCreateFlag.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateFlag(String nodeId, APIContext context) {
      super(context, nodeId, "/flags", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateFlag setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateFlag setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateFlag setPageId (Long pageId) {
      this.setParam("page_id", pageId);
      return this;
    }
    public APIRequestCreateFlag setPageId (String pageId) {
      this.setParam("page_id", pageId);
      return this;
    }

    public APIRequestCreateFlag setPageIds (List<Long> pageIds) {
      this.setParam("page_ids", pageIds);
      return this;
    }
    public APIRequestCreateFlag setPageIds (String pageIds) {
      this.setParam("page_ids", pageIds);
      return this;
    }

    public APIRequestCreateFlag setFlag (String flag) {
      this.setParam("flag", flag);
      return this;
    }

    public APIRequestCreateFlag setValue (Boolean value) {
      this.setParam("value", value);
      return this;
    }
    public APIRequestCreateFlag setValue (String value) {
      this.setParam("value", value);
      return this;
    }

    public APIRequestCreateFlag setEntryPoint (String entryPoint) {
      this.setParam("entry_point", entryPoint);
      return this;
    }

    public APIRequestCreateFlag setEndpoint (String endpoint) {
      this.setParam("endpoint", endpoint);
      return this;
    }

    public APIRequestCreateFlag requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateFlag requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateFlag requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateFlag requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateFlag requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateFlag requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetGlobalBrandChildren extends APIRequest<Page> {

    APINodeList<Page> lastResponse = null;
    @Override
    public APINodeList<Page> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "about",
      "access_token",
      "ad_campaign",
      "affiliation",
      "app_id",
      "app_links",
      "artists_we_like",
      "attire",
      "awards",
      "band_interests",
      "band_members",
      "best_page",
      "bio",
      "birthday",
      "booking_agent",
      "built",
      "business",
      "can_checkin",
      "can_post",
      "category",
      "category_list",
      "checkins",
      "company_overview",
      "connected_instagram_account",
      "contact_address",
      "context",
      "copyright_attribution_insights",
      "copyright_whitelisted_ig_partners",
      "country_page_likes",
      "cover",
      "culinary_team",
      "current_location",
      "description",
      "description_html",
      "directed_by",
      "display_subtext",
      "displayed_message_response_time",
      "emails",
      "engagement",
      "fan_count",
      "featured_video",
      "features",
      "food_styles",
      "founded",
      "general_info",
      "general_manager",
      "genre",
      "global_brand_page_name",
      "global_brand_parent_page",
      "global_brand_root_id",
      "has_added_app",
      "has_whatsapp_business_number",
      "has_whatsapp_number",
      "hometown",
      "hours",
      "id",
      "impressum",
      "influences",
      "instagram_business_account",
      "instant_articles_review_status",
      "is_always_open",
      "is_chain",
      "is_community_page",
      "is_eligible_for_branded_content",
      "is_messenger_bot_get_started_enabled",
      "is_messenger_platform_bot",
      "is_owned",
      "is_permanently_closed",
      "is_published",
      "is_unclaimed",
      "is_verified",
      "is_webhooks_subscribed",
      "keywords",
      "leadgen_form_preview_details",
      "leadgen_has_crm_integration",
      "leadgen_has_fat_ping_crm_integration",
      "leadgen_tos_acceptance_time",
      "leadgen_tos_accepted",
      "leadgen_tos_accepting_user",
      "link",
      "location",
      "members",
      "merchant_id",
      "merchant_review_status",
      "messenger_ads_default_icebreakers",
      "messenger_ads_default_page_welcome_message",
      "messenger_ads_default_quick_replies",
      "messenger_ads_quick_replies_type",
      "mission",
      "mpg",
      "name",
      "name_with_location_descriptor",
      "network",
      "new_like_count",
      "offer_eligible",
      "overall_star_rating",
      "page_token",
      "parent_page",
      "parking",
      "payment_options",
      "personal_info",
      "personal_interests",
      "pharma_safety_info",
      "phone",
      "place_type",
      "plot_outline",
      "preferred_audience",
      "press_contact",
      "price_range",
      "produced_by",
      "products",
      "promotion_eligible",
      "promotion_ineligible_reason",
      "public_transit",
      "publisher_space",
      "rating_count",
      "recipient",
      "record_label",
      "release_date",
      "restaurant_services",
      "restaurant_specialties",
      "schedule",
      "screenplay_by",
      "season",
      "single_line_address",
      "starring",
      "start_info",
      "store_code",
      "store_location_descriptor",
      "store_number",
      "studio",
      "supports_instant_articles",
      "talking_about_count",
      "unread_message_count",
      "unread_notif_count",
      "unseen_message_count",
      "username",
      "verification_status",
      "voip_info",
      "website",
      "were_here_count",
      "whatsapp_number",
      "written_by",
    };

    @Override
    public APINodeList<Page> parseResponse(String response) throws APIException {
      return Page.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<Page> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Page> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Page>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Page>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<Page>>() {
           public APINodeList<Page> apply(String result) {
             try {
               return APIRequestGetGlobalBrandChildren.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetGlobalBrandChildren(String nodeId, APIContext context) {
      super(context, nodeId, "/global_brand_children", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetGlobalBrandChildren setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetGlobalBrandChildren setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetGlobalBrandChildren requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetGlobalBrandChildren requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetGlobalBrandChildren requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetGlobalBrandChildren requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetGlobalBrandChildren requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetGlobalBrandChildren requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetGlobalBrandChildren requestAboutField () {
      return this.requestAboutField(true);
    }
    public APIRequestGetGlobalBrandChildren requestAboutField (boolean value) {
      this.requestField("about", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestAccessTokenField () {
      return this.requestAccessTokenField(true);
    }
    public APIRequestGetGlobalBrandChildren requestAccessTokenField (boolean value) {
      this.requestField("access_token", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestAdCampaignField () {
      return this.requestAdCampaignField(true);
    }
    public APIRequestGetGlobalBrandChildren requestAdCampaignField (boolean value) {
      this.requestField("ad_campaign", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestAffiliationField () {
      return this.requestAffiliationField(true);
    }
    public APIRequestGetGlobalBrandChildren requestAffiliationField (boolean value) {
      this.requestField("affiliation", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestAppIdField () {
      return this.requestAppIdField(true);
    }
    public APIRequestGetGlobalBrandChildren requestAppIdField (boolean value) {
      this.requestField("app_id", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestAppLinksField () {
      return this.requestAppLinksField(true);
    }
    public APIRequestGetGlobalBrandChildren requestAppLinksField (boolean value) {
      this.requestField("app_links", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestArtistsWeLikeField () {
      return this.requestArtistsWeLikeField(true);
    }
    public APIRequestGetGlobalBrandChildren requestArtistsWeLikeField (boolean value) {
      this.requestField("artists_we_like", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestAttireField () {
      return this.requestAttireField(true);
    }
    public APIRequestGetGlobalBrandChildren requestAttireField (boolean value) {
      this.requestField("attire", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestAwardsField () {
      return this.requestAwardsField(true);
    }
    public APIRequestGetGlobalBrandChildren requestAwardsField (boolean value) {
      this.requestField("awards", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestBandInterestsField () {
      return this.requestBandInterestsField(true);
    }
    public APIRequestGetGlobalBrandChildren requestBandInterestsField (boolean value) {
      this.requestField("band_interests", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestBandMembersField () {
      return this.requestBandMembersField(true);
    }
    public APIRequestGetGlobalBrandChildren requestBandMembersField (boolean value) {
      this.requestField("band_members", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestBestPageField () {
      return this.requestBestPageField(true);
    }
    public APIRequestGetGlobalBrandChildren requestBestPageField (boolean value) {
      this.requestField("best_page", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestBioField () {
      return this.requestBioField(true);
    }
    public APIRequestGetGlobalBrandChildren requestBioField (boolean value) {
      this.requestField("bio", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestBirthdayField () {
      return this.requestBirthdayField(true);
    }
    public APIRequestGetGlobalBrandChildren requestBirthdayField (boolean value) {
      this.requestField("birthday", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestBookingAgentField () {
      return this.requestBookingAgentField(true);
    }
    public APIRequestGetGlobalBrandChildren requestBookingAgentField (boolean value) {
      this.requestField("booking_agent", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestBuiltField () {
      return this.requestBuiltField(true);
    }
    public APIRequestGetGlobalBrandChildren requestBuiltField (boolean value) {
      this.requestField("built", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestBusinessField () {
      return this.requestBusinessField(true);
    }
    public APIRequestGetGlobalBrandChildren requestBusinessField (boolean value) {
      this.requestField("business", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestCanCheckinField () {
      return this.requestCanCheckinField(true);
    }
    public APIRequestGetGlobalBrandChildren requestCanCheckinField (boolean value) {
      this.requestField("can_checkin", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestCanPostField () {
      return this.requestCanPostField(true);
    }
    public APIRequestGetGlobalBrandChildren requestCanPostField (boolean value) {
      this.requestField("can_post", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestCategoryField () {
      return this.requestCategoryField(true);
    }
    public APIRequestGetGlobalBrandChildren requestCategoryField (boolean value) {
      this.requestField("category", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestCategoryListField () {
      return this.requestCategoryListField(true);
    }
    public APIRequestGetGlobalBrandChildren requestCategoryListField (boolean value) {
      this.requestField("category_list", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestCheckinsField () {
      return this.requestCheckinsField(true);
    }
    public APIRequestGetGlobalBrandChildren requestCheckinsField (boolean value) {
      this.requestField("checkins", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestCompanyOverviewField () {
      return this.requestCompanyOverviewField(true);
    }
    public APIRequestGetGlobalBrandChildren requestCompanyOverviewField (boolean value) {
      this.requestField("company_overview", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestConnectedInstagramAccountField () {
      return this.requestConnectedInstagramAccountField(true);
    }
    public APIRequestGetGlobalBrandChildren requestConnectedInstagramAccountField (boolean value) {
      this.requestField("connected_instagram_account", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestContactAddressField () {
      return this.requestContactAddressField(true);
    }
    public APIRequestGetGlobalBrandChildren requestContactAddressField (boolean value) {
      this.requestField("contact_address", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestContextField () {
      return this.requestContextField(true);
    }
    public APIRequestGetGlobalBrandChildren requestContextField (boolean value) {
      this.requestField("context", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestCopyrightAttributionInsightsField () {
      return this.requestCopyrightAttributionInsightsField(true);
    }
    public APIRequestGetGlobalBrandChildren requestCopyrightAttributionInsightsField (boolean value) {
      this.requestField("copyright_attribution_insights", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestCopyrightWhitelistedIgPartnersField () {
      return this.requestCopyrightWhitelistedIgPartnersField(true);
    }
    public APIRequestGetGlobalBrandChildren requestCopyrightWhitelistedIgPartnersField (boolean value) {
      this.requestField("copyright_whitelisted_ig_partners", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestCountryPageLikesField () {
      return this.requestCountryPageLikesField(true);
    }
    public APIRequestGetGlobalBrandChildren requestCountryPageLikesField (boolean value) {
      this.requestField("country_page_likes", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestCoverField () {
      return this.requestCoverField(true);
    }
    public APIRequestGetGlobalBrandChildren requestCoverField (boolean value) {
      this.requestField("cover", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestCulinaryTeamField () {
      return this.requestCulinaryTeamField(true);
    }
    public APIRequestGetGlobalBrandChildren requestCulinaryTeamField (boolean value) {
      this.requestField("culinary_team", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestCurrentLocationField () {
      return this.requestCurrentLocationField(true);
    }
    public APIRequestGetGlobalBrandChildren requestCurrentLocationField (boolean value) {
      this.requestField("current_location", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetGlobalBrandChildren requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestDescriptionHtmlField () {
      return this.requestDescriptionHtmlField(true);
    }
    public APIRequestGetGlobalBrandChildren requestDescriptionHtmlField (boolean value) {
      this.requestField("description_html", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestDirectedByField () {
      return this.requestDirectedByField(true);
    }
    public APIRequestGetGlobalBrandChildren requestDirectedByField (boolean value) {
      this.requestField("directed_by", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestDisplaySubtextField () {
      return this.requestDisplaySubtextField(true);
    }
    public APIRequestGetGlobalBrandChildren requestDisplaySubtextField (boolean value) {
      this.requestField("display_subtext", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestDisplayedMessageResponseTimeField () {
      return this.requestDisplayedMessageResponseTimeField(true);
    }
    public APIRequestGetGlobalBrandChildren requestDisplayedMessageResponseTimeField (boolean value) {
      this.requestField("displayed_message_response_time", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestEmailsField () {
      return this.requestEmailsField(true);
    }
    public APIRequestGetGlobalBrandChildren requestEmailsField (boolean value) {
      this.requestField("emails", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestEngagementField () {
      return this.requestEngagementField(true);
    }
    public APIRequestGetGlobalBrandChildren requestEngagementField (boolean value) {
      this.requestField("engagement", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestFanCountField () {
      return this.requestFanCountField(true);
    }
    public APIRequestGetGlobalBrandChildren requestFanCountField (boolean value) {
      this.requestField("fan_count", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestFeaturedVideoField () {
      return this.requestFeaturedVideoField(true);
    }
    public APIRequestGetGlobalBrandChildren requestFeaturedVideoField (boolean value) {
      this.requestField("featured_video", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestFeaturesField () {
      return this.requestFeaturesField(true);
    }
    public APIRequestGetGlobalBrandChildren requestFeaturesField (boolean value) {
      this.requestField("features", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestFoodStylesField () {
      return this.requestFoodStylesField(true);
    }
    public APIRequestGetGlobalBrandChildren requestFoodStylesField (boolean value) {
      this.requestField("food_styles", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestFoundedField () {
      return this.requestFoundedField(true);
    }
    public APIRequestGetGlobalBrandChildren requestFoundedField (boolean value) {
      this.requestField("founded", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestGeneralInfoField () {
      return this.requestGeneralInfoField(true);
    }
    public APIRequestGetGlobalBrandChildren requestGeneralInfoField (boolean value) {
      this.requestField("general_info", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestGeneralManagerField () {
      return this.requestGeneralManagerField(true);
    }
    public APIRequestGetGlobalBrandChildren requestGeneralManagerField (boolean value) {
      this.requestField("general_manager", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestGenreField () {
      return this.requestGenreField(true);
    }
    public APIRequestGetGlobalBrandChildren requestGenreField (boolean value) {
      this.requestField("genre", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestGlobalBrandPageNameField () {
      return this.requestGlobalBrandPageNameField(true);
    }
    public APIRequestGetGlobalBrandChildren requestGlobalBrandPageNameField (boolean value) {
      this.requestField("global_brand_page_name", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestGlobalBrandParentPageField () {
      return this.requestGlobalBrandParentPageField(true);
    }
    public APIRequestGetGlobalBrandChildren requestGlobalBrandParentPageField (boolean value) {
      this.requestField("global_brand_parent_page", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestGlobalBrandRootIdField () {
      return this.requestGlobalBrandRootIdField(true);
    }
    public APIRequestGetGlobalBrandChildren requestGlobalBrandRootIdField (boolean value) {
      this.requestField("global_brand_root_id", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestHasAddedAppField () {
      return this.requestHasAddedAppField(true);
    }
    public APIRequestGetGlobalBrandChildren requestHasAddedAppField (boolean value) {
      this.requestField("has_added_app", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestHasWhatsappBusinessNumberField () {
      return this.requestHasWhatsappBusinessNumberField(true);
    }
    public APIRequestGetGlobalBrandChildren requestHasWhatsappBusinessNumberField (boolean value) {
      this.requestField("has_whatsapp_business_number", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestHasWhatsappNumberField () {
      return this.requestHasWhatsappNumberField(true);
    }
    public APIRequestGetGlobalBrandChildren requestHasWhatsappNumberField (boolean value) {
      this.requestField("has_whatsapp_number", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestHometownField () {
      return this.requestHometownField(true);
    }
    public APIRequestGetGlobalBrandChildren requestHometownField (boolean value) {
      this.requestField("hometown", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestHoursField () {
      return this.requestHoursField(true);
    }
    public APIRequestGetGlobalBrandChildren requestHoursField (boolean value) {
      this.requestField("hours", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestImpressumField () {
      return this.requestImpressumField(true);
    }
    public APIRequestGetGlobalBrandChildren requestImpressumField (boolean value) {
      this.requestField("impressum", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestInfluencesField () {
      return this.requestInfluencesField(true);
    }
    public APIRequestGetGlobalBrandChildren requestInfluencesField (boolean value) {
      this.requestField("influences", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestInstagramBusinessAccountField () {
      return this.requestInstagramBusinessAccountField(true);
    }
    public APIRequestGetGlobalBrandChildren requestInstagramBusinessAccountField (boolean value) {
      this.requestField("instagram_business_account", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestInstantArticlesReviewStatusField () {
      return this.requestInstantArticlesReviewStatusField(true);
    }
    public APIRequestGetGlobalBrandChildren requestInstantArticlesReviewStatusField (boolean value) {
      this.requestField("instant_articles_review_status", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIsAlwaysOpenField () {
      return this.requestIsAlwaysOpenField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIsAlwaysOpenField (boolean value) {
      this.requestField("is_always_open", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIsChainField () {
      return this.requestIsChainField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIsChainField (boolean value) {
      this.requestField("is_chain", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIsCommunityPageField () {
      return this.requestIsCommunityPageField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIsCommunityPageField (boolean value) {
      this.requestField("is_community_page", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIsEligibleForBrandedContentField () {
      return this.requestIsEligibleForBrandedContentField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIsEligibleForBrandedContentField (boolean value) {
      this.requestField("is_eligible_for_branded_content", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIsMessengerBotGetStartedEnabledField () {
      return this.requestIsMessengerBotGetStartedEnabledField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIsMessengerBotGetStartedEnabledField (boolean value) {
      this.requestField("is_messenger_bot_get_started_enabled", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIsMessengerPlatformBotField () {
      return this.requestIsMessengerPlatformBotField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIsMessengerPlatformBotField (boolean value) {
      this.requestField("is_messenger_platform_bot", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIsOwnedField () {
      return this.requestIsOwnedField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIsOwnedField (boolean value) {
      this.requestField("is_owned", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIsPermanentlyClosedField () {
      return this.requestIsPermanentlyClosedField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIsPermanentlyClosedField (boolean value) {
      this.requestField("is_permanently_closed", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIsPublishedField () {
      return this.requestIsPublishedField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIsPublishedField (boolean value) {
      this.requestField("is_published", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIsUnclaimedField () {
      return this.requestIsUnclaimedField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIsUnclaimedField (boolean value) {
      this.requestField("is_unclaimed", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIsVerifiedField () {
      return this.requestIsVerifiedField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIsVerifiedField (boolean value) {
      this.requestField("is_verified", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestIsWebhooksSubscribedField () {
      return this.requestIsWebhooksSubscribedField(true);
    }
    public APIRequestGetGlobalBrandChildren requestIsWebhooksSubscribedField (boolean value) {
      this.requestField("is_webhooks_subscribed", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestKeywordsField () {
      return this.requestKeywordsField(true);
    }
    public APIRequestGetGlobalBrandChildren requestKeywordsField (boolean value) {
      this.requestField("keywords", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestLeadgenFormPreviewDetailsField () {
      return this.requestLeadgenFormPreviewDetailsField(true);
    }
    public APIRequestGetGlobalBrandChildren requestLeadgenFormPreviewDetailsField (boolean value) {
      this.requestField("leadgen_form_preview_details", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestLeadgenHasCrmIntegrationField () {
      return this.requestLeadgenHasCrmIntegrationField(true);
    }
    public APIRequestGetGlobalBrandChildren requestLeadgenHasCrmIntegrationField (boolean value) {
      this.requestField("leadgen_has_crm_integration", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestLeadgenHasFatPingCrmIntegrationField () {
      return this.requestLeadgenHasFatPingCrmIntegrationField(true);
    }
    public APIRequestGetGlobalBrandChildren requestLeadgenHasFatPingCrmIntegrationField (boolean value) {
      this.requestField("leadgen_has_fat_ping_crm_integration", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestLeadgenTosAcceptanceTimeField () {
      return this.requestLeadgenTosAcceptanceTimeField(true);
    }
    public APIRequestGetGlobalBrandChildren requestLeadgenTosAcceptanceTimeField (boolean value) {
      this.requestField("leadgen_tos_acceptance_time", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestLeadgenTosAcceptedField () {
      return this.requestLeadgenTosAcceptedField(true);
    }
    public APIRequestGetGlobalBrandChildren requestLeadgenTosAcceptedField (boolean value) {
      this.requestField("leadgen_tos_accepted", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestLeadgenTosAcceptingUserField () {
      return this.requestLeadgenTosAcceptingUserField(true);
    }
    public APIRequestGetGlobalBrandChildren requestLeadgenTosAcceptingUserField (boolean value) {
      this.requestField("leadgen_tos_accepting_user", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestLinkField () {
      return this.requestLinkField(true);
    }
    public APIRequestGetGlobalBrandChildren requestLinkField (boolean value) {
      this.requestField("link", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestLocationField () {
      return this.requestLocationField(true);
    }
    public APIRequestGetGlobalBrandChildren requestLocationField (boolean value) {
      this.requestField("location", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestMembersField () {
      return this.requestMembersField(true);
    }
    public APIRequestGetGlobalBrandChildren requestMembersField (boolean value) {
      this.requestField("members", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestMerchantIdField () {
      return this.requestMerchantIdField(true);
    }
    public APIRequestGetGlobalBrandChildren requestMerchantIdField (boolean value) {
      this.requestField("merchant_id", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestMerchantReviewStatusField () {
      return this.requestMerchantReviewStatusField(true);
    }
    public APIRequestGetGlobalBrandChildren requestMerchantReviewStatusField (boolean value) {
      this.requestField("merchant_review_status", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestMessengerAdsDefaultIcebreakersField () {
      return this.requestMessengerAdsDefaultIcebreakersField(true);
    }
    public APIRequestGetGlobalBrandChildren requestMessengerAdsDefaultIcebreakersField (boolean value) {
      this.requestField("messenger_ads_default_icebreakers", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestMessengerAdsDefaultPageWelcomeMessageField () {
      return this.requestMessengerAdsDefaultPageWelcomeMessageField(true);
    }
    public APIRequestGetGlobalBrandChildren requestMessengerAdsDefaultPageWelcomeMessageField (boolean value) {
      this.requestField("messenger_ads_default_page_welcome_message", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestMessengerAdsDefaultQuickRepliesField () {
      return this.requestMessengerAdsDefaultQuickRepliesField(true);
    }
    public APIRequestGetGlobalBrandChildren requestMessengerAdsDefaultQuickRepliesField (boolean value) {
      this.requestField("messenger_ads_default_quick_replies", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestMessengerAdsQuickRepliesTypeField () {
      return this.requestMessengerAdsQuickRepliesTypeField(true);
    }
    public APIRequestGetGlobalBrandChildren requestMessengerAdsQuickRepliesTypeField (boolean value) {
      this.requestField("messenger_ads_quick_replies_type", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestMissionField () {
      return this.requestMissionField(true);
    }
    public APIRequestGetGlobalBrandChildren requestMissionField (boolean value) {
      this.requestField("mission", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestMpgField () {
      return this.requestMpgField(true);
    }
    public APIRequestGetGlobalBrandChildren requestMpgField (boolean value) {
      this.requestField("mpg", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetGlobalBrandChildren requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestNameWithLocationDescriptorField () {
      return this.requestNameWithLocationDescriptorField(true);
    }
    public APIRequestGetGlobalBrandChildren requestNameWithLocationDescriptorField (boolean value) {
      this.requestField("name_with_location_descriptor", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestNetworkField () {
      return this.requestNetworkField(true);
    }
    public APIRequestGetGlobalBrandChildren requestNetworkField (boolean value) {
      this.requestField("network", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestNewLikeCountField () {
      return this.requestNewLikeCountField(true);
    }
    public APIRequestGetGlobalBrandChildren requestNewLikeCountField (boolean value) {
      this.requestField("new_like_count", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestOfferEligibleField () {
      return this.requestOfferEligibleField(true);
    }
    public APIRequestGetGlobalBrandChildren requestOfferEligibleField (boolean value) {
      this.requestField("offer_eligible", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestOverallStarRatingField () {
      return this.requestOverallStarRatingField(true);
    }
    public APIRequestGetGlobalBrandChildren requestOverallStarRatingField (boolean value) {
      this.requestField("overall_star_rating", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPageTokenField () {
      return this.requestPageTokenField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPageTokenField (boolean value) {
      this.requestField("page_token", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestParentPageField () {
      return this.requestParentPageField(true);
    }
    public APIRequestGetGlobalBrandChildren requestParentPageField (boolean value) {
      this.requestField("parent_page", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestParkingField () {
      return this.requestParkingField(true);
    }
    public APIRequestGetGlobalBrandChildren requestParkingField (boolean value) {
      this.requestField("parking", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPaymentOptionsField () {
      return this.requestPaymentOptionsField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPaymentOptionsField (boolean value) {
      this.requestField("payment_options", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPersonalInfoField () {
      return this.requestPersonalInfoField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPersonalInfoField (boolean value) {
      this.requestField("personal_info", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPersonalInterestsField () {
      return this.requestPersonalInterestsField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPersonalInterestsField (boolean value) {
      this.requestField("personal_interests", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPharmaSafetyInfoField () {
      return this.requestPharmaSafetyInfoField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPharmaSafetyInfoField (boolean value) {
      this.requestField("pharma_safety_info", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPhoneField () {
      return this.requestPhoneField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPhoneField (boolean value) {
      this.requestField("phone", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPlaceTypeField () {
      return this.requestPlaceTypeField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPlaceTypeField (boolean value) {
      this.requestField("place_type", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPlotOutlineField () {
      return this.requestPlotOutlineField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPlotOutlineField (boolean value) {
      this.requestField("plot_outline", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPreferredAudienceField () {
      return this.requestPreferredAudienceField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPreferredAudienceField (boolean value) {
      this.requestField("preferred_audience", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPressContactField () {
      return this.requestPressContactField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPressContactField (boolean value) {
      this.requestField("press_contact", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPriceRangeField () {
      return this.requestPriceRangeField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPriceRangeField (boolean value) {
      this.requestField("price_range", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestProducedByField () {
      return this.requestProducedByField(true);
    }
    public APIRequestGetGlobalBrandChildren requestProducedByField (boolean value) {
      this.requestField("produced_by", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestProductsField () {
      return this.requestProductsField(true);
    }
    public APIRequestGetGlobalBrandChildren requestProductsField (boolean value) {
      this.requestField("products", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPromotionEligibleField () {
      return this.requestPromotionEligibleField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPromotionEligibleField (boolean value) {
      this.requestField("promotion_eligible", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPromotionIneligibleReasonField () {
      return this.requestPromotionIneligibleReasonField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPromotionIneligibleReasonField (boolean value) {
      this.requestField("promotion_ineligible_reason", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPublicTransitField () {
      return this.requestPublicTransitField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPublicTransitField (boolean value) {
      this.requestField("public_transit", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestPublisherSpaceField () {
      return this.requestPublisherSpaceField(true);
    }
    public APIRequestGetGlobalBrandChildren requestPublisherSpaceField (boolean value) {
      this.requestField("publisher_space", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestRatingCountField () {
      return this.requestRatingCountField(true);
    }
    public APIRequestGetGlobalBrandChildren requestRatingCountField (boolean value) {
      this.requestField("rating_count", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestRecipientField () {
      return this.requestRecipientField(true);
    }
    public APIRequestGetGlobalBrandChildren requestRecipientField (boolean value) {
      this.requestField("recipient", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestRecordLabelField () {
      return this.requestRecordLabelField(true);
    }
    public APIRequestGetGlobalBrandChildren requestRecordLabelField (boolean value) {
      this.requestField("record_label", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestReleaseDateField () {
      return this.requestReleaseDateField(true);
    }
    public APIRequestGetGlobalBrandChildren requestReleaseDateField (boolean value) {
      this.requestField("release_date", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestRestaurantServicesField () {
      return this.requestRestaurantServicesField(true);
    }
    public APIRequestGetGlobalBrandChildren requestRestaurantServicesField (boolean value) {
      this.requestField("restaurant_services", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestRestaurantSpecialtiesField () {
      return this.requestRestaurantSpecialtiesField(true);
    }
    public APIRequestGetGlobalBrandChildren requestRestaurantSpecialtiesField (boolean value) {
      this.requestField("restaurant_specialties", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestScheduleField () {
      return this.requestScheduleField(true);
    }
    public APIRequestGetGlobalBrandChildren requestScheduleField (boolean value) {
      this.requestField("schedule", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestScreenplayByField () {
      return this.requestScreenplayByField(true);
    }
    public APIRequestGetGlobalBrandChildren requestScreenplayByField (boolean value) {
      this.requestField("screenplay_by", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestSeasonField () {
      return this.requestSeasonField(true);
    }
    public APIRequestGetGlobalBrandChildren requestSeasonField (boolean value) {
      this.requestField("season", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestSingleLineAddressField () {
      return this.requestSingleLineAddressField(true);
    }
    public APIRequestGetGlobalBrandChildren requestSingleLineAddressField (boolean value) {
      this.requestField("single_line_address", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestStarringField () {
      return this.requestStarringField(true);
    }
    public APIRequestGetGlobalBrandChildren requestStarringField (boolean value) {
      this.requestField("starring", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestStartInfoField () {
      return this.requestStartInfoField(true);
    }
    public APIRequestGetGlobalBrandChildren requestStartInfoField (boolean value) {
      this.requestField("start_info", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestStoreCodeField () {
      return this.requestStoreCodeField(true);
    }
    public APIRequestGetGlobalBrandChildren requestStoreCodeField (boolean value) {
      this.requestField("store_code", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestStoreLocationDescriptorField () {
      return this.requestStoreLocationDescriptorField(true);
    }
    public APIRequestGetGlobalBrandChildren requestStoreLocationDescriptorField (boolean value) {
      this.requestField("store_location_descriptor", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestStoreNumberField () {
      return this.requestStoreNumberField(true);
    }
    public APIRequestGetGlobalBrandChildren requestStoreNumberField (boolean value) {
      this.requestField("store_number", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestStudioField () {
      return this.requestStudioField(true);
    }
    public APIRequestGetGlobalBrandChildren requestStudioField (boolean value) {
      this.requestField("studio", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestSupportsInstantArticlesField () {
      return this.requestSupportsInstantArticlesField(true);
    }
    public APIRequestGetGlobalBrandChildren requestSupportsInstantArticlesField (boolean value) {
      this.requestField("supports_instant_articles", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestTalkingAboutCountField () {
      return this.requestTalkingAboutCountField(true);
    }
    public APIRequestGetGlobalBrandChildren requestTalkingAboutCountField (boolean value) {
      this.requestField("talking_about_count", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestUnreadMessageCountField () {
      return this.requestUnreadMessageCountField(true);
    }
    public APIRequestGetGlobalBrandChildren requestUnreadMessageCountField (boolean value) {
      this.requestField("unread_message_count", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestUnreadNotifCountField () {
      return this.requestUnreadNotifCountField(true);
    }
    public APIRequestGetGlobalBrandChildren requestUnreadNotifCountField (boolean value) {
      this.requestField("unread_notif_count", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestUnseenMessageCountField () {
      return this.requestUnseenMessageCountField(true);
    }
    public APIRequestGetGlobalBrandChildren requestUnseenMessageCountField (boolean value) {
      this.requestField("unseen_message_count", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestUsernameField () {
      return this.requestUsernameField(true);
    }
    public APIRequestGetGlobalBrandChildren requestUsernameField (boolean value) {
      this.requestField("username", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestVerificationStatusField () {
      return this.requestVerificationStatusField(true);
    }
    public APIRequestGetGlobalBrandChildren requestVerificationStatusField (boolean value) {
      this.requestField("verification_status", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestVoipInfoField () {
      return this.requestVoipInfoField(true);
    }
    public APIRequestGetGlobalBrandChildren requestVoipInfoField (boolean value) {
      this.requestField("voip_info", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestWebsiteField () {
      return this.requestWebsiteField(true);
    }
    public APIRequestGetGlobalBrandChildren requestWebsiteField (boolean value) {
      this.requestField("website", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestWereHereCountField () {
      return this.requestWereHereCountField(true);
    }
    public APIRequestGetGlobalBrandChildren requestWereHereCountField (boolean value) {
      this.requestField("were_here_count", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestWhatsappNumberField () {
      return this.requestWhatsappNumberField(true);
    }
    public APIRequestGetGlobalBrandChildren requestWhatsappNumberField (boolean value) {
      this.requestField("whatsapp_number", value);
      return this;
    }
    public APIRequestGetGlobalBrandChildren requestWrittenByField () {
      return this.requestWrittenByField(true);
    }
    public APIRequestGetGlobalBrandChildren requestWrittenByField (boolean value) {
      this.requestField("written_by", value);
      return this;
    }
  }

  public static class APIRequestGetIndexedVideoCopyrights extends APIRequest<VideoCopyright> {

    APINodeList<VideoCopyright> lastResponse = null;
    @Override
    public APINodeList<VideoCopyright> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "content_category",
      "copyright_content_id",
      "creator",
      "id",
      "in_conflict",
      "monitoring_status",
      "monitoring_type",
      "ownership_countries",
      "reference_file",
      "reference_file_disabled",
      "reference_file_disabled_by_ops",
      "reference_file_expired",
      "reference_owner_id",
      "rule_ids",
      "whitelisted_ids",
    };

    @Override
    public APINodeList<VideoCopyright> parseResponse(String response) throws APIException {
      return VideoCopyright.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<VideoCopyright> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<VideoCopyright> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<VideoCopyright>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<VideoCopyright>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<VideoCopyright>>() {
           public APINodeList<VideoCopyright> apply(String result) {
             try {
               return APIRequestGetIndexedVideoCopyrights.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetIndexedVideoCopyrights(String nodeId, APIContext context) {
      super(context, nodeId, "/indexed_video_copyrights", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetIndexedVideoCopyrights setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetIndexedVideoCopyrights setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetIndexedVideoCopyrights requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetIndexedVideoCopyrights requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetIndexedVideoCopyrights requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetIndexedVideoCopyrights requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetIndexedVideoCopyrights requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetIndexedVideoCopyrights requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetIndexedVideoCopyrights requestContentCategoryField () {
      return this.requestContentCategoryField(true);
    }
    public APIRequestGetIndexedVideoCopyrights requestContentCategoryField (boolean value) {
      this.requestField("content_category", value);
      return this;
    }
    public APIRequestGetIndexedVideoCopyrights requestCopyrightContentIdField () {
      return this.requestCopyrightContentIdField(true);
    }
    public APIRequestGetIndexedVideoCopyrights requestCopyrightContentIdField (boolean value) {
      this.requestField("copyright_content_id", value);
      return this;
    }
    public APIRequestGetIndexedVideoCopyrights requestCreatorField () {
      return this.requestCreatorField(true);
    }
    public APIRequestGetIndexedVideoCopyrights requestCreatorField (boolean value) {
      this.requestField("creator", value);
      return this;
    }
    public APIRequestGetIndexedVideoCopyrights requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetIndexedVideoCopyrights requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetIndexedVideoCopyrights requestInConflictField () {
      return this.requestInConflictField(true);
    }
    public APIRequestGetIndexedVideoCopyrights requestInConflictField (boolean value) {
      this.requestField("in_conflict", value);
      return this;
    }
    public APIRequestGetIndexedVideoCopyrights requestMonitoringStatusField () {
      return this.requestMonitoringStatusField(true);
    }
    public APIRequestGetIndexedVideoCopyrights requestMonitoringStatusField (boolean value) {
      this.requestField("monitoring_status", value);
      return this;
    }
    public APIRequestGetIndexedVideoCopyrights requestMonitoringTypeField () {
      return this.requestMonitoringTypeField(true);
    }
    public APIRequestGetIndexedVideoCopyrights requestMonitoringTypeField (boolean value) {
      this.requestField("monitoring_type", value);
      return this;
    }
    public APIRequestGetIndexedVideoCopyrights requestOwnershipCountriesField () {
      return this.requestOwnershipCountriesField(true);
    }
    public APIRequestGetIndexedVideoCopyrights requestOwnershipCountriesField (boolean value) {
      this.requestField("ownership_countries", value);
      return this;
    }
    public APIRequestGetIndexedVideoCopyrights requestReferenceFileField () {
      return this.requestReferenceFileField(true);
    }
    public APIRequestGetIndexedVideoCopyrights requestReferenceFileField (boolean value) {
      this.requestField("reference_file", value);
      return this;
    }
    public APIRequestGetIndexedVideoCopyrights requestReferenceFileDisabledField () {
      return this.requestReferenceFileDisabledField(true);
    }
    public APIRequestGetIndexedVideoCopyrights requestReferenceFileDisabledField (boolean value) {
      this.requestField("reference_file_disabled", value);
      return this;
    }
    public APIRequestGetIndexedVideoCopyrights requestReferenceFileDisabledByOpsField () {
      return this.requestReferenceFileDisabledByOpsField(true);
    }
    public APIRequestGetIndexedVideoCopyrights requestReferenceFileDisabledByOpsField (boolean value) {
      this.requestField("reference_file_disabled_by_ops", value);
      return this;
    }
    public APIRequestGetIndexedVideoCopyrights requestReferenceFileExpiredField () {
      return this.requestReferenceFileExpiredField(true);
    }
    public APIRequestGetIndexedVideoCopyrights requestReferenceFileExpiredField (boolean value) {
      this.requestField("reference_file_expired", value);
      return this;
    }
    public APIRequestGetIndexedVideoCopyrights requestReferenceOwnerIdField () {
      return this.requestReferenceOwnerIdField(true);
    }
    public APIRequestGetIndexedVideoCopyrights requestReferenceOwnerIdField (boolean value) {
      this.requestField("reference_owner_id", value);
      return this;
    }
    public APIRequestGetIndexedVideoCopyrights requestRuleIdsField () {
      return this.requestRuleIdsField(true);
    }
    public APIRequestGetIndexedVideoCopyrights requestRuleIdsField (boolean value) {
      this.requestField("rule_ids", value);
      return this;
    }
    public APIRequestGetIndexedVideoCopyrights requestWhitelistedIdsField () {
      return this.requestWhitelistedIdsField(true);
    }
    public APIRequestGetIndexedVideoCopyrights requestWhitelistedIdsField (boolean value) {
      this.requestField("whitelisted_ids", value);
      return this;
    }
  }

  public static class APIRequestGetIndexedVideos extends APIRequest<AdVideo> {

    APINodeList<AdVideo> lastResponse = null;
    @Override
    public APINodeList<AdVideo> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "ad_breaks",
      "backdated_time",
      "backdated_time_granularity",
      "content_category",
      "content_tags",
      "created_time",
      "custom_labels",
      "description",
      "embed_html",
      "embeddable",
      "event",
      "expiration",
      "format",
      "from",
      "icon",
      "id",
      "is_crosspost_video",
      "is_crossposting_eligible",
      "is_episode",
      "is_instagram_eligible",
      "length",
      "live_audience_count",
      "live_status",
      "name",
      "permalink_url",
      "picture",
      "place",
      "privacy",
      "published",
      "scheduled_publish_time",
      "source",
      "spherical",
      "status",
      "title",
      "tv_banner_ad",
      "universal_video_id",
      "updated_time",
    };

    @Override
    public APINodeList<AdVideo> parseResponse(String response) throws APIException {
      return AdVideo.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<AdVideo> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<AdVideo> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<AdVideo>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<AdVideo>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<AdVideo>>() {
           public APINodeList<AdVideo> apply(String result) {
             try {
               return APIRequestGetIndexedVideos.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetIndexedVideos(String nodeId, APIContext context) {
      super(context, nodeId, "/indexed_videos", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetIndexedVideos setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetIndexedVideos setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetIndexedVideos requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetIndexedVideos requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetIndexedVideos requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetIndexedVideos requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetIndexedVideos requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetIndexedVideos requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetIndexedVideos requestAdBreaksField () {
      return this.requestAdBreaksField(true);
    }
    public APIRequestGetIndexedVideos requestAdBreaksField (boolean value) {
      this.requestField("ad_breaks", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestBackdatedTimeField () {
      return this.requestBackdatedTimeField(true);
    }
    public APIRequestGetIndexedVideos requestBackdatedTimeField (boolean value) {
      this.requestField("backdated_time", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestBackdatedTimeGranularityField () {
      return this.requestBackdatedTimeGranularityField(true);
    }
    public APIRequestGetIndexedVideos requestBackdatedTimeGranularityField (boolean value) {
      this.requestField("backdated_time_granularity", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestContentCategoryField () {
      return this.requestContentCategoryField(true);
    }
    public APIRequestGetIndexedVideos requestContentCategoryField (boolean value) {
      this.requestField("content_category", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestContentTagsField () {
      return this.requestContentTagsField(true);
    }
    public APIRequestGetIndexedVideos requestContentTagsField (boolean value) {
      this.requestField("content_tags", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestCreatedTimeField () {
      return this.requestCreatedTimeField(true);
    }
    public APIRequestGetIndexedVideos requestCreatedTimeField (boolean value) {
      this.requestField("created_time", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestCustomLabelsField () {
      return this.requestCustomLabelsField(true);
    }
    public APIRequestGetIndexedVideos requestCustomLabelsField (boolean value) {
      this.requestField("custom_labels", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetIndexedVideos requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestEmbedHtmlField () {
      return this.requestEmbedHtmlField(true);
    }
    public APIRequestGetIndexedVideos requestEmbedHtmlField (boolean value) {
      this.requestField("embed_html", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestEmbeddableField () {
      return this.requestEmbeddableField(true);
    }
    public APIRequestGetIndexedVideos requestEmbeddableField (boolean value) {
      this.requestField("embeddable", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestEventField () {
      return this.requestEventField(true);
    }
    public APIRequestGetIndexedVideos requestEventField (boolean value) {
      this.requestField("event", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestExpirationField () {
      return this.requestExpirationField(true);
    }
    public APIRequestGetIndexedVideos requestExpirationField (boolean value) {
      this.requestField("expiration", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestFormatField () {
      return this.requestFormatField(true);
    }
    public APIRequestGetIndexedVideos requestFormatField (boolean value) {
      this.requestField("format", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestFromField () {
      return this.requestFromField(true);
    }
    public APIRequestGetIndexedVideos requestFromField (boolean value) {
      this.requestField("from", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestIconField () {
      return this.requestIconField(true);
    }
    public APIRequestGetIndexedVideos requestIconField (boolean value) {
      this.requestField("icon", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetIndexedVideos requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestIsCrosspostVideoField () {
      return this.requestIsCrosspostVideoField(true);
    }
    public APIRequestGetIndexedVideos requestIsCrosspostVideoField (boolean value) {
      this.requestField("is_crosspost_video", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestIsCrosspostingEligibleField () {
      return this.requestIsCrosspostingEligibleField(true);
    }
    public APIRequestGetIndexedVideos requestIsCrosspostingEligibleField (boolean value) {
      this.requestField("is_crossposting_eligible", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestIsEpisodeField () {
      return this.requestIsEpisodeField(true);
    }
    public APIRequestGetIndexedVideos requestIsEpisodeField (boolean value) {
      this.requestField("is_episode", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestIsInstagramEligibleField () {
      return this.requestIsInstagramEligibleField(true);
    }
    public APIRequestGetIndexedVideos requestIsInstagramEligibleField (boolean value) {
      this.requestField("is_instagram_eligible", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestLengthField () {
      return this.requestLengthField(true);
    }
    public APIRequestGetIndexedVideos requestLengthField (boolean value) {
      this.requestField("length", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestLiveAudienceCountField () {
      return this.requestLiveAudienceCountField(true);
    }
    public APIRequestGetIndexedVideos requestLiveAudienceCountField (boolean value) {
      this.requestField("live_audience_count", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestLiveStatusField () {
      return this.requestLiveStatusField(true);
    }
    public APIRequestGetIndexedVideos requestLiveStatusField (boolean value) {
      this.requestField("live_status", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetIndexedVideos requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestPermalinkUrlField () {
      return this.requestPermalinkUrlField(true);
    }
    public APIRequestGetIndexedVideos requestPermalinkUrlField (boolean value) {
      this.requestField("permalink_url", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestPictureField () {
      return this.requestPictureField(true);
    }
    public APIRequestGetIndexedVideos requestPictureField (boolean value) {
      this.requestField("picture", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestPlaceField () {
      return this.requestPlaceField(true);
    }
    public APIRequestGetIndexedVideos requestPlaceField (boolean value) {
      this.requestField("place", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestPrivacyField () {
      return this.requestPrivacyField(true);
    }
    public APIRequestGetIndexedVideos requestPrivacyField (boolean value) {
      this.requestField("privacy", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestPublishedField () {
      return this.requestPublishedField(true);
    }
    public APIRequestGetIndexedVideos requestPublishedField (boolean value) {
      this.requestField("published", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestScheduledPublishTimeField () {
      return this.requestScheduledPublishTimeField(true);
    }
    public APIRequestGetIndexedVideos requestScheduledPublishTimeField (boolean value) {
      this.requestField("scheduled_publish_time", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestSourceField () {
      return this.requestSourceField(true);
    }
    public APIRequestGetIndexedVideos requestSourceField (boolean value) {
      this.requestField("source", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestSphericalField () {
      return this.requestSphericalField(true);
    }
    public APIRequestGetIndexedVideos requestSphericalField (boolean value) {
      this.requestField("spherical", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestStatusField () {
      return this.requestStatusField(true);
    }
    public APIRequestGetIndexedVideos requestStatusField (boolean value) {
      this.requestField("status", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestTitleField () {
      return this.requestTitleField(true);
    }
    public APIRequestGetIndexedVideos requestTitleField (boolean value) {
      this.requestField("title", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestTvBannerAdField () {
      return this.requestTvBannerAdField(true);
    }
    public APIRequestGetIndexedVideos requestTvBannerAdField (boolean value) {
      this.requestField("tv_banner_ad", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestUniversalVideoIdField () {
      return this.requestUniversalVideoIdField(true);
    }
    public APIRequestGetIndexedVideos requestUniversalVideoIdField (boolean value) {
      this.requestField("universal_video_id", value);
      return this;
    }
    public APIRequestGetIndexedVideos requestUpdatedTimeField () {
      return this.requestUpdatedTimeField(true);
    }
    public APIRequestGetIndexedVideos requestUpdatedTimeField (boolean value) {
      this.requestField("updated_time", value);
      return this;
    }
  }

  public static class APIRequestGetInsights extends APIRequest<InsightsResult> {

    APINodeList<InsightsResult> lastResponse = null;
    @Override
    public APINodeList<InsightsResult> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "since",
      "until",
      "metric",
      "period",
      "show_description_from_api_doc",
      "date_preset",
    };

    public static final String[] FIELDS = {
      "description",
      "description_from_api_doc",
      "id",
      "name",
      "period",
      "title",
      "values",
    };

    @Override
    public APINodeList<InsightsResult> parseResponse(String response) throws APIException {
      return InsightsResult.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<InsightsResult> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<InsightsResult> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<InsightsResult>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<InsightsResult>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<InsightsResult>>() {
           public APINodeList<InsightsResult> apply(String result) {
             try {
               return APIRequestGetInsights.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetInsights(String nodeId, APIContext context) {
      super(context, nodeId, "/insights", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetInsights setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetInsights setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetInsights setSince (String since) {
      this.setParam("since", since);
      return this;
    }

    public APIRequestGetInsights setUntil (String until) {
      this.setParam("until", until);
      return this;
    }

    public APIRequestGetInsights setMetric (List<Object> metric) {
      this.setParam("metric", metric);
      return this;
    }
    public APIRequestGetInsights setMetric (String metric) {
      this.setParam("metric", metric);
      return this;
    }

    public APIRequestGetInsights setPeriod (InsightsResult.EnumPeriod period) {
      this.setParam("period", period);
      return this;
    }
    public APIRequestGetInsights setPeriod (String period) {
      this.setParam("period", period);
      return this;
    }

    public APIRequestGetInsights setShowDescriptionFromApiDoc (Boolean showDescriptionFromApiDoc) {
      this.setParam("show_description_from_api_doc", showDescriptionFromApiDoc);
      return this;
    }
    public APIRequestGetInsights setShowDescriptionFromApiDoc (String showDescriptionFromApiDoc) {
      this.setParam("show_description_from_api_doc", showDescriptionFromApiDoc);
      return this;
    }

    public APIRequestGetInsights setDatePreset (InsightsResult.EnumDatePreset datePreset) {
      this.setParam("date_preset", datePreset);
      return this;
    }
    public APIRequestGetInsights setDatePreset (String datePreset) {
      this.setParam("date_preset", datePreset);
      return this;
    }

    public APIRequestGetInsights requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetInsights requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetInsights requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetInsights requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetInsights requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetInsights requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetInsights requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetInsights requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetInsights requestDescriptionFromApiDocField () {
      return this.requestDescriptionFromApiDocField(true);
    }
    public APIRequestGetInsights requestDescriptionFromApiDocField (boolean value) {
      this.requestField("description_from_api_doc", value);
      return this;
    }
    public APIRequestGetInsights requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetInsights requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetInsights requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetInsights requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetInsights requestPeriodField () {
      return this.requestPeriodField(true);
    }
    public APIRequestGetInsights requestPeriodField (boolean value) {
      this.requestField("period", value);
      return this;
    }
    public APIRequestGetInsights requestTitleField () {
      return this.requestTitleField(true);
    }
    public APIRequestGetInsights requestTitleField (boolean value) {
      this.requestField("title", value);
      return this;
    }
    public APIRequestGetInsights requestValuesField () {
      return this.requestValuesField(true);
    }
    public APIRequestGetInsights requestValuesField (boolean value) {
      this.requestField("values", value);
      return this;
    }
  }

  public static class APIRequestGetInsightsExports extends APIRequest<PageInsightsAsyncExportRun> {

    APINodeList<PageInsightsAsyncExportRun> lastResponse = null;
    @Override
    public APINodeList<PageInsightsAsyncExportRun> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "data_level",
      "from_creation_date",
    };

    public static final String[] FIELDS = {
      "data_level",
      "filters",
      "format",
      "gen_report_date",
      "id",
      "report_end_date",
      "report_start_date",
      "sorters",
      "status",
    };

    @Override
    public APINodeList<PageInsightsAsyncExportRun> parseResponse(String response) throws APIException {
      return PageInsightsAsyncExportRun.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<PageInsightsAsyncExportRun> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<PageInsightsAsyncExportRun> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<PageInsightsAsyncExportRun>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<PageInsightsAsyncExportRun>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<PageInsightsAsyncExportRun>>() {
           public APINodeList<PageInsightsAsyncExportRun> apply(String result) {
             try {
               return APIRequestGetInsightsExports.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetInsightsExports(String nodeId, APIContext context) {
      super(context, nodeId, "/insights_exports", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetInsightsExports setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetInsightsExports setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetInsightsExports setDataLevel (List<String> dataLevel) {
      this.setParam("data_level", dataLevel);
      return this;
    }
    public APIRequestGetInsightsExports setDataLevel (String dataLevel) {
      this.setParam("data_level", dataLevel);
      return this;
    }

    public APIRequestGetInsightsExports setFromCreationDate (String fromCreationDate) {
      this.setParam("from_creation_date", fromCreationDate);
      return this;
    }

    public APIRequestGetInsightsExports requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetInsightsExports requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetInsightsExports requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetInsightsExports requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetInsightsExports requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetInsightsExports requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetInsightsExports requestDataLevelField () {
      return this.requestDataLevelField(true);
    }
    public APIRequestGetInsightsExports requestDataLevelField (boolean value) {
      this.requestField("data_level", value);
      return this;
    }
    public APIRequestGetInsightsExports requestFiltersField () {
      return this.requestFiltersField(true);
    }
    public APIRequestGetInsightsExports requestFiltersField (boolean value) {
      this.requestField("filters", value);
      return this;
    }
    public APIRequestGetInsightsExports requestFormatField () {
      return this.requestFormatField(true);
    }
    public APIRequestGetInsightsExports requestFormatField (boolean value) {
      this.requestField("format", value);
      return this;
    }
    public APIRequestGetInsightsExports requestGenReportDateField () {
      return this.requestGenReportDateField(true);
    }
    public APIRequestGetInsightsExports requestGenReportDateField (boolean value) {
      this.requestField("gen_report_date", value);
      return this;
    }
    public APIRequestGetInsightsExports requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetInsightsExports requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetInsightsExports requestReportEndDateField () {
      return this.requestReportEndDateField(true);
    }
    public APIRequestGetInsightsExports requestReportEndDateField (boolean value) {
      this.requestField("report_end_date", value);
      return this;
    }
    public APIRequestGetInsightsExports requestReportStartDateField () {
      return this.requestReportStartDateField(true);
    }
    public APIRequestGetInsightsExports requestReportStartDateField (boolean value) {
      this.requestField("report_start_date", value);
      return this;
    }
    public APIRequestGetInsightsExports requestSortersField () {
      return this.requestSortersField(true);
    }
    public APIRequestGetInsightsExports requestSortersField (boolean value) {
      this.requestField("sorters", value);
      return this;
    }
    public APIRequestGetInsightsExports requestStatusField () {
      return this.requestStatusField(true);
    }
    public APIRequestGetInsightsExports requestStatusField (boolean value) {
      this.requestField("status", value);
      return this;
    }
  }

  public static class APIRequestGetInstantArticles extends APIRequest<InstantArticle> {

    APINodeList<InstantArticle> lastResponse = null;
    @Override
    public APINodeList<InstantArticle> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "development_mode",
    };

    public static final String[] FIELDS = {
      "canonical_url",
      "development_mode",
      "html_source",
      "id",
      "most_recent_import_status",
      "photos",
      "publish_status",
      "published",
      "videos",
    };

    @Override
    public APINodeList<InstantArticle> parseResponse(String response) throws APIException {
      return InstantArticle.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<InstantArticle> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<InstantArticle> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<InstantArticle>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<InstantArticle>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<InstantArticle>>() {
           public APINodeList<InstantArticle> apply(String result) {
             try {
               return APIRequestGetInstantArticles.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetInstantArticles(String nodeId, APIContext context) {
      super(context, nodeId, "/instant_articles", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetInstantArticles setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetInstantArticles setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetInstantArticles setDevelopmentMode (Boolean developmentMode) {
      this.setParam("development_mode", developmentMode);
      return this;
    }
    public APIRequestGetInstantArticles setDevelopmentMode (String developmentMode) {
      this.setParam("development_mode", developmentMode);
      return this;
    }

    public APIRequestGetInstantArticles requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetInstantArticles requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetInstantArticles requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetInstantArticles requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetInstantArticles requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetInstantArticles requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetInstantArticles requestCanonicalUrlField () {
      return this.requestCanonicalUrlField(true);
    }
    public APIRequestGetInstantArticles requestCanonicalUrlField (boolean value) {
      this.requestField("canonical_url", value);
      return this;
    }
    public APIRequestGetInstantArticles requestDevelopmentModeField () {
      return this.requestDevelopmentModeField(true);
    }
    public APIRequestGetInstantArticles requestDevelopmentModeField (boolean value) {
      this.requestField("development_mode", value);
      return this;
    }
    public APIRequestGetInstantArticles requestHtmlSourceField () {
      return this.requestHtmlSourceField(true);
    }
    public APIRequestGetInstantArticles requestHtmlSourceField (boolean value) {
      this.requestField("html_source", value);
      return this;
    }
    public APIRequestGetInstantArticles requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetInstantArticles requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetInstantArticles requestMostRecentImportStatusField () {
      return this.requestMostRecentImportStatusField(true);
    }
    public APIRequestGetInstantArticles requestMostRecentImportStatusField (boolean value) {
      this.requestField("most_recent_import_status", value);
      return this;
    }
    public APIRequestGetInstantArticles requestPhotosField () {
      return this.requestPhotosField(true);
    }
    public APIRequestGetInstantArticles requestPhotosField (boolean value) {
      this.requestField("photos", value);
      return this;
    }
    public APIRequestGetInstantArticles requestPublishStatusField () {
      return this.requestPublishStatusField(true);
    }
    public APIRequestGetInstantArticles requestPublishStatusField (boolean value) {
      this.requestField("publish_status", value);
      return this;
    }
    public APIRequestGetInstantArticles requestPublishedField () {
      return this.requestPublishedField(true);
    }
    public APIRequestGetInstantArticles requestPublishedField (boolean value) {
      this.requestField("published", value);
      return this;
    }
    public APIRequestGetInstantArticles requestVideosField () {
      return this.requestVideosField(true);
    }
    public APIRequestGetInstantArticles requestVideosField (boolean value) {
      this.requestField("videos", value);
      return this;
    }
  }

  public static class APIRequestCreateInstantArticle extends APIRequest<InstantArticle> {

    InstantArticle lastResponse = null;
    @Override
    public InstantArticle getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "html_source",
      "development_mode",
      "take_live",
      "published",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public InstantArticle parseResponse(String response) throws APIException {
      return InstantArticle.parseResponse(response, getContext(), this).head();
    }

    @Override
    public InstantArticle execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public InstantArticle execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<InstantArticle> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<InstantArticle> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, InstantArticle>() {
           public InstantArticle apply(String result) {
             try {
               return APIRequestCreateInstantArticle.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateInstantArticle(String nodeId, APIContext context) {
      super(context, nodeId, "/instant_articles", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateInstantArticle setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateInstantArticle setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateInstantArticle setHtmlSource (String htmlSource) {
      this.setParam("html_source", htmlSource);
      return this;
    }

    public APIRequestCreateInstantArticle setDevelopmentMode (Boolean developmentMode) {
      this.setParam("development_mode", developmentMode);
      return this;
    }
    public APIRequestCreateInstantArticle setDevelopmentMode (String developmentMode) {
      this.setParam("development_mode", developmentMode);
      return this;
    }

    public APIRequestCreateInstantArticle setTakeLive (Boolean takeLive) {
      this.setParam("take_live", takeLive);
      return this;
    }
    public APIRequestCreateInstantArticle setTakeLive (String takeLive) {
      this.setParam("take_live", takeLive);
      return this;
    }

    public APIRequestCreateInstantArticle setPublished (Boolean published) {
      this.setParam("published", published);
      return this;
    }
    public APIRequestCreateInstantArticle setPublished (String published) {
      this.setParam("published", published);
      return this;
    }

    public APIRequestCreateInstantArticle requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateInstantArticle requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateInstantArticle requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateInstantArticle requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateInstantArticle requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateInstantArticle requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetInstantArticlesInsights extends APIRequest<InstantArticleInsightsQueryResult> {

    APINodeList<InstantArticleInsightsQueryResult> lastResponse = null;
    @Override
    public APINodeList<InstantArticleInsightsQueryResult> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "metric",
      "period",
      "since",
      "until",
      "breakdown",
    };

    public static final String[] FIELDS = {
      "breakdowns",
      "name",
      "time",
      "value",
      "id",
    };

    @Override
    public APINodeList<InstantArticleInsightsQueryResult> parseResponse(String response) throws APIException {
      return InstantArticleInsightsQueryResult.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<InstantArticleInsightsQueryResult> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<InstantArticleInsightsQueryResult> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<InstantArticleInsightsQueryResult>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<InstantArticleInsightsQueryResult>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<InstantArticleInsightsQueryResult>>() {
           public APINodeList<InstantArticleInsightsQueryResult> apply(String result) {
             try {
               return APIRequestGetInstantArticlesInsights.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetInstantArticlesInsights(String nodeId, APIContext context) {
      super(context, nodeId, "/instant_articles_insights", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetInstantArticlesInsights setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetInstantArticlesInsights setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetInstantArticlesInsights setMetric (List<Object> metric) {
      this.setParam("metric", metric);
      return this;
    }
    public APIRequestGetInstantArticlesInsights setMetric (String metric) {
      this.setParam("metric", metric);
      return this;
    }

    public APIRequestGetInstantArticlesInsights setPeriod (InstantArticleInsightsQueryResult.EnumPeriod period) {
      this.setParam("period", period);
      return this;
    }
    public APIRequestGetInstantArticlesInsights setPeriod (String period) {
      this.setParam("period", period);
      return this;
    }

    public APIRequestGetInstantArticlesInsights setSince (String since) {
      this.setParam("since", since);
      return this;
    }

    public APIRequestGetInstantArticlesInsights setUntil (String until) {
      this.setParam("until", until);
      return this;
    }

    public APIRequestGetInstantArticlesInsights setBreakdown (InstantArticleInsightsQueryResult.EnumBreakdown breakdown) {
      this.setParam("breakdown", breakdown);
      return this;
    }
    public APIRequestGetInstantArticlesInsights setBreakdown (String breakdown) {
      this.setParam("breakdown", breakdown);
      return this;
    }

    public APIRequestGetInstantArticlesInsights requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetInstantArticlesInsights requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetInstantArticlesInsights requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetInstantArticlesInsights requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetInstantArticlesInsights requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetInstantArticlesInsights requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetInstantArticlesInsights requestBreakdownsField () {
      return this.requestBreakdownsField(true);
    }
    public APIRequestGetInstantArticlesInsights requestBreakdownsField (boolean value) {
      this.requestField("breakdowns", value);
      return this;
    }
    public APIRequestGetInstantArticlesInsights requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetInstantArticlesInsights requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetInstantArticlesInsights requestTimeField () {
      return this.requestTimeField(true);
    }
    public APIRequestGetInstantArticlesInsights requestTimeField (boolean value) {
      this.requestField("time", value);
      return this;
    }
    public APIRequestGetInstantArticlesInsights requestValueField () {
      return this.requestValueField(true);
    }
    public APIRequestGetInstantArticlesInsights requestValueField (boolean value) {
      this.requestField("value", value);
      return this;
    }
    public APIRequestGetInstantArticlesInsights requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetInstantArticlesInsights requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
  }

  public static class APIRequestCreateInstantArticlesPublish extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "canonical_url",
      "publish_status",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response) throws APIException {
      return Page.parseResponse(response, getContext(), this).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, Page>() {
           public Page apply(String result) {
             try {
               return APIRequestCreateInstantArticlesPublish.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateInstantArticlesPublish(String nodeId, APIContext context) {
      super(context, nodeId, "/instant_articles_publish", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateInstantArticlesPublish setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateInstantArticlesPublish setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateInstantArticlesPublish setCanonicalUrl (String canonicalUrl) {
      this.setParam("canonical_url", canonicalUrl);
      return this;
    }

    public APIRequestCreateInstantArticlesPublish setPublishStatus (Page.EnumPublishStatus publishStatus) {
      this.setParam("publish_status", publishStatus);
      return this;
    }
    public APIRequestCreateInstantArticlesPublish setPublishStatus (String publishStatus) {
      this.setParam("publish_status", publishStatus);
      return this;
    }

    public APIRequestCreateInstantArticlesPublish requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateInstantArticlesPublish requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateInstantArticlesPublish requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateInstantArticlesPublish requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateInstantArticlesPublish requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateInstantArticlesPublish requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetLabels extends APIRequest<PageLabel> {

    APINodeList<PageLabel> lastResponse = null;
    @Override
    public APINodeList<PageLabel> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "creation_time",
      "creator_id",
      "from",
      "id",
      "name",
    };

    @Override
    public APINodeList<PageLabel> parseResponse(String response) throws APIException {
      return PageLabel.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<PageLabel> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<PageLabel> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<PageLabel>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<PageLabel>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<PageLabel>>() {
           public APINodeList<PageLabel> apply(String result) {
             try {
               return APIRequestGetLabels.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetLabels(String nodeId, APIContext context) {
      super(context, nodeId, "/labels", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetLabels setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetLabels setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetLabels requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetLabels requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLabels requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetLabels requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLabels requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetLabels requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetLabels requestCreationTimeField () {
      return this.requestCreationTimeField(true);
    }
    public APIRequestGetLabels requestCreationTimeField (boolean value) {
      this.requestField("creation_time", value);
      return this;
    }
    public APIRequestGetLabels requestCreatorIdField () {
      return this.requestCreatorIdField(true);
    }
    public APIRequestGetLabels requestCreatorIdField (boolean value) {
      this.requestField("creator_id", value);
      return this;
    }
    public APIRequestGetLabels requestFromField () {
      return this.requestFromField(true);
    }
    public APIRequestGetLabels requestFromField (boolean value) {
      this.requestField("from", value);
      return this;
    }
    public APIRequestGetLabels requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetLabels requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetLabels requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetLabels requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
  }

  public static class APIRequestCreateLabel extends APIRequest<PageLabel> {

    PageLabel lastResponse = null;
    @Override
    public PageLabel getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "name",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public PageLabel parseResponse(String response) throws APIException {
      return PageLabel.parseResponse(response, getContext(), this).head();
    }

    @Override
    public PageLabel execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public PageLabel execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<PageLabel> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<PageLabel> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, PageLabel>() {
           public PageLabel apply(String result) {
             try {
               return APIRequestCreateLabel.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateLabel(String nodeId, APIContext context) {
      super(context, nodeId, "/labels", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateLabel setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateLabel setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateLabel setName (String name) {
      this.setParam("name", name);
      return this;
    }

    public APIRequestCreateLabel requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateLabel requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLabel requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateLabel requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLabel requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateLabel requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetLeadGenConditionalQuestionsGroup extends APIRequest<LeadGenConditionalQuestionsGroup> {

    APINodeList<LeadGenConditionalQuestionsGroup> lastResponse = null;
    @Override
    public APINodeList<LeadGenConditionalQuestionsGroup> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "choices",
      "questions",
      "id",
    };

    @Override
    public APINodeList<LeadGenConditionalQuestionsGroup> parseResponse(String response) throws APIException {
      return LeadGenConditionalQuestionsGroup.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<LeadGenConditionalQuestionsGroup> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<LeadGenConditionalQuestionsGroup> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<LeadGenConditionalQuestionsGroup>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<LeadGenConditionalQuestionsGroup>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<LeadGenConditionalQuestionsGroup>>() {
           public APINodeList<LeadGenConditionalQuestionsGroup> apply(String result) {
             try {
               return APIRequestGetLeadGenConditionalQuestionsGroup.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetLeadGenConditionalQuestionsGroup(String nodeId, APIContext context) {
      super(context, nodeId, "/leadgen_conditional_questions_group", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetLeadGenConditionalQuestionsGroup setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetLeadGenConditionalQuestionsGroup setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetLeadGenConditionalQuestionsGroup requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetLeadGenConditionalQuestionsGroup requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLeadGenConditionalQuestionsGroup requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetLeadGenConditionalQuestionsGroup requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLeadGenConditionalQuestionsGroup requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetLeadGenConditionalQuestionsGroup requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetLeadGenConditionalQuestionsGroup requestChoicesField () {
      return this.requestChoicesField(true);
    }
    public APIRequestGetLeadGenConditionalQuestionsGroup requestChoicesField (boolean value) {
      this.requestField("choices", value);
      return this;
    }
    public APIRequestGetLeadGenConditionalQuestionsGroup requestQuestionsField () {
      return this.requestQuestionsField(true);
    }
    public APIRequestGetLeadGenConditionalQuestionsGroup requestQuestionsField (boolean value) {
      this.requestField("questions", value);
      return this;
    }
    public APIRequestGetLeadGenConditionalQuestionsGroup requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetLeadGenConditionalQuestionsGroup requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
  }

  public static class APIRequestCreateLeadGenConditionalQuestionsGroup extends APIRequest<LeadGenConditionalQuestionsGroup> {

    LeadGenConditionalQuestionsGroup lastResponse = null;
    @Override
    public LeadGenConditionalQuestionsGroup getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "conditional_questions_group_csv",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public LeadGenConditionalQuestionsGroup parseResponse(String response) throws APIException {
      return LeadGenConditionalQuestionsGroup.parseResponse(response, getContext(), this).head();
    }

    @Override
    public LeadGenConditionalQuestionsGroup execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public LeadGenConditionalQuestionsGroup execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<LeadGenConditionalQuestionsGroup> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<LeadGenConditionalQuestionsGroup> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, LeadGenConditionalQuestionsGroup>() {
           public LeadGenConditionalQuestionsGroup apply(String result) {
             try {
               return APIRequestCreateLeadGenConditionalQuestionsGroup.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateLeadGenConditionalQuestionsGroup(String nodeId, APIContext context) {
      super(context, nodeId, "/leadgen_conditional_questions_group", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateLeadGenConditionalQuestionsGroup setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateLeadGenConditionalQuestionsGroup setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateLeadGenConditionalQuestionsGroup setConditionalQuestionsGroupCsv (File conditionalQuestionsGroupCsv) {
      this.setParam("conditional_questions_group_csv", conditionalQuestionsGroupCsv);
      return this;
    }
    public APIRequestCreateLeadGenConditionalQuestionsGroup setConditionalQuestionsGroupCsv (String conditionalQuestionsGroupCsv) {
      this.setParam("conditional_questions_group_csv", conditionalQuestionsGroupCsv);
      return this;
    }

    public APIRequestCreateLeadGenConditionalQuestionsGroup requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateLeadGenConditionalQuestionsGroup requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLeadGenConditionalQuestionsGroup requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateLeadGenConditionalQuestionsGroup requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLeadGenConditionalQuestionsGroup requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateLeadGenConditionalQuestionsGroup requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetLeadGenContextCards extends APIRequest<LeadGenContextCard> {

    APINodeList<LeadGenContextCard> lastResponse = null;
    @Override
    public APINodeList<LeadGenContextCard> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "button_text",
      "canvas",
      "canvas_jump_to_form_button_text",
      "content",
      "cover_photo",
      "format",
      "id",
      "style",
      "title",
    };

    @Override
    public APINodeList<LeadGenContextCard> parseResponse(String response) throws APIException {
      return LeadGenContextCard.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<LeadGenContextCard> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<LeadGenContextCard> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<LeadGenContextCard>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<LeadGenContextCard>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<LeadGenContextCard>>() {
           public APINodeList<LeadGenContextCard> apply(String result) {
             try {
               return APIRequestGetLeadGenContextCards.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetLeadGenContextCards(String nodeId, APIContext context) {
      super(context, nodeId, "/leadgen_context_cards", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetLeadGenContextCards setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetLeadGenContextCards setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetLeadGenContextCards requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetLeadGenContextCards requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLeadGenContextCards requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetLeadGenContextCards requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLeadGenContextCards requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetLeadGenContextCards requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetLeadGenContextCards requestButtonTextField () {
      return this.requestButtonTextField(true);
    }
    public APIRequestGetLeadGenContextCards requestButtonTextField (boolean value) {
      this.requestField("button_text", value);
      return this;
    }
    public APIRequestGetLeadGenContextCards requestCanvasField () {
      return this.requestCanvasField(true);
    }
    public APIRequestGetLeadGenContextCards requestCanvasField (boolean value) {
      this.requestField("canvas", value);
      return this;
    }
    public APIRequestGetLeadGenContextCards requestCanvasJumpToFormButtonTextField () {
      return this.requestCanvasJumpToFormButtonTextField(true);
    }
    public APIRequestGetLeadGenContextCards requestCanvasJumpToFormButtonTextField (boolean value) {
      this.requestField("canvas_jump_to_form_button_text", value);
      return this;
    }
    public APIRequestGetLeadGenContextCards requestContentField () {
      return this.requestContentField(true);
    }
    public APIRequestGetLeadGenContextCards requestContentField (boolean value) {
      this.requestField("content", value);
      return this;
    }
    public APIRequestGetLeadGenContextCards requestCoverPhotoField () {
      return this.requestCoverPhotoField(true);
    }
    public APIRequestGetLeadGenContextCards requestCoverPhotoField (boolean value) {
      this.requestField("cover_photo", value);
      return this;
    }
    public APIRequestGetLeadGenContextCards requestFormatField () {
      return this.requestFormatField(true);
    }
    public APIRequestGetLeadGenContextCards requestFormatField (boolean value) {
      this.requestField("format", value);
      return this;
    }
    public APIRequestGetLeadGenContextCards requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetLeadGenContextCards requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetLeadGenContextCards requestStyleField () {
      return this.requestStyleField(true);
    }
    public APIRequestGetLeadGenContextCards requestStyleField (boolean value) {
      this.requestField("style", value);
      return this;
    }
    public APIRequestGetLeadGenContextCards requestTitleField () {
      return this.requestTitleField(true);
    }
    public APIRequestGetLeadGenContextCards requestTitleField (boolean value) {
      this.requestField("title", value);
      return this;
    }
  }

  public static class APIRequestCreateLeadGenContextCard extends APIRequest<LeadGenContextCard> {

    LeadGenContextCard lastResponse = null;
    @Override
    public LeadGenContextCard getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "title",
      "style",
      "content",
      "button_text",
      "cover_photo",
      "cover_photo_id",
      "status",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public LeadGenContextCard parseResponse(String response) throws APIException {
      return LeadGenContextCard.parseResponse(response, getContext(), this).head();
    }

    @Override
    public LeadGenContextCard execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public LeadGenContextCard execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<LeadGenContextCard> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<LeadGenContextCard> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, LeadGenContextCard>() {
           public LeadGenContextCard apply(String result) {
             try {
               return APIRequestCreateLeadGenContextCard.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateLeadGenContextCard(String nodeId, APIContext context) {
      super(context, nodeId, "/leadgen_context_cards", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateLeadGenContextCard setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateLeadGenContextCard setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateLeadGenContextCard setTitle (String title) {
      this.setParam("title", title);
      return this;
    }

    public APIRequestCreateLeadGenContextCard setStyle (LeadGenContextCard.EnumStyle style) {
      this.setParam("style", style);
      return this;
    }
    public APIRequestCreateLeadGenContextCard setStyle (String style) {
      this.setParam("style", style);
      return this;
    }

    public APIRequestCreateLeadGenContextCard setContent (List<String> content) {
      this.setParam("content", content);
      return this;
    }
    public APIRequestCreateLeadGenContextCard setContent (String content) {
      this.setParam("content", content);
      return this;
    }

    public APIRequestCreateLeadGenContextCard setButtonText (String buttonText) {
      this.setParam("button_text", buttonText);
      return this;
    }

    public APIRequestCreateLeadGenContextCard setCoverPhoto (File coverPhoto) {
      this.setParam("cover_photo", coverPhoto);
      return this;
    }
    public APIRequestCreateLeadGenContextCard setCoverPhoto (String coverPhoto) {
      this.setParam("cover_photo", coverPhoto);
      return this;
    }

    public APIRequestCreateLeadGenContextCard setCoverPhotoId (String coverPhotoId) {
      this.setParam("cover_photo_id", coverPhotoId);
      return this;
    }

    public APIRequestCreateLeadGenContextCard setStatus (LeadGenContextCard.EnumStatus status) {
      this.setParam("status", status);
      return this;
    }
    public APIRequestCreateLeadGenContextCard setStatus (String status) {
      this.setParam("status", status);
      return this;
    }

    public APIRequestCreateLeadGenContextCard requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateLeadGenContextCard requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLeadGenContextCard requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateLeadGenContextCard requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLeadGenContextCard requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateLeadGenContextCard requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetLeadGenDraftForms extends APIRequest<LeadGenDataDraft> {

    APINodeList<LeadGenDataDraft> lastResponse = null;
    @Override
    public APINodeList<LeadGenDataDraft> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "block_display_for_non_targeted_viewer",
      "context_card",
      "created_time",
      "creator_id",
      "follow_up_action_url",
      "id",
      "is_optimized_for_quality",
      "legal_content",
      "locale",
      "name",
      "page",
      "question_page_custom_headline",
      "questions",
      "status",
      "thank_you_page",
      "tracking_parameters",
    };

    @Override
    public APINodeList<LeadGenDataDraft> parseResponse(String response) throws APIException {
      return LeadGenDataDraft.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<LeadGenDataDraft> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<LeadGenDataDraft> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<LeadGenDataDraft>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<LeadGenDataDraft>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<LeadGenDataDraft>>() {
           public APINodeList<LeadGenDataDraft> apply(String result) {
             try {
               return APIRequestGetLeadGenDraftForms.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetLeadGenDraftForms(String nodeId, APIContext context) {
      super(context, nodeId, "/leadgen_draft_forms", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetLeadGenDraftForms setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetLeadGenDraftForms setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetLeadGenDraftForms requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetLeadGenDraftForms requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLeadGenDraftForms requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetLeadGenDraftForms requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLeadGenDraftForms requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetLeadGenDraftForms requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetLeadGenDraftForms requestBlockDisplayForNonTargetedViewerField () {
      return this.requestBlockDisplayForNonTargetedViewerField(true);
    }
    public APIRequestGetLeadGenDraftForms requestBlockDisplayForNonTargetedViewerField (boolean value) {
      this.requestField("block_display_for_non_targeted_viewer", value);
      return this;
    }
    public APIRequestGetLeadGenDraftForms requestContextCardField () {
      return this.requestContextCardField(true);
    }
    public APIRequestGetLeadGenDraftForms requestContextCardField (boolean value) {
      this.requestField("context_card", value);
      return this;
    }
    public APIRequestGetLeadGenDraftForms requestCreatedTimeField () {
      return this.requestCreatedTimeField(true);
    }
    public APIRequestGetLeadGenDraftForms requestCreatedTimeField (boolean value) {
      this.requestField("created_time", value);
      return this;
    }
    public APIRequestGetLeadGenDraftForms requestCreatorIdField () {
      return this.requestCreatorIdField(true);
    }
    public APIRequestGetLeadGenDraftForms requestCreatorIdField (boolean value) {
      this.requestField("creator_id", value);
      return this;
    }
    public APIRequestGetLeadGenDraftForms requestFollowUpActionUrlField () {
      return this.requestFollowUpActionUrlField(true);
    }
    public APIRequestGetLeadGenDraftForms requestFollowUpActionUrlField (boolean value) {
      this.requestField("follow_up_action_url", value);
      return this;
    }
    public APIRequestGetLeadGenDraftForms requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetLeadGenDraftForms requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetLeadGenDraftForms requestIsOptimizedForQualityField () {
      return this.requestIsOptimizedForQualityField(true);
    }
    public APIRequestGetLeadGenDraftForms requestIsOptimizedForQualityField (boolean value) {
      this.requestField("is_optimized_for_quality", value);
      return this;
    }
    public APIRequestGetLeadGenDraftForms requestLegalContentField () {
      return this.requestLegalContentField(true);
    }
    public APIRequestGetLeadGenDraftForms requestLegalContentField (boolean value) {
      this.requestField("legal_content", value);
      return this;
    }
    public APIRequestGetLeadGenDraftForms requestLocaleField () {
      return this.requestLocaleField(true);
    }
    public APIRequestGetLeadGenDraftForms requestLocaleField (boolean value) {
      this.requestField("locale", value);
      return this;
    }
    public APIRequestGetLeadGenDraftForms requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetLeadGenDraftForms requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetLeadGenDraftForms requestPageField () {
      return this.requestPageField(true);
    }
    public APIRequestGetLeadGenDraftForms requestPageField (boolean value) {
      this.requestField("page", value);
      return this;
    }
    public APIRequestGetLeadGenDraftForms requestQuestionPageCustomHeadlineField () {
      return this.requestQuestionPageCustomHeadlineField(true);
    }
    public APIRequestGetLeadGenDraftForms requestQuestionPageCustomHeadlineField (boolean value) {
      this.requestField("question_page_custom_headline", value);
      return this;
    }
    public APIRequestGetLeadGenDraftForms requestQuestionsField () {
      return this.requestQuestionsField(true);
    }
    public APIRequestGetLeadGenDraftForms requestQuestionsField (boolean value) {
      this.requestField("questions", value);
      return this;
    }
    public APIRequestGetLeadGenDraftForms requestStatusField () {
      return this.requestStatusField(true);
    }
    public APIRequestGetLeadGenDraftForms requestStatusField (boolean value) {
      this.requestField("status", value);
      return this;
    }
    public APIRequestGetLeadGenDraftForms requestThankYouPageField () {
      return this.requestThankYouPageField(true);
    }
    public APIRequestGetLeadGenDraftForms requestThankYouPageField (boolean value) {
      this.requestField("thank_you_page", value);
      return this;
    }
    public APIRequestGetLeadGenDraftForms requestTrackingParametersField () {
      return this.requestTrackingParametersField(true);
    }
    public APIRequestGetLeadGenDraftForms requestTrackingParametersField (boolean value) {
      this.requestField("tracking_parameters", value);
      return this;
    }
  }

  public static class APIRequestCreateLeadGenDraftForm extends APIRequest<LeadGenDataDraft> {

    LeadGenDataDraft lastResponse = null;
    @Override
    public LeadGenDataDraft getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "name",
      "locale",
      "block_display_for_non_targeted_viewer",
      "follow_up_action_url",
      "legal_content_id",
      "context_card_id",
      "questions",
      "privacy_policy",
      "custom_disclaimer",
      "context_card",
      "thank_you_page",
      "tracking_parameters",
      "question_page_custom_headline",
      "is_optimized_for_quality",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public LeadGenDataDraft parseResponse(String response) throws APIException {
      return LeadGenDataDraft.parseResponse(response, getContext(), this).head();
    }

    @Override
    public LeadGenDataDraft execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public LeadGenDataDraft execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<LeadGenDataDraft> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<LeadGenDataDraft> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, LeadGenDataDraft>() {
           public LeadGenDataDraft apply(String result) {
             try {
               return APIRequestCreateLeadGenDraftForm.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateLeadGenDraftForm(String nodeId, APIContext context) {
      super(context, nodeId, "/leadgen_draft_forms", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateLeadGenDraftForm setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateLeadGenDraftForm setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateLeadGenDraftForm setName (String name) {
      this.setParam("name", name);
      return this;
    }

    public APIRequestCreateLeadGenDraftForm setLocale (LeadGenDataDraft.EnumLocale locale) {
      this.setParam("locale", locale);
      return this;
    }
    public APIRequestCreateLeadGenDraftForm setLocale (String locale) {
      this.setParam("locale", locale);
      return this;
    }

    public APIRequestCreateLeadGenDraftForm setBlockDisplayForNonTargetedViewer (Boolean blockDisplayForNonTargetedViewer) {
      this.setParam("block_display_for_non_targeted_viewer", blockDisplayForNonTargetedViewer);
      return this;
    }
    public APIRequestCreateLeadGenDraftForm setBlockDisplayForNonTargetedViewer (String blockDisplayForNonTargetedViewer) {
      this.setParam("block_display_for_non_targeted_viewer", blockDisplayForNonTargetedViewer);
      return this;
    }

    public APIRequestCreateLeadGenDraftForm setFollowUpActionUrl (String followUpActionUrl) {
      this.setParam("follow_up_action_url", followUpActionUrl);
      return this;
    }

    public APIRequestCreateLeadGenDraftForm setLegalContentId (String legalContentId) {
      this.setParam("legal_content_id", legalContentId);
      return this;
    }

    public APIRequestCreateLeadGenDraftForm setContextCardId (String contextCardId) {
      this.setParam("context_card_id", contextCardId);
      return this;
    }

    public APIRequestCreateLeadGenDraftForm setQuestions (List<Object> questions) {
      this.setParam("questions", questions);
      return this;
    }
    public APIRequestCreateLeadGenDraftForm setQuestions (String questions) {
      this.setParam("questions", questions);
      return this;
    }

    public APIRequestCreateLeadGenDraftForm setPrivacyPolicy (Map<String, String> privacyPolicy) {
      this.setParam("privacy_policy", privacyPolicy);
      return this;
    }
    public APIRequestCreateLeadGenDraftForm setPrivacyPolicy (String privacyPolicy) {
      this.setParam("privacy_policy", privacyPolicy);
      return this;
    }

    public APIRequestCreateLeadGenDraftForm setCustomDisclaimer (Object customDisclaimer) {
      this.setParam("custom_disclaimer", customDisclaimer);
      return this;
    }
    public APIRequestCreateLeadGenDraftForm setCustomDisclaimer (String customDisclaimer) {
      this.setParam("custom_disclaimer", customDisclaimer);
      return this;
    }

    public APIRequestCreateLeadGenDraftForm setContextCard (Object contextCard) {
      this.setParam("context_card", contextCard);
      return this;
    }
    public APIRequestCreateLeadGenDraftForm setContextCard (String contextCard) {
      this.setParam("context_card", contextCard);
      return this;
    }

    public APIRequestCreateLeadGenDraftForm setThankYouPage (Map<String, String> thankYouPage) {
      this.setParam("thank_you_page", thankYouPage);
      return this;
    }
    public APIRequestCreateLeadGenDraftForm setThankYouPage (String thankYouPage) {
      this.setParam("thank_you_page", thankYouPage);
      return this;
    }

    public APIRequestCreateLeadGenDraftForm setTrackingParameters (Object trackingParameters) {
      this.setParam("tracking_parameters", trackingParameters);
      return this;
    }
    public APIRequestCreateLeadGenDraftForm setTrackingParameters (String trackingParameters) {
      this.setParam("tracking_parameters", trackingParameters);
      return this;
    }

    public APIRequestCreateLeadGenDraftForm setQuestionPageCustomHeadline (String questionPageCustomHeadline) {
      this.setParam("question_page_custom_headline", questionPageCustomHeadline);
      return this;
    }

    public APIRequestCreateLeadGenDraftForm setIsOptimizedForQuality (Boolean isOptimizedForQuality) {
      this.setParam("is_optimized_for_quality", isOptimizedForQuality);
      return this;
    }
    public APIRequestCreateLeadGenDraftForm setIsOptimizedForQuality (String isOptimizedForQuality) {
      this.setParam("is_optimized_for_quality", isOptimizedForQuality);
      return this;
    }

    public APIRequestCreateLeadGenDraftForm requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateLeadGenDraftForm requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLeadGenDraftForm requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateLeadGenDraftForm requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLeadGenDraftForm requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateLeadGenDraftForm requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetLeadGenForms extends APIRequest<LeadgenForm> {

    APINodeList<LeadgenForm> lastResponse = null;
    @Override
    public APINodeList<LeadgenForm> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "allow_organic_lead",
      "block_display_for_non_targeted_viewer",
      "context_card",
      "created_time",
      "creator",
      "creator_id",
      "cusomized_tcpa_content",
      "expired_leads_count",
      "extra_details",
      "follow_up_action_text",
      "follow_up_action_url",
      "id",
      "is_optimized_for_quality",
      "leadgen_export_csv_url",
      "leads_count",
      "legal_content",
      "locale",
      "messenger_welcome_message",
      "name",
      "organic_leads_count",
      "page",
      "page_id",
      "privacy_policy_url",
      "qualifiers",
      "question_page_custom_headline",
      "questions",
      "status",
      "tcpa_compliance",
      "thank_you_page",
      "tracking_parameters",
    };

    @Override
    public APINodeList<LeadgenForm> parseResponse(String response) throws APIException {
      return LeadgenForm.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<LeadgenForm> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<LeadgenForm> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<LeadgenForm>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<LeadgenForm>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<LeadgenForm>>() {
           public APINodeList<LeadgenForm> apply(String result) {
             try {
               return APIRequestGetLeadGenForms.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetLeadGenForms(String nodeId, APIContext context) {
      super(context, nodeId, "/leadgen_forms", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetLeadGenForms setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetLeadGenForms setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetLeadGenForms requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetLeadGenForms requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLeadGenForms requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetLeadGenForms requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLeadGenForms requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetLeadGenForms requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetLeadGenForms requestAllowOrganicLeadField () {
      return this.requestAllowOrganicLeadField(true);
    }
    public APIRequestGetLeadGenForms requestAllowOrganicLeadField (boolean value) {
      this.requestField("allow_organic_lead", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestBlockDisplayForNonTargetedViewerField () {
      return this.requestBlockDisplayForNonTargetedViewerField(true);
    }
    public APIRequestGetLeadGenForms requestBlockDisplayForNonTargetedViewerField (boolean value) {
      this.requestField("block_display_for_non_targeted_viewer", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestContextCardField () {
      return this.requestContextCardField(true);
    }
    public APIRequestGetLeadGenForms requestContextCardField (boolean value) {
      this.requestField("context_card", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestCreatedTimeField () {
      return this.requestCreatedTimeField(true);
    }
    public APIRequestGetLeadGenForms requestCreatedTimeField (boolean value) {
      this.requestField("created_time", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestCreatorField () {
      return this.requestCreatorField(true);
    }
    public APIRequestGetLeadGenForms requestCreatorField (boolean value) {
      this.requestField("creator", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestCreatorIdField () {
      return this.requestCreatorIdField(true);
    }
    public APIRequestGetLeadGenForms requestCreatorIdField (boolean value) {
      this.requestField("creator_id", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestCusomizedTcpaContentField () {
      return this.requestCusomizedTcpaContentField(true);
    }
    public APIRequestGetLeadGenForms requestCusomizedTcpaContentField (boolean value) {
      this.requestField("cusomized_tcpa_content", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestExpiredLeadsCountField () {
      return this.requestExpiredLeadsCountField(true);
    }
    public APIRequestGetLeadGenForms requestExpiredLeadsCountField (boolean value) {
      this.requestField("expired_leads_count", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestExtraDetailsField () {
      return this.requestExtraDetailsField(true);
    }
    public APIRequestGetLeadGenForms requestExtraDetailsField (boolean value) {
      this.requestField("extra_details", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestFollowUpActionTextField () {
      return this.requestFollowUpActionTextField(true);
    }
    public APIRequestGetLeadGenForms requestFollowUpActionTextField (boolean value) {
      this.requestField("follow_up_action_text", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestFollowUpActionUrlField () {
      return this.requestFollowUpActionUrlField(true);
    }
    public APIRequestGetLeadGenForms requestFollowUpActionUrlField (boolean value) {
      this.requestField("follow_up_action_url", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetLeadGenForms requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestIsOptimizedForQualityField () {
      return this.requestIsOptimizedForQualityField(true);
    }
    public APIRequestGetLeadGenForms requestIsOptimizedForQualityField (boolean value) {
      this.requestField("is_optimized_for_quality", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestLeadgenExportCsvUrlField () {
      return this.requestLeadgenExportCsvUrlField(true);
    }
    public APIRequestGetLeadGenForms requestLeadgenExportCsvUrlField (boolean value) {
      this.requestField("leadgen_export_csv_url", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestLeadsCountField () {
      return this.requestLeadsCountField(true);
    }
    public APIRequestGetLeadGenForms requestLeadsCountField (boolean value) {
      this.requestField("leads_count", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestLegalContentField () {
      return this.requestLegalContentField(true);
    }
    public APIRequestGetLeadGenForms requestLegalContentField (boolean value) {
      this.requestField("legal_content", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestLocaleField () {
      return this.requestLocaleField(true);
    }
    public APIRequestGetLeadGenForms requestLocaleField (boolean value) {
      this.requestField("locale", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestMessengerWelcomeMessageField () {
      return this.requestMessengerWelcomeMessageField(true);
    }
    public APIRequestGetLeadGenForms requestMessengerWelcomeMessageField (boolean value) {
      this.requestField("messenger_welcome_message", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetLeadGenForms requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestOrganicLeadsCountField () {
      return this.requestOrganicLeadsCountField(true);
    }
    public APIRequestGetLeadGenForms requestOrganicLeadsCountField (boolean value) {
      this.requestField("organic_leads_count", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestPageField () {
      return this.requestPageField(true);
    }
    public APIRequestGetLeadGenForms requestPageField (boolean value) {
      this.requestField("page", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestPageIdField () {
      return this.requestPageIdField(true);
    }
    public APIRequestGetLeadGenForms requestPageIdField (boolean value) {
      this.requestField("page_id", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestPrivacyPolicyUrlField () {
      return this.requestPrivacyPolicyUrlField(true);
    }
    public APIRequestGetLeadGenForms requestPrivacyPolicyUrlField (boolean value) {
      this.requestField("privacy_policy_url", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestQualifiersField () {
      return this.requestQualifiersField(true);
    }
    public APIRequestGetLeadGenForms requestQualifiersField (boolean value) {
      this.requestField("qualifiers", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestQuestionPageCustomHeadlineField () {
      return this.requestQuestionPageCustomHeadlineField(true);
    }
    public APIRequestGetLeadGenForms requestQuestionPageCustomHeadlineField (boolean value) {
      this.requestField("question_page_custom_headline", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestQuestionsField () {
      return this.requestQuestionsField(true);
    }
    public APIRequestGetLeadGenForms requestQuestionsField (boolean value) {
      this.requestField("questions", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestStatusField () {
      return this.requestStatusField(true);
    }
    public APIRequestGetLeadGenForms requestStatusField (boolean value) {
      this.requestField("status", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestTcpaComplianceField () {
      return this.requestTcpaComplianceField(true);
    }
    public APIRequestGetLeadGenForms requestTcpaComplianceField (boolean value) {
      this.requestField("tcpa_compliance", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestThankYouPageField () {
      return this.requestThankYouPageField(true);
    }
    public APIRequestGetLeadGenForms requestThankYouPageField (boolean value) {
      this.requestField("thank_you_page", value);
      return this;
    }
    public APIRequestGetLeadGenForms requestTrackingParametersField () {
      return this.requestTrackingParametersField(true);
    }
    public APIRequestGetLeadGenForms requestTrackingParametersField (boolean value) {
      this.requestField("tracking_parameters", value);
      return this;
    }
  }

  public static class APIRequestCreateLeadGenForm extends APIRequest<LeadgenForm> {

    LeadgenForm lastResponse = null;
    @Override
    public LeadgenForm getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "name",
      "locale",
      "allow_organic_lead_retrieval",
      "block_display_for_non_targeted_viewer",
      "follow_up_action_url",
      "legal_content_id",
      "context_card_id",
      "thank_you_page_id",
      "questions",
      "privacy_policy",
      "custom_disclaimer",
      "context_card",
      "thank_you_page",
      "tracking_parameters",
      "cover_photo",
      "question_page_custom_headline",
      "is_optimized_for_quality",
      "is_for_canvas",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public LeadgenForm parseResponse(String response) throws APIException {
      return LeadgenForm.parseResponse(response, getContext(), this).head();
    }

    @Override
    public LeadgenForm execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public LeadgenForm execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<LeadgenForm> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<LeadgenForm> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, LeadgenForm>() {
           public LeadgenForm apply(String result) {
             try {
               return APIRequestCreateLeadGenForm.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateLeadGenForm(String nodeId, APIContext context) {
      super(context, nodeId, "/leadgen_forms", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateLeadGenForm setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateLeadGenForm setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateLeadGenForm setName (String name) {
      this.setParam("name", name);
      return this;
    }

    public APIRequestCreateLeadGenForm setLocale (LeadgenForm.EnumLocale locale) {
      this.setParam("locale", locale);
      return this;
    }
    public APIRequestCreateLeadGenForm setLocale (String locale) {
      this.setParam("locale", locale);
      return this;
    }

    public APIRequestCreateLeadGenForm setAllowOrganicLeadRetrieval (Boolean allowOrganicLeadRetrieval) {
      this.setParam("allow_organic_lead_retrieval", allowOrganicLeadRetrieval);
      return this;
    }
    public APIRequestCreateLeadGenForm setAllowOrganicLeadRetrieval (String allowOrganicLeadRetrieval) {
      this.setParam("allow_organic_lead_retrieval", allowOrganicLeadRetrieval);
      return this;
    }

    public APIRequestCreateLeadGenForm setBlockDisplayForNonTargetedViewer (Boolean blockDisplayForNonTargetedViewer) {
      this.setParam("block_display_for_non_targeted_viewer", blockDisplayForNonTargetedViewer);
      return this;
    }
    public APIRequestCreateLeadGenForm setBlockDisplayForNonTargetedViewer (String blockDisplayForNonTargetedViewer) {
      this.setParam("block_display_for_non_targeted_viewer", blockDisplayForNonTargetedViewer);
      return this;
    }

    public APIRequestCreateLeadGenForm setFollowUpActionUrl (Object followUpActionUrl) {
      this.setParam("follow_up_action_url", followUpActionUrl);
      return this;
    }
    public APIRequestCreateLeadGenForm setFollowUpActionUrl (String followUpActionUrl) {
      this.setParam("follow_up_action_url", followUpActionUrl);
      return this;
    }

    public APIRequestCreateLeadGenForm setLegalContentId (Object legalContentId) {
      this.setParam("legal_content_id", legalContentId);
      return this;
    }
    public APIRequestCreateLeadGenForm setLegalContentId (String legalContentId) {
      this.setParam("legal_content_id", legalContentId);
      return this;
    }

    public APIRequestCreateLeadGenForm setContextCardId (Object contextCardId) {
      this.setParam("context_card_id", contextCardId);
      return this;
    }
    public APIRequestCreateLeadGenForm setContextCardId (String contextCardId) {
      this.setParam("context_card_id", contextCardId);
      return this;
    }

    public APIRequestCreateLeadGenForm setThankYouPageId (Object thankYouPageId) {
      this.setParam("thank_you_page_id", thankYouPageId);
      return this;
    }
    public APIRequestCreateLeadGenForm setThankYouPageId (String thankYouPageId) {
      this.setParam("thank_you_page_id", thankYouPageId);
      return this;
    }

    public APIRequestCreateLeadGenForm setQuestions (List<Object> questions) {
      this.setParam("questions", questions);
      return this;
    }
    public APIRequestCreateLeadGenForm setQuestions (String questions) {
      this.setParam("questions", questions);
      return this;
    }

    public APIRequestCreateLeadGenForm setPrivacyPolicy (Object privacyPolicy) {
      this.setParam("privacy_policy", privacyPolicy);
      return this;
    }
    public APIRequestCreateLeadGenForm setPrivacyPolicy (String privacyPolicy) {
      this.setParam("privacy_policy", privacyPolicy);
      return this;
    }

    public APIRequestCreateLeadGenForm setCustomDisclaimer (Object customDisclaimer) {
      this.setParam("custom_disclaimer", customDisclaimer);
      return this;
    }
    public APIRequestCreateLeadGenForm setCustomDisclaimer (String customDisclaimer) {
      this.setParam("custom_disclaimer", customDisclaimer);
      return this;
    }

    public APIRequestCreateLeadGenForm setContextCard (Object contextCard) {
      this.setParam("context_card", contextCard);
      return this;
    }
    public APIRequestCreateLeadGenForm setContextCard (String contextCard) {
      this.setParam("context_card", contextCard);
      return this;
    }

    public APIRequestCreateLeadGenForm setThankYouPage (Object thankYouPage) {
      this.setParam("thank_you_page", thankYouPage);
      return this;
    }
    public APIRequestCreateLeadGenForm setThankYouPage (String thankYouPage) {
      this.setParam("thank_you_page", thankYouPage);
      return this;
    }

    public APIRequestCreateLeadGenForm setTrackingParameters (Object trackingParameters) {
      this.setParam("tracking_parameters", trackingParameters);
      return this;
    }
    public APIRequestCreateLeadGenForm setTrackingParameters (String trackingParameters) {
      this.setParam("tracking_parameters", trackingParameters);
      return this;
    }

    public APIRequestCreateLeadGenForm setCoverPhoto (File coverPhoto) {
      this.setParam("cover_photo", coverPhoto);
      return this;
    }
    public APIRequestCreateLeadGenForm setCoverPhoto (String coverPhoto) {
      this.setParam("cover_photo", coverPhoto);
      return this;
    }

    public APIRequestCreateLeadGenForm setQuestionPageCustomHeadline (String questionPageCustomHeadline) {
      this.setParam("question_page_custom_headline", questionPageCustomHeadline);
      return this;
    }

    public APIRequestCreateLeadGenForm setIsOptimizedForQuality (Boolean isOptimizedForQuality) {
      this.setParam("is_optimized_for_quality", isOptimizedForQuality);
      return this;
    }
    public APIRequestCreateLeadGenForm setIsOptimizedForQuality (String isOptimizedForQuality) {
      this.setParam("is_optimized_for_quality", isOptimizedForQuality);
      return this;
    }

    public APIRequestCreateLeadGenForm setIsForCanvas (Boolean isForCanvas) {
      this.setParam("is_for_canvas", isForCanvas);
      return this;
    }
    public APIRequestCreateLeadGenForm setIsForCanvas (String isForCanvas) {
      this.setParam("is_for_canvas", isForCanvas);
      return this;
    }

    public APIRequestCreateLeadGenForm requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateLeadGenForm requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLeadGenForm requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateLeadGenForm requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLeadGenForm requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateLeadGenForm requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetLeadGenLegalContent extends APIRequest<LeadGenLegalContent> {

    APINodeList<LeadGenLegalContent> lastResponse = null;
    @Override
    public APINodeList<LeadGenLegalContent> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "custom_disclaimer",
      "id",
      "privacy_policy",
    };

    @Override
    public APINodeList<LeadGenLegalContent> parseResponse(String response) throws APIException {
      return LeadGenLegalContent.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<LeadGenLegalContent> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<LeadGenLegalContent> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<LeadGenLegalContent>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<LeadGenLegalContent>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<LeadGenLegalContent>>() {
           public APINodeList<LeadGenLegalContent> apply(String result) {
             try {
               return APIRequestGetLeadGenLegalContent.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetLeadGenLegalContent(String nodeId, APIContext context) {
      super(context, nodeId, "/leadgen_legal_content", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetLeadGenLegalContent setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetLeadGenLegalContent setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetLeadGenLegalContent requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetLeadGenLegalContent requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLeadGenLegalContent requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetLeadGenLegalContent requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLeadGenLegalContent requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetLeadGenLegalContent requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetLeadGenLegalContent requestCustomDisclaimerField () {
      return this.requestCustomDisclaimerField(true);
    }
    public APIRequestGetLeadGenLegalContent requestCustomDisclaimerField (boolean value) {
      this.requestField("custom_disclaimer", value);
      return this;
    }
    public APIRequestGetLeadGenLegalContent requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetLeadGenLegalContent requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetLeadGenLegalContent requestPrivacyPolicyField () {
      return this.requestPrivacyPolicyField(true);
    }
    public APIRequestGetLeadGenLegalContent requestPrivacyPolicyField (boolean value) {
      this.requestField("privacy_policy", value);
      return this;
    }
  }

  public static class APIRequestCreateLeadGenLegalContent extends APIRequest<LeadGenLegalContent> {

    LeadGenLegalContent lastResponse = null;
    @Override
    public LeadGenLegalContent getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "privacy_policy",
      "custom_disclaimer",
      "status",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public LeadGenLegalContent parseResponse(String response) throws APIException {
      return LeadGenLegalContent.parseResponse(response, getContext(), this).head();
    }

    @Override
    public LeadGenLegalContent execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public LeadGenLegalContent execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<LeadGenLegalContent> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<LeadGenLegalContent> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, LeadGenLegalContent>() {
           public LeadGenLegalContent apply(String result) {
             try {
               return APIRequestCreateLeadGenLegalContent.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateLeadGenLegalContent(String nodeId, APIContext context) {
      super(context, nodeId, "/leadgen_legal_content", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateLeadGenLegalContent setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateLeadGenLegalContent setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateLeadGenLegalContent setPrivacyPolicy (Object privacyPolicy) {
      this.setParam("privacy_policy", privacyPolicy);
      return this;
    }
    public APIRequestCreateLeadGenLegalContent setPrivacyPolicy (String privacyPolicy) {
      this.setParam("privacy_policy", privacyPolicy);
      return this;
    }

    public APIRequestCreateLeadGenLegalContent setCustomDisclaimer (Object customDisclaimer) {
      this.setParam("custom_disclaimer", customDisclaimer);
      return this;
    }
    public APIRequestCreateLeadGenLegalContent setCustomDisclaimer (String customDisclaimer) {
      this.setParam("custom_disclaimer", customDisclaimer);
      return this;
    }

    public APIRequestCreateLeadGenLegalContent setStatus (LeadGenLegalContent.EnumStatus status) {
      this.setParam("status", status);
      return this;
    }
    public APIRequestCreateLeadGenLegalContent setStatus (String status) {
      this.setParam("status", status);
      return this;
    }

    public APIRequestCreateLeadGenLegalContent requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateLeadGenLegalContent requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLeadGenLegalContent requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateLeadGenLegalContent requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLeadGenLegalContent requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateLeadGenLegalContent requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetLeadGenQualifiers extends APIRequest<LeadGenQualifier> {

    APINodeList<LeadGenQualifier> lastResponse = null;
    @Override
    public APINodeList<LeadGenQualifier> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "category",
      "field_key",
      "id",
      "label",
      "question",
    };

    @Override
    public APINodeList<LeadGenQualifier> parseResponse(String response) throws APIException {
      return LeadGenQualifier.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<LeadGenQualifier> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<LeadGenQualifier> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<LeadGenQualifier>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<LeadGenQualifier>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<LeadGenQualifier>>() {
           public APINodeList<LeadGenQualifier> apply(String result) {
             try {
               return APIRequestGetLeadGenQualifiers.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetLeadGenQualifiers(String nodeId, APIContext context) {
      super(context, nodeId, "/leadgen_qualifiers", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetLeadGenQualifiers setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetLeadGenQualifiers setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetLeadGenQualifiers requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetLeadGenQualifiers requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLeadGenQualifiers requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetLeadGenQualifiers requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLeadGenQualifiers requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetLeadGenQualifiers requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetLeadGenQualifiers requestCategoryField () {
      return this.requestCategoryField(true);
    }
    public APIRequestGetLeadGenQualifiers requestCategoryField (boolean value) {
      this.requestField("category", value);
      return this;
    }
    public APIRequestGetLeadGenQualifiers requestFieldKeyField () {
      return this.requestFieldKeyField(true);
    }
    public APIRequestGetLeadGenQualifiers requestFieldKeyField (boolean value) {
      this.requestField("field_key", value);
      return this;
    }
    public APIRequestGetLeadGenQualifiers requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetLeadGenQualifiers requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetLeadGenQualifiers requestLabelField () {
      return this.requestLabelField(true);
    }
    public APIRequestGetLeadGenQualifiers requestLabelField (boolean value) {
      this.requestField("label", value);
      return this;
    }
    public APIRequestGetLeadGenQualifiers requestQuestionField () {
      return this.requestQuestionField(true);
    }
    public APIRequestGetLeadGenQualifiers requestQuestionField (boolean value) {
      this.requestField("question", value);
      return this;
    }
  }

  public static class APIRequestCreateLeadGenThankYouPage extends APIRequest<APINode> {

    APINode lastResponse = null;
    @Override
    public APINode getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "body",
      "business_phone_number",
      "button_text",
      "button_type",
      "country_code",
      "enable_messenger",
      "title",
      "website_url",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINode parseResponse(String response) throws APIException {
      return APINode.parseResponse(response, getContext(), this).head();
    }

    @Override
    public APINode execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINode execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINode> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINode>() {
           public APINode apply(String result) {
             try {
               return APIRequestCreateLeadGenThankYouPage.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateLeadGenThankYouPage(String nodeId, APIContext context) {
      super(context, nodeId, "/leadgen_thank_you_page", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateLeadGenThankYouPage setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateLeadGenThankYouPage setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateLeadGenThankYouPage setBody (String body) {
      this.setParam("body", body);
      return this;
    }

    public APIRequestCreateLeadGenThankYouPage setBusinessPhoneNumber (String businessPhoneNumber) {
      this.setParam("business_phone_number", businessPhoneNumber);
      return this;
    }

    public APIRequestCreateLeadGenThankYouPage setButtonText (String buttonText) {
      this.setParam("button_text", buttonText);
      return this;
    }

    public APIRequestCreateLeadGenThankYouPage setButtonType (EnumButtonType buttonType) {
      this.setParam("button_type", buttonType);
      return this;
    }
    public APIRequestCreateLeadGenThankYouPage setButtonType (String buttonType) {
      this.setParam("button_type", buttonType);
      return this;
    }

    public APIRequestCreateLeadGenThankYouPage setCountryCode (String countryCode) {
      this.setParam("country_code", countryCode);
      return this;
    }

    public APIRequestCreateLeadGenThankYouPage setEnableMessenger (Boolean enableMessenger) {
      this.setParam("enable_messenger", enableMessenger);
      return this;
    }
    public APIRequestCreateLeadGenThankYouPage setEnableMessenger (String enableMessenger) {
      this.setParam("enable_messenger", enableMessenger);
      return this;
    }

    public APIRequestCreateLeadGenThankYouPage setTitle (String title) {
      this.setParam("title", title);
      return this;
    }

    public APIRequestCreateLeadGenThankYouPage setWebsiteUrl (String websiteUrl) {
      this.setParam("website_url", websiteUrl);
      return this;
    }

    public APIRequestCreateLeadGenThankYouPage requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateLeadGenThankYouPage requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLeadGenThankYouPage requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateLeadGenThankYouPage requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLeadGenThankYouPage requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateLeadGenThankYouPage requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestDeleteLeadGenWhitelistedUsers extends APIRequest<APINode> {

    APINodeList<APINode> lastResponse = null;
    @Override
    public APINodeList<APINode> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "user_id",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINodeList<APINode> parseResponse(String response) throws APIException {
      return APINode.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<APINode> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<APINode>>() {
           public APINodeList<APINode> apply(String result) {
             try {
               return APIRequestDeleteLeadGenWhitelistedUsers.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestDeleteLeadGenWhitelistedUsers(String nodeId, APIContext context) {
      super(context, nodeId, "/leadgen_whitelisted_users", "DELETE", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestDeleteLeadGenWhitelistedUsers setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestDeleteLeadGenWhitelistedUsers setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestDeleteLeadGenWhitelistedUsers setUserId (String userId) {
      this.setParam("user_id", userId);
      return this;
    }

    public APIRequestDeleteLeadGenWhitelistedUsers requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestDeleteLeadGenWhitelistedUsers requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteLeadGenWhitelistedUsers requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestDeleteLeadGenWhitelistedUsers requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteLeadGenWhitelistedUsers requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestDeleteLeadGenWhitelistedUsers requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetLeadGenWhitelistedUsers extends APIRequest<User> {

    APINodeList<User> lastResponse = null;
    @Override
    public APINodeList<User> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "about",
      "address",
      "admin_notes",
      "age_range",
      "bio",
      "birthday",
      "can_review_measurement_request",
      "context",
      "cover",
      "currency",
      "devices",
      "education",
      "email",
      "employee_number",
      "favorite_athletes",
      "favorite_teams",
      "first_name",
      "gender",
      "hometown",
      "id",
      "inspirational_people",
      "install_type",
      "installed",
      "interested_in",
      "is_famedeeplinkinguser",
      "is_shared_login",
      "is_verified",
      "labels",
      "languages",
      "last_name",
      "link",
      "local_news_megaphone_dismiss_status",
      "local_news_subscription_status",
      "locale",
      "location",
      "meeting_for",
      "middle_name",
      "name",
      "name_format",
      "payment_pricepoints",
      "political",
      "profile_pic",
      "public_key",
      "quotes",
      "relationship_status",
      "religion",
      "security_settings",
      "shared_login_upgrade_required_by",
      "short_name",
      "significant_other",
      "sports",
      "test_group",
      "third_party_id",
      "timezone",
      "token_for_business",
      "updated_time",
      "username",
      "verified",
      "video_upload_limits",
      "viewer_can_send_gift",
      "website",
      "work",
    };

    @Override
    public APINodeList<User> parseResponse(String response) throws APIException {
      return User.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<User> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<User> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<User>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<User>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<User>>() {
           public APINodeList<User> apply(String result) {
             try {
               return APIRequestGetLeadGenWhitelistedUsers.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetLeadGenWhitelistedUsers(String nodeId, APIContext context) {
      super(context, nodeId, "/leadgen_whitelisted_users", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetLeadGenWhitelistedUsers setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetLeadGenWhitelistedUsers setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetLeadGenWhitelistedUsers requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetLeadGenWhitelistedUsers requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLeadGenWhitelistedUsers requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetLeadGenWhitelistedUsers requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLeadGenWhitelistedUsers requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetLeadGenWhitelistedUsers requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetLeadGenWhitelistedUsers requestAboutField () {
      return this.requestAboutField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestAboutField (boolean value) {
      this.requestField("about", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestAddressField () {
      return this.requestAddressField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestAddressField (boolean value) {
      this.requestField("address", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestAdminNotesField () {
      return this.requestAdminNotesField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestAdminNotesField (boolean value) {
      this.requestField("admin_notes", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestAgeRangeField () {
      return this.requestAgeRangeField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestAgeRangeField (boolean value) {
      this.requestField("age_range", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestBioField () {
      return this.requestBioField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestBioField (boolean value) {
      this.requestField("bio", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestBirthdayField () {
      return this.requestBirthdayField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestBirthdayField (boolean value) {
      this.requestField("birthday", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestCanReviewMeasurementRequestField () {
      return this.requestCanReviewMeasurementRequestField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestCanReviewMeasurementRequestField (boolean value) {
      this.requestField("can_review_measurement_request", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestContextField () {
      return this.requestContextField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestContextField (boolean value) {
      this.requestField("context", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestCoverField () {
      return this.requestCoverField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestCoverField (boolean value) {
      this.requestField("cover", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestCurrencyField () {
      return this.requestCurrencyField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestCurrencyField (boolean value) {
      this.requestField("currency", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestDevicesField () {
      return this.requestDevicesField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestDevicesField (boolean value) {
      this.requestField("devices", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestEducationField () {
      return this.requestEducationField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestEducationField (boolean value) {
      this.requestField("education", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestEmailField () {
      return this.requestEmailField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestEmailField (boolean value) {
      this.requestField("email", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestEmployeeNumberField () {
      return this.requestEmployeeNumberField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestEmployeeNumberField (boolean value) {
      this.requestField("employee_number", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestFavoriteAthletesField () {
      return this.requestFavoriteAthletesField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestFavoriteAthletesField (boolean value) {
      this.requestField("favorite_athletes", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestFavoriteTeamsField () {
      return this.requestFavoriteTeamsField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestFavoriteTeamsField (boolean value) {
      this.requestField("favorite_teams", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestFirstNameField () {
      return this.requestFirstNameField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestFirstNameField (boolean value) {
      this.requestField("first_name", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestGenderField () {
      return this.requestGenderField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestGenderField (boolean value) {
      this.requestField("gender", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestHometownField () {
      return this.requestHometownField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestHometownField (boolean value) {
      this.requestField("hometown", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestInspirationalPeopleField () {
      return this.requestInspirationalPeopleField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestInspirationalPeopleField (boolean value) {
      this.requestField("inspirational_people", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestInstallTypeField () {
      return this.requestInstallTypeField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestInstallTypeField (boolean value) {
      this.requestField("install_type", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestInstalledField () {
      return this.requestInstalledField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestInstalledField (boolean value) {
      this.requestField("installed", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestInterestedInField () {
      return this.requestInterestedInField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestInterestedInField (boolean value) {
      this.requestField("interested_in", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestIsFamedeeplinkinguserField () {
      return this.requestIsFamedeeplinkinguserField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestIsFamedeeplinkinguserField (boolean value) {
      this.requestField("is_famedeeplinkinguser", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestIsSharedLoginField () {
      return this.requestIsSharedLoginField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestIsSharedLoginField (boolean value) {
      this.requestField("is_shared_login", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestIsVerifiedField () {
      return this.requestIsVerifiedField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestIsVerifiedField (boolean value) {
      this.requestField("is_verified", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestLabelsField () {
      return this.requestLabelsField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestLabelsField (boolean value) {
      this.requestField("labels", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestLanguagesField () {
      return this.requestLanguagesField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestLanguagesField (boolean value) {
      this.requestField("languages", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestLastNameField () {
      return this.requestLastNameField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestLastNameField (boolean value) {
      this.requestField("last_name", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestLinkField () {
      return this.requestLinkField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestLinkField (boolean value) {
      this.requestField("link", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestLocalNewsMegaphoneDismissStatusField () {
      return this.requestLocalNewsMegaphoneDismissStatusField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestLocalNewsMegaphoneDismissStatusField (boolean value) {
      this.requestField("local_news_megaphone_dismiss_status", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestLocalNewsSubscriptionStatusField () {
      return this.requestLocalNewsSubscriptionStatusField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestLocalNewsSubscriptionStatusField (boolean value) {
      this.requestField("local_news_subscription_status", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestLocaleField () {
      return this.requestLocaleField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestLocaleField (boolean value) {
      this.requestField("locale", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestLocationField () {
      return this.requestLocationField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestLocationField (boolean value) {
      this.requestField("location", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestMeetingForField () {
      return this.requestMeetingForField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestMeetingForField (boolean value) {
      this.requestField("meeting_for", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestMiddleNameField () {
      return this.requestMiddleNameField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestMiddleNameField (boolean value) {
      this.requestField("middle_name", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestNameFormatField () {
      return this.requestNameFormatField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestNameFormatField (boolean value) {
      this.requestField("name_format", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestPaymentPricepointsField () {
      return this.requestPaymentPricepointsField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestPaymentPricepointsField (boolean value) {
      this.requestField("payment_pricepoints", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestPoliticalField () {
      return this.requestPoliticalField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestPoliticalField (boolean value) {
      this.requestField("political", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestProfilePicField () {
      return this.requestProfilePicField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestProfilePicField (boolean value) {
      this.requestField("profile_pic", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestPublicKeyField () {
      return this.requestPublicKeyField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestPublicKeyField (boolean value) {
      this.requestField("public_key", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestQuotesField () {
      return this.requestQuotesField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestQuotesField (boolean value) {
      this.requestField("quotes", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestRelationshipStatusField () {
      return this.requestRelationshipStatusField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestRelationshipStatusField (boolean value) {
      this.requestField("relationship_status", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestReligionField () {
      return this.requestReligionField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestReligionField (boolean value) {
      this.requestField("religion", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestSecuritySettingsField () {
      return this.requestSecuritySettingsField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestSecuritySettingsField (boolean value) {
      this.requestField("security_settings", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestSharedLoginUpgradeRequiredByField () {
      return this.requestSharedLoginUpgradeRequiredByField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestSharedLoginUpgradeRequiredByField (boolean value) {
      this.requestField("shared_login_upgrade_required_by", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestShortNameField () {
      return this.requestShortNameField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestShortNameField (boolean value) {
      this.requestField("short_name", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestSignificantOtherField () {
      return this.requestSignificantOtherField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestSignificantOtherField (boolean value) {
      this.requestField("significant_other", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestSportsField () {
      return this.requestSportsField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestSportsField (boolean value) {
      this.requestField("sports", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestTestGroupField () {
      return this.requestTestGroupField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestTestGroupField (boolean value) {
      this.requestField("test_group", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestThirdPartyIdField () {
      return this.requestThirdPartyIdField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestThirdPartyIdField (boolean value) {
      this.requestField("third_party_id", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestTimezoneField () {
      return this.requestTimezoneField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestTimezoneField (boolean value) {
      this.requestField("timezone", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestTokenForBusinessField () {
      return this.requestTokenForBusinessField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestTokenForBusinessField (boolean value) {
      this.requestField("token_for_business", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestUpdatedTimeField () {
      return this.requestUpdatedTimeField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestUpdatedTimeField (boolean value) {
      this.requestField("updated_time", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestUsernameField () {
      return this.requestUsernameField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestUsernameField (boolean value) {
      this.requestField("username", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestVerifiedField () {
      return this.requestVerifiedField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestVerifiedField (boolean value) {
      this.requestField("verified", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestVideoUploadLimitsField () {
      return this.requestVideoUploadLimitsField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestVideoUploadLimitsField (boolean value) {
      this.requestField("video_upload_limits", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestViewerCanSendGiftField () {
      return this.requestViewerCanSendGiftField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestViewerCanSendGiftField (boolean value) {
      this.requestField("viewer_can_send_gift", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestWebsiteField () {
      return this.requestWebsiteField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestWebsiteField (boolean value) {
      this.requestField("website", value);
      return this;
    }
    public APIRequestGetLeadGenWhitelistedUsers requestWorkField () {
      return this.requestWorkField(true);
    }
    public APIRequestGetLeadGenWhitelistedUsers requestWorkField (boolean value) {
      this.requestField("work", value);
      return this;
    }
  }

  public static class APIRequestCreateLeadGenWhitelistedUser extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "user_id",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response) throws APIException {
      return Page.parseResponse(response, getContext(), this).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, Page>() {
           public Page apply(String result) {
             try {
               return APIRequestCreateLeadGenWhitelistedUser.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateLeadGenWhitelistedUser(String nodeId, APIContext context) {
      super(context, nodeId, "/leadgen_whitelisted_users", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateLeadGenWhitelistedUser setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateLeadGenWhitelistedUser setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateLeadGenWhitelistedUser setUserId (Long userId) {
      this.setParam("user_id", userId);
      return this;
    }
    public APIRequestCreateLeadGenWhitelistedUser setUserId (String userId) {
      this.setParam("user_id", userId);
      return this;
    }

    public APIRequestCreateLeadGenWhitelistedUser requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateLeadGenWhitelistedUser requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLeadGenWhitelistedUser requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateLeadGenWhitelistedUser requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLeadGenWhitelistedUser requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateLeadGenWhitelistedUser requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetLikes extends APIRequest<Page> {

    APINodeList<Page> lastResponse = null;
    @Override
    public APINodeList<Page> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "target_id",
    };

    public static final String[] FIELDS = {
      "about",
      "access_token",
      "ad_campaign",
      "affiliation",
      "app_id",
      "app_links",
      "artists_we_like",
      "attire",
      "awards",
      "band_interests",
      "band_members",
      "best_page",
      "bio",
      "birthday",
      "booking_agent",
      "built",
      "business",
      "can_checkin",
      "can_post",
      "category",
      "category_list",
      "checkins",
      "company_overview",
      "connected_instagram_account",
      "contact_address",
      "context",
      "copyright_attribution_insights",
      "copyright_whitelisted_ig_partners",
      "country_page_likes",
      "cover",
      "culinary_team",
      "current_location",
      "description",
      "description_html",
      "directed_by",
      "display_subtext",
      "displayed_message_response_time",
      "emails",
      "engagement",
      "fan_count",
      "featured_video",
      "features",
      "food_styles",
      "founded",
      "general_info",
      "general_manager",
      "genre",
      "global_brand_page_name",
      "global_brand_parent_page",
      "global_brand_root_id",
      "has_added_app",
      "has_whatsapp_business_number",
      "has_whatsapp_number",
      "hometown",
      "hours",
      "id",
      "impressum",
      "influences",
      "instagram_business_account",
      "instant_articles_review_status",
      "is_always_open",
      "is_chain",
      "is_community_page",
      "is_eligible_for_branded_content",
      "is_messenger_bot_get_started_enabled",
      "is_messenger_platform_bot",
      "is_owned",
      "is_permanently_closed",
      "is_published",
      "is_unclaimed",
      "is_verified",
      "is_webhooks_subscribed",
      "keywords",
      "leadgen_form_preview_details",
      "leadgen_has_crm_integration",
      "leadgen_has_fat_ping_crm_integration",
      "leadgen_tos_acceptance_time",
      "leadgen_tos_accepted",
      "leadgen_tos_accepting_user",
      "link",
      "location",
      "members",
      "merchant_id",
      "merchant_review_status",
      "messenger_ads_default_icebreakers",
      "messenger_ads_default_page_welcome_message",
      "messenger_ads_default_quick_replies",
      "messenger_ads_quick_replies_type",
      "mission",
      "mpg",
      "name",
      "name_with_location_descriptor",
      "network",
      "new_like_count",
      "offer_eligible",
      "overall_star_rating",
      "page_token",
      "parent_page",
      "parking",
      "payment_options",
      "personal_info",
      "personal_interests",
      "pharma_safety_info",
      "phone",
      "place_type",
      "plot_outline",
      "preferred_audience",
      "press_contact",
      "price_range",
      "produced_by",
      "products",
      "promotion_eligible",
      "promotion_ineligible_reason",
      "public_transit",
      "publisher_space",
      "rating_count",
      "recipient",
      "record_label",
      "release_date",
      "restaurant_services",
      "restaurant_specialties",
      "schedule",
      "screenplay_by",
      "season",
      "single_line_address",
      "starring",
      "start_info",
      "store_code",
      "store_location_descriptor",
      "store_number",
      "studio",
      "supports_instant_articles",
      "talking_about_count",
      "unread_message_count",
      "unread_notif_count",
      "unseen_message_count",
      "username",
      "verification_status",
      "voip_info",
      "website",
      "were_here_count",
      "whatsapp_number",
      "written_by",
    };

    @Override
    public APINodeList<Page> parseResponse(String response) throws APIException {
      return Page.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<Page> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Page> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Page>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Page>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<Page>>() {
           public APINodeList<Page> apply(String result) {
             try {
               return APIRequestGetLikes.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetLikes(String nodeId, APIContext context) {
      super(context, nodeId, "/likes", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetLikes setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetLikes setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetLikes setTargetId (String targetId) {
      this.setParam("target_id", targetId);
      return this;
    }

    public APIRequestGetLikes requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetLikes requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLikes requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetLikes requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLikes requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetLikes requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetLikes requestAboutField () {
      return this.requestAboutField(true);
    }
    public APIRequestGetLikes requestAboutField (boolean value) {
      this.requestField("about", value);
      return this;
    }
    public APIRequestGetLikes requestAccessTokenField () {
      return this.requestAccessTokenField(true);
    }
    public APIRequestGetLikes requestAccessTokenField (boolean value) {
      this.requestField("access_token", value);
      return this;
    }
    public APIRequestGetLikes requestAdCampaignField () {
      return this.requestAdCampaignField(true);
    }
    public APIRequestGetLikes requestAdCampaignField (boolean value) {
      this.requestField("ad_campaign", value);
      return this;
    }
    public APIRequestGetLikes requestAffiliationField () {
      return this.requestAffiliationField(true);
    }
    public APIRequestGetLikes requestAffiliationField (boolean value) {
      this.requestField("affiliation", value);
      return this;
    }
    public APIRequestGetLikes requestAppIdField () {
      return this.requestAppIdField(true);
    }
    public APIRequestGetLikes requestAppIdField (boolean value) {
      this.requestField("app_id", value);
      return this;
    }
    public APIRequestGetLikes requestAppLinksField () {
      return this.requestAppLinksField(true);
    }
    public APIRequestGetLikes requestAppLinksField (boolean value) {
      this.requestField("app_links", value);
      return this;
    }
    public APIRequestGetLikes requestArtistsWeLikeField () {
      return this.requestArtistsWeLikeField(true);
    }
    public APIRequestGetLikes requestArtistsWeLikeField (boolean value) {
      this.requestField("artists_we_like", value);
      return this;
    }
    public APIRequestGetLikes requestAttireField () {
      return this.requestAttireField(true);
    }
    public APIRequestGetLikes requestAttireField (boolean value) {
      this.requestField("attire", value);
      return this;
    }
    public APIRequestGetLikes requestAwardsField () {
      return this.requestAwardsField(true);
    }
    public APIRequestGetLikes requestAwardsField (boolean value) {
      this.requestField("awards", value);
      return this;
    }
    public APIRequestGetLikes requestBandInterestsField () {
      return this.requestBandInterestsField(true);
    }
    public APIRequestGetLikes requestBandInterestsField (boolean value) {
      this.requestField("band_interests", value);
      return this;
    }
    public APIRequestGetLikes requestBandMembersField () {
      return this.requestBandMembersField(true);
    }
    public APIRequestGetLikes requestBandMembersField (boolean value) {
      this.requestField("band_members", value);
      return this;
    }
    public APIRequestGetLikes requestBestPageField () {
      return this.requestBestPageField(true);
    }
    public APIRequestGetLikes requestBestPageField (boolean value) {
      this.requestField("best_page", value);
      return this;
    }
    public APIRequestGetLikes requestBioField () {
      return this.requestBioField(true);
    }
    public APIRequestGetLikes requestBioField (boolean value) {
      this.requestField("bio", value);
      return this;
    }
    public APIRequestGetLikes requestBirthdayField () {
      return this.requestBirthdayField(true);
    }
    public APIRequestGetLikes requestBirthdayField (boolean value) {
      this.requestField("birthday", value);
      return this;
    }
    public APIRequestGetLikes requestBookingAgentField () {
      return this.requestBookingAgentField(true);
    }
    public APIRequestGetLikes requestBookingAgentField (boolean value) {
      this.requestField("booking_agent", value);
      return this;
    }
    public APIRequestGetLikes requestBuiltField () {
      return this.requestBuiltField(true);
    }
    public APIRequestGetLikes requestBuiltField (boolean value) {
      this.requestField("built", value);
      return this;
    }
    public APIRequestGetLikes requestBusinessField () {
      return this.requestBusinessField(true);
    }
    public APIRequestGetLikes requestBusinessField (boolean value) {
      this.requestField("business", value);
      return this;
    }
    public APIRequestGetLikes requestCanCheckinField () {
      return this.requestCanCheckinField(true);
    }
    public APIRequestGetLikes requestCanCheckinField (boolean value) {
      this.requestField("can_checkin", value);
      return this;
    }
    public APIRequestGetLikes requestCanPostField () {
      return this.requestCanPostField(true);
    }
    public APIRequestGetLikes requestCanPostField (boolean value) {
      this.requestField("can_post", value);
      return this;
    }
    public APIRequestGetLikes requestCategoryField () {
      return this.requestCategoryField(true);
    }
    public APIRequestGetLikes requestCategoryField (boolean value) {
      this.requestField("category", value);
      return this;
    }
    public APIRequestGetLikes requestCategoryListField () {
      return this.requestCategoryListField(true);
    }
    public APIRequestGetLikes requestCategoryListField (boolean value) {
      this.requestField("category_list", value);
      return this;
    }
    public APIRequestGetLikes requestCheckinsField () {
      return this.requestCheckinsField(true);
    }
    public APIRequestGetLikes requestCheckinsField (boolean value) {
      this.requestField("checkins", value);
      return this;
    }
    public APIRequestGetLikes requestCompanyOverviewField () {
      return this.requestCompanyOverviewField(true);
    }
    public APIRequestGetLikes requestCompanyOverviewField (boolean value) {
      this.requestField("company_overview", value);
      return this;
    }
    public APIRequestGetLikes requestConnectedInstagramAccountField () {
      return this.requestConnectedInstagramAccountField(true);
    }
    public APIRequestGetLikes requestConnectedInstagramAccountField (boolean value) {
      this.requestField("connected_instagram_account", value);
      return this;
    }
    public APIRequestGetLikes requestContactAddressField () {
      return this.requestContactAddressField(true);
    }
    public APIRequestGetLikes requestContactAddressField (boolean value) {
      this.requestField("contact_address", value);
      return this;
    }
    public APIRequestGetLikes requestContextField () {
      return this.requestContextField(true);
    }
    public APIRequestGetLikes requestContextField (boolean value) {
      this.requestField("context", value);
      return this;
    }
    public APIRequestGetLikes requestCopyrightAttributionInsightsField () {
      return this.requestCopyrightAttributionInsightsField(true);
    }
    public APIRequestGetLikes requestCopyrightAttributionInsightsField (boolean value) {
      this.requestField("copyright_attribution_insights", value);
      return this;
    }
    public APIRequestGetLikes requestCopyrightWhitelistedIgPartnersField () {
      return this.requestCopyrightWhitelistedIgPartnersField(true);
    }
    public APIRequestGetLikes requestCopyrightWhitelistedIgPartnersField (boolean value) {
      this.requestField("copyright_whitelisted_ig_partners", value);
      return this;
    }
    public APIRequestGetLikes requestCountryPageLikesField () {
      return this.requestCountryPageLikesField(true);
    }
    public APIRequestGetLikes requestCountryPageLikesField (boolean value) {
      this.requestField("country_page_likes", value);
      return this;
    }
    public APIRequestGetLikes requestCoverField () {
      return this.requestCoverField(true);
    }
    public APIRequestGetLikes requestCoverField (boolean value) {
      this.requestField("cover", value);
      return this;
    }
    public APIRequestGetLikes requestCulinaryTeamField () {
      return this.requestCulinaryTeamField(true);
    }
    public APIRequestGetLikes requestCulinaryTeamField (boolean value) {
      this.requestField("culinary_team", value);
      return this;
    }
    public APIRequestGetLikes requestCurrentLocationField () {
      return this.requestCurrentLocationField(true);
    }
    public APIRequestGetLikes requestCurrentLocationField (boolean value) {
      this.requestField("current_location", value);
      return this;
    }
    public APIRequestGetLikes requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetLikes requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetLikes requestDescriptionHtmlField () {
      return this.requestDescriptionHtmlField(true);
    }
    public APIRequestGetLikes requestDescriptionHtmlField (boolean value) {
      this.requestField("description_html", value);
      return this;
    }
    public APIRequestGetLikes requestDirectedByField () {
      return this.requestDirectedByField(true);
    }
    public APIRequestGetLikes requestDirectedByField (boolean value) {
      this.requestField("directed_by", value);
      return this;
    }
    public APIRequestGetLikes requestDisplaySubtextField () {
      return this.requestDisplaySubtextField(true);
    }
    public APIRequestGetLikes requestDisplaySubtextField (boolean value) {
      this.requestField("display_subtext", value);
      return this;
    }
    public APIRequestGetLikes requestDisplayedMessageResponseTimeField () {
      return this.requestDisplayedMessageResponseTimeField(true);
    }
    public APIRequestGetLikes requestDisplayedMessageResponseTimeField (boolean value) {
      this.requestField("displayed_message_response_time", value);
      return this;
    }
    public APIRequestGetLikes requestEmailsField () {
      return this.requestEmailsField(true);
    }
    public APIRequestGetLikes requestEmailsField (boolean value) {
      this.requestField("emails", value);
      return this;
    }
    public APIRequestGetLikes requestEngagementField () {
      return this.requestEngagementField(true);
    }
    public APIRequestGetLikes requestEngagementField (boolean value) {
      this.requestField("engagement", value);
      return this;
    }
    public APIRequestGetLikes requestFanCountField () {
      return this.requestFanCountField(true);
    }
    public APIRequestGetLikes requestFanCountField (boolean value) {
      this.requestField("fan_count", value);
      return this;
    }
    public APIRequestGetLikes requestFeaturedVideoField () {
      return this.requestFeaturedVideoField(true);
    }
    public APIRequestGetLikes requestFeaturedVideoField (boolean value) {
      this.requestField("featured_video", value);
      return this;
    }
    public APIRequestGetLikes requestFeaturesField () {
      return this.requestFeaturesField(true);
    }
    public APIRequestGetLikes requestFeaturesField (boolean value) {
      this.requestField("features", value);
      return this;
    }
    public APIRequestGetLikes requestFoodStylesField () {
      return this.requestFoodStylesField(true);
    }
    public APIRequestGetLikes requestFoodStylesField (boolean value) {
      this.requestField("food_styles", value);
      return this;
    }
    public APIRequestGetLikes requestFoundedField () {
      return this.requestFoundedField(true);
    }
    public APIRequestGetLikes requestFoundedField (boolean value) {
      this.requestField("founded", value);
      return this;
    }
    public APIRequestGetLikes requestGeneralInfoField () {
      return this.requestGeneralInfoField(true);
    }
    public APIRequestGetLikes requestGeneralInfoField (boolean value) {
      this.requestField("general_info", value);
      return this;
    }
    public APIRequestGetLikes requestGeneralManagerField () {
      return this.requestGeneralManagerField(true);
    }
    public APIRequestGetLikes requestGeneralManagerField (boolean value) {
      this.requestField("general_manager", value);
      return this;
    }
    public APIRequestGetLikes requestGenreField () {
      return this.requestGenreField(true);
    }
    public APIRequestGetLikes requestGenreField (boolean value) {
      this.requestField("genre", value);
      return this;
    }
    public APIRequestGetLikes requestGlobalBrandPageNameField () {
      return this.requestGlobalBrandPageNameField(true);
    }
    public APIRequestGetLikes requestGlobalBrandPageNameField (boolean value) {
      this.requestField("global_brand_page_name", value);
      return this;
    }
    public APIRequestGetLikes requestGlobalBrandParentPageField () {
      return this.requestGlobalBrandParentPageField(true);
    }
    public APIRequestGetLikes requestGlobalBrandParentPageField (boolean value) {
      this.requestField("global_brand_parent_page", value);
      return this;
    }
    public APIRequestGetLikes requestGlobalBrandRootIdField () {
      return this.requestGlobalBrandRootIdField(true);
    }
    public APIRequestGetLikes requestGlobalBrandRootIdField (boolean value) {
      this.requestField("global_brand_root_id", value);
      return this;
    }
    public APIRequestGetLikes requestHasAddedAppField () {
      return this.requestHasAddedAppField(true);
    }
    public APIRequestGetLikes requestHasAddedAppField (boolean value) {
      this.requestField("has_added_app", value);
      return this;
    }
    public APIRequestGetLikes requestHasWhatsappBusinessNumberField () {
      return this.requestHasWhatsappBusinessNumberField(true);
    }
    public APIRequestGetLikes requestHasWhatsappBusinessNumberField (boolean value) {
      this.requestField("has_whatsapp_business_number", value);
      return this;
    }
    public APIRequestGetLikes requestHasWhatsappNumberField () {
      return this.requestHasWhatsappNumberField(true);
    }
    public APIRequestGetLikes requestHasWhatsappNumberField (boolean value) {
      this.requestField("has_whatsapp_number", value);
      return this;
    }
    public APIRequestGetLikes requestHometownField () {
      return this.requestHometownField(true);
    }
    public APIRequestGetLikes requestHometownField (boolean value) {
      this.requestField("hometown", value);
      return this;
    }
    public APIRequestGetLikes requestHoursField () {
      return this.requestHoursField(true);
    }
    public APIRequestGetLikes requestHoursField (boolean value) {
      this.requestField("hours", value);
      return this;
    }
    public APIRequestGetLikes requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetLikes requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetLikes requestImpressumField () {
      return this.requestImpressumField(true);
    }
    public APIRequestGetLikes requestImpressumField (boolean value) {
      this.requestField("impressum", value);
      return this;
    }
    public APIRequestGetLikes requestInfluencesField () {
      return this.requestInfluencesField(true);
    }
    public APIRequestGetLikes requestInfluencesField (boolean value) {
      this.requestField("influences", value);
      return this;
    }
    public APIRequestGetLikes requestInstagramBusinessAccountField () {
      return this.requestInstagramBusinessAccountField(true);
    }
    public APIRequestGetLikes requestInstagramBusinessAccountField (boolean value) {
      this.requestField("instagram_business_account", value);
      return this;
    }
    public APIRequestGetLikes requestInstantArticlesReviewStatusField () {
      return this.requestInstantArticlesReviewStatusField(true);
    }
    public APIRequestGetLikes requestInstantArticlesReviewStatusField (boolean value) {
      this.requestField("instant_articles_review_status", value);
      return this;
    }
    public APIRequestGetLikes requestIsAlwaysOpenField () {
      return this.requestIsAlwaysOpenField(true);
    }
    public APIRequestGetLikes requestIsAlwaysOpenField (boolean value) {
      this.requestField("is_always_open", value);
      return this;
    }
    public APIRequestGetLikes requestIsChainField () {
      return this.requestIsChainField(true);
    }
    public APIRequestGetLikes requestIsChainField (boolean value) {
      this.requestField("is_chain", value);
      return this;
    }
    public APIRequestGetLikes requestIsCommunityPageField () {
      return this.requestIsCommunityPageField(true);
    }
    public APIRequestGetLikes requestIsCommunityPageField (boolean value) {
      this.requestField("is_community_page", value);
      return this;
    }
    public APIRequestGetLikes requestIsEligibleForBrandedContentField () {
      return this.requestIsEligibleForBrandedContentField(true);
    }
    public APIRequestGetLikes requestIsEligibleForBrandedContentField (boolean value) {
      this.requestField("is_eligible_for_branded_content", value);
      return this;
    }
    public APIRequestGetLikes requestIsMessengerBotGetStartedEnabledField () {
      return this.requestIsMessengerBotGetStartedEnabledField(true);
    }
    public APIRequestGetLikes requestIsMessengerBotGetStartedEnabledField (boolean value) {
      this.requestField("is_messenger_bot_get_started_enabled", value);
      return this;
    }
    public APIRequestGetLikes requestIsMessengerPlatformBotField () {
      return this.requestIsMessengerPlatformBotField(true);
    }
    public APIRequestGetLikes requestIsMessengerPlatformBotField (boolean value) {
      this.requestField("is_messenger_platform_bot", value);
      return this;
    }
    public APIRequestGetLikes requestIsOwnedField () {
      return this.requestIsOwnedField(true);
    }
    public APIRequestGetLikes requestIsOwnedField (boolean value) {
      this.requestField("is_owned", value);
      return this;
    }
    public APIRequestGetLikes requestIsPermanentlyClosedField () {
      return this.requestIsPermanentlyClosedField(true);
    }
    public APIRequestGetLikes requestIsPermanentlyClosedField (boolean value) {
      this.requestField("is_permanently_closed", value);
      return this;
    }
    public APIRequestGetLikes requestIsPublishedField () {
      return this.requestIsPublishedField(true);
    }
    public APIRequestGetLikes requestIsPublishedField (boolean value) {
      this.requestField("is_published", value);
      return this;
    }
    public APIRequestGetLikes requestIsUnclaimedField () {
      return this.requestIsUnclaimedField(true);
    }
    public APIRequestGetLikes requestIsUnclaimedField (boolean value) {
      this.requestField("is_unclaimed", value);
      return this;
    }
    public APIRequestGetLikes requestIsVerifiedField () {
      return this.requestIsVerifiedField(true);
    }
    public APIRequestGetLikes requestIsVerifiedField (boolean value) {
      this.requestField("is_verified", value);
      return this;
    }
    public APIRequestGetLikes requestIsWebhooksSubscribedField () {
      return this.requestIsWebhooksSubscribedField(true);
    }
    public APIRequestGetLikes requestIsWebhooksSubscribedField (boolean value) {
      this.requestField("is_webhooks_subscribed", value);
      return this;
    }
    public APIRequestGetLikes requestKeywordsField () {
      return this.requestKeywordsField(true);
    }
    public APIRequestGetLikes requestKeywordsField (boolean value) {
      this.requestField("keywords", value);
      return this;
    }
    public APIRequestGetLikes requestLeadgenFormPreviewDetailsField () {
      return this.requestLeadgenFormPreviewDetailsField(true);
    }
    public APIRequestGetLikes requestLeadgenFormPreviewDetailsField (boolean value) {
      this.requestField("leadgen_form_preview_details", value);
      return this;
    }
    public APIRequestGetLikes requestLeadgenHasCrmIntegrationField () {
      return this.requestLeadgenHasCrmIntegrationField(true);
    }
    public APIRequestGetLikes requestLeadgenHasCrmIntegrationField (boolean value) {
      this.requestField("leadgen_has_crm_integration", value);
      return this;
    }
    public APIRequestGetLikes requestLeadgenHasFatPingCrmIntegrationField () {
      return this.requestLeadgenHasFatPingCrmIntegrationField(true);
    }
    public APIRequestGetLikes requestLeadgenHasFatPingCrmIntegrationField (boolean value) {
      this.requestField("leadgen_has_fat_ping_crm_integration", value);
      return this;
    }
    public APIRequestGetLikes requestLeadgenTosAcceptanceTimeField () {
      return this.requestLeadgenTosAcceptanceTimeField(true);
    }
    public APIRequestGetLikes requestLeadgenTosAcceptanceTimeField (boolean value) {
      this.requestField("leadgen_tos_acceptance_time", value);
      return this;
    }
    public APIRequestGetLikes requestLeadgenTosAcceptedField () {
      return this.requestLeadgenTosAcceptedField(true);
    }
    public APIRequestGetLikes requestLeadgenTosAcceptedField (boolean value) {
      this.requestField("leadgen_tos_accepted", value);
      return this;
    }
    public APIRequestGetLikes requestLeadgenTosAcceptingUserField () {
      return this.requestLeadgenTosAcceptingUserField(true);
    }
    public APIRequestGetLikes requestLeadgenTosAcceptingUserField (boolean value) {
      this.requestField("leadgen_tos_accepting_user", value);
      return this;
    }
    public APIRequestGetLikes requestLinkField () {
      return this.requestLinkField(true);
    }
    public APIRequestGetLikes requestLinkField (boolean value) {
      this.requestField("link", value);
      return this;
    }
    public APIRequestGetLikes requestLocationField () {
      return this.requestLocationField(true);
    }
    public APIRequestGetLikes requestLocationField (boolean value) {
      this.requestField("location", value);
      return this;
    }
    public APIRequestGetLikes requestMembersField () {
      return this.requestMembersField(true);
    }
    public APIRequestGetLikes requestMembersField (boolean value) {
      this.requestField("members", value);
      return this;
    }
    public APIRequestGetLikes requestMerchantIdField () {
      return this.requestMerchantIdField(true);
    }
    public APIRequestGetLikes requestMerchantIdField (boolean value) {
      this.requestField("merchant_id", value);
      return this;
    }
    public APIRequestGetLikes requestMerchantReviewStatusField () {
      return this.requestMerchantReviewStatusField(true);
    }
    public APIRequestGetLikes requestMerchantReviewStatusField (boolean value) {
      this.requestField("merchant_review_status", value);
      return this;
    }
    public APIRequestGetLikes requestMessengerAdsDefaultIcebreakersField () {
      return this.requestMessengerAdsDefaultIcebreakersField(true);
    }
    public APIRequestGetLikes requestMessengerAdsDefaultIcebreakersField (boolean value) {
      this.requestField("messenger_ads_default_icebreakers", value);
      return this;
    }
    public APIRequestGetLikes requestMessengerAdsDefaultPageWelcomeMessageField () {
      return this.requestMessengerAdsDefaultPageWelcomeMessageField(true);
    }
    public APIRequestGetLikes requestMessengerAdsDefaultPageWelcomeMessageField (boolean value) {
      this.requestField("messenger_ads_default_page_welcome_message", value);
      return this;
    }
    public APIRequestGetLikes requestMessengerAdsDefaultQuickRepliesField () {
      return this.requestMessengerAdsDefaultQuickRepliesField(true);
    }
    public APIRequestGetLikes requestMessengerAdsDefaultQuickRepliesField (boolean value) {
      this.requestField("messenger_ads_default_quick_replies", value);
      return this;
    }
    public APIRequestGetLikes requestMessengerAdsQuickRepliesTypeField () {
      return this.requestMessengerAdsQuickRepliesTypeField(true);
    }
    public APIRequestGetLikes requestMessengerAdsQuickRepliesTypeField (boolean value) {
      this.requestField("messenger_ads_quick_replies_type", value);
      return this;
    }
    public APIRequestGetLikes requestMissionField () {
      return this.requestMissionField(true);
    }
    public APIRequestGetLikes requestMissionField (boolean value) {
      this.requestField("mission", value);
      return this;
    }
    public APIRequestGetLikes requestMpgField () {
      return this.requestMpgField(true);
    }
    public APIRequestGetLikes requestMpgField (boolean value) {
      this.requestField("mpg", value);
      return this;
    }
    public APIRequestGetLikes requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetLikes requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetLikes requestNameWithLocationDescriptorField () {
      return this.requestNameWithLocationDescriptorField(true);
    }
    public APIRequestGetLikes requestNameWithLocationDescriptorField (boolean value) {
      this.requestField("name_with_location_descriptor", value);
      return this;
    }
    public APIRequestGetLikes requestNetworkField () {
      return this.requestNetworkField(true);
    }
    public APIRequestGetLikes requestNetworkField (boolean value) {
      this.requestField("network", value);
      return this;
    }
    public APIRequestGetLikes requestNewLikeCountField () {
      return this.requestNewLikeCountField(true);
    }
    public APIRequestGetLikes requestNewLikeCountField (boolean value) {
      this.requestField("new_like_count", value);
      return this;
    }
    public APIRequestGetLikes requestOfferEligibleField () {
      return this.requestOfferEligibleField(true);
    }
    public APIRequestGetLikes requestOfferEligibleField (boolean value) {
      this.requestField("offer_eligible", value);
      return this;
    }
    public APIRequestGetLikes requestOverallStarRatingField () {
      return this.requestOverallStarRatingField(true);
    }
    public APIRequestGetLikes requestOverallStarRatingField (boolean value) {
      this.requestField("overall_star_rating", value);
      return this;
    }
    public APIRequestGetLikes requestPageTokenField () {
      return this.requestPageTokenField(true);
    }
    public APIRequestGetLikes requestPageTokenField (boolean value) {
      this.requestField("page_token", value);
      return this;
    }
    public APIRequestGetLikes requestParentPageField () {
      return this.requestParentPageField(true);
    }
    public APIRequestGetLikes requestParentPageField (boolean value) {
      this.requestField("parent_page", value);
      return this;
    }
    public APIRequestGetLikes requestParkingField () {
      return this.requestParkingField(true);
    }
    public APIRequestGetLikes requestParkingField (boolean value) {
      this.requestField("parking", value);
      return this;
    }
    public APIRequestGetLikes requestPaymentOptionsField () {
      return this.requestPaymentOptionsField(true);
    }
    public APIRequestGetLikes requestPaymentOptionsField (boolean value) {
      this.requestField("payment_options", value);
      return this;
    }
    public APIRequestGetLikes requestPersonalInfoField () {
      return this.requestPersonalInfoField(true);
    }
    public APIRequestGetLikes requestPersonalInfoField (boolean value) {
      this.requestField("personal_info", value);
      return this;
    }
    public APIRequestGetLikes requestPersonalInterestsField () {
      return this.requestPersonalInterestsField(true);
    }
    public APIRequestGetLikes requestPersonalInterestsField (boolean value) {
      this.requestField("personal_interests", value);
      return this;
    }
    public APIRequestGetLikes requestPharmaSafetyInfoField () {
      return this.requestPharmaSafetyInfoField(true);
    }
    public APIRequestGetLikes requestPharmaSafetyInfoField (boolean value) {
      this.requestField("pharma_safety_info", value);
      return this;
    }
    public APIRequestGetLikes requestPhoneField () {
      return this.requestPhoneField(true);
    }
    public APIRequestGetLikes requestPhoneField (boolean value) {
      this.requestField("phone", value);
      return this;
    }
    public APIRequestGetLikes requestPlaceTypeField () {
      return this.requestPlaceTypeField(true);
    }
    public APIRequestGetLikes requestPlaceTypeField (boolean value) {
      this.requestField("place_type", value);
      return this;
    }
    public APIRequestGetLikes requestPlotOutlineField () {
      return this.requestPlotOutlineField(true);
    }
    public APIRequestGetLikes requestPlotOutlineField (boolean value) {
      this.requestField("plot_outline", value);
      return this;
    }
    public APIRequestGetLikes requestPreferredAudienceField () {
      return this.requestPreferredAudienceField(true);
    }
    public APIRequestGetLikes requestPreferredAudienceField (boolean value) {
      this.requestField("preferred_audience", value);
      return this;
    }
    public APIRequestGetLikes requestPressContactField () {
      return this.requestPressContactField(true);
    }
    public APIRequestGetLikes requestPressContactField (boolean value) {
      this.requestField("press_contact", value);
      return this;
    }
    public APIRequestGetLikes requestPriceRangeField () {
      return this.requestPriceRangeField(true);
    }
    public APIRequestGetLikes requestPriceRangeField (boolean value) {
      this.requestField("price_range", value);
      return this;
    }
    public APIRequestGetLikes requestProducedByField () {
      return this.requestProducedByField(true);
    }
    public APIRequestGetLikes requestProducedByField (boolean value) {
      this.requestField("produced_by", value);
      return this;
    }
    public APIRequestGetLikes requestProductsField () {
      return this.requestProductsField(true);
    }
    public APIRequestGetLikes requestProductsField (boolean value) {
      this.requestField("products", value);
      return this;
    }
    public APIRequestGetLikes requestPromotionEligibleField () {
      return this.requestPromotionEligibleField(true);
    }
    public APIRequestGetLikes requestPromotionEligibleField (boolean value) {
      this.requestField("promotion_eligible", value);
      return this;
    }
    public APIRequestGetLikes requestPromotionIneligibleReasonField () {
      return this.requestPromotionIneligibleReasonField(true);
    }
    public APIRequestGetLikes requestPromotionIneligibleReasonField (boolean value) {
      this.requestField("promotion_ineligible_reason", value);
      return this;
    }
    public APIRequestGetLikes requestPublicTransitField () {
      return this.requestPublicTransitField(true);
    }
    public APIRequestGetLikes requestPublicTransitField (boolean value) {
      this.requestField("public_transit", value);
      return this;
    }
    public APIRequestGetLikes requestPublisherSpaceField () {
      return this.requestPublisherSpaceField(true);
    }
    public APIRequestGetLikes requestPublisherSpaceField (boolean value) {
      this.requestField("publisher_space", value);
      return this;
    }
    public APIRequestGetLikes requestRatingCountField () {
      return this.requestRatingCountField(true);
    }
    public APIRequestGetLikes requestRatingCountField (boolean value) {
      this.requestField("rating_count", value);
      return this;
    }
    public APIRequestGetLikes requestRecipientField () {
      return this.requestRecipientField(true);
    }
    public APIRequestGetLikes requestRecipientField (boolean value) {
      this.requestField("recipient", value);
      return this;
    }
    public APIRequestGetLikes requestRecordLabelField () {
      return this.requestRecordLabelField(true);
    }
    public APIRequestGetLikes requestRecordLabelField (boolean value) {
      this.requestField("record_label", value);
      return this;
    }
    public APIRequestGetLikes requestReleaseDateField () {
      return this.requestReleaseDateField(true);
    }
    public APIRequestGetLikes requestReleaseDateField (boolean value) {
      this.requestField("release_date", value);
      return this;
    }
    public APIRequestGetLikes requestRestaurantServicesField () {
      return this.requestRestaurantServicesField(true);
    }
    public APIRequestGetLikes requestRestaurantServicesField (boolean value) {
      this.requestField("restaurant_services", value);
      return this;
    }
    public APIRequestGetLikes requestRestaurantSpecialtiesField () {
      return this.requestRestaurantSpecialtiesField(true);
    }
    public APIRequestGetLikes requestRestaurantSpecialtiesField (boolean value) {
      this.requestField("restaurant_specialties", value);
      return this;
    }
    public APIRequestGetLikes requestScheduleField () {
      return this.requestScheduleField(true);
    }
    public APIRequestGetLikes requestScheduleField (boolean value) {
      this.requestField("schedule", value);
      return this;
    }
    public APIRequestGetLikes requestScreenplayByField () {
      return this.requestScreenplayByField(true);
    }
    public APIRequestGetLikes requestScreenplayByField (boolean value) {
      this.requestField("screenplay_by", value);
      return this;
    }
    public APIRequestGetLikes requestSeasonField () {
      return this.requestSeasonField(true);
    }
    public APIRequestGetLikes requestSeasonField (boolean value) {
      this.requestField("season", value);
      return this;
    }
    public APIRequestGetLikes requestSingleLineAddressField () {
      return this.requestSingleLineAddressField(true);
    }
    public APIRequestGetLikes requestSingleLineAddressField (boolean value) {
      this.requestField("single_line_address", value);
      return this;
    }
    public APIRequestGetLikes requestStarringField () {
      return this.requestStarringField(true);
    }
    public APIRequestGetLikes requestStarringField (boolean value) {
      this.requestField("starring", value);
      return this;
    }
    public APIRequestGetLikes requestStartInfoField () {
      return this.requestStartInfoField(true);
    }
    public APIRequestGetLikes requestStartInfoField (boolean value) {
      this.requestField("start_info", value);
      return this;
    }
    public APIRequestGetLikes requestStoreCodeField () {
      return this.requestStoreCodeField(true);
    }
    public APIRequestGetLikes requestStoreCodeField (boolean value) {
      this.requestField("store_code", value);
      return this;
    }
    public APIRequestGetLikes requestStoreLocationDescriptorField () {
      return this.requestStoreLocationDescriptorField(true);
    }
    public APIRequestGetLikes requestStoreLocationDescriptorField (boolean value) {
      this.requestField("store_location_descriptor", value);
      return this;
    }
    public APIRequestGetLikes requestStoreNumberField () {
      return this.requestStoreNumberField(true);
    }
    public APIRequestGetLikes requestStoreNumberField (boolean value) {
      this.requestField("store_number", value);
      return this;
    }
    public APIRequestGetLikes requestStudioField () {
      return this.requestStudioField(true);
    }
    public APIRequestGetLikes requestStudioField (boolean value) {
      this.requestField("studio", value);
      return this;
    }
    public APIRequestGetLikes requestSupportsInstantArticlesField () {
      return this.requestSupportsInstantArticlesField(true);
    }
    public APIRequestGetLikes requestSupportsInstantArticlesField (boolean value) {
      this.requestField("supports_instant_articles", value);
      return this;
    }
    public APIRequestGetLikes requestTalkingAboutCountField () {
      return this.requestTalkingAboutCountField(true);
    }
    public APIRequestGetLikes requestTalkingAboutCountField (boolean value) {
      this.requestField("talking_about_count", value);
      return this;
    }
    public APIRequestGetLikes requestUnreadMessageCountField () {
      return this.requestUnreadMessageCountField(true);
    }
    public APIRequestGetLikes requestUnreadMessageCountField (boolean value) {
      this.requestField("unread_message_count", value);
      return this;
    }
    public APIRequestGetLikes requestUnreadNotifCountField () {
      return this.requestUnreadNotifCountField(true);
    }
    public APIRequestGetLikes requestUnreadNotifCountField (boolean value) {
      this.requestField("unread_notif_count", value);
      return this;
    }
    public APIRequestGetLikes requestUnseenMessageCountField () {
      return this.requestUnseenMessageCountField(true);
    }
    public APIRequestGetLikes requestUnseenMessageCountField (boolean value) {
      this.requestField("unseen_message_count", value);
      return this;
    }
    public APIRequestGetLikes requestUsernameField () {
      return this.requestUsernameField(true);
    }
    public APIRequestGetLikes requestUsernameField (boolean value) {
      this.requestField("username", value);
      return this;
    }
    public APIRequestGetLikes requestVerificationStatusField () {
      return this.requestVerificationStatusField(true);
    }
    public APIRequestGetLikes requestVerificationStatusField (boolean value) {
      this.requestField("verification_status", value);
      return this;
    }
    public APIRequestGetLikes requestVoipInfoField () {
      return this.requestVoipInfoField(true);
    }
    public APIRequestGetLikes requestVoipInfoField (boolean value) {
      this.requestField("voip_info", value);
      return this;
    }
    public APIRequestGetLikes requestWebsiteField () {
      return this.requestWebsiteField(true);
    }
    public APIRequestGetLikes requestWebsiteField (boolean value) {
      this.requestField("website", value);
      return this;
    }
    public APIRequestGetLikes requestWereHereCountField () {
      return this.requestWereHereCountField(true);
    }
    public APIRequestGetLikes requestWereHereCountField (boolean value) {
      this.requestField("were_here_count", value);
      return this;
    }
    public APIRequestGetLikes requestWhatsappNumberField () {
      return this.requestWhatsappNumberField(true);
    }
    public APIRequestGetLikes requestWhatsappNumberField (boolean value) {
      this.requestField("whatsapp_number", value);
      return this;
    }
    public APIRequestGetLikes requestWrittenByField () {
      return this.requestWrittenByField(true);
    }
    public APIRequestGetLikes requestWrittenByField (boolean value) {
      this.requestField("written_by", value);
      return this;
    }
  }

  public static class APIRequestCreateLink extends APIRequest<Link> {

    Link lastResponse = null;
    @Override
    public Link getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "link",
      "message",
      "image",
      "tags",
      "place",
      "published",
      "scheduled_publish_time",
      "unpublished_content_type",
      "targeting",
      "privacy",
      "application_id",
      "is_explicit_share",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Link parseResponse(String response) throws APIException {
      return Link.parseResponse(response, getContext(), this).head();
    }

    @Override
    public Link execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Link execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<Link> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Link> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, Link>() {
           public Link apply(String result) {
             try {
               return APIRequestCreateLink.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateLink(String nodeId, APIContext context) {
      super(context, nodeId, "/links", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateLink setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateLink setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateLink setLink (String link) {
      this.setParam("link", link);
      return this;
    }

    public APIRequestCreateLink setMessage (String message) {
      this.setParam("message", message);
      return this;
    }

    public APIRequestCreateLink setImage (String image) {
      this.setParam("image", image);
      return this;
    }

    public APIRequestCreateLink setTags (List<Long> tags) {
      this.setParam("tags", tags);
      return this;
    }
    public APIRequestCreateLink setTags (String tags) {
      this.setParam("tags", tags);
      return this;
    }

    public APIRequestCreateLink setPlace (Object place) {
      this.setParam("place", place);
      return this;
    }
    public APIRequestCreateLink setPlace (String place) {
      this.setParam("place", place);
      return this;
    }

    public APIRequestCreateLink setPublished (Boolean published) {
      this.setParam("published", published);
      return this;
    }
    public APIRequestCreateLink setPublished (String published) {
      this.setParam("published", published);
      return this;
    }

    public APIRequestCreateLink setScheduledPublishTime (Long scheduledPublishTime) {
      this.setParam("scheduled_publish_time", scheduledPublishTime);
      return this;
    }
    public APIRequestCreateLink setScheduledPublishTime (String scheduledPublishTime) {
      this.setParam("scheduled_publish_time", scheduledPublishTime);
      return this;
    }

    public APIRequestCreateLink setUnpublishedContentType (Link.EnumUnpublishedContentType unpublishedContentType) {
      this.setParam("unpublished_content_type", unpublishedContentType);
      return this;
    }
    public APIRequestCreateLink setUnpublishedContentType (String unpublishedContentType) {
      this.setParam("unpublished_content_type", unpublishedContentType);
      return this;
    }

    public APIRequestCreateLink setTargeting (Object targeting) {
      this.setParam("targeting", targeting);
      return this;
    }
    public APIRequestCreateLink setTargeting (String targeting) {
      this.setParam("targeting", targeting);
      return this;
    }

    public APIRequestCreateLink setPrivacy (Object privacy) {
      this.setParam("privacy", privacy);
      return this;
    }
    public APIRequestCreateLink setPrivacy (String privacy) {
      this.setParam("privacy", privacy);
      return this;
    }

    public APIRequestCreateLink setApplicationId (String applicationId) {
      this.setParam("application_id", applicationId);
      return this;
    }

    public APIRequestCreateLink setIsExplicitShare (Boolean isExplicitShare) {
      this.setParam("is_explicit_share", isExplicitShare);
      return this;
    }
    public APIRequestCreateLink setIsExplicitShare (String isExplicitShare) {
      this.setParam("is_explicit_share", isExplicitShare);
      return this;
    }

    public APIRequestCreateLink requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateLink requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLink requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateLink requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLink requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateLink requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetLiveVideos extends APIRequest<LiveVideo> {

    APINodeList<LiveVideo> lastResponse = null;
    @Override
    public APINodeList<LiveVideo> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "type",
      "source",
      "broadcast_status",
    };

    public static final String[] FIELDS = {
      "ad_break_config",
      "ad_break_failure_reason",
      "broadcast_start_time",
      "copyright",
      "creation_time",
      "dash_ingest_url",
      "dash_preview_url",
      "description",
      "embed_html",
      "from",
      "id",
      "ingest_streams",
      "is_manual_mode",
      "is_reference_only",
      "live_encoders",
      "live_views",
      "permalink_url",
      "planned_start_time",
      "preview_url",
      "seconds_left",
      "secure_stream_url",
      "status",
      "stream_url",
      "targeting",
      "title",
      "total_views",
      "video",
    };

    @Override
    public APINodeList<LiveVideo> parseResponse(String response) throws APIException {
      return LiveVideo.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<LiveVideo> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<LiveVideo> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<LiveVideo>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<LiveVideo>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<LiveVideo>>() {
           public APINodeList<LiveVideo> apply(String result) {
             try {
               return APIRequestGetLiveVideos.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetLiveVideos(String nodeId, APIContext context) {
      super(context, nodeId, "/live_videos", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetLiveVideos setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetLiveVideos setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetLiveVideos setType (LiveVideo.EnumType type) {
      this.setParam("type", type);
      return this;
    }
    public APIRequestGetLiveVideos setType (String type) {
      this.setParam("type", type);
      return this;
    }

    public APIRequestGetLiveVideos setSource (LiveVideo.EnumSource source) {
      this.setParam("source", source);
      return this;
    }
    public APIRequestGetLiveVideos setSource (String source) {
      this.setParam("source", source);
      return this;
    }

    public APIRequestGetLiveVideos setBroadcastStatus (List<LiveVideo.EnumBroadcastStatus> broadcastStatus) {
      this.setParam("broadcast_status", broadcastStatus);
      return this;
    }
    public APIRequestGetLiveVideos setBroadcastStatus (String broadcastStatus) {
      this.setParam("broadcast_status", broadcastStatus);
      return this;
    }

    public APIRequestGetLiveVideos requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetLiveVideos requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLiveVideos requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetLiveVideos requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLiveVideos requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetLiveVideos requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetLiveVideos requestAdBreakConfigField () {
      return this.requestAdBreakConfigField(true);
    }
    public APIRequestGetLiveVideos requestAdBreakConfigField (boolean value) {
      this.requestField("ad_break_config", value);
      return this;
    }
    public APIRequestGetLiveVideos requestAdBreakFailureReasonField () {
      return this.requestAdBreakFailureReasonField(true);
    }
    public APIRequestGetLiveVideos requestAdBreakFailureReasonField (boolean value) {
      this.requestField("ad_break_failure_reason", value);
      return this;
    }
    public APIRequestGetLiveVideos requestBroadcastStartTimeField () {
      return this.requestBroadcastStartTimeField(true);
    }
    public APIRequestGetLiveVideos requestBroadcastStartTimeField (boolean value) {
      this.requestField("broadcast_start_time", value);
      return this;
    }
    public APIRequestGetLiveVideos requestCopyrightField () {
      return this.requestCopyrightField(true);
    }
    public APIRequestGetLiveVideos requestCopyrightField (boolean value) {
      this.requestField("copyright", value);
      return this;
    }
    public APIRequestGetLiveVideos requestCreationTimeField () {
      return this.requestCreationTimeField(true);
    }
    public APIRequestGetLiveVideos requestCreationTimeField (boolean value) {
      this.requestField("creation_time", value);
      return this;
    }
    public APIRequestGetLiveVideos requestDashIngestUrlField () {
      return this.requestDashIngestUrlField(true);
    }
    public APIRequestGetLiveVideos requestDashIngestUrlField (boolean value) {
      this.requestField("dash_ingest_url", value);
      return this;
    }
    public APIRequestGetLiveVideos requestDashPreviewUrlField () {
      return this.requestDashPreviewUrlField(true);
    }
    public APIRequestGetLiveVideos requestDashPreviewUrlField (boolean value) {
      this.requestField("dash_preview_url", value);
      return this;
    }
    public APIRequestGetLiveVideos requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetLiveVideos requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetLiveVideos requestEmbedHtmlField () {
      return this.requestEmbedHtmlField(true);
    }
    public APIRequestGetLiveVideos requestEmbedHtmlField (boolean value) {
      this.requestField("embed_html", value);
      return this;
    }
    public APIRequestGetLiveVideos requestFromField () {
      return this.requestFromField(true);
    }
    public APIRequestGetLiveVideos requestFromField (boolean value) {
      this.requestField("from", value);
      return this;
    }
    public APIRequestGetLiveVideos requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetLiveVideos requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetLiveVideos requestIngestStreamsField () {
      return this.requestIngestStreamsField(true);
    }
    public APIRequestGetLiveVideos requestIngestStreamsField (boolean value) {
      this.requestField("ingest_streams", value);
      return this;
    }
    public APIRequestGetLiveVideos requestIsManualModeField () {
      return this.requestIsManualModeField(true);
    }
    public APIRequestGetLiveVideos requestIsManualModeField (boolean value) {
      this.requestField("is_manual_mode", value);
      return this;
    }
    public APIRequestGetLiveVideos requestIsReferenceOnlyField () {
      return this.requestIsReferenceOnlyField(true);
    }
    public APIRequestGetLiveVideos requestIsReferenceOnlyField (boolean value) {
      this.requestField("is_reference_only", value);
      return this;
    }
    public APIRequestGetLiveVideos requestLiveEncodersField () {
      return this.requestLiveEncodersField(true);
    }
    public APIRequestGetLiveVideos requestLiveEncodersField (boolean value) {
      this.requestField("live_encoders", value);
      return this;
    }
    public APIRequestGetLiveVideos requestLiveViewsField () {
      return this.requestLiveViewsField(true);
    }
    public APIRequestGetLiveVideos requestLiveViewsField (boolean value) {
      this.requestField("live_views", value);
      return this;
    }
    public APIRequestGetLiveVideos requestPermalinkUrlField () {
      return this.requestPermalinkUrlField(true);
    }
    public APIRequestGetLiveVideos requestPermalinkUrlField (boolean value) {
      this.requestField("permalink_url", value);
      return this;
    }
    public APIRequestGetLiveVideos requestPlannedStartTimeField () {
      return this.requestPlannedStartTimeField(true);
    }
    public APIRequestGetLiveVideos requestPlannedStartTimeField (boolean value) {
      this.requestField("planned_start_time", value);
      return this;
    }
    public APIRequestGetLiveVideos requestPreviewUrlField () {
      return this.requestPreviewUrlField(true);
    }
    public APIRequestGetLiveVideos requestPreviewUrlField (boolean value) {
      this.requestField("preview_url", value);
      return this;
    }
    public APIRequestGetLiveVideos requestSecondsLeftField () {
      return this.requestSecondsLeftField(true);
    }
    public APIRequestGetLiveVideos requestSecondsLeftField (boolean value) {
      this.requestField("seconds_left", value);
      return this;
    }
    public APIRequestGetLiveVideos requestSecureStreamUrlField () {
      return this.requestSecureStreamUrlField(true);
    }
    public APIRequestGetLiveVideos requestSecureStreamUrlField (boolean value) {
      this.requestField("secure_stream_url", value);
      return this;
    }
    public APIRequestGetLiveVideos requestStatusField () {
      return this.requestStatusField(true);
    }
    public APIRequestGetLiveVideos requestStatusField (boolean value) {
      this.requestField("status", value);
      return this;
    }
    public APIRequestGetLiveVideos requestStreamUrlField () {
      return this.requestStreamUrlField(true);
    }
    public APIRequestGetLiveVideos requestStreamUrlField (boolean value) {
      this.requestField("stream_url", value);
      return this;
    }
    public APIRequestGetLiveVideos requestTargetingField () {
      return this.requestTargetingField(true);
    }
    public APIRequestGetLiveVideos requestTargetingField (boolean value) {
      this.requestField("targeting", value);
      return this;
    }
    public APIRequestGetLiveVideos requestTitleField () {
      return this.requestTitleField(true);
    }
    public APIRequestGetLiveVideos requestTitleField (boolean value) {
      this.requestField("title", value);
      return this;
    }
    public APIRequestGetLiveVideos requestTotalViewsField () {
      return this.requestTotalViewsField(true);
    }
    public APIRequestGetLiveVideos requestTotalViewsField (boolean value) {
      this.requestField("total_views", value);
      return this;
    }
    public APIRequestGetLiveVideos requestVideoField () {
      return this.requestVideoField(true);
    }
    public APIRequestGetLiveVideos requestVideoField (boolean value) {
      this.requestField("video", value);
      return this;
    }
  }

  public static class APIRequestCreateLiveVideo extends APIRequest<LiveVideo> {

    LiveVideo lastResponse = null;
    @Override
    public LiveVideo getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "title",
      "description",
      "save_vod",
      "published",
      "status",
      "privacy",
      "stop_on_delete_stream",
      "stream_type",
      "content_tags",
      "is_spherical",
      "is_audio_only",
      "planned_start_time",
      "schedule_custom_profile_image",
      "projection",
      "spatial_audio_format",
      "encoding_settings",
      "live_encoders",
      "original_fov",
      "fisheye_video_cropped",
      "front_z_rotation",
      "attribution_app_id",
      "stereoscopic_mode",
      "custom_labels",
      "targeting",
      "product_items",
      "crossposting_actions",
      "game_show",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public LiveVideo parseResponse(String response) throws APIException {
      return LiveVideo.parseResponse(response, getContext(), this).head();
    }

    @Override
    public LiveVideo execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public LiveVideo execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<LiveVideo> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<LiveVideo> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, LiveVideo>() {
           public LiveVideo apply(String result) {
             try {
               return APIRequestCreateLiveVideo.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateLiveVideo(String nodeId, APIContext context) {
      super(context, nodeId, "/live_videos", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateLiveVideo setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateLiveVideo setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateLiveVideo setTitle (String title) {
      this.setParam("title", title);
      return this;
    }

    public APIRequestCreateLiveVideo setDescription (String description) {
      this.setParam("description", description);
      return this;
    }

    public APIRequestCreateLiveVideo setSaveVod (Boolean saveVod) {
      this.setParam("save_vod", saveVod);
      return this;
    }
    public APIRequestCreateLiveVideo setSaveVod (String saveVod) {
      this.setParam("save_vod", saveVod);
      return this;
    }

    public APIRequestCreateLiveVideo setPublished (Boolean published) {
      this.setParam("published", published);
      return this;
    }
    public APIRequestCreateLiveVideo setPublished (String published) {
      this.setParam("published", published);
      return this;
    }

    public APIRequestCreateLiveVideo setStatus (LiveVideo.EnumStatus status) {
      this.setParam("status", status);
      return this;
    }
    public APIRequestCreateLiveVideo setStatus (String status) {
      this.setParam("status", status);
      return this;
    }

    public APIRequestCreateLiveVideo setPrivacy (Object privacy) {
      this.setParam("privacy", privacy);
      return this;
    }
    public APIRequestCreateLiveVideo setPrivacy (String privacy) {
      this.setParam("privacy", privacy);
      return this;
    }

    public APIRequestCreateLiveVideo setStopOnDeleteStream (Boolean stopOnDeleteStream) {
      this.setParam("stop_on_delete_stream", stopOnDeleteStream);
      return this;
    }
    public APIRequestCreateLiveVideo setStopOnDeleteStream (String stopOnDeleteStream) {
      this.setParam("stop_on_delete_stream", stopOnDeleteStream);
      return this;
    }

    public APIRequestCreateLiveVideo setStreamType (LiveVideo.EnumStreamType streamType) {
      this.setParam("stream_type", streamType);
      return this;
    }
    public APIRequestCreateLiveVideo setStreamType (String streamType) {
      this.setParam("stream_type", streamType);
      return this;
    }

    public APIRequestCreateLiveVideo setContentTags (List<String> contentTags) {
      this.setParam("content_tags", contentTags);
      return this;
    }
    public APIRequestCreateLiveVideo setContentTags (String contentTags) {
      this.setParam("content_tags", contentTags);
      return this;
    }

    public APIRequestCreateLiveVideo setIsSpherical (Boolean isSpherical) {
      this.setParam("is_spherical", isSpherical);
      return this;
    }
    public APIRequestCreateLiveVideo setIsSpherical (String isSpherical) {
      this.setParam("is_spherical", isSpherical);
      return this;
    }

    public APIRequestCreateLiveVideo setIsAudioOnly (Boolean isAudioOnly) {
      this.setParam("is_audio_only", isAudioOnly);
      return this;
    }
    public APIRequestCreateLiveVideo setIsAudioOnly (String isAudioOnly) {
      this.setParam("is_audio_only", isAudioOnly);
      return this;
    }

    public APIRequestCreateLiveVideo setPlannedStartTime (Long plannedStartTime) {
      this.setParam("planned_start_time", plannedStartTime);
      return this;
    }
    public APIRequestCreateLiveVideo setPlannedStartTime (String plannedStartTime) {
      this.setParam("planned_start_time", plannedStartTime);
      return this;
    }

    public APIRequestCreateLiveVideo setScheduleCustomProfileImage (File scheduleCustomProfileImage) {
      this.setParam("schedule_custom_profile_image", scheduleCustomProfileImage);
      return this;
    }
    public APIRequestCreateLiveVideo setScheduleCustomProfileImage (String scheduleCustomProfileImage) {
      this.setParam("schedule_custom_profile_image", scheduleCustomProfileImage);
      return this;
    }

    public APIRequestCreateLiveVideo setProjection (LiveVideo.EnumProjection projection) {
      this.setParam("projection", projection);
      return this;
    }
    public APIRequestCreateLiveVideo setProjection (String projection) {
      this.setParam("projection", projection);
      return this;
    }

    public APIRequestCreateLiveVideo setSpatialAudioFormat (LiveVideo.EnumSpatialAudioFormat spatialAudioFormat) {
      this.setParam("spatial_audio_format", spatialAudioFormat);
      return this;
    }
    public APIRequestCreateLiveVideo setSpatialAudioFormat (String spatialAudioFormat) {
      this.setParam("spatial_audio_format", spatialAudioFormat);
      return this;
    }

    public APIRequestCreateLiveVideo setEncodingSettings (String encodingSettings) {
      this.setParam("encoding_settings", encodingSettings);
      return this;
    }

    public APIRequestCreateLiveVideo setLiveEncoders (List<String> liveEncoders) {
      this.setParam("live_encoders", liveEncoders);
      return this;
    }
    public APIRequestCreateLiveVideo setLiveEncoders (String liveEncoders) {
      this.setParam("live_encoders", liveEncoders);
      return this;
    }

    public APIRequestCreateLiveVideo setOriginalFov (Long originalFov) {
      this.setParam("original_fov", originalFov);
      return this;
    }
    public APIRequestCreateLiveVideo setOriginalFov (String originalFov) {
      this.setParam("original_fov", originalFov);
      return this;
    }

    public APIRequestCreateLiveVideo setFisheyeVideoCropped (Boolean fisheyeVideoCropped) {
      this.setParam("fisheye_video_cropped", fisheyeVideoCropped);
      return this;
    }
    public APIRequestCreateLiveVideo setFisheyeVideoCropped (String fisheyeVideoCropped) {
      this.setParam("fisheye_video_cropped", fisheyeVideoCropped);
      return this;
    }

    public APIRequestCreateLiveVideo setFrontZRotation (Double frontZRotation) {
      this.setParam("front_z_rotation", frontZRotation);
      return this;
    }
    public APIRequestCreateLiveVideo setFrontZRotation (String frontZRotation) {
      this.setParam("front_z_rotation", frontZRotation);
      return this;
    }

    public APIRequestCreateLiveVideo setAttributionAppId (String attributionAppId) {
      this.setParam("attribution_app_id", attributionAppId);
      return this;
    }

    public APIRequestCreateLiveVideo setStereoscopicMode (LiveVideo.EnumStereoscopicMode stereoscopicMode) {
      this.setParam("stereoscopic_mode", stereoscopicMode);
      return this;
    }
    public APIRequestCreateLiveVideo setStereoscopicMode (String stereoscopicMode) {
      this.setParam("stereoscopic_mode", stereoscopicMode);
      return this;
    }

    public APIRequestCreateLiveVideo setCustomLabels (List<String> customLabels) {
      this.setParam("custom_labels", customLabels);
      return this;
    }
    public APIRequestCreateLiveVideo setCustomLabels (String customLabels) {
      this.setParam("custom_labels", customLabels);
      return this;
    }

    public APIRequestCreateLiveVideo setTargeting (Object targeting) {
      this.setParam("targeting", targeting);
      return this;
    }
    public APIRequestCreateLiveVideo setTargeting (String targeting) {
      this.setParam("targeting", targeting);
      return this;
    }

    public APIRequestCreateLiveVideo setProductItems (List<String> productItems) {
      this.setParam("product_items", productItems);
      return this;
    }
    public APIRequestCreateLiveVideo setProductItems (String productItems) {
      this.setParam("product_items", productItems);
      return this;
    }

    public APIRequestCreateLiveVideo setCrosspostingActions (List<Map<String, String>> crosspostingActions) {
      this.setParam("crossposting_actions", crosspostingActions);
      return this;
    }
    public APIRequestCreateLiveVideo setCrosspostingActions (String crosspostingActions) {
      this.setParam("crossposting_actions", crosspostingActions);
      return this;
    }

    public APIRequestCreateLiveVideo setGameShow (Map<String, String> gameShow) {
      this.setParam("game_show", gameShow);
      return this;
    }
    public APIRequestCreateLiveVideo setGameShow (String gameShow) {
      this.setParam("game_show", gameShow);
      return this;
    }

    public APIRequestCreateLiveVideo requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateLiveVideo requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLiveVideo requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateLiveVideo requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLiveVideo requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateLiveVideo requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestDeleteLocations extends APIRequest<APINode> {

    APINodeList<APINode> lastResponse = null;
    @Override
    public APINodeList<APINode> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "location_page_id",
      "store_number",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINodeList<APINode> parseResponse(String response) throws APIException {
      return APINode.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<APINode> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<APINode>>() {
           public APINodeList<APINode> apply(String result) {
             try {
               return APIRequestDeleteLocations.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestDeleteLocations(String nodeId, APIContext context) {
      super(context, nodeId, "/locations", "DELETE", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestDeleteLocations setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestDeleteLocations setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestDeleteLocations setLocationPageId (Object locationPageId) {
      this.setParam("location_page_id", locationPageId);
      return this;
    }
    public APIRequestDeleteLocations setLocationPageId (String locationPageId) {
      this.setParam("location_page_id", locationPageId);
      return this;
    }

    public APIRequestDeleteLocations setStoreNumber (Long storeNumber) {
      this.setParam("store_number", storeNumber);
      return this;
    }
    public APIRequestDeleteLocations setStoreNumber (String storeNumber) {
      this.setParam("store_number", storeNumber);
      return this;
    }

    public APIRequestDeleteLocations requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestDeleteLocations requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteLocations requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestDeleteLocations requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteLocations requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestDeleteLocations requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetLocations extends APIRequest<Page> {

    APINodeList<Page> lastResponse = null;
    @Override
    public APINodeList<Page> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "about",
      "access_token",
      "ad_campaign",
      "affiliation",
      "app_id",
      "app_links",
      "artists_we_like",
      "attire",
      "awards",
      "band_interests",
      "band_members",
      "best_page",
      "bio",
      "birthday",
      "booking_agent",
      "built",
      "business",
      "can_checkin",
      "can_post",
      "category",
      "category_list",
      "checkins",
      "company_overview",
      "connected_instagram_account",
      "contact_address",
      "context",
      "copyright_attribution_insights",
      "copyright_whitelisted_ig_partners",
      "country_page_likes",
      "cover",
      "culinary_team",
      "current_location",
      "description",
      "description_html",
      "directed_by",
      "display_subtext",
      "displayed_message_response_time",
      "emails",
      "engagement",
      "fan_count",
      "featured_video",
      "features",
      "food_styles",
      "founded",
      "general_info",
      "general_manager",
      "genre",
      "global_brand_page_name",
      "global_brand_parent_page",
      "global_brand_root_id",
      "has_added_app",
      "has_whatsapp_business_number",
      "has_whatsapp_number",
      "hometown",
      "hours",
      "id",
      "impressum",
      "influences",
      "instagram_business_account",
      "instant_articles_review_status",
      "is_always_open",
      "is_chain",
      "is_community_page",
      "is_eligible_for_branded_content",
      "is_messenger_bot_get_started_enabled",
      "is_messenger_platform_bot",
      "is_owned",
      "is_permanently_closed",
      "is_published",
      "is_unclaimed",
      "is_verified",
      "is_webhooks_subscribed",
      "keywords",
      "leadgen_form_preview_details",
      "leadgen_has_crm_integration",
      "leadgen_has_fat_ping_crm_integration",
      "leadgen_tos_acceptance_time",
      "leadgen_tos_accepted",
      "leadgen_tos_accepting_user",
      "link",
      "location",
      "members",
      "merchant_id",
      "merchant_review_status",
      "messenger_ads_default_icebreakers",
      "messenger_ads_default_page_welcome_message",
      "messenger_ads_default_quick_replies",
      "messenger_ads_quick_replies_type",
      "mission",
      "mpg",
      "name",
      "name_with_location_descriptor",
      "network",
      "new_like_count",
      "offer_eligible",
      "overall_star_rating",
      "page_token",
      "parent_page",
      "parking",
      "payment_options",
      "personal_info",
      "personal_interests",
      "pharma_safety_info",
      "phone",
      "place_type",
      "plot_outline",
      "preferred_audience",
      "press_contact",
      "price_range",
      "produced_by",
      "products",
      "promotion_eligible",
      "promotion_ineligible_reason",
      "public_transit",
      "publisher_space",
      "rating_count",
      "recipient",
      "record_label",
      "release_date",
      "restaurant_services",
      "restaurant_specialties",
      "schedule",
      "screenplay_by",
      "season",
      "single_line_address",
      "starring",
      "start_info",
      "store_code",
      "store_location_descriptor",
      "store_number",
      "studio",
      "supports_instant_articles",
      "talking_about_count",
      "unread_message_count",
      "unread_notif_count",
      "unseen_message_count",
      "username",
      "verification_status",
      "voip_info",
      "website",
      "were_here_count",
      "whatsapp_number",
      "written_by",
    };

    @Override
    public APINodeList<Page> parseResponse(String response) throws APIException {
      return Page.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<Page> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Page> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Page>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Page>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<Page>>() {
           public APINodeList<Page> apply(String result) {
             try {
               return APIRequestGetLocations.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetLocations(String nodeId, APIContext context) {
      super(context, nodeId, "/locations", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetLocations setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetLocations setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetLocations requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetLocations requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLocations requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetLocations requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetLocations requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetLocations requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetLocations requestAboutField () {
      return this.requestAboutField(true);
    }
    public APIRequestGetLocations requestAboutField (boolean value) {
      this.requestField("about", value);
      return this;
    }
    public APIRequestGetLocations requestAccessTokenField () {
      return this.requestAccessTokenField(true);
    }
    public APIRequestGetLocations requestAccessTokenField (boolean value) {
      this.requestField("access_token", value);
      return this;
    }
    public APIRequestGetLocations requestAdCampaignField () {
      return this.requestAdCampaignField(true);
    }
    public APIRequestGetLocations requestAdCampaignField (boolean value) {
      this.requestField("ad_campaign", value);
      return this;
    }
    public APIRequestGetLocations requestAffiliationField () {
      return this.requestAffiliationField(true);
    }
    public APIRequestGetLocations requestAffiliationField (boolean value) {
      this.requestField("affiliation", value);
      return this;
    }
    public APIRequestGetLocations requestAppIdField () {
      return this.requestAppIdField(true);
    }
    public APIRequestGetLocations requestAppIdField (boolean value) {
      this.requestField("app_id", value);
      return this;
    }
    public APIRequestGetLocations requestAppLinksField () {
      return this.requestAppLinksField(true);
    }
    public APIRequestGetLocations requestAppLinksField (boolean value) {
      this.requestField("app_links", value);
      return this;
    }
    public APIRequestGetLocations requestArtistsWeLikeField () {
      return this.requestArtistsWeLikeField(true);
    }
    public APIRequestGetLocations requestArtistsWeLikeField (boolean value) {
      this.requestField("artists_we_like", value);
      return this;
    }
    public APIRequestGetLocations requestAttireField () {
      return this.requestAttireField(true);
    }
    public APIRequestGetLocations requestAttireField (boolean value) {
      this.requestField("attire", value);
      return this;
    }
    public APIRequestGetLocations requestAwardsField () {
      return this.requestAwardsField(true);
    }
    public APIRequestGetLocations requestAwardsField (boolean value) {
      this.requestField("awards", value);
      return this;
    }
    public APIRequestGetLocations requestBandInterestsField () {
      return this.requestBandInterestsField(true);
    }
    public APIRequestGetLocations requestBandInterestsField (boolean value) {
      this.requestField("band_interests", value);
      return this;
    }
    public APIRequestGetLocations requestBandMembersField () {
      return this.requestBandMembersField(true);
    }
    public APIRequestGetLocations requestBandMembersField (boolean value) {
      this.requestField("band_members", value);
      return this;
    }
    public APIRequestGetLocations requestBestPageField () {
      return this.requestBestPageField(true);
    }
    public APIRequestGetLocations requestBestPageField (boolean value) {
      this.requestField("best_page", value);
      return this;
    }
    public APIRequestGetLocations requestBioField () {
      return this.requestBioField(true);
    }
    public APIRequestGetLocations requestBioField (boolean value) {
      this.requestField("bio", value);
      return this;
    }
    public APIRequestGetLocations requestBirthdayField () {
      return this.requestBirthdayField(true);
    }
    public APIRequestGetLocations requestBirthdayField (boolean value) {
      this.requestField("birthday", value);
      return this;
    }
    public APIRequestGetLocations requestBookingAgentField () {
      return this.requestBookingAgentField(true);
    }
    public APIRequestGetLocations requestBookingAgentField (boolean value) {
      this.requestField("booking_agent", value);
      return this;
    }
    public APIRequestGetLocations requestBuiltField () {
      return this.requestBuiltField(true);
    }
    public APIRequestGetLocations requestBuiltField (boolean value) {
      this.requestField("built", value);
      return this;
    }
    public APIRequestGetLocations requestBusinessField () {
      return this.requestBusinessField(true);
    }
    public APIRequestGetLocations requestBusinessField (boolean value) {
      this.requestField("business", value);
      return this;
    }
    public APIRequestGetLocations requestCanCheckinField () {
      return this.requestCanCheckinField(true);
    }
    public APIRequestGetLocations requestCanCheckinField (boolean value) {
      this.requestField("can_checkin", value);
      return this;
    }
    public APIRequestGetLocations requestCanPostField () {
      return this.requestCanPostField(true);
    }
    public APIRequestGetLocations requestCanPostField (boolean value) {
      this.requestField("can_post", value);
      return this;
    }
    public APIRequestGetLocations requestCategoryField () {
      return this.requestCategoryField(true);
    }
    public APIRequestGetLocations requestCategoryField (boolean value) {
      this.requestField("category", value);
      return this;
    }
    public APIRequestGetLocations requestCategoryListField () {
      return this.requestCategoryListField(true);
    }
    public APIRequestGetLocations requestCategoryListField (boolean value) {
      this.requestField("category_list", value);
      return this;
    }
    public APIRequestGetLocations requestCheckinsField () {
      return this.requestCheckinsField(true);
    }
    public APIRequestGetLocations requestCheckinsField (boolean value) {
      this.requestField("checkins", value);
      return this;
    }
    public APIRequestGetLocations requestCompanyOverviewField () {
      return this.requestCompanyOverviewField(true);
    }
    public APIRequestGetLocations requestCompanyOverviewField (boolean value) {
      this.requestField("company_overview", value);
      return this;
    }
    public APIRequestGetLocations requestConnectedInstagramAccountField () {
      return this.requestConnectedInstagramAccountField(true);
    }
    public APIRequestGetLocations requestConnectedInstagramAccountField (boolean value) {
      this.requestField("connected_instagram_account", value);
      return this;
    }
    public APIRequestGetLocations requestContactAddressField () {
      return this.requestContactAddressField(true);
    }
    public APIRequestGetLocations requestContactAddressField (boolean value) {
      this.requestField("contact_address", value);
      return this;
    }
    public APIRequestGetLocations requestContextField () {
      return this.requestContextField(true);
    }
    public APIRequestGetLocations requestContextField (boolean value) {
      this.requestField("context", value);
      return this;
    }
    public APIRequestGetLocations requestCopyrightAttributionInsightsField () {
      return this.requestCopyrightAttributionInsightsField(true);
    }
    public APIRequestGetLocations requestCopyrightAttributionInsightsField (boolean value) {
      this.requestField("copyright_attribution_insights", value);
      return this;
    }
    public APIRequestGetLocations requestCopyrightWhitelistedIgPartnersField () {
      return this.requestCopyrightWhitelistedIgPartnersField(true);
    }
    public APIRequestGetLocations requestCopyrightWhitelistedIgPartnersField (boolean value) {
      this.requestField("copyright_whitelisted_ig_partners", value);
      return this;
    }
    public APIRequestGetLocations requestCountryPageLikesField () {
      return this.requestCountryPageLikesField(true);
    }
    public APIRequestGetLocations requestCountryPageLikesField (boolean value) {
      this.requestField("country_page_likes", value);
      return this;
    }
    public APIRequestGetLocations requestCoverField () {
      return this.requestCoverField(true);
    }
    public APIRequestGetLocations requestCoverField (boolean value) {
      this.requestField("cover", value);
      return this;
    }
    public APIRequestGetLocations requestCulinaryTeamField () {
      return this.requestCulinaryTeamField(true);
    }
    public APIRequestGetLocations requestCulinaryTeamField (boolean value) {
      this.requestField("culinary_team", value);
      return this;
    }
    public APIRequestGetLocations requestCurrentLocationField () {
      return this.requestCurrentLocationField(true);
    }
    public APIRequestGetLocations requestCurrentLocationField (boolean value) {
      this.requestField("current_location", value);
      return this;
    }
    public APIRequestGetLocations requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetLocations requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetLocations requestDescriptionHtmlField () {
      return this.requestDescriptionHtmlField(true);
    }
    public APIRequestGetLocations requestDescriptionHtmlField (boolean value) {
      this.requestField("description_html", value);
      return this;
    }
    public APIRequestGetLocations requestDirectedByField () {
      return this.requestDirectedByField(true);
    }
    public APIRequestGetLocations requestDirectedByField (boolean value) {
      this.requestField("directed_by", value);
      return this;
    }
    public APIRequestGetLocations requestDisplaySubtextField () {
      return this.requestDisplaySubtextField(true);
    }
    public APIRequestGetLocations requestDisplaySubtextField (boolean value) {
      this.requestField("display_subtext", value);
      return this;
    }
    public APIRequestGetLocations requestDisplayedMessageResponseTimeField () {
      return this.requestDisplayedMessageResponseTimeField(true);
    }
    public APIRequestGetLocations requestDisplayedMessageResponseTimeField (boolean value) {
      this.requestField("displayed_message_response_time", value);
      return this;
    }
    public APIRequestGetLocations requestEmailsField () {
      return this.requestEmailsField(true);
    }
    public APIRequestGetLocations requestEmailsField (boolean value) {
      this.requestField("emails", value);
      return this;
    }
    public APIRequestGetLocations requestEngagementField () {
      return this.requestEngagementField(true);
    }
    public APIRequestGetLocations requestEngagementField (boolean value) {
      this.requestField("engagement", value);
      return this;
    }
    public APIRequestGetLocations requestFanCountField () {
      return this.requestFanCountField(true);
    }
    public APIRequestGetLocations requestFanCountField (boolean value) {
      this.requestField("fan_count", value);
      return this;
    }
    public APIRequestGetLocations requestFeaturedVideoField () {
      return this.requestFeaturedVideoField(true);
    }
    public APIRequestGetLocations requestFeaturedVideoField (boolean value) {
      this.requestField("featured_video", value);
      return this;
    }
    public APIRequestGetLocations requestFeaturesField () {
      return this.requestFeaturesField(true);
    }
    public APIRequestGetLocations requestFeaturesField (boolean value) {
      this.requestField("features", value);
      return this;
    }
    public APIRequestGetLocations requestFoodStylesField () {
      return this.requestFoodStylesField(true);
    }
    public APIRequestGetLocations requestFoodStylesField (boolean value) {
      this.requestField("food_styles", value);
      return this;
    }
    public APIRequestGetLocations requestFoundedField () {
      return this.requestFoundedField(true);
    }
    public APIRequestGetLocations requestFoundedField (boolean value) {
      this.requestField("founded", value);
      return this;
    }
    public APIRequestGetLocations requestGeneralInfoField () {
      return this.requestGeneralInfoField(true);
    }
    public APIRequestGetLocations requestGeneralInfoField (boolean value) {
      this.requestField("general_info", value);
      return this;
    }
    public APIRequestGetLocations requestGeneralManagerField () {
      return this.requestGeneralManagerField(true);
    }
    public APIRequestGetLocations requestGeneralManagerField (boolean value) {
      this.requestField("general_manager", value);
      return this;
    }
    public APIRequestGetLocations requestGenreField () {
      return this.requestGenreField(true);
    }
    public APIRequestGetLocations requestGenreField (boolean value) {
      this.requestField("genre", value);
      return this;
    }
    public APIRequestGetLocations requestGlobalBrandPageNameField () {
      return this.requestGlobalBrandPageNameField(true);
    }
    public APIRequestGetLocations requestGlobalBrandPageNameField (boolean value) {
      this.requestField("global_brand_page_name", value);
      return this;
    }
    public APIRequestGetLocations requestGlobalBrandParentPageField () {
      return this.requestGlobalBrandParentPageField(true);
    }
    public APIRequestGetLocations requestGlobalBrandParentPageField (boolean value) {
      this.requestField("global_brand_parent_page", value);
      return this;
    }
    public APIRequestGetLocations requestGlobalBrandRootIdField () {
      return this.requestGlobalBrandRootIdField(true);
    }
    public APIRequestGetLocations requestGlobalBrandRootIdField (boolean value) {
      this.requestField("global_brand_root_id", value);
      return this;
    }
    public APIRequestGetLocations requestHasAddedAppField () {
      return this.requestHasAddedAppField(true);
    }
    public APIRequestGetLocations requestHasAddedAppField (boolean value) {
      this.requestField("has_added_app", value);
      return this;
    }
    public APIRequestGetLocations requestHasWhatsappBusinessNumberField () {
      return this.requestHasWhatsappBusinessNumberField(true);
    }
    public APIRequestGetLocations requestHasWhatsappBusinessNumberField (boolean value) {
      this.requestField("has_whatsapp_business_number", value);
      return this;
    }
    public APIRequestGetLocations requestHasWhatsappNumberField () {
      return this.requestHasWhatsappNumberField(true);
    }
    public APIRequestGetLocations requestHasWhatsappNumberField (boolean value) {
      this.requestField("has_whatsapp_number", value);
      return this;
    }
    public APIRequestGetLocations requestHometownField () {
      return this.requestHometownField(true);
    }
    public APIRequestGetLocations requestHometownField (boolean value) {
      this.requestField("hometown", value);
      return this;
    }
    public APIRequestGetLocations requestHoursField () {
      return this.requestHoursField(true);
    }
    public APIRequestGetLocations requestHoursField (boolean value) {
      this.requestField("hours", value);
      return this;
    }
    public APIRequestGetLocations requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetLocations requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetLocations requestImpressumField () {
      return this.requestImpressumField(true);
    }
    public APIRequestGetLocations requestImpressumField (boolean value) {
      this.requestField("impressum", value);
      return this;
    }
    public APIRequestGetLocations requestInfluencesField () {
      return this.requestInfluencesField(true);
    }
    public APIRequestGetLocations requestInfluencesField (boolean value) {
      this.requestField("influences", value);
      return this;
    }
    public APIRequestGetLocations requestInstagramBusinessAccountField () {
      return this.requestInstagramBusinessAccountField(true);
    }
    public APIRequestGetLocations requestInstagramBusinessAccountField (boolean value) {
      this.requestField("instagram_business_account", value);
      return this;
    }
    public APIRequestGetLocations requestInstantArticlesReviewStatusField () {
      return this.requestInstantArticlesReviewStatusField(true);
    }
    public APIRequestGetLocations requestInstantArticlesReviewStatusField (boolean value) {
      this.requestField("instant_articles_review_status", value);
      return this;
    }
    public APIRequestGetLocations requestIsAlwaysOpenField () {
      return this.requestIsAlwaysOpenField(true);
    }
    public APIRequestGetLocations requestIsAlwaysOpenField (boolean value) {
      this.requestField("is_always_open", value);
      return this;
    }
    public APIRequestGetLocations requestIsChainField () {
      return this.requestIsChainField(true);
    }
    public APIRequestGetLocations requestIsChainField (boolean value) {
      this.requestField("is_chain", value);
      return this;
    }
    public APIRequestGetLocations requestIsCommunityPageField () {
      return this.requestIsCommunityPageField(true);
    }
    public APIRequestGetLocations requestIsCommunityPageField (boolean value) {
      this.requestField("is_community_page", value);
      return this;
    }
    public APIRequestGetLocations requestIsEligibleForBrandedContentField () {
      return this.requestIsEligibleForBrandedContentField(true);
    }
    public APIRequestGetLocations requestIsEligibleForBrandedContentField (boolean value) {
      this.requestField("is_eligible_for_branded_content", value);
      return this;
    }
    public APIRequestGetLocations requestIsMessengerBotGetStartedEnabledField () {
      return this.requestIsMessengerBotGetStartedEnabledField(true);
    }
    public APIRequestGetLocations requestIsMessengerBotGetStartedEnabledField (boolean value) {
      this.requestField("is_messenger_bot_get_started_enabled", value);
      return this;
    }
    public APIRequestGetLocations requestIsMessengerPlatformBotField () {
      return this.requestIsMessengerPlatformBotField(true);
    }
    public APIRequestGetLocations requestIsMessengerPlatformBotField (boolean value) {
      this.requestField("is_messenger_platform_bot", value);
      return this;
    }
    public APIRequestGetLocations requestIsOwnedField () {
      return this.requestIsOwnedField(true);
    }
    public APIRequestGetLocations requestIsOwnedField (boolean value) {
      this.requestField("is_owned", value);
      return this;
    }
    public APIRequestGetLocations requestIsPermanentlyClosedField () {
      return this.requestIsPermanentlyClosedField(true);
    }
    public APIRequestGetLocations requestIsPermanentlyClosedField (boolean value) {
      this.requestField("is_permanently_closed", value);
      return this;
    }
    public APIRequestGetLocations requestIsPublishedField () {
      return this.requestIsPublishedField(true);
    }
    public APIRequestGetLocations requestIsPublishedField (boolean value) {
      this.requestField("is_published", value);
      return this;
    }
    public APIRequestGetLocations requestIsUnclaimedField () {
      return this.requestIsUnclaimedField(true);
    }
    public APIRequestGetLocations requestIsUnclaimedField (boolean value) {
      this.requestField("is_unclaimed", value);
      return this;
    }
    public APIRequestGetLocations requestIsVerifiedField () {
      return this.requestIsVerifiedField(true);
    }
    public APIRequestGetLocations requestIsVerifiedField (boolean value) {
      this.requestField("is_verified", value);
      return this;
    }
    public APIRequestGetLocations requestIsWebhooksSubscribedField () {
      return this.requestIsWebhooksSubscribedField(true);
    }
    public APIRequestGetLocations requestIsWebhooksSubscribedField (boolean value) {
      this.requestField("is_webhooks_subscribed", value);
      return this;
    }
    public APIRequestGetLocations requestKeywordsField () {
      return this.requestKeywordsField(true);
    }
    public APIRequestGetLocations requestKeywordsField (boolean value) {
      this.requestField("keywords", value);
      return this;
    }
    public APIRequestGetLocations requestLeadgenFormPreviewDetailsField () {
      return this.requestLeadgenFormPreviewDetailsField(true);
    }
    public APIRequestGetLocations requestLeadgenFormPreviewDetailsField (boolean value) {
      this.requestField("leadgen_form_preview_details", value);
      return this;
    }
    public APIRequestGetLocations requestLeadgenHasCrmIntegrationField () {
      return this.requestLeadgenHasCrmIntegrationField(true);
    }
    public APIRequestGetLocations requestLeadgenHasCrmIntegrationField (boolean value) {
      this.requestField("leadgen_has_crm_integration", value);
      return this;
    }
    public APIRequestGetLocations requestLeadgenHasFatPingCrmIntegrationField () {
      return this.requestLeadgenHasFatPingCrmIntegrationField(true);
    }
    public APIRequestGetLocations requestLeadgenHasFatPingCrmIntegrationField (boolean value) {
      this.requestField("leadgen_has_fat_ping_crm_integration", value);
      return this;
    }
    public APIRequestGetLocations requestLeadgenTosAcceptanceTimeField () {
      return this.requestLeadgenTosAcceptanceTimeField(true);
    }
    public APIRequestGetLocations requestLeadgenTosAcceptanceTimeField (boolean value) {
      this.requestField("leadgen_tos_acceptance_time", value);
      return this;
    }
    public APIRequestGetLocations requestLeadgenTosAcceptedField () {
      return this.requestLeadgenTosAcceptedField(true);
    }
    public APIRequestGetLocations requestLeadgenTosAcceptedField (boolean value) {
      this.requestField("leadgen_tos_accepted", value);
      return this;
    }
    public APIRequestGetLocations requestLeadgenTosAcceptingUserField () {
      return this.requestLeadgenTosAcceptingUserField(true);
    }
    public APIRequestGetLocations requestLeadgenTosAcceptingUserField (boolean value) {
      this.requestField("leadgen_tos_accepting_user", value);
      return this;
    }
    public APIRequestGetLocations requestLinkField () {
      return this.requestLinkField(true);
    }
    public APIRequestGetLocations requestLinkField (boolean value) {
      this.requestField("link", value);
      return this;
    }
    public APIRequestGetLocations requestLocationField () {
      return this.requestLocationField(true);
    }
    public APIRequestGetLocations requestLocationField (boolean value) {
      this.requestField("location", value);
      return this;
    }
    public APIRequestGetLocations requestMembersField () {
      return this.requestMembersField(true);
    }
    public APIRequestGetLocations requestMembersField (boolean value) {
      this.requestField("members", value);
      return this;
    }
    public APIRequestGetLocations requestMerchantIdField () {
      return this.requestMerchantIdField(true);
    }
    public APIRequestGetLocations requestMerchantIdField (boolean value) {
      this.requestField("merchant_id", value);
      return this;
    }
    public APIRequestGetLocations requestMerchantReviewStatusField () {
      return this.requestMerchantReviewStatusField(true);
    }
    public APIRequestGetLocations requestMerchantReviewStatusField (boolean value) {
      this.requestField("merchant_review_status", value);
      return this;
    }
    public APIRequestGetLocations requestMessengerAdsDefaultIcebreakersField () {
      return this.requestMessengerAdsDefaultIcebreakersField(true);
    }
    public APIRequestGetLocations requestMessengerAdsDefaultIcebreakersField (boolean value) {
      this.requestField("messenger_ads_default_icebreakers", value);
      return this;
    }
    public APIRequestGetLocations requestMessengerAdsDefaultPageWelcomeMessageField () {
      return this.requestMessengerAdsDefaultPageWelcomeMessageField(true);
    }
    public APIRequestGetLocations requestMessengerAdsDefaultPageWelcomeMessageField (boolean value) {
      this.requestField("messenger_ads_default_page_welcome_message", value);
      return this;
    }
    public APIRequestGetLocations requestMessengerAdsDefaultQuickRepliesField () {
      return this.requestMessengerAdsDefaultQuickRepliesField(true);
    }
    public APIRequestGetLocations requestMessengerAdsDefaultQuickRepliesField (boolean value) {
      this.requestField("messenger_ads_default_quick_replies", value);
      return this;
    }
    public APIRequestGetLocations requestMessengerAdsQuickRepliesTypeField () {
      return this.requestMessengerAdsQuickRepliesTypeField(true);
    }
    public APIRequestGetLocations requestMessengerAdsQuickRepliesTypeField (boolean value) {
      this.requestField("messenger_ads_quick_replies_type", value);
      return this;
    }
    public APIRequestGetLocations requestMissionField () {
      return this.requestMissionField(true);
    }
    public APIRequestGetLocations requestMissionField (boolean value) {
      this.requestField("mission", value);
      return this;
    }
    public APIRequestGetLocations requestMpgField () {
      return this.requestMpgField(true);
    }
    public APIRequestGetLocations requestMpgField (boolean value) {
      this.requestField("mpg", value);
      return this;
    }
    public APIRequestGetLocations requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetLocations requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetLocations requestNameWithLocationDescriptorField () {
      return this.requestNameWithLocationDescriptorField(true);
    }
    public APIRequestGetLocations requestNameWithLocationDescriptorField (boolean value) {
      this.requestField("name_with_location_descriptor", value);
      return this;
    }
    public APIRequestGetLocations requestNetworkField () {
      return this.requestNetworkField(true);
    }
    public APIRequestGetLocations requestNetworkField (boolean value) {
      this.requestField("network", value);
      return this;
    }
    public APIRequestGetLocations requestNewLikeCountField () {
      return this.requestNewLikeCountField(true);
    }
    public APIRequestGetLocations requestNewLikeCountField (boolean value) {
      this.requestField("new_like_count", value);
      return this;
    }
    public APIRequestGetLocations requestOfferEligibleField () {
      return this.requestOfferEligibleField(true);
    }
    public APIRequestGetLocations requestOfferEligibleField (boolean value) {
      this.requestField("offer_eligible", value);
      return this;
    }
    public APIRequestGetLocations requestOverallStarRatingField () {
      return this.requestOverallStarRatingField(true);
    }
    public APIRequestGetLocations requestOverallStarRatingField (boolean value) {
      this.requestField("overall_star_rating", value);
      return this;
    }
    public APIRequestGetLocations requestPageTokenField () {
      return this.requestPageTokenField(true);
    }
    public APIRequestGetLocations requestPageTokenField (boolean value) {
      this.requestField("page_token", value);
      return this;
    }
    public APIRequestGetLocations requestParentPageField () {
      return this.requestParentPageField(true);
    }
    public APIRequestGetLocations requestParentPageField (boolean value) {
      this.requestField("parent_page", value);
      return this;
    }
    public APIRequestGetLocations requestParkingField () {
      return this.requestParkingField(true);
    }
    public APIRequestGetLocations requestParkingField (boolean value) {
      this.requestField("parking", value);
      return this;
    }
    public APIRequestGetLocations requestPaymentOptionsField () {
      return this.requestPaymentOptionsField(true);
    }
    public APIRequestGetLocations requestPaymentOptionsField (boolean value) {
      this.requestField("payment_options", value);
      return this;
    }
    public APIRequestGetLocations requestPersonalInfoField () {
      return this.requestPersonalInfoField(true);
    }
    public APIRequestGetLocations requestPersonalInfoField (boolean value) {
      this.requestField("personal_info", value);
      return this;
    }
    public APIRequestGetLocations requestPersonalInterestsField () {
      return this.requestPersonalInterestsField(true);
    }
    public APIRequestGetLocations requestPersonalInterestsField (boolean value) {
      this.requestField("personal_interests", value);
      return this;
    }
    public APIRequestGetLocations requestPharmaSafetyInfoField () {
      return this.requestPharmaSafetyInfoField(true);
    }
    public APIRequestGetLocations requestPharmaSafetyInfoField (boolean value) {
      this.requestField("pharma_safety_info", value);
      return this;
    }
    public APIRequestGetLocations requestPhoneField () {
      return this.requestPhoneField(true);
    }
    public APIRequestGetLocations requestPhoneField (boolean value) {
      this.requestField("phone", value);
      return this;
    }
    public APIRequestGetLocations requestPlaceTypeField () {
      return this.requestPlaceTypeField(true);
    }
    public APIRequestGetLocations requestPlaceTypeField (boolean value) {
      this.requestField("place_type", value);
      return this;
    }
    public APIRequestGetLocations requestPlotOutlineField () {
      return this.requestPlotOutlineField(true);
    }
    public APIRequestGetLocations requestPlotOutlineField (boolean value) {
      this.requestField("plot_outline", value);
      return this;
    }
    public APIRequestGetLocations requestPreferredAudienceField () {
      return this.requestPreferredAudienceField(true);
    }
    public APIRequestGetLocations requestPreferredAudienceField (boolean value) {
      this.requestField("preferred_audience", value);
      return this;
    }
    public APIRequestGetLocations requestPressContactField () {
      return this.requestPressContactField(true);
    }
    public APIRequestGetLocations requestPressContactField (boolean value) {
      this.requestField("press_contact", value);
      return this;
    }
    public APIRequestGetLocations requestPriceRangeField () {
      return this.requestPriceRangeField(true);
    }
    public APIRequestGetLocations requestPriceRangeField (boolean value) {
      this.requestField("price_range", value);
      return this;
    }
    public APIRequestGetLocations requestProducedByField () {
      return this.requestProducedByField(true);
    }
    public APIRequestGetLocations requestProducedByField (boolean value) {
      this.requestField("produced_by", value);
      return this;
    }
    public APIRequestGetLocations requestProductsField () {
      return this.requestProductsField(true);
    }
    public APIRequestGetLocations requestProductsField (boolean value) {
      this.requestField("products", value);
      return this;
    }
    public APIRequestGetLocations requestPromotionEligibleField () {
      return this.requestPromotionEligibleField(true);
    }
    public APIRequestGetLocations requestPromotionEligibleField (boolean value) {
      this.requestField("promotion_eligible", value);
      return this;
    }
    public APIRequestGetLocations requestPromotionIneligibleReasonField () {
      return this.requestPromotionIneligibleReasonField(true);
    }
    public APIRequestGetLocations requestPromotionIneligibleReasonField (boolean value) {
      this.requestField("promotion_ineligible_reason", value);
      return this;
    }
    public APIRequestGetLocations requestPublicTransitField () {
      return this.requestPublicTransitField(true);
    }
    public APIRequestGetLocations requestPublicTransitField (boolean value) {
      this.requestField("public_transit", value);
      return this;
    }
    public APIRequestGetLocations requestPublisherSpaceField () {
      return this.requestPublisherSpaceField(true);
    }
    public APIRequestGetLocations requestPublisherSpaceField (boolean value) {
      this.requestField("publisher_space", value);
      return this;
    }
    public APIRequestGetLocations requestRatingCountField () {
      return this.requestRatingCountField(true);
    }
    public APIRequestGetLocations requestRatingCountField (boolean value) {
      this.requestField("rating_count", value);
      return this;
    }
    public APIRequestGetLocations requestRecipientField () {
      return this.requestRecipientField(true);
    }
    public APIRequestGetLocations requestRecipientField (boolean value) {
      this.requestField("recipient", value);
      return this;
    }
    public APIRequestGetLocations requestRecordLabelField () {
      return this.requestRecordLabelField(true);
    }
    public APIRequestGetLocations requestRecordLabelField (boolean value) {
      this.requestField("record_label", value);
      return this;
    }
    public APIRequestGetLocations requestReleaseDateField () {
      return this.requestReleaseDateField(true);
    }
    public APIRequestGetLocations requestReleaseDateField (boolean value) {
      this.requestField("release_date", value);
      return this;
    }
    public APIRequestGetLocations requestRestaurantServicesField () {
      return this.requestRestaurantServicesField(true);
    }
    public APIRequestGetLocations requestRestaurantServicesField (boolean value) {
      this.requestField("restaurant_services", value);
      return this;
    }
    public APIRequestGetLocations requestRestaurantSpecialtiesField () {
      return this.requestRestaurantSpecialtiesField(true);
    }
    public APIRequestGetLocations requestRestaurantSpecialtiesField (boolean value) {
      this.requestField("restaurant_specialties", value);
      return this;
    }
    public APIRequestGetLocations requestScheduleField () {
      return this.requestScheduleField(true);
    }
    public APIRequestGetLocations requestScheduleField (boolean value) {
      this.requestField("schedule", value);
      return this;
    }
    public APIRequestGetLocations requestScreenplayByField () {
      return this.requestScreenplayByField(true);
    }
    public APIRequestGetLocations requestScreenplayByField (boolean value) {
      this.requestField("screenplay_by", value);
      return this;
    }
    public APIRequestGetLocations requestSeasonField () {
      return this.requestSeasonField(true);
    }
    public APIRequestGetLocations requestSeasonField (boolean value) {
      this.requestField("season", value);
      return this;
    }
    public APIRequestGetLocations requestSingleLineAddressField () {
      return this.requestSingleLineAddressField(true);
    }
    public APIRequestGetLocations requestSingleLineAddressField (boolean value) {
      this.requestField("single_line_address", value);
      return this;
    }
    public APIRequestGetLocations requestStarringField () {
      return this.requestStarringField(true);
    }
    public APIRequestGetLocations requestStarringField (boolean value) {
      this.requestField("starring", value);
      return this;
    }
    public APIRequestGetLocations requestStartInfoField () {
      return this.requestStartInfoField(true);
    }
    public APIRequestGetLocations requestStartInfoField (boolean value) {
      this.requestField("start_info", value);
      return this;
    }
    public APIRequestGetLocations requestStoreCodeField () {
      return this.requestStoreCodeField(true);
    }
    public APIRequestGetLocations requestStoreCodeField (boolean value) {
      this.requestField("store_code", value);
      return this;
    }
    public APIRequestGetLocations requestStoreLocationDescriptorField () {
      return this.requestStoreLocationDescriptorField(true);
    }
    public APIRequestGetLocations requestStoreLocationDescriptorField (boolean value) {
      this.requestField("store_location_descriptor", value);
      return this;
    }
    public APIRequestGetLocations requestStoreNumberField () {
      return this.requestStoreNumberField(true);
    }
    public APIRequestGetLocations requestStoreNumberField (boolean value) {
      this.requestField("store_number", value);
      return this;
    }
    public APIRequestGetLocations requestStudioField () {
      return this.requestStudioField(true);
    }
    public APIRequestGetLocations requestStudioField (boolean value) {
      this.requestField("studio", value);
      return this;
    }
    public APIRequestGetLocations requestSupportsInstantArticlesField () {
      return this.requestSupportsInstantArticlesField(true);
    }
    public APIRequestGetLocations requestSupportsInstantArticlesField (boolean value) {
      this.requestField("supports_instant_articles", value);
      return this;
    }
    public APIRequestGetLocations requestTalkingAboutCountField () {
      return this.requestTalkingAboutCountField(true);
    }
    public APIRequestGetLocations requestTalkingAboutCountField (boolean value) {
      this.requestField("talking_about_count", value);
      return this;
    }
    public APIRequestGetLocations requestUnreadMessageCountField () {
      return this.requestUnreadMessageCountField(true);
    }
    public APIRequestGetLocations requestUnreadMessageCountField (boolean value) {
      this.requestField("unread_message_count", value);
      return this;
    }
    public APIRequestGetLocations requestUnreadNotifCountField () {
      return this.requestUnreadNotifCountField(true);
    }
    public APIRequestGetLocations requestUnreadNotifCountField (boolean value) {
      this.requestField("unread_notif_count", value);
      return this;
    }
    public APIRequestGetLocations requestUnseenMessageCountField () {
      return this.requestUnseenMessageCountField(true);
    }
    public APIRequestGetLocations requestUnseenMessageCountField (boolean value) {
      this.requestField("unseen_message_count", value);
      return this;
    }
    public APIRequestGetLocations requestUsernameField () {
      return this.requestUsernameField(true);
    }
    public APIRequestGetLocations requestUsernameField (boolean value) {
      this.requestField("username", value);
      return this;
    }
    public APIRequestGetLocations requestVerificationStatusField () {
      return this.requestVerificationStatusField(true);
    }
    public APIRequestGetLocations requestVerificationStatusField (boolean value) {
      this.requestField("verification_status", value);
      return this;
    }
    public APIRequestGetLocations requestVoipInfoField () {
      return this.requestVoipInfoField(true);
    }
    public APIRequestGetLocations requestVoipInfoField (boolean value) {
      this.requestField("voip_info", value);
      return this;
    }
    public APIRequestGetLocations requestWebsiteField () {
      return this.requestWebsiteField(true);
    }
    public APIRequestGetLocations requestWebsiteField (boolean value) {
      this.requestField("website", value);
      return this;
    }
    public APIRequestGetLocations requestWereHereCountField () {
      return this.requestWereHereCountField(true);
    }
    public APIRequestGetLocations requestWereHereCountField (boolean value) {
      this.requestField("were_here_count", value);
      return this;
    }
    public APIRequestGetLocations requestWhatsappNumberField () {
      return this.requestWhatsappNumberField(true);
    }
    public APIRequestGetLocations requestWhatsappNumberField (boolean value) {
      this.requestField("whatsapp_number", value);
      return this;
    }
    public APIRequestGetLocations requestWrittenByField () {
      return this.requestWrittenByField(true);
    }
    public APIRequestGetLocations requestWrittenByField (boolean value) {
      this.requestField("written_by", value);
      return this;
    }
  }

  public static class APIRequestCreateLocation extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "store_number",
      "location",
      "place_topics",
      "phone",
      "store_name",
      "hours",
      "page_username",
      "old_store_number",
      "permanently_closed",
      "price_range",
      "store_location_descriptor",
      "location_page_id",
      "ignore_warnings",
      "website",
      "always_open",
      "store_code",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response) throws APIException {
      return Page.parseResponse(response, getContext(), this).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, Page>() {
           public Page apply(String result) {
             try {
               return APIRequestCreateLocation.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateLocation(String nodeId, APIContext context) {
      super(context, nodeId, "/locations", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateLocation setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateLocation setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateLocation setStoreNumber (Long storeNumber) {
      this.setParam("store_number", storeNumber);
      return this;
    }
    public APIRequestCreateLocation setStoreNumber (String storeNumber) {
      this.setParam("store_number", storeNumber);
      return this;
    }

    public APIRequestCreateLocation setLocation (Object location) {
      this.setParam("location", location);
      return this;
    }
    public APIRequestCreateLocation setLocation (String location) {
      this.setParam("location", location);
      return this;
    }

    public APIRequestCreateLocation setPlaceTopics (List<String> placeTopics) {
      this.setParam("place_topics", placeTopics);
      return this;
    }
    public APIRequestCreateLocation setPlaceTopics (String placeTopics) {
      this.setParam("place_topics", placeTopics);
      return this;
    }

    public APIRequestCreateLocation setPhone (String phone) {
      this.setParam("phone", phone);
      return this;
    }

    public APIRequestCreateLocation setStoreName (String storeName) {
      this.setParam("store_name", storeName);
      return this;
    }

    public APIRequestCreateLocation setHours (Map<String, String> hours) {
      this.setParam("hours", hours);
      return this;
    }
    public APIRequestCreateLocation setHours (String hours) {
      this.setParam("hours", hours);
      return this;
    }

    public APIRequestCreateLocation setPageUsername (String pageUsername) {
      this.setParam("page_username", pageUsername);
      return this;
    }

    public APIRequestCreateLocation setOldStoreNumber (Long oldStoreNumber) {
      this.setParam("old_store_number", oldStoreNumber);
      return this;
    }
    public APIRequestCreateLocation setOldStoreNumber (String oldStoreNumber) {
      this.setParam("old_store_number", oldStoreNumber);
      return this;
    }

    public APIRequestCreateLocation setPermanentlyClosed (Boolean permanentlyClosed) {
      this.setParam("permanently_closed", permanentlyClosed);
      return this;
    }
    public APIRequestCreateLocation setPermanentlyClosed (String permanentlyClosed) {
      this.setParam("permanently_closed", permanentlyClosed);
      return this;
    }

    public APIRequestCreateLocation setPriceRange (String priceRange) {
      this.setParam("price_range", priceRange);
      return this;
    }

    public APIRequestCreateLocation setStoreLocationDescriptor (String storeLocationDescriptor) {
      this.setParam("store_location_descriptor", storeLocationDescriptor);
      return this;
    }

    public APIRequestCreateLocation setLocationPageId (Object locationPageId) {
      this.setParam("location_page_id", locationPageId);
      return this;
    }
    public APIRequestCreateLocation setLocationPageId (String locationPageId) {
      this.setParam("location_page_id", locationPageId);
      return this;
    }

    public APIRequestCreateLocation setIgnoreWarnings (Boolean ignoreWarnings) {
      this.setParam("ignore_warnings", ignoreWarnings);
      return this;
    }
    public APIRequestCreateLocation setIgnoreWarnings (String ignoreWarnings) {
      this.setParam("ignore_warnings", ignoreWarnings);
      return this;
    }

    public APIRequestCreateLocation setWebsite (Object website) {
      this.setParam("website", website);
      return this;
    }
    public APIRequestCreateLocation setWebsite (String website) {
      this.setParam("website", website);
      return this;
    }

    public APIRequestCreateLocation setAlwaysOpen (Boolean alwaysOpen) {
      this.setParam("always_open", alwaysOpen);
      return this;
    }
    public APIRequestCreateLocation setAlwaysOpen (String alwaysOpen) {
      this.setParam("always_open", alwaysOpen);
      return this;
    }

    public APIRequestCreateLocation setStoreCode (String storeCode) {
      this.setParam("store_code", storeCode);
      return this;
    }

    public APIRequestCreateLocation requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateLocation requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLocation requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateLocation requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateLocation requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateLocation requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetMediaFingerprints extends APIRequest<MediaFingerprint> {

    APINodeList<MediaFingerprint> lastResponse = null;
    @Override
    public APINodeList<MediaFingerprint> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "universal_content_id",
      "fingerprint_validity",
    };

    public static final String[] FIELDS = {
      "duration_in_sec",
      "expiration_time",
      "fingerprint_content_type",
      "fingerprint_type",
      "fingerprint_validity",
      "id",
      "metadata",
      "title",
      "universal_content_id",
    };

    @Override
    public APINodeList<MediaFingerprint> parseResponse(String response) throws APIException {
      return MediaFingerprint.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<MediaFingerprint> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<MediaFingerprint> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<MediaFingerprint>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<MediaFingerprint>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<MediaFingerprint>>() {
           public APINodeList<MediaFingerprint> apply(String result) {
             try {
               return APIRequestGetMediaFingerprints.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetMediaFingerprints(String nodeId, APIContext context) {
      super(context, nodeId, "/media_fingerprints", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetMediaFingerprints setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetMediaFingerprints setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetMediaFingerprints setUniversalContentId (String universalContentId) {
      this.setParam("universal_content_id", universalContentId);
      return this;
    }

    public APIRequestGetMediaFingerprints setFingerprintValidity (MediaFingerprint.EnumFingerprintValidity fingerprintValidity) {
      this.setParam("fingerprint_validity", fingerprintValidity);
      return this;
    }
    public APIRequestGetMediaFingerprints setFingerprintValidity (String fingerprintValidity) {
      this.setParam("fingerprint_validity", fingerprintValidity);
      return this;
    }

    public APIRequestGetMediaFingerprints requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetMediaFingerprints requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetMediaFingerprints requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetMediaFingerprints requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetMediaFingerprints requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetMediaFingerprints requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetMediaFingerprints requestDurationInSecField () {
      return this.requestDurationInSecField(true);
    }
    public APIRequestGetMediaFingerprints requestDurationInSecField (boolean value) {
      this.requestField("duration_in_sec", value);
      return this;
    }
    public APIRequestGetMediaFingerprints requestExpirationTimeField () {
      return this.requestExpirationTimeField(true);
    }
    public APIRequestGetMediaFingerprints requestExpirationTimeField (boolean value) {
      this.requestField("expiration_time", value);
      return this;
    }
    public APIRequestGetMediaFingerprints requestFingerprintContentTypeField () {
      return this.requestFingerprintContentTypeField(true);
    }
    public APIRequestGetMediaFingerprints requestFingerprintContentTypeField (boolean value) {
      this.requestField("fingerprint_content_type", value);
      return this;
    }
    public APIRequestGetMediaFingerprints requestFingerprintTypeField () {
      return this.requestFingerprintTypeField(true);
    }
    public APIRequestGetMediaFingerprints requestFingerprintTypeField (boolean value) {
      this.requestField("fingerprint_type", value);
      return this;
    }
    public APIRequestGetMediaFingerprints requestFingerprintValidityField () {
      return this.requestFingerprintValidityField(true);
    }
    public APIRequestGetMediaFingerprints requestFingerprintValidityField (boolean value) {
      this.requestField("fingerprint_validity", value);
      return this;
    }
    public APIRequestGetMediaFingerprints requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetMediaFingerprints requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetMediaFingerprints requestMetadataField () {
      return this.requestMetadataField(true);
    }
    public APIRequestGetMediaFingerprints requestMetadataField (boolean value) {
      this.requestField("metadata", value);
      return this;
    }
    public APIRequestGetMediaFingerprints requestTitleField () {
      return this.requestTitleField(true);
    }
    public APIRequestGetMediaFingerprints requestTitleField (boolean value) {
      this.requestField("title", value);
      return this;
    }
    public APIRequestGetMediaFingerprints requestUniversalContentIdField () {
      return this.requestUniversalContentIdField(true);
    }
    public APIRequestGetMediaFingerprints requestUniversalContentIdField (boolean value) {
      this.requestField("universal_content_id", value);
      return this;
    }
  }

  public static class APIRequestCreateMediaFingerprint extends APIRequest<MediaFingerprint> {

    MediaFingerprint lastResponse = null;
    @Override
    public MediaFingerprint getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "fingerprint_content_type",
      "title",
      "metadata",
      "universal_content_id",
      "source",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public MediaFingerprint parseResponse(String response) throws APIException {
      return MediaFingerprint.parseResponse(response, getContext(), this).head();
    }

    @Override
    public MediaFingerprint execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public MediaFingerprint execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<MediaFingerprint> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<MediaFingerprint> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, MediaFingerprint>() {
           public MediaFingerprint apply(String result) {
             try {
               return APIRequestCreateMediaFingerprint.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateMediaFingerprint(String nodeId, APIContext context) {
      super(context, nodeId, "/media_fingerprints", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateMediaFingerprint setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateMediaFingerprint setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateMediaFingerprint setFingerprintContentType (MediaFingerprint.EnumFingerprintContentType fingerprintContentType) {
      this.setParam("fingerprint_content_type", fingerprintContentType);
      return this;
    }
    public APIRequestCreateMediaFingerprint setFingerprintContentType (String fingerprintContentType) {
      this.setParam("fingerprint_content_type", fingerprintContentType);
      return this;
    }

    public APIRequestCreateMediaFingerprint setTitle (String title) {
      this.setParam("title", title);
      return this;
    }

    public APIRequestCreateMediaFingerprint setMetadata (Object metadata) {
      this.setParam("metadata", metadata);
      return this;
    }
    public APIRequestCreateMediaFingerprint setMetadata (String metadata) {
      this.setParam("metadata", metadata);
      return this;
    }

    public APIRequestCreateMediaFingerprint setUniversalContentId (String universalContentId) {
      this.setParam("universal_content_id", universalContentId);
      return this;
    }

    public APIRequestCreateMediaFingerprint setSource (String source) {
      this.setParam("source", source);
      return this;
    }

    public APIRequestCreateMediaFingerprint requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateMediaFingerprint requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMediaFingerprint requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateMediaFingerprint requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMediaFingerprint requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateMediaFingerprint requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestCreateMessageAttachment extends APIRequest<APINode> {

    APINode lastResponse = null;
    @Override
    public APINode getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "message",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINode parseResponse(String response) throws APIException {
      return APINode.parseResponse(response, getContext(), this).head();
    }

    @Override
    public APINode execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINode execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINode> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINode>() {
           public APINode apply(String result) {
             try {
               return APIRequestCreateMessageAttachment.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateMessageAttachment(String nodeId, APIContext context) {
      super(context, nodeId, "/message_attachments", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateMessageAttachment setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateMessageAttachment setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateMessageAttachment setMessage (Object message) {
      this.setParam("message", message);
      return this;
    }
    public APIRequestCreateMessageAttachment setMessage (String message) {
      this.setParam("message", message);
      return this;
    }

    public APIRequestCreateMessageAttachment requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateMessageAttachment requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMessageAttachment requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateMessageAttachment requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMessageAttachment requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateMessageAttachment requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestCreateMessageCreative extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "messages",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response) throws APIException {
      return Page.parseResponse(response, getContext(), this).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, Page>() {
           public Page apply(String result) {
             try {
               return APIRequestCreateMessageCreative.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateMessageCreative(String nodeId, APIContext context) {
      super(context, nodeId, "/message_creatives", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateMessageCreative setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateMessageCreative setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateMessageCreative setMessages (List<Object> messages) {
      this.setParam("messages", messages);
      return this;
    }
    public APIRequestCreateMessageCreative setMessages (String messages) {
      this.setParam("messages", messages);
      return this;
    }

    public APIRequestCreateMessageCreative requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateMessageCreative requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMessageCreative requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateMessageCreative requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMessageCreative requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateMessageCreative requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestCreateMessage extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "recipient",
      "message",
      "sender_action",
      "notification_type",
      "tag",
      "messaging_type",
      "persona_id",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response) throws APIException {
      return Page.parseResponse(response, getContext(), this).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, Page>() {
           public Page apply(String result) {
             try {
               return APIRequestCreateMessage.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateMessage(String nodeId, APIContext context) {
      super(context, nodeId, "/messages", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateMessage setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateMessage setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateMessage setRecipient (Object recipient) {
      this.setParam("recipient", recipient);
      return this;
    }
    public APIRequestCreateMessage setRecipient (String recipient) {
      this.setParam("recipient", recipient);
      return this;
    }

    public APIRequestCreateMessage setMessage (Object message) {
      this.setParam("message", message);
      return this;
    }
    public APIRequestCreateMessage setMessage (String message) {
      this.setParam("message", message);
      return this;
    }

    public APIRequestCreateMessage setSenderAction (Page.EnumSenderAction senderAction) {
      this.setParam("sender_action", senderAction);
      return this;
    }
    public APIRequestCreateMessage setSenderAction (String senderAction) {
      this.setParam("sender_action", senderAction);
      return this;
    }

    public APIRequestCreateMessage setNotificationType (Page.EnumNotificationType notificationType) {
      this.setParam("notification_type", notificationType);
      return this;
    }
    public APIRequestCreateMessage setNotificationType (String notificationType) {
      this.setParam("notification_type", notificationType);
      return this;
    }

    public APIRequestCreateMessage setTag (Object tag) {
      this.setParam("tag", tag);
      return this;
    }
    public APIRequestCreateMessage setTag (String tag) {
      this.setParam("tag", tag);
      return this;
    }

    public APIRequestCreateMessage setMessagingType (Page.EnumMessagingType messagingType) {
      this.setParam("messaging_type", messagingType);
      return this;
    }
    public APIRequestCreateMessage setMessagingType (String messagingType) {
      this.setParam("messaging_type", messagingType);
      return this;
    }

    public APIRequestCreateMessage setPersonaId (Object personaId) {
      this.setParam("persona_id", personaId);
      return this;
    }
    public APIRequestCreateMessage setPersonaId (String personaId) {
      this.setParam("persona_id", personaId);
      return this;
    }

    public APIRequestCreateMessage requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateMessage requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMessage requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateMessage requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMessage requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateMessage requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetMessagingFeatureReview extends APIRequest<MessagingFeatureReview> {

    APINodeList<MessagingFeatureReview> lastResponse = null;
    @Override
    public APINodeList<MessagingFeatureReview> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "feature",
      "status",
      "id",
    };

    @Override
    public APINodeList<MessagingFeatureReview> parseResponse(String response) throws APIException {
      return MessagingFeatureReview.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<MessagingFeatureReview> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<MessagingFeatureReview> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<MessagingFeatureReview>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<MessagingFeatureReview>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<MessagingFeatureReview>>() {
           public APINodeList<MessagingFeatureReview> apply(String result) {
             try {
               return APIRequestGetMessagingFeatureReview.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetMessagingFeatureReview(String nodeId, APIContext context) {
      super(context, nodeId, "/messaging_feature_review", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetMessagingFeatureReview setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetMessagingFeatureReview setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetMessagingFeatureReview requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetMessagingFeatureReview requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetMessagingFeatureReview requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetMessagingFeatureReview requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetMessagingFeatureReview requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetMessagingFeatureReview requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetMessagingFeatureReview requestFeatureField () {
      return this.requestFeatureField(true);
    }
    public APIRequestGetMessagingFeatureReview requestFeatureField (boolean value) {
      this.requestField("feature", value);
      return this;
    }
    public APIRequestGetMessagingFeatureReview requestStatusField () {
      return this.requestStatusField(true);
    }
    public APIRequestGetMessagingFeatureReview requestStatusField (boolean value) {
      this.requestField("status", value);
      return this;
    }
    public APIRequestGetMessagingFeatureReview requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetMessagingFeatureReview requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
  }

  public static class APIRequestGetMessengerAdsPageWelcomeMessages extends APIRequest<MessengerDestinationPageWelcomeMessage> {

    APINodeList<MessengerDestinationPageWelcomeMessage> lastResponse = null;
    @Override
    public APINodeList<MessengerDestinationPageWelcomeMessage> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "id",
      "page_welcome_message_body",
      "page_welcome_message_type",
      "template_name",
      "time_created",
      "time_last_used",
    };

    @Override
    public APINodeList<MessengerDestinationPageWelcomeMessage> parseResponse(String response) throws APIException {
      return MessengerDestinationPageWelcomeMessage.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<MessengerDestinationPageWelcomeMessage> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<MessengerDestinationPageWelcomeMessage> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<MessengerDestinationPageWelcomeMessage>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<MessengerDestinationPageWelcomeMessage>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<MessengerDestinationPageWelcomeMessage>>() {
           public APINodeList<MessengerDestinationPageWelcomeMessage> apply(String result) {
             try {
               return APIRequestGetMessengerAdsPageWelcomeMessages.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetMessengerAdsPageWelcomeMessages(String nodeId, APIContext context) {
      super(context, nodeId, "/messenger_ads_page_welcome_messages", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetMessengerAdsPageWelcomeMessages setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetMessengerAdsPageWelcomeMessages setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetMessengerAdsPageWelcomeMessages requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetMessengerAdsPageWelcomeMessages requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetMessengerAdsPageWelcomeMessages requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetMessengerAdsPageWelcomeMessages requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetMessengerAdsPageWelcomeMessages requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetMessengerAdsPageWelcomeMessages requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetMessengerAdsPageWelcomeMessages requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetMessengerAdsPageWelcomeMessages requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetMessengerAdsPageWelcomeMessages requestPageWelcomeMessageBodyField () {
      return this.requestPageWelcomeMessageBodyField(true);
    }
    public APIRequestGetMessengerAdsPageWelcomeMessages requestPageWelcomeMessageBodyField (boolean value) {
      this.requestField("page_welcome_message_body", value);
      return this;
    }
    public APIRequestGetMessengerAdsPageWelcomeMessages requestPageWelcomeMessageTypeField () {
      return this.requestPageWelcomeMessageTypeField(true);
    }
    public APIRequestGetMessengerAdsPageWelcomeMessages requestPageWelcomeMessageTypeField (boolean value) {
      this.requestField("page_welcome_message_type", value);
      return this;
    }
    public APIRequestGetMessengerAdsPageWelcomeMessages requestTemplateNameField () {
      return this.requestTemplateNameField(true);
    }
    public APIRequestGetMessengerAdsPageWelcomeMessages requestTemplateNameField (boolean value) {
      this.requestField("template_name", value);
      return this;
    }
    public APIRequestGetMessengerAdsPageWelcomeMessages requestTimeCreatedField () {
      return this.requestTimeCreatedField(true);
    }
    public APIRequestGetMessengerAdsPageWelcomeMessages requestTimeCreatedField (boolean value) {
      this.requestField("time_created", value);
      return this;
    }
    public APIRequestGetMessengerAdsPageWelcomeMessages requestTimeLastUsedField () {
      return this.requestTimeLastUsedField(true);
    }
    public APIRequestGetMessengerAdsPageWelcomeMessages requestTimeLastUsedField (boolean value) {
      this.requestField("time_last_used", value);
      return this;
    }
  }

  public static class APIRequestCreateMessengerCode extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "type",
      "data",
      "image_size",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response) throws APIException {
      return Page.parseResponse(response, getContext(), this).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, Page>() {
           public Page apply(String result) {
             try {
               return APIRequestCreateMessengerCode.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateMessengerCode(String nodeId, APIContext context) {
      super(context, nodeId, "/messenger_codes", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateMessengerCode setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateMessengerCode setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateMessengerCode setType (Page.EnumType type) {
      this.setParam("type", type);
      return this;
    }
    public APIRequestCreateMessengerCode setType (String type) {
      this.setParam("type", type);
      return this;
    }

    public APIRequestCreateMessengerCode setData (String data) {
      this.setParam("data", data);
      return this;
    }

    public APIRequestCreateMessengerCode setImageSize (Long imageSize) {
      this.setParam("image_size", imageSize);
      return this;
    }
    public APIRequestCreateMessengerCode setImageSize (String imageSize) {
      this.setParam("image_size", imageSize);
      return this;
    }

    public APIRequestCreateMessengerCode requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateMessengerCode requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMessengerCode requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateMessengerCode requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMessengerCode requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateMessengerCode requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestDeleteMessengerProfile extends APIRequest<APINode> {

    APINodeList<APINode> lastResponse = null;
    @Override
    public APINodeList<APINode> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "fields",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINodeList<APINode> parseResponse(String response) throws APIException {
      return APINode.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<APINode> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<APINode>>() {
           public APINodeList<APINode> apply(String result) {
             try {
               return APIRequestDeleteMessengerProfile.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestDeleteMessengerProfile(String nodeId, APIContext context) {
      super(context, nodeId, "/messenger_profile", "DELETE", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestDeleteMessengerProfile setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestDeleteMessengerProfile setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestDeleteMessengerProfile setFields (List<EnumFields> fields) {
      this.setParam("fields", fields);
      return this;
    }
    public APIRequestDeleteMessengerProfile setFields (String fields) {
      this.setParam("fields", fields);
      return this;
    }

    public APIRequestDeleteMessengerProfile requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestDeleteMessengerProfile requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteMessengerProfile requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestDeleteMessengerProfile requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteMessengerProfile requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestDeleteMessengerProfile requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetMessengerProfile extends APIRequest<MessengerProfile> {

    APINodeList<MessengerProfile> lastResponse = null;
    @Override
    public APINodeList<MessengerProfile> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "account_linking_url",
      "get_started",
      "greeting",
      "home_url",
      "payment_settings",
      "persistent_menu",
      "target_audience",
      "whitelisted_domains",
      "id",
    };

    @Override
    public APINodeList<MessengerProfile> parseResponse(String response) throws APIException {
      return MessengerProfile.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<MessengerProfile> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<MessengerProfile> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<MessengerProfile>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<MessengerProfile>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<MessengerProfile>>() {
           public APINodeList<MessengerProfile> apply(String result) {
             try {
               return APIRequestGetMessengerProfile.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetMessengerProfile(String nodeId, APIContext context) {
      super(context, nodeId, "/messenger_profile", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetMessengerProfile setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetMessengerProfile setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetMessengerProfile requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetMessengerProfile requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetMessengerProfile requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetMessengerProfile requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetMessengerProfile requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetMessengerProfile requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetMessengerProfile requestAccountLinkingUrlField () {
      return this.requestAccountLinkingUrlField(true);
    }
    public APIRequestGetMessengerProfile requestAccountLinkingUrlField (boolean value) {
      this.requestField("account_linking_url", value);
      return this;
    }
    public APIRequestGetMessengerProfile requestGetStartedField () {
      return this.requestGetStartedField(true);
    }
    public APIRequestGetMessengerProfile requestGetStartedField (boolean value) {
      this.requestField("get_started", value);
      return this;
    }
    public APIRequestGetMessengerProfile requestGreetingField () {
      return this.requestGreetingField(true);
    }
    public APIRequestGetMessengerProfile requestGreetingField (boolean value) {
      this.requestField("greeting", value);
      return this;
    }
    public APIRequestGetMessengerProfile requestHomeUrlField () {
      return this.requestHomeUrlField(true);
    }
    public APIRequestGetMessengerProfile requestHomeUrlField (boolean value) {
      this.requestField("home_url", value);
      return this;
    }
    public APIRequestGetMessengerProfile requestPaymentSettingsField () {
      return this.requestPaymentSettingsField(true);
    }
    public APIRequestGetMessengerProfile requestPaymentSettingsField (boolean value) {
      this.requestField("payment_settings", value);
      return this;
    }
    public APIRequestGetMessengerProfile requestPersistentMenuField () {
      return this.requestPersistentMenuField(true);
    }
    public APIRequestGetMessengerProfile requestPersistentMenuField (boolean value) {
      this.requestField("persistent_menu", value);
      return this;
    }
    public APIRequestGetMessengerProfile requestTargetAudienceField () {
      return this.requestTargetAudienceField(true);
    }
    public APIRequestGetMessengerProfile requestTargetAudienceField (boolean value) {
      this.requestField("target_audience", value);
      return this;
    }
    public APIRequestGetMessengerProfile requestWhitelistedDomainsField () {
      return this.requestWhitelistedDomainsField(true);
    }
    public APIRequestGetMessengerProfile requestWhitelistedDomainsField (boolean value) {
      this.requestField("whitelisted_domains", value);
      return this;
    }
    public APIRequestGetMessengerProfile requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetMessengerProfile requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
  }

  public static class APIRequestCreateMessengerProfile extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "get_started",
      "persistent_menu",
      "target_audience",
      "whitelisted_domains",
      "greeting",
      "account_linking_url",
      "payment_settings",
      "home_url",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response) throws APIException {
      return Page.parseResponse(response, getContext(), this).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, Page>() {
           public Page apply(String result) {
             try {
               return APIRequestCreateMessengerProfile.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateMessengerProfile(String nodeId, APIContext context) {
      super(context, nodeId, "/messenger_profile", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateMessengerProfile setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateMessengerProfile setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateMessengerProfile setGetStarted (Object getStarted) {
      this.setParam("get_started", getStarted);
      return this;
    }
    public APIRequestCreateMessengerProfile setGetStarted (String getStarted) {
      this.setParam("get_started", getStarted);
      return this;
    }

    public APIRequestCreateMessengerProfile setPersistentMenu (List<Object> persistentMenu) {
      this.setParam("persistent_menu", persistentMenu);
      return this;
    }
    public APIRequestCreateMessengerProfile setPersistentMenu (String persistentMenu) {
      this.setParam("persistent_menu", persistentMenu);
      return this;
    }

    public APIRequestCreateMessengerProfile setTargetAudience (Object targetAudience) {
      this.setParam("target_audience", targetAudience);
      return this;
    }
    public APIRequestCreateMessengerProfile setTargetAudience (String targetAudience) {
      this.setParam("target_audience", targetAudience);
      return this;
    }

    public APIRequestCreateMessengerProfile setWhitelistedDomains (List<String> whitelistedDomains) {
      this.setParam("whitelisted_domains", whitelistedDomains);
      return this;
    }
    public APIRequestCreateMessengerProfile setWhitelistedDomains (String whitelistedDomains) {
      this.setParam("whitelisted_domains", whitelistedDomains);
      return this;
    }

    public APIRequestCreateMessengerProfile setGreeting (List<Object> greeting) {
      this.setParam("greeting", greeting);
      return this;
    }
    public APIRequestCreateMessengerProfile setGreeting (String greeting) {
      this.setParam("greeting", greeting);
      return this;
    }

    public APIRequestCreateMessengerProfile setAccountLinkingUrl (String accountLinkingUrl) {
      this.setParam("account_linking_url", accountLinkingUrl);
      return this;
    }

    public APIRequestCreateMessengerProfile setPaymentSettings (Object paymentSettings) {
      this.setParam("payment_settings", paymentSettings);
      return this;
    }
    public APIRequestCreateMessengerProfile setPaymentSettings (String paymentSettings) {
      this.setParam("payment_settings", paymentSettings);
      return this;
    }

    public APIRequestCreateMessengerProfile setHomeUrl (Object homeUrl) {
      this.setParam("home_url", homeUrl);
      return this;
    }
    public APIRequestCreateMessengerProfile setHomeUrl (String homeUrl) {
      this.setParam("home_url", homeUrl);
      return this;
    }

    public APIRequestCreateMessengerProfile requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateMessengerProfile requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMessengerProfile requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateMessengerProfile requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMessengerProfile requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateMessengerProfile requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetMilestones extends APIRequest<LifeEvent> {

    APINodeList<LifeEvent> lastResponse = null;
    @Override
    public APINodeList<LifeEvent> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "created_time",
      "description",
      "end_time",
      "from",
      "id",
      "is_hidden",
      "start_time",
      "title",
      "updated_time",
    };

    @Override
    public APINodeList<LifeEvent> parseResponse(String response) throws APIException {
      return LifeEvent.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<LifeEvent> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<LifeEvent> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<LifeEvent>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<LifeEvent>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<LifeEvent>>() {
           public APINodeList<LifeEvent> apply(String result) {
             try {
               return APIRequestGetMilestones.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetMilestones(String nodeId, APIContext context) {
      super(context, nodeId, "/milestones", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetMilestones setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetMilestones setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetMilestones requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetMilestones requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetMilestones requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetMilestones requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetMilestones requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetMilestones requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetMilestones requestCreatedTimeField () {
      return this.requestCreatedTimeField(true);
    }
    public APIRequestGetMilestones requestCreatedTimeField (boolean value) {
      this.requestField("created_time", value);
      return this;
    }
    public APIRequestGetMilestones requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetMilestones requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetMilestones requestEndTimeField () {
      return this.requestEndTimeField(true);
    }
    public APIRequestGetMilestones requestEndTimeField (boolean value) {
      this.requestField("end_time", value);
      return this;
    }
    public APIRequestGetMilestones requestFromField () {
      return this.requestFromField(true);
    }
    public APIRequestGetMilestones requestFromField (boolean value) {
      this.requestField("from", value);
      return this;
    }
    public APIRequestGetMilestones requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetMilestones requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetMilestones requestIsHiddenField () {
      return this.requestIsHiddenField(true);
    }
    public APIRequestGetMilestones requestIsHiddenField (boolean value) {
      this.requestField("is_hidden", value);
      return this;
    }
    public APIRequestGetMilestones requestStartTimeField () {
      return this.requestStartTimeField(true);
    }
    public APIRequestGetMilestones requestStartTimeField (boolean value) {
      this.requestField("start_time", value);
      return this;
    }
    public APIRequestGetMilestones requestTitleField () {
      return this.requestTitleField(true);
    }
    public APIRequestGetMilestones requestTitleField (boolean value) {
      this.requestField("title", value);
      return this;
    }
    public APIRequestGetMilestones requestUpdatedTimeField () {
      return this.requestUpdatedTimeField(true);
    }
    public APIRequestGetMilestones requestUpdatedTimeField (boolean value) {
      this.requestField("updated_time", value);
      return this;
    }
  }

  public static class APIRequestCreateMilestone extends APIRequest<LifeEvent> {

    LifeEvent lastResponse = null;
    @Override
    public LifeEvent getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "title",
      "description",
      "start_time",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public LifeEvent parseResponse(String response) throws APIException {
      return LifeEvent.parseResponse(response, getContext(), this).head();
    }

    @Override
    public LifeEvent execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public LifeEvent execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<LifeEvent> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<LifeEvent> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, LifeEvent>() {
           public LifeEvent apply(String result) {
             try {
               return APIRequestCreateMilestone.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateMilestone(String nodeId, APIContext context) {
      super(context, nodeId, "/milestones", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateMilestone setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateMilestone setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateMilestone setTitle (String title) {
      this.setParam("title", title);
      return this;
    }

    public APIRequestCreateMilestone setDescription (String description) {
      this.setParam("description", description);
      return this;
    }

    public APIRequestCreateMilestone setStartTime (String startTime) {
      this.setParam("start_time", startTime);
      return this;
    }

    public APIRequestCreateMilestone requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateMilestone requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMilestone requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateMilestone requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateMilestone requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateMilestone requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetMusicVideoCopyrights extends APIRequest<MusicVideoCopyright> {

    APINodeList<MusicVideoCopyright> lastResponse = null;
    @Override
    public APINodeList<MusicVideoCopyright> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "creation_time",
      "displayed_matches_count",
      "id",
      "in_conflict",
      "isrc",
      "match_rule",
      "ownership_countries",
      "reference_file_status",
      "ridge_monitoring_status",
      "update_time",
      "video_asset",
      "whitelisted_fb_users",
      "whitelisted_ig_users",
    };

    @Override
    public APINodeList<MusicVideoCopyright> parseResponse(String response) throws APIException {
      return MusicVideoCopyright.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<MusicVideoCopyright> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<MusicVideoCopyright> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<MusicVideoCopyright>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<MusicVideoCopyright>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<MusicVideoCopyright>>() {
           public APINodeList<MusicVideoCopyright> apply(String result) {
             try {
               return APIRequestGetMusicVideoCopyrights.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetMusicVideoCopyrights(String nodeId, APIContext context) {
      super(context, nodeId, "/music_video_copyrights", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetMusicVideoCopyrights setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetMusicVideoCopyrights setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetMusicVideoCopyrights requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetMusicVideoCopyrights requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetMusicVideoCopyrights requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetMusicVideoCopyrights requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetMusicVideoCopyrights requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetMusicVideoCopyrights requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetMusicVideoCopyrights requestCreationTimeField () {
      return this.requestCreationTimeField(true);
    }
    public APIRequestGetMusicVideoCopyrights requestCreationTimeField (boolean value) {
      this.requestField("creation_time", value);
      return this;
    }
    public APIRequestGetMusicVideoCopyrights requestDisplayedMatchesCountField () {
      return this.requestDisplayedMatchesCountField(true);
    }
    public APIRequestGetMusicVideoCopyrights requestDisplayedMatchesCountField (boolean value) {
      this.requestField("displayed_matches_count", value);
      return this;
    }
    public APIRequestGetMusicVideoCopyrights requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetMusicVideoCopyrights requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetMusicVideoCopyrights requestInConflictField () {
      return this.requestInConflictField(true);
    }
    public APIRequestGetMusicVideoCopyrights requestInConflictField (boolean value) {
      this.requestField("in_conflict", value);
      return this;
    }
    public APIRequestGetMusicVideoCopyrights requestIsrcField () {
      return this.requestIsrcField(true);
    }
    public APIRequestGetMusicVideoCopyrights requestIsrcField (boolean value) {
      this.requestField("isrc", value);
      return this;
    }
    public APIRequestGetMusicVideoCopyrights requestMatchRuleField () {
      return this.requestMatchRuleField(true);
    }
    public APIRequestGetMusicVideoCopyrights requestMatchRuleField (boolean value) {
      this.requestField("match_rule", value);
      return this;
    }
    public APIRequestGetMusicVideoCopyrights requestOwnershipCountriesField () {
      return this.requestOwnershipCountriesField(true);
    }
    public APIRequestGetMusicVideoCopyrights requestOwnershipCountriesField (boolean value) {
      this.requestField("ownership_countries", value);
      return this;
    }
    public APIRequestGetMusicVideoCopyrights requestReferenceFileStatusField () {
      return this.requestReferenceFileStatusField(true);
    }
    public APIRequestGetMusicVideoCopyrights requestReferenceFileStatusField (boolean value) {
      this.requestField("reference_file_status", value);
      return this;
    }
    public APIRequestGetMusicVideoCopyrights requestRidgeMonitoringStatusField () {
      return this.requestRidgeMonitoringStatusField(true);
    }
    public APIRequestGetMusicVideoCopyrights requestRidgeMonitoringStatusField (boolean value) {
      this.requestField("ridge_monitoring_status", value);
      return this;
    }
    public APIRequestGetMusicVideoCopyrights requestUpdateTimeField () {
      return this.requestUpdateTimeField(true);
    }
    public APIRequestGetMusicVideoCopyrights requestUpdateTimeField (boolean value) {
      this.requestField("update_time", value);
      return this;
    }
    public APIRequestGetMusicVideoCopyrights requestVideoAssetField () {
      return this.requestVideoAssetField(true);
    }
    public APIRequestGetMusicVideoCopyrights requestVideoAssetField (boolean value) {
      this.requestField("video_asset", value);
      return this;
    }
    public APIRequestGetMusicVideoCopyrights requestWhitelistedFbUsersField () {
      return this.requestWhitelistedFbUsersField(true);
    }
    public APIRequestGetMusicVideoCopyrights requestWhitelistedFbUsersField (boolean value) {
      this.requestField("whitelisted_fb_users", value);
      return this;
    }
    public APIRequestGetMusicVideoCopyrights requestWhitelistedIgUsersField () {
      return this.requestWhitelistedIgUsersField(true);
    }
    public APIRequestGetMusicVideoCopyrights requestWhitelistedIgUsersField (boolean value) {
      this.requestField("whitelisted_ig_users", value);
      return this;
    }
  }

  public static class APIRequestGetMusicVideoMediaCopyrights extends APIRequest<MusicVideoCopyright> {

    APINodeList<MusicVideoCopyright> lastResponse = null;
    @Override
    public APINodeList<MusicVideoCopyright> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "creation_time",
      "displayed_matches_count",
      "id",
      "in_conflict",
      "isrc",
      "match_rule",
      "ownership_countries",
      "reference_file_status",
      "ridge_monitoring_status",
      "update_time",
      "video_asset",
      "whitelisted_fb_users",
      "whitelisted_ig_users",
    };

    @Override
    public APINodeList<MusicVideoCopyright> parseResponse(String response) throws APIException {
      return MusicVideoCopyright.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<MusicVideoCopyright> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<MusicVideoCopyright> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<MusicVideoCopyright>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<MusicVideoCopyright>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<MusicVideoCopyright>>() {
           public APINodeList<MusicVideoCopyright> apply(String result) {
             try {
               return APIRequestGetMusicVideoMediaCopyrights.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetMusicVideoMediaCopyrights(String nodeId, APIContext context) {
      super(context, nodeId, "/music_video_media_copyrights", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetMusicVideoMediaCopyrights setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetMusicVideoMediaCopyrights setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetMusicVideoMediaCopyrights requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetMusicVideoMediaCopyrights requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetMusicVideoMediaCopyrights requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetMusicVideoMediaCopyrights requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetMusicVideoMediaCopyrights requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetMusicVideoMediaCopyrights requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetMusicVideoMediaCopyrights requestCreationTimeField () {
      return this.requestCreationTimeField(true);
    }
    public APIRequestGetMusicVideoMediaCopyrights requestCreationTimeField (boolean value) {
      this.requestField("creation_time", value);
      return this;
    }
    public APIRequestGetMusicVideoMediaCopyrights requestDisplayedMatchesCountField () {
      return this.requestDisplayedMatchesCountField(true);
    }
    public APIRequestGetMusicVideoMediaCopyrights requestDisplayedMatchesCountField (boolean value) {
      this.requestField("displayed_matches_count", value);
      return this;
    }
    public APIRequestGetMusicVideoMediaCopyrights requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetMusicVideoMediaCopyrights requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetMusicVideoMediaCopyrights requestInConflictField () {
      return this.requestInConflictField(true);
    }
    public APIRequestGetMusicVideoMediaCopyrights requestInConflictField (boolean value) {
      this.requestField("in_conflict", value);
      return this;
    }
    public APIRequestGetMusicVideoMediaCopyrights requestIsrcField () {
      return this.requestIsrcField(true);
    }
    public APIRequestGetMusicVideoMediaCopyrights requestIsrcField (boolean value) {
      this.requestField("isrc", value);
      return this;
    }
    public APIRequestGetMusicVideoMediaCopyrights requestMatchRuleField () {
      return this.requestMatchRuleField(true);
    }
    public APIRequestGetMusicVideoMediaCopyrights requestMatchRuleField (boolean value) {
      this.requestField("match_rule", value);
      return this;
    }
    public APIRequestGetMusicVideoMediaCopyrights requestOwnershipCountriesField () {
      return this.requestOwnershipCountriesField(true);
    }
    public APIRequestGetMusicVideoMediaCopyrights requestOwnershipCountriesField (boolean value) {
      this.requestField("ownership_countries", value);
      return this;
    }
    public APIRequestGetMusicVideoMediaCopyrights requestReferenceFileStatusField () {
      return this.requestReferenceFileStatusField(true);
    }
    public APIRequestGetMusicVideoMediaCopyrights requestReferenceFileStatusField (boolean value) {
      this.requestField("reference_file_status", value);
      return this;
    }
    public APIRequestGetMusicVideoMediaCopyrights requestRidgeMonitoringStatusField () {
      return this.requestRidgeMonitoringStatusField(true);
    }
    public APIRequestGetMusicVideoMediaCopyrights requestRidgeMonitoringStatusField (boolean value) {
      this.requestField("ridge_monitoring_status", value);
      return this;
    }
    public APIRequestGetMusicVideoMediaCopyrights requestUpdateTimeField () {
      return this.requestUpdateTimeField(true);
    }
    public APIRequestGetMusicVideoMediaCopyrights requestUpdateTimeField (boolean value) {
      this.requestField("update_time", value);
      return this;
    }
    public APIRequestGetMusicVideoMediaCopyrights requestVideoAssetField () {
      return this.requestVideoAssetField(true);
    }
    public APIRequestGetMusicVideoMediaCopyrights requestVideoAssetField (boolean value) {
      this.requestField("video_asset", value);
      return this;
    }
    public APIRequestGetMusicVideoMediaCopyrights requestWhitelistedFbUsersField () {
      return this.requestWhitelistedFbUsersField(true);
    }
    public APIRequestGetMusicVideoMediaCopyrights requestWhitelistedFbUsersField (boolean value) {
      this.requestField("whitelisted_fb_users", value);
      return this;
    }
    public APIRequestGetMusicVideoMediaCopyrights requestWhitelistedIgUsersField () {
      return this.requestWhitelistedIgUsersField(true);
    }
    public APIRequestGetMusicVideoMediaCopyrights requestWhitelistedIgUsersField (boolean value) {
      this.requestField("whitelisted_ig_users", value);
      return this;
    }
  }

  public static class APIRequestGetNativeOffers extends APIRequest<NativeOffer> {

    APINodeList<NativeOffer> lastResponse = null;
    @Override
    public APINodeList<NativeOffer> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "barcode_photo",
      "barcode_photo_uri",
      "barcode_type",
      "barcode_value",
      "block_reshares",
      "details",
      "disable_location",
      "discounts",
      "expiration_time",
      "id",
      "instore_code",
      "location_type",
      "max_save_count",
      "online_code",
      "page",
      "page_set_id",
      "redemption_code",
      "redemption_link",
      "save_count",
      "terms",
      "title",
      "total_unique_codes",
      "unique_codes",
      "unique_codes_file_code_type",
      "unique_codes_file_name",
      "unique_codes_file_upload_status",
    };

    @Override
    public APINodeList<NativeOffer> parseResponse(String response) throws APIException {
      return NativeOffer.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<NativeOffer> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<NativeOffer> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<NativeOffer>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<NativeOffer>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<NativeOffer>>() {
           public APINodeList<NativeOffer> apply(String result) {
             try {
               return APIRequestGetNativeOffers.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetNativeOffers(String nodeId, APIContext context) {
      super(context, nodeId, "/nativeoffers", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetNativeOffers setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetNativeOffers setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetNativeOffers requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetNativeOffers requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetNativeOffers requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetNativeOffers requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetNativeOffers requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetNativeOffers requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetNativeOffers requestBarcodePhotoField () {
      return this.requestBarcodePhotoField(true);
    }
    public APIRequestGetNativeOffers requestBarcodePhotoField (boolean value) {
      this.requestField("barcode_photo", value);
      return this;
    }
    public APIRequestGetNativeOffers requestBarcodePhotoUriField () {
      return this.requestBarcodePhotoUriField(true);
    }
    public APIRequestGetNativeOffers requestBarcodePhotoUriField (boolean value) {
      this.requestField("barcode_photo_uri", value);
      return this;
    }
    public APIRequestGetNativeOffers requestBarcodeTypeField () {
      return this.requestBarcodeTypeField(true);
    }
    public APIRequestGetNativeOffers requestBarcodeTypeField (boolean value) {
      this.requestField("barcode_type", value);
      return this;
    }
    public APIRequestGetNativeOffers requestBarcodeValueField () {
      return this.requestBarcodeValueField(true);
    }
    public APIRequestGetNativeOffers requestBarcodeValueField (boolean value) {
      this.requestField("barcode_value", value);
      return this;
    }
    public APIRequestGetNativeOffers requestBlockResharesField () {
      return this.requestBlockResharesField(true);
    }
    public APIRequestGetNativeOffers requestBlockResharesField (boolean value) {
      this.requestField("block_reshares", value);
      return this;
    }
    public APIRequestGetNativeOffers requestDetailsField () {
      return this.requestDetailsField(true);
    }
    public APIRequestGetNativeOffers requestDetailsField (boolean value) {
      this.requestField("details", value);
      return this;
    }
    public APIRequestGetNativeOffers requestDisableLocationField () {
      return this.requestDisableLocationField(true);
    }
    public APIRequestGetNativeOffers requestDisableLocationField (boolean value) {
      this.requestField("disable_location", value);
      return this;
    }
    public APIRequestGetNativeOffers requestDiscountsField () {
      return this.requestDiscountsField(true);
    }
    public APIRequestGetNativeOffers requestDiscountsField (boolean value) {
      this.requestField("discounts", value);
      return this;
    }
    public APIRequestGetNativeOffers requestExpirationTimeField () {
      return this.requestExpirationTimeField(true);
    }
    public APIRequestGetNativeOffers requestExpirationTimeField (boolean value) {
      this.requestField("expiration_time", value);
      return this;
    }
    public APIRequestGetNativeOffers requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetNativeOffers requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetNativeOffers requestInstoreCodeField () {
      return this.requestInstoreCodeField(true);
    }
    public APIRequestGetNativeOffers requestInstoreCodeField (boolean value) {
      this.requestField("instore_code", value);
      return this;
    }
    public APIRequestGetNativeOffers requestLocationTypeField () {
      return this.requestLocationTypeField(true);
    }
    public APIRequestGetNativeOffers requestLocationTypeField (boolean value) {
      this.requestField("location_type", value);
      return this;
    }
    public APIRequestGetNativeOffers requestMaxSaveCountField () {
      return this.requestMaxSaveCountField(true);
    }
    public APIRequestGetNativeOffers requestMaxSaveCountField (boolean value) {
      this.requestField("max_save_count", value);
      return this;
    }
    public APIRequestGetNativeOffers requestOnlineCodeField () {
      return this.requestOnlineCodeField(true);
    }
    public APIRequestGetNativeOffers requestOnlineCodeField (boolean value) {
      this.requestField("online_code", value);
      return this;
    }
    public APIRequestGetNativeOffers requestPageField () {
      return this.requestPageField(true);
    }
    public APIRequestGetNativeOffers requestPageField (boolean value) {
      this.requestField("page", value);
      return this;
    }
    public APIRequestGetNativeOffers requestPageSetIdField () {
      return this.requestPageSetIdField(true);
    }
    public APIRequestGetNativeOffers requestPageSetIdField (boolean value) {
      this.requestField("page_set_id", value);
      return this;
    }
    public APIRequestGetNativeOffers requestRedemptionCodeField () {
      return this.requestRedemptionCodeField(true);
    }
    public APIRequestGetNativeOffers requestRedemptionCodeField (boolean value) {
      this.requestField("redemption_code", value);
      return this;
    }
    public APIRequestGetNativeOffers requestRedemptionLinkField () {
      return this.requestRedemptionLinkField(true);
    }
    public APIRequestGetNativeOffers requestRedemptionLinkField (boolean value) {
      this.requestField("redemption_link", value);
      return this;
    }
    public APIRequestGetNativeOffers requestSaveCountField () {
      return this.requestSaveCountField(true);
    }
    public APIRequestGetNativeOffers requestSaveCountField (boolean value) {
      this.requestField("save_count", value);
      return this;
    }
    public APIRequestGetNativeOffers requestTermsField () {
      return this.requestTermsField(true);
    }
    public APIRequestGetNativeOffers requestTermsField (boolean value) {
      this.requestField("terms", value);
      return this;
    }
    public APIRequestGetNativeOffers requestTitleField () {
      return this.requestTitleField(true);
    }
    public APIRequestGetNativeOffers requestTitleField (boolean value) {
      this.requestField("title", value);
      return this;
    }
    public APIRequestGetNativeOffers requestTotalUniqueCodesField () {
      return this.requestTotalUniqueCodesField(true);
    }
    public APIRequestGetNativeOffers requestTotalUniqueCodesField (boolean value) {
      this.requestField("total_unique_codes", value);
      return this;
    }
    public APIRequestGetNativeOffers requestUniqueCodesField () {
      return this.requestUniqueCodesField(true);
    }
    public APIRequestGetNativeOffers requestUniqueCodesField (boolean value) {
      this.requestField("unique_codes", value);
      return this;
    }
    public APIRequestGetNativeOffers requestUniqueCodesFileCodeTypeField () {
      return this.requestUniqueCodesFileCodeTypeField(true);
    }
    public APIRequestGetNativeOffers requestUniqueCodesFileCodeTypeField (boolean value) {
      this.requestField("unique_codes_file_code_type", value);
      return this;
    }
    public APIRequestGetNativeOffers requestUniqueCodesFileNameField () {
      return this.requestUniqueCodesFileNameField(true);
    }
    public APIRequestGetNativeOffers requestUniqueCodesFileNameField (boolean value) {
      this.requestField("unique_codes_file_name", value);
      return this;
    }
    public APIRequestGetNativeOffers requestUniqueCodesFileUploadStatusField () {
      return this.requestUniqueCodesFileUploadStatusField(true);
    }
    public APIRequestGetNativeOffers requestUniqueCodesFileUploadStatusField (boolean value) {
      this.requestField("unique_codes_file_upload_status", value);
      return this;
    }
  }

  public static class APIRequestCreateNativeOffer extends APIRequest<NativeOffer> {

    NativeOffer lastResponse = null;
    @Override
    public NativeOffer getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "discounts",
      "details",
      "terms",
      "redemption_code",
      "redemption_link",
      "max_save_count",
      "online_code",
      "instore_code",
      "expiration_time",
      "location_type",
      "barcode_type",
      "barcode_value",
      "barcode_photo",
      "unique_codes",
      "unique_barcodes",
      "block_reshares",
      "disable_location",
      "commerce_store",
      "commerce_store_collection",
      "commerce_product_item",
      "page_set_id",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public NativeOffer parseResponse(String response) throws APIException {
      return NativeOffer.parseResponse(response, getContext(), this).head();
    }

    @Override
    public NativeOffer execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public NativeOffer execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<NativeOffer> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<NativeOffer> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, NativeOffer>() {
           public NativeOffer apply(String result) {
             try {
               return APIRequestCreateNativeOffer.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateNativeOffer(String nodeId, APIContext context) {
      super(context, nodeId, "/nativeoffers", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateNativeOffer setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateNativeOffer setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateNativeOffer setDiscounts (List<Object> discounts) {
      this.setParam("discounts", discounts);
      return this;
    }
    public APIRequestCreateNativeOffer setDiscounts (String discounts) {
      this.setParam("discounts", discounts);
      return this;
    }

    public APIRequestCreateNativeOffer setDetails (String details) {
      this.setParam("details", details);
      return this;
    }

    public APIRequestCreateNativeOffer setTerms (String terms) {
      this.setParam("terms", terms);
      return this;
    }

    public APIRequestCreateNativeOffer setRedemptionCode (String redemptionCode) {
      this.setParam("redemption_code", redemptionCode);
      return this;
    }

    public APIRequestCreateNativeOffer setRedemptionLink (String redemptionLink) {
      this.setParam("redemption_link", redemptionLink);
      return this;
    }

    public APIRequestCreateNativeOffer setMaxSaveCount (Long maxSaveCount) {
      this.setParam("max_save_count", maxSaveCount);
      return this;
    }
    public APIRequestCreateNativeOffer setMaxSaveCount (String maxSaveCount) {
      this.setParam("max_save_count", maxSaveCount);
      return this;
    }

    public APIRequestCreateNativeOffer setOnlineCode (String onlineCode) {
      this.setParam("online_code", onlineCode);
      return this;
    }

    public APIRequestCreateNativeOffer setInstoreCode (String instoreCode) {
      this.setParam("instore_code", instoreCode);
      return this;
    }

    public APIRequestCreateNativeOffer setExpirationTime (String expirationTime) {
      this.setParam("expiration_time", expirationTime);
      return this;
    }

    public APIRequestCreateNativeOffer setLocationType (NativeOffer.EnumLocationType locationType) {
      this.setParam("location_type", locationType);
      return this;
    }
    public APIRequestCreateNativeOffer setLocationType (String locationType) {
      this.setParam("location_type", locationType);
      return this;
    }

    public APIRequestCreateNativeOffer setBarcodeType (NativeOffer.EnumBarcodeType barcodeType) {
      this.setParam("barcode_type", barcodeType);
      return this;
    }
    public APIRequestCreateNativeOffer setBarcodeType (String barcodeType) {
      this.setParam("barcode_type", barcodeType);
      return this;
    }

    public APIRequestCreateNativeOffer setBarcodeValue (String barcodeValue) {
      this.setParam("barcode_value", barcodeValue);
      return this;
    }

    public APIRequestCreateNativeOffer setBarcodePhoto (Long barcodePhoto) {
      this.setParam("barcode_photo", barcodePhoto);
      return this;
    }
    public APIRequestCreateNativeOffer setBarcodePhoto (String barcodePhoto) {
      this.setParam("barcode_photo", barcodePhoto);
      return this;
    }

    public APIRequestCreateNativeOffer setUniqueCodes (Long uniqueCodes) {
      this.setParam("unique_codes", uniqueCodes);
      return this;
    }
    public APIRequestCreateNativeOffer setUniqueCodes (String uniqueCodes) {
      this.setParam("unique_codes", uniqueCodes);
      return this;
    }

    public APIRequestCreateNativeOffer setUniqueBarcodes (Long uniqueBarcodes) {
      this.setParam("unique_barcodes", uniqueBarcodes);
      return this;
    }
    public APIRequestCreateNativeOffer setUniqueBarcodes (String uniqueBarcodes) {
      this.setParam("unique_barcodes", uniqueBarcodes);
      return this;
    }

    public APIRequestCreateNativeOffer setBlockReshares (Boolean blockReshares) {
      this.setParam("block_reshares", blockReshares);
      return this;
    }
    public APIRequestCreateNativeOffer setBlockReshares (String blockReshares) {
      this.setParam("block_reshares", blockReshares);
      return this;
    }

    public APIRequestCreateNativeOffer setDisableLocation (Boolean disableLocation) {
      this.setParam("disable_location", disableLocation);
      return this;
    }
    public APIRequestCreateNativeOffer setDisableLocation (String disableLocation) {
      this.setParam("disable_location", disableLocation);
      return this;
    }

    public APIRequestCreateNativeOffer setCommerceStore (String commerceStore) {
      this.setParam("commerce_store", commerceStore);
      return this;
    }

    public APIRequestCreateNativeOffer setCommerceStoreCollection (String commerceStoreCollection) {
      this.setParam("commerce_store_collection", commerceStoreCollection);
      return this;
    }

    public APIRequestCreateNativeOffer setCommerceProductItem (String commerceProductItem) {
      this.setParam("commerce_product_item", commerceProductItem);
      return this;
    }

    public APIRequestCreateNativeOffer setPageSetId (String pageSetId) {
      this.setParam("page_set_id", pageSetId);
      return this;
    }

    public APIRequestCreateNativeOffer requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateNativeOffer requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateNativeOffer requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateNativeOffer requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateNativeOffer requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateNativeOffer requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestCreateNlpConfig extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "nlp_enabled",
      "model",
      "custom_token",
      "n_best",
      "verbose",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response) throws APIException {
      return Page.parseResponse(response, getContext(), this).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, Page>() {
           public Page apply(String result) {
             try {
               return APIRequestCreateNlpConfig.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateNlpConfig(String nodeId, APIContext context) {
      super(context, nodeId, "/nlp_configs", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateNlpConfig setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateNlpConfig setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateNlpConfig setNlpEnabled (Boolean nlpEnabled) {
      this.setParam("nlp_enabled", nlpEnabled);
      return this;
    }
    public APIRequestCreateNlpConfig setNlpEnabled (String nlpEnabled) {
      this.setParam("nlp_enabled", nlpEnabled);
      return this;
    }

    public APIRequestCreateNlpConfig setModel (Page.EnumModel model) {
      this.setParam("model", model);
      return this;
    }
    public APIRequestCreateNlpConfig setModel (String model) {
      this.setParam("model", model);
      return this;
    }

    public APIRequestCreateNlpConfig setCustomToken (String customToken) {
      this.setParam("custom_token", customToken);
      return this;
    }

    public APIRequestCreateNlpConfig setNBest (Long nBest) {
      this.setParam("n_best", nBest);
      return this;
    }
    public APIRequestCreateNlpConfig setNBest (String nBest) {
      this.setParam("n_best", nBest);
      return this;
    }

    public APIRequestCreateNlpConfig setVerbose (Boolean verbose) {
      this.setParam("verbose", verbose);
      return this;
    }
    public APIRequestCreateNlpConfig setVerbose (String verbose) {
      this.setParam("verbose", verbose);
      return this;
    }

    public APIRequestCreateNlpConfig requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateNlpConfig requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateNlpConfig requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateNlpConfig requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateNlpConfig requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateNlpConfig requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestCreateNote extends APIRequest<APINode> {

    APINode lastResponse = null;
    @Override
    public APINode getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "message",
      "subject",
      "privacy",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINode parseResponse(String response) throws APIException {
      return APINode.parseResponse(response, getContext(), this).head();
    }

    @Override
    public APINode execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINode execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINode> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINode>() {
           public APINode apply(String result) {
             try {
               return APIRequestCreateNote.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateNote(String nodeId, APIContext context) {
      super(context, nodeId, "/notes", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateNote setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateNote setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateNote setMessage (String message) {
      this.setParam("message", message);
      return this;
    }

    public APIRequestCreateNote setSubject (String subject) {
      this.setParam("subject", subject);
      return this;
    }

    public APIRequestCreateNote setPrivacy (Object privacy) {
      this.setParam("privacy", privacy);
      return this;
    }
    public APIRequestCreateNote setPrivacy (String privacy) {
      this.setParam("privacy", privacy);
      return this;
    }

    public APIRequestCreateNote requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateNote requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateNote requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateNote requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateNote requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateNote requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestCreateNotification extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "seen",
      "read",
      "notif_ids",
      "filtering",
      "template",
      "href",
      "ref",
      "type",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response) throws APIException {
      return Page.parseResponse(response, getContext(), this).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, Page>() {
           public Page apply(String result) {
             try {
               return APIRequestCreateNotification.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateNotification(String nodeId, APIContext context) {
      super(context, nodeId, "/notifications", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateNotification setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateNotification setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateNotification setSeen (Boolean seen) {
      this.setParam("seen", seen);
      return this;
    }
    public APIRequestCreateNotification setSeen (String seen) {
      this.setParam("seen", seen);
      return this;
    }

    public APIRequestCreateNotification setRead (Boolean read) {
      this.setParam("read", read);
      return this;
    }
    public APIRequestCreateNotification setRead (String read) {
      this.setParam("read", read);
      return this;
    }

    public APIRequestCreateNotification setNotifIds (List<String> notifIds) {
      this.setParam("notif_ids", notifIds);
      return this;
    }
    public APIRequestCreateNotification setNotifIds (String notifIds) {
      this.setParam("notif_ids", notifIds);
      return this;
    }

    public APIRequestCreateNotification setFiltering (List<Page.EnumFiltering> filtering) {
      this.setParam("filtering", filtering);
      return this;
    }
    public APIRequestCreateNotification setFiltering (String filtering) {
      this.setParam("filtering", filtering);
      return this;
    }

    public APIRequestCreateNotification setTemplate (Object template) {
      this.setParam("template", template);
      return this;
    }
    public APIRequestCreateNotification setTemplate (String template) {
      this.setParam("template", template);
      return this;
    }

    public APIRequestCreateNotification setHref (Object href) {
      this.setParam("href", href);
      return this;
    }
    public APIRequestCreateNotification setHref (String href) {
      this.setParam("href", href);
      return this;
    }

    public APIRequestCreateNotification setRef (String ref) {
      this.setParam("ref", ref);
      return this;
    }

    public APIRequestCreateNotification setType (Page.EnumType type) {
      this.setParam("type", type);
      return this;
    }
    public APIRequestCreateNotification setType (String type) {
      this.setParam("type", type);
      return this;
    }

    public APIRequestCreateNotification requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateNotification requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateNotification requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateNotification requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateNotification requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateNotification requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestCreatePageBackedInstagramAccount extends APIRequest<APINode> {

    APINode lastResponse = null;
    @Override
    public APINode getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINode parseResponse(String response) throws APIException {
      return APINode.parseResponse(response, getContext(), this).head();
    }

    @Override
    public APINode execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINode execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINode> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINode>() {
           public APINode apply(String result) {
             try {
               return APIRequestCreatePageBackedInstagramAccount.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreatePageBackedInstagramAccount(String nodeId, APIContext context) {
      super(context, nodeId, "/page_backed_instagram_accounts", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreatePageBackedInstagramAccount setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreatePageBackedInstagramAccount setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreatePageBackedInstagramAccount requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreatePageBackedInstagramAccount requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreatePageBackedInstagramAccount requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreatePageBackedInstagramAccount requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreatePageBackedInstagramAccount requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreatePageBackedInstagramAccount requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestCreatePassThreadControl extends APIRequest<Page> {

    Page lastResponse = null;
    @Override
    public Page getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "recipient",
      "target_app_id",
      "metadata",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Page parseResponse(String response) throws APIException {
      return Page.parseResponse(response, getContext(), this).head();
    }

    @Override
    public Page execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Page execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<Page> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Page> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, Page>() {
           public Page apply(String result) {
             try {
               return APIRequestCreatePassThreadControl.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreatePassThreadControl(String nodeId, APIContext context) {
      super(context, nodeId, "/pass_thread_control", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreatePassThreadControl setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreatePassThreadControl setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreatePassThreadControl setRecipient (Object recipient) {
      this.setParam("recipient", recipient);
      return this;
    }
    public APIRequestCreatePassThreadControl setRecipient (String recipient) {
      this.setParam("recipient", recipient);
      return this;
    }

    public APIRequestCreatePassThreadControl setTargetAppId (Long targetAppId) {
      this.setParam("target_app_id", targetAppId);
      return this;
    }
    public APIRequestCreatePassThreadControl setTargetAppId (String targetAppId) {
      this.setParam("target_app_id", targetAppId);
      return this;
    }

    public APIRequestCreatePassThreadControl setMetadata (String metadata) {
      this.setParam("metadata", metadata);
      return this;
    }

    public APIRequestCreatePassThreadControl requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreatePassThreadControl requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreatePassThreadControl requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreatePassThreadControl requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreatePassThreadControl requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreatePassThreadControl requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetPersonas extends APIRequest<Persona> {

    APINodeList<Persona> lastResponse = null;
    @Override
    public APINodeList<Persona> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "id",
      "name",
      "profile_picture_url",
    };

    @Override
    public APINodeList<Persona> parseResponse(String response) throws APIException {
      return Persona.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<Persona> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Persona> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Persona>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Persona>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<Persona>>() {
           public APINodeList<Persona> apply(String result) {
             try {
               return APIRequestGetPersonas.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetPersonas(String nodeId, APIContext context) {
      super(context, nodeId, "/personas", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetPersonas setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetPersonas setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetPersonas requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetPersonas requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetPersonas requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetPersonas requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetPersonas requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetPersonas requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetPersonas requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetPersonas requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetPersonas requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetPersonas requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetPersonas requestProfilePictureUrlField () {
      return this.requestProfilePictureUrlField(true);
    }
    public APIRequestGetPersonas requestProfilePictureUrlField (boolean value) {
      this.requestField("profile_picture_url", value);
      return this;
    }
  }

  public static class APIRequestCreatePersona extends APIRequest<Persona> {

    Persona lastResponse = null;
    @Override
    public Persona getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "name",
      "profile_picture_url",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Persona parseResponse(String response) throws APIException {
      return Persona.parseResponse(response, getContext(), this).head();
    }

    @Override
    public Persona execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Persona execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<Persona> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Persona> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, Persona>() {
           public Persona apply(String result) {
             try {
               return APIRequestCreatePersona.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreatePersona(String nodeId, APIContext context) {
      super(context, nodeId, "/personas", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreatePersona setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreatePersona setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreatePersona setName (String name) {
      this.setParam("name", name);
      return this;
    }

    public APIRequestCreatePersona setProfilePictureUrl (Object profilePictureUrl) {
      this.setParam("profile_picture_url", profilePictureUrl);
      return this;
    }
    public APIRequestCreatePersona setProfilePictureUrl (String profilePictureUrl) {
      this.setParam("profile_picture_url", profilePictureUrl);
      return this;
    }

    public APIRequestCreatePersona requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreatePersona requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreatePersona requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreatePersona requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreatePersona requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreatePersona requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetPhotos extends APIRequest<Photo> {

    APINodeList<Photo> lastResponse = null;
    @Override
    public APINodeList<Photo> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "type",
      "biz_tag_id",
      "business_id",
    };

    public static final String[] FIELDS = {
      "album",
      "backdated_time",
      "backdated_time_granularity",
      "can_backdate",
      "can_delete",
      "can_tag",
      "created_time",
      "event",
      "from",
      "height",
      "icon",
      "id",
      "images",
      "link",
      "name",
      "name_tags",
      "page_story_id",
      "picture",
      "place",
      "position",
      "source",
      "target",
      "updated_time",
      "webp_images",
      "width",
    };

    @Override
    public APINodeList<Photo> parseResponse(String response) throws APIException {
      return Photo.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<Photo> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<Photo> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<Photo>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<Photo>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<Photo>>() {
           public APINodeList<Photo> apply(String result) {
             try {
               return APIRequestGetPhotos.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetPhotos(String nodeId, APIContext context) {
      super(context, nodeId, "/photos", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetPhotos setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetPhotos setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetPhotos setType (Photo.EnumType type) {
      this.setParam("type", type);
      return this;
    }
    public APIRequestGetPhotos setType (String type) {
      this.setParam("type", type);
      return this;
    }

    public APIRequestGetPhotos setBizTagId (Long bizTagId) {
      this.setParam("biz_tag_id", bizTagId);
      return this;
    }
    public APIRequestGetPhotos setBizTagId (String bizTagId) {
      this.setParam("biz_tag_id", bizTagId);
      return this;
    }

    public APIRequestGetPhotos setBusinessId (String businessId) {
      this.setParam("business_id", businessId);
      return this;
    }

    public APIRequestGetPhotos requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetPhotos requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetPhotos requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetPhotos requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetPhotos requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetPhotos requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetPhotos requestAlbumField () {
      return this.requestAlbumField(true);
    }
    public APIRequestGetPhotos requestAlbumField (boolean value) {
      this.requestField("album", value);
      return this;
    }
    public APIRequestGetPhotos requestBackdatedTimeField () {
      return this.requestBackdatedTimeField(true);
    }
    public APIRequestGetPhotos requestBackdatedTimeField (boolean value) {
      this.requestField("backdated_time", value);
      return this;
    }
    public APIRequestGetPhotos requestBackdatedTimeGranularityField () {
      return this.requestBackdatedTimeGranularityField(true);
    }
    public APIRequestGetPhotos requestBackdatedTimeGranularityField (boolean value) {
      this.requestField("backdated_time_granularity", value);
      return this;
    }
    public APIRequestGetPhotos requestCanBackdateField () {
      return this.requestCanBackdateField(true);
    }
    public APIRequestGetPhotos requestCanBackdateField (boolean value) {
      this.requestField("can_backdate", value);
      return this;
    }
    public APIRequestGetPhotos requestCanDeleteField () {
      return this.requestCanDeleteField(true);
    }
    public APIRequestGetPhotos requestCanDeleteField (boolean value) {
      this.requestField("can_delete", value);
      return this;
    }
    public APIRequestGetPhotos requestCanTagField () {
      return this.requestCanTagField(true);
    }
    public APIRequestGetPhotos requestCanTagField (boolean value) {
      this.requestField("can_tag", value);
      return this;
    }
    public APIRequestGetPhotos requestCreatedTimeField () {
      return this.requestCreatedTimeField(true);
    }
    public APIRequestGetPhotos requestCreatedTimeField (boolean value) {
      this.requestField("created_time", value);
      return this;
    }
    public APIRequestGetPhotos requestEventField () {
      return this.requestEventField(true);
    }
    public APIRequestGetPhotos requestEventField (boolean value) {
      this.requestField("event", value);
      return this;
    }
    public APIRequestGetPhotos requestFromField () {
      return this.requestFromField(true);
    }
    public APIRequestGetPhotos requestFromField (boolean value) {
      this.requestField("from", value);
      return this;
    }
    public APIRequestGetPhotos requestHeightField () {
      return this.requestHeightField(true);
    }
    public APIRequestGetPhotos requestHeightField (boolean value) {
      this.requestField("height", value);
      return this;
    }
    public APIRequestGetPhotos requestIconField () {
      return this.requestIconField(true);
    }
    public APIRequestGetPhotos requestIconField (boolean value) {
      this.requestField("icon", value);
      return this;
    }
    public APIRequestGetPhotos requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetPhotos requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetPhotos requestImagesField () {
      return this.requestImagesField(true);
    }
    public APIRequestGetPhotos requestImagesField (boolean value) {
      this.requestField("images", value);
      return this;
    }
    public APIRequestGetPhotos requestLinkField () {
      return this.requestLinkField(true);
    }
    public APIRequestGetPhotos requestLinkField (boolean value) {
      this.requestField("link", value);
      return this;
    }
    public APIRequestGetPhotos requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetPhotos requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetPhotos requestNameTagsField () {
      return this.requestNameTagsField(true);
    }
    public APIRequestGetPhotos requestNameTagsField (boolean value) {
      this.requestField("name_tags", value);
      return this;
    }
    public APIRequestGetPhotos requestPageStoryIdField () {
      return this.requestPageStoryIdField(true);
    }
    public APIRequestGetPhotos requestPageStoryIdField (boolean value) {
      this.requestField("page_story_id", value);
      return this;
    }
    public APIRequestGetPhotos requestPictureField () {
      return this.requestPictureField(true);
    }
    public APIRequestGetPhotos requestPictureField (boolean value) {
      this.requestField("picture", value);
      return this;
    }
    public APIRequestGetPhotos requestPlaceField () {
      return this.requestPlaceField(true);
    }
    public APIRequestGetPhotos requestPlaceField (boolean value) {
      this.requestField("place", value);
      return this;
    }
    public APIRequestGetPhotos requestPositionField () {
      return this.requestPositionField(true);
    }
    public APIRequestGetPhotos requestPositionField (boolean value) {
      this.requestField("position", value);
      return this;
    }
    public APIRequestGetPhotos requestSourceField () {
      return this.requestSourceField(true);
    }
    public APIRequestGetPhotos requestSourceField (boolean value) {
      this.requestField("source", value);
      return this;
    }
    public APIRequestGetPhotos requestTargetField () {
      return this.requestTargetField(true);
    }
    public APIRequestGetPhotos requestTargetField (boolean value) {
      this.requestField("target", value);
      return this;
    }
    public APIRequestGetPhotos requestUpdatedTimeField () {
      return this.requestUpdatedTimeField(true);
    }
    public APIRequestGetPhotos requestUpdatedTimeField (boolean value) {
      this.requestField("updated_time", value);
      return this;
    }
    public APIRequestGetPhotos requestWebpImagesField () {
      return this.requestWebpImagesField(true);
    }
    public APIRequestGetPhotos requestWebpImagesField (boolean value) {
      this.requestField("webp_images", value);
      return this;
    }
    public APIRequestGetPhotos requestWidthField () {
      return this.requestWidthField(true);
    }
    public APIRequestGetPhotos requestWidthField (boolean value) {
      this.requestField("width", value);
      return this;
    }
  }

  public static class APIRequestCreatePhoto extends APIRequest<Photo> {

    Photo lastResponse = null;
    @Override
    public Photo getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "aid",
      "caption",
      "url",
      "uid",
      "profile_id",
      "target_id",
      "checkin_id",
      "vault_image_id",
      "tags",
      "place",
      "is_explicit_place",
      "is_explicit_location",
      "og_action_type_id",
      "og_object_id",
      "og_phrase",
      "og_icon_id",
      "og_suggestion_mechanism",
      "og_set_profile_badge",
      "privacy",
      "targeting",
      "feed_targeting",
      "no_story",
      "published",
      "offline_id",
      "attempt",
      "backdated_time",
      "backdated_time_granularity",
      "time_since_original_post",
      "filter_type",
      "scheduled_publish_time",
      "unpublished_content_type",
      "nectar_module",
      "full_res_is_coming_later",
      "composer_session_id",
      "qn",
      "manual_privacy",
      "audience_exp",
      "proxied_app_id",
      "ios_bundle_id",
      "android_key_hash",
      "user_selected_tags",
      "allow_spherical_photo",
      "spherical_metadata",
      "initial_view_heading_override_degrees",
      "initial_view_pitch_override_degrees",
      "initial_view_vertical_fov_override_degrees",
      "sponsor_id",
      "direct_share_status",
      "sponsor_relationship",
      "application_id",
      "name",
      "message",
      "temporary",
      "location_source_id",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public Photo parseResponse(String response) throws APIException {
      return Photo.parseResponse(response, getContext(), this).head();
    }

    @Override
    public Photo execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public Photo execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<Photo> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<Photo> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, Photo>() {
           public Photo apply(String result) {
             try {
               return APIRequestCreatePhoto.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreatePhoto(String nodeId, APIContext context) {
      super(context, nodeId, "/photos", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreatePhoto setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreatePhoto setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreatePhoto setAid (String aid) {
      this.setParam("aid", aid);
      return this;
    }

    public APIRequestCreatePhoto setCaption (String caption) {
      this.setParam("caption", caption);
      return this;
    }

    public APIRequestCreatePhoto setUrl (String url) {
      this.setParam("url", url);
      return this;
    }

    public APIRequestCreatePhoto setUid (Long uid) {
      this.setParam("uid", uid);
      return this;
    }
    public APIRequestCreatePhoto setUid (String uid) {
      this.setParam("uid", uid);
      return this;
    }

    public APIRequestCreatePhoto setProfileId (Long profileId) {
      this.setParam("profile_id", profileId);
      return this;
    }
    public APIRequestCreatePhoto setProfileId (String profileId) {
      this.setParam("profile_id", profileId);
      return this;
    }

    public APIRequestCreatePhoto setTargetId (Long targetId) {
      this.setParam("target_id", targetId);
      return this;
    }
    public APIRequestCreatePhoto setTargetId (String targetId) {
      this.setParam("target_id", targetId);
      return this;
    }

    public APIRequestCreatePhoto setCheckinId (Object checkinId) {
      this.setParam("checkin_id", checkinId);
      return this;
    }
    public APIRequestCreatePhoto setCheckinId (String checkinId) {
      this.setParam("checkin_id", checkinId);
      return this;
    }

    public APIRequestCreatePhoto setVaultImageId (String vaultImageId) {
      this.setParam("vault_image_id", vaultImageId);
      return this;
    }

    public APIRequestCreatePhoto setTags (List<Object> tags) {
      this.setParam("tags", tags);
      return this;
    }
    public APIRequestCreatePhoto setTags (String tags) {
      this.setParam("tags", tags);
      return this;
    }

    public APIRequestCreatePhoto setPlace (Object place) {
      this.setParam("place", place);
      return this;
    }
    public APIRequestCreatePhoto setPlace (String place) {
      this.setParam("place", place);
      return this;
    }

    public APIRequestCreatePhoto setIsExplicitPlace (Boolean isExplicitPlace) {
      this.setParam("is_explicit_place", isExplicitPlace);
      return this;
    }
    public APIRequestCreatePhoto setIsExplicitPlace (String isExplicitPlace) {
      this.setParam("is_explicit_place", isExplicitPlace);
      return this;
    }

    public APIRequestCreatePhoto setIsExplicitLocation (Boolean isExplicitLocation) {
      this.setParam("is_explicit_location", isExplicitLocation);
      return this;
    }
    public APIRequestCreatePhoto setIsExplicitLocation (String isExplicitLocation) {
      this.setParam("is_explicit_location", isExplicitLocation);
      return this;
    }

    public APIRequestCreatePhoto setOgActionTypeId (String ogActionTypeId) {
      this.setParam("og_action_type_id", ogActionTypeId);
      return this;
    }

    public APIRequestCreatePhoto setOgObjectId (String ogObjectId) {
      this.setParam("og_object_id", ogObjectId);
      return this;
    }

    public APIRequestCreatePhoto setOgPhrase (String ogPhrase) {
      this.setParam("og_phrase", ogPhrase);
      return this;
    }

    public APIRequestCreatePhoto setOgIconId (String ogIconId) {
      this.setParam("og_icon_id", ogIconId);
      return this;
    }

    public APIRequestCreatePhoto setOgSuggestionMechanism (String ogSuggestionMechanism) {
      this.setParam("og_suggestion_mechanism", ogSuggestionMechanism);
      return this;
    }

    public APIRequestCreatePhoto setOgSetProfileBadge (Boolean ogSetProfileBadge) {
      this.setParam("og_set_profile_badge", ogSetProfileBadge);
      return this;
    }
    public APIRequestCreatePhoto setOgSetProfileBadge (String ogSetProfileBadge) {
      this.setParam("og_set_profile_badge", ogSetProfileBadge);
      return this;
    }

    public APIRequestCreatePhoto setPrivacy (Object privacy) {
      this.setParam("privacy", privacy);
      return this;
    }
    public APIRequestCreatePhoto setPrivacy (String privacy) {
      this.setParam("privacy", privacy);
      return this;
    }

    public APIRequestCreatePhoto setTargeting (Object targeting) {
      this.setParam("targeting", targeting);
      return this;
    }
    public APIRequestCreatePhoto setTargeting (String targeting) {
      this.setParam("targeting", targeting);
      return this;
    }

    public APIRequestCreatePhoto setFeedTargeting (Object feedTargeting) {
      this.setParam("feed_targeting", feedTargeting);
      return this;
    }
    public APIRequestCreatePhoto setFeedTargeting (String feedTargeting) {
      this.setParam("feed_targeting", feedTargeting);
      return this;
    }

    public APIRequestCreatePhoto setNoStory (Boolean noStory) {
      this.setParam("no_story", noStory);
      return this;
    }
    public APIRequestCreatePhoto setNoStory (String noStory) {
      this.setParam("no_story", noStory);
      return this;
    }

    public APIRequestCreatePhoto setPublished (Boolean published) {
      this.setParam("published", published);
      return this;
    }
    public APIRequestCreatePhoto setPublished (String published) {
      this.setParam("published", published);
      return this;
    }

    public APIRequestCreatePhoto setOfflineId (Long offlineId) {
      this.setParam("offline_id", offlineId);
      return this;
    }
    public APIRequestCreatePhoto setOfflineId (String offlineId) {
      this.setParam("offline_id", offlineId);
      return this;
    }

    public APIRequestCreatePhoto setAttempt (Long attempt) {
      this.setParam("attempt", attempt);
      return this;
    }
    public APIRequestCreatePhoto setAttempt (String attempt) {
      this.setParam("attempt", attempt);
      return this;
    }

    public APIRequestCreatePhoto setBackdatedTime (String backdatedTime) {
      this.setParam("backdated_time", backdatedTime);
      return this;
    }

    public APIRequestCreatePhoto setBackdatedTimeGranularity (Photo.EnumBackdatedTimeGranularity backdatedTimeGranularity) {
      this.setParam("backdated_time_granularity", backdatedTimeGranularity);
      return this;
    }
    public APIRequestCreatePhoto setBackdatedTimeGranularity (String backdatedTimeGranularity) {
      this.setParam("backdated_time_granularity", backdatedTimeGranularity);
      return this;
    }

    public APIRequestCreatePhoto setTimeSinceOriginalPost (Long timeSinceOriginalPost) {
      this.setParam("time_since_original_post", timeSinceOriginalPost);
      return this;
    }
    public APIRequestCreatePhoto setTimeSinceOriginalPost (String timeSinceOriginalPost) {
      this.setParam("time_since_original_post", timeSinceOriginalPost);
      return this;
    }

    public APIRequestCreatePhoto setFilterType (Long filterType) {
      this.setParam("filter_type", filterType);
      return this;
    }
    public APIRequestCreatePhoto setFilterType (String filterType) {
      this.setParam("filter_type", filterType);
      return this;
    }

    public APIRequestCreatePhoto setScheduledPublishTime (Long scheduledPublishTime) {
      this.setParam("scheduled_publish_time", scheduledPublishTime);
      return this;
    }
    public APIRequestCreatePhoto setScheduledPublishTime (String scheduledPublishTime) {
      this.setParam("scheduled_publish_time", scheduledPublishTime);
      return this;
    }

    public APIRequestCreatePhoto setUnpublishedContentType (Photo.EnumUnpublishedContentType unpublishedContentType) {
      this.setParam("unpublished_content_type", unpublishedContentType);
      return this;
    }
    public APIRequestCreatePhoto setUnpublishedContentType (String unpublishedContentType) {
      this.setParam("unpublished_content_type", unpublishedContentType);
      return this;
    }

    public APIRequestCreatePhoto setNectarModule (String nectarModule) {
      this.setParam("nectar_module", nectarModule);
      return this;
    }

    public APIRequestCreatePhoto setFullResIsComingLater (Boolean fullResIsComingLater) {
      this.setParam("full_res_is_coming_later", fullResIsComingLater);
      return this;
    }
    public APIRequestCreatePhoto setFullResIsComingLater (String fullResIsComingLater) {
      this.setParam("full_res_is_coming_later", fullResIsComingLater);
      return this;
    }

    public APIRequestCreatePhoto setComposerSessionId (String composerSessionId) {
      this.setParam("composer_session_id", composerSessionId);
      return this;
    }

    public APIRequestCreatePhoto setQn (String qn) {
      this.setParam("qn", qn);
      return this;
    }

    public APIRequestCreatePhoto setManualPrivacy (Boolean manualPrivacy) {
      this.setParam("manual_privacy", manualPrivacy);
      return this;
    }
    public APIRequestCreatePhoto setManualPrivacy (String manualPrivacy) {
      this.setParam("manual_privacy", manualPrivacy);
      return this;
    }

    public APIRequestCreatePhoto setAudienceExp (Boolean audienceExp) {
      this.setParam("audience_exp", audienceExp);
      return this;
    }
    public APIRequestCreatePhoto setAudienceExp (String audienceExp) {
      this.setParam("audience_exp", audienceExp);
      return this;
    }

    public APIRequestCreatePhoto setProxiedAppId (String proxiedAppId) {
      this.setParam("proxied_app_id", proxiedAppId);
      return this;
    }

    public APIRequestCreatePhoto setIosBundleId (String iosBundleId) {
      this.setParam("ios_bundle_id", iosBundleId);
      return this;
    }

    public APIRequestCreatePhoto setAndroidKeyHash (String androidKeyHash) {
      this.setParam("android_key_hash", androidKeyHash);
      return this;
    }

    public APIRequestCreatePhoto setUserSelectedTags (Boolean userSelectedTags) {
      this.setParam("user_selected_tags", userSelectedTags);
      return this;
    }
    public APIRequestCreatePhoto setUserSelectedTags (String userSelectedTags) {
      this.setParam("user_selected_tags", userSelectedTags);
      return this;
    }

    public APIRequestCreatePhoto setAllowSphericalPhoto (Boolean allowSphericalPhoto) {
      this.setParam("allow_spherical_photo", allowSphericalPhoto);
      return this;
    }
    public APIRequestCreatePhoto setAllowSphericalPhoto (String allowSphericalPhoto) {
      this.setParam("allow_spherical_photo", allowSphericalPhoto);
      return this;
    }

    public APIRequestCreatePhoto setSphericalMetadata (Map<String, String> sphericalMetadata) {
      this.setParam("spherical_metadata", sphericalMetadata);
      return this;
    }
    public APIRequestCreatePhoto setSphericalMetadata (String sphericalMetadata) {
      this.setParam("spherical_metadata", sphericalMetadata);
      return this;
    }

    public APIRequestCreatePhoto setInitialViewHeadingOverrideDegrees (Long initialViewHeadingOverrideDegrees) {
      this.setParam("initial_view_heading_override_degrees", initialViewHeadingOverrideDegrees);
      return this;
    }
    public APIRequestCreatePhoto setInitialViewHeadingOverrideDegrees (String initialViewHeadingOverrideDegrees) {
      this.setParam("initial_view_heading_override_degrees", initialViewHeadingOverrideDegrees);
      return this;
    }

    public APIRequestCreatePhoto setInitialViewPitchOverrideDegrees (Long initialViewPitchOverrideDegrees) {
      this.setParam("initial_view_pitch_override_degrees", initialViewPitchOverrideDegrees);
      return this;
    }
    public APIRequestCreatePhoto setInitialViewPitchOverrideDegrees (String initialViewPitchOverrideDegrees) {
      this.setParam("initial_view_pitch_override_degrees", initialViewPitchOverrideDegrees);
      return this;
    }

    public APIRequestCreatePhoto setInitialViewVerticalFovOverrideDegrees (Long initialViewVerticalFovOverrideDegrees) {
      this.setParam("initial_view_vertical_fov_override_degrees", initialViewVerticalFovOverrideDegrees);
      return this;
    }
    public APIRequestCreatePhoto setInitialViewVerticalFovOverrideDegrees (String initialViewVerticalFovOverrideDegrees) {
      this.setParam("initial_view_vertical_fov_override_degrees", initialViewVerticalFovOverrideDegrees);
      return this;
    }

    public APIRequestCreatePhoto setSponsorId (String sponsorId) {
      this.setParam("sponsor_id", sponsorId);
      return this;
    }

    public APIRequestCreatePhoto setDirectShareStatus (Long directShareStatus) {
      this.setParam("direct_share_status", directShareStatus);
      return this;
    }
    public APIRequestCreatePhoto setDirectShareStatus (String directShareStatus) {
      this.setParam("direct_share_status", directShareStatus);
      return this;
    }

    public APIRequestCreatePhoto setSponsorRelationship (Long sponsorRelationship) {
      this.setParam("sponsor_relationship", sponsorRelationship);
      return this;
    }
    public APIRequestCreatePhoto setSponsorRelationship (String sponsorRelationship) {
      this.setParam("sponsor_relationship", sponsorRelationship);
      return this;
    }

    public APIRequestCreatePhoto setApplicationId (String applicationId) {
      this.setParam("application_id", applicationId);
      return this;
    }

    public APIRequestCreatePhoto setName (String name) {
      this.setParam("name", name);
      return this;
    }

    public APIRequestCreatePhoto setMessage (String message) {
      this.setParam("message", message);
      return this;
    }

    public APIRequestCreatePhoto setTemporary (Boolean temporary) {
      this.setParam("temporary", temporary);
      return this;
    }
    public APIRequestCreatePhoto setTemporary (String temporary) {
      this.setParam("temporary", temporary);
      return this;
    }

    public APIRequestCreatePhoto setLocationSourceId (String locationSourceId) {
      this.setParam("location_source_id", locationSourceId);
      return this;
    }

    public APIRequestCreatePhoto requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreatePhoto requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreatePhoto requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreatePhoto requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreatePhoto requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreatePhoto requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetPicture extends APIRequest<ProfilePictureSource> {

    APINodeList<ProfilePictureSource> lastResponse = null;
    @Override
    public APINodeList<ProfilePictureSource> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "height",
      "width",
      "type",
      "redirect",
    };

    public static final String[] FIELDS = {
      "bottom",
      "cache_key",
      "height",
      "is_silhouette",
      "left",
      "right",
      "top",
      "uri",
      "url",
      "width",
      "id",
    };

    @Override
    public APINodeList<ProfilePictureSource> parseResponse(String response) throws APIException {
      return ProfilePictureSource.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<ProfilePictureSource> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<ProfilePictureSource> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<ProfilePictureSource>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<ProfilePictureSource>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<ProfilePictureSource>>() {
           public APINodeList<ProfilePictureSource> apply(String result) {
             try {
               return APIRequestGetPicture.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetPicture(String nodeId, APIContext context) {
      super(context, nodeId, "/picture", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetPicture setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetPicture setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetPicture setHeight (Long height) {
      this.setParam("height", height);
      return this;
    }
    public APIRequestGetPicture setHeight (String height) {
      this.setParam("height", height);
      return this;
    }

    public APIRequestGetPicture setWidth (Long width) {
      this.setParam("width", width);
      return this;
    }
    public APIRequestGetPicture setWidth (String width) {
      this.setParam("width", width);
      return this;
    }

    public APIRequestGetPicture setType (ProfilePictureSource.EnumType type) {
      this.setParam("type", type);
      return this;
    }
    public APIRequestGetPicture setType (String type) {
      this.setParam("type", type);
      return this;
    }

    public APIRequestGetPicture setRedirect (Boolean redirect) {
      this.setParam("redirect", redirect);
      return this;
    }
    public APIRequestGetPicture setRedirect (String redirect) {
      this.setParam("redirect", redirect);
      return this;
    }

    public APIRequestGetPicture requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetPicture requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetPicture requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetPicture requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetPicture requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetPicture requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetPicture requestBottomField () {
      return this.requestBottomField(true);
    }
    public APIRequestGetPicture requestBottomField (boolean value) {
      this.requestField("bottom", value);
      return this;
    }
    public APIRequestGetPicture requestCacheKeyField () {
      return this.requestCacheKeyField(true);
    }
    public APIRequestGetPicture requestCacheKeyField (boolean value) {
      this.requestField("cache_key", value);
      return this;
    }
    public APIRequestGetPicture requestHeightField () {
      return this.requestHeightField(true);
    }
    public APIRequestGetPicture requestHeightField (boolean value) {
      this.requestField("height", value);
      return this;
    }
    public APIRequestGetPicture requestIsSilhouetteField () {
      return this.requestIsSilhouetteField(true);
    }
    public APIRequestGetPicture requestIsSilhouetteField (boolean value) {
      this.requestField("is_silhouette", value);
      return this;
    }
    public APIRequestGetPicture requestLeftField () {
      return this.requestLeftField(true);
    }
    public APIRequestGetPicture requestLeftField (boolean value) {
      this.requestField("left", value);
      return this;
    }
    public APIRequestGetPicture requestRightField () {
      return this.requestRightField(true);
    }
    public APIRequestGetPicture requestRightField (boolean value) {
      this.requestField("right", value);
      return this;
    }
    public APIRequestGetPicture requestTopField () {
      return this.requestTopField(true);
    }
    public APIRequestGetPicture requestTopField (boolean value) {
      this.requestField("top", value);
      return this;
    }
    public APIRequestGetPicture requestUriField () {
      return this.requestUriField(true);
    }
    public APIRequestGetPicture requestUriField (boolean value) {
      this.requestField("uri", value);
      return this;
    }
    public APIRequestGetPicture requestUrlField () {
      return this.requestUrlField(true);
    }
    public APIRequestGetPicture requestUrlField (boolean value) {
      this.requestField("url", value);
      return this;
    }
    public APIRequestGetPicture requestWidthField () {
      return this.requestWidthField(true);
    }
    public APIRequestGetPicture requestWidthField (boolean value) {
      this.requestField("width", value);
      return this;
    }
    public APIRequestGetPicture requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetPicture requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
  }

  public static class APIRequestCreatePicture extends APIRequest<ProfilePictureSource> {

    ProfilePictureSource lastResponse = null;
    @Override
    public ProfilePictureSource getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "composer_session_id",
      "qn",
      "photo",
      "reuse",
      "x",
      "y",
      "width",
      "height",
      "scaled_crop_rect",
      "profile_pic_source",
      "profile_pic_method",
      "sticker_id",
      "caption",
      "sticker_source_object_id",
      "msqrd_mask_id",
      "media_effect_ids",
      "media_effect_source_object_id",
      "set_profile_photo_shield",
      "has_umg",
      "android_key_hash",
      "ios_bundle_id",
      "proxied_app_id",
      "picture",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public ProfilePictureSource parseResponse(String response) throws APIException {
      return ProfilePictureSource.parseResponse(response, getContext(), this).head();
    }

    @Override
    public ProfilePictureSource execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public ProfilePictureSource execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<ProfilePictureSource> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<ProfilePictureSource> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, ProfilePictureSource>() {
           public ProfilePictureSource apply(String result) {
             try {
               return APIRequestCreatePicture.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreatePicture(String nodeId, APIContext context) {
      super(context, nodeId, "/picture", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreatePicture setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreatePicture setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreatePicture setComposerSessionId (String composerSessionId) {
      this.setParam("composer_session_id", composerSessionId);
      return this;
    }

    public APIRequestCreatePicture setQn (String qn) {
      this.setParam("qn", qn);
      return this;
    }

    public APIRequestCreatePicture setPhoto (String photo) {
      this.setParam("photo", photo);
      return this;
    }

    public APIRequestCreatePicture setReuse (Boolean reuse) {
      this.setParam("reuse", reuse);
      return this;
    }
    public APIRequestCreatePicture setReuse (String reuse) {
      this.setParam("reuse", reuse);
      return this;
    }

    public APIRequestCreatePicture setX (Long x) {
      this.setParam("x", x);
      return this;
    }
    public APIRequestCreatePicture setX (String x) {
      this.setParam("x", x);
      return this;
    }

    public APIRequestCreatePicture setY (Long y) {
      this.setParam("y", y);
      return this;
    }
    public APIRequestCreatePicture setY (String y) {
      this.setParam("y", y);
      return this;
    }

    public APIRequestCreatePicture setWidth (Long width) {
      this.setParam("width", width);
      return this;
    }
    public APIRequestCreatePicture setWidth (String width) {
      this.setParam("width", width);
      return this;
    }

    public APIRequestCreatePicture setHeight (Long height) {
      this.setParam("height", height);
      return this;
    }
    public APIRequestCreatePicture setHeight (String height) {
      this.setParam("height", height);
      return this;
    }

    public APIRequestCreatePicture setScaledCropRect (Object scaledCropRect) {
      this.setParam("scaled_crop_rect", scaledCropRect);
      return this;
    }
    public APIRequestCreatePicture setScaledCropRect (String scaledCropRect) {
      this.setParam("scaled_crop_rect", scaledCropRect);
      return this;
    }

    public APIRequestCreatePicture setProfilePicSource (String profilePicSource) {
      this.setParam("profile_pic_source", profilePicSource);
      return this;
    }

    public APIRequestCreatePicture setProfilePicMethod (String profilePicMethod) {
      this.setParam("profile_pic_method", profilePicMethod);
      return this;
    }

    public APIRequestCreatePicture setStickerId (Long stickerId) {
      this.setParam("sticker_id", stickerId);
      return this;
    }
    public APIRequestCreatePicture setStickerId (String stickerId) {
      this.setParam("sticker_id", stickerId);
      return this;
    }

    public APIRequestCreatePicture setCaption (String caption) {
      this.setParam("caption", caption);
      return this;
    }

    public APIRequestCreatePicture setStickerSourceObjectId (Long stickerSourceObjectId) {
      this.setParam("sticker_source_object_id", stickerSourceObjectId);
      return this;
    }
    public APIRequestCreatePicture setStickerSourceObjectId (String stickerSourceObjectId) {
      this.setParam("sticker_source_object_id", stickerSourceObjectId);
      return this;
    }

    public APIRequestCreatePicture setMsqrdMaskId (String msqrdMaskId) {
      this.setParam("msqrd_mask_id", msqrdMaskId);
      return this;
    }

    public APIRequestCreatePicture setMediaEffectIds (List<Long> mediaEffectIds) {
      this.setParam("media_effect_ids", mediaEffectIds);
      return this;
    }
    public APIRequestCreatePicture setMediaEffectIds (String mediaEffectIds) {
      this.setParam("media_effect_ids", mediaEffectIds);
      return this;
    }

    public APIRequestCreatePicture setMediaEffectSourceObjectId (Long mediaEffectSourceObjectId) {
      this.setParam("media_effect_source_object_id", mediaEffectSourceObjectId);
      return this;
    }
    public APIRequestCreatePicture setMediaEffectSourceObjectId (String mediaEffectSourceObjectId) {
      this.setParam("media_effect_source_object_id", mediaEffectSourceObjectId);
      return this;
    }

    public APIRequestCreatePicture setSetProfilePhotoShield (String setProfilePhotoShield) {
      this.setParam("set_profile_photo_shield", setProfilePhotoShield);
      return this;
    }

    public APIRequestCreatePicture setHasUmg (Boolean hasUmg) {
      this.setParam("has_umg", hasUmg);
      return this;
    }
    public APIRequestCreatePicture setHasUmg (String hasUmg) {
      this.setParam("has_umg", hasUmg);
      return this;
    }

    public APIRequestCreatePicture setAndroidKeyHash (String androidKeyHash) {
      this.setParam("android_key_hash", androidKeyHash);
      return this;
    }

    public APIRequestCreatePicture setIosBundleId (String iosBundleId) {
      this.setParam("ios_bundle_id", iosBundleId);
      return this;
    }

    public APIRequestCreatePicture setProxiedAppId (Long proxiedAppId) {
      this.setParam("proxied_app_id", proxiedAppId);
      return this;
    }
    public APIRequestCreatePicture setProxiedAppId (String proxiedAppId) {
      this.setParam("proxied_app_id", proxiedAppId);
      return this;
    }

    public APIRequestCreatePicture setPicture (String picture) {
      this.setParam("picture", picture);
      return this;
    }

    public APIRequestCreatePicture requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreatePicture requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreatePicture requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreatePicture requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreatePicture requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreatePicture requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetPlaceTopics extends APIRequest<PlaceTopic> {

    APINodeList<PlaceTopic> lastResponse = null;
    @Override
    public APINodeList<PlaceTopic> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "count",
      "has_children",
      "icon_url",
      "id",
      "name",
      "parent_ids",
      "plural_name",
      "top_subtopic_names",
    };

    @Override
    public APINodeList<PlaceTopic> parseResponse(String response) throws APIException {
      return PlaceTopic.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<PlaceTopic> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<PlaceTopic> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<PlaceTopic>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<PlaceTopic>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<PlaceTopic>>() {
           public APINodeList<PlaceTopic> apply(String result) {
             try {
               return APIRequestGetPlaceTopics.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetPlaceTopics(String nodeId, APIContext context) {
      super(context, nodeId, "/place_topics", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetPlaceTopics setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetPlaceTopics setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetPlaceTopics requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetPlaceTopics requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetPlaceTopics requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetPlaceTopics requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetPlaceTopics requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetPlaceTopics requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetPlaceTopics requestCountField () {
      return this.requestCountField(true);
    }
    public APIRequestGetPlaceTopics requestCountField (boolean value) {
      this.requestField("count", value);
      return this;
    }
    public APIRequestGetPlaceTopics requestHasChildrenField () {
      return this.requestHasChildrenField(true);
    }
    public APIRequestGetPlaceTopics requestHasChildrenField (boolean value) {
      this.requestField("has_children", value);
      return this;
    }
    public APIRequestGetPlaceTopics requestIconUrlField () {
      return this.requestIconUrlField(true);
    }
    public APIRequestGetPlaceTopics requestIconUrlField (boolean value) {
      this.requestField("icon_url", value);
      return this;
    }
    public APIRequestGetPlaceTopics requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetPlaceTopics requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetPlaceTopics requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetPlaceTopics requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetPlaceTopics requestParentIdsField () {
      return this.requestParentIdsField(true);
    }
    public APIRequestGetPlaceTopics requestParentIdsField (boolean value) {
      this.requestField("parent_ids", value);
      return this;
    }
    public APIRequestGetPlaceTopics requestPluralNameField () {
      return this.requestPluralNameField(true);
    }
    public APIRequestGetPlaceTopics requestPluralNameField (boolean value) {
      this.requestField("plural_name", value);
      return this;
    }
    public APIRequestGetPlaceTopics requestTopSubtopicNamesField () {
      return this.requestTopSubtopicNamesField(true);
    }
    public APIRequestGetPlaceTopics requestTopSubtopicNamesField (boolean value) {
      this.requestField("top_subtopic_names", value);
      return this;
    }
  }

  public static class APIRequestGetPosts extends APIRequest<PagePost> {

    APINodeList<PagePost> lastResponse = null;
    @Override
    public APINodeList<PagePost> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "include_hidden",
      "with",
      "show_expired",
      "q",
    };

    public static final String[] FIELDS = {
      "actions",
      "admin_creator",
      "allowed_advertising_objectives",
      "application",
      "backdated_time",
      "call_to_action",
      "can_reply_privately",
      "caption",
      "child_attachments",
      "comments_mirroring_domain",
      "coordinates",
      "created_time",
      "description",
      "event",
      "expanded_height",
      "expanded_width",
      "feed_targeting",
      "from",
      "full_picture",
      "height",
      "icon",
      "id",
      "instagram_eligibility",
      "is_app_share",
      "is_expired",
      "is_hidden",
      "is_instagram_eligible",
      "is_popular",
      "is_published",
      "is_spherical",
      "link",
      "message",
      "message_tags",
      "multi_share_end_card",
      "multi_share_optimized",
      "name",
      "object_id",
      "parent_id",
      "permalink_url",
      "picture",
      "place",
      "privacy",
      "promotable_id",
      "promotion_status",
      "properties",
      "scheduled_publish_time",
      "shares",
      "source