/**
 * Copyright (c) 2015-present, Facebook, Inc. All rights reserved.
 *
 * You are hereby granted a non-exclusive, worldwide, royalty-free license to
 * use, copy, modify, and distribute this software in source code or binary
 * form for use in connection with the web services and APIs provided by
 * Facebook.
 *
 * As with any software that integrates with the Facebook platform, your use
 * of this software is subject to the Facebook Developer Principles and
 * Policies [http://developers.facebook.com/policy/]. This copyright notice
 * shall be included in all copies or substantial portions of the software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */

package com.facebook.ads.sdk;

import java.io.File;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.gson.JsonObject;
import com.google.gson.JsonArray;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;

import com.facebook.ads.sdk.APIException.MalformedResponseException;

/**
 * This class is auto-generated.
 *
 * For any issues or feature requests related to this class, please let us know
 * on github and we'll fix in our codegen framework. We'll not be able to accept
 * pull request for this class.
 *
 */
public class DynamicItemDisplayBundleFolder extends APINode {
  @SerializedName("categorization_criteria")
  private String mCategorizationCriteria = null;
  @SerializedName("id")
  private String mId = null;
  @SerializedName("name")
  private String mName = null;
  @SerializedName("product_catalog")
  private ProductCatalog mProductCatalog = null;
  @SerializedName("product_set")
  private ProductSet mProductSet = null;
  @SerializedName("valid_labels")
  private List<Object> mValidLabels = null;
  protected static Gson gson = null;

  DynamicItemDisplayBundleFolder() {
  }

  public DynamicItemDisplayBundleFolder(Long id, APIContext context) {
    this(id.toString(), context);
  }

  public DynamicItemDisplayBundleFolder(String id, APIContext context) {
    this.mId = id;

    this.context = context;
  }

  public DynamicItemDisplayBundleFolder fetch() throws APIException{
    DynamicItemDisplayBundleFolder newInstance = fetchById(this.getPrefixedId().toString(), this.context);
    this.copyFrom(newInstance);
    return this;
  }

  public static DynamicItemDisplayBundleFolder fetchById(Long id, APIContext context) throws APIException {
    return fetchById(id.toString(), context);
  }

  public static ListenableFuture<DynamicItemDisplayBundleFolder> fetchByIdAsync(Long id, APIContext context) throws APIException {
    return fetchByIdAsync(id.toString(), context);
  }

  public static DynamicItemDisplayBundleFolder fetchById(String id, APIContext context) throws APIException {
    return
      new APIRequestGet(id, context)
      .requestAllFields()
      .execute();
  }

  public static ListenableFuture<DynamicItemDisplayBundleFolder> fetchByIdAsync(String id, APIContext context) throws APIException {
    return
      new APIRequestGet(id, context)
      .requestAllFields()
      .executeAsync();
  }

  public static APINodeList<DynamicItemDisplayBundleFolder> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
    return (APINodeList<DynamicItemDisplayBundleFolder>)(
      new APIRequest<DynamicItemDisplayBundleFolder>(context, "", "/", "GET", DynamicItemDisplayBundleFolder.getParser())
        .setParam("ids", APIRequest.joinStringList(ids))
        .requestFields(fields)
        .execute()
    );
  }

  public static ListenableFuture<APINodeList<DynamicItemDisplayBundleFolder>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
    return
      new APIRequest(context, "", "/", "GET", DynamicItemDisplayBundleFolder.getParser())
        .setParam("ids", APIRequest.joinStringList(ids))
        .requestFields(fields)
        .executeAsyncBase();
  }

  private String getPrefixedId() {
    return getId();
  }

  public String getId() {
    return getFieldId().toString();
  }
  public static DynamicItemDisplayBundleFolder loadJSON(String json, APIContext context) {
    DynamicItemDisplayBundleFolder dynamicItemDisplayBundleFolder = getGson().fromJson(json, DynamicItemDisplayBundleFolder.class);
    if (context.isDebug()) {
      JsonParser parser = new JsonParser();
      JsonElement o1 = parser.parse(json);
      JsonElement o2 = parser.parse(dynamicItemDisplayBundleFolder.toString());
      if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
        o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
      }
      if (!o1.equals(o2)) {
        context.log("[Warning] When parsing response, object is not consistent with JSON:");
        context.log("[JSON]" + o1);
        context.log("[Object]" + o2);
      };
    }
    dynamicItemDisplayBundleFolder.context = context;
    dynamicItemDisplayBundleFolder.rawValue = json;
    return dynamicItemDisplayBundleFolder;
  }

  public static APINodeList<DynamicItemDisplayBundleFolder> parseResponse(String json, APIContext context, APIRequest request) throws MalformedResponseException {
    APINodeList<DynamicItemDisplayBundleFolder> dynamicItemDisplayBundleFolders = new APINodeList<DynamicItemDisplayBundleFolder>(request, json);
    JsonArray arr;
    JsonObject obj;
    JsonParser parser = new JsonParser();
    Exception exception = null;
    try{
      JsonElement result = parser.parse(json);
      if (result.isJsonArray()) {
        // First, check if it's a pure JSON Array
        arr = result.getAsJsonArray();
        for (int i = 0; i < arr.size(); i++) {
          dynamicItemDisplayBundleFolders.add(loadJSON(arr.get(i).getAsJsonObject().toString(), context));
        };
        return dynamicItemDisplayBundleFolders;
      } else if (result.isJsonObject()) {
        obj = result.getAsJsonObject();
        if (obj.has("data")) {
          if (obj.has("paging")) {
            JsonObject paging = obj.get("paging").getAsJsonObject();
            if (paging.has("cursors")) {
                JsonObject cursors = paging.get("cursors").getAsJsonObject();
                String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                dynamicItemDisplayBundleFolders.setCursors(before, after);
            }
            String previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
            String next = paging.has("next") ? paging.get("next").getAsString() : null;
            dynamicItemDisplayBundleFolders.setPaging(previous, next);
            if (context.hasAppSecret()) {
              dynamicItemDisplayBundleFolders.setAppSecret(context.getAppSecretProof());
            }
          }
          if (obj.get("data").isJsonArray()) {
            // Second, check if it's a JSON array with "data"
            arr = obj.get("data").getAsJsonArray();
            for (int i = 0; i < arr.size(); i++) {
              dynamicItemDisplayBundleFolders.add(loadJSON(arr.get(i).getAsJsonObject().toString(), context));
            };
          } else if (obj.get("data").isJsonObject()) {
            // Third, check if it's a JSON object with "data"
            obj = obj.get("data").getAsJsonObject();
            boolean isRedownload = false;
            for (String s : new String[]{"campaigns", "adsets", "ads"}) {
              if (obj.has(s)) {
                isRedownload = true;
                obj = obj.getAsJsonObject(s);
                for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                  dynamicItemDisplayBundleFolders.add(loadJSON(entry.getValue().toString(), context));
                }
                break;
              }
            }
            if (!isRedownload) {
              dynamicItemDisplayBundleFolders.add(loadJSON(obj.toString(), context));
            }
          }
          return dynamicItemDisplayBundleFolders;
        } else if (obj.has("images")) {
          // Fourth, check if it's a map of image objects
          obj = obj.get("images").getAsJsonObject();
          for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
              dynamicItemDisplayBundleFolders.add(loadJSON(entry.getValue().toString(), context));
          }
          return dynamicItemDisplayBundleFolders;
        } else {
          // Fifth, check if it's an array of objects indexed by id
          boolean isIdIndexedArray = true;
          for (Map.Entry entry : obj.entrySet()) {
            String key = (String) entry.getKey();
            if (key.equals("__fb_trace_id__")) {
              continue;
            }
            JsonElement value = (JsonElement) entry.getValue();
            if (
              value != null &&
              value.isJsonObject() &&
              value.getAsJsonObject().has("id") &&
              value.getAsJsonObject().get("id") != null &&
              value.getAsJsonObject().get("id").getAsString().equals(key)
            ) {
              dynamicItemDisplayBundleFolders.add(loadJSON(value.toString(), context));
            } else {
              isIdIndexedArray = false;
              break;
            }
          }
          if (isIdIndexedArray) {
            return dynamicItemDisplayBundleFolders;
          }

          // Sixth, check if it's pure JsonObject
          dynamicItemDisplayBundleFolders.clear();
          dynamicItemDisplayBundleFolders.add(loadJSON(json, context));
          return dynamicItemDisplayBundleFolders;
        }
      }
    } catch (Exception e) {
      exception = e;
    }
    throw new MalformedResponseException(
      "Invalid response string: " + json,
      exception
    );
  }

  @Override
  public APIContext getContext() {
    return context;
  }

  @Override
  public void setContext(APIContext context) {
    this.context = context;
  }

  @Override
  public String toString() {
    return getGson().toJson(this);
  }

  public APIRequestDeleteBundles deleteBundles() {
    return new APIRequestDeleteBundles(this.getPrefixedId().toString(), context);
  }

  public APIRequestGetBundles getBundles() {
    return new APIRequestGetBundles(this.getPrefixedId().toString(), context);
  }

  public APIRequestCreateBundle createBundle() {
    return new APIRequestCreateBundle(this.getPrefixedId().toString(), context);
  }

  public APIRequestDelete delete() {
    return new APIRequestDelete(this.getPrefixedId().toString(), context);
  }

  public APIRequestGet get() {
    return new APIRequestGet(this.getPrefixedId().toString(), context);
  }

  public APIRequestUpdate update() {
    return new APIRequestUpdate(this.getPrefixedId().toString(), context);
  }


  public String getFieldCategorizationCriteria() {
    return mCategorizationCriteria;
  }

  public String getFieldId() {
    return mId;
  }

  public String getFieldName() {
    return mName;
  }

  public ProductCatalog getFieldProductCatalog() {
    if (mProductCatalog != null) {
      mProductCatalog.context = getContext();
    }
    return mProductCatalog;
  }

  public ProductSet getFieldProductSet() {
    if (mProductSet != null) {
      mProductSet.context = getContext();
    }
    return mProductSet;
  }

  public List<Object> getFieldValidLabels() {
    return mValidLabels;
  }



  public static class APIRequestDeleteBundles extends APIRequest<APINode> {

    APINodeList<APINode> lastResponse = null;
    @Override
    public APINodeList<APINode> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "bundle",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINodeList<APINode> parseResponse(String response) throws APIException {
      return APINode.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<APINode> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<APINode>>() {
           public APINodeList<APINode> apply(String result) {
             try {
               return APIRequestDeleteBundles.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestDeleteBundles(String nodeId, APIContext context) {
      super(context, nodeId, "/bundles", "DELETE", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestDeleteBundles setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestDeleteBundles setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestDeleteBundles setBundle (String bundle) {
      this.setParam("bundle", bundle);
      return this;
    }

    public APIRequestDeleteBundles requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestDeleteBundles requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteBundles requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestDeleteBundles requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDeleteBundles requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestDeleteBundles requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGetBundles extends APIRequest<DynamicItemDisplayBundle> {

    APINodeList<DynamicItemDisplayBundle> lastResponse = null;
    @Override
    public APINodeList<DynamicItemDisplayBundle> getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "additional_urls",
      "description",
      "id",
      "name",
      "product_set",
      "text_tokens",
      "url",
    };

    @Override
    public APINodeList<DynamicItemDisplayBundle> parseResponse(String response) throws APIException {
      return DynamicItemDisplayBundle.parseResponse(response, getContext(), this);
    }

    @Override
    public APINodeList<DynamicItemDisplayBundle> execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINodeList<DynamicItemDisplayBundle> execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINodeList<DynamicItemDisplayBundle>> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINodeList<DynamicItemDisplayBundle>> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINodeList<DynamicItemDisplayBundle>>() {
           public APINodeList<DynamicItemDisplayBundle> apply(String result) {
             try {
               return APIRequestGetBundles.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGetBundles(String nodeId, APIContext context) {
      super(context, nodeId, "/bundles", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGetBundles setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGetBundles setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGetBundles requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGetBundles requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetBundles requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGetBundles requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGetBundles requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGetBundles requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGetBundles requestAdditionalUrlsField () {
      return this.requestAdditionalUrlsField(true);
    }
    public APIRequestGetBundles requestAdditionalUrlsField (boolean value) {
      this.requestField("additional_urls", value);
      return this;
    }
    public APIRequestGetBundles requestDescriptionField () {
      return this.requestDescriptionField(true);
    }
    public APIRequestGetBundles requestDescriptionField (boolean value) {
      this.requestField("description", value);
      return this;
    }
    public APIRequestGetBundles requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGetBundles requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGetBundles requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGetBundles requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGetBundles requestProductSetField () {
      return this.requestProductSetField(true);
    }
    public APIRequestGetBundles requestProductSetField (boolean value) {
      this.requestField("product_set", value);
      return this;
    }
    public APIRequestGetBundles requestTextTokensField () {
      return this.requestTextTokensField(true);
    }
    public APIRequestGetBundles requestTextTokensField (boolean value) {
      this.requestField("text_tokens", value);
      return this;
    }
    public APIRequestGetBundles requestUrlField () {
      return this.requestUrlField(true);
    }
    public APIRequestGetBundles requestUrlField (boolean value) {
      this.requestField("url", value);
      return this;
    }
  }

  public static class APIRequestCreateBundle extends APIRequest<DynamicItemDisplayBundleFolder> {

    DynamicItemDisplayBundleFolder lastResponse = null;
    @Override
    public DynamicItemDisplayBundleFolder getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "bundle",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public DynamicItemDisplayBundleFolder parseResponse(String response) throws APIException {
      return DynamicItemDisplayBundleFolder.parseResponse(response, getContext(), this).head();
    }

    @Override
    public DynamicItemDisplayBundleFolder execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public DynamicItemDisplayBundleFolder execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<DynamicItemDisplayBundleFolder> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<DynamicItemDisplayBundleFolder> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, DynamicItemDisplayBundleFolder>() {
           public DynamicItemDisplayBundleFolder apply(String result) {
             try {
               return APIRequestCreateBundle.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestCreateBundle(String nodeId, APIContext context) {
      super(context, nodeId, "/bundles", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestCreateBundle setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestCreateBundle setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestCreateBundle setBundle (String bundle) {
      this.setParam("bundle", bundle);
      return this;
    }

    public APIRequestCreateBundle requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestCreateBundle requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateBundle requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestCreateBundle requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestCreateBundle requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestCreateBundle requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestDelete extends APIRequest<APINode> {

    APINode lastResponse = null;
    @Override
    public APINode getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
    };

    @Override
    public APINode parseResponse(String response) throws APIException {
      return APINode.parseResponse(response, getContext(), this).head();
    }

    @Override
    public APINode execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public APINode execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<APINode> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, APINode>() {
           public APINode apply(String result) {
             try {
               return APIRequestDelete.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestDelete(String nodeId, APIContext context) {
      super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestDelete setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestDelete setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestDelete requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestDelete requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDelete requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestDelete requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestDelete requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestDelete requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }

  public static class APIRequestGet extends APIRequest<DynamicItemDisplayBundleFolder> {

    DynamicItemDisplayBundleFolder lastResponse = null;
    @Override
    public DynamicItemDisplayBundleFolder getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
    };

    public static final String[] FIELDS = {
      "categorization_criteria",
      "id",
      "name",
      "product_catalog",
      "product_set",
      "valid_labels",
    };

    @Override
    public DynamicItemDisplayBundleFolder parseResponse(String response) throws APIException {
      return DynamicItemDisplayBundleFolder.parseResponse(response, getContext(), this).head();
    }

    @Override
    public DynamicItemDisplayBundleFolder execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public DynamicItemDisplayBundleFolder execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<DynamicItemDisplayBundleFolder> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<DynamicItemDisplayBundleFolder> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, DynamicItemDisplayBundleFolder>() {
           public DynamicItemDisplayBundleFolder apply(String result) {
             try {
               return APIRequestGet.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestGet(String nodeId, APIContext context) {
      super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestGet setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestGet setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestGet requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestGet requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGet requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestGet requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestGet requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestGet requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

    public APIRequestGet requestCategorizationCriteriaField () {
      return this.requestCategorizationCriteriaField(true);
    }
    public APIRequestGet requestCategorizationCriteriaField (boolean value) {
      this.requestField("categorization_criteria", value);
      return this;
    }
    public APIRequestGet requestIdField () {
      return this.requestIdField(true);
    }
    public APIRequestGet requestIdField (boolean value) {
      this.requestField("id", value);
      return this;
    }
    public APIRequestGet requestNameField () {
      return this.requestNameField(true);
    }
    public APIRequestGet requestNameField (boolean value) {
      this.requestField("name", value);
      return this;
    }
    public APIRequestGet requestProductCatalogField () {
      return this.requestProductCatalogField(true);
    }
    public APIRequestGet requestProductCatalogField (boolean value) {
      this.requestField("product_catalog", value);
      return this;
    }
    public APIRequestGet requestProductSetField () {
      return this.requestProductSetField(true);
    }
    public APIRequestGet requestProductSetField (boolean value) {
      this.requestField("product_set", value);
      return this;
    }
    public APIRequestGet requestValidLabelsField () {
      return this.requestValidLabelsField(true);
    }
    public APIRequestGet requestValidLabelsField (boolean value) {
      this.requestField("valid_labels", value);
      return this;
    }
  }

  public static class APIRequestUpdate extends APIRequest<DynamicItemDisplayBundleFolder> {

    DynamicItemDisplayBundleFolder lastResponse = null;
    @Override
    public DynamicItemDisplayBundleFolder getLastResponse() {
      return lastResponse;
    }
    public static final String[] PARAMS = {
      "bundles",
      "name",
    };

    public static final String[] FIELDS = {
    };

    @Override
    public DynamicItemDisplayBundleFolder parseResponse(String response) throws APIException {
      return DynamicItemDisplayBundleFolder.parseResponse(response, getContext(), this).head();
    }

    @Override
    public DynamicItemDisplayBundleFolder execute() throws APIException {
      return execute(new HashMap<String, Object>());
    }

    @Override
    public DynamicItemDisplayBundleFolder execute(Map<String, Object> extraParams) throws APIException {
      lastResponse = parseResponse(executeInternal(extraParams));
      return lastResponse;
    }

    public ListenableFuture<DynamicItemDisplayBundleFolder> executeAsync() throws APIException {
      return executeAsync(new HashMap<String, Object>());
    };

    public ListenableFuture<DynamicItemDisplayBundleFolder> executeAsync(Map<String, Object> extraParams) throws APIException {
      return Futures.transform(
        executeAsyncInternal(extraParams),
        new Function<String, DynamicItemDisplayBundleFolder>() {
           public DynamicItemDisplayBundleFolder apply(String result) {
             try {
               return APIRequestUpdate.this.parseResponse(result);
             } catch (Exception e) {
               throw new RuntimeException(e);
             }
           }
         }
      );
    };

    public APIRequestUpdate(String nodeId, APIContext context) {
      super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
    }

    @Override
    public APIRequestUpdate setParam(String param, Object value) {
      setParamInternal(param, value);
      return this;
    }

    @Override
    public APIRequestUpdate setParams(Map<String, Object> params) {
      setParamsInternal(params);
      return this;
    }


    public APIRequestUpdate setBundles (List<String> bundles) {
      this.setParam("bundles", bundles);
      return this;
    }
    public APIRequestUpdate setBundles (String bundles) {
      this.setParam("bundles", bundles);
      return this;
    }

    public APIRequestUpdate setName (String name) {
      this.setParam("name", name);
      return this;
    }

    public APIRequestUpdate requestAllFields () {
      return this.requestAllFields(true);
    }

    public APIRequestUpdate requestAllFields (boolean value) {
      for (String field : FIELDS) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestUpdate requestFields (List<String> fields) {
      return this.requestFields(fields, true);
    }

    @Override
    public APIRequestUpdate requestFields (List<String> fields, boolean value) {
      for (String field : fields) {
        this.requestField(field, value);
      }
      return this;
    }

    @Override
    public APIRequestUpdate requestField (String field) {
      this.requestField(field, true);
      return this;
    }

    @Override
    public APIRequestUpdate requestField (String field, boolean value) {
      this.requestFieldInternal(field, value);
      return this;
    }

  }


  synchronized /*package*/ static Gson getGson() {
    if (gson != null) {
      return gson;
    } else {
      gson = new GsonBuilder()
        .excludeFieldsWithModifiers(Modifier.STATIC)
        .excludeFieldsWithModifiers(Modifier.PROTECTED)
        .disableHtmlEscaping()
        .create();
    }
    return gson;
  }

  public DynamicItemDisplayBundleFolder copyFrom(DynamicItemDisplayBundleFolder instance) {
    this.mCategorizationCriteria = instance.mCategorizationCriteria;
    this.mId = instance.mId;
    this.mName = instance.mName;
    this.mProductCatalog = instance.mProductCatalog;
    this.mProductSet = instance.mProductSet;
    this.mValidLabels = instance.mValidLabels;
    this.context = instance.context;
    this.rawValue = instance.rawValue;
    return this;
  }

  public static APIRequest.ResponseParser<DynamicItemDisplayBundleFolder> getParser() {
    return new APIRequest.ResponseParser<DynamicItemDisplayBundleFolder>() {
      public APINodeList<DynamicItemDisplayBundleFolder> parseResponse(String response, APIContext context, APIRequest<DynamicItemDisplayBundleFolder> request) throws MalformedResponseException {
        return DynamicItemDisplayBundleFolder.parseResponse(response, context, request);
      }
    };
  }
}
