/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdPlacePageSet;
import com.facebook.ads.sdk.AdsPixel;
import com.facebook.ads.sdk.Application;
import com.facebook.ads.sdk.CustomConversion;
import com.facebook.ads.sdk.OfflineConversionDataSet;
import com.facebook.ads.sdk.OffsitePixel;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdStudyObjective
extends APINode {
    @SerializedName(value="custom_attributes")
    private List<String> mCustomAttributes = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_primary")
    private Boolean mIsPrimary = null;
    @SerializedName(value="last_updated_results")
    private String mLastUpdatedResults = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="results")
    private List<String> mResults = null;
    @SerializedName(value="type")
    private String mType = null;
    protected static Gson gson = null;

    AdStudyObjective() {
    }

    public AdStudyObjective(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdStudyObjective(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdStudyObjective fetch() throws APIException {
        AdStudyObjective newInstance = AdStudyObjective.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdStudyObjective fetchById(Long id, APIContext context) throws APIException {
        return AdStudyObjective.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdStudyObjective> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdStudyObjective.fetchByIdAsync(id.toString(), context);
    }

    public static AdStudyObjective fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdStudyObjective> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdStudyObjective> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdStudyObjective>(context, "", "/", "GET", AdStudyObjective.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdStudyObjective>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdStudyObjective>(context, "", "/", "GET", AdStudyObjective.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdStudyObjective loadJSON(String json, APIContext context, String header) {
        AdStudyObjective adStudyObjective = (AdStudyObjective)AdStudyObjective.getGson().fromJson(json, AdStudyObjective.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adStudyObjective.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adStudyObjective.context = context;
        adStudyObjective.rawValue = json;
        adStudyObjective.header = header;
        return adStudyObjective;
    }

    public static APINodeList<AdStudyObjective> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdStudyObjective> adStudyObjectives = new APINodeList<AdStudyObjective>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adStudyObjectives.add(AdStudyObjective.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adStudyObjectives;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adStudyObjectives.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adStudyObjectives.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adStudyObjectives.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adStudyObjectives.add(AdStudyObjective.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adStudyObjectives.add(AdStudyObjective.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adStudyObjectives.add(AdStudyObjective.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adStudyObjectives;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adStudyObjectives.add(AdStudyObjective.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adStudyObjectives;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adStudyObjectives.add(AdStudyObjective.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adStudyObjectives;
                }
                adStudyObjectives.clear();
                adStudyObjectives.add(AdStudyObjective.loadJSON(json, context, header));
                return adStudyObjectives;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdStudyObjective.getGson().toJson((Object)this);
    }

    public APIRequestGetAdPlacePageSets getAdPlacePageSets() {
        return new APIRequestGetAdPlacePageSets(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdsPixels getAdsPixels() {
        return new APIRequestGetAdsPixels(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetApplications getApplications() {
        return new APIRequestGetApplications(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetCustomConversions getCustomConversions() {
        return new APIRequestGetCustomConversions(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetOfflineConversionDataSets getOfflineConversionDataSets() {
        return new APIRequestGetOfflineConversionDataSets(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetOffsitePixels getOffsitePixels() {
        return new APIRequestGetOffsitePixels(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public List<String> getFieldCustomAttributes() {
        return this.mCustomAttributes;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsPrimary() {
        return this.mIsPrimary;
    }

    public String getFieldLastUpdatedResults() {
        return this.mLastUpdatedResults;
    }

    public String getFieldName() {
        return this.mName;
    }

    public List<String> getFieldResults() {
        return this.mResults;
    }

    public String getFieldType() {
        return this.mType;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdStudyObjective copyFrom(AdStudyObjective instance) {
        this.mCustomAttributes = instance.mCustomAttributes;
        this.mId = instance.mId;
        this.mIsPrimary = instance.mIsPrimary;
        this.mLastUpdatedResults = instance.mLastUpdatedResults;
        this.mName = instance.mName;
        this.mResults = instance.mResults;
        this.mType = instance.mType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdStudyObjective> getParser() {
        return new APIRequest.ResponseParser<AdStudyObjective>(){

            @Override
            public APINodeList<AdStudyObjective> parseResponse(String response, APIContext context, APIRequest<AdStudyObjective> request, String header) throws APIException.MalformedResponseException {
                return AdStudyObjective.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumBreakdowns {
        VALUE_AGE("age"),
        VALUE_CELL_ID("cell_id"),
        VALUE_COUNTRY("country"),
        VALUE_GENDER("gender"),
        NULL(null);

        private String value;

        private EnumBreakdowns(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumType {
        VALUE_BRAND("BRAND"),
        VALUE_BRANDLIFT("BRANDLIFT"),
        VALUE_FTL("FTL"),
        VALUE_MAE("MAE"),
        VALUE_MAI("MAI"),
        VALUE_NONSALES("NONSALES"),
        VALUE_PARTNER("PARTNER"),
        VALUE_SALES("SALES"),
        VALUE_TELCO("TELCO"),
        NULL(null);

        private String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<AdStudyObjective> {
        AdStudyObjective lastResponse = null;
        public static final String[] PARAMS = new String[]{"adspixels", "applications", "customconversions", "is_primary", "name", "offline_conversion_data_sets", "offsitepixels", "product_sets", "type"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdStudyObjective getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdStudyObjective parseResponse(String response, String header) throws APIException {
            return AdStudyObjective.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdStudyObjective execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdStudyObjective execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdStudyObjective> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdStudyObjective> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdStudyObjective>(){

                public AdStudyObjective apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setAdspixels(List<Object> adspixels) {
            this.setParam("adspixels", adspixels);
            return this;
        }

        public APIRequestUpdate setAdspixels(String adspixels) {
            this.setParam("adspixels", adspixels);
            return this;
        }

        public APIRequestUpdate setApplications(List<Object> applications) {
            this.setParam("applications", applications);
            return this;
        }

        public APIRequestUpdate setApplications(String applications) {
            this.setParam("applications", applications);
            return this;
        }

        public APIRequestUpdate setCustomconversions(List<Object> customconversions) {
            this.setParam("customconversions", customconversions);
            return this;
        }

        public APIRequestUpdate setCustomconversions(String customconversions) {
            this.setParam("customconversions", customconversions);
            return this;
        }

        public APIRequestUpdate setIsPrimary(Boolean isPrimary) {
            this.setParam("is_primary", isPrimary);
            return this;
        }

        public APIRequestUpdate setIsPrimary(String isPrimary) {
            this.setParam("is_primary", isPrimary);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate setOfflineConversionDataSets(List<Object> offlineConversionDataSets) {
            this.setParam("offline_conversion_data_sets", offlineConversionDataSets);
            return this;
        }

        public APIRequestUpdate setOfflineConversionDataSets(String offlineConversionDataSets) {
            this.setParam("offline_conversion_data_sets", offlineConversionDataSets);
            return this;
        }

        public APIRequestUpdate setOffsitepixels(List<Object> offsitepixels) {
            this.setParam("offsitepixels", offsitepixels);
            return this;
        }

        public APIRequestUpdate setOffsitepixels(String offsitepixels) {
            this.setParam("offsitepixels", offsitepixels);
            return this;
        }

        public APIRequestUpdate setProductSets(List<Object> productSets) {
            this.setParam("product_sets", productSets);
            return this;
        }

        public APIRequestUpdate setProductSets(String productSets) {
            this.setParam("product_sets", productSets);
            return this;
        }

        public APIRequestUpdate setType(EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestUpdate setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdStudyObjective> {
        AdStudyObjective lastResponse = null;
        public static final String[] PARAMS = new String[]{"breakdowns"};
        public static final String[] FIELDS = new String[]{"custom_attributes", "id", "is_primary", "last_updated_results", "name", "results", "type"};

        @Override
        public AdStudyObjective getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdStudyObjective parseResponse(String response, String header) throws APIException {
            return AdStudyObjective.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdStudyObjective execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdStudyObjective execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdStudyObjective> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdStudyObjective> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdStudyObjective>(){

                public AdStudyObjective apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet setBreakdowns(List<EnumBreakdowns> breakdowns) {
            this.setParam("breakdowns", breakdowns);
            return this;
        }

        public APIRequestGet setBreakdowns(String breakdowns) {
            this.setParam("breakdowns", breakdowns);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCustomAttributesField() {
            return this.requestCustomAttributesField(true);
        }

        public APIRequestGet requestCustomAttributesField(boolean value) {
            this.requestField("custom_attributes", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsPrimaryField() {
            return this.requestIsPrimaryField(true);
        }

        public APIRequestGet requestIsPrimaryField(boolean value) {
            this.requestField("is_primary", value);
            return this;
        }

        public APIRequestGet requestLastUpdatedResultsField() {
            return this.requestLastUpdatedResultsField(true);
        }

        public APIRequestGet requestLastUpdatedResultsField(boolean value) {
            this.requestField("last_updated_results", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestResultsField() {
            return this.requestResultsField(true);
        }

        public APIRequestGet requestResultsField(boolean value) {
            this.requestField("results", value);
            return this;
        }

        public APIRequestGet requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGet requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetOffsitePixels
    extends APIRequest<OffsitePixel> {
        APINodeList<OffsitePixel> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"creator", "id", "js_pixel", "last_firing_time", "name", "tag"};

        @Override
        public APINodeList<OffsitePixel> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<OffsitePixel> parseResponse(String response, String header) throws APIException {
            return OffsitePixel.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<OffsitePixel> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<OffsitePixel> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<OffsitePixel>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<OffsitePixel>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<OffsitePixel>>(){

                public APINodeList<OffsitePixel> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetOffsitePixels.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetOffsitePixels(String nodeId, APIContext context) {
            super(context, nodeId, "/offsitepixels", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetOffsitePixels setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetOffsitePixels setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetOffsitePixels requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetOffsitePixels requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOffsitePixels requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetOffsitePixels requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOffsitePixels requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetOffsitePixels requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetOffsitePixels requestCreatorField() {
            return this.requestCreatorField(true);
        }

        public APIRequestGetOffsitePixels requestCreatorField(boolean value) {
            this.requestField("creator", value);
            return this;
        }

        public APIRequestGetOffsitePixels requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetOffsitePixels requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetOffsitePixels requestJsPixelField() {
            return this.requestJsPixelField(true);
        }

        public APIRequestGetOffsitePixels requestJsPixelField(boolean value) {
            this.requestField("js_pixel", value);
            return this;
        }

        public APIRequestGetOffsitePixels requestLastFiringTimeField() {
            return this.requestLastFiringTimeField(true);
        }

        public APIRequestGetOffsitePixels requestLastFiringTimeField(boolean value) {
            this.requestField("last_firing_time", value);
            return this;
        }

        public APIRequestGetOffsitePixels requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetOffsitePixels requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetOffsitePixels requestTagField() {
            return this.requestTagField(true);
        }

        public APIRequestGetOffsitePixels requestTagField(boolean value) {
            this.requestField("tag", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetOfflineConversionDataSets
    extends APIRequest<OfflineConversionDataSet> {
        APINodeList<OfflineConversionDataSet> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"business", "config", "creation_time", "description", "duplicate_entries", "enable_auto_assign_to_accounts", "event_stats", "event_time_max", "event_time_min", "id", "is_mta_use", "is_restricted_use", "last_upload_app", "last_upload_app_changed_time", "match_rate_approx", "matched_entries", "name", "usage", "valid_entries"};

        @Override
        public APINodeList<OfflineConversionDataSet> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<OfflineConversionDataSet> parseResponse(String response, String header) throws APIException {
            return OfflineConversionDataSet.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<OfflineConversionDataSet> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<OfflineConversionDataSet> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<OfflineConversionDataSet>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<OfflineConversionDataSet>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<OfflineConversionDataSet>>(){

                public APINodeList<OfflineConversionDataSet> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetOfflineConversionDataSets.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetOfflineConversionDataSets(String nodeId, APIContext context) {
            super(context, nodeId, "/offline_conversion_data_sets", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetOfflineConversionDataSets setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetOfflineConversionDataSets setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetOfflineConversionDataSets requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOfflineConversionDataSets requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetOfflineConversionDataSets requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOfflineConversionDataSets requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetOfflineConversionDataSets requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestConfigField() {
            return this.requestConfigField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestConfigField(boolean value) {
            this.requestField("config", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestDuplicateEntriesField() {
            return this.requestDuplicateEntriesField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestDuplicateEntriesField(boolean value) {
            this.requestField("duplicate_entries", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestEnableAutoAssignToAccountsField() {
            return this.requestEnableAutoAssignToAccountsField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestEnableAutoAssignToAccountsField(boolean value) {
            this.requestField("enable_auto_assign_to_accounts", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestEventStatsField() {
            return this.requestEventStatsField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestEventStatsField(boolean value) {
            this.requestField("event_stats", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestEventTimeMaxField() {
            return this.requestEventTimeMaxField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestEventTimeMaxField(boolean value) {
            this.requestField("event_time_max", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestEventTimeMinField() {
            return this.requestEventTimeMinField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestEventTimeMinField(boolean value) {
            this.requestField("event_time_min", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestIsMtaUseField() {
            return this.requestIsMtaUseField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestIsMtaUseField(boolean value) {
            this.requestField("is_mta_use", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestIsRestrictedUseField() {
            return this.requestIsRestrictedUseField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestIsRestrictedUseField(boolean value) {
            this.requestField("is_restricted_use", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestLastUploadAppField() {
            return this.requestLastUploadAppField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestLastUploadAppField(boolean value) {
            this.requestField("last_upload_app", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestLastUploadAppChangedTimeField() {
            return this.requestLastUploadAppChangedTimeField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestLastUploadAppChangedTimeField(boolean value) {
            this.requestField("last_upload_app_changed_time", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestMatchRateApproxField() {
            return this.requestMatchRateApproxField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestMatchRateApproxField(boolean value) {
            this.requestField("match_rate_approx", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestMatchedEntriesField() {
            return this.requestMatchedEntriesField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestMatchedEntriesField(boolean value) {
            this.requestField("matched_entries", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestUsageField() {
            return this.requestUsageField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestUsageField(boolean value) {
            this.requestField("usage", value);
            return this;
        }

        public APIRequestGetOfflineConversionDataSets requestValidEntriesField() {
            return this.requestValidEntriesField(true);
        }

        public APIRequestGetOfflineConversionDataSets requestValidEntriesField(boolean value) {
            this.requestField("valid_entries", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetCustomConversions
    extends APIRequest<CustomConversion> {
        APINodeList<CustomConversion> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "aggregation_rule", "business", "creation_time", "custom_event_type", "data_sources", "default_conversion_value", "description", "event_source_type", "first_fired_time", "id", "is_archived", "is_unavailable", "last_fired_time", "name", "offline_conversion_data_set", "pixel", "retention_days", "rule"};

        @Override
        public APINodeList<CustomConversion> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<CustomConversion> parseResponse(String response, String header) throws APIException {
            return CustomConversion.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<CustomConversion> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<CustomConversion> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<CustomConversion>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<CustomConversion>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<CustomConversion>>(){

                public APINodeList<CustomConversion> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetCustomConversions.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetCustomConversions(String nodeId, APIContext context) {
            super(context, nodeId, "/customconversions", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetCustomConversions setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetCustomConversions setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetCustomConversions requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetCustomConversions requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCustomConversions requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetCustomConversions requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCustomConversions requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetCustomConversions requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetCustomConversions requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetCustomConversions requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetCustomConversions requestAggregationRuleField() {
            return this.requestAggregationRuleField(true);
        }

        public APIRequestGetCustomConversions requestAggregationRuleField(boolean value) {
            this.requestField("aggregation_rule", value);
            return this;
        }

        public APIRequestGetCustomConversions requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetCustomConversions requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetCustomConversions requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGetCustomConversions requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGetCustomConversions requestCustomEventTypeField() {
            return this.requestCustomEventTypeField(true);
        }

        public APIRequestGetCustomConversions requestCustomEventTypeField(boolean value) {
            this.requestField("custom_event_type", value);
            return this;
        }

        public APIRequestGetCustomConversions requestDataSourcesField() {
            return this.requestDataSourcesField(true);
        }

        public APIRequestGetCustomConversions requestDataSourcesField(boolean value) {
            this.requestField("data_sources", value);
            return this;
        }

        public APIRequestGetCustomConversions requestDefaultConversionValueField() {
            return this.requestDefaultConversionValueField(true);
        }

        public APIRequestGetCustomConversions requestDefaultConversionValueField(boolean value) {
            this.requestField("default_conversion_value", value);
            return this;
        }

        public APIRequestGetCustomConversions requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetCustomConversions requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetCustomConversions requestEventSourceTypeField() {
            return this.requestEventSourceTypeField(true);
        }

        public APIRequestGetCustomConversions requestEventSourceTypeField(boolean value) {
            this.requestField("event_source_type", value);
            return this;
        }

        public APIRequestGetCustomConversions requestFirstFiredTimeField() {
            return this.requestFirstFiredTimeField(true);
        }

        public APIRequestGetCustomConversions requestFirstFiredTimeField(boolean value) {
            this.requestField("first_fired_time", value);
            return this;
        }

        public APIRequestGetCustomConversions requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetCustomConversions requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetCustomConversions requestIsArchivedField() {
            return this.requestIsArchivedField(true);
        }

        public APIRequestGetCustomConversions requestIsArchivedField(boolean value) {
            this.requestField("is_archived", value);
            return this;
        }

        public APIRequestGetCustomConversions requestIsUnavailableField() {
            return this.requestIsUnavailableField(true);
        }

        public APIRequestGetCustomConversions requestIsUnavailableField(boolean value) {
            this.requestField("is_unavailable", value);
            return this;
        }

        public APIRequestGetCustomConversions requestLastFiredTimeField() {
            return this.requestLastFiredTimeField(true);
        }

        public APIRequestGetCustomConversions requestLastFiredTimeField(boolean value) {
            this.requestField("last_fired_time", value);
            return this;
        }

        public APIRequestGetCustomConversions requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetCustomConversions requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetCustomConversions requestOfflineConversionDataSetField() {
            return this.requestOfflineConversionDataSetField(true);
        }

        public APIRequestGetCustomConversions requestOfflineConversionDataSetField(boolean value) {
            this.requestField("offline_conversion_data_set", value);
            return this;
        }

        public APIRequestGetCustomConversions requestPixelField() {
            return this.requestPixelField(true);
        }

        public APIRequestGetCustomConversions requestPixelField(boolean value) {
            this.requestField("pixel", value);
            return this;
        }

        public APIRequestGetCustomConversions requestRetentionDaysField() {
            return this.requestRetentionDaysField(true);
        }

        public APIRequestGetCustomConversions requestRetentionDaysField(boolean value) {
            this.requestField("retention_days", value);
            return this;
        }

        public APIRequestGetCustomConversions requestRuleField() {
            return this.requestRuleField(true);
        }

        public APIRequestGetCustomConversions requestRuleField(boolean value) {
            this.requestField("rule", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetApplications
    extends APIRequest<Application> {
        APINodeList<Application> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"an_ad_space_limit", "an_platforms", "android_key_hash", "android_sdk_error_categories", "app_domains", "app_events_feature_bitmask", "app_events_session_timeout", "app_install_tracked", "app_name", "app_signals_binding_ios", "app_type", "auth_dialog_data_help_url", "auth_dialog_headline", "auth_dialog_perms_explanation", "auth_referral_default_activity_privacy", "auth_referral_enabled", "auth_referral_extended_perms", "auth_referral_friend_perms", "auth_referral_response_type", "auth_referral_user_perms", "auto_event_mapping_android", "auto_event_mapping_ios", "auto_event_setup_enabled", "canvas_fluid_height", "canvas_fluid_width", "canvas_url", "category", "client_config", "company", "configured_ios_sso", "contact_email", "context", "created_time", "creator_uid", "daily_active_users", "daily_active_users_rank", "deauth_callback_url", "default_share_mode", "description", "financial_id", "gdpv4_chrome_custom_tabs_enabled", "gdpv4_enabled", "gdpv4_nux_content", "gdpv4_nux_enabled", "has_messenger_product", "hosting_url", "icon_url", "id", "ios_bundle_id", "ios_sdk_dialog_flows", "ios_sdk_error_categories", "ios_sfvc_attr", "ios_supports_native_proxy_auth_flow", "ios_supports_system_auth", "ipad_app_store_id", "iphone_app_store_id", "is_viewer_admin", "latest_sdk_version", "link", "logging_token", "login_secret", "logo_url", "migrations", "mobile_profile_section_url", "mobile_web_url", "monthly_active_users", "monthly_active_users_rank", "name", "namespace", "object_store_urls", "page_tab_default_name", "page_tab_url", "photo_url", "privacy_policy_url", "profile_section_url", "property_id", "real_time_mode_devices", "restrictions", "sdk_update_message", "seamless_login", "secure_canvas_url", "secure_page_tab_url", "server_ip_whitelist", "smart_login_bookmark_icon_url", "smart_login_menu_icon_url", "social_discovery", "subcategory", "supported_platforms", "supports_apprequests_fast_app_switch", "supports_attribution", "supports_implicit_sdk_logging", "suppress_native_ios_gdp", "terms_of_service_url", "url_scheme_suffix", "user_support_email", "user_support_url", "website_url", "weekly_active_users"};

        @Override
        public APINodeList<Application> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Application> parseResponse(String response, String header) throws APIException {
            return Application.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Application> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Application> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Application>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Application>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Application>>(){

                public APINodeList<Application> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetApplications.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetApplications(String nodeId, APIContext context) {
            super(context, nodeId, "/applications", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetApplications setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetApplications setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetApplications requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetApplications requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetApplications requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetApplications requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetApplications requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetApplications requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetApplications requestAnAdSpaceLimitField() {
            return this.requestAnAdSpaceLimitField(true);
        }

        public APIRequestGetApplications requestAnAdSpaceLimitField(boolean value) {
            this.requestField("an_ad_space_limit", value);
            return this;
        }

        public APIRequestGetApplications requestAnPlatformsField() {
            return this.requestAnPlatformsField(true);
        }

        public APIRequestGetApplications requestAnPlatformsField(boolean value) {
            this.requestField("an_platforms", value);
            return this;
        }

        public APIRequestGetApplications requestAndroidKeyHashField() {
            return this.requestAndroidKeyHashField(true);
        }

        public APIRequestGetApplications requestAndroidKeyHashField(boolean value) {
            this.requestField("android_key_hash", value);
            return this;
        }

        public APIRequestGetApplications requestAndroidSdkErrorCategoriesField() {
            return this.requestAndroidSdkErrorCategoriesField(true);
        }

        public APIRequestGetApplications requestAndroidSdkErrorCategoriesField(boolean value) {
            this.requestField("android_sdk_error_categories", value);
            return this;
        }

        public APIRequestGetApplications requestAppDomainsField() {
            return this.requestAppDomainsField(true);
        }

        public APIRequestGetApplications requestAppDomainsField(boolean value) {
            this.requestField("app_domains", value);
            return this;
        }

        public APIRequestGetApplications requestAppEventsFeatureBitmaskField() {
            return this.requestAppEventsFeatureBitmaskField(true);
        }

        public APIRequestGetApplications requestAppEventsFeatureBitmaskField(boolean value) {
            this.requestField("app_events_feature_bitmask", value);
            return this;
        }

        public APIRequestGetApplications requestAppEventsSessionTimeoutField() {
            return this.requestAppEventsSessionTimeoutField(true);
        }

        public APIRequestGetApplications requestAppEventsSessionTimeoutField(boolean value) {
            this.requestField("app_events_session_timeout", value);
            return this;
        }

        public APIRequestGetApplications requestAppInstallTrackedField() {
            return this.requestAppInstallTrackedField(true);
        }

        public APIRequestGetApplications requestAppInstallTrackedField(boolean value) {
            this.requestField("app_install_tracked", value);
            return this;
        }

        public APIRequestGetApplications requestAppNameField() {
            return this.requestAppNameField(true);
        }

        public APIRequestGetApplications requestAppNameField(boolean value) {
            this.requestField("app_name", value);
            return this;
        }

        public APIRequestGetApplications requestAppSignalsBindingIosField() {
            return this.requestAppSignalsBindingIosField(true);
        }

        public APIRequestGetApplications requestAppSignalsBindingIosField(boolean value) {
            this.requestField("app_signals_binding_ios", value);
            return this;
        }

        public APIRequestGetApplications requestAppTypeField() {
            return this.requestAppTypeField(true);
        }

        public APIRequestGetApplications requestAppTypeField(boolean value) {
            this.requestField("app_type", value);
            return this;
        }

        public APIRequestGetApplications requestAuthDialogDataHelpUrlField() {
            return this.requestAuthDialogDataHelpUrlField(true);
        }

        public APIRequestGetApplications requestAuthDialogDataHelpUrlField(boolean value) {
            this.requestField("auth_dialog_data_help_url", value);
            return this;
        }

        public APIRequestGetApplications requestAuthDialogHeadlineField() {
            return this.requestAuthDialogHeadlineField(true);
        }

        public APIRequestGetApplications requestAuthDialogHeadlineField(boolean value) {
            this.requestField("auth_dialog_headline", value);
            return this;
        }

        public APIRequestGetApplications requestAuthDialogPermsExplanationField() {
            return this.requestAuthDialogPermsExplanationField(true);
        }

        public APIRequestGetApplications requestAuthDialogPermsExplanationField(boolean value) {
            this.requestField("auth_dialog_perms_explanation", value);
            return this;
        }

        public APIRequestGetApplications requestAuthReferralDefaultActivityPrivacyField() {
            return this.requestAuthReferralDefaultActivityPrivacyField(true);
        }

        public APIRequestGetApplications requestAuthReferralDefaultActivityPrivacyField(boolean value) {
            this.requestField("auth_referral_default_activity_privacy", value);
            return this;
        }

        public APIRequestGetApplications requestAuthReferralEnabledField() {
            return this.requestAuthReferralEnabledField(true);
        }

        public APIRequestGetApplications requestAuthReferralEnabledField(boolean value) {
            this.requestField("auth_referral_enabled", value);
            return this;
        }

        public APIRequestGetApplications requestAuthReferralExtendedPermsField() {
            return this.requestAuthReferralExtendedPermsField(true);
        }

        public APIRequestGetApplications requestAuthReferralExtendedPermsField(boolean value) {
            this.requestField("auth_referral_extended_perms", value);
            return this;
        }

        public APIRequestGetApplications requestAuthReferralFriendPermsField() {
            return this.requestAuthReferralFriendPermsField(true);
        }

        public APIRequestGetApplications requestAuthReferralFriendPermsField(boolean value) {
            this.requestField("auth_referral_friend_perms", value);
            return this;
        }

        public APIRequestGetApplications requestAuthReferralResponseTypeField() {
            return this.requestAuthReferralResponseTypeField(true);
        }

        public APIRequestGetApplications requestAuthReferralResponseTypeField(boolean value) {
            this.requestField("auth_referral_response_type", value);
            return this;
        }

        public APIRequestGetApplications requestAuthReferralUserPermsField() {
            return this.requestAuthReferralUserPermsField(true);
        }

        public APIRequestGetApplications requestAuthReferralUserPermsField(boolean value) {
            this.requestField("auth_referral_user_perms", value);
            return this;
        }

        public APIRequestGetApplications requestAutoEventMappingAndroidField() {
            return this.requestAutoEventMappingAndroidField(true);
        }

        public APIRequestGetApplications requestAutoEventMappingAndroidField(boolean value) {
            this.requestField("auto_event_mapping_android", value);
            return this;
        }

        public APIRequestGetApplications requestAutoEventMappingIosField() {
            return this.requestAutoEventMappingIosField(true);
        }

        public APIRequestGetApplications requestAutoEventMappingIosField(boolean value) {
            this.requestField("auto_event_mapping_ios", value);
            return this;
        }

        public APIRequestGetApplications requestAutoEventSetupEnabledField() {
            return this.requestAutoEventSetupEnabledField(true);
        }

        public APIRequestGetApplications requestAutoEventSetupEnabledField(boolean value) {
            this.requestField("auto_event_setup_enabled", value);
            return this;
        }

        public APIRequestGetApplications requestCanvasFluidHeightField() {
            return this.requestCanvasFluidHeightField(true);
        }

        public APIRequestGetApplications requestCanvasFluidHeightField(boolean value) {
            this.requestField("canvas_fluid_height", value);
            return this;
        }

        public APIRequestGetApplications requestCanvasFluidWidthField() {
            return this.requestCanvasFluidWidthField(true);
        }

        public APIRequestGetApplications requestCanvasFluidWidthField(boolean value) {
            this.requestField("canvas_fluid_width", value);
            return this;
        }

        public APIRequestGetApplications requestCanvasUrlField() {
            return this.requestCanvasUrlField(true);
        }

        public APIRequestGetApplications requestCanvasUrlField(boolean value) {
            this.requestField("canvas_url", value);
            return this;
        }

        public APIRequestGetApplications requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGetApplications requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGetApplications requestClientConfigField() {
            return this.requestClientConfigField(true);
        }

        public APIRequestGetApplications requestClientConfigField(boolean value) {
            this.requestField("client_config", value);
            return this;
        }

        public APIRequestGetApplications requestCompanyField() {
            return this.requestCompanyField(true);
        }

        public APIRequestGetApplications requestCompanyField(boolean value) {
            this.requestField("company", value);
            return this;
        }

        public APIRequestGetApplications requestConfiguredIosSsoField() {
            return this.requestConfiguredIosSsoField(true);
        }

        public APIRequestGetApplications requestConfiguredIosSsoField(boolean value) {
            this.requestField("configured_ios_sso", value);
            return this;
        }

        public APIRequestGetApplications requestContactEmailField() {
            return this.requestContactEmailField(true);
        }

        public APIRequestGetApplications requestContactEmailField(boolean value) {
            this.requestField("contact_email", value);
            return this;
        }

        public APIRequestGetApplications requestContextField() {
            return this.requestContextField(true);
        }

        public APIRequestGetApplications requestContextField(boolean value) {
            this.requestField("context", value);
            return this;
        }

        public APIRequestGetApplications requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetApplications requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetApplications requestCreatorUidField() {
            return this.requestCreatorUidField(true);
        }

        public APIRequestGetApplications requestCreatorUidField(boolean value) {
            this.requestField("creator_uid", value);
            return this;
        }

        public APIRequestGetApplications requestDailyActiveUsersField() {
            return this.requestDailyActiveUsersField(true);
        }

        public APIRequestGetApplications requestDailyActiveUsersField(boolean value) {
            this.requestField("daily_active_users", value);
            return this;
        }

        public APIRequestGetApplications requestDailyActiveUsersRankField() {
            return this.requestDailyActiveUsersRankField(true);
        }

        public APIRequestGetApplications requestDailyActiveUsersRankField(boolean value) {
            this.requestField("daily_active_users_rank", value);
            return this;
        }

        public APIRequestGetApplications requestDeauthCallbackUrlField() {
            return this.requestDeauthCallbackUrlField(true);
        }

        public APIRequestGetApplications requestDeauthCallbackUrlField(boolean value) {
            this.requestField("deauth_callback_url", value);
            return this;
        }

        public APIRequestGetApplications requestDefaultShareModeField() {
            return this.requestDefaultShareModeField(true);
        }

        public APIRequestGetApplications requestDefaultShareModeField(boolean value) {
            this.requestField("default_share_mode", value);
            return this;
        }

        public APIRequestGetApplications requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetApplications requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetApplications requestFinancialIdField() {
            return this.requestFinancialIdField(true);
        }

        public APIRequestGetApplications requestFinancialIdField(boolean value) {
            this.requestField("financial_id", value);
            return this;
        }

        public APIRequestGetApplications requestGdpv4ChromeCustomTabsEnabledField() {
            return this.requestGdpv4ChromeCustomTabsEnabledField(true);
        }

        public APIRequestGetApplications requestGdpv4ChromeCustomTabsEnabledField(boolean value) {
            this.requestField("gdpv4_chrome_custom_tabs_enabled", value);
            return this;
        }

        public APIRequestGetApplications requestGdpv4EnabledField() {
            return this.requestGdpv4EnabledField(true);
        }

        public APIRequestGetApplications requestGdpv4EnabledField(boolean value) {
            this.requestField("gdpv4_enabled", value);
            return this;
        }

        public APIRequestGetApplications requestGdpv4NuxContentField() {
            return this.requestGdpv4NuxContentField(true);
        }

        public APIRequestGetApplications requestGdpv4NuxContentField(boolean value) {
            this.requestField("gdpv4_nux_content", value);
            return this;
        }

        public APIRequestGetApplications requestGdpv4NuxEnabledField() {
            return this.requestGdpv4NuxEnabledField(true);
        }

        public APIRequestGetApplications requestGdpv4NuxEnabledField(boolean value) {
            this.requestField("gdpv4_nux_enabled", value);
            return this;
        }

        public APIRequestGetApplications requestHasMessengerProductField() {
            return this.requestHasMessengerProductField(true);
        }

        public APIRequestGetApplications requestHasMessengerProductField(boolean value) {
            this.requestField("has_messenger_product", value);
            return this;
        }

        public APIRequestGetApplications requestHostingUrlField() {
            return this.requestHostingUrlField(true);
        }

        public APIRequestGetApplications requestHostingUrlField(boolean value) {
            this.requestField("hosting_url", value);
            return this;
        }

        public APIRequestGetApplications requestIconUrlField() {
            return this.requestIconUrlField(true);
        }

        public APIRequestGetApplications requestIconUrlField(boolean value) {
            this.requestField("icon_url", value);
            return this;
        }

        public APIRequestGetApplications requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetApplications requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetApplications requestIosBundleIdField() {
            return this.requestIosBundleIdField(true);
        }

        public APIRequestGetApplications requestIosBundleIdField(boolean value) {
            this.requestField("ios_bundle_id", value);
            return this;
        }

        public APIRequestGetApplications requestIosSdkDialogFlowsField() {
            return this.requestIosSdkDialogFlowsField(true);
        }

        public APIRequestGetApplications requestIosSdkDialogFlowsField(boolean value) {
            this.requestField("ios_sdk_dialog_flows", value);
            return this;
        }

        public APIRequestGetApplications requestIosSdkErrorCategoriesField() {
            return this.requestIosSdkErrorCategoriesField(true);
        }

        public APIRequestGetApplications requestIosSdkErrorCategoriesField(boolean value) {
            this.requestField("ios_sdk_error_categories", value);
            return this;
        }

        public APIRequestGetApplications requestIosSfvcAttrField() {
            return this.requestIosSfvcAttrField(true);
        }

        public APIRequestGetApplications requestIosSfvcAttrField(boolean value) {
            this.requestField("ios_sfvc_attr", value);
            return this;
        }

        public APIRequestGetApplications requestIosSupportsNativeProxyAuthFlowField() {
            return this.requestIosSupportsNativeProxyAuthFlowField(true);
        }

        public APIRequestGetApplications requestIosSupportsNativeProxyAuthFlowField(boolean value) {
            this.requestField("ios_supports_native_proxy_auth_flow", value);
            return this;
        }

        public APIRequestGetApplications requestIosSupportsSystemAuthField() {
            return this.requestIosSupportsSystemAuthField(true);
        }

        public APIRequestGetApplications requestIosSupportsSystemAuthField(boolean value) {
            this.requestField("ios_supports_system_auth", value);
            return this;
        }

        public APIRequestGetApplications requestIpadAppStoreIdField() {
            return this.requestIpadAppStoreIdField(true);
        }

        public APIRequestGetApplications requestIpadAppStoreIdField(boolean value) {
            this.requestField("ipad_app_store_id", value);
            return this;
        }

        public APIRequestGetApplications requestIphoneAppStoreIdField() {
            return this.requestIphoneAppStoreIdField(true);
        }

        public APIRequestGetApplications requestIphoneAppStoreIdField(boolean value) {
            this.requestField("iphone_app_store_id", value);
            return this;
        }

        public APIRequestGetApplications requestIsViewerAdminField() {
            return this.requestIsViewerAdminField(true);
        }

        public APIRequestGetApplications requestIsViewerAdminField(boolean value) {
            this.requestField("is_viewer_admin", value);
            return this;
        }

        public APIRequestGetApplications requestLatestSdkVersionField() {
            return this.requestLatestSdkVersionField(true);
        }

        public APIRequestGetApplications requestLatestSdkVersionField(boolean value) {
            this.requestField("latest_sdk_version", value);
            return this;
        }

        public APIRequestGetApplications requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetApplications requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetApplications requestLoggingTokenField() {
            return this.requestLoggingTokenField(true);
        }

        public APIRequestGetApplications requestLoggingTokenField(boolean value) {
            this.requestField("logging_token", value);
            return this;
        }

        public APIRequestGetApplications requestLoginSecretField() {
            return this.requestLoginSecretField(true);
        }

        public APIRequestGetApplications requestLoginSecretField(boolean value) {
            this.requestField("login_secret", value);
            return this;
        }

        public APIRequestGetApplications requestLogoUrlField() {
            return this.requestLogoUrlField(true);
        }

        public APIRequestGetApplications requestLogoUrlField(boolean value) {
            this.requestField("logo_url", value);
            return this;
        }

        public APIRequestGetApplications requestMigrationsField() {
            return this.requestMigrationsField(true);
        }

        public APIRequestGetApplications requestMigrationsField(boolean value) {
            this.requestField("migrations", value);
            return this;
        }

        public APIRequestGetApplications requestMobileProfileSectionUrlField() {
            return this.requestMobileProfileSectionUrlField(true);
        }

        public APIRequestGetApplications requestMobileProfileSectionUrlField(boolean value) {
            this.requestField("mobile_profile_section_url", value);
            return this;
        }

        public APIRequestGetApplications requestMobileWebUrlField() {
            return this.requestMobileWebUrlField(true);
        }

        public APIRequestGetApplications requestMobileWebUrlField(boolean value) {
            this.requestField("mobile_web_url", value);
            return this;
        }

        public APIRequestGetApplications requestMonthlyActiveUsersField() {
            return this.requestMonthlyActiveUsersField(true);
        }

        public APIRequestGetApplications requestMonthlyActiveUsersField(boolean value) {
            this.requestField("monthly_active_users", value);
            return this;
        }

        public APIRequestGetApplications requestMonthlyActiveUsersRankField() {
            return this.requestMonthlyActiveUsersRankField(true);
        }

        public APIRequestGetApplications requestMonthlyActiveUsersRankField(boolean value) {
            this.requestField("monthly_active_users_rank", value);
            return this;
        }

        public APIRequestGetApplications requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetApplications requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetApplications requestNamespaceField() {
            return this.requestNamespaceField(true);
        }

        public APIRequestGetApplications requestNamespaceField(boolean value) {
            this.requestField("namespace", value);
            return this;
        }

        public APIRequestGetApplications requestObjectStoreUrlsField() {
            return this.requestObjectStoreUrlsField(true);
        }

        public APIRequestGetApplications requestObjectStoreUrlsField(boolean value) {
            this.requestField("object_store_urls", value);
            return this;
        }

        public APIRequestGetApplications requestPageTabDefaultNameField() {
            return this.requestPageTabDefaultNameField(true);
        }

        public APIRequestGetApplications requestPageTabDefaultNameField(boolean value) {
            this.requestField("page_tab_default_name", value);
            return this;
        }

        public APIRequestGetApplications requestPageTabUrlField() {
            return this.requestPageTabUrlField(true);
        }

        public APIRequestGetApplications requestPageTabUrlField(boolean value) {
            this.requestField("page_tab_url", value);
            return this;
        }

        public APIRequestGetApplications requestPhotoUrlField() {
            return this.requestPhotoUrlField(true);
        }

        public APIRequestGetApplications requestPhotoUrlField(boolean value) {
            this.requestField("photo_url", value);
            return this;
        }

        public APIRequestGetApplications requestPrivacyPolicyUrlField() {
            return this.requestPrivacyPolicyUrlField(true);
        }

        public APIRequestGetApplications requestPrivacyPolicyUrlField(boolean value) {
            this.requestField("privacy_policy_url", value);
            return this;
        }

        public APIRequestGetApplications requestProfileSectionUrlField() {
            return this.requestProfileSectionUrlField(true);
        }

        public APIRequestGetApplications requestProfileSectionUrlField(boolean value) {
            this.requestField("profile_section_url", value);
            return this;
        }

        public APIRequestGetApplications requestPropertyIdField() {
            return this.requestPropertyIdField(true);
        }

        public APIRequestGetApplications requestPropertyIdField(boolean value) {
            this.requestField("property_id", value);
            return this;
        }

        public APIRequestGetApplications requestRealTimeModeDevicesField() {
            return this.requestRealTimeModeDevicesField(true);
        }

        public APIRequestGetApplications requestRealTimeModeDevicesField(boolean value) {
            this.requestField("real_time_mode_devices", value);
            return this;
        }

        public APIRequestGetApplications requestRestrictionsField() {
            return this.requestRestrictionsField(true);
        }

        public APIRequestGetApplications requestRestrictionsField(boolean value) {
            this.requestField("restrictions", value);
            return this;
        }

        public APIRequestGetApplications requestSdkUpdateMessageField() {
            return this.requestSdkUpdateMessageField(true);
        }

        public APIRequestGetApplications requestSdkUpdateMessageField(boolean value) {
            this.requestField("sdk_update_message", value);
            return this;
        }

        public APIRequestGetApplications requestSeamlessLoginField() {
            return this.requestSeamlessLoginField(true);
        }

        public APIRequestGetApplications requestSeamlessLoginField(boolean value) {
            this.requestField("seamless_login", value);
            return this;
        }

        public APIRequestGetApplications requestSecureCanvasUrlField() {
            return this.requestSecureCanvasUrlField(true);
        }

        public APIRequestGetApplications requestSecureCanvasUrlField(boolean value) {
            this.requestField("secure_canvas_url", value);
            return this;
        }

        public APIRequestGetApplications requestSecurePageTabUrlField() {
            return this.requestSecurePageTabUrlField(true);
        }

        public APIRequestGetApplications requestSecurePageTabUrlField(boolean value) {
            this.requestField("secure_page_tab_url", value);
            return this;
        }

        public APIRequestGetApplications requestServerIpWhitelistField() {
            return this.requestServerIpWhitelistField(true);
        }

        public APIRequestGetApplications requestServerIpWhitelistField(boolean value) {
            this.requestField("server_ip_whitelist", value);
            return this;
        }

        public APIRequestGetApplications requestSmartLoginBookmarkIconUrlField() {
            return this.requestSmartLoginBookmarkIconUrlField(true);
        }

        public APIRequestGetApplications requestSmartLoginBookmarkIconUrlField(boolean value) {
            this.requestField("smart_login_bookmark_icon_url", value);
            return this;
        }

        public APIRequestGetApplications requestSmartLoginMenuIconUrlField() {
            return this.requestSmartLoginMenuIconUrlField(true);
        }

        public APIRequestGetApplications requestSmartLoginMenuIconUrlField(boolean value) {
            this.requestField("smart_login_menu_icon_url", value);
            return this;
        }

        public APIRequestGetApplications requestSocialDiscoveryField() {
            return this.requestSocialDiscoveryField(true);
        }

        public APIRequestGetApplications requestSocialDiscoveryField(boolean value) {
            this.requestField("social_discovery", value);
            return this;
        }

        public APIRequestGetApplications requestSubcategoryField() {
            return this.requestSubcategoryField(true);
        }

        public APIRequestGetApplications requestSubcategoryField(boolean value) {
            this.requestField("subcategory", value);
            return this;
        }

        public APIRequestGetApplications requestSupportedPlatformsField() {
            return this.requestSupportedPlatformsField(true);
        }

        public APIRequestGetApplications requestSupportedPlatformsField(boolean value) {
            this.requestField("supported_platforms", value);
            return this;
        }

        public APIRequestGetApplications requestSupportsApprequestsFastAppSwitchField() {
            return this.requestSupportsApprequestsFastAppSwitchField(true);
        }

        public APIRequestGetApplications requestSupportsApprequestsFastAppSwitchField(boolean value) {
            this.requestField("supports_apprequests_fast_app_switch", value);
            return this;
        }

        public APIRequestGetApplications requestSupportsAttributionField() {
            return this.requestSupportsAttributionField(true);
        }

        public APIRequestGetApplications requestSupportsAttributionField(boolean value) {
            this.requestField("supports_attribution", value);
            return this;
        }

        public APIRequestGetApplications requestSupportsImplicitSdkLoggingField() {
            return this.requestSupportsImplicitSdkLoggingField(true);
        }

        public APIRequestGetApplications requestSupportsImplicitSdkLoggingField(boolean value) {
            this.requestField("supports_implicit_sdk_logging", value);
            return this;
        }

        public APIRequestGetApplications requestSuppressNativeIosGdpField() {
            return this.requestSuppressNativeIosGdpField(true);
        }

        public APIRequestGetApplications requestSuppressNativeIosGdpField(boolean value) {
            this.requestField("suppress_native_ios_gdp", value);
            return this;
        }

        public APIRequestGetApplications requestTermsOfServiceUrlField() {
            return this.requestTermsOfServiceUrlField(true);
        }

        public APIRequestGetApplications requestTermsOfServiceUrlField(boolean value) {
            this.requestField("terms_of_service_url", value);
            return this;
        }

        public APIRequestGetApplications requestUrlSchemeSuffixField() {
            return this.requestUrlSchemeSuffixField(true);
        }

        public APIRequestGetApplications requestUrlSchemeSuffixField(boolean value) {
            this.requestField("url_scheme_suffix", value);
            return this;
        }

        public APIRequestGetApplications requestUserSupportEmailField() {
            return this.requestUserSupportEmailField(true);
        }

        public APIRequestGetApplications requestUserSupportEmailField(boolean value) {
            this.requestField("user_support_email", value);
            return this;
        }

        public APIRequestGetApplications requestUserSupportUrlField() {
            return this.requestUserSupportUrlField(true);
        }

        public APIRequestGetApplications requestUserSupportUrlField(boolean value) {
            this.requestField("user_support_url", value);
            return this;
        }

        public APIRequestGetApplications requestWebsiteUrlField() {
            return this.requestWebsiteUrlField(true);
        }

        public APIRequestGetApplications requestWebsiteUrlField(boolean value) {
            this.requestField("website_url", value);
            return this;
        }

        public APIRequestGetApplications requestWeeklyActiveUsersField() {
            return this.requestWeeklyActiveUsersField(true);
        }

        public APIRequestGetApplications requestWeeklyActiveUsersField(boolean value) {
            this.requestField("weekly_active_users", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAdsPixels
    extends APIRequest<AdsPixel> {
        APINodeList<AdsPixel> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"automatic_matching_fields", "can_proxy", "code", "creation_time", "creator", "data_use_setting", "enable_automatic_matching", "first_party_cookie_status", "id", "is_created_by_business", "last_fired_time", "name", "owner_ad_account", "owner_business"};

        @Override
        public APINodeList<AdsPixel> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdsPixel> parseResponse(String response, String header) throws APIException {
            return AdsPixel.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdsPixel> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdsPixel> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdsPixel>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdsPixel>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AdsPixel>>(){

                public APINodeList<AdsPixel> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetAdsPixels.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAdsPixels(String nodeId, APIContext context) {
            super(context, nodeId, "/adspixels", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAdsPixels setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAdsPixels setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAdsPixels requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAdsPixels requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdsPixels requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAdsPixels requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdsPixels requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAdsPixels requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAdsPixels requestAutomaticMatchingFieldsField() {
            return this.requestAutomaticMatchingFieldsField(true);
        }

        public APIRequestGetAdsPixels requestAutomaticMatchingFieldsField(boolean value) {
            this.requestField("automatic_matching_fields", value);
            return this;
        }

        public APIRequestGetAdsPixels requestCanProxyField() {
            return this.requestCanProxyField(true);
        }

        public APIRequestGetAdsPixels requestCanProxyField(boolean value) {
            this.requestField("can_proxy", value);
            return this;
        }

        public APIRequestGetAdsPixels requestCodeField() {
            return this.requestCodeField(true);
        }

        public APIRequestGetAdsPixels requestCodeField(boolean value) {
            this.requestField("code", value);
            return this;
        }

        public APIRequestGetAdsPixels requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGetAdsPixels requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGetAdsPixels requestCreatorField() {
            return this.requestCreatorField(true);
        }

        public APIRequestGetAdsPixels requestCreatorField(boolean value) {
            this.requestField("creator", value);
            return this;
        }

        public APIRequestGetAdsPixels requestDataUseSettingField() {
            return this.requestDataUseSettingField(true);
        }

        public APIRequestGetAdsPixels requestDataUseSettingField(boolean value) {
            this.requestField("data_use_setting", value);
            return this;
        }

        public APIRequestGetAdsPixels requestEnableAutomaticMatchingField() {
            return this.requestEnableAutomaticMatchingField(true);
        }

        public APIRequestGetAdsPixels requestEnableAutomaticMatchingField(boolean value) {
            this.requestField("enable_automatic_matching", value);
            return this;
        }

        public APIRequestGetAdsPixels requestFirstPartyCookieStatusField() {
            return this.requestFirstPartyCookieStatusField(true);
        }

        public APIRequestGetAdsPixels requestFirstPartyCookieStatusField(boolean value) {
            this.requestField("first_party_cookie_status", value);
            return this;
        }

        public APIRequestGetAdsPixels requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAdsPixels requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAdsPixels requestIsCreatedByBusinessField() {
            return this.requestIsCreatedByBusinessField(true);
        }

        public APIRequestGetAdsPixels requestIsCreatedByBusinessField(boolean value) {
            this.requestField("is_created_by_business", value);
            return this;
        }

        public APIRequestGetAdsPixels requestLastFiredTimeField() {
            return this.requestLastFiredTimeField(true);
        }

        public APIRequestGetAdsPixels requestLastFiredTimeField(boolean value) {
            this.requestField("last_fired_time", value);
            return this;
        }

        public APIRequestGetAdsPixels requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAdsPixels requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAdsPixels requestOwnerAdAccountField() {
            return this.requestOwnerAdAccountField(true);
        }

        public APIRequestGetAdsPixels requestOwnerAdAccountField(boolean value) {
            this.requestField("owner_ad_account", value);
            return this;
        }

        public APIRequestGetAdsPixels requestOwnerBusinessField() {
            return this.requestOwnerBusinessField(true);
        }

        public APIRequestGetAdsPixels requestOwnerBusinessField(boolean value) {
            this.requestField("owner_business", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAdPlacePageSets
    extends APIRequest<AdPlacePageSet> {
        APINodeList<AdPlacePageSet> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "id", "location_types", "name", "pages_count", "parent_page"};

        @Override
        public APINodeList<AdPlacePageSet> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdPlacePageSet> parseResponse(String response, String header) throws APIException {
            return AdPlacePageSet.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdPlacePageSet> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdPlacePageSet> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdPlacePageSet>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdPlacePageSet>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AdPlacePageSet>>(){

                public APINodeList<AdPlacePageSet> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetAdPlacePageSets.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAdPlacePageSets(String nodeId, APIContext context) {
            super(context, nodeId, "/ad_place_page_sets", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAdPlacePageSets setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAdPlacePageSets setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAdPlacePageSets requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAdPlacePageSets requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdPlacePageSets requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAdPlacePageSets requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdPlacePageSets requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAdPlacePageSets requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAdPlacePageSets requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetAdPlacePageSets requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetAdPlacePageSets requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAdPlacePageSets requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAdPlacePageSets requestLocationTypesField() {
            return this.requestLocationTypesField(true);
        }

        public APIRequestGetAdPlacePageSets requestLocationTypesField(boolean value) {
            this.requestField("location_types", value);
            return this;
        }

        public APIRequestGetAdPlacePageSets requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAdPlacePageSets requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAdPlacePageSets requestPagesCountField() {
            return this.requestPagesCountField(true);
        }

        public APIRequestGetAdPlacePageSets requestPagesCountField(boolean value) {
            this.requestField("pages_count", value);
            return this;
        }

        public APIRequestGetAdPlacePageSets requestParentPageField() {
            return this.requestParentPageField(true);
        }

        public APIRequestGetAdPlacePageSets requestParentPageField(boolean value) {
            this.requestField("parent_page", value);
            return this;
        }
    }
}

