/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoPoll
extends APINode {
    @SerializedName(value="close_after_voting")
    private Boolean mCloseAfterVoting = null;
    @SerializedName(value="default_open")
    private Boolean mDefaultOpen = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="question")
    private String mQuestion = null;
    @SerializedName(value="show_gradient")
    private Boolean mShowGradient = null;
    @SerializedName(value="show_results")
    private Boolean mShowResults = null;
    @SerializedName(value="status")
    private String mStatus = null;
    protected static Gson gson = null;

    VideoPoll() {
    }

    public VideoPoll(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public VideoPoll(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public VideoPoll fetch() throws APIException {
        VideoPoll newInstance = VideoPoll.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static VideoPoll fetchById(Long id, APIContext context) throws APIException {
        return VideoPoll.fetchById(id.toString(), context);
    }

    public static ListenableFuture<VideoPoll> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return VideoPoll.fetchByIdAsync(id.toString(), context);
    }

    public static VideoPoll fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<VideoPoll> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<VideoPoll> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<VideoPoll>(context, "", "/", "GET", VideoPoll.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<VideoPoll>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<VideoPoll>(context, "", "/", "GET", VideoPoll.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static VideoPoll loadJSON(String json, APIContext context, String header) {
        VideoPoll videoPoll = (VideoPoll)VideoPoll.getGson().fromJson(json, VideoPoll.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(videoPoll.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        videoPoll.context = context;
        videoPoll.rawValue = json;
        videoPoll.header = header;
        return videoPoll;
    }

    public static APINodeList<VideoPoll> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<VideoPoll> videoPolls = new APINodeList<VideoPoll>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        videoPolls.add(VideoPoll.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return videoPolls;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            videoPolls.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        videoPolls.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            videoPolls.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            videoPolls.add(VideoPoll.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                videoPolls.add(VideoPoll.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            videoPolls.add(VideoPoll.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return videoPolls;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        videoPolls.add(VideoPoll.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return videoPolls;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        videoPolls.add(VideoPoll.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return videoPolls;
                }
                videoPolls.clear();
                videoPolls.add(VideoPoll.loadJSON(json, context, header));
                return videoPolls;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return VideoPoll.getGson().toJson((Object)this);
    }

    public APIRequestGetPollOptions getPollOptions() {
        return new APIRequestGetPollOptions(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public Boolean getFieldCloseAfterVoting() {
        return this.mCloseAfterVoting;
    }

    public Boolean getFieldDefaultOpen() {
        return this.mDefaultOpen;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldQuestion() {
        return this.mQuestion;
    }

    public Boolean getFieldShowGradient() {
        return this.mShowGradient;
    }

    public Boolean getFieldShowResults() {
        return this.mShowResults;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public VideoPoll copyFrom(VideoPoll instance) {
        this.mCloseAfterVoting = instance.mCloseAfterVoting;
        this.mDefaultOpen = instance.mDefaultOpen;
        this.mId = instance.mId;
        this.mQuestion = instance.mQuestion;
        this.mShowGradient = instance.mShowGradient;
        this.mShowResults = instance.mShowResults;
        this.mStatus = instance.mStatus;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<VideoPoll> getParser() {
        return new APIRequest.ResponseParser<VideoPoll>(){

            @Override
            public APINodeList<VideoPoll> parseResponse(String response, APIContext context, APIRequest<VideoPoll> request, String header) throws APIException.MalformedResponseException {
                return VideoPoll.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumAction {
        VALUE_ATTACH_TO_VIDEO("ATTACH_TO_VIDEO"),
        VALUE_CLOSE("CLOSE"),
        VALUE_DELETE_POLL("DELETE_POLL"),
        VALUE_SHOW_RESULTS("SHOW_RESULTS"),
        VALUE_SHOW_VOTING("SHOW_VOTING"),
        NULL(null);

        private String value;

        private EnumAction(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<VideoPoll> {
        VideoPoll lastResponse = null;
        public static final String[] PARAMS = new String[]{"action", "close_after_voting", "default_open", "show_gradient", "show_results"};
        public static final String[] FIELDS = new String[0];

        @Override
        public VideoPoll getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public VideoPoll parseResponse(String response, String header) throws APIException {
            return VideoPoll.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public VideoPoll execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public VideoPoll execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<VideoPoll> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<VideoPoll> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, VideoPoll>(){

                public VideoPoll apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setAction(EnumAction action) {
            this.setParam("action", (Object)action);
            return this;
        }

        public APIRequestUpdate setAction(String action) {
            this.setParam("action", action);
            return this;
        }

        public APIRequestUpdate setCloseAfterVoting(Boolean closeAfterVoting) {
            this.setParam("close_after_voting", closeAfterVoting);
            return this;
        }

        public APIRequestUpdate setCloseAfterVoting(String closeAfterVoting) {
            this.setParam("close_after_voting", closeAfterVoting);
            return this;
        }

        public APIRequestUpdate setDefaultOpen(Boolean defaultOpen) {
            this.setParam("default_open", defaultOpen);
            return this;
        }

        public APIRequestUpdate setDefaultOpen(String defaultOpen) {
            this.setParam("default_open", defaultOpen);
            return this;
        }

        public APIRequestUpdate setShowGradient(Boolean showGradient) {
            this.setParam("show_gradient", showGradient);
            return this;
        }

        public APIRequestUpdate setShowGradient(String showGradient) {
            this.setParam("show_gradient", showGradient);
            return this;
        }

        public APIRequestUpdate setShowResults(Boolean showResults) {
            this.setParam("show_results", showResults);
            return this;
        }

        public APIRequestUpdate setShowResults(String showResults) {
            this.setParam("show_results", showResults);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<VideoPoll> {
        VideoPoll lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"close_after_voting", "default_open", "id", "question", "show_gradient", "show_results", "status"};

        @Override
        public VideoPoll getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public VideoPoll parseResponse(String response, String header) throws APIException {
            return VideoPoll.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public VideoPoll execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public VideoPoll execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<VideoPoll> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<VideoPoll> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, VideoPoll>(){

                public VideoPoll apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCloseAfterVotingField() {
            return this.requestCloseAfterVotingField(true);
        }

        public APIRequestGet requestCloseAfterVotingField(boolean value) {
            this.requestField("close_after_voting", value);
            return this;
        }

        public APIRequestGet requestDefaultOpenField() {
            return this.requestDefaultOpenField(true);
        }

        public APIRequestGet requestDefaultOpenField(boolean value) {
            this.requestField("default_open", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestQuestionField() {
            return this.requestQuestionField(true);
        }

        public APIRequestGet requestQuestionField(boolean value) {
            this.requestField("question", value);
            return this;
        }

        public APIRequestGet requestShowGradientField() {
            return this.requestShowGradientField(true);
        }

        public APIRequestGet requestShowGradientField(boolean value) {
            this.requestField("show_gradient", value);
            return this;
        }

        public APIRequestGet requestShowResultsField() {
            return this.requestShowResultsField(true);
        }

        public APIRequestGet requestShowResultsField(boolean value) {
            this.requestField("show_results", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetPollOptions
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetPollOptions.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPollOptions(String nodeId, APIContext context) {
            super(context, nodeId, "/poll_options", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPollOptions setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPollOptions setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPollOptions requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPollOptions requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPollOptions requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPollOptions requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPollOptions requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPollOptions requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

