/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdImage
extends APINode {
    @SerializedName(value="account_id")
    private String mAccountId = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="creatives")
    private List<String> mCreatives = null;
    @SerializedName(value="hash")
    private String mHash = null;
    @SerializedName(value="height")
    private Long mHeight = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_associated_creatives_in_adgroups")
    private Boolean mIsAssociatedCreativesInAdgroups = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="original_height")
    private Long mOriginalHeight = null;
    @SerializedName(value="original_width")
    private Long mOriginalWidth = null;
    @SerializedName(value="permalink_url")
    private String mPermalinkUrl = null;
    @SerializedName(value="status")
    private EnumStatus mStatus = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    @SerializedName(value="url")
    private String mUrl = null;
    @SerializedName(value="url_128")
    private String mUrl128 = null;
    @SerializedName(value="width")
    private Long mWidth = null;
    protected static Gson gson = null;

    AdImage() {
    }

    public AdImage(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdImage(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdImage fetch() throws APIException {
        AdImage newInstance = AdImage.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdImage fetchById(Long id, APIContext context) throws APIException {
        return AdImage.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdImage> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdImage.fetchByIdAsync(id.toString(), context);
    }

    public static AdImage fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdImage> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdImage> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdImage>(context, "", "/", "GET", AdImage.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdImage>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdImage>(context, "", "/", "GET", AdImage.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdImage loadJSON(String json, APIContext context, String header) {
        AdImage adImage = (AdImage)AdImage.getGson().fromJson(json, AdImage.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adImage.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adImage.context = context;
        adImage.rawValue = json;
        adImage.header = header;
        return adImage;
    }

    public static APINodeList<AdImage> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdImage> adImages = new APINodeList<AdImage>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adImages.add(AdImage.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adImages;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adImages.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adImages.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adImages.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adImages.add(AdImage.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adImages.add(AdImage.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adImages.add(AdImage.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adImages;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adImages.add(AdImage.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adImages;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adImages.add(AdImage.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adImages;
                }
                adImages.clear();
                adImages.add(AdImage.loadJSON(json, context, header));
                return adImages;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdImage.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAccountId() {
        return this.mAccountId;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public List<String> getFieldCreatives() {
        return this.mCreatives;
    }

    public String getFieldHash() {
        return this.mHash;
    }

    public Long getFieldHeight() {
        return this.mHeight;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsAssociatedCreativesInAdgroups() {
        return this.mIsAssociatedCreativesInAdgroups;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Long getFieldOriginalHeight() {
        return this.mOriginalHeight;
    }

    public Long getFieldOriginalWidth() {
        return this.mOriginalWidth;
    }

    public String getFieldPermalinkUrl() {
        return this.mPermalinkUrl;
    }

    public EnumStatus getFieldStatus() {
        return this.mStatus;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    public String getFieldUrl128() {
        return this.mUrl128;
    }

    public Long getFieldWidth() {
        return this.mWidth;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdImage copyFrom(AdImage instance) {
        this.mAccountId = instance.mAccountId;
        this.mCreatedTime = instance.mCreatedTime;
        this.mCreatives = instance.mCreatives;
        this.mHash = instance.mHash;
        this.mHeight = instance.mHeight;
        this.mId = instance.mId;
        this.mIsAssociatedCreativesInAdgroups = instance.mIsAssociatedCreativesInAdgroups;
        this.mName = instance.mName;
        this.mOriginalHeight = instance.mOriginalHeight;
        this.mOriginalWidth = instance.mOriginalWidth;
        this.mPermalinkUrl = instance.mPermalinkUrl;
        this.mStatus = instance.mStatus;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.mUrl = instance.mUrl;
        this.mUrl128 = instance.mUrl128;
        this.mWidth = instance.mWidth;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdImage> getParser() {
        return new APIRequest.ResponseParser<AdImage>(){

            @Override
            public APINodeList<AdImage> parseResponse(String response, APIContext context, APIRequest<AdImage> request, String header) throws APIException.MalformedResponseException {
                return AdImage.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumStatus {
        VALUE_ACTIVE("ACTIVE"),
        VALUE_DELETED("DELETED");

        private String value;

        private EnumStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdImage> {
        AdImage lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "created_time", "creatives", "hash", "height", "id", "is_associated_creatives_in_adgroups", "name", "original_height", "original_width", "permalink_url", "status", "updated_time", "url", "url_128", "width"};

        @Override
        public AdImage getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdImage parseResponse(String response, String header) throws APIException {
            return AdImage.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdImage execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdImage execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdImage> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdImage> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdImage>(){

                public AdImage apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGet requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestCreativesField() {
            return this.requestCreativesField(true);
        }

        public APIRequestGet requestCreativesField(boolean value) {
            this.requestField("creatives", value);
            return this;
        }

        public APIRequestGet requestHashField() {
            return this.requestHashField(true);
        }

        public APIRequestGet requestHashField(boolean value) {
            this.requestField("hash", value);
            return this;
        }

        public APIRequestGet requestHeightField() {
            return this.requestHeightField(true);
        }

        public APIRequestGet requestHeightField(boolean value) {
            this.requestField("height", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsAssociatedCreativesInAdgroupsField() {
            return this.requestIsAssociatedCreativesInAdgroupsField(true);
        }

        public APIRequestGet requestIsAssociatedCreativesInAdgroupsField(boolean value) {
            this.requestField("is_associated_creatives_in_adgroups", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestOriginalHeightField() {
            return this.requestOriginalHeightField(true);
        }

        public APIRequestGet requestOriginalHeightField(boolean value) {
            this.requestField("original_height", value);
            return this;
        }

        public APIRequestGet requestOriginalWidthField() {
            return this.requestOriginalWidthField(true);
        }

        public APIRequestGet requestOriginalWidthField(boolean value) {
            this.requestField("original_width", value);
            return this;
        }

        public APIRequestGet requestPermalinkUrlField() {
            return this.requestPermalinkUrlField(true);
        }

        public APIRequestGet requestPermalinkUrlField(boolean value) {
            this.requestField("permalink_url", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGet requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGet requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }

        public APIRequestGet requestUrl128Field() {
            return this.requestUrl128Field(true);
        }

        public APIRequestGet requestUrl128Field(boolean value) {
            this.requestField("url_128", value);
            return this;
        }

        public APIRequestGet requestWidthField() {
            return this.requestWidthField(true);
        }

        public APIRequestGet requestWidthField(boolean value) {
            this.requestField("width", value);
            return this;
        }
    }
}

