/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.CustomAudience;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudiencePermission
extends APINode {
    @SerializedName(value="audience")
    private CustomAudience mAudience = null;
    @SerializedName(value="share_account_id")
    private String mShareAccountId = null;
    @SerializedName(value="share_account_name")
    private String mShareAccountName = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AudiencePermission loadJSON(String json, APIContext context, String header) {
        AudiencePermission audiencePermission = (AudiencePermission)AudiencePermission.getGson().fromJson(json, AudiencePermission.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(audiencePermission.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        audiencePermission.context = context;
        audiencePermission.rawValue = json;
        audiencePermission.header = header;
        return audiencePermission;
    }

    public static APINodeList<AudiencePermission> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AudiencePermission> audiencePermissions = new APINodeList<AudiencePermission>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        audiencePermissions.add(AudiencePermission.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return audiencePermissions;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            audiencePermissions.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        audiencePermissions.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            audiencePermissions.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            audiencePermissions.add(AudiencePermission.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                audiencePermissions.add(AudiencePermission.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            audiencePermissions.add(AudiencePermission.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return audiencePermissions;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        audiencePermissions.add(AudiencePermission.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return audiencePermissions;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        audiencePermissions.add(AudiencePermission.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return audiencePermissions;
                }
                audiencePermissions.clear();
                audiencePermissions.add(AudiencePermission.loadJSON(json, context, header));
                return audiencePermissions;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AudiencePermission.getGson().toJson((Object)this);
    }

    public CustomAudience getFieldAudience() {
        if (this.mAudience != null) {
            this.mAudience.context = this.getContext();
        }
        return this.mAudience;
    }

    public AudiencePermission setFieldAudience(CustomAudience value) {
        this.mAudience = value;
        return this;
    }

    public AudiencePermission setFieldAudience(String value) {
        Type type = new TypeToken<CustomAudience>(){}.getType();
        this.mAudience = (CustomAudience)CustomAudience.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldShareAccountId() {
        return this.mShareAccountId;
    }

    public AudiencePermission setFieldShareAccountId(String value) {
        this.mShareAccountId = value;
        return this;
    }

    public String getFieldShareAccountName() {
        return this.mShareAccountName;
    }

    public AudiencePermission setFieldShareAccountName(String value) {
        this.mShareAccountName = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AudiencePermission copyFrom(AudiencePermission instance) {
        this.mAudience = instance.mAudience;
        this.mShareAccountId = instance.mShareAccountId;
        this.mShareAccountName = instance.mShareAccountName;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AudiencePermission> getParser() {
        return new APIRequest.ResponseParser<AudiencePermission>(){

            @Override
            public APINodeList<AudiencePermission> parseResponse(String response, APIContext context, APIRequest<AudiencePermission> request, String header) throws APIException.MalformedResponseException {
                return AudiencePermission.parseResponse(response, context, request, header);
            }
        };
    }
}

