/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.VideoCopyrightRule;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioCopyright
extends APINode {
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="displayed_matches_count")
    private Long mDisplayedMatchesCount = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="in_conflict")
    private Boolean mInConflict = null;
    @SerializedName(value="isrc")
    private String mIsrc = null;
    @SerializedName(value="match_rule")
    private VideoCopyrightRule mMatchRule = null;
    @SerializedName(value="ownership_countries")
    private List<String> mOwnershipCountries = null;
    @SerializedName(value="reference_file_status")
    private String mReferenceFileStatus = null;
    @SerializedName(value="ridge_monitoring_status")
    private String mRidgeMonitoringStatus = null;
    @SerializedName(value="update_time")
    private String mUpdateTime = null;
    @SerializedName(value="whitelisted_fb_users")
    private List<Object> mWhitelistedFbUsers = null;
    @SerializedName(value="whitelisted_ig_users")
    private List<String> mWhitelistedIgUsers = null;
    protected static Gson gson = null;

    AudioCopyright() {
    }

    public AudioCopyright(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AudioCopyright(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AudioCopyright fetch() throws APIException {
        AudioCopyright newInstance = AudioCopyright.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AudioCopyright fetchById(Long id, APIContext context) throws APIException {
        return AudioCopyright.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AudioCopyright> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AudioCopyright.fetchByIdAsync(id.toString(), context);
    }

    public static AudioCopyright fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AudioCopyright> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AudioCopyright> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AudioCopyright>(context, "", "/", "GET", AudioCopyright.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AudioCopyright>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AudioCopyright>(context, "", "/", "GET", AudioCopyright.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AudioCopyright loadJSON(String json, APIContext context, String header) {
        AudioCopyright audioCopyright = (AudioCopyright)AudioCopyright.getGson().fromJson(json, AudioCopyright.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(audioCopyright.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        audioCopyright.context = context;
        audioCopyright.rawValue = json;
        audioCopyright.header = header;
        return audioCopyright;
    }

    public static APINodeList<AudioCopyright> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AudioCopyright> audioCopyrights = new APINodeList<AudioCopyright>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        audioCopyrights.add(AudioCopyright.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return audioCopyrights;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            audioCopyrights.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        audioCopyrights.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            audioCopyrights.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            audioCopyrights.add(AudioCopyright.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                audioCopyrights.add(AudioCopyright.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            audioCopyrights.add(AudioCopyright.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return audioCopyrights;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        audioCopyrights.add(AudioCopyright.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return audioCopyrights;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        audioCopyrights.add(AudioCopyright.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return audioCopyrights;
                }
                audioCopyrights.clear();
                audioCopyrights.add(AudioCopyright.loadJSON(json, context, header));
                return audioCopyrights;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AudioCopyright.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public Long getFieldDisplayedMatchesCount() {
        return this.mDisplayedMatchesCount;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldInConflict() {
        return this.mInConflict;
    }

    public String getFieldIsrc() {
        return this.mIsrc;
    }

    public VideoCopyrightRule getFieldMatchRule() {
        if (this.mMatchRule != null) {
            this.mMatchRule.context = this.getContext();
        }
        return this.mMatchRule;
    }

    public List<String> getFieldOwnershipCountries() {
        return this.mOwnershipCountries;
    }

    public String getFieldReferenceFileStatus() {
        return this.mReferenceFileStatus;
    }

    public String getFieldRidgeMonitoringStatus() {
        return this.mRidgeMonitoringStatus;
    }

    public String getFieldUpdateTime() {
        return this.mUpdateTime;
    }

    public List<Object> getFieldWhitelistedFbUsers() {
        return this.mWhitelistedFbUsers;
    }

    public List<String> getFieldWhitelistedIgUsers() {
        return this.mWhitelistedIgUsers;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AudioCopyright copyFrom(AudioCopyright instance) {
        this.mCreationTime = instance.mCreationTime;
        this.mDisplayedMatchesCount = instance.mDisplayedMatchesCount;
        this.mId = instance.mId;
        this.mInConflict = instance.mInConflict;
        this.mIsrc = instance.mIsrc;
        this.mMatchRule = instance.mMatchRule;
        this.mOwnershipCountries = instance.mOwnershipCountries;
        this.mReferenceFileStatus = instance.mReferenceFileStatus;
        this.mRidgeMonitoringStatus = instance.mRidgeMonitoringStatus;
        this.mUpdateTime = instance.mUpdateTime;
        this.mWhitelistedFbUsers = instance.mWhitelistedFbUsers;
        this.mWhitelistedIgUsers = instance.mWhitelistedIgUsers;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AudioCopyright> getParser() {
        return new APIRequest.ResponseParser<AudioCopyright>(){

            @Override
            public APINodeList<AudioCopyright> parseResponse(String response, APIContext context, APIRequest<AudioCopyright> request, String header) throws APIException.MalformedResponseException {
                return AudioCopyright.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AudioCopyright> {
        AudioCopyright lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"creation_time", "displayed_matches_count", "id", "in_conflict", "isrc", "match_rule", "ownership_countries", "reference_file_status", "ridge_monitoring_status", "update_time", "whitelisted_fb_users", "whitelisted_ig_users"};

        @Override
        public AudioCopyright getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AudioCopyright parseResponse(String response, String header) throws APIException {
            return AudioCopyright.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AudioCopyright execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AudioCopyright execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AudioCopyright> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AudioCopyright> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AudioCopyright>(){

                public AudioCopyright apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestDisplayedMatchesCountField() {
            return this.requestDisplayedMatchesCountField(true);
        }

        public APIRequestGet requestDisplayedMatchesCountField(boolean value) {
            this.requestField("displayed_matches_count", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestInConflictField() {
            return this.requestInConflictField(true);
        }

        public APIRequestGet requestInConflictField(boolean value) {
            this.requestField("in_conflict", value);
            return this;
        }

        public APIRequestGet requestIsrcField() {
            return this.requestIsrcField(true);
        }

        public APIRequestGet requestIsrcField(boolean value) {
            this.requestField("isrc", value);
            return this;
        }

        public APIRequestGet requestMatchRuleField() {
            return this.requestMatchRuleField(true);
        }

        public APIRequestGet requestMatchRuleField(boolean value) {
            this.requestField("match_rule", value);
            return this;
        }

        public APIRequestGet requestOwnershipCountriesField() {
            return this.requestOwnershipCountriesField(true);
        }

        public APIRequestGet requestOwnershipCountriesField(boolean value) {
            this.requestField("ownership_countries", value);
            return this;
        }

        public APIRequestGet requestReferenceFileStatusField() {
            return this.requestReferenceFileStatusField(true);
        }

        public APIRequestGet requestReferenceFileStatusField(boolean value) {
            this.requestField("reference_file_status", value);
            return this;
        }

        public APIRequestGet requestRidgeMonitoringStatusField() {
            return this.requestRidgeMonitoringStatusField(true);
        }

        public APIRequestGet requestRidgeMonitoringStatusField(boolean value) {
            this.requestField("ridge_monitoring_status", value);
            return this;
        }

        public APIRequestGet requestUpdateTimeField() {
            return this.requestUpdateTimeField(true);
        }

        public APIRequestGet requestUpdateTimeField(boolean value) {
            this.requestField("update_time", value);
            return this;
        }

        public APIRequestGet requestWhitelistedFbUsersField() {
            return this.requestWhitelistedFbUsersField(true);
        }

        public APIRequestGet requestWhitelistedFbUsersField(boolean value) {
            this.requestField("whitelisted_fb_users", value);
            return this;
        }

        public APIRequestGet requestWhitelistedIgUsersField() {
            return this.requestWhitelistedIgUsersField(true);
        }

        public APIRequestGet requestWhitelistedIgUsersField(boolean value) {
            this.requestField("whitelisted_ig_users", value);
            return this;
        }
    }
}

